/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin.bookmark;

import cds.aladin.Aladin;
import cds.aladin.Chaine;
import cds.aladin.Function;
import cds.aladin.bookmark.Bookmarks;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class FrameBookmarks
extends JFrame {
    private Aladin aladin;
    private Bookmarks bookmarks;
    private boolean expertMode = false;
    private JPanel expertPanel = null;
    private JPanel amateurPanel = null;
    private JTextArea edit;
    private Function fctEdit = null;
    private JButton apply;
    private JButton delete;
    private JPanel genPanel = null;
    static final int BKM = 0;
    static final int LOC = 1;
    static final int NAME = 2;
    static final int DESC = 3;
    private JTable table;
    private BookmarkTable tableModel;

    public FrameBookmarks(Aladin aladin, Bookmarks bookmarks) {
        this.aladin = aladin;
        this.bookmarks = bookmarks;
        Aladin.setIcon(this);
        this.setTitle(aladin.getChaine().getString("BKMTITLE"));
        this.enableEvents(64L);
        Util.setCloseShortcut(this, false, aladin);
    }

    private Function addBookmark(String name, String param, String description, String code) {
        Function f = new Function(name, param, code, description);
        f.setBookmark(true);
        this.aladin.getCommand().addFunction(f);
        return f;
    }

    @Override
    public void show() {
        if (this.genPanel == null) {
            this.createPanel();
            this.pack();
        }
        super.show();
    }

    private void createPanel() {
        this.genPanel = (JPanel)this.getContentPane();
        this.genPanel.setLayout(new BorderLayout(5, 5));
        this.genPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.genPanel.add((Component)this.getBookmarksPanel(), "North");
        this.genPanel.add((Component)this.getAmateurPanel(), "South");
        this.getExpertPanel();
    }

    private JPanel getExpertPanel() {
        if (this.expertPanel != null) {
            return this.expertPanel;
        }
        JPanel p = this.expertPanel = new JPanel(new BorderLayout(5, 5));
        p.add((Component)this.getEditPanel(), "Center");
        p.add((Component)this.getControlPanel(), "South");
        return p;
    }

    private JPanel getAmateurPanel() {
        if (this.amateurPanel != null) {
            return this.amateurPanel;
        }
        JPanel p = this.amateurPanel = new JPanel();
        FrameBookmarks frameBookmarks = this;
        Chaine chaine = frameBookmarks.aladin.getChaine();
        JButton b = new JButton(chaine.getString("EXEC"));
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameBookmarks.this.execute();
            }
        });
        b = new JButton(chaine.getString("BKMEDITOR"));
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameBookmarks.this.genPanel.remove(FrameBookmarks.this.amateurPanel);
                FrameBookmarks.this.genPanel.add((Component)FrameBookmarks.this.getExpertPanel(), "Center");
                FrameBookmarks.this.expertMode = true;
                FrameBookmarks.this.pack();
            }
        });
        b = new JButton(chaine.getString("PROPCLOSE"));
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameBookmarks.this.dispose();
            }
        });
        p.add(Util.getHelpButton(this, chaine.getString("BKMHELP")));
        return p;
    }

    public void setVisibleEdit() {
        if (this.genPanel == null) {
            this.createPanel();
        }
        this.genPanel.remove(this.amateurPanel);
        this.genPanel.add((Component)this.getExpertPanel(), "Center");
        this.expertMode = true;
        this.pack();
        this.setVisible(true);
    }

    protected JPanel getEditPanel() {
        JPanel p = new JPanel(new BorderLayout());
        this.edit = new JTextArea(8, 50);
        this.edit.setFont(Aladin.COURIER);
        this.edit.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                FrameBookmarks.this.apply.setEnabled(FrameBookmarks.this.isModif());
            }
        });
        JScrollPane sc = new JScrollPane(this.edit);
        p.add((Component)sc, "Center");
        return p;
    }

    private void resumeEdit(Function f, boolean valid) {
        if (valid) {
            this.valide(true);
        }
        this.fctEdit = f;
        boolean local = f == null ? false : f.isLocalDefinition();
        this.edit.setText(f == null ? "" : f.toString());
        this.edit.setEditable(local);
        this.delete.setEnabled(local);
        this.apply.setEnabled(this.isModif());
    }

    private boolean isModif() {
        if (this.fctEdit == null) {
            return false;
        }
        if (!this.fctEdit.isLocalDefinition()) {
            return false;
        }
        return !this.fctEdit.toString().trim().equals(this.edit.getText().trim());
    }

    private void valide(boolean flagTest) {
        block7: {
            block6: {
                if (!this.isModif()) {
                    return;
                }
                if (!flagTest) break block6;
                FrameBookmarks frameBookmarks = this;
                if (!Aladin.confirmation(this, frameBookmarks.aladin.getChaine().getString("BKMAPPLY"))) break block7;
            }
            try {
                Function t = new Function(this.edit.getText());
                this.fctEdit.setDescription(t.getDescription());
                this.fctEdit.setName(t.getName());
                this.fctEdit.setParam(t.getParam());
                this.fctEdit.setCode(t.getCode());
                this.fctEdit.setLocalDefinition(true);
                this.edit.setText(this.fctEdit.toString());
                this.resumeTable();
                this.bookmarks.resumeToolBar();
                this.aladin.log("Bookmark", "create");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void execute() {
        try {
            Function f;
            if (!this.isModif()) {
                int row = this.table.getSelectedRow();
                f = this.aladin.getCommand().getFunction(row);
            } else {
                f = new Function(this.edit.getText());
            }
            f.exec(this.aladin, "", true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private JPanel getControlPanel() {
        JPanel p = new JPanel();
        FrameBookmarks frameBookmarks = this;
        Chaine chaine = frameBookmarks.aladin.getChaine();
        JButton b = new JButton(chaine.getString("PROPNEWCALIB"));
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameBookmarks.this.createNewBookmark();
            }
        });
        b = this.delete = new JButton(chaine.getString("SLMDEL"));
        p.add(this.delete);
        b.setEnabled(false);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameBookmarks.this.deleteBookmark();
            }
        });
        b = new JButton(chaine.getString("BKMDEFAULT"));
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameBookmarks.this.resetBookmarks(true);
            }
        });
        p.add(new JLabel(" - "));
        b = new JButton(chaine.getString("EXEC"));
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameBookmarks.this.execute();
            }
        });
        b = this.apply = new JButton(chaine.getString("PROPAPPLY"));
        p.add(this.apply);
        b.setEnabled(false);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameBookmarks.this.valide(false);
            }
        });
        b = new JButton(chaine.getString("PROPCLOSE"));
        p.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameBookmarks.this.dispose();
            }
        });
        return p;
    }

    private void createNewBookmark() {
        this.createNewBookmark("YourName", "$TARGET,$RADIUS", "Your description", null);
    }

    public void createNewBookmark(String name, String param, String description, String code) {
        Function f = this.addBookmark(name, param, description, code);
        this.aladin.getCommand().addFunction(f);
        this.resumeEdit(f, true);
        if (code != null) {
            this.fctEdit.setCode(null);
            this.valide(false);
        }
        this.resumeTable();
        int row = this.table.getRowCount() - 1;
        this.table.scrollRectToVisible(this.table.getCellRect(row, 2, true));
        this.table.setRowSelectionInterval(row, row);
    }

    private void deleteBookmark() {
        int row = this.table.getSelectedRow();
        Function f = this.aladin.getCommand().getFunction(row);
        this.aladin.getCommand().removeFunction(f);
        this.resumeTable();
        this.bookmarks.resumeToolBar();
        this.resumeEdit(null, false);
    }

    protected void resetBookmarks(boolean withConfirmation) {
        if (withConfirmation) {
            FrameBookmarks frameBookmarks = this;
            if (!Aladin.confirmation(this, frameBookmarks.aladin.getChaine().getString("BKMCONFIRM"))) {
                return;
            }
        }
        this.bookmarks.reload();
        this.resumeTable();
        this.resumeEdit(null, false);
    }

    @Override
    public void dispose() {
        if (this.expertMode) {
            this.genPanel.remove(this.expertPanel);
            this.genPanel.add((Component)this.getAmateurPanel(), "South");
            this.pack();
            this.expertMode = false;
        }
        this.setVisible(false);
    }

    protected JPanel getBookmarksPanel() {
        JPanel p = new JPanel(new BorderLayout());
        JScrollPane sc = new JScrollPane(this.createBookmarksTable());
        p.add((Component)sc, "Center");
        return p;
    }

    private void resumeTable() {
        this.tableModel.fireTableDataChanged();
    }

    private JTable createBookmarksTable() {
        this.tableModel = new BookmarkTable();
        this.table = new JTable(this.tableModel);
        this.table.setSelectionMode(0);
        this.table.getColumnModel().getColumn(1).setMinWidth(20);
        this.table.getColumnModel().getColumn(1).setMaxWidth(20);
        this.table.getColumnModel().getColumn(0).setMinWidth(60);
        this.table.getColumnModel().getColumn(0).setMaxWidth(60);
        this.table.getColumnModel().getColumn(2).setMinWidth(70);
        this.table.getColumnModel().getColumn(2).setMaxWidth(70);
        this.table.setPreferredScrollableViewportSize(new Dimension(420, 456));
        MyRenderer cr = new MyRenderer();
        this.table.getColumnModel().getColumn(1).setCellRenderer(cr);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int row = FrameBookmarks.this.table.rowAtPoint(e.getPoint());
                Function f = FrameBookmarks.this.aladin.getCommand().getFunction(row);
                if (FrameBookmarks.this.delete != null) {
                    FrameBookmarks.this.delete.setEnabled(true);
                }
                FrameBookmarks.this.resumeEdit(f, true);
            }
        });
        return this.table;
    }

    private LabelIcon getIcon(Function f) {
        return new LabelIcon(f);
    }

    class LabelIcon
    extends JLabel {
        Function f;

        LabelIcon() {
        }

        LabelIcon(Function f) {
            this.f = f;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Util.drawSignet(g, 6, 7, this.f.isLocalDefinition() ? Aladin.COLOR_BLUE : Aladin.COLOR_GREEN_LIGHT);
        }
    }

    class MyRenderer
    extends DefaultTableCellRenderer {
        MyRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return (Component)value;
        }
    }

    class BookmarkTable
    extends AbstractTableModel {
        BookmarkTable() {
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return FrameBookmarks.this.aladin.getCommand().getNbFunctions();
        }

        @Override
        public String getColumnName(int col) {
            return col == 1 ? "" : (col == 0 ? "Bookmark" : (col == 2 ? "Name" : "Description"));
        }

        public Class getColumnClass(int col) {
            if (col == 1) {
                return new LabelIcon().getClass();
            }
            if (col == 0) {
                return new Boolean(true).getClass();
            }
            return super.getColumnClass(col);
        }

        @Override
        public Object getValueAt(int row, int col) {
            Function f = FrameBookmarks.this.aladin.getCommand().getFunction(row);
            switch (col) {
                case 1: {
                    return FrameBookmarks.this.getIcon(f);
                }
                case 0: {
                    return new Boolean(f.isBookmark());
                }
                case 2: {
                    return f.getName();
                }
            }
            return f.getDescription();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (col == 0) {
                return true;
            }
            Function f = FrameBookmarks.this.aladin.getCommand().getFunction(row);
            return f.isLocalDefinition();
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Function f = FrameBookmarks.this.aladin.getCommand().getFunction(row);
            if (col == 0) {
                f.setBookmark(!f.isBookmark());
                FrameBookmarks.this.bookmarks.resumeToolBar();
            } else if (col == 2 || col == 3) {
                if (col == 2) {
                    f.setName((String)value);
                } else {
                    f.setDescription((String)value);
                }
                f.setLocalDefinition(true);
                FrameBookmarks.this.resumeEdit(f, false);
                FrameBookmarks.this.bookmarks.resumeToolBar();
            }
        }
    }
}

