/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin.bookmark;

import cds.aladin.Aladin;
import cds.aladin.Function;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;

public class ButtonBookmark
extends JButton {
    private Aladin aladin;
    private Function fct;
    public static final Color Orange = new Color(255, 175, 0);

    public ButtonBookmark(Aladin aladin, String name, String descr, String code) {
        this.aladin = aladin;
        this.fct = new Function(name, null, code, descr);
        this.suite();
    }

    public ButtonBookmark(Aladin aladin, Function fonction) {
        this.aladin = aladin;
        this.fct = fonction;
        this.suite();
    }

    private void suite() {
        this.setFont(Aladin.SBOLD);
        this.setForeground(Aladin.COLOR_LABEL);
        this.setBackground(this.aladin.getBackground());
        this.setBorder(BorderFactory.createEmptyBorder(1, 10, 1, 5));
        this.setToolTipText("<html><b>" + Util.fold(this.fct.getDescription(), 20) + "</b>" + "<br><i>" + this.fct.getCode().replaceAll(";", "<br>").replaceAll("\n", "<br>") + "</i>" + "</html>");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonBookmark.this.exec();
            }
        });
    }

    public Function getFunction() {
        return this.fct;
    }

    @Override
    public String getText() {
        return this.fct == null ? "X" : this.fct.getName();
    }

    private void exec() {
        try {
            this.fct.exec(this.aladin, "", true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Util.drawSignet(g, 5, 8, this.fct.isLocalDefinition() ? Aladin.COLOR_BLUE : Aladin.COLOR_GREEN_LIGHT);
    }
}

