/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.Cote;
import cds.aladin.Ligne;
import cds.aladin.Obj;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageCube;
import cds.aladin.PlanImageRGB;
import cds.aladin.PlanRGBInterface;
import cds.aladin.PointD;
import cds.aladin.Projection;
import cds.aladin.RectangleD;
import cds.aladin.Repere;
import cds.aladin.RepereSpectrum;
import cds.aladin.SED;
import cds.aladin.Source;
import cds.aladin.SourceStat;
import cds.aladin.TargetHistory;
import cds.aladin.Tool;
import cds.aladin.ViewSimple;
import cds.aladin.Widget;
import cds.aladin.WidgetControl;
import cds.aladin.ZoomHist;
import cds.aladin.ZoomTime;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ZoomView
extends JComponent
implements MouseWheelListener,
MouseListener,
MouseMotionListener,
Widget {
    protected int WENZOOM = 8;
    Aladin aladin;
    Image img;
    Image imgwen;
    MemoryImageSource mImgWen;
    Graphics gwen;
    Image imgbuf;
    Graphics gbuf;
    int lastImgID = -1;
    RectangleD rectzoom;
    RectangleD or;
    boolean flagdrag;
    boolean imgok;
    Rectangle clip;
    int W;
    int H;
    double xwen;
    double ywen;
    private PointD oc;
    private int oframe;
    boolean zoomok;
    int xmwen;
    int ymwen;
    int xWenrect;
    int yWenrect;
    boolean memInv;
    boolean flagRGB;
    boolean flagwen;
    private int[] cut;
    private int[] cutR;
    private int[] cutG;
    private int[] cutB;
    protected boolean flagCut = false;
    private Obj objCut;
    ZoomTime zoomTime;
    ZoomHist hist = null;
    SED sed = null;
    protected boolean flagHist = false;
    protected boolean flagSED = false;
    private boolean flagTargetControl = false;
    private boolean flagSynchronized = false;
    private static Color BGD;
    private int cutX = -1;
    private int cutY = -1;
    private String INFO = null;
    private String TIPTARGET = null;
    private String TIPLISTTARGET = null;
    private String TIPSTORETARGET = null;
    private static int DELTAYWITHTIME;
    private int ov = 0;
    private short oiz = (short)-2;
    private Projection proj = null;
    private int lastHipsWidth = 0;
    private int lastHiPSHeight = 0;
    int deltaY = 0;
    private Rectangle rectLoc = null;
    private Rectangle rectHistory = null;
    private Rectangle rectTarget = null;
    private boolean flagHistoryIn = false;
    private boolean flagTargetHistoryIn = false;
    private boolean flagLocHistoryIn = false;
    private static final int[][] LOCX;
    static final int CUTNORMAL = 0;
    static final int CUTRGB = 1;
    static final int CUTHIST = 2;
    private String oSrcSed = "";
    private byte[] pixels = null;
    private byte[] scalepixels = null;
    private int[] pixelsRGB = null;
    private int[] scalepixelsRGB = null;
    private static int WF;
    static int[] XF;
    static int[] YF;
    private int owidth;
    private int oheight;
    private int lastWidth = 0;
    private int lastHeight = 0;
    private WidgetControl voc = null;

    protected ZoomView(Aladin aladin) {
        this.aladin = aladin;
        this.setOpaque(true);
        this.setBackground(Aladin.BLUE);
        BGD = Aladin.COLOR_BACKGROUND;
        this.addMouseWheelListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.WENZOOM = 8;
    }

    protected void setZoomTime(ZoomTime zoomTime) {
        this.zoomTime = zoomTime;
    }

    protected ZoomView() {
    }

    private void resumeSize() {
        int w = this.getWidth();
        if (this.cut != null && this.cut.length == w) {
            return;
        }
        this.cut = new int[w];
        this.cutR = new int[w];
        this.cutG = new int[w];
        this.cutB = new int[w];
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.aladin.inHelp) {
            return;
        }
        if (e.getClickCount() == 2) {
            return;
        }
        if (this.flagSED) {
            if (this.sed.mouseWheel(e)) {
                this.repaint();
            }
            return;
        }
        if (this.flagHist) {
            if (this.hist.mouseWheelMoved(e)) {
                this.repaint();
            }
            return;
        }
        if (this.flagCut && this.objCut instanceof Repere) {
            ViewSimple vc = this.aladin.view.getCurrentView();
            vc.cubeControl.incFrame(-e.getWheelRotation());
            this.aladin.calque.repaintAll();
            return;
        }
        if (this.zoomTime.mouseWheelMoved(e, this.aladin.view.getCurrentView())) {
            this.synchronizeTime(e);
            return;
        }
        this.synchronize(e);
        this.aladin.calque.zoom.incZoom(-e.getWheelRotation());
    }

    protected void free() {
        this.hist = null;
        this.sed = null;
        this.flagSED = false;
        this.flagHist = false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    private void memoLoc() {
        this.aladin.targetHistory.add(this.aladin.localisation.getLocalisation(this.aladin.view.repere));
    }

    protected void triangleAction(int x, int y) {
        this.triangleAction(x, y, 0);
    }

    protected void triangleAction(final int x, final int y, int initIndex) {
        int max = 20;
        ArrayList<String> v = this.aladin.targetHistory.getTargets(initIndex, max);
        if (v.size() == 0) {
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        for (String s : v) {
            JMenuItem mi = null;
            if (s.equals("...")) {
                mi = new JMenuItem(s);
                mi.setActionCommand("" + (initIndex + max));
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            int index = Integer.parseInt(((JMenuItem)e.getSource()).getActionCommand());
                            ZoomView.this.triangleAction(x, y, index);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            } else {
                mi = new JMenuItemExt(s.length() > 40 ? s.substring(0, 38) + " ..." : s);
                mi.setActionCommand(TargetHistory.getTarget(s));
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        String s = ((JMenuItem)e.getSource()).getActionCommand();
                        ZoomView.this.aladin.command.execNow(s);
                    }
                });
            }
            popup.add(mi);
        }
        if (this.aladin.isFullScreen()) {
            JComponent c = (JComponent)this.aladin.fullScreen.getContentPane();
            c.setComponentPopupMenu(popup);
            WidgetControl wc = this.getWidgetControl();
            popup.show(c, wc.getX() + x, wc.getY() + y);
        } else {
            this.setComponentPopupMenu(popup);
            popup.show(this, x, y);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        boolean doubleClick;
        if (this.aladin.inHelp) {
            return;
        }
        if (this.flagCut || this.flagHist || this.flagSED) {
            return;
        }
        if (this.rectHistory != null && this.flagTargetControl) {
            if (this.rectTarget.contains(e.getPoint())) {
                this.aladin.command.execNow(this.aladin.targetHistory.getLast());
            } else if (this.rectHistory.contains(e.getPoint())) {
                this.triangleAction(e.getX(), e.getY());
            } else if (this.rectLoc.contains(e.getPoint())) {
                this.memoLoc();
                this.repaint();
            }
            return;
        }
        ViewSimple v = this.aladin.view.getCurrentView();
        v.stopAutomaticScroll();
        boolean bl = doubleClick = e.getClickCount() >= 2;
        if (this.zoomTime.mousePress(e.getX(), e.getY(), v, doubleClick)) {
            this.synchronizeTime(e);
            return;
        }
        this.or = null;
        if (!v.isFree() && v.pref instanceof PlanBG) {
            this.setAllSkyCenter(v, e.getX(), e.getY() + this.deltaY);
        } else {
            this.flagdrag = true;
            this.newZoom(e.getX(), e.getY() + this.deltaY);
            this.synchronize(e);
        }
    }

    protected void synchronize(MouseEvent e) {
        if (e.isShiftDown() && this.flagSynchronized || !this.aladin.view.isMultiView()) {
            return;
        }
        ViewSimple vc = this.aladin.view.getCurrentView();
        if (vc == null || vc.isFree() || !Projection.isOk(vc.pref.projd)) {
            return;
        }
        if (e.isShiftDown()) {
            this.aladin.view.selectCompatibleViews();
            this.aladin.view.setZoomRaDecForSelectedViews(this.aladin.calque.zoom.getValue(), null);
            this.flagSynchronized = true;
        } else {
            this.flagSynchronized = false;
        }
    }

    protected void synchronizeTime(MouseEvent e) {
        if (!e.isShiftDown() && !this.aladin.view.isMultiView()) {
            return;
        }
        ViewSimple vc = this.aladin.view.getCurrentView();
        if (vc == null || vc.isFree() || !Projection.isOk(vc.pref.projd)) {
            return;
        }
        if (e.isShiftDown()) {
            this.aladin.view.selectCompatibleViews();
        }
        this.aladin.view.syncTimeRange(vc);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.aladin.inHelp) {
            return;
        }
        if (this.flagSED) {
            return;
        }
        if (this.flagHist) {
            if (this.hist.mouseDragged(e)) {
                this.repaint();
            }
            return;
        }
        if (this.flagCut) {
            if (this.objCut instanceof RepereSpectrum) {
                this.setFrameCube(e.getX());
            }
            return;
        }
        ViewSimple v = this.aladin.view.getCurrentView();
        if (this.zoomTime.mouseDrag(e.getX(), e.getY(), v)) {
            this.synchronizeTime(e);
            return;
        }
        if (v.isPlot()) {
            return;
        }
        this.flagdrag = true;
        if (!v.isFree() && v.pref instanceof PlanBG) {
            this.setAllSkyCenter(v, e.getX(), e.getY() + this.deltaY);
        } else {
            this.synchronize(e);
            this.newZoom(e.getX(), e.getY() + this.deltaY);
            this.drawInViewNow(e.getX(), e.getY() + this.deltaY);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.aladin.inHelp) {
            return;
        }
        if (this.INFO == null) {
            this.INFO = Aladin.chaine.getString("ZINFO");
            this.TIPTARGET = Aladin.chaine.getString("TIPTARGET");
            this.TIPLISTTARGET = Aladin.chaine.getString("TIPLISTTARGET");
            this.TIPSTORETARGET = Aladin.chaine.getString("TIPSTORETARGET");
        }
        if (this.rectHistory != null) {
            boolean in3;
            boolean in2;
            boolean repaint = false;
            boolean in1 = this.rectHistory.contains(e.getPoint());
            if (in1 != this.flagHistoryIn) {
                this.flagHistoryIn = in1;
                repaint = true;
            }
            if (in1) {
                Util.toolTip(this, this.TIPTARGET);
            }
            if ((in2 = this.rectTarget.contains(e.getPoint())) != this.flagTargetHistoryIn) {
                this.flagTargetHistoryIn = in2;
                repaint = true;
            }
            if (in2) {
                Util.toolTip(this, this.TIPLISTTARGET);
            }
            if ((in3 = this.rectLoc.contains(e.getPoint())) != this.flagLocHistoryIn) {
                this.flagLocHistoryIn = in3;
                repaint = true;
            }
            if (in3) {
                Util.toolTip(this, this.TIPSTORETARGET);
            }
            boolean bl = this.flagTargetControl = in1 || in2 || in3;
            if (!this.flagTargetControl) {
                Util.toolTip(this, "");
            }
            if (repaint) {
                this.repaint();
            }
        }
        if (this.flagSED) {
            this.sed.mouseMove(e.getX(), e.getY());
            this.repaint();
            return;
        }
        this.aladin.status.setText(this.INFO);
        this.cutX = e.getX();
        this.cutY = e.getY();
        if (this.flagHist && this.hist.setOnMouse(e.getX(), e.getY())) {
            this.repaint();
            if (this.hist.flagHistPixel) {
                this.aladin.view.getCurrentView().repaint();
            }
        } else if (this.flagCut) {
            this.repaint();
        } else {
            this.zoomTime.mouseMove(e.getX(), e.getY(), this.aladin.view.getCurrentView());
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.aladin.inHelp) {
            return;
        }
        if (this.flagSED) {
            this.sed.mouseExit();
            this.repaint();
            return;
        }
        Aladin.makeCursor(this, 0);
        if (this.aladin.view.flagHighlight) {
            this.hist.resetHighlightSource();
            this.aladin.view.flagHighlight = false;
            this.aladin.view.repaint();
        }
        if (this.flagCut || this.flagHist) {
            if (this.flagHist) {
                this.hist.setOnMouse(-1, -1);
            }
            this.cutY = -1;
            this.cutX = -1;
            this.repaint();
            if (this.hist != null && this.hist.flagHistPixel) {
                this.aladin.view.getCurrentView().repaint();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.aladin.inHelp) {
            this.aladin.help.setText(this.Help());
            return;
        }
        boolean resize = this.flagCut;
        if (this.objCut instanceof SourceStat) {
            resize = false;
        }
        if (Ligne.isLigne(this.objCut)) {
            resize = false;
        }
        Aladin.makeCursor(this, resize ? 5 : 2);
    }

    protected Coord drawInViewNow(double xmouse, double ymouse) {
        Coord coo;
        ViewSimple vc;
        block9: {
            vc = this.aladin.view.getCurrentView();
            if (vc == null || vc.isFree()) {
                return null;
            }
            coo = null;
            if (!vc.isPlot()) {
                try {
                    Projection proj = vc.getProj();
                    if (!Projection.isOk(proj)) break block9;
                    PointD p = vc.zoomViewToImage(xmouse, ymouse);
                    coo = new Coord();
                    coo.x = p.x;
                    coo.y = p.y;
                    proj.getCoord(coo);
                    if (Double.isNaN(coo.al)) {
                        coo = null;
                    }
                }
                catch (Exception e) {
                    coo = null;
                }
            } else if (vc.isPlotTime()) {
                this.aladin.view.syncTimeRange(vc);
            }
        }
        if (coo == null) {
            this.calculZoom(vc, xmouse, ymouse);
            this.repaint();
            vc.repaint();
        } else {
            this.aladin.view.setZoomRaDecForSelectedViews(0.0, coo, vc, false, true);
            this.aladin.view.syncView(1.0, coo, null);
        }
        return coo;
    }

    private void setFrameCube(int xc) {
        ViewSimple vc = this.aladin.view.getCurrentView();
        int nbFrame = vc.cubeControl.nbFrame;
        int frame = (int)((double)nbFrame * ((double)xc / (double)this.getWidth()));
        if (frame >= nbFrame) {
            frame = nbFrame - 1;
        }
        if (frame < 0) {
            frame = 0;
        }
        vc.cubeControl.setFrameLevel(frame);
        vc.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.aladin.inHelp) {
            this.aladin.helpOff();
            return;
        }
        if (this.flagTargetControl && this.rectHistory != null) {
            return;
        }
        if (this.flagSED) {
            this.sed.mouseRelease(e.getX(), e.getY());
            return;
        }
        if (this.flagCut) {
            if (this.objCut instanceof SourceStat) {
                this.setFrameCube(e.getX());
            }
            this.flagdrag = false;
            return;
        }
        if (this.flagHist) {
            if (e.getX() < 10) {
                if (this.hist.mouseDragged(e)) {
                    this.repaint();
                }
            } else {
                if (this.hist.inCroix(e.getX(), e.getY())) {
                    this.stopHist();
                } else {
                    this.hist.selectHighlightSource();
                }
                this.aladin.calque.repaintAll();
            }
            return;
        }
        this.flagSynchronized = false;
        ViewSimple v = this.aladin.view.getCurrentView();
        if (this.zoomTime.mouseRelease(e.getX(), e.getY(), v)) {
            this.synchronizeTime(e);
            return;
        }
        if (e.isControlDown() || v.isPlot()) {
            v.reInitZoom(true);
            return;
        }
        Coord coo = this.drawInViewNow(e.getX(), e.getY() + this.deltaY);
        if (coo != null) {
            this.aladin.view.setRepere(coo);
        }
        this.flagdrag = false;
    }

    protected void startDrag() {
        this.flagdrag = true;
    }

    protected void stopDrag() {
        this.flagdrag = false;
        this.or = null;
        this.repaint();
    }

    protected boolean newZoom(double xc, double yc) {
        return this.newZoom(this.aladin.view.getCurrentView(), xc, yc);
    }

    protected boolean newZoom(ViewSimple v, double xc, double yc) {
        if (v.locked) {
            return false;
        }
        if (!this.calculZoom(v, xc, yc)) {
            return false;
        }
        this.repaint();
        return true;
    }

    protected boolean calculZoom(ViewSimple v, double xc, double yc) {
        this.zoomok = false;
        if (v.isFree()) {
            return false;
        }
        v.setZoomXY(v.zoom, xc, yc);
        if (this.rectzoom != null && v.rzoomView != null && v.rzoomView.equals(this.rectzoom)) {
            this.zoomok = true;
            return false;
        }
        this.rectzoom = v.rzoomView;
        this.aladin.calque.zoom.setValue(v.zoom);
        v.newView();
        this.zoomok = true;
        return true;
    }

    protected void resetImgID() {
        this.lastImgID = -1;
    }

    protected boolean drawImgZoom(ViewSimple v) {
        this.mImgWen = null;
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.imgbuf == null || this.imgbuf.getWidth(this.aladin) != w || this.imgbuf.getHeight(this.aladin) != h) {
            if (this.gbuf != null) {
                this.gbuf.dispose();
            }
            this.imgbuf = this.aladin.createImage(w, h);
            this.gbuf = this.imgbuf.getGraphics();
        }
        if (v == null || v.isFree() || !v.pref.isImage() || v.northUp) {
            if (this.lastImgID != -2) {
                this.gbuf.setColor(BGD);
                this.gbuf.fillRect(0, 0, w, h);
                this.drawBord(this.gbuf);
                this.lastImgID = -2;
            }
            if (v != null && !v.isFree()) {
                this.calculZoom(v, v.xzoomView, v.yzoomView);
            }
        } else {
            try {
                boolean flagRGB;
                PlanImage pi = (PlanImage)v.pref;
                boolean bl = flagRGB = pi.type == 2 || pi.type == 20;
                if (this.lastImgID != pi.getImgID() || !flagRGB && (pi.pixelsZoom == null || pi.pixelsZoom.length != w * h) || flagRGB && (((PlanRGBInterface)((Object)pi)).getPixelsZoomRGB() == null || ((PlanRGBInterface)((Object)pi)).getPixelsZoomRGB().length != w * h)) {
                    Image pimg;
                    this.gbuf.setColor(BGD);
                    this.gbuf.fillRect(0, 0, w, h);
                    if (flagRGB) {
                        ((PlanRGBInterface)((Object)pi)).calculPixelsZoomRGB();
                        pimg = this.createImage(new MemoryImageSource(w, h, ((PlanRGBInterface)((Object)pi)).getPixelsZoomRGB(), 0, w));
                    } else {
                        pi.calculPixelsZoom();
                        pimg = this.createImage(new MemoryImageSource(w, h, pi.cm, pi.pixelsZoom, 0, w));
                    }
                    this.gbuf.drawImage(pimg, 0, 0, this);
                    this.drawBord(this.gbuf);
                    this.lastImgID = pi.getImgID();
                    this.calculZoom(v, v.xzoomView, v.yzoomView);
                }
            }
            catch (OutOfMemoryError eOut) {
                this.aladin.gc();
                return false;
            }
            catch (Exception ezoom) {
                ezoom.printStackTrace();
                System.out.println("Try ezoom error: " + ezoom);
                return false;
            }
        }
        this.img = this.imgbuf;
        return true;
    }

    protected void setAllSkyCenter(ViewSimple v, double xc, double yc) {
        Coord c = new Coord();
        c.x = xc;
        c.y = yc;
        this.proj.getCoord(c);
        if (Double.isNaN(c.al)) {
            return;
        }
        v.goToAllSky(c);
    }

    private void drawHipsControl(Graphics g, ViewSimple v) {
        block11: {
            try {
                int width = this.getWidth();
                int height = this.getHeight();
                int n = this.deltaY = this.zoomTime.isActivated() ? DELTAYWITHTIME : 0;
                if (this.lastHipsWidth != width || this.lastHiPSHeight != height) {
                    this.oiz = (short)-1;
                    this.lastHipsWidth = width;
                    this.lastHiPSHeight = height;
                }
                if (this.imgbuf == null || this.imgbuf.getWidth(this.aladin) != width || this.imgbuf.getHeight(this.aladin) != height) {
                    if (this.gbuf != null) {
                        this.gbuf.dispose();
                    }
                    this.imgbuf = this.aladin.createImage(width, height);
                    this.gbuf = this.imgbuf.getGraphics();
                }
                if (this.oiz != v.iz || this.ov != v.hashCode()) {
                    int ga = 4 * width / 10;
                    this.gbuf.setColor(BGD);
                    this.gbuf.fillRect(0, 0, width, height);
                    Projection lastProj = this.proj;
                    try {
                        this.proj = new Projection(null, 0, 0.0, 0.0, 120.0, (double)(width / 2), (double)(-height / 2 + 10), (double)width / 190.0, 0.0, false, 4, Calib.FK5);
                        this.proj.frame = 0;
                    }
                    catch (Exception e) {
                        this.proj = lastProj;
                    }
                    this.oiz = v.iz;
                    this.ov = v.hashCode();
                    Coord c = new Coord(0.0, 0.0);
                    this.proj.getXY(c);
                    int y = (int)c.y;
                    int x = (int)c.x;
                    c.al = 0.0;
                    c.del = 90.0;
                    this.proj.getXY(c);
                    int pa = (int)Math.abs(c.y - (double)y);
                    ga = pa * 2;
                    this.gbuf.setColor(Aladin.COLOR_GREEN);
                    this.gbuf.drawOval(x - ga, y - pa - this.deltaY, ga * 2, pa * 2);
                    this.gbuf.drawOval(x - (ga + pa) / 2, y - pa - this.deltaY, ga + pa, pa * 2);
                    this.gbuf.drawOval(x - pa, y - pa - this.deltaY, pa * 2, pa * 2);
                    this.gbuf.drawOval(x - pa / 2, y - pa - this.deltaY, pa, pa * 2);
                    this.gbuf.drawLine(x - ga, y - this.deltaY, x + ga, y - this.deltaY);
                    this.gbuf.drawLine(x, y - pa - this.deltaY, x, y + pa - this.deltaY);
                    Coord[] coin = v.getCouverture();
                    if (coin != null) {
                        this.proj.frame = this.aladin.localisation.getFrame();
                        this.gbuf.setColor(Aladin.COLOR_BLUE);
                        for (int i = 0; i < coin.length; ++i) {
                            if (Double.isNaN(coin[i].al)) continue;
                            c.al = coin[i].al;
                            c.del = coin[i].del;
                            this.proj.getXY(c);
                            this.gbuf.drawLine((int)c.x, (int)c.y - this.deltaY, (int)c.x, (int)c.y - this.deltaY);
                        }
                        c = v.getCooCentre();
                        if (c == null) {
                            System.err.println("ZommView.drawHipsControl bug++ (v.getCooCenter() returns null ! => switch in SIN");
                            this.proj = v.pref.projd = new Projection("allsky", 2, 0.0, 0.0, 240.0, 240.0, 250.0, 250.0, 500.0, 500.0, 0.0, false, 1, Calib.FK5);
                            v.pref.projd.frame = this.aladin.localisation.getFrame();
                            v.projLocal = v.pref.projd.copy();
                            this.drawHipsControl(g, v);
                            return;
                        }
                        this.proj.getXY(c);
                        this.gbuf.setColor(Aladin.COLOR_CONTROL_FOREGROUND_HIGHLIGHT);
                        Util.fillCircle7(this.gbuf, (int)c.x, (int)c.y - this.deltaY);
                    }
                    this.gbuf.setFont(Aladin.SPLAIN);
                    this.gbuf.setColor(Aladin.COLOR_VERTDEAU);
                    this.gbuf.drawString("+90", x - 5, y - pa - 2 - this.deltaY);
                    this.gbuf.drawString("-90", x - 5, y + pa + 10 - this.deltaY);
                    this.gbuf.drawString("-180", x - ga + 5 - this.gbuf.getFontMetrics().stringWidth("-180"), y + 15 - this.deltaY);
                    this.gbuf.drawString("+180", x + ga - 5, y - 5 - this.deltaY);
                    this.gbuf.setFont(Aladin.SBOLD);
                    FontMetrics fm = this.gbuf.getFontMetrics();
                    this.gbuf.setColor(Aladin.COLOR_CONTROL_FOREGROUND);
                    String s = this.aladin.localisation.J2000ToString(c.al, c.del, 6, false);
                    int xInfo = (int)(c.x + (double)fm.stringWidth(s) > (double)width ? c.x - (double)fm.stringWidth(s) - 10.0 : c.x + 10.0);
                    int yInfo = (int)c.y - 5;
                    this.gbuf.drawString(s, xInfo, yInfo - this.deltaY);
                    String s1 = v.getTaille(0);
                    xInfo = (int)(c.x + (double)fm.stringWidth(s) > (double)width ? c.x - (double)fm.stringWidth(s1) - 10.0 : c.x + 10.0);
                    this.gbuf.drawString(s1, xInfo, (yInfo += 12) - this.deltaY);
                    this.drawBord(this.gbuf);
                }
                g.drawImage(this.imgbuf, 0, 0, this);
                this.drawTargetHistoryControl(g);
                this.zoomTime.draw(g, v);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block11;
                e.printStackTrace();
            }
        }
    }

    private void drawBord(Graphics g) {
        Util.drawEdge(g, this.getWidth(), this.getHeight());
    }

    private void drawTargetHistoryControl(Graphics g) {
        Color c = Aladin.COLOR_CONTROL_FOREGROUND;
        int x = 5;
        int y = 10;
        g.setColor(this.flagLocHistoryIn ? c.brighter() : c);
        this.drawLoc(g, x, y - 5);
        this.rectLoc = new Rectangle(x, y - 5, 15, 20);
        g.setColor(this.flagHistoryIn ? c.brighter() : c);
        Util.fillTriangle7(g, x += 20, y);
        this.rectHistory = new Rectangle(x, y - 5, 15, 20);
        String target = this.aladin.targetHistory.getLast();
        int w = g.getFontMetrics().stringWidth(target);
        g.setColor(this.flagTargetHistoryIn ? c.brighter() : c);
        g.drawString(target, x += 15, y + 6);
        this.rectTarget = new Rectangle(x, y - 5, w, 20);
    }

    protected void drawLoc(Graphics g, int x, int y) {
        for (int i = 0; i < LOCX.length; ++i) {
            g.drawLine(LOCX[i][1] + x, LOCX[i][0] + y, LOCX[i][2] + x, LOCX[i][0] + y);
        }
    }

    protected void setCM(IndexColorModel ic) {
        this.repaint();
    }

    protected void drawImgHist(Graphics g) {
        this.hist.draw(g);
        this.drawBord(g);
    }

    protected boolean drawImgSED(Graphics g) {
        if (this.sed.getCount() == 0) {
            return false;
        }
        this.sed.draw(g);
        this.drawBord(g);
        return true;
    }

    protected void drawImgCut(Graphics g) {
        int i;
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(Aladin.COLOR_BACKGROUND);
        g.fillRect(1, 1, w - 2, h - 2);
        this.drawBord(g);
        boolean trouve = false;
        for (i = 1; i < this.cut.length - 1; ++i) {
            if (this.cut[i] == 0 && this.cutR[i] == 0 && this.cutG[i] == 0 && this.cutB[i] == 0) continue;
            trouve = true;
            break;
        }
        if (!trouve) {
            this.aladin.status.setText("Nothing in cut graph !!");
            return;
        }
        if (this.cut[0] != -1) {
            g.setColor(Aladin.COLOR_CONTROL_FOREGROUND_UNAVAILABLE);
            for (i = 1; i < this.cut.length - 1; ++i) {
                g.drawLine(i, h - this.cut[i], i, h);
            }
            g.setColor(Aladin.COLOR_CONTROL_FOREGROUND);
            for (i = 1; i < this.cut.length - 1; ++i) {
                g.drawLine(i, h - this.cut[i - 1], i, h - this.cut[i]);
            }
        } else {
            g.setColor(Color.red);
            for (i = 1; i < this.cutR.length - 1; ++i) {
                g.drawLine(i - 1, h - this.cutR[i - 1], i, h - this.cutR[i]);
            }
            g.setColor(Color.green);
            for (i = 1; i < this.cutG.length - 1; ++i) {
                g.drawLine(i - 1, h - this.cutG[i - 1], i, h - this.cutG[i]);
            }
            g.setColor(Color.blue);
            for (i = 1; i < this.cutB.length - 1; ++i) {
                g.drawLine(i - 1, h - this.cutB[i - 1], i, h - this.cutB[i]);
            }
        }
    }

    private void drawFWHM(Graphics g) {
        int x2;
        int x1;
        if (this.cutX < 0 || this.cut[0] == -1) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int y = height - this.cutY;
        PlanImage pimg = (PlanImage)this.aladin.calque.getPlanBase();
        String pixel = "pixel value: " + pimg.getPixelInfoFromGrey(y * 256 / height);
        g.setFont(Aladin.PLAIN);
        g.setColor(Aladin.COLOR_BLUE);
        g.drawLine(1, this.cutY, 4, this.cutY);
        g.drawLine(width - 4, this.cutY, width, this.cutY);
        g.drawString(pixel, 25, this.cutY < 20 ? height - 2 : 18);
        for (x1 = this.cutX; x1 > 0 && y <= this.cut[x1]; --x1) {
        }
        for (x2 = this.cutX; x2 < width && y <= this.cut[x2]; ++x2) {
        }
        if (x2 <= x1) {
            return;
        }
        g.setColor(Aladin.COLOR_FOREGROUND);
        g.drawLine(x1 + 1, this.cutY, x2 - 1, this.cutY);
        g.drawLine(x1 + 1, this.cutY + 1, x2 - 1, this.cutY + 1);
        double distXY = ((Cote)this.objCut).getDistXY();
        if (distXY == -1.0) {
            return;
        }
        double f = (double)(x2 - x1) * distXY / (double)width;
        String fwhm = Util.myRound(f + "", 1) + "pix";
        int x = width - this.cutX < 40 ? this.cutX - 50 : this.cutX + 7;
        g.drawString(fwhm, x, this.cutY - 2);
        double dist = ((Cote)this.objCut).getDist();
        if (dist != -1.0) {
            g.drawString(Coord.getUnit(dist * f / distXY), x, this.cutY + 15);
        }
    }

    private void drawPixelCourant(Graphics g) {
        block4: {
            try {
                PlanImage p = (PlanImage)this.aladin.calque.getPlanBase();
                if (p == null) {
                    return;
                }
                g.setColor(Aladin.COLOR_BLUE);
                g.setFont(Aladin.SPLAIN);
                String s = p.getPixelInfoFromGrey(0);
                g.drawString(s, 2, 10);
                s = p.getPixelInfoFromGrey(255);
                g.drawString(s, this.getWidth() - g.getFontMetrics().stringWidth(s) - 2, 10);
                if (this.cutX > 0) {
                    s = p.getPixelInfoFromGrey((int)Math.floor((double)this.cutX * (256.0 / (double)this.getWidth())));
                    int x = this.cutX;
                    g.setColor(Color.red);
                    g.drawLine(x, 0, x, this.getHeight());
                    int len = g.getFontMetrics().stringWidth(s);
                    x = x + len > this.getWidth() - 5 ? x - 5 - len : (x += 5);
                    g.drawString(s, x, this.getHeight() - 5);
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block4;
                e.printStackTrace();
            }
        }
    }

    private void drawCubeFrame(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        ViewSimple vc = this.aladin.view.getCurrentView();
        int frame = vc.cubeControl.lastFrame;
        int nbFrame = vc.cubeControl.nbFrame;
        int x = (int)((double)width * ((double)frame / (double)nbFrame));
        int w = Math.max(1, (int)((double)width / (double)nbFrame));
        g.setColor(Color.red);
        g.fillRect(x, 0, w, height);
        PlanImageCube pic = null;
        pic = vc.pref.type == 4 ? (PlanImageCube)vc.pref : null;
        g.setFont(Aladin.SPLAIN);
        String s = pic != null && pic.fromCanal ? pic.getCanalValue(frame) : "" + (frame + 1);
        int l = g.getFontMetrics().stringWidth(s);
        g.drawString(s, x + l + w > width ? x - l - 2 : x + w + 2, height - 2);
        int y = height - this.cutY;
        String pixel = ((PlanImage)vc.pref).getPixelInfoFromGrey(y * 256 / height);
        if (pixel.length() == 0) {
            return;
        }
        g.setColor(Color.black);
        g.drawLine(1, this.cutY, width, this.cutY);
        g.drawString(pixel, 10, this.cutY < 20 ? this.cutY + 10 : this.cutY - 2);
    }

    protected void suspendCut() {
        this.flagCut = false;
        this.repaint();
    }

    protected Obj getObjCut() {
        return this.objCut;
    }

    protected void cutOff(Obj objCut) {
        if (objCut != this.objCut) {
            return;
        }
        this.setCut(null);
    }

    protected void setCut(int[] v) {
        this.setCut(null, v, 0);
    }

    protected void setCut(Obj objCut, int[] v, int mode) {
        this.cutX = -1;
        this.objCut = objCut;
        if (objCut == null || v == null || this.aladin.toolBox.tool[6].mode == -1) {
            if (this.flagCut) {
                this.repaint();
            }
            this.flagCut = false;
            return;
        }
        this.flagCut = true;
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.cut == null || this.cut.length != width) {
            this.cut = new int[width];
            this.cutR = new int[width];
            this.cutG = new int[width];
            this.cutB = new int[width];
        }
        double f = (double)height / 256.0;
        double w = (double)v.length / (double)width;
        int j = 0;
        for (int i = 0; i < width; ++i) {
            int n = 0;
            double sw = w * (double)i;
            if (mode == 1) {
                this.cut[0] = -1;
                boolean valid = true;
                double tG = 0.0;
                double tB = 0.0;
                double tR = 0.0;
                while ((double)j < sw && j < v.length) {
                    if (valid && v[j] == -1) {
                        valid = false;
                    }
                    tR += (double)(v[j] >> 16 & 0xFF);
                    tG += (double)(v[j] >> 8 & 0xFF);
                    tB += (double)(v[j] & 0xFF);
                    ++j;
                    ++n;
                }
                tR /= (double)n;
                tG /= (double)n;
                tB /= (double)n;
                if (!valid) {
                    this.cutG[i] = this.cutB[i] = this.getWidth();
                    this.cutR[i] = this.cutB[i];
                    continue;
                }
                this.cutR[i] = (int)(f * tR);
                this.cutG[i] = (int)(f * tG);
                this.cutB[i] = (int)(f * tB);
                if (this.cutR[i] == 0 && i > 0) {
                    this.cutR[i] = this.cutR[i - 1];
                }
                if (this.cutG[i] == 0 && i > 0) {
                    this.cutG[i] = this.cutG[i - 1];
                }
                if (this.cutB[i] != 0 || i <= 0) continue;
                this.cutB[i] = this.cutB[i - 1];
                continue;
            }
            double t = 0.0;
            boolean valid = true;
            while ((double)j < sw && j < v.length) {
                if (valid && v[j] == -1) {
                    valid = false;
                }
                t += (double)v[j++];
                ++n;
            }
            t /= (double)n;
            if (!valid) {
                this.cut[i] = 0;
                continue;
            }
            this.cut[i] = (int)(f * t);
            if (mode != 0 || this.cut[i] != 0 || i <= 0) continue;
            this.cut[i] = this.cut[i - 1];
        }
        this.repaint();
    }

    protected void clearSED() {
        this.flagSED = false;
        this.oSrcSed = "";
        if (this.sed != null) {
            this.sed.clear();
        }
        this.aladin.view.simRep = null;
        this.aladin.calque.repaintAll();
    }

    protected void setSED(String position, String source) {
        this.setSED(position, source, null);
    }

    protected void setSED(String position, String source, Repere simRep) {
        if (source == null) {
            source = "";
        }
        if (source.length() == 0) {
            this.flagSED = false;
        }
        if (this.oSrcSed.equals(source)) {
            return;
        }
        this.oSrcSed = source;
        if (source.length() == 0) {
            this.clearSED();
        } else {
            if (this.sed == null) {
                this.sed = new SED(this.aladin);
            }
            this.flagSED = true;
            this.flagHist = false;
            this.sed.loadFromSource(position, source);
            this.sed.setRepere(simRep);
        }
        this.repaint();
    }

    protected void setSED(Source o) {
        String source;
        String string = source = o == null ? null : o.id;
        if (source == null) {
            source = "";
        }
        this.oSrcSed = source;
        if (source.length() == 0) {
            this.clearSED();
        } else {
            if (this.sed == null) {
                this.sed = new SED(this.aladin);
            }
            this.sed.clear();
            this.flagSED = true;
            this.flagHist = false;
            this.sed.addFromIterator(this.aladin.mesure.iterator());
            this.sed.setHighLight(o);
        }
        this.repaint();
    }

    protected void resumeSED() {
        Source s = this.aladin.mesure.getFirstSrc();
        if (!(s != null && s.getLeg() != null && s.getLeg().isSED() || this.flagSED)) {
            return;
        }
        this.setSED(s);
    }

    protected void stopHist() {
        if (!this.flagHist) {
            return;
        }
        this.flagHist = false;
        this.aladin.view.flagHighlight = false;
        this.hist.resetHighlightSource();
        this.repaint();
    }

    protected void initPixelHist() {
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.hist == null) {
            this.hist = new ZoomHist(this.aladin);
        }
        this.hist.startHistPixel();
    }

    protected void addPixelHist(double pix) {
        this.hist.addPixel(pix);
    }

    protected void createPixelHist(String titre) {
        this.hist.createHistPixel(titre);
    }

    protected void activeHistPixel(String texte) {
        this.flagHist = true;
        this.hist.setText(texte);
        this.repaint();
    }

    protected boolean setHist(Source o, int nField) {
        boolean rep = false;
        this.flagSED = false;
        this.oSrcSed = "";
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.hist == null) {
            this.hist = new ZoomHist(this.aladin);
            rep = true;
        }
        boolean bl = this.hist.o != o || this.hist.nField != nField;
        this.flagHist = this.hist.init(o, nField);
        this.repaint();
        return rep |= bl;
    }

    protected void changeWen(int sens) {
        if (sens == -1 && this.WENZOOM > 8) {
            this.WENZOOM /= 2;
            this.oc = null;
            this.mImgWen = null;
        } else if (sens == 1 && this.WENZOOM < 64) {
            this.WENZOOM *= 2;
            this.oc = null;
            this.mImgWen = null;
        }
        this.repaint();
    }

    protected void setPixelTable(boolean flag) {
        this.WENZOOM = flag ? 32 : 8;
    }

    protected void drawImgWen() {
        ViewSimple v = this.aladin.view.getMouseView();
        if (v == null || v.isFree() || !v.pref.isImage() || v.isProjSync() || v.northUp) {
            this.img = null;
            this.imgok = false;
            return;
        }
        PointD c = v.getPosition(this.xwen, this.ywen);
        int frame = v.pref.type == 3 || v.pref.type == 4 ? v.cubeControl.lastFrame : this.oframe;
        if (c.equals(this.oc) && frame == this.oframe) {
            return;
        }
        this.oc = c;
        this.oframe = frame;
        this.calculWen(v, (int)c.x, (int)c.y);
    }

    protected void calculWen(ViewSimple v, int x, int y) {
        boolean isPlanRGB;
        this.xmwen = x;
        this.ymwen = y;
        int w = (int)Math.ceil((double)this.getWidth() / (double)this.WENZOOM);
        int x1 = this.xmwen - w / 2;
        int y1 = this.ymwen - w / 2;
        this.xWenrect = (this.xmwen - x1) * this.WENZOOM;
        this.yWenrect = (this.ymwen - y1) * this.WENZOOM;
        PlanImage p = (PlanImage)v.pref;
        boolean bl = isPlanRGB = p.type == 2;
        if (v.hashCode() != this.ov) {
            this.mImgWen = null;
        }
        this.ov = v.hashCode();
        if (isPlanRGB) {
            if (this.pixelsRGB == null || this.pixelsRGB.length != w * w) {
                this.pixelsRGB = new int[w * w];
            }
            if (this.scalepixelsRGB == null || this.scalepixelsRGB.length != w * w * this.WENZOOM * this.WENZOOM) {
                this.scalepixelsRGB = new int[w * w * this.WENZOOM * this.WENZOOM];
            }
        } else {
            if (this.pixels == null || this.pixels.length != w * w) {
                this.pixels = new byte[w * w];
            }
            if (this.scalepixels == null || this.scalepixels.length != w * w * this.WENZOOM * this.WENZOOM) {
                this.scalepixels = new byte[w * w * this.WENZOOM * this.WENZOOM];
            }
        }
        if (x1 >= 0 && y1 >= 0 && x1 + w < p.width && y1 + w < p.height) {
            if (isPlanRGB) {
                PlanImageRGB pi = (PlanImageRGB)p;
                pi.getPixels(this.pixelsRGB, x1, y1, w, w);
                this.flagRGB = true;
                int d = 0;
                for (int i = 0; i < w; ++i) {
                    int orig = d;
                    for (int k = 0; k < w; ++k) {
                        int c = this.pixelsRGB[i * w + k];
                        for (int m = 0; m < this.WENZOOM; ++m) {
                            this.scalepixelsRGB[d + m] = c;
                        }
                        d += this.WENZOOM;
                    }
                    for (int j = 1; j < this.WENZOOM; j += j) {
                        System.arraycopy(this.scalepixelsRGB, orig, this.scalepixelsRGB, orig + j * w * this.WENZOOM, j * this.WENZOOM * w);
                    }
                    d += (this.WENZOOM - 1) * this.WENZOOM * w;
                }
            } else {
                p.getPixels(this.pixels, x1, y1, w, w);
                this.flagRGB = false;
                int d = 0;
                for (int i = 0; i < w; ++i) {
                    int orig = d;
                    for (int k = 0; k < w; ++k) {
                        byte c = this.pixels[i * w + k];
                        for (int m = 0; m < this.WENZOOM; ++m) {
                            this.scalepixels[d + m] = c;
                        }
                        d += this.WENZOOM;
                    }
                    for (int j = 1; j < this.WENZOOM; j += j) {
                        System.arraycopy(this.scalepixels, orig, this.scalepixels, orig + j * w * this.WENZOOM, j * this.WENZOOM * w);
                    }
                    d += (this.WENZOOM - 1) * this.WENZOOM * w;
                }
            }
        }
        if (isPlanRGB) {
            if (this.mImgWen == null) {
                this.mImgWen = new MemoryImageSource(w * this.WENZOOM, w * this.WENZOOM, this.scalepixelsRGB, 0, w * this.WENZOOM);
                this.mImgWen.setAnimated(true);
                this.imgwen = this.getToolkit().createImage(this.mImgWen);
            } else {
                this.mImgWen.newPixels(this.scalepixelsRGB, ColorModel.getRGBdefault(), 0, w * this.WENZOOM);
            }
        } else if (this.mImgWen == null) {
            this.mImgWen = new MemoryImageSource(w * this.WENZOOM, w * this.WENZOOM, p.cm, this.scalepixels, 0, w * this.WENZOOM);
            this.mImgWen.setAnimated(true);
            this.imgwen = this.getToolkit().createImage(this.mImgWen);
        } else {
            this.mImgWen.newPixels(this.scalepixels, p.cm, 0, w * this.WENZOOM);
        }
        if (this.flagwen) {
            this.imgok = true;
            this.img = this.imgwen;
        }
    }

    private void drawInfo(Graphics g, int w, int h) {
        try {
            Projection proj = this.aladin.view.getCurrentView().pref.projd;
            if (proj.isXYLinear()) {
                return;
            }
            Calib c = proj.c;
            String w1 = Coord.getUnit(c.getImgWidth());
            String h1 = Coord.getUnit(c.getImgHeight());
            g.setFont(Aladin.SPLAIN);
            g.setColor(Aladin.COLOR_CONTROL_FOREGROUND);
            String s = w1 + " x " + h1;
            g.drawString(s, w / 2 - g.getFontMetrics().stringWidth(s) / 2, h - 8);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private static void drawFleche(Graphics g, int x, int y, char d) {
        int dx;
        int n = d == 'W' ? -WF : (dx = d == 'E' ? WF : 0);
        int dy = d == 'N' ? -WF : (d == 'S' ? WF : 0);
        int xb = x + dx;
        int yb = y + dy;
        g.drawLine(x, y, xb, yb);
        ZoomView.XF[0] = xb;
        ZoomView.YF[0] = yb;
        ZoomView.XF[1] = xb + (dy /= 3) - (dx /= 3);
        ZoomView.YF[1] = yb - dy - dx;
        ZoomView.XF[2] = xb - dy - dx;
        ZoomView.YF[2] = yb - dy + dx;
        g.fillPolygon(XF, YF, 3);
        g.drawPolygon(XF, YF, 3);
    }

    protected boolean isPixelTable() {
        return this.WENZOOM >= 32;
    }

    protected void copier() {
        if (!this.flagHist) {
            return;
        }
        String s = this.hist.getCopier();
        this.aladin.copyToClipBoard(s);
    }

    @Override
    public void paintComponent(Graphics gr) {
        if (Aladin.NOGUI) {
            return;
        }
        this.rectHistory = null;
        this.aladin.setAliasing(gr);
        ViewSimple v = this.aladin.view.getCurrentView();
        int w = this.getWidth();
        int h = this.getHeight();
        if (w != this.lastWidth || h != this.lastHeight) {
            this.aladin.view.adjustZoomView(this.lastWidth, w, this.lastHeight, h);
            this.lastWidth = w;
            this.lastHeight = h;
            this.resumeSize();
        }
        gr.setColor(Aladin.COLOR_BACKGROUND);
        gr.fillRect(0, 0, w, h);
        this.drawBord(gr);
        if (v == null || v.isFree()) {
            return;
        }
        Dimension d = v.getSize();
        if (this.flagwen) {
            this.imgok = true;
            this.drawImgWen();
        }
        if (!this.flagdrag) {
            this.imgok = this.drawImgZoom(v);
        }
        if (this.flagHist) {
            this.drawImgHist(gr);
            return;
        }
        if (this.flagSED && this.drawImgSED(gr)) {
            return;
        }
        if (this.flagCut) {
            this.drawImgCut(gr);
            try {
                if (this.objCut instanceof Cote) {
                    this.drawFWHM(gr);
                } else if (this.objCut instanceof SourceStat) {
                    if (((SourceStat)this.objCut).hasRayon()) {
                        this.drawPixelCourant(gr);
                    }
                } else if (Ligne.isLigne(this.objCut)) {
                    this.drawPixelCourant(gr);
                } else if (this.objCut instanceof Repere) {
                    this.drawCubeFrame(gr);
                }
            }
            catch (Exception e) {
                this.setCut(null);
            }
            return;
        }
        if (v.isPlotTime()) {
            gr.setColor(BGD);
            gr.fillRect(0, 0, w, h);
            this.drawBord(gr);
            this.drawTargetHistoryControl(gr);
            this.zoomTime.draw(gr, v);
            return;
        }
        if (v.isPlot()) {
            gr.setColor(BGD);
            gr.fillRect(0, 0, w, h);
            this.drawBord(gr);
            return;
        }
        if (!(Aladin.NOGUI || v.isFree() || d.width == this.owidth && d.height == this.oheight)) {
            this.owidth = d.width;
            this.oheight = d.height;
            this.newZoom(v.xzoomView, v.yzoomView);
            return;
        }
        if (v.pref instanceof PlanBG) {
            this.drawHipsControl(gr, v);
            return;
        }
        if (this.imgok) {
            gr.drawImage(this.img, 0, 0, this);
            this.zoomTime.draw(gr, v);
        } else {
            gr.clearRect(0, 0, w, h);
        }
        if (!(v.isFree() || this.flagwen || this.flagCut || this.rectzoom == null)) {
            this.drawArea(gr, (int)Math.round(this.rectzoom.x), (int)Math.round(this.rectzoom.y), (int)Math.round(this.rectzoom.width - 1.0), (int)Math.round(this.rectzoom.height - 1.0));
            gr.setColor(Aladin.COLOR_BLUE);
            this.drawInfo(gr, w, h);
        }
        if (this.flagwen && this.imgok) {
            int W2 = this.WENZOOM / 2;
            gr.setColor(Aladin.COLOR_BLUE);
            gr.drawRect(this.xWenrect, this.yWenrect, this.WENZOOM, this.WENZOOM);
            if (this.WENZOOM <= 16) {
                ZoomView.drawFleche(gr, this.xWenrect + W2, this.yWenrect - this.WENZOOM, 'N');
                ZoomView.drawFleche(gr, this.xWenrect + W2, this.yWenrect + 2 * this.WENZOOM, 'S');
                ZoomView.drawFleche(gr, this.xWenrect - this.WENZOOM, this.yWenrect + W2, 'W');
                ZoomView.drawFleche(gr, this.xWenrect + 2 * this.WENZOOM, this.yWenrect + W2, 'E');
            }
            gr.setFont(Aladin.LBOLD);
            gr.setColor(Color.red);
            if (this.isPixelTable() && v.pref.type != 2) {
                v = this.aladin.view.getMouseView();
                int step = this.WENZOOM == 32 ? 4 : 1;
                gr.setFont(Aladin.BOLD);
                gr.setColor(Color.black);
                int j = 0;
                int y1 = this.ymwen - step - 1;
                while (y1 <= this.ymwen + step) {
                    int i = 0;
                    int x1 = this.xmwen - step - 1;
                    while (x1 <= this.xmwen + step) {
                        int xx = (i - 1) * this.WENZOOM + 8;
                        int yy = (j - 1) * this.WENZOOM + 2 * this.WENZOOM / 3 - 7 + i % 2 * this.WENZOOM / 2;
                        String pix = ((PlanImage)v.pref).getPixelInfo(x1, y1, 3);
                        Util.drawStringOutline(gr, pix, xx, yy, y1 == this.ymwen && x1 == this.xmwen ? Color.cyan : Color.white, Color.black);
                        ++x1;
                        ++i;
                    }
                    ++y1;
                    ++j;
                }
            }
        }
        this.drawBord(gr);
    }

    private void drawArea(Graphics g, int x, int y, int width, int height) {
        Util.drawArea(this.aladin, g, x, y, width, height, Color.blue, 0.15f, true);
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(Color.red);
        if (x + width < 0) {
            ZoomView.drawFleche(g, 15, h / 2, 'W');
        }
        if (y + height < 0) {
            ZoomView.drawFleche(g, w / 2, 15, 'N');
        }
        if (x >= this.getWidth()) {
            ZoomView.drawFleche(g, w - 15, h / 2, 'E');
        }
        if (y >= this.getHeight()) {
            ZoomView.drawFleche(g, w / 2, h - 15, 'S');
        }
    }

    protected void wen(double x, double y) {
        if (!this.flagwen) {
            return;
        }
        if (this.xwen == x && this.ywen == y) {
            return;
        }
        this.xwen = x;
        this.ywen = y;
        this.repaint();
    }

    protected void wenOn() {
        this.flagwen = true;
    }

    void wenOff() {
        this.flagwen = false;
        this.repaint();
    }

    protected String Help() {
        return Aladin.chaine.getString("ZoomView.HELP");
    }

    @Override
    public WidgetControl getWidgetControl() {
        return this.voc;
    }

    @Override
    public void createWidgetControl(int x, int y, int width, int height, float opacity, JComponent parent) {
        this.voc = new WidgetControl(this, x, y, width, height, opacity, parent);
        this.voc.setResizable(true);
    }

    @Override
    public void paintCollapsed(Graphics g) {
        Tool.drawVOHand(g, 3, 2);
    }

    static {
        DELTAYWITHTIME = 15;
        LOCX = new int[][]{{0, 5, 9}, {1, 4, 10}, {2, 3, 11}, {3, 2, 5}, {3, 9, 12}, {4, 2, 4}, {4, 10, 12}, {5, 2, 4}, {5, 10, 12}, {6, 2, 4}, {6, 10, 12}, {7, 2, 5}, {7, 9, 12}, {8, 3, 11}, {9, 4, 10}, {10, 4, 10}, {11, 5, 9}, {12, 6, 8}, {13, 7, 7}};
        WF = 12;
        XF = new int[3];
        YF = new int[3];
    }

    class JMenuItemExt
    extends JMenuItem {
        JMenuItemExt(String s) {
            super(s);
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    String s = ((JMenuItem)e.getSource()).getActionCommand();
                }
            });
        }
    }
}

