/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.ViewSimple;
import cds.aladin.ZoomView;
import cds.moc.TMoc;
import cds.tools.Astrodate;
import cds.tools.Util;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;

class ZoomTime {
    static final int DELTAY = 40;
    static final int DELTA_G = 7;
    static final int DELTA_D = 7;
    Aladin aladin;
    ZoomView zoomView;
    private double globalJdmin = -1.0;
    private double globalJdmax = -1.0;
    int width;
    int height;
    int xDrag;
    int state;
    int stateMove;
    Rectangle inRect = null;
    static final int OUT = 0;
    static final int BEFORE = 1;
    static final int ONSTART = 2;
    static final int INTIME = 3;
    static final int ONEND = 4;
    static final int AFTER = 5;
    static final int M = 3;
    static final double FCTZOOM = 0.12;
    private static final int SIZE_CLOCK = 5;

    ZoomTime(ZoomView zoomView) {
        this.zoomView = zoomView;
        this.aladin = zoomView.aladin;
        this.xDrag = -1;
        this.state = 0;
        this.stateMove = 0;
    }

    void setGlobalTimeRange(double[] timeRange) {
        this.globalJdmin = timeRange[0];
        this.globalJdmax = timeRange[1];
        this.zoomView.repaint();
    }

    protected double[] getGlobalTimeRange() {
        return new double[]{this.globalJdmin, this.globalJdmax};
    }

    protected boolean mouseIn(int x, int y) {
        return this.inRect == null ? false : this.inRect.contains(x, y);
    }

    protected int getMouseState(int x, ViewSimple v) {
        int end;
        double[] t = v.getTimeRange();
        int start = Double.isNaN(t[0]) ? 7 : this.getX(t[0]);
        int n = end = Double.isNaN(t[1]) ? this.width - 7 : this.getX(t[1]);
        return x < 4 ? 0 : (x < start - 3 ? 1 : (x <= start + 3 ? 2 : (x < end - 3 ? 3 : (x <= end + 3 ? 4 : (x <= this.width - 7 + 3 ? 5 : 0)))));
    }

    private double getDeltaTime(int deltaX) {
        double total = this.globalJdmax - this.globalJdmin;
        double w = this.width - 14;
        double onePix = total / w;
        double deltaJD = (double)deltaX * onePix;
        return deltaJD;
    }

    private double getTime(int x) {
        return this.getDeltaTime(x + 7) + this.globalJdmin;
    }

    protected double[] deltaXTime(int deltaX, ViewSimple v) {
        double deltaJD = this.getDeltaTime(deltaX);
        double[] t = v.getTimeRange();
        if (Double.isNaN(t[0])) {
            t[0] = this.globalJdmin;
        }
        if (Double.isNaN(t[1])) {
            t[1] = this.globalJdmax;
        }
        if (this.state == 2) {
            t[0] = t[0] + deltaJD;
        } else if (this.state == 4) {
            t[1] = t[1] + deltaJD;
        } else if (this.state == 3) {
            t[0] = t[0] + deltaJD;
            t[1] = t[1] + deltaJD;
        }
        if (t[0] > t[1]) {
            t[0] = t[1];
        }
        if (t[0] <= this.globalJdmin) {
            t[0] = Double.NaN;
        }
        if (t[1] >= this.globalJdmax) {
            t[1] = Double.NaN;
        }
        v.setTimeRange(t);
        return t;
    }

    protected double setXTime(int x, ViewSimple v) {
        double jd = this.getTime(x);
        double[] t = v.getTimeRange();
        if (Double.isNaN(t[0]) && Double.isNaN(t[1])) {
            return Double.NaN;
        }
        if (Double.isNaN(t[0])) {
            t[0] = this.globalJdmin;
        }
        if (Double.isNaN(t[1])) {
            t[1] = this.globalJdmax;
        }
        double midRange = (t[1] - t[0]) / 2.0;
        t[0] = jd - midRange;
        t[1] = jd + midRange;
        if (t[0] <= this.globalJdmin) {
            t[0] = Double.NaN;
        }
        if (t[1] >= this.globalJdmax) {
            t[1] = Double.NaN;
        }
        v.setTimeRange(t);
        return midRange;
    }

    protected void mouseMove(int x, int y, ViewSimple v) {
        if (!this.mouseIn(x, y)) {
            this.stateMove = 0;
            return;
        }
        this.stateMove = this.getMouseState(x, v);
    }

    protected boolean mousePress(int x, int y, ViewSimple v, boolean doubleClick) {
        if (!this.mouseIn(x, y)) {
            this.state = 0;
            return false;
        }
        if (doubleClick) {
            v.setTimeRange(new double[]{Double.NaN, Double.NaN});
            return true;
        }
        this.state = this.getMouseState(x, v);
        return true;
    }

    protected boolean mouseDrag(int x, int y, ViewSimple v) {
        if (this.state == 0) {
            return false;
        }
        if (this.xDrag != -1) {
            int deltaX = x - this.xDrag;
            this.deltaXTime(deltaX, v);
        }
        this.xDrag = x;
        return true;
    }

    protected boolean mouseRelease(int x, int y, ViewSimple v) {
        if (this.xDrag == -1) {
            if (!this.mouseIn(x, y)) {
                return false;
            }
            double t = this.setXTime(x, v);
            return true;
        }
        int deltaX = x - this.xDrag;
        double[] t = this.deltaXTime(deltaX, v);
        this.xDrag = -1;
        return true;
    }

    protected boolean isActivated() {
        if (Double.isNaN(this.globalJdmin)) {
            return false;
        }
        return this.globalJdmax != this.globalJdmin;
    }

    private int getX(double jd) {
        double total = this.globalJdmax - this.globalJdmin;
        double w = this.width - 14;
        double fct = w / total;
        return (int)((jd - this.globalJdmin) * fct) + 7;
    }

    protected boolean mouseWheelMoved(MouseWheelEvent e, ViewSimple v) {
        if (!this.mouseIn(e.getX(), e.getY())) {
            return false;
        }
        double[] t = v.getTimeRange();
        if (Double.isNaN(t[0])) {
            t = new double[]{this.globalJdmin, this.globalJdmax};
        }
        int sens = e.getWheelRotation() > 0 ? 1 : -1;
        double range = t[1] - t[0];
        double nRange = range * (sens == 1 ? 1.12 : 0.88);
        double centre = (t[0] + t[1]) / 2.0;
        t[0] = centre - nRange / 2.0;
        t[1] = centre + nRange / 2.0;
        if (t[0] <= this.globalJdmin) {
            t[0] = Double.NaN;
        }
        if (t[1] >= this.globalJdmax) {
            t[1] = Double.NaN;
        }
        if (v.setTimeRange(t)) {
            this.zoomView.repaint();
        }
        return true;
    }

    protected void draw(Graphics g, ViewSimple v) {
        if (!this.isActivated()) {
            this.inRect = null;
            return;
        }
        this.width = this.zoomView.getWidth();
        this.height = this.zoomView.getHeight();
        int x = 7;
        int y = this.height - 40;
        int w = this.width - 14;
        int h = 13;
        if (this.inRect == null || this.inRect.width != this.width || this.inRect.height != this.height) {
            this.inRect = new Rectangle(x - 2, y - 5, w + 4, h + 6);
        }
        g.setFont(Aladin.SPLAIN);
        g.setColor(Aladin.COLOR_GREEN);
        g.drawRect(x, y, w, h);
        g.setColor(Aladin.COLOR_BLUETIME);
        g.fillRect(x + 2, y + 2, w - 4, h - 4);
        g.setColor(Aladin.COLOR_VERTDEAU);
        String startDate = Astrodate.JDToDate(this.globalJdmin, false);
        String endDate = Astrodate.JDToDate(this.globalJdmax, false);
        if (startDate.equals(endDate)) {
            startDate = Astrodate.JDToDate(this.globalJdmin);
            endDate = Astrodate.JDToDate(this.globalJdmax);
            int i = endDate.indexOf(84);
            endDate = endDate.substring(i + 1);
        }
        g.drawString(startDate, x, y + h + 13);
        g.drawString(endDate, this.width - g.getFontMetrics().stringWidth(endDate) - 5, y + h + 13);
        double[] t = v.getTimeRange();
        if (!Double.isNaN(t[0]) || !Double.isNaN(t[1])) {
            int x1 = Double.isNaN(t[0]) ? 7 : this.getX(t[0]);
            int x2 = Double.isNaN(t[1]) ? this.width - 7 : this.getX(t[1]);
            g.setColor(Aladin.COLOR_BLUE);
            g.fillRect(x1, y + 2, x2 - x1 + 1, h - 4);
            g.setColor(Aladin.COLOR_CONTROL_FOREGROUND_HIGHLIGHT);
            g.fillRect(x1, y - 3, 2, h + 6);
            g.drawLine(x1, y - 3, x1 + 3, y - 3);
            g.drawLine(x1, y + h + 3, x1 + 3, y + h + 3);
            g.fillRect(x2 - 1, y - 3, 2, h + 6);
            g.drawLine(x2, y - 3, x2 - 3, y - 3);
            g.drawLine(x2, y + h + 3, x2 - 3, y + h + 3);
            int xm = (x1 + x2) / 2;
            g.drawLine(xm, y - 2, xm, y + h + 2);
            if (Double.isNaN(t[0])) {
                t[0] = this.globalJdmin;
            }
            if (Double.isNaN(t[1])) {
                t[1] = this.globalJdmax;
            }
            String s = Astrodate.JDToDate((t[0] + t[1]) / 2.0);
            int len = g.getFontMetrics().stringWidth(s);
            int x3 = xm - len / 2;
            if (x3 < 2) {
                x3 = 2;
            }
            if (x3 + len > this.width) {
                x3 = this.width - len - 2;
            }
            g.drawString(s, x3, y - 5 - 12);
            s = TMoc.getTemps((long)((t[1] - t[0]) * 8.64E10), true);
            len = g.getFontMetrics().stringWidth(s);
            x3 = xm - len / 2;
            if (x3 < 2) {
                x3 = 2;
            }
            if (x3 + len > this.width) {
                x3 = this.width - len - 2;
            }
            g.drawString(s, x3, y - 5);
        } else {
            g.setColor(this.stateMove == 2 ? Aladin.COLOR_CONTROL_FOREGROUND : Aladin.COLOR_GREEN);
            Util.drawTriangle(g, 7, y - 2, 7, false);
            g.setColor(this.stateMove == 4 ? Aladin.COLOR_CONTROL_FOREGROUND : Aladin.COLOR_GREEN);
            Util.drawTriangle(g, this.width - 7, y - 2, 7, false);
        }
    }
}

