/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.Timer;

public final class ViewControl
extends JComponent
implements MouseMotionListener,
MouseListener {
    public static final int MVIEW1 = 1;
    public static final int MVIEW2T = 5;
    public static final int MVIEW2C = 2;
    public static final int MVIEW2L = 3;
    public static final int MVIEW4 = 4;
    public static final int MVIEW9 = 9;
    public static final int MVIEW16 = 16;
    static final int DEFAULT = 1;
    static final int[] MODE = new int[]{1, 5, 2, 3, 4, 9, 16};
    static final int MAXVIEW = 16;
    String INFOMVIEW;
    String INFOSYNC;
    String LABEL;
    static final int SL = 18;
    static final int L = 12;
    static final int H = 24;
    static final int W = 14 * MODE.length + 2;
    protected int modeView = 1;
    private int nMode = -1;
    Aladin aladin;
    private Timer timerTip = null;
    private boolean enabled = false;

    protected ViewControl(Aladin aladin) {
        this.aladin = aladin;
        this.INFOMVIEW = Aladin.chaine.getString("MVIEWDESC");
        this.LABEL = Aladin.chaine.getString("MVIEWLABEL");
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(W, 24);
    }

    protected static int getLevel(int m) {
        for (int level = 0; level < MODE.length; ++level) {
            if (MODE[level] != m) continue;
            return level;
        }
        return -1;
    }

    protected static int nextModeView(int m) {
        int level = ViewControl.getLevel(m) + 1;
        if (level >= MODE.length) {
            return -1;
        }
        return MODE[level];
    }

    protected static void moveViewOrder(ViewSimple[] v, int s, int t, boolean flagCopy) {
        v[s].copyIn(v[t]);
        if (!flagCopy) {
            v[s].free();
        }
        ViewControl.setGoodViewNumber(v);
    }

    protected static void setGoodViewNumber(ViewSimple[] v) {
        for (int i = 0; i < 16; ++i) {
            v[i].n = i;
        }
    }

    protected int getNbView(int mode) {
        return mode == 3 || mode == 5 ? 2 : mode;
    }

    protected int getNbLig() {
        return this.getNbLig(this.modeView);
    }

    protected int getNbLig(int mode) {
        if (mode == 3) {
            return 1;
        }
        if (mode == 2 || mode == 5) {
            return 2;
        }
        return (int)Math.sqrt(mode);
    }

    protected int getNbCol() {
        return this.getNbCol(this.modeView);
    }

    protected int getNbCol(int mode) {
        if (mode == 3) {
            return 2;
        }
        if (mode == 2 || mode == 5) {
            return 1;
        }
        return (int)Math.sqrt(mode);
    }

    private void drawLogo(Graphics g) {
        g.setColor(Aladin.COLOR_MAINPANEL_BACKGROUND);
        g.fillRect(0, 0, W, 24);
        for (int i = 0; i < MODE.length; ++i) {
            int mode = MODE[i];
            boolean down = this.modeView == mode;
            boolean in = !down && this.nMode == i;
            int nlig = this.getNbLig(mode);
            int ncol = this.getNbCol(mode);
            int mw = 12 / ncol;
            int mh = 12 / nlig;
            int w = 12 / ncol - 2;
            int h = 12 / nlig - 2;
            for (int j = 0; j < ncol; ++j) {
                for (int k = 0; k < nlig; ++k) {
                    Color fg;
                    int d;
                    int m;
                    int x = 5 + i * 14 + j * mw;
                    int y = 2 + k * mh;
                    int n = mode != 5 ? 0 : (m = k == 0 ? h / 2 : -h / 2);
                    int n2 = mode != 5 ? 0 : (d = k == 0 ? 0 : h / 2);
                    Color color = !this.enabled ? Aladin.COLOR_CONTROL_FOREGROUND_UNAVAILABLE : (fg = down ? Aladin.COLOR_ICON_ACTIVATED : Aladin.COLOR_CONTROL_FOREGROUND);
                    if (this.enabled && in) {
                        fg = fg.brighter();
                    }
                    g.setColor(fg);
                    g.drawLine(x, y + d, x + w, y + d);
                    g.drawLine(x, y + d, x, y + d + h + m);
                    g.drawLine(x + w, y + d, x + w, y + d + h + m);
                    g.drawLine(x, y + d + h + m, x + w, y + d + h + m);
                }
            }
        }
        g.setColor(!this.enabled ? Aladin.COLOR_CONTROL_FOREGROUND_UNAVAILABLE : Aladin.COLOR_CONTROL_FOREGROUND);
        g.setFont(Aladin.SPLAIN);
        g.drawString(this.LABEL, (W + 6) / 2 - g.getFontMetrics().stringWidth(this.LABEL) / 2, 22);
    }

    private void computeModeView(int x) {
        this.modeView = MODE[this.getN(x)];
    }

    private int getN(int x) {
        int n = x / (W / MODE.length);
        if (n >= MODE.length) {
            n = MODE.length - 1;
        }
        return n;
    }

    protected void setModeView(int m) {
        this.modeView = m;
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.aladin.inHelp) {
            this.aladin.help.setText(this.Help());
            return;
        }
        Aladin.makeCursor(this, 2);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.timerTip != null) {
            this.timerTip.stop();
            this.timerTip = null;
        }
        Aladin.makeCursor(this, 0);
        this.nMode = -1;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.aladin.inHelp) {
            return;
        }
        this.aladin.endMsg();
        this.computeModeView(e.getX());
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.aladin.inHelp) {
            this.aladin.helpOff();
            return;
        }
        Aladin.makeCursor(this, 1);
        this.computeModeView(e.getX());
        this.aladin.view.setModeView(this.modeView);
        this.aladin.console.printCommand("modeview " + this.modeView);
        this.aladin.toolBox.toolMode();
        Aladin.makeCursor(this, 0);
        this.repaint();
    }

    private void showTip() {
        this.aladin.configuration.showHelpIfOk("ViewControl.HELP");
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.aladin.inHelp) {
            return;
        }
        if (this.timerTip == null) {
            this.timerTip = new Timer(6000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ViewControl.this.showTip();
                }
            });
        }
        this.timerTip.restart();
        int n = this.getN(e.getX());
        if (n != this.nMode) {
            this.nMode = n;
            this.repaint();
        }
        Util.toolTip(this, n == -2 ? this.INFOSYNC : this.INFOMVIEW);
    }

    @Override
    public void paintComponent(Graphics gr) {
        this.enabled = !this.aladin.msgOn;
        this.drawLogo(gr);
    }

    protected String Help() {
        return Aladin.chaine.getString("ViewControl.HELP");
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }
}

