/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.GluApp;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.Border;

public class VOToolDescription
extends JPanel {
    private static String INSTITUTE;
    private static String VERSION;
    private static String URL;
    private static String STATE;
    private static String COPYRIGHT;
    private static String SYSTEM;
    private static String DIR;
    private static String INSTALL;
    private static String[] MODEINSTALL;
    private Aladin aladin;
    private EventListener listener;
    protected GluApp vo;
    private boolean editable;
    private MyLabel name;
    private MyLabel institute;
    private MyLabel version;
    private MyLabel right;
    private MyLabel doc;
    private MyLabel install;
    private MyLabel system;
    private MyLabel dir;
    private JTextArea descr;
    private JCheckBox state;
    protected Timer timer;
    private JButton browse;
    private static final Dimension DIM;
    protected int modeB = 0;
    private static Color BG;

    protected VOToolDescription(Aladin a, EventListener listener) {
        this.aladin = a;
        this.listener = listener;
        INSTITUTE = "Origin";
        VERSION = "Version";
        STATE = "Available in the Aladin menu";
        URL = "Documentation";
        COPYRIGHT = "Copyright";
        SYSTEM = "Command line";
        DIR = "Running directory";
        INSTALL = "Install. method";
        MODEINSTALL = new String[]{"Local", "Java jar package", "Web download page", "Java Webstart (no installation)", "Java Applet (no installation)"};
        this.createPanel();
        this.timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VOToolDescription.this.downloading();
            }
        });
        this.timer.setRepeats(true);
        this.editable = false;
    }

    private String getInfo(String s) {
        if (s == null || s.trim().length() == 0) {
            return "";
        }
        return s;
    }

    private void createPanel() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(1, 3, 1, 3);
        c.anchor = 17;
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.anchor = 17;
        c.insets.top += 5;
        c.insets.bottom += 10;
        MyLabel m = this.name = new MyLabel(this.listener);
        p.add((Component)this.name, c);
        m.setFont(m.getFont().deriveFont(1, m.getFont().getSize2D() + 3.0f));
        m.setForeground(Aladin.COLOR_GREEN);
        c.insets.top -= 5;
        c.insets.bottom -= 10;
        c.gridx = 0;
        ++c.gridy;
        JLabel l = new JLabel(INSTITUTE + " : ");
        p.add((Component)l, c);
        l.setFont(l.getFont().deriveFont(2));
        ++c.gridx;
        this.institute = new MyLabel(this.listener);
        p.add((Component)this.institute, c);
        c.gridx = 0;
        ++c.gridy;
        l = new JLabel(COPYRIGHT + " : ");
        p.add((Component)l, c);
        l.setFont(l.getFont().deriveFont(2));
        ++c.gridx;
        m = this.right = new MyLabel(this.listener);
        p.add((Component)this.right, c);
        c.gridx = 0;
        ++c.gridy;
        l = new JLabel(URL + " : ");
        p.add((Component)l, c);
        l.setFont(l.getFont().deriveFont(2));
        ++c.gridx;
        m = this.doc = new MyLabel(this.listener);
        p.add((Component)this.doc, c);
        m.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (VOToolDescription.this.doc.getToolTipText() == null) {
                    return;
                }
                ((VOToolDescription)VOToolDescription.this).aladin.glu.showDocument("Http", ((JLabel)e.getSource()).getToolTipText(), true);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (VOToolDescription.this.doc.getToolTipText() == null) {
                    return;
                }
                VOToolDescription.this.doc.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (VOToolDescription.this.doc.getToolTipText() == null) {
                    return;
                }
                VOToolDescription.this.doc.setCursor(Cursor.getDefaultCursor());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (VOToolDescription.this.doc.getToolTipText() == null) {
                    return;
                }
                VOToolDescription.this.doc.setForeground(new Color(128, 0, 128));
            }
        });
        c.gridx = 0;
        ++c.gridy;
        c.fill = 1;
        c.gridwidth = 2;
        c.insets.top += 5;
        c.weighty = 1.0;
        c.weightx = 1.0;
        JTextArea t = this.descr = new JTextArea();
        p.add((Component)new JScrollPane(this.descr), c);
        t.setFont(Aladin.PLAIN);
        t.setWrapStyleWord(true);
        t.setLineWrap(true);
        t.setEditable(false);
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.fill = 2;
        c.gridwidth = 1;
        c.insets.top -= 5;
        c.gridx = 0;
        ++c.gridy;
        c.insets.top += 10;
        l = new JLabel(VERSION + " : ");
        p.add((Component)l, c);
        l.setFont(l.getFont().deriveFont(2));
        ++c.gridx;
        m = this.version = new MyLabel(this.listener);
        p.add((Component)this.version, c);
        m.setFont(m.getFont().deriveFont(1));
        c.insets.top -= 10;
        c.gridx = 0;
        ++c.gridy;
        l = new JLabel(INSTALL + " : ");
        p.add((Component)l, c);
        l.setFont(l.getFont().deriveFont(2));
        ++c.gridx;
        m = this.install = new MyLabel(this.listener);
        p.add((Component)this.install, c);
        c.gridx = 0;
        ++c.gridy;
        l = new JLabel(DIR + " : ");
        p.add((Component)l, c);
        l.setFont(l.getFont().deriveFont(2));
        ++c.gridx;
        JPanel p1 = new JPanel(new BorderLayout());
        this.dir = new MyLabel(this.listener);
        p1.add((Component)this.dir, "Center");
        JButton b = this.browse = new JButton("Browse");
        p1.add((Component)this.browse, "East");
        b.setEnabled(false);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VOToolDescription.this.dirBrowser();
            }
        });
        p.add((Component)p1, c);
        c.gridx = 0;
        ++c.gridy;
        l = new JLabel(SYSTEM + " : ");
        p.add((Component)l, c);
        l.setFont(l.getFont().deriveFont(2));
        ++c.gridx;
        this.system = new MyLabel(50, this.listener);
        p.add((Component)this.system, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.anchor = 10;
        this.state = new JCheckBox(STATE);
        p.add((Component)this.state, c);
        this.state.setFont(this.state.getFont().deriveFont(1));
        this.state.addActionListener((ActionListener)this.listener);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)p, "Center");
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    @Override
    public Dimension getPreferredSize() {
        return DIM;
    }

    private void dirBrowser() {
        FileDialog fd = new FileDialog((Frame)this.aladin.dialog, "Running directory selection");
        if (this.dir != null) {
            fd.setDirectory(this.dir.getText());
        }
        fd.setFile("-");
        fd.setVisible(true);
        String dir = fd.getDirectory();
        String name = fd.getFile();
        if (name != null && name.equals("-")) {
            name = "";
        }
        String t = (dir == null ? "" : dir) + (name == null ? "" : name);
        this.dir.setText(t);
        this.aladin.frameVOTool.apply.setEnabled(this.hasBeenChanged());
    }

    protected boolean hasBeenChanged() {
        if (this.vo == null) {
            return false;
        }
        if (this.editable && this.name.getText().trim().length() > 0) {
            return true;
        }
        if (this.vo.isActivated() != this.state.isSelected()) {
            return true;
        }
        if (this.system.hasBeenEdited()) {
            return true;
        }
        return this.dir.hasBeenEdited();
    }

    protected GluApp apply() {
        this.vo.activated = this.state.isSelected() ? "Yes" : "No";
        String s = this.dir.getText().trim();
        this.vo.dir = s.length() > 0 ? s : null;
        s = this.system.getText().trim();
        String cmd = this.vo.getJavaCommand();
        if (cmd != null && cmd.equals(s)) {
            s = "";
        }
        this.vo.system = s.length() > 0 ? s : null;
        if (this.editable) {
            s = this.name.getText().trim();
            this.vo.aladinLabel = s.length() > 0 ? s : null;
            s = this.institute.getText().trim();
            this.vo.institute = s.length() > 0 ? s : null;
            s = this.version.getText().trim();
            this.vo.releaseNumber = s.length() > 0 ? s : "0";
            s = this.right.getText().trim();
            this.vo.copyright = s.length() > 0 ? s : null;
            this.setEditable(false);
        }
        this.setVOtool(this.vo);
        return this.vo;
    }

    private void downloading() {
        String dots = this.modeB == 3 ? "..." : (this.modeB == 2 ? ".." : (this.modeB == 1 ? "." : ""));
        ++this.modeB;
        if (this.modeB > 3) {
            this.modeB = 0;
        }
        String s = (this.vo.nextNumber != null ? this.vo.nextNumber : this.vo.releaseNumber) + " downloading (" + this.vo.downloading / 1024L + " KB)" + dots;
        this.version.setText(s);
    }

    protected void setEditable(boolean flag) {
        this.editable = flag;
        this.name.setEditable(flag);
        this.institute.setEditable(flag);
        this.version.setEditable(flag);
        this.right.setEditable(flag);
        this.descr.setEditable(flag);
    }

    protected void setVOtool(GluApp vo) {
        String s;
        this.vo = vo;
        int mode = vo == null ? 0 : vo.getInstallMode();
        this.name.setText(vo == null ? "" : this.getInfo(vo.aladinLabel));
        this.institute.setText(vo == null ? "" : this.getInfo(vo.institute));
        this.version.setForeground(Color.black);
        if (vo == null) {
            s = null;
            this.setEditable(false);
        } else if (this.editable) {
            s = this.getInfo(vo.releaseNumber);
        } else if (vo.downloading != -1L) {
            s = "";
            this.version.setForeground(Color.orange.darker());
            this.timer.start();
        } else {
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
            if (vo.releaseNumber == null) {
                s = "";
                this.version.setForeground(Color.black);
            } else if (vo.canBeRun()) {
                s = this.getInfo(vo.releaseNumber + (mode == 3 || mode == 4 ? "" : " installed"));
                this.version.setForeground(Aladin.COLOR_GREEN);
                if (vo.nextNumber != null) {
                    s = s + " - new available version: " + vo.nextNumber;
                    this.version.setForeground(Color.orange.darker());
                }
            } else {
                s = vo.nextNumber != null ? this.getInfo(vo.nextNumber + " not installed") : this.getInfo(vo.releaseNumber + " not installed");
                this.version.setForeground(Color.red);
            }
        }
        this.version.setText(s);
        this.install.setText(vo == null ? "" : MODEINSTALL[mode]);
        if (mode == 4 || mode == 3) {
            this.dir.setMemo(" --");
            this.dir.setEditable(false);
            this.system.setMemo(" -- ");
            this.system.setEditable(false);
            this.browse.setEnabled(false);
        } else {
            this.dir.setMemo(vo.jarUrl != null ? this.aladin.getVOPath() : "", vo == null ? null : vo.dir);
            this.system.setMemo(vo.javaParam != null ? vo.getJavaCommand() : "", vo == null ? "" : vo.getCommand());
            this.browse.setEnabled(true);
        }
        this.descr.setText(vo == null ? "" : this.getInfo(vo.verboseDescr != null ? vo.verboseDescr : vo.description));
        this.descr.setCaretPosition(0);
        this.right.setText(vo == null ? "" : this.getInfo(vo.copyright));
        if (vo == null || vo.docUrl == null) {
            this.doc.setText("");
        } else if (vo.docUrl != null) {
            this.doc.setForeground(Color.blue);
            Util.toolTip(this.doc, vo.docUrl);
            this.doc.setText(VOToolDescription.cut(vo.docUrl, 60));
        } else {
            Util.toolTip(this.doc, null);
        }
        this.state.setSelected(vo != null && vo.isActivated());
        this.state.setEnabled(vo != null && vo.canBeRun());
    }

    static String cut(String s, int m) {
        int n = s.length();
        if (n <= m) {
            return s;
        }
        return s.substring(0, m - 2) + "...";
    }

    static {
        DIM = new Dimension(550, 350);
        BG = new JLabel().getBackground();
    }

    class MyLabel
    extends JTextField
    implements KeyListener {
        private Border border;
        private Border emptyBorder;
        private String memo;
        private String init;
        private boolean listen;

        MyLabel(EventListener listener) {
            this.emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            this.listen = false;
            this.suite(listener);
        }

        MyLabel(int n, EventListener listener) {
            super(n);
            this.emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
            this.listen = false;
            this.suite(listener);
        }

        private void suite(EventListener listener) {
            this.border = this.getBorder();
            this.setEditable(false);
            this.addKeyListener((KeyListener)listener);
        }

        protected void setMemo(String memo) {
            this.setMemo(memo, null);
        }

        protected void setMemo(String memo, String init) {
            this.memo = memo;
            this.init = init == null ? memo : init;
            this.setText(this.init);
            this.setEditable(true);
            if (!this.listen) {
                this.addKeyListener(this);
                this.listen = true;
            }
        }

        public boolean hasBeenChanged() {
            if (!this.isEditable() || this.memo == null) {
                return false;
            }
            return !this.getText().trim().equals(this.memo);
        }

        public boolean hasBeenEdited() {
            if (!this.isEditable() || this.init == null) {
                return false;
            }
            return !this.getText().trim().equals(this.init);
        }

        @Override
        public void setEditable(boolean flag) {
            super.setEditable(flag);
            this.setBackground(flag ? Color.white : BG);
            this.setBorder(flag ? this.border : this.emptyBorder);
            this.setCaretPosition(0);
        }

        @Override
        public void setText(String s) {
            super.setText(s);
            if (this.memo != null || this.init != null) {
                this.testChange();
            }
        }

        private void testChange() {
            Color c;
            Color color = c = this.hasBeenChanged() || this.hasBeenEdited() ? Color.black : Color.gray;
            if (this.getForeground() != c) {
                this.setForeground(c);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.testChange();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

