/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.JoinFacade;
import cds.aladin.Server;
import cds.aladin.TapManager;
import cds.aladin.UploadFacade;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Map;
import javax.swing.JList;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

class UploadTablesRenderer
extends BasicComboBoxRenderer {
    private static final long serialVersionUID = -4372535217338044431L;
    private static UploadTablesRenderer instance;
    UploadFacade uploadFacade;

    public UploadTablesRenderer(Aladin aladin) {
        this.uploadFacade = TapManager.getInstance(aladin).initUploadFrame();
    }

    public static synchronized UploadTablesRenderer getInstance(Aladin aladin) {
        if (instance == null) {
            instance = new UploadTablesRenderer(aladin);
        }
        return instance;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        String tooltip = null;
        String valueTxt = (String)value;
        String planeName = this.getUploadPlaneName(valueTxt);
        if (planeName != null) {
            valueTxt = "(" + planeName + ") " + valueTxt;
            tooltip = UploadTablesRenderer.getToolTip(planeName, String.valueOf(value));
        }
        this.setText(valueTxt);
        this.setToolTipText(tooltip);
        this.setPreferredSize(new Dimension(320, Server.HAUT));
        return this;
    }

    public String getUploadPlaneName(String uploadTableName) {
        String result = null;
        if (!this.uploadFacade.uploadTableNameDict.isEmpty() && this.uploadFacade.uploadTableNameDict.containsValue(uploadTableName)) {
            for (Map.Entry<String, String> entry : this.uploadFacade.uploadTableNameDict.entrySet()) {
                if (!entry.getValue().equals(uploadTableName)) continue;
                result = entry.getKey();
                break;
            }
        }
        return result;
    }

    public static String getToolTip(String planeName, String name) {
        StringBuffer tooltip = new StringBuffer("<html><p width=\"500\">");
        if (JoinFacade.UPLOADJOINTABLENAMETOOLTIP != null) {
            tooltip.append(String.format(JoinFacade.UPLOADJOINTABLENAMETOOLTIP, planeName, name));
        } else {
            tooltip.append(name).append(" can be used as ").append(name).append(" in your adql query. Click on settings to change the table name.");
        }
        tooltip.append("</p></html>");
        return tooltip.toString();
    }
}

