/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameSimple;
import cds.aladin.MySplitPane;
import cds.aladin.Server;
import cds.aladin.TapManager;
import cds.aladin.UWSJob;
import cds.tools.MultiPartPostOutputStream;
import cds.tools.Util;
import cds.xml.UWSReader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class UWSFacade
implements ActionListener {
    private static UWSFacade instance = null;
    public Aladin aladin;
    public FrameSimple jobControllerGui;
    public MySplitPane asyncPanel;
    private JPanel inSessionAsyncJobsPanel;
    public JPanel jobDetails;
    private ButtonGroup radioGroup;
    private JRadioButton prevJobRadio;
    private List<UWSJob> sessionUWSJobs;
    private JTextField previousSessionJob;
    public JCheckBox deleteOnExit;
    public JButton loadResultsbutton;
    public static String JOBNOTFOUNDMESSAGE;
    public static String JOBERRORTOOLTIP;
    public static String UWSNOJOBMESSAGE;
    public static String CANTSTARTJOB;
    public static String GENERICERROR1LINE;
    public static String STANDARDRESULTSLOAD;
    public static String STANDARDRESULTSLOADTIP;
    public static String UWSASKLOADDEFAULTRESULTS;
    public static String CANTABORTJOB;
    public static String UWSJOBRADIOTOOLTIP;
    public static String JOBCONTROLLERTITLE;
    public static String UWSPANELCURRECTSESSIONTITLE;
    public static String UWSPANELPREVIOUSSESSIONTITLE;
    public static String JOBNOTSELECTED;
    public static String JOBNOTFOUNDGIVENURL;
    public static String NOJOBURLMESSAGE;
    public static String JOBDELETEERRORMESSAGE;
    public static String DELETEONCLOSEBUTTONLABEL;
    public static String UWSMULTIJOBLOADMESSAGE;
    public static String UWSASKTOREMOVENOTFOUNDJOBS;
    public static String UWSASKTOREMOVENOTFOUNDJOBSTITLE;
    public static String ERROR_INCORRECTPROTOCOL;
    public static final int POLLINGDELAY = 4000;
    public static int DELETETIMEOUTTIME;

    public UWSFacade() {
    }

    public UWSFacade(Aladin aladin) {
        this();
        this.aladin = aladin;
    }

    public static synchronized UWSFacade getInstance(Aladin aladin) {
        if (instance == null) {
            instance = new UWSFacade(aladin);
        }
        return instance;
    }

    public static synchronized void fireAsync(Aladin aladin, Server server, String label, String url, Map<String, Object> requestParams, int requestNumber) {
        UWSFacade instance = UWSFacade.getInstance(aladin);
        instance.instantiateGui();
        try {
            URL requestUrl = TapManager.getUrl(url, null, null);
            instance.handleJob(server, label, requestUrl, null, requestParams, false, requestNumber);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public void handleJob(Server server, String label, URL url, String queryString, Map<String, Object> requestParams, boolean doRun, int requestNumber) {
        UWSJob job = null;
        try {
            job = this.createJob(server, label, url, queryString, requestParams, doRun, requestNumber);
            this.addNewJobToGui(job);
            this.refreshGui();
            job.run();
            job.pollForCompletion(server, true, this, requestNumber);
        }
        catch (IOException e) {
            StringBuffer errorMessageToUser = new StringBuffer(GENERICERROR1LINE);
            if (job == null || job.gui == null) {
                errorMessageToUser.append("\n Unable to create job");
            }
            if (queryString != null) {
                errorMessageToUser.append("\n For query: ").append(queryString).append("\n").append(e.getMessage());
            } else {
                errorMessageToUser.append("\n at: ").append(url.toString()).append("\n").append(e.getMessage());
            }
            if (job != null && "Not found ;ERROR_404".equals(job.getCurrentPhase())) {
                if (this.checkIfJobInCache(job)) {
                    Aladin.trace(3, "Job is not found, user did not ask for delete: \n" + job.getLocation().toString());
                    Aladin.error(this.asyncPanel, errorMessageToUser.toString());
                    if (job != null) {
                        job.showAsErroneous();
                    }
                } else if (job != null) {
                    job.resetStatusOnServer();
                }
            } else {
                Aladin.error(this.asyncPanel, errorMessageToUser.toString());
                if (job != null) {
                    job.showAsErroneous();
                }
            }
            if (server != null) {
                server.setStatusForCurrentRequest(requestNumber, 3);
            }
        }
        catch (Exception e) {
            if (job != null) {
                job.showAsErroneous();
            }
            if (server != null) {
                server.setStatusForCurrentRequest(requestNumber, 3);
            }
            Aladin.error(this.asyncPanel, "Error with async job! " + e.getMessage());
        }
    }

    public UWSJob createJob(Server server, String jobLabel, URL requestUrl, String queryString, Map<String, Object> postParams, boolean doRun, int requestNumber) throws Exception {
        UWSJob job;
        block13: {
            job = null;
            HttpURLConnection httpClient = null;
            try {
                Aladin.trace(3, "trying to createJob() uws for:: " + requestUrl.toString());
                MultiPartPostOutputStream.setTmpDir(Aladin.CACHEDIR);
                String boundary = MultiPartPostOutputStream.createBoundary();
                URLConnection urlConn = MultiPartPostOutputStream.createConnection(requestUrl);
                urlConn.setRequestProperty("Accept", "*/*");
                urlConn.setRequestProperty("Content-Type", MultiPartPostOutputStream.getContentType(boundary));
                urlConn.setRequestProperty("Connection", "Keep-Alive");
                urlConn.setRequestProperty("Cache-Control", "no-cache");
                MultiPartPostOutputStream out = new MultiPartPostOutputStream(urlConn.getOutputStream(), boundary);
                if (postParams != null) {
                    for (Map.Entry<String, Object> postParam : postParams.entrySet()) {
                        if (postParam.getValue() instanceof String) {
                            out.writeField(postParam.getKey(), String.valueOf(postParam.getValue()));
                            Aladin.trace(3, "createJob() " + postParam.getKey() + " :: " + String.valueOf(postParam.getValue()));
                            continue;
                        }
                        if (!(postParam.getValue() instanceof File)) continue;
                        out.writeFile(postParam.getKey(), null, (File)postParam.getValue(), false);
                        Aladin.trace(3, "createJob() " + postParam.getKey() + " :: " + (File)postParam.getValue());
                    }
                }
                if (doRun) {
                    out.writeField("PHASE", "RUN");
                    Aladin.trace(3, "createJob() PHASE :: RUN");
                }
                out.close();
                if (!(urlConn instanceof HttpURLConnection)) {
                    throw new Exception("Error url is not http!");
                }
                httpClient = (HttpURLConnection)urlConn;
                httpClient.setInstanceFollowRedirects(false);
                if (httpClient.getResponseCode() == 303) {
                    String location = httpClient.getHeaderField("Location");
                    job = new UWSJob(this, jobLabel, new URL(location));
                    UWSFacade.populateJob(job.getLocation().openStream(), job);
                    if (postParams != null && postParams.containsKey("QUERY")) {
                        job.setQuery((String)postParams.get("QUERY"));
                    }
                    job.setDeleteOnExit(true);
                    job.setInitialGui();
                    break block13;
                }
                String errorMessage = Util.handleErrorResponseForTapAndDL(requestUrl, httpClient);
                Aladin.trace(3, "createJob() ERROR !! did not get a url redirect. \n" + errorMessage);
                throw new Exception(errorMessage);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
            finally {
                if (httpClient != null) {
                    httpClient.disconnect();
                }
            }
        }
        Aladin.trace(3, "In createJob. Job phase is:" + job.getCurrentPhase());
        job.server = server;
        job.requestNumber = requestNumber;
        return job;
    }

    public synchronized void addNewJobToGui(UWSJob job) {
        if (this.sessionUWSJobs == null) {
            this.sessionUWSJobs = new ArrayList<UWSJob>();
            this.inSessionAsyncJobsPanel.removeAll();
        }
        this.sessionUWSJobs.add(job);
        this.inSessionAsyncJobsPanel.add(job.gui);
        this.radioGroup.add(job.gui);
    }

    public void removeJobUpdateGui(UWSJob job) {
        if (this.sessionUWSJobs != null && this.sessionUWSJobs.contains(job)) {
            this.sessionUWSJobs.remove(job);
            if (job.gui.isSelected()) {
                if (this.sessionUWSJobs.size() > 0) {
                    this.sessionUWSJobs.get((int)0).gui.setEnabled(true);
                    this.sessionUWSJobs.get((int)0).gui.doClick();
                } else {
                    this.clearJobsummary();
                    this.deleteOnExit.setVisible(false);
                }
            }
            this.inSessionAsyncJobsPanel.remove(job.gui);
            this.inSessionAsyncJobsPanel.revalidate();
            this.inSessionAsyncJobsPanel.repaint();
        }
    }

    public boolean checkIfJobInCache(UWSJob job) {
        boolean result = false;
        result = this.sessionUWSJobs != null && this.sessionUWSJobs.contains(job);
        return result;
    }

    public synchronized void refreshGui() {
        this.asyncPanel.revalidate();
        this.asyncPanel.repaint();
    }

    public void clearJobsummary() {
        this.jobDetails.removeAll();
        this.jobDetails.revalidate();
        this.jobDetails.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringBuffer getResponse(InputStream in) {
        BufferedReader buffReader = null;
        StringBuffer result = null;
        try {
            String response;
            buffReader = new BufferedReader(new InputStreamReader(in));
            result = new StringBuffer();
            while ((response = buffReader.readLine()) != null) {
                result.append(response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        finally {
            if (buffReader != null) {
                try {
                    buffReader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static StringBuffer getResponse(URL url) {
        StringBuffer result = null;
        try {
            result = UWSFacade.getResponse(Util.openStream(url));
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public void checkPhase(UWSJob job) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void populateJob(InputStream inputStream, UWSJob job) throws Exception {
        UWSReader uwsReader = new UWSReader();
        UWSJob uWSJob = job;
        synchronized (uWSJob) {
            uwsReader.load(inputStream, job);
            inputStream.close();
            Aladin.trace(3, "in populateJob phase is:" + job.getCurrentPhase() + " results" + job.getResults());
        }
    }

    public static void getsetPhase(UWSJob uwsJob) throws IOException, URISyntaxException {
        URL phaseUrl = TapManager.getUrl(uwsJob.getLocation().toString(), null, "phase");
        StringBuffer result = UWSFacade.getResponse(phaseUrl);
        if (result != null) {
            uwsJob.setCurrentPhase(result.toString().toUpperCase());
        }
    }

    public void deleteJob(UWSJob job, boolean updateModelAndGui) throws IOException, Exception {
        block15: {
            HttpURLConnection httpConn = null;
            try {
                int option;
                URLConnection conn = job.getLocation().openConnection();
                if (!(conn instanceof HttpURLConnection)) break block15;
                httpConn = (HttpURLConnection)conn;
                httpConn.setInstanceFollowRedirects(false);
                httpConn.setRequestMethod("DELETE");
                httpConn.setConnectTimeout(DELETETIMEOUTTIME);
                httpConn.connect();
                if (httpConn.getResponseCode() == 303) {
                    if (updateModelAndGui) {
                        this.removeJobUpdateGui(job);
                    }
                    break block15;
                }
                if (httpConn.getResponseCode() == 404 && (option = JOptionPane.showConfirmDialog(this.asyncPanel, UWSASKTOREMOVENOTFOUNDJOBS, UWSASKTOREMOVENOTFOUNDJOBSTITLE, 2)) == 0) {
                    this.removeJobUpdateGui(job);
                    return;
                }
                StringBuffer errorMessage = new StringBuffer(JOBDELETEERRORMESSAGE);
                errorMessage.append("\n").append(Util.handleErrorResponseForTapAndDL(job.getLocation(), httpConn));
                Aladin.trace(3, "Error when deleting job!" + errorMessage.toString());
                throw new IOException(errorMessage.toString());
            }
            catch (ProtocolException e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                throw e;
            }
            catch (IOException e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                throw e;
            }
            catch (Exception e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                throw e;
            }
            finally {
                if (httpConn != null) {
                    httpConn.disconnect();
                }
            }
        }
    }

    public MySplitPane instantiateGui() {
        if (this.jobControllerGui == null) {
            this.jobControllerGui = new FrameSimple(this.aladin);
        }
        if (this.asyncPanel == null) {
            JPanel topPanel = new JPanel(new GridBagLayout());
            if (this.inSessionAsyncJobsPanel == null) {
                this.inSessionAsyncJobsPanel = new JPanel();
                if (this.sessionUWSJobs == null) {
                    JLabel infoLabel = new JLabel(UWSNOJOBMESSAGE);
                    infoLabel.setFont(Aladin.LITALIC);
                    this.inSessionAsyncJobsPanel.add(infoLabel);
                }
                this.inSessionAsyncJobsPanel.setBackground(Aladin.COLOR_CONTROL_BACKGROUND);
                this.inSessionAsyncJobsPanel.setLayout(new BoxLayout(this.inSessionAsyncJobsPanel, 1));
            }
            this.radioGroup = new ButtonGroup();
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 1;
            c.weightx = 1.0;
            JScrollPane jobsScroll = new JScrollPane(this.inSessionAsyncJobsPanel);
            jobsScroll.setBackground(Aladin.BLUE);
            jobsScroll.getVerticalScrollBar().setUnitIncrement(5);
            jobsScroll.setMinimumSize(new Dimension(200, 100));
            c.weighty = 0.48;
            c.fill = 1;
            c.insets = new Insets(4, 7, 0, 4);
            jobsScroll.setBorder(BorderFactory.createTitledBorder(UWSPANELCURRECTSESSIONTITLE));
            topPanel.add((Component)jobsScroll, c);
            JPanel searchPanel = new JPanel();
            searchPanel.setBackground(Aladin.BLUE);
            searchPanel.setName("searchPanel");
            this.prevJobRadio = new JRadioButton("Job URL");
            searchPanel.setLayout(new BoxLayout(searchPanel, 0));
            this.radioGroup.add(this.prevJobRadio);
            searchPanel.add(this.prevJobRadio);
            this.prevJobRadio.addActionListener(this);
            this.previousSessionJob = new JTextField(25);
            searchPanel.add(this.previousSessionJob);
            JButton button = new JButton("GO");
            button.setActionCommand("GETPREVIOUSSESSIONJOB");
            button.addActionListener(this);
            searchPanel.add(button);
            ++c.gridy;
            c.weighty = 0.01;
            c.insets = new Insets(7, 7, 0, 4);
            c.fill = 2;
            searchPanel.setBorder(BorderFactory.createTitledBorder(UWSPANELPREVIOUSSESSIONTITLE));
            topPanel.add((Component)searchPanel, c);
            JPanel actionPanel = new JPanel();
            actionPanel.setBackground(Aladin.COLOR_CONTROL_BACKGROUND);
            this.loadResultsbutton = new JButton(STANDARDRESULTSLOAD);
            this.loadResultsbutton.setToolTipText(STANDARDRESULTSLOADTIP);
            this.loadResultsbutton.addActionListener(this);
            this.loadResultsbutton.setActionCommand("LOADDEFAULTTAPRESULT");
            this.loadResultsbutton.setVisible(false);
            actionPanel.add(this.loadResultsbutton);
            button = new JButton("ABORT");
            button.setActionCommand("ABORTJOB");
            button.addActionListener(this);
            actionPanel.add(button);
            button = new JButton("DELETE");
            button.setActionCommand("DELETEJOB");
            button.addActionListener(this);
            actionPanel.add(button);
            this.deleteOnExit = new JCheckBox(DELETEONCLOSEBUTTONLABEL);
            this.deleteOnExit.setActionCommand("DELETEONEXIT");
            this.deleteOnExit.addActionListener(this);
            this.deleteOnExit.setSelected(true);
            this.deleteOnExit.setVisible(false);
            actionPanel.add(this.deleteOnExit);
            ++c.gridy;
            topPanel.add((Component)actionPanel, c);
            this.jobDetails = new JPanel();
            jobsScroll = new JScrollPane(this.jobDetails);
            jobsScroll.setBackground(Aladin.BLUE);
            this.jobDetails.setVisible(false);
            this.jobDetails.setBorder(BorderFactory.createTitledBorder("Job details:"));
            this.asyncPanel = new MySplitPane(this.aladin, 0, topPanel, jobsScroll, 1);
            this.asyncPanel.setBackground(Aladin.COLOR_CONTROL_BACKGROUND);
            this.asyncPanel.setFont(Aladin.PLAIN);
        }
        return this.asyncPanel;
    }

    public UWSJob getQuote(URL url) {
        return null;
    }

    public void authenticate() {
    }

    public void getResults() {
    }

    public UWSJob getJobFromCache(String url) {
        UWSJob result = null;
        if (this.sessionUWSJobs != null) {
            for (UWSJob uwsJob : this.sessionUWSJobs) {
                if (!uwsJob.getLocation().toString().equalsIgnoreCase(url)) continue;
                result = uwsJob;
                break;
            }
        }
        return result;
    }

    public UWSJob getSelectedInSessionJob() {
        UWSJob selectedJob = null;
        for (UWSJob uwsJob : this.sessionUWSJobs) {
            if (!uwsJob.gui.isSelected()) continue;
            selectedJob = uwsJob;
        }
        return selectedJob;
    }

    public void deleteAllSetToDeleteJobs() {
        if (this.sessionUWSJobs != null) {
            for (UWSJob uwsJob : this.sessionUWSJobs) {
                if (!uwsJob.isDeleteOnExit()) continue;
                try {
                    this.deleteJob(uwsJob, false);
                }
                catch (Exception exception) {}
            }
        }
    }

    public void loadResults(UWSJob uwsJob, String chosen, int requestNumber, Server server) throws MalformedURLException, IOException, Exception {
        if ("COMPLETED".equals(uwsJob.getCurrentPhase())) {
            String resultsUrl = null;
            if (chosen != null) {
                int option;
                resultsUrl = this.getResultsPath(uwsJob, chosen);
                if (resultsUrl == null && (option = JOptionPane.showConfirmDialog(this.asyncPanel, UWSASKLOADDEFAULTRESULTS)) == 0) {
                    resultsUrl = uwsJob.getDefaultResultsUrl();
                }
            } else {
                resultsUrl = uwsJob.getIfSingleResult();
                if (resultsUrl == null) {
                    this.showAsyncPanel();
                    Aladin.info(this.asyncPanel, UWSMULTIJOBLOADMESSAGE);
                    return;
                }
                resultsUrl = this.getResultsPath(uwsJob, resultsUrl);
            }
            URL urlToLoad = TapManager.getUrl(resultsUrl, null, null);
            try {
                TapManager.handleResponse(this.aladin, urlToLoad, null, uwsJob.getServerLabel(), server, uwsJob.getQuery(), requestNumber);
            }
            catch (IOException e) {
                this.showAsyncPanel();
                throw e;
            }
        }
    }

    public String getResultsPath(UWSJob uwsJob, String resultToLoad) {
        String resultsUrlString = null;
        URL resultsUrl = null;
        if (resultToLoad.startsWith("http") || resultToLoad.startsWith("https")) {
            resultsUrl = this.validateUrlSimple(resultToLoad);
        } else {
            try {
                resultsUrl = new URL(uwsJob.getLocation().getProtocol(), uwsJob.getLocation().getHost(), uwsJob.getLocation().getPort(), URLDecoder.decode(resultToLoad, "utf-8"));
                resultsUrl = this.validateUrlSimple(resultsUrl);
                if (resultsUrl == null) {
                    resultsUrl = new URL(uwsJob.getLocation().getProtocol(), uwsJob.getLocation().getHost(), uwsJob.getLocation().getPort(), resultToLoad);
                    resultsUrl = this.validateUrlSimple(resultsUrl);
                }
            }
            catch (MalformedURLException e) {
                Aladin.trace(3, e.getMessage());
            }
            catch (UnsupportedEncodingException e) {
                Aladin.trace(3, e.getMessage());
            }
        }
        if (resultsUrl != null) {
            resultsUrlString = resultsUrl.toString();
        }
        return resultsUrlString;
    }

    public URL validateUrlSimple(String resultToLoad) {
        URL resultsUrl = this.validateUrlSimple(resultToLoad, true);
        if (resultsUrl == null) {
            resultsUrl = this.validateUrlSimple(resultToLoad, false);
        }
        return resultsUrl;
    }

    public URL validateUrlSimple(String resultToLoad, boolean decode) {
        URL resultsUrl = null;
        try {
            resultsUrl = decode ? new URL(URLDecoder.decode(resultToLoad, "utf-8")) : new URL(resultToLoad);
            resultsUrl = this.validateUrlSimple(resultsUrl);
            if (resultsUrl != null && resultsUrl.getAuthority() == null) {
                Aladin.trace(3, "no authority " + resultsUrl);
                resultsUrl = null;
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return resultsUrl;
    }

    public URL validateUrlSimple(URL resultsUrl) {
        try {
            if (resultsUrl != null) {
                resultsUrl.toURI();
                if (resultsUrl.getAuthority() == null) {
                    Aladin.trace(3, "no authority " + resultsUrl);
                    resultsUrl = null;
                }
            }
        }
        catch (URISyntaxException e) {
            Aladin.trace(3, "URISyntaxException when trying to decode" + e.getMessage());
            resultsUrl = null;
        }
        return resultsUrl;
    }

    public UWSJob processJobSelection(boolean loadJobSummary) throws Exception {
        UWSJob selectedJob = null;
        try {
            if (this.prevJobRadio.isSelected()) {
                if (this.previousSessionJob.getText().isEmpty()) {
                    throw new Exception(NOJOBURLMESSAGE);
                }
                URL jobUrl = new URL(this.previousSessionJob.getText());
                selectedJob = this.getJobFromCache(jobUrl.toString());
                if (selectedJob == null) {
                    selectedJob = new UWSJob(this, "", jobUrl);
                    UWSFacade.populateJob(Util.openStreamForTapAndDL(selectedJob.getLocation(), null, true, 10000), selectedJob);
                }
                if (loadJobSummary) {
                    selectedJob.setJobDetailsPanel();
                    if (this.sessionUWSJobs == null) {
                        this.asyncPanel.revalidate();
                        this.asyncPanel.repaint();
                    }
                }
            } else {
                selectedJob = this.getSelectedInSessionJob();
            }
            if (selectedJob == null) {
                throw new Exception(JOBNOTSELECTED);
            }
        }
        catch (MalformedURLException e1) {
            if (Aladin.levelTrace >= 3) {
                e1.printStackTrace();
            }
            throw e1;
        }
        catch (IOException e1) {
            if (Aladin.levelTrace >= 3) {
                e1.printStackTrace();
            }
            throw new IOException(JOBNOTFOUNDGIVENURL + " \n" + e1.getMessage());
        }
        return selectedJob;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block44: {
            Object o = e.getSource();
            if (o instanceof JRadioButton) {
                if (this.prevJobRadio.isSelected()) {
                    if (this.loadResultsbutton != null) {
                        this.loadResultsbutton.setVisible(false);
                    }
                    if (!this.previousSessionJob.getText().isEmpty()) {
                        try {
                            URL jobUrl = new URL(this.previousSessionJob.getText());
                            UWSJob selectedJob = this.getJobFromCache(jobUrl.toString());
                            if (selectedJob != null) {
                                selectedJob.setJobDetailsPanel();
                                if ("COMPLETED".equals(selectedJob.getCurrentPhase())) {
                                    this.loadResultsbutton.setVisible(true);
                                }
                                if (this.sessionUWSJobs == null) {
                                    this.asyncPanel.revalidate();
                                    this.asyncPanel.repaint();
                                }
                            }
                        }
                        catch (Exception e1) {
                            // empty catch block
                        }
                    }
                    this.deleteOnExit.setVisible(false);
                }
            } else if (o instanceof JButton) {
                String action = ((JButton)o).getActionCommand();
                if (action.equals("GETPREVIOUSSESSIONJOB")) {
                    this.prevJobRadio.setSelected(true);
                    this.deleteOnExit.setVisible(false);
                    if (this.loadResultsbutton != null) {
                        this.loadResultsbutton.setVisible(false);
                    }
                    try {
                        UWSJob selectedJob = this.processJobSelection(true);
                        if (selectedJob != null && "COMPLETED".equals(selectedJob.getCurrentPhase())) {
                            this.loadResultsbutton.setVisible(true);
                        }
                    }
                    catch (Exception e1) {
                        Aladin.error(this.asyncPanel, e1.getMessage());
                    }
                } else if (action.equals("LOADDEFAULTTAPRESULT")) {
                    try {
                        UWSJob selectedJob = this.processJobSelection(true);
                        String resultsUrl = selectedJob.getDefaultResultsUrl();
                        this.loadResults(selectedJob, resultsUrl, -1, null);
                    }
                    catch (MalformedURLException e1) {
                        Aladin.error(this.asyncPanel, "Error in processing results url!");
                    }
                    catch (IOException e1) {
                        Aladin.error(this.asyncPanel, "Unable to get the job information, please try again!");
                    }
                    catch (Exception e1) {
                        Aladin.error(this.asyncPanel, e1.getMessage());
                    }
                } else {
                    if (action.equals("DELETEJOB")) {
                        UWSJob selectedJob = null;
                        try {
                            selectedJob = this.processJobSelection(false);
                            this.deleteJob(selectedJob, true);
                            if (this.prevJobRadio.isSelected()) {
                                Aladin.info(this.asyncPanel, selectedJob.getJobId() + " -job sucessfully deleted");
                            }
                            selectedJob.resetStatusOnServer();
                        }
                        catch (ProtocolException e1) {
                            Aladin.error(this.asyncPanel, e1.getMessage());
                            if (selectedJob != null) {
                                selectedJob.showErrorOnServer();
                            }
                            break block44;
                        }
                        catch (IOException e1) {
                            Aladin.error(this.asyncPanel, e1.getMessage());
                            if (selectedJob != null) {
                                selectedJob.showErrorOnServer();
                            }
                            break block44;
                        }
                        catch (Exception e1) {
                            Aladin.error(this.asyncPanel, e1.getMessage());
                            if (selectedJob != null) {
                                selectedJob.showErrorOnServer();
                            }
                            break block44;
                        }
                    }
                    if (action.equals("ABORTJOB")) {
                        UWSJob selectedJob = null;
                        try {
                            selectedJob = this.processJobSelection(false);
                            if (selectedJob.canAbort()) {
                                selectedJob.abortJob();
                                selectedJob.resetStatusOnServer();
                                if (this.prevJobRadio.isSelected()) {
                                    selectedJob.updateGui(null);
                                    Aladin.info(this.asyncPanel, selectedJob.getJobId() + " -job sucessfully aborted");
                                }
                                break block44;
                            }
                            Aladin.error(this.asyncPanel, "Cannot abort job when phase is: " + selectedJob.getCurrentPhase());
                            return;
                        }
                        catch (IOException e1) {
                            if (selectedJob != null) {
                                selectedJob.showErrorOnServer();
                            }
                            Aladin.trace(3, e1.getMessage());
                            Aladin.error(this.asyncPanel, e1.getMessage());
                        }
                        catch (Exception e1) {
                            Aladin.error(this.asyncPanel, e1.getMessage());
                            if (selectedJob != null) {
                                selectedJob.showErrorOnServer();
                            }
                        }
                    }
                }
            } else if (o instanceof JCheckBox) {
                try {
                    UWSJob selectedJob = this.processJobSelection(false);
                    selectedJob.setDeleteOnExit(((JCheckBox)o).isSelected());
                }
                catch (Exception e1) {
                    Aladin.error(this.asyncPanel, e1.getMessage());
                }
            }
        }
    }

    public void showAsyncPanel() {
        MySplitPane asyncPanel = this.instantiateGui();
        this.jobControllerGui.show(asyncPanel, JOBCONTROLLERTITLE);
        this.jobControllerGui.toFront();
    }

    static {
        ERROR_INCORRECTPROTOCOL = "IOException. Job url not http protocol!";
        DELETETIMEOUTTIME = 7000;
        JOBNOTFOUNDMESSAGE = Aladin.chaine.getString("JOBNOTFOUNDMESSAGE");
        JOBERRORTOOLTIP = Aladin.chaine.getString("JOBERRORTOOLTIP");
        UWSNOJOBMESSAGE = Aladin.chaine.getString("UWSNOJOBMESSAGE");
        CANTSTARTJOB = Aladin.chaine.getString("CANTSTARTJOB");
        GENERICERROR1LINE = Aladin.getChaine().getString("GENERICERROR") + "\n";
        STANDARDRESULTSLOAD = Aladin.getChaine().getString("STANDARDRESULTSLOAD");
        STANDARDRESULTSLOADTIP = Aladin.getChaine().getString("STANDARDRESULTSLOADTIP");
        UWSASKLOADDEFAULTRESULTS = Aladin.getChaine().getString("UWSASKLOADDEFAULTRESULTS");
        CANTABORTJOB = Aladin.getChaine().getString("CANTABORTJOB");
        UWSJOBRADIOTOOLTIP = Aladin.getChaine().getString("UWSJOBRADIOTOOLTIP");
        JOBCONTROLLERTITLE = Aladin.getChaine().getString("JOBCONTROLLERTITLE");
        UWSPANELCURRECTSESSIONTITLE = Aladin.getChaine().getString("UWSPANELCURRECTSESSIONTITLE");
        UWSPANELPREVIOUSSESSIONTITLE = Aladin.getChaine().getString("UWSPANELPREVIOUSSESSIONTITLE");
        JOBNOTSELECTED = Aladin.getChaine().getString("JOBNOTSELECTED");
        JOBNOTFOUNDGIVENURL = Aladin.getChaine().getString("JOBNOTFOUNDGIVENURL");
        NOJOBURLMESSAGE = Aladin.getChaine().getString("NOJOBURLMESSAGE");
        JOBDELETEERRORMESSAGE = Aladin.getChaine().getString("JOBDELETEERRORMESSAGE");
        DELETEONCLOSEBUTTONLABEL = Aladin.getChaine().getString("DELETEONCLOSEBUTTONLABEL");
        UWSMULTIJOBLOADMESSAGE = Aladin.getChaine().getString("UWSMULTIJOBLOADMESSAGE");
        UWSASKTOREMOVENOTFOUNDJOBS = Aladin.getChaine().getString("UWSASKTOREMOVENOTFOUNDJOBS");
        UWSASKTOREMOVENOTFOUNDJOBSTITLE = Aladin.getChaine().getString("UWSASKTOREMOVENOTFOUNDJOBSTITLE");
    }
}

