/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

public final class Tok {
    private char[] a;
    private int oi;
    private int i;
    private char c;
    private String separator;
    private char lastSeparator = '\u0000';
    private StringBuffer curTok = new StringBuffer();
    private static String TEST = "global color=green dashlist=8 3 width=1 font=\"helvetica 10 normal\" select=1 file=\"\\Root\\file\"";
    private static String TEST1 = "global(color=green,dashlist=8,3,width=1,\"font=\\\"helvetica 10 normal\\\"\",select=1)";
    private static String TEST2 = "box(83.468685,22.0908,163.33361\",367.7002\",96.508724)";

    public Tok(String s) {
        this(s, null);
    }

    public Tok(String s, String separator) {
        this.separator = separator;
        this.a = s.toCharArray();
        this.i = 0;
        this.oi = 0;
    }

    public static String quote(String s) {
        return Tok.quote(s, false);
    }

    public static String quote(String s, boolean force) {
        int i;
        char[] a = s.toCharArray();
        if (!force) {
            for (i = 0; i < a.length && !Character.isSpace(a[i]) && a[i] != ',' && a[i] != '&' && a[i] != '|' && a[i] != ')' && a[i] != '(' && a[i] != '\\' && a[i] != '\'' && a[i] != '\"'; ++i) {
            }
            if (i == a.length) {
                return s;
            }
        }
        StringBuilder s1 = new StringBuilder(a.length);
        s1.append('\"');
        for (i = 0; i < a.length; ++i) {
            if (a[i] == '\"' || a[i] == '\\') {
                s1.append('\\');
            }
            s1.append(a[i]);
        }
        s1.append('\"');
        return s1.toString();
    }

    private String unQuote(StringBuffer s) {
        return Tok.unQuote(s.toString());
    }

    public static String unQuote(String s) {
        int n = s.length();
        if (n < 2) {
            return s;
        }
        char c = s.charAt(0);
        if (c != '\"' && c != '\'' || c != s.charAt(n - 1)) {
            return s;
        }
        char[] a = s.toCharArray();
        StringBuilder s1 = new StringBuilder(a.length);
        boolean backslash = false;
        for (int i = 1; i < n - 1; ++i) {
            c = a[i];
            if (backslash && (c == '\"' || c == '\'' || c == '\\')) {
                s1.replace(s1.length() - 1, s1.length(), c + "");
            } else {
                s1.append(c);
            }
            backslash = c == '\\';
        }
        return s1.toString();
    }

    public int countTokens() {
        int memoI = this.i;
        int j = 0;
        while (this.nextToken().length() > 0) {
            ++j;
        }
        this.i = memoI;
        return j;
    }

    public String[] getStrings() {
        String[] s = new String[this.countTokens()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = this.nextToken();
        }
        return s;
    }

    public boolean hasMoreTokens() {
        return this.i < this.a.length;
    }

    public int getPos() {
        return this.i;
    }

    public int getPreviousPos() {
        return this.oi;
    }

    private boolean isSeparator(char c) {
        boolean rep = false;
        if (this.separator == null) {
            rep = Character.isSpace(c);
        } else {
            boolean bl = rep = this.separator.indexOf(c) >= 0;
        }
        if (rep) {
            this.lastSeparator = c;
        }
        return rep;
    }

    public char getLastSeparator() {
        return this.lastSeparator;
    }

    private void resetString(StringBuffer s) {
        int n = s.length();
        if (n == 0) {
            return;
        }
        s.delete(0, n);
    }

    public String nextToken() {
        this.resetString(this.curTok);
        boolean quote = false;
        boolean backslash = false;
        boolean first = true;
        this.oi = this.i;
        while (this.i < this.a.length) {
            if (!(backslash || this.a[this.i] != '\"' && this.a[this.i] != '\'')) {
                if (!quote && first) {
                    this.c = this.a[this.i];
                    quote = true;
                } else if (this.a[this.i] == this.c) {
                    quote = false;
                }
            }
            boolean bl = backslash = this.a[this.i] == '\\';
            if (!quote && this.isSeparator(this.a[this.i])) {
                while (++this.i < this.a.length && this.isSeparator(this.a[this.i])) {
                }
                return this.unQuote(this.curTok);
            }
            first = false;
            this.curTok.append(this.a[this.i]);
            ++this.i;
        }
        return this.unQuote(this.curTok);
    }

    public static void main(String[] argv) {
        System.out.println("==> " + TEST2);
        Tok tok = new Tok(TEST2, "( ,)");
        StringBuffer s = new StringBuffer(tok.nextToken() + "(");
        boolean first = true;
        while (tok.hasMoreTokens()) {
            if (!first) {
                s.append(',');
            }
            first = false;
            String p1 = tok.nextToken();
            String p2 = Tok.quote(p1);
            System.out.println(p1 + " ==> " + p2);
            s.append(p2);
        }
        s.append(')');
        System.out.println("==> " + s);
    }
}

