/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Command;
import cds.aladin.Localisation;
import java.util.ArrayList;

public class TargetHistory {
    Aladin aladin;
    ArrayList<String> list;

    protected TargetHistory(Aladin aladin) {
        this.aladin = aladin;
        this.list = new ArrayList();
    }

    protected void add(String target) {
        if (target == null || target.trim().length() == 0) {
            return;
        }
        String t = TargetHistory.getTarget(target);
        if (!(Command.isDateCmd(t) || Localisation.notCoord(t) || Localisation.hasFoxSuffix(t))) {
            target = target + " " + this.aladin.localisation.getFrameFox();
        }
        this.remove(target);
        this.list.add(target);
    }

    protected static String getTarget(String s) {
        int i = s.indexOf("->");
        if (i < 0) {
            return s;
        }
        return s.substring(i + 2);
    }

    protected boolean remove(String target) {
        int i = this.find(target);
        if (i >= 0) {
            this.list.remove(i);
        }
        return i >= 0;
    }

    protected int find(String target) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (!target.equals(this.list.get(i))) continue;
            return i;
        }
        return -1;
    }

    protected String getLast() {
        return this.list.get(this.list.size() - 1);
    }

    protected ArrayList<String> getTargets(int index, int nb) {
        ArrayList<String> a = new ArrayList<String>(nb);
        int n = this.list.size() - 1 - index;
        for (int i = 0; i < nb && n >= 0; ++i, --n) {
            a.add(this.list.get(n));
        }
        if (n > 0) {
            a.add("...");
        }
        return a;
    }
}

