/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Constants;
import cds.aladin.TapTable;
import cds.xml.Field;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TapTableColumn {
    private String table_name;
    private String column_name;
    private String datatype;
    private String xtype;
    private int size;
    private String description;
    private String utype;
    private String unit;
    private String ucd;
    private String isIndexed;
    private String isPrincipal;
    private String isStandard;

    public TapTableColumn() {
    }

    public TapTableColumn(TapTableColumn ref, String alais) {
        this.table_name = ref.getTable_name() + "." + alais;
        this.column_name = ref.column_name;
        this.description = ref.description;
        this.unit = ref.unit;
        this.ucd = ref.ucd;
        this.utype = ref.utype;
        this.datatype = ref.datatype;
        this.size = ref.size;
        this.isPrincipal = ref.isPrincipal;
        this.isIndexed = ref.isIndexed;
        this.isStandard = ref.isStandard;
    }

    public Vector<String> getRowVector() {
        Vector<String> allValuesVector = new Vector<String>(10);
        allValuesVector.addElement(this.column_name);
        allValuesVector.addElement(this.description);
        allValuesVector.addElement(this.unit);
        allValuesVector.addElement(this.ucd);
        allValuesVector.addElement(this.utype);
        allValuesVector.addElement(this.datatype);
        if (this.size == -1) {
            allValuesVector.addElement("");
        } else {
            allValuesVector.addElement(String.valueOf(this.size));
        }
        allValuesVector.addElement(this.isPrincipal);
        allValuesVector.addElement(this.isIndexed);
        allValuesVector.addElement(this.isStandard);
        return allValuesVector;
    }

    public static Vector<String> getColumnLabels() {
        Vector<String> columnNames = new Vector<String>(10);
        columnNames.addElement("ColumnName");
        columnNames.addElement("Description");
        columnNames.addElement("Unit");
        columnNames.addElement("UCD");
        columnNames.addElement("Utype");
        columnNames.addElement("Datatype");
        columnNames.addElement("Size");
        columnNames.addElement("isPrincipalColumn?");
        columnNames.addElement("isIndexedColumn?");
        columnNames.addElement("isStandardColumn?");
        return columnNames;
    }

    public String getTable_name() {
        return this.table_name;
    }

    public void setTable_name(String table_name) {
        this.table_name = table_name;
    }

    public String getColumn_name() {
        return this.column_name;
    }

    public String getColumnNameForQuery() {
        return TapTable.getQueryPart(this.column_name, false);
    }

    public void setColumn_name(String column_name) {
        this.column_name = column_name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getUcd() {
        return this.ucd;
    }

    public void setUcd(String ucd) {
        this.ucd = ucd;
    }

    public String getUtype() {
        return this.utype;
    }

    public void setUtype(String utype) {
        this.utype = utype;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
    }

    public void setDataType(Field f) {
        String datatype = Field.typeFits2VOTable(f.datatype);
        if (datatype.equalsIgnoreCase("int")) {
            this.datatype = Constants.DBColumnType.INTEGER.name();
        } else if (datatype.equalsIgnoreCase("long")) {
            this.datatype = Constants.DBColumnType.BIGINT.name();
        } else if (datatype.equalsIgnoreCase("char")) {
            this.datatype = Constants.DBColumnType.CHAR.name();
        } else if (datatype.equalsIgnoreCase("string")) {
            this.datatype = Constants.DBColumnType.VARCHAR.name();
        } else if (datatype.equalsIgnoreCase("float")) {
            this.datatype = Constants.DBColumnType.REAL.name();
        } else if (datatype.equalsIgnoreCase("double")) {
            this.datatype = Constants.DBColumnType.DOUBLE.name();
        } else if (datatype.equalsIgnoreCase("short")) {
            this.datatype = Constants.DBColumnType.SMALLINT.name();
        } else if (datatype.equalsIgnoreCase("unsignedByte")) {
            this.datatype = Constants.DBColumnType.VARBINARY.name();
        }
    }

    public void setSize(String dataType, String value) {
        this.size = this.verifyExtractIntString(dataType, value);
    }

    public int verifyExtractIntString(String dataType, String value) {
        int parsedValue = -1;
        if (dataType != null && value != null && !value.isEmpty() && dataType.equals("int")) {
            try {
                parsedValue = Integer.parseInt(value);
            }
            catch (Exception e) {
                Aladin.trace(3, "unable to parse: value:" + value);
            }
            return parsedValue;
        }
        return parsedValue;
    }

    public boolean isDefinedMain() {
        String[] words;
        boolean result = false;
        if (this.ucd != null && (words = this.ucd.split(";")).length > 1 && words[1].equalsIgnoreCase("meta.main")) {
            result = true;
        }
        return result;
    }

    public String getIsPrincipal() {
        return this.isPrincipal;
    }

    public void setIsPrincipal(String isPrincipal) {
        this.isPrincipal = isPrincipal;
    }

    public String getIsIndexed() {
        return this.isIndexed;
    }

    public void setIsIndexed(String isIndexed) {
        this.isIndexed = isIndexed;
    }

    public String getIsStandard() {
        return this.isStandard;
    }

    public void setIsStandard(String isStandard) {
        this.isStandard = isStandard;
    }

    public String toString() {
        StringBuffer toPrint = new StringBuffer();
        toPrint.append("table name:").append(this.table_name).append(", Column name: ").append(this.column_name).append(", description :").append(this.description).append(", unit :").append(this.unit).append(", ucd :").append(this.ucd).append(", datatype :").append(this.datatype).append(", size :").append(this.size).append(",is principal : ").append(this.isPrincipal).append(", is indexed :").append(this.isIndexed).append(", is standard :").append(this.isStandard);
        return toPrint.toString();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getFlaggedColumnToolTip() {
        String tooltip = this.column_name;
        if (this.unit != null) {
            tooltip = "Unit: " + this.unit;
        }
        if (this.utype != null) {
            if (this.unit != null) {
                tooltip = tooltip + ", ";
            }
            tooltip = tooltip + this.utype;
        }
        return this.column_name;
    }

    public boolean isNumeric() {
        boolean result = false;
        if (this.datatype != null && (this.datatype.toUpperCase().contains("SMALLINT") || this.datatype.toUpperCase().contains("INTEGER") || this.datatype.toUpperCase().contains("BIGINT") || this.datatype.toUpperCase().contains("REAL") || this.datatype.toUpperCase().contains("DOUBLE"))) {
            result = true;
        }
        return result;
    }

    public static boolean isInteger(String input) {
        boolean result = false;
        Pattern pattern = Pattern.compile("^\\d*[1-9]\\d*$");
        Matcher matcher = pattern.matcher(input);
        result = matcher.find();
        return result;
    }

    public String getXtype() {
        return this.xtype;
    }

    public void setXtype(String xtype) {
        this.xtype = xtype;
    }
}

