/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import adql.db.DefaultDBTable;
import cds.aladin.Aladin;
import cds.aladin.Constants;
import cds.aladin.Coord;
import cds.aladin.CustomListCellRenderer;
import cds.aladin.DynamicTapForm;
import cds.aladin.ForeignKeyColumn;
import cds.aladin.FrameSimple;
import cds.aladin.Glu;
import cds.aladin.JoinFacade;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.Server;
import cds.aladin.ServerGlu;
import cds.aladin.ServerObsTap;
import cds.aladin.ServerTap;
import cds.aladin.ServerTapExamples;
import cds.aladin.TapClient;
import cds.aladin.TapFrameServer;
import cds.aladin.TapTable;
import cds.aladin.TapTableColumn;
import cds.aladin.UWSFacade;
import cds.aladin.UploadFacade;
import cds.mocmulti.MocItem2;
import cds.savot.binary.DataBinaryReader;
import cds.savot.binary.SavotDataReader;
import cds.savot.binary2.DataBinary2Reader;
import cds.savot.model.FieldSet;
import cds.savot.model.SavotBinary;
import cds.savot.model.SavotBinary2;
import cds.savot.model.SavotField;
import cds.savot.model.SavotResource;
import cds.savot.model.SavotTable;
import cds.savot.model.TDSet;
import cds.savot.model.TRSet;
import cds.savot.pull.SavotPullParser;
import cds.tools.MultiPartPostOutputStream;
import cds.tools.TwoColorJTable;
import cds.tools.Util;
import cds.xml.ExamplesReader;
import cds.xml.Field;
import cds.xml.VOSICapabilitiesReader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class TapManager {
    private static TapManager instance = null;
    private boolean initAllLoad = true;
    public Aladin aladin;
    protected static Vector<Vector<String>> splTapServerLabels;
    protected static Vector<String> allTapServerLabels;
    protected TapFrameServer tapFrameServer = null;
    protected UploadFacade uploadFacade;
    MutableComboBoxModel uploadTablesModel = new DefaultComboBoxModel();
    protected FrameSimple joinFrame;
    protected static Map<String, TapClient> tapServerPanelCache;
    protected static Map<String, TapClient> tapServerTreeCache;
    public static final String STANDARDQUERYPARAMSTEMPLATE = "REQUEST=doQuery&LANG=ADQL&MAXREC=20000000&QUERY=";
    public static final String GETTAPSCHEMACOLUMNCOUNT = "REQUEST=doQuery&LANG=ADQL&MAXREC=20000000&QUERY=SELECT+COUNT%28*%29+FROM+TAP_SCHEMA.columns";
    public static final String GETTAPSCHEMACOLUMNS = "REQUEST=doQuery&LANG=ADQL&MAXREC=20000000&QUERY=SELECT+*+FROM+TAP_SCHEMA.columns";
    public static final String GETTAPSCHEMATABLES = "REQUEST=doQuery&LANG=ADQL&MAXREC=20000000&QUERY=SELECT+*+FROM+TAP_SCHEMA.tables";
    public static final String GETTAPSCHEMATABLENAMES = "REQUEST=doQuery&LANG=ADQL&MAXREC=20000000&QUERY=SELECT+table_name+FROM+TAP_SCHEMA.tables";
    public static final String GETTAPSCHEMACOLUMN = "SELECT * FROM TAP_SCHEMA.columns WHERE table_name = '%1$s'";
    public static final String GETTAPCAPABILITIES = "capabilities";
    public static final String GETTAPEXAMPLES = "examples";
    public static final String GETTAPFOREIGNRELFORTABLE = "SELECT target_table, from_table, target_column, from_column FROM TAP_SCHEMA.keys JOIN TAP_SCHEMA.key_columns ON TAP_SCHEMA.keys.key_id = TAP_SCHEMA.key_columns.key_id WHERE target_table ='%1$s'";
    public static final String GENERICERROR;
    public static final String TAPLOADINGMESSAGE;
    public static final String TAPLOADERRORMESSAGE;
    public static final String UPLOADTABLECHANGEWARNING;
    public static final int MAXTAPCOLUMNDOWNLOADVOLUME = 1000;
    public static final long MAXTAPROWS = 20000000L;
    protected List<String> eligibleUploadServers;
    public UWSFacade uwsFacade;
    public FrameSimple tapPanelFromTree;
    public boolean hideTapSchema;

    public TapManager() {
    }

    public TapManager(Aladin aladin) {
        this();
        aladin.initThreadPool();
        this.uwsFacade = UWSFacade.getInstance(aladin);
        this.aladin = aladin;
        this.hideTapSchema = aladin.configuration.hideTapSchema();
    }

    public static synchronized TapManager getInstance(Aladin aladin) {
        if (instance == null) {
            instance = new TapManager(aladin);
        }
        return instance;
    }

    public void instantiateTapServers() {
        if (this.initAllLoad) {
            this.populateTapServersFromTree(null);
            this.populateSplFromDirectory();
        }
    }

    public Vector<Vector<String>> getPreSelectedTapServers() {
        this.instantiateTapServers();
        return splTapServerLabels;
    }

    public List<String> getRegistryTapServers() {
        this.instantiateTapServers();
        return allTapServerLabels;
    }

    public boolean isValidTapServerList() {
        boolean result = false;
        this.instantiateTapServers();
        if (splTapServerLabels != null && !splTapServerLabels.isEmpty()) {
            result = true;
        } else if (allTapServerLabels != null && !allTapServerLabels.isEmpty()) {
            result = true;
        }
        return result;
    }

    public void addTapService(String actionName, String label, String url, String description) {
        if (actionName != null) {
            Vector<String> newDatalabel = new Vector<String>();
            newDatalabel.add(TapFrameServer.labelId, label);
            newDatalabel.add(TapFrameServer.descriptionId, description);
            newDatalabel.add(TapFrameServer.urlId, url);
            if (splTapServerLabels == null) {
                splTapServerLabels = new Vector();
            }
            this.removeOldEntries(label);
            splTapServerLabels.add(newDatalabel);
        }
    }

    public void removeOldEntries(String actionName) {
        for (Vector<String> datalabel : splTapServerLabels) {
            if (datalabel.get(0) == null || !datalabel.get(0).equals(actionName)) continue;
            splTapServerLabels.remove(datalabel);
            break;
        }
    }

    public void populateTapServersFromTree(String mask) {
        try {
            if (allTapServerLabels == null) {
                allTapServerLabels = new Vector();
            } else {
                allTapServerLabels.clear();
            }
            if (mask == null || mask.isEmpty()) {
                mask = "*";
            }
            allTapServerLabels.addAll(this.aladin.directory.getTAPServers(mask));
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.error(this.tapFrameServer, "Tap servers not loaded from directory tree!", 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSplFromDirectory() {
        try {
            if (splTapServerLabels == null) {
                splTapServerLabels = new Vector();
            }
            ArrayList<String> tapServersMocId = this.aladin.directory.getPredefinedTAPServersMultiProp();
            for (String id : tapServersMocId) {
                MocItem2 mi = this.aladin.directory.multiProp.getItem(id);
                String url = mi.prop.get("tap_service_url");
                String description = mi.prop.get("obs_title");
                if (description == null) {
                    description = mi.prop.get("obs_collection");
                }
                Vector<String> tapServer = new Vector<String>();
                tapServer.add(TapFrameServer.labelId, id);
                tapServer.add(TapFrameServer.descriptionId, description);
                tapServer.add(TapFrameServer.urlId, url);
                splTapServerLabels.add(tapServer);
            }
            Aladin.trace(3, "populateFromDirectory():: Done loading from directory...");
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.error(this.tapFrameServer, "Unable to load tap servers from directory !", 1);
        }
        finally {
            this.initAllLoad = false;
        }
    }

    public void showTapServerOnServerSelector(Server server) {
        this.aladin.dialog.findReplaceServer(this.aladin.dialog.tapServer, server);
        this.aladin.dialog.tapServer = server;
        this.aladin.dialog.show(server);
    }

    public void showTapPanelFromTree(String label, Server resultServer) {
        if (this.tapPanelFromTree == null) {
            this.tapPanelFromTree = new FrameSimple(this.aladin);
        }
        Aladin.makeCursor(this.tapPanelFromTree, 1);
        this.tapPanelFromTree.show(resultServer, "TAP access with " + label);
        Aladin.makeCursor(this.tapPanelFromTree, 0);
    }

    public void loadTapServer(String gluActionName, String label, String url, String defaultTables) throws Exception {
        if (label != null) {
            String cacheId;
            TapClient tapClient = null;
            if (this.joinFrame != null && this.joinFrame.isVisible()) {
                this.joinFrame.setVisible(false);
            }
            if ((cacheId = this.labelInCache(gluActionName, label, tapServerPanelCache)) != null) {
                tapClient = tapServerPanelCache.get(cacheId);
                tapClient.tapBaseUrl = url;
                if (defaultTables != null) {
                    tapClient.updateNodeAndSetModes(defaultTables);
                }
            } else {
                cacheId = this.labelInCache(gluActionName, label, tapServerTreeCache);
                if (cacheId != null) {
                    tapClient = this.copyTapClientAndDisplay(tapServerTreeCache.get(cacheId), url, Constants.TapClientMode.DIALOG, defaultTables);
                } else {
                    cacheId = label;
                    tapClient = new TapClient(Constants.TapClientMode.DIALOG, this, label, url, defaultTables);
                }
                tapServerPanelCache.put(cacheId, tapClient);
            }
            Server resultServer = tapClient.getServerToDisplay(null);
            this.aladin.dialog.findReplaceServer(this.aladin.dialog.tapServer, resultServer);
            this.aladin.dialog.tapServer = resultServer;
            StringBuffer params = new StringBuffer("Displaying ");
            if (tapClient.model.getSelectedItem() != null) {
                params.append(tapClient.model.getSelectedItem()).append(" ").append(tapClient.tapBaseUrl);
            }
            this.aladin.glu.log("TAP", params.toString());
        }
    }

    public Server loadTapServerForSimpleFrame(String gluActionName, String label, String url, String defaultTables) throws Exception {
        TapClient tapClient = null;
        String cacheId = this.labelInCache(gluActionName, label, tapServerTreeCache);
        if (cacheId != null) {
            tapClient = tapServerTreeCache.get(cacheId);
            tapClient.tapBaseUrl = url;
            if (defaultTables != null) {
                tapClient.updateNodeAndSetModes(defaultTables);
            }
        } else {
            cacheId = this.labelInCache(gluActionName, label, tapServerPanelCache);
            if (cacheId != null) {
                tapClient = this.copyTapClientAndDisplay(tapServerPanelCache.get(cacheId), url, Constants.TapClientMode.TREEPANEL, defaultTables);
            } else {
                cacheId = label;
                tapClient = new TapClient(Constants.TapClientMode.TREEPANEL, this, label, url, defaultTables);
            }
            tapServerTreeCache.put(cacheId, tapClient);
        }
        Server resultServer = tapClient.getServerToDisplay(null);
        this.showTapPanelFromTree(cacheId, resultServer);
        StringBuffer params = new StringBuffer("Displaying ");
        if (tapClient.model.getSelectedItem() != null) {
            params.append(tapClient.model.getSelectedItem()).append(" ").append(tapClient.tapBaseUrl);
        }
        this.aladin.glu.log("TAP", params.toString());
        return resultServer;
    }

    public String labelInCache(String gluActionName, String actionName, Map<String, TapClient> cache) {
        String label = null;
        if (gluActionName != null && cache.containsKey(gluActionName)) {
            label = gluActionName;
        } else if (actionName != null && cache.containsKey(actionName)) {
            label = actionName;
        }
        return label;
    }

    public DynamicTapForm createAndLoadATapServer(TapClient tapClient, DynamicTapForm newServer) throws Exception {
        newServer.setName(tapClient.tapLabel);
        if (tapClient.tapBaseUrl == null) {
            Object urlFromGlu = this.aladin.glu.aladinDic.get(tapClient.tapLabel);
            if (urlFromGlu != null) {
                tapClient.tapBaseUrl = (String)urlFromGlu;
            }
            if (tapClient.tapBaseUrl == null) {
                throw new Exception("Tap server url not found");
            }
        }
        newServer.setOpaque(true);
        newServer.showloading();
        tapClient.capabilities = this.getTapCapabilities(tapClient.tapBaseUrl);
        this.loadTapColumnSchemas(tapClient, newServer);
        return newServer;
    }

    public TapClient copyTapClientAndDisplay(TapClient original, String urlInput, Constants.TapClientMode mode, String nodeTables) {
        TapClient copy = null;
        if (original.serverGlu != null) {
            ServerGlu serverGluCopy = null;
            StringBuffer originalGluRecord = original.serverGlu.record;
            String gluRecord = originalGluRecord.toString();
            gluRecord = mode == Constants.TapClientMode.TREEPANEL ? gluRecord.concat("%Aladin.Protocol TAPv1-TREEPANEL") : gluRecord.concat("%Aladin.Protocol TAPv1");
            serverGluCopy = this.getCopy(originalGluRecord, gluRecord);
            copy = serverGluCopy.tapClient;
            if (nodeTables != null) {
                copy.updateNodeAndSetModes(nodeTables);
            }
        }
        if (copy == null) {
            copy = new TapClient(mode, this, original.tapLabel, urlInput, nodeTables);
        }
        this.copyMetadata(copy, original, mode, false);
        copy.tapBaseUrl = urlInput;
        if (original.serverTap != null && original.tapBaseUrl.equalsIgnoreCase(urlInput)) {
            copy.serverTap = new ServerTap(this.aladin);
            copy.serverTap.formLoadStatus = 0;
            copy.serverTap.tapClient = copy;
        }
        return copy;
    }

    public void updateServerMetaDataInCache(TapClient original, boolean onlyInfoPanel) {
        Constants.TapClientMode mode = null;
        TapClient toUpdate = null;
        if (original.mode == Constants.TapClientMode.DIALOG) {
            mode = Constants.TapClientMode.TREEPANEL;
            toUpdate = tapServerTreeCache.get(original.tapLabel);
        } else {
            mode = Constants.TapClientMode.DIALOG;
            toUpdate = tapServerPanelCache.get(original.tapLabel);
        }
        if (toUpdate != null) {
            this.copyMetadata(toUpdate, original, mode, onlyInfoPanel);
        }
    }

    public void copyMetadata(TapClient copy, TapClient original, Constants.TapClientMode mode, boolean onlyInfoPanel) {
        if (!onlyInfoPanel) {
            copy.tapLabel = original.tapLabel;
            copy.tapBaseUrl = original.tapBaseUrl;
            copy.capabilities = original.capabilities;
            copy.setData(original.tablesMetaData);
            copy.queryCheckerTables = original.queryCheckerTables;
            copy.obscoreTables = original.obscoreTables;
        }
        copy.infoPanel = original.infoPanel;
    }

    public ServerGlu getCopy(StringBuffer originalGluRecord, String gluRecord) {
        Glu cfr_ignored_0 = this.aladin.glu;
        Glu.vGluServer = new Vector(50);
        ByteArrayInputStream dicStream = new ByteArrayInputStream(gluRecord.getBytes(StandardCharsets.UTF_8));
        this.aladin.glu.loadGluDic(new DataInputStream(dicStream), true, false);
        Glu cfr_ignored_1 = this.aladin.glu;
        Vector serverVector = Glu.vGluServer;
        int n = serverVector.size();
        if (n == 0) {
            return null;
        }
        ServerGlu serverGlu = (ServerGlu)serverVector.get(0);
        serverGlu.record = originalGluRecord;
        return serverGlu;
    }

    public void createGenericTapFormFromMetaData(final DynamicTapForm newServer) {
        try {
            this.aladin.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Thread currentT = Thread.currentThread();
                    String oldTName = currentT.getName();
                    try {
                        currentT.setName("TloadServerTapForm: " + newServer.getName());
                        newServer.createFormDefault();
                        newServer.revalidate();
                        newServer.repaint();
                    }
                    finally {
                        currentT.setName(oldTName);
                    }
                }
            });
        }
        catch (RejectedExecutionException ex) {
            newServer.showLoadingError();
            newServer.revalidate();
            newServer.repaint();
            this.displayWarning(newServer.tapClient, "Unable to get metadata for " + newServer.getName() + "\n Request overload! Please wait and try again.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkDummyInitForServerDialog(Server tapServer) {
        boolean result = true;
        if (this.aladin.glu.lastTapGluServer == null && tapServer instanceof ServerTap && ((ServerTap)tapServer).isNotLoaded()) {
            try {
                tapServer.makeCursor(1);
                this.showTapRegistryForm();
            }
            catch (Exception e) {
                Aladin.error(this.aladin.dialog, GENERICERROR);
                e.printStackTrace();
            }
            finally {
                tapServer.makeCursor(0);
            }
            result = false;
        }
        return result;
    }

    protected void setTargetDimensions(TapClient tc) {
        MocItem2 mocItem = this.aladin.directory.multiProp.getItem(tc.tapLabel);
        if (mocItem != null) {
            MyProperties prop = this.aladin.directory.multiProp.getItem((String)tc.tapLabel).prop;
            String s = prop.getProperty("hips_initial_ra");
            if (s != null) {
                String s1 = prop.getProperty("hips_initial_dec");
                s = s1 != null ? s + " " + s1 : null;
            }
            if (s == null) {
                tc.target = null;
            } else {
                try {
                    tc.target = new Coord(s);
                }
                catch (Exception e) {
                    Aladin.trace(3, "target error!");
                    tc.target = null;
                }
            }
            double div2 = 2.0;
            s = prop.getProperty("hips_initial_fov");
            if (s == null) {
                tc.radius = -1.0;
            } else {
                try {
                    tc.radius = Server.getAngleInArcmin(s, 8) / 60.0 / div2;
                }
                catch (Exception e) {
                    Aladin.trace(3, "radius error!");
                    tc.radius = -1.0;
                }
            }
        }
    }

    public boolean checkDummyTapServer(Server server) {
        boolean result = false;
        if (server instanceof ServerTap && ((ServerTap)server).isNotLoaded()) {
            result = true;
        }
        return result;
    }

    public Plan getPlan(String aladinFileName) {
        Plan resultantPlan = null;
        Plan[] plan = this.aladin.calque.plan;
        for (int i = 0; i < plan.length; ++i) {
            if (plan[i].label == null || !plan[i].label.equalsIgnoreCase(aladinFileName)) continue;
            resultantPlan = plan[i];
            break;
        }
        return resultantPlan;
    }

    public Future<VOSICapabilitiesReader> getTapCapabilities(final String tapServiceUrl) {
        Future<VOSICapabilitiesReader> capabilities = null;
        try {
            capabilities = this.aladin.executor.submit(new Callable<VOSICapabilitiesReader>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public VOSICapabilitiesReader call() {
                    Thread currentT = Thread.currentThread();
                    String oldTName = currentT.getName();
                    VOSICapabilitiesReader vosiCapabilitiesReader = null;
                    currentT.setName("TgetCapabilities: " + tapServiceUrl);
                    try {
                        URL capabilitiesUrl = TapManager.getUrl(tapServiceUrl, null, TapManager.GETTAPCAPABILITIES);
                        vosiCapabilitiesReader = new VOSICapabilitiesReader();
                        vosiCapabilitiesReader.load(capabilitiesUrl);
                    }
                    catch (Exception e) {
                        Aladin.trace(3, "Unable to get capabilitites for.." + tapServiceUrl);
                        if (Aladin.levelTrace >= 3) {
                            e.printStackTrace();
                        }
                    }
                    finally {
                        currentT.setName(oldTName);
                    }
                    return vosiCapabilitiesReader;
                }
            });
        }
        catch (RejectedExecutionException e) {
            Aladin.trace(3, "RejectedExecutionException. Unable to get capabilitites for.." + tapServiceUrl);
        }
        return capabilities;
    }

    public Map getTapExamples(String tapServiceUrl) {
        Map<String, String> examples;
        block13: {
            ExamplesReader daliExamplesReader = new ExamplesReader();
            MyInputStream is = null;
            examples = null;
            try {
                URL url = TapManager.getUrl(tapServiceUrl, null, GETTAPEXAMPLES);
                Aladin.trace(3, "TapManager.getResults() for: " + url);
                long startTime = TapManager.getTimeToLog();
                is = Util.openStreamForTapAndDL(url, null, true, 10000);
                long time = TapManager.getTimeToLog();
                if (Aladin.levelTrace >= 4) {
                    System.out.println("DaliExamples got inputstream: " + time + " time taken: " + (time - startTime));
                }
                startTime = TapManager.getTimeToLog();
                examples = daliExamplesReader.parse(is);
            }
            catch (MalformedURLException e) {
                if (Aladin.levelTrace > 3) {
                    e.printStackTrace();
                }
            }
            catch (ParserConfigurationException e) {
                if (Aladin.levelTrace > 3) {
                    e.printStackTrace();
                }
            }
            catch (SAXException e) {
                if (Aladin.levelTrace > 3) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                if (Aladin.levelTrace > 3) {
                    e.printStackTrace();
                }
            }
            catch (URISyntaxException e) {
                if (Aladin.levelTrace > 3) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace <= 3) break block13;
                e.printStackTrace();
            }
        }
        return examples;
    }

    public void loadTapColumnSchemas(final TapClient clientToLoad, final DynamicTapForm newServer) {
        try {
            this.aladin.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Thread currentT = Thread.currentThread();
                    String oldTName = currentT.getName();
                    String tapServiceUrl = clientToLoad.tapBaseUrl;
                    currentT.setName("TgetMetaInfo: " + tapServiceUrl);
                    long startTime = TapManager.getTimeToLog();
                    if (Aladin.levelTrace >= 4) {
                        System.out.println("loadTapColumnSchemas starting: " + startTime);
                    }
                    try {
                        SavotResource resultsResource;
                        int count = 1000;
                        try {
                            String volume = TapManager.this.getFutureResultsVolume(tapServiceUrl);
                            if (volume != null) {
                                count = Integer.parseInt(volume);
                            }
                        }
                        catch (Exception e) {
                            if (Aladin.levelTrace >= 3) {
                                e.printStackTrace();
                            }
                            Aladin.trace(3, "Murky waters..do not know count. will get data table-wise...");
                        }
                        clientToLoad.setData(new HashMap<String, TapTable>());
                        if (count >= 1000) {
                            String defaultTable;
                            resultsResource = TapManager.getResults("getAllTables", tapServiceUrl, TapManager.GETTAPSCHEMATABLENAMES, "sync");
                            TapManager.this.updateTableMetadata(newServer, tapServiceUrl);
                            TapManager.this.populateTables(clientToLoad, resultsResource);
                            String tableNameQueryParam = defaultTable = clientToLoad.tablesMetaData.keySet().iterator().next();
                            String gettablesColumnsQuery = String.format(TapManager.GETTAPSCHEMACOLUMN, tableNameQueryParam);
                            gettablesColumnsQuery = URLEncoder.encode(gettablesColumnsQuery, "utf-8");
                            gettablesColumnsQuery = TapManager.STANDARDQUERYPARAMSTEMPLATE + gettablesColumnsQuery;
                            SavotResource columnResults = TapManager.getResults("getOneTableColums", tapServiceUrl, gettablesColumnsQuery, "sync");
                            TapManager.this.populateColumns(clientToLoad, columnResults);
                        } else if (count > 0) {
                            resultsResource = TapManager.getResults("getAllTableColums", tapServiceUrl, TapManager.GETTAPSCHEMACOLUMNS, "sync");
                            TapManager.this.updateTableMetadata(newServer, tapServiceUrl);
                            TapManager.this.populateColumns(clientToLoad, resultsResource);
                        } else {
                            newServer.showLoadingError();
                            TapManager.this.displayWarning(clientToLoad, "Error from tap server " + clientToLoad.tapLabel + " : unable to get metadata !");
                            return;
                        }
                        clientToLoad.preprocessTapClient();
                        newServer.createFormDefault();
                        long time = TapManager.getTimeToLog();
                        if (Aladin.levelTrace >= 4) {
                            System.out.println("all done at: " + time + " time taken: " + (time - startTime));
                        }
                        TapManager.this.updateServerMetaDataInCache(clientToLoad, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        newServer.showLoadingError();
                        TapManager.this.displayWarning(clientToLoad, e.getMessage());
                    }
                    finally {
                        newServer.revalidate();
                        newServer.repaint();
                        currentT.setName(oldTName);
                    }
                }
            });
        }
        catch (RejectedExecutionException ex) {
            newServer.showLoadingError();
            newServer.revalidate();
            newServer.repaint();
            this.displayWarning(clientToLoad, "Unable to get metadata for " + clientToLoad.tapLabel + "\n Request overload! Please wait and try again.");
        }
    }

    public void loadForeignKeyRelationsForSelectedTable(final TapClient clientToLoad, final JoinFacade joinFacade, final String table_name) {
        try {
            this.aladin.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Thread currentT = Thread.currentThread();
                    String oldTName = currentT.getName();
                    String tapServiceUrl = clientToLoad.tapBaseUrl;
                    currentT.setName("TgetForeignRelMetaInfo: " + table_name + " - " + tapServiceUrl);
                    long startTime = TapManager.getTimeToLog();
                    if (Aladin.levelTrace >= 4) {
                        System.out.println("loadTapColumnSchemas starting: " + startTime);
                    }
                    try {
                        if (clientToLoad.tablesMetaData.get((Object)table_name).foreignKeyColumns == null) {
                            try {
                                String tableNameQueryParam = URLEncoder.encode(table_name, "utf-8");
                                String gettablesForeignKeyColumnsQuery = String.format(TapManager.GETTAPFOREIGNRELFORTABLE, tableNameQueryParam);
                                gettablesForeignKeyColumnsQuery = URLEncoder.encode(gettablesForeignKeyColumnsQuery, "utf-8");
                                gettablesForeignKeyColumnsQuery = TapManager.STANDARDQUERYPARAMSTEMPLATE + gettablesForeignKeyColumnsQuery;
                                SavotResource keysResults = TapManager.getResults("getAllForeignRelsForSelTable", tapServiceUrl, gettablesForeignKeyColumnsQuery, "sync");
                                TapManager.this.populateForeignKeys(clientToLoad, table_name, keysResults);
                                TapManager.this.updateServerMetaDataInCache(clientToLoad, false);
                            }
                            catch (Exception e) {
                                Aladin.trace(3, "No foreign keys read!");
                            }
                        }
                        joinFacade.setJoinTableForm(null, null);
                        long time = TapManager.getTimeToLog();
                        if (Aladin.levelTrace >= 4) {
                            System.out.println("all done at: " + time + " time taken: " + (time - startTime));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        joinFacade.showLoadingError();
                        Aladin.error(joinFacade, e.getMessage());
                    }
                    finally {
                        joinFacade.revalidate();
                        joinFacade.repaint();
                        currentT.setName(oldTName);
                    }
                }
            });
        }
        catch (RejectedExecutionException ex) {
            joinFacade.showLoadingError();
            joinFacade.revalidate();
            joinFacade.repaint();
            Aladin.error(joinFacade, "Unable to get metadata for " + clientToLoad.tapLabel + "\n Request overload! Please wait and try again.");
        }
    }

    public void showTapRegistryForm() {
        this.loadTapServerList();
        this.tapFrameServer.setVisible(true);
        this.tapFrameServer.toFront();
    }

    public void loadTapServerList() {
        if (this.tapFrameServer == null) {
            this.tapFrameServer = new TapFrameServer(this.aladin, this);
            this.tapFrameServer.createCenterPane();
            Aladin.makeCursor(this.tapFrameServer.options, 1);
            this.loadPreselectedServers();
        }
    }

    public void loadPreselectedServers() {
        try {
            this.aladin.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Thread currentT = Thread.currentThread();
                    String oldTName = currentT.getName();
                    try {
                        currentT.setName("TinitPreselectedServers: ");
                        TapManager.this.tapFrameServer.initPreselectedServers();
                        Aladin.makeCursor(TapManager.this.tapFrameServer.options, 0);
                        Aladin.makeCursor(TapManager.this.tapFrameServer.treeRegistryPanel, 1);
                        TapManager.this.loadAllServers();
                    }
                    finally {
                        currentT.setName(oldTName);
                    }
                }
            });
        }
        catch (RejectedExecutionException ex) {
            Aladin.trace(3, "RejectedExecutionException");
            this.tapFrameServer.showRegistryNotLoaded();
            Aladin.makeCursor(this.tapFrameServer.options, 0);
            Aladin.makeCursor(this.tapFrameServer.treeRegistryPanel, 0);
        }
    }

    public void loadAllServers() {
        try {
            this.aladin.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Thread currentT = Thread.currentThread();
                    String oldTName = currentT.getName();
                    try {
                        currentT.setName("TinitAllServers: ");
                        TapManager.this.tapFrameServer.initAllServers();
                        Aladin.makeCursor(TapManager.this.tapFrameServer.treeRegistryPanel, 0);
                    }
                    finally {
                        currentT.setName(oldTName);
                    }
                }
            });
        }
        catch (RejectedExecutionException ex) {
            Aladin.trace(3, "RejectedExecutionException");
            this.tapFrameServer.showCompleteListNotLoaded();
            Aladin.makeCursor(this.tapFrameServer.treeRegistryPanel, 0);
        }
    }

    public void reloadTapServerList() {
        if (this.tapFrameServer != null) {
            this.tapFrameServer.initPreselectedServers();
            this.tapFrameServer.reloadRegistryPanel();
        }
    }

    public void initTapExamples(final ServerTapExamples serverTapExamples) {
        try {
            this.aladin.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Thread currentT = Thread.currentThread();
                    String oldTName = currentT.getName();
                    try {
                        currentT.setName("TinitTapExamples: " + serverTapExamples.tapClient.tapLabel);
                        serverTapExamples.ball.setMode(4);
                        serverTapExamples.info1.setText("Loading service examples...");
                        serverTapExamples.loadTapExamples();
                    }
                    finally {
                        currentT.setName(oldTName);
                    }
                }
            });
        }
        catch (RejectedExecutionException ex) {
            Aladin.trace(3, "RejectedExecutionException");
        }
    }

    public void updateTableColumnSchemas(DynamicTapForm dynamicTapForm, List<String> tableNames) throws Exception {
        dynamicTapForm.ball.setMode(4);
        if (tableNames == null || tableNames.isEmpty()) {
            throw new Exception("Error no table name provided !\n");
        }
        try {
            String tapServiceUrl = dynamicTapForm.tapClient.tapBaseUrl;
            boolean isNotFirst = false;
            StringBuffer whereCondition = new StringBuffer();
            String gettablesColumnsQuery = null;
            if (tableNames.size() == 1) {
                gettablesColumnsQuery = String.format(GETTAPSCHEMACOLUMN, tableNames.get(0));
            } else {
                for (String tableName : tableNames) {
                    if (isNotFirst) {
                        whereCondition.append(" OR table_name = ");
                    } else {
                        whereCondition.append(" table_name = ");
                    }
                    whereCondition.append(Util.formatterPourRequete(true, tableName));
                    isNotFirst = true;
                }
                gettablesColumnsQuery = "SELECT * FROM TAP_SCHEMA.columns WHERE " + whereCondition.toString();
            }
            gettablesColumnsQuery = URLEncoder.encode(gettablesColumnsQuery, "utf-8");
            gettablesColumnsQuery = STANDARDQUERYPARAMSTEMPLATE + gettablesColumnsQuery;
            SavotResource columnResults = TapManager.getResults("updateTableColumnSchemas", dynamicTapForm.tapClient.tapBaseUrl, gettablesColumnsQuery, "sync");
            this.populateColumns(dynamicTapForm.tapClient, columnResults);
            dynamicTapForm.updateQueryChecker(tableNames);
            Future<JPanel> infoPanel = this.createMetaInfoDisplay(tapServiceUrl, dynamicTapForm.tapClient.tablesMetaData);
            if (infoPanel != null) {
                dynamicTapForm.tapClient.tackleFrameInfoServerUpdate(this.aladin, dynamicTapForm, infoPanel);
            }
            Aladin.trace(3, "done updating tap info for : " + tableNames.toString() + "| server is : " + dynamicTapForm.tapClient.tapBaseUrl);
            dynamicTapForm.ball.setMode(1);
        }
        catch (RejectedExecutionException e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            dynamicTapForm.ball.setMode(3);
            throw new Exception("Request overload! Please wait and try again.");
        }
        catch (Exception e) {
            dynamicTapForm.ball.setMode(3);
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            throw e;
        }
    }

    public static URL getUrl(String baseUrlStr, String query, String subPath) throws URISyntaxException, MalformedURLException {
        URL genUrl = null;
        if (baseUrlStr != null) {
            String path = baseUrlStr;
            int slash = 0;
            if (subPath != null) {
                if (path.endsWith("/")) {
                    ++slash;
                }
                if (subPath.startsWith("/")) {
                    ++slash;
                }
                switch (slash) {
                    case 0: {
                        path = path + "/";
                        break;
                    }
                    case 2: {
                        subPath = subPath.replaceFirst("/", "");
                        break;
                    }
                }
                path = path + subPath;
            }
            if (query != null) {
                path = path + "?" + query;
            }
            URI uri = new URI(path);
            genUrl = uri.toURL();
        }
        return genUrl;
    }

    public void eraseNotification(final JLabel notificationBar, String message, final String resetText) {
        notificationBar.setFont(Aladin.LITALIC);
        notificationBar.setText(message);
        try {
            this.aladin.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Thread currentT = Thread.currentThread();
                    String oldTName = currentT.getName();
                    try {
                        currentT.setName("TeraseNotification: ");
                        currentT.setPriority(1);
                        TimeUnit.SECONDS.sleep(3L);
                        notificationBar.setFont(Aladin.LPLAIN);
                        notificationBar.setText(resetText);
                        notificationBar.revalidate();
                        notificationBar.repaint();
                    }
                    catch (InterruptedException e) {
                        if (Aladin.levelTrace >= 3) {
                            e.printStackTrace();
                        }
                    }
                    finally {
                        currentT.setName(oldTName);
                    }
                }
            });
        }
        catch (RejectedExecutionException ex) {
            Aladin.trace(3, "RejectedExecutionException");
            notificationBar.setFont(Aladin.LPLAIN);
            notificationBar.setText(resetText);
        }
    }

    public void activateWaitMode(final ServerTap serverTap) {
        try {
            this.aladin.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Thread currentT = Thread.currentThread();
                    String oldTName = currentT.getName();
                    try {
                        currentT.setName("TmakeWait: " + serverTap.tapClient.tapLabel);
                        currentT.setPriority(1);
                        serverTap.waitCursor();
                        serverTap.info1.setText(TAPLOADINGMESSAGE);
                        serverTap.revalidate();
                        serverTap.repaint();
                    }
                    finally {
                        currentT.setName(oldTName);
                    }
                }
            });
        }
        catch (RejectedExecutionException ex) {
            Aladin.trace(3, "RejectedExecutionException");
            serverTap.ball.setMode(3);
            serverTap.info1.setText(TAPLOADERRORMESSAGE);
        }
    }

    public void populateTables(TapClient tapClient, SavotResource resultsResource) throws Exception {
        if (resultsResource != null) {
            if (resultsResource.getTableCount() <= 0) {
                if (Aladin.levelTrace >= 3) {
                    System.err.println("ERROR in populateTables! Did not read table data for " + tapClient.tapBaseUrl);
                }
                throw new Exception("ERROR while getting table information! Did not read table data from: " + tapClient.tapBaseUrl + " .\n\n Perhaps TAP_SCHEMA is not available for this server.");
            }
            long startTime = TapManager.getTimeToLog();
            block5: for (int i = 0; i < resultsResource.getTableCount(); ++i) {
                int type = this.getType(0, resultsResource);
                switch (type) {
                    case 0: {
                        this.tableReader(tapClient, resultsResource.getTRSet(i), resultsResource.getFieldSet(i));
                        continue block5;
                    }
                    case 1: {
                        this.binaryTableReader(tapClient, resultsResource.getData(i).getBinary(), resultsResource.getFieldSet(i));
                        continue block5;
                    }
                    case 2: {
                        this.binaryTableReader(tapClient, resultsResource.getData(i).getBinary2(), resultsResource.getFieldSet(i));
                        continue block5;
                    }
                    default: {
                        if (Aladin.levelTrace >= 3) {
                            System.err.println("ERROR in populateTables! Did not read table data for " + tapClient.tapBaseUrl);
                        }
                        throw new Exception("ERROR in populateTables! Did not read table data" + tapClient.tapBaseUrl);
                    }
                }
            }
            long time = TapManager.getTimeToLog();
            if (Aladin.levelTrace >= 4) {
                System.out.println("populateTables parsing: " + time + " time taken : " + (time - startTime));
            }
        }
    }

    public void populateForeignKeys(TapClient tapClient, String table_name, SavotResource resultsResource) throws Exception {
        if (resultsResource != null) {
            if (resultsResource.getTableCount() <= 0) {
                if (Aladin.levelTrace >= 3) {
                    System.err.println("ERROR in populateForeignKeys! Did not read foreign keys data for " + tapClient.tapBaseUrl);
                }
                throw new Exception("ERROR while getting foreign key information! Did not read foreign key data from: " + tapClient.tapBaseUrl + " .\n\n Perhaps TAP_SCHEMA is not available for this server.");
            }
            long startTime = TapManager.getTimeToLog();
            block5: for (int i = 0; i < resultsResource.getTableCount(); ++i) {
                int type = this.getType(0, resultsResource);
                switch (type) {
                    case 0: {
                        this.foreignKeysReader(tapClient, table_name, resultsResource.getTRSet(i), resultsResource.getFieldSet(i));
                        continue block5;
                    }
                    case 1: {
                        this.foreignKeysbinaryReader(tapClient, table_name, resultsResource.getData(i).getBinary(), resultsResource.getFieldSet(i));
                        continue block5;
                    }
                    case 2: {
                        this.foreignKeysbinaryReader(tapClient, table_name, resultsResource.getData(i).getBinary2(), resultsResource.getFieldSet(i));
                        continue block5;
                    }
                    default: {
                        if (Aladin.levelTrace >= 3) {
                            System.err.println("ERROR in populateForeignKeys! Did not read foreign keys data for " + tapClient.tapBaseUrl);
                        }
                        throw new Exception("ERROR in populateForeignKeys! Did not read table data" + tapClient.tapBaseUrl);
                    }
                }
            }
            long time = TapManager.getTimeToLog();
            if (Aladin.levelTrace >= 4) {
                System.out.println("populateForeignKeys parsing: " + time + " time taken : " + (time - startTime));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tableReader(TapClient tapClient, TRSet tableRows, FieldSet fieldSet) throws Exception {
        TapTable table = null;
        if (fieldSet != null && tableRows != null && tableRows.getItemCount() > 0) {
            for (int j = 0; j < tableRows.getItemCount(); ++j) {
                table = new TapTable();
                TDSet theTDs = tableRows.getTDSet(j);
                String tableName = null;
                for (int k = 0; k < theTDs.getItemCount(); ++k) {
                    SavotField field = (SavotField)fieldSet.getItemAt(k);
                    String fieldName = field.getName();
                    if (fieldName == null || fieldName.isEmpty()) continue;
                    if (fieldName.equalsIgnoreCase("table_name")) {
                        tableName = theTDs.getContent(k);
                        table.setTable_name(tableName);
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("table_type")) {
                        table.setTable_type(theTDs.getContent(k));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("schema_name")) {
                        table.setSchema_name(theTDs.getContent(k));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("utype")) {
                        table.setUtype(theTDs.getContent(k));
                        continue;
                    }
                    if (!fieldName.equalsIgnoreCase("description")) continue;
                    table.setDescription(theTDs.getContent(k));
                }
                if (tableName == null) continue;
                Map<String, TapTable> map = tapClient.tablesMetaData;
                synchronized (map) {
                    if (tapClient.tablesMetaData.containsKey(tableName)) {
                        TapTable oldEntry = tapClient.tablesMetaData.get(tableName);
                        if (oldEntry.getColumns() != null) {
                            table.setColumns(oldEntry.getColumns());
                        }
                        if (oldEntry.getFlaggedColumns() != null) {
                            table.setFlaggedColumns(oldEntry.getFlaggedColumns());
                        }
                        if (oldEntry.getObsCoreColumns() != null) {
                            table.setObsCoreColumns(oldEntry.getObsCoreColumns());
                        }
                    }
                    tapClient.tablesMetaData.put(tableName, table);
                    continue;
                }
            }
        } else {
            if (Aladin.levelTrace >= 3) {
                System.err.println("ERROR in populateTables! Did not read table data for " + tapClient.tapBaseUrl);
            }
            throw new Exception("ERROR in populateTables! Did not read table data" + tapClient.tapBaseUrl);
        }
    }

    protected void binaryTableReader(TapClient tapClient, SavotBinary binaryData, FieldSet fields) throws IOException {
        DataBinaryReader dataReader = new DataBinaryReader(binaryData.getStream(), fields);
        this.binaryTableReader(tapClient, dataReader, fields);
    }

    protected void binaryTableReader(TapClient tapClient, SavotBinary2 binaryData, FieldSet fields) throws IOException {
        DataBinary2Reader dataReader = new DataBinary2Reader(binaryData.getStream(), fields);
        this.binaryTableReader(tapClient, dataReader, fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void binaryTableReader(TapClient tapClient, SavotDataReader parser, FieldSet fields) throws IOException {
        try {
            TapTable table = null;
            while (parser.next()) {
                table = new TapTable();
                String tableName = null;
                for (int j = 0; j < fields.getItemCount(); ++j) {
                    table.setTable_type(parser.getCellAsString(j));
                    SavotField field = (SavotField)fields.getItemAt(j);
                    String fieldName = field.getName();
                    if (fieldName == null || fieldName.isEmpty()) continue;
                    if (fieldName.equalsIgnoreCase("table_name")) {
                        tableName = parser.getCellAsString(j);
                        table.setTable_name(tableName);
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("table_type")) {
                        table.setTable_type(parser.getCellAsString(j));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("schema_name")) {
                        table.setSchema_name(parser.getCellAsString(j));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("utype")) {
                        table.setUtype(parser.getCellAsString(j));
                        continue;
                    }
                    if (!fieldName.equalsIgnoreCase("description")) continue;
                    table.setDescription(parser.getCellAsString(j));
                }
                if (tableName == null) continue;
                Map<String, TapTable> map = tapClient.tablesMetaData;
                synchronized (map) {
                    if (tapClient.tablesMetaData.containsKey(tableName)) {
                        TapTable oldEntry = tapClient.tablesMetaData.get(tableName);
                        if (oldEntry.getColumns() != null) {
                            table.setColumns(oldEntry.getColumns());
                        }
                        if (oldEntry.getFlaggedColumns() != null) {
                            table.setFlaggedColumns(oldEntry.getFlaggedColumns());
                        }
                        if (oldEntry.getObsCoreColumns() != null) {
                            table.setObsCoreColumns(oldEntry.getObsCoreColumns());
                        }
                    }
                    tapClient.tablesMetaData.put(tableName, table);
                }
            }
            return;
        }
        catch (IOException e) {
            Aladin.trace(3, "ERROR in binaryTableReader! Did not read table data for " + tapClient.tapBaseUrl);
            if (Aladin.levelTrace < 3) throw e;
            e.printStackTrace();
            throw e;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    protected void foreignKeysReader(TapClient tapClient, String selectedTableName, TRSet tableRows, FieldSet fieldSet) throws Exception {
        ForeignKeyColumn keyColumn = null;
        if (fieldSet != null && tableRows != null && tableRows.getItemCount() > 0) {
            for (int j = 0; j < tableRows.getItemCount(); ++j) {
                String tableName = null;
                keyColumn = new ForeignKeyColumn();
                TDSet theTDs = tableRows.getTDSet(j);
                for (int k = 0; k < theTDs.getItemCount(); ++k) {
                    SavotField field = (SavotField)fieldSet.getItemAt(k);
                    String fieldName = field.getName();
                    if (fieldName == null || fieldName.isEmpty()) continue;
                    if (fieldName.equalsIgnoreCase("target_table")) {
                        tableName = theTDs.getContent(k);
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("from_table")) {
                        keyColumn.setFrom_table(theTDs.getContent(k));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("target_column")) {
                        keyColumn.setTarget_column(theTDs.getContent(k));
                        continue;
                    }
                    if (!fieldName.equalsIgnoreCase("from_column")) continue;
                    keyColumn.setFrom_column(theTDs.getContent(k));
                }
                this.setForeignKeyColumn(tapClient, tableName, keyColumn);
            }
        } else {
            if (Aladin.levelTrace >= 3) {
                System.err.println("ERROR in foreignKeysReader! Did not read keys/key-columns data for " + tapClient.tapBaseUrl);
            }
            this.setForeignKeyColumn(tapClient, selectedTableName, null);
            throw new Exception("ERROR reading foreign keys! Did not read table data: " + tapClient.tapBaseUrl);
        }
    }

    protected void foreignKeysbinaryReader(TapClient tapClient, String selectedTableName, SavotBinary binaryData, FieldSet fields) throws IOException {
        DataBinaryReader dataReader = new DataBinaryReader(binaryData.getStream(), fields);
        this.foreignKeysbinaryReader(tapClient, selectedTableName, dataReader, fields);
    }

    protected void foreignKeysbinaryReader(TapClient tapClient, String selectedTableName, SavotBinary2 binaryData, FieldSet fields) throws IOException {
        DataBinary2Reader dataReader = new DataBinary2Reader(binaryData.getStream(), fields);
        this.foreignKeysbinaryReader(tapClient, selectedTableName, dataReader, fields);
    }

    protected void foreignKeysbinaryReader(TapClient tapClient, String selectedTableName, SavotDataReader parser, FieldSet fields) throws IOException {
        try {
            ForeignKeyColumn keyColumn = null;
            while (parser.next()) {
                keyColumn = new ForeignKeyColumn();
                String tableName = null;
                for (int j = 0; j < fields.getItemCount(); ++j) {
                    SavotField field = (SavotField)fields.getItemAt(j);
                    String fieldName = field.getName();
                    if (fieldName == null || fieldName.isEmpty()) continue;
                    if (fieldName.equalsIgnoreCase("target_table")) {
                        tableName = parser.getCellAsString(j);
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("from_table")) {
                        keyColumn.setFrom_table(parser.getCellAsString(j));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("target_column")) {
                        keyColumn.setTarget_column(parser.getCellAsString(j));
                        continue;
                    }
                    if (!fieldName.equalsIgnoreCase("from_column")) continue;
                    keyColumn.setFrom_column(parser.getCellAsString(j));
                }
                this.setForeignKeyColumn(tapClient, tableName, keyColumn);
            }
        }
        catch (IOException e) {
            Aladin.trace(3, "ERROR in foreignKeysbinaryReader! Did not read keys data for " + tapClient.tapBaseUrl);
            this.setForeignKeyColumn(tapClient, selectedTableName, null);
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            throw e;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setForeignKeyColumn(TapClient tapClient, String tableName, ForeignKeyColumn keyColumn) {
        if (tableName != null) {
            Map<String, TapTable> map = tapClient.tablesMetaData;
            synchronized (map) {
                if (tapClient.tablesMetaData.containsKey(tableName)) {
                    TapTable tableToUpdate = tapClient.tablesMetaData.get(tableName);
                    if (tableToUpdate.foreignKeyColumns == null) {
                        tableToUpdate.foreignKeyColumns = new ArrayList<ForeignKeyColumn>();
                    }
                    if (keyColumn != null) {
                        tableToUpdate.foreignKeyColumns.add(keyColumn);
                    }
                }
            }
        }
    }

    protected int getType(int tableIndex, SavotResource resultsResource) {
        int type = -1;
        if (resultsResource.getTables() == null || resultsResource.getTables().getItemAt(tableIndex) == null || ((SavotTable)resultsResource.getTables().getItemAt(tableIndex)).getData() == null || ((SavotTable)resultsResource.getTables().getItemAt(tableIndex)).getData().getTableData() == null) {
            if (((SavotTable)resultsResource.getTables().getItemAt(tableIndex)).getData().getBinary2() != null) {
                type = 2;
            } else if (((SavotTable)resultsResource.getTables().getItemAt(tableIndex)).getData().getBinary() != null) {
                type = 1;
            }
        } else if (((SavotTable)resultsResource.getTables().getItemAt(tableIndex)).getData().getTableData().getTRs() != null) {
            type = 0;
        }
        return type;
    }

    public void populateColumns(TapClient tapClient, SavotResource resultsResource) throws Exception {
        if (resultsResource != null) {
            long startTime = TapManager.getTimeToLog();
            block5: for (int i = 0; i < resultsResource.getTableCount(); ++i) {
                int type = this.getType(0, resultsResource);
                switch (type) {
                    case 0: {
                        this.tableColumnReader(tapClient, resultsResource.getTRSet(i), resultsResource.getFieldSet(i));
                        continue block5;
                    }
                    case 1: {
                        this.binaryColumnReader(tapClient, resultsResource.getData(i).getBinary(), resultsResource.getFieldSet(i));
                        continue block5;
                    }
                    case 2: {
                        this.binaryColumnReader(tapClient, resultsResource.getData(i).getBinary2(), resultsResource.getFieldSet(i));
                        continue block5;
                    }
                    default: {
                        if (Aladin.levelTrace >= 3) {
                            System.err.println("ERROR in populateColumns! Did not read table column data for " + tapClient.tapBaseUrl);
                        }
                        throw new Exception("ERROR in populateColumns! Did not read table column data for " + tapClient.tapBaseUrl);
                    }
                }
            }
            long time = TapManager.getTimeToLog();
            if (Aladin.levelTrace >= 4) {
                System.out.println("populateColumns parsing: " + time + " time taken : " + (time - startTime));
            }
        }
    }

    protected void tableColumnReader(TapClient tapClient, TRSet tableRows, FieldSet fieldSet) throws Exception {
        TapTableColumn tableColumn = null;
        if (fieldSet != null && tableRows != null && tableRows.getItemCount() > 0) {
            for (int j = 0; j < tableRows.getItemCount(); ++j) {
                tableColumn = new TapTableColumn();
                TDSet theTDs = tableRows.getTDSet(j);
                for (int k = 0; k < theTDs.getItemCount(); ++k) {
                    SavotField field = (SavotField)fieldSet.getItemAt(k);
                    String fieldName = field.getName();
                    if (fieldName == null || fieldName.isEmpty()) continue;
                    if (fieldName.equalsIgnoreCase("table_name")) {
                        tableColumn.setTable_name(theTDs.getContent(k));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("column_name")) {
                        tableColumn.setColumn_name(theTDs.getContent(k));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("description")) {
                        tableColumn.setDescription(theTDs.getContent(k));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("unit")) {
                        tableColumn.setUnit(theTDs.getContent(k));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("ucd")) {
                        tableColumn.setUcd(theTDs.getContent(k));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("utype")) {
                        tableColumn.setUtype(theTDs.getContent(k));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("datatype")) {
                        tableColumn.setDatatype(theTDs.getContent(k));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("size")) {
                        tableColumn.setSize(field.getDataType(), theTDs.getContent(k));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("principal")) {
                        tableColumn.setIsPrincipal(theTDs.getContent(k));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("indexed")) {
                        tableColumn.setIsIndexed(theTDs.getContent(k));
                        continue;
                    }
                    if (!fieldName.equalsIgnoreCase("std")) continue;
                    tableColumn.setIsStandard(theTDs.getContent(k));
                }
                this.setTableIntoTapMetaData(tapClient, tableColumn);
            }
        } else {
            if (Aladin.levelTrace >= 3) {
                System.err.println("ERROR in populateColumns! Did not read table column data for " + tapClient.tapBaseUrl);
            }
            throw new Exception("ERROR in populateColumns! Did not read table column data for " + tapClient.tapBaseUrl);
        }
        this.obscorePostProcess(tapClient);
    }

    public synchronized void obscorePostProcess(TapClient tapClient) {
        for (TapTable table : tapClient.tablesMetaData.values()) {
            if (!table.hasObscoreInTheName() || tapClient.obscoreTables.containsValue(table) || table.obsCoreColumns == null || table.obsCoreColumns.size() <= 6) continue;
            tapClient.obscoreTables.put(table.getTable_name(), table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableIntoTapMetaData(TapClient tapClient, TapTableColumn tableColumn) {
        Vector<TapTableColumn> tableColumns = null;
        TapTable table = null;
        String tableName = tableColumn.getTable_name();
        if (tableName != null) {
            Map<String, TapTable> map = tapClient.tablesMetaData;
            synchronized (map) {
                if (tapClient.tablesMetaData.containsKey(tableName)) {
                    table = tapClient.tablesMetaData.get(tableColumn.getTable_name());
                    tableColumns = table.getColumns();
                    if (tableColumns == null) {
                        tableColumns = new Vector();
                        table.setColumns(tableColumns);
                    }
                } else {
                    tableColumns = new Vector();
                    table = new TapTable();
                    table.setTable_name(tableName);
                    table.setColumns(tableColumns);
                    tapClient.tablesMetaData.put(tableName, table);
                }
                table.parseUcds(tableColumn);
                table.parseForObscore(false, tableColumn);
                tableColumns.add(tableColumn);
            }
        }
    }

    protected void binaryColumnReader(TapClient tapClient, SavotBinary binaryData, FieldSet fields) throws IOException {
        DataBinaryReader dataReader = new DataBinaryReader(binaryData.getStream(), fields);
        this.binaryColumnReader(tapClient, dataReader, fields);
    }

    protected void binaryColumnReader(TapClient tapClient, SavotBinary2 binaryData, FieldSet fields) throws IOException {
        DataBinary2Reader dataReader = new DataBinary2Reader(binaryData.getStream(), fields);
        this.binaryColumnReader(tapClient, dataReader, fields);
    }

    protected void binaryColumnReader(TapClient tapClient, SavotDataReader parser, FieldSet fields) throws IOException {
        TapTableColumn tableColumn = null;
        try {
            while (parser.next()) {
                tableColumn = new TapTableColumn();
                for (int j = 0; j < fields.getItemCount(); ++j) {
                    SavotField field = (SavotField)fields.getItemAt(j);
                    String fieldName = field.getName();
                    if (fieldName == null || fieldName.isEmpty()) continue;
                    if (fieldName.equalsIgnoreCase("table_name")) {
                        tableColumn.setTable_name(parser.getCellAsString(j));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("column_name")) {
                        tableColumn.setColumn_name(parser.getCellAsString(j));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("description")) {
                        tableColumn.setDescription(parser.getCellAsString(j));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("unit")) {
                        tableColumn.setUnit(parser.getCellAsString(j));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("ucd")) {
                        tableColumn.setUcd(parser.getCellAsString(j));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("utype")) {
                        tableColumn.setUtype(parser.getCellAsString(j));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("datatype")) {
                        tableColumn.setDatatype(parser.getCellAsString(j));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("size")) {
                        tableColumn.setSize(field.getDataType(), parser.getCellAsString(j));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("principal")) {
                        tableColumn.setIsPrincipal(parser.getCellAsString(j));
                        continue;
                    }
                    if (fieldName.equalsIgnoreCase("indexed")) {
                        tableColumn.setIsIndexed(parser.getCellAsString(j));
                        continue;
                    }
                    if (!fieldName.equalsIgnoreCase("std")) continue;
                    tableColumn.setIsStandard(parser.getCellAsString(j));
                }
                this.setTableIntoTapMetaData(tapClient, tableColumn);
            }
            this.obscorePostProcess(tapClient);
        }
        catch (IOException e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.trace(3, "ERROR in binaryColumnReader! Did not read column column data for " + tapClient.tapBaseUrl);
            throw e;
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    public static void populateColumnsFromPlan(Plan planToUpload, String tableName, Map<String, TapTable> tablesMetaData) {
        Vector<TapTableColumn> tableColumns = new Vector<TapTableColumn>();
        TapTable table = null;
        TapTableColumn tableColumn = null;
        Enumeration e = planToUpload.pcat.vField.elements();
        String raName = "";
        String decName = "";
        table = new TapTable();
        table.setTable_name(tableName);
        while (e.hasMoreElements()) {
            Field f = (Field)e.nextElement();
            tableColumn = new TapTableColumn();
            tableColumn.setTable_name(tableName);
            tableColumn.setColumn_name(f.name);
            tableColumn.setDescription(f.description);
            tableColumn.setDataType(f);
            tableColumn.setUcd(f.ucd);
            tableColumn.setUnit(f.unit);
            tableColumn.setUtype(f.utype);
            table.parseUcds(tableColumn);
            table.parseForObscore(true, tableColumn);
            tableColumns.add(tableColumn);
            if (f.isRa()) {
                if (Aladin.levelTrace >= 3) {
                    System.err.println("f.isRa()" + f.isRa() + " , and its name is: " + f.name);
                }
                raName = f.name;
            }
            if (!f.isDe()) continue;
            if (Aladin.levelTrace >= 3) {
                System.err.println("f.isDe()" + f.isDe() + " , and its name is: " + f.name);
            }
            decName = f.name;
        }
        table.setColumns(tableColumns);
        tablesMetaData.put(tableName, table);
    }

    public static SavotResource getResults(String what, String tapServiceUrl, String file, String path) throws MalformedURLException, Exception {
        SavotResource resultsResource = null;
        MyInputStream is = null;
        try {
            URL url = TapManager.getUrl(tapServiceUrl, file, path);
            Aladin.trace(3, "TapManager.getResults() for: " + url);
            long startTime = TapManager.getTimeToLog();
            is = Util.openStreamForTapAndDL(url, null, true, 10000);
            long time = TapManager.getTimeToLog();
            if (Aladin.levelTrace >= 4) {
                System.out.println(what + "getResults got inputstream: " + time + " time taken: " + (time - startTime));
            }
            startTime = TapManager.getTimeToLog();
            SavotPullParser savotParser = new SavotPullParser(is, 0, null, false);
            resultsResource = Util.populateResultsResource(savotParser);
            time = TapManager.getTimeToLog();
            if (Aladin.levelTrace >= 4) {
                System.out.println(what + "getResults parsing: " + time + " time taken : " + (time - startTime));
            }
            is.close();
        }
        catch (MalformedURLException me) {
            if (Aladin.levelTrace >= 3) {
                me.printStackTrace();
            }
            throw me;
        }
        catch (IOException ioe) {
            Aladin.trace(3, ioe.getMessage());
            if (is != null) {
                is.close();
            }
            throw ioe;
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            if (is != null) {
                is.close();
            }
            throw e;
        }
        return resultsResource;
    }

    public static long getTimeToLog() {
        return System.nanoTime();
    }

    public synchronized void initialiseUploadFacadeFromAladinPlan(final Plan planToLoad, final String uploadTableName) {
        this.aladin.executor.execute(new Runnable(){

            @Override
            public void run() {
                String tableName = uploadTableName;
                if (uploadTableName == null || uploadTableName.isEmpty()) {
                    tableName = TapManager.this.uploadFacade.generateUploadTableName("TAP_UPLOAD.AladinTable");
                }
                TapManager.populateColumnsFromPlan(planToLoad, tableName, TapManager.this.uploadFacade.uploadTablesMetaData);
                TapManager.this.uploadTablesModel.addElement(tableName);
            }
        });
    }

    public void changeUploadTableName(String oldTableName, String tableName, Map<String, TapTable> tablesMetaData) {
        TapTable table = null;
        if (tablesMetaData.containsKey(oldTableName)) {
            table = tablesMetaData.get(oldTableName);
            tablesMetaData.remove(oldTableName);
            tablesMetaData.put(tableName, table);
            table.setTable_name(tableName);
            this.uploadTablesModel.removeElement(oldTableName);
            this.uploadTablesModel.addElement(tableName);
            this.uploadTablesModel.setSelectedItem(tableName);
        }
    }

    public String getFutureResultsVolume(String tapServiceUrl) throws Exception {
        String count = null;
        SavotResource resultsResource = TapManager.getResults("getCount ", tapServiceUrl, GETTAPSCHEMACOLUMNCOUNT, "sync");
        if (resultsResource != null) {
            block5: for (int i = 0; i < 1; ++i) {
                int type = this.getType(0, resultsResource);
                int index = 0;
                switch (type) {
                    case 0: {
                        count = this.getTableRowParam(index, resultsResource.getTRSet(index), resultsResource.getFieldSet(index), "COUNT");
                        continue block5;
                    }
                    case 1: {
                        count = this.getBinarySingleParam(index, resultsResource.getData(i).getBinary(), resultsResource.getFieldSet(index), "COUNT");
                        continue block5;
                    }
                    case 2: {
                        count = this.getBinary2SingleParam(index, resultsResource.getData(i).getBinary2(), resultsResource.getFieldSet(index), "COUNT");
                        continue block5;
                    }
                    default: {
                        if (Aladin.levelTrace < 3) continue block5;
                        System.err.println("ERROR in getFutureResultsVolume()! Did not read count. url:" + tapServiceUrl);
                    }
                }
            }
        }
        return count;
    }

    protected String getTableRowParam(int index, TRSet tableRows, FieldSet fieldSet, String paramName) {
        String count = String.valueOf(1000);
        TDSet theTDs = tableRows.getTDSet(index);
        SavotField field = (SavotField)fieldSet.getItemAt(index);
        String fieldName = field.getName();
        if (fieldName != null && !fieldName.isEmpty()) {
            count = theTDs.getContent(index);
        }
        return count;
    }

    protected String getBinarySingleParam(int index, SavotBinary binaryData, FieldSet fieldSet, String paramName) {
        String count;
        block4: {
            count = String.valueOf(1000);
            DataBinaryReader parser = null;
            try {
                parser = new DataBinaryReader(binaryData.getStream(), fieldSet);
                while (parser.next()) {
                    SavotField field = (SavotField)fieldSet.getItemAt(index);
                    String fieldName = field.getName().toUpperCase();
                    if (fieldName == null || fieldName.isEmpty()) continue;
                    count = parser.getCellAsString(index);
                }
            }
            catch (IOException e) {
                if (Aladin.levelTrace >= 3) {
                    System.err.println("IOError.. Count not known");
                }
                if (Aladin.levelTrace < 3) break block4;
                e.printStackTrace();
            }
        }
        return count;
    }

    protected String getBinary2SingleParam(int index, SavotBinary2 binaryData, FieldSet fieldSet, String paramName) {
        String count;
        block4: {
            count = String.valueOf(1000);
            DataBinary2Reader parser = null;
            try {
                parser = new DataBinary2Reader(binaryData.getStream(), fieldSet);
                while (parser.next()) {
                    SavotField field = (SavotField)fieldSet.getItemAt(index);
                    String fieldName = field.getName().toUpperCase();
                    if (fieldName == null || fieldName.isEmpty()) continue;
                    count = parser.getCellAsString(index);
                }
            }
            catch (IOException e) {
                if (Aladin.levelTrace >= 3) {
                    System.err.println("IOError.. Count not known");
                }
                if (Aladin.levelTrace < 3) break block4;
                e.printStackTrace();
            }
        }
        return count;
    }

    public void updateTableMetadata(final DynamicTapForm newServer, final String tapServiceUrl) {
        try {
            this.aladin.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Thread currentT = Thread.currentThread();
                    String oldTName = currentT.getName();
                    currentT.setName("TupdateTableMetadata: " + tapServiceUrl);
                    currentT.setPriority(3);
                    try {
                        SavotResource resultsResource = TapManager.getResults("gettableInfos", tapServiceUrl, TapManager.GETTAPSCHEMATABLES, "sync");
                        TapManager.this.populateTables(newServer.tapClient, resultsResource);
                        Future<JPanel> infoPanel = TapManager.this.createMetaInfoDisplay(tapServiceUrl, newServer.tapClient.tablesMetaData);
                        if (infoPanel != null) {
                            newServer.tapClient.tackleFrameInfoServerUpdate(TapManager.this.aladin, newServer, infoPanel);
                        }
                    }
                    catch (Exception e) {
                        if (Aladin.levelTrace >= 3) {
                            e.printStackTrace();
                        }
                    }
                    finally {
                        currentT.setName(oldTName);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            Aladin.trace(3, "RejectedExecutionException. Unable to update table metadata.." + tapServiceUrl);
        }
    }

    public synchronized Future<JPanel> createMetaInfoDisplay(final String tapServiceUrl, final Map<String, TapTable> tablesMetaData) {
        Future<JPanel> result = null;
        try {
            result = this.aladin.executor.submit(new Callable<JPanel>(){

                @Override
                public JPanel call() throws MalformedURLException {
                    Thread currentT = Thread.currentThread();
                    String oldTName = currentT.getName();
                    currentT.setName("TcreateInfoFrame: " + tapServiceUrl);
                    currentT.setPriority(3);
                    GridBagLayout gridbag = new GridBagLayout();
                    GridBagConstraints bagConstraints = null;
                    JPanel infoPanel = new JPanel();
                    infoPanel.setLayout(gridbag);
                    infoPanel.setFont(Aladin.PLAIN);
                    JLabel tableNameLabel = null;
                    TwoColorJTable infoTable = null;
                    JScrollPane scrollPane = null;
                    Vector<String> columnNames = TapTableColumn.getColumnLabels();
                    Vector<Vector<String>> allRows = null;
                    int width = 500;
                    int height = 115;
                    bagConstraints = new GridBagConstraints();
                    bagConstraints.gridx = 0;
                    bagConstraints.gridy = 0;
                    bagConstraints.gridwidth = 1;
                    bagConstraints.weightx = 1.0;
                    bagConstraints.weighty = 0.001;
                    bagConstraints.fill = 0;
                    bagConstraints.anchor = 17;
                    bagConstraints.insets = new Insets(20, 2, 2, 2);
                    JLabel displayString = new JLabel("Database Schema: ");
                    displayString.setFont(Aladin.BOLD);
                    gridbag.setConstraints(displayString, bagConstraints);
                    infoPanel.add(displayString);
                    JLabel tableDescription = null;
                    StringBuilder recordInfoTables = new StringBuilder();
                    for (String tableName : tablesMetaData.keySet()) {
                        String description = "";
                        Vector<TapTableColumn> columnMetadata = ((TapTable)tablesMetaData.get(tableName)).getColumns();
                        TapTable table = (TapTable)tablesMetaData.get(tableName);
                        if (table != null && table.getDescription() != null && !table.getDescription().isEmpty()) {
                            description = table.getDescription();
                        }
                        if (columnMetadata != null) {
                            tableNameLabel = new JLabel("Table: " + tableName);
                            tableNameLabel.setFont(Aladin.BOLD);
                            ++bagConstraints.gridy;
                            bagConstraints.insets = new Insets(20, 2, 2, 2);
                            infoPanel.add((Component)tableNameLabel, bagConstraints);
                            if (!description.isEmpty()) {
                                tableDescription = new JLabel("<html><p width=\"1000\">Description:" + description);
                                ++bagConstraints.gridy;
                                bagConstraints.insets = new Insets(2, 2, 2, 2);
                                infoPanel.add((Component)tableDescription, bagConstraints);
                            }
                            allRows = new Vector<Vector<String>>();
                            for (TapTableColumn tapTableColumn : columnMetadata) {
                                allRows.addElement(tapTableColumn.getRowVector());
                            }
                            infoTable = new TwoColorJTable(allRows, columnNames);
                            infoTable.setPreferredScrollableViewportSize(new Dimension(width, height));
                            scrollPane = new JScrollPane(infoTable);
                            scrollPane.getVerticalScrollBar().setUnitIncrement(4);
                            ++bagConstraints.gridy;
                            bagConstraints.insets = new Insets(2, 2, 2, 2);
                            bagConstraints.fill = 1;
                            bagConstraints.weighty = 0.05;
                            infoPanel.add((Component)scrollPane, bagConstraints);
                            continue;
                        }
                        recordInfoTables.append("\n------------Table: " + tableName + "--------------");
                        if (!description.isEmpty()) {
                            recordInfoTables.append("\n").append(description);
                        }
                        recordInfoTables.append("\nPlease select this table in the TAP server selector form to get column metadata.\n");
                    }
                    if (recordInfoTables.length() > 0) {
                        JTextArea infoTablesDisplay = new JTextArea(20, 85);
                        infoTablesDisplay.setText(recordInfoTables.toString());
                        infoTablesDisplay.setFont(Aladin.COURIER);
                        infoTablesDisplay.setBackground(Color.white);
                        infoTablesDisplay.setEditable(false);
                        scrollPane = new JScrollPane(infoTablesDisplay);
                        bagConstraints.fill = 1;
                        bagConstraints.weighty = 0.1;
                        ++bagConstraints.gridy;
                        bagConstraints.insets = new Insets(2, 2, 2, 2);
                        gridbag.setConstraints(scrollPane, bagConstraints);
                        infoPanel.add(scrollPane);
                    }
                    currentT.setName(oldTName);
                    return infoPanel;
                }
            });
        }
        catch (RejectedExecutionException ex) {
            Aladin.trace(3, "RejectedExecutionException. Unable to create the metainfo display for.." + tapServiceUrl);
        }
        return result;
    }

    public void fireSync(final Server server, final String url, final String queryString, final Map<String, Object> postParams) throws Exception {
        final int requestNumber = server.newRequestCreation();
        try {
            this.aladin.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Thread currentT = Thread.currentThread();
                    String oldTName = currentT.getName();
                    try {
                        if (postParams == null || postParams.isEmpty()) {
                            String queryParam = TapManager.STANDARDQUERYPARAMSTEMPLATE + URLEncoder.encode(queryString, "utf-8");
                            URL syncUrl = TapManager.getUrl(url, queryParam, "sync");
                            currentT.setName("TsubmitSync: " + syncUrl);
                            TapManager.handleResponse(TapManager.this.aladin, syncUrl, null, server.tapClient.tapLabel, server, queryString, requestNumber);
                        } else {
                            URL syncUrl = TapManager.getUrl(url, null, "sync");
                            currentT.setName("TsubmitSync: " + syncUrl);
                            MultiPartPostOutputStream.setTmpDir(Aladin.CACHEDIR);
                            String boundary = MultiPartPostOutputStream.createBoundary();
                            URLConnection urlConn = MultiPartPostOutputStream.createConnection(syncUrl);
                            urlConn.setRequestProperty("Accept", "*/*");
                            urlConn.setRequestProperty("Content-Type", MultiPartPostOutputStream.getContentType(boundary));
                            urlConn.setRequestProperty("Connection", "Keep-Alive");
                            HttpURLConnection http = (HttpURLConnection)urlConn;
                            http.setRequestProperty("http.agent", "Aladin/v11.024");
                            http.setRequestProperty("Accept-Encoding", "gzip");
                            MultiPartPostOutputStream out = new MultiPartPostOutputStream(urlConn.getOutputStream(), boundary);
                            out.writeField("REQUEST", "doQuery");
                            out.writeField("LANG", "ADQL");
                            out.writeField("MAXREC", "20000000");
                            out.writeField("QUERY", queryString);
                            if (postParams != null) {
                                for (Map.Entry postParam : postParams.entrySet()) {
                                    if (postParam.getValue() instanceof String) {
                                        out.writeField((String)postParam.getKey(), String.valueOf(postParam.getValue()));
                                        continue;
                                    }
                                    if (!(postParam.getValue() instanceof File)) continue;
                                    out.writeFile((String)postParam.getKey(), "application/x-votable+xml", (File)postParam.getValue(), false);
                                }
                            }
                            out.close();
                            TapManager.handleResponse(TapManager.this.aladin, syncUrl, urlConn, server.tapClient.tapLabel, server, queryString, requestNumber);
                        }
                    }
                    catch (MalformedURLException e) {
                        if (Aladin.levelTrace >= 3) {
                            e.printStackTrace();
                        }
                        TapManager.this.displayWarning(server, requestNumber, e.getMessage());
                    }
                    catch (UnknownHostException e) {
                        if (Aladin.levelTrace >= 3) {
                            e.printStackTrace();
                        }
                        TapManager.this.displayWarning(server, requestNumber, "Cannot contact server! Please try again later" + e.getMessage());
                    }
                    catch (IOException e) {
                        if (Aladin.levelTrace >= 3) {
                            e.printStackTrace();
                        }
                        TapManager.this.displayWarning(server, requestNumber, e.getMessage());
                    }
                    catch (Exception e) {
                        if (Aladin.levelTrace >= 3) {
                            e.printStackTrace();
                        }
                        TapManager.this.displayWarning(server, requestNumber, e.getMessage());
                    }
                    finally {
                        currentT.setName(oldTName);
                    }
                }
            });
        }
        catch (RejectedExecutionException ex) {
            this.displayWarning(server, requestNumber, "Unable to submit: " + queryString + "\n Request overload! Please wait and try again.");
        }
    }

    public static void handleResponse(Aladin aladin, URL url, URLConnection conn, String planeLabel, Server server, String query, int requestNumber) throws Exception {
        MyInputStream is = null;
        try {
            Aladin.trace(3, "trying url : " + url);
            is = Util.openStreamForTapAndDL(url, conn, true, 10000);
            if (requestNumber == -1 || server.requestsSent != requestNumber) {
                server = null;
            } else {
                server.disableStatusForAllPlanes();
            }
            String institute = null;
            if (server != null) {
                institute = server.institute;
            }
            aladin.calque.createPlan(is, planeLabel, institute, server, url, query, requestNumber);
        }
        catch (Exception e) {
            Aladin.trace(3, "Error when getting job!" + e.getMessage());
            throw e;
        }
    }

    public String getSyncUrlUnEncoded(Server s, String url, String queryParam) {
        String result = null;
        try {
            result = TapManager.getUrl(url, null, "sync").toString();
            if (queryParam != null) {
                result = result + "?" + queryParam;
            }
        }
        catch (Exception e) {
            if (Aladin.levelTrace > 3) {
                e.printStackTrace();
            }
            Aladin.error(s, e.getMessage());
        }
        return result;
    }

    public void fireASync(final Server server, final String url, final String queryString, final Map<String, Object> postParams) throws Exception {
        final int requestNumber = server.newRequestCreation();
        try {
            this.aladin.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Thread currentT = Thread.currentThread();
                    String oldTName = currentT.getName();
                    currentT.setName("TsubmitAsync: " + server.tapClient.tapBaseUrl);
                    try {
                        TapManager.this.uwsFacade.showAsyncPanel();
                        HashMap<String, Object> requestParams = new HashMap<String, Object>();
                        requestParams.put("REQUEST", "doQuery");
                        requestParams.put("LANG", "ADQL");
                        requestParams.put("MAXREC", "20000000");
                        requestParams.put("QUERY", queryString);
                        if (postParams != null && !postParams.isEmpty()) {
                            requestParams.putAll(postParams);
                        }
                        URL requestUrl = TapManager.getUrl(url, null, "async");
                        TapManager.this.uwsFacade.handleJob(server, server.tapClient.tapLabel, requestUrl, queryString, requestParams, true, requestNumber);
                        currentT.setName(oldTName);
                    }
                    catch (Exception e) {
                        if (Aladin.levelTrace >= 3) {
                            e.printStackTrace();
                        }
                        TapManager.this.displayWarning(server, requestNumber, Aladin.getChaine().getString("GENERICERROR"));
                    }
                }
            });
        }
        catch (RejectedExecutionException ex) {
            this.displayWarning(server, requestNumber, "Unable to submit: " + queryString + "\n Request overload! Please wait and try again.");
        }
    }

    public void setRaDecForTapServer(final ServerTap serverTap, final String selectedTableName) {
        try {
            this.aladin.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Thread currentT = Thread.currentThread();
                    String oldTName = currentT.getName();
                    currentT.setName("TsetRaDec: " + serverTap.tapClient.tapBaseUrl);
                    boolean addTargetPanel = false;
                    TapTable selectedTable = serverTap.tapClient.tablesMetaData.get(selectedTableName);
                    Vector<TapTableColumn> raColumnModel = new Vector<TapTableColumn>();
                    raColumnModel.addAll(ServerTap.getPotentialRaOrDecColumns(selectedTable.getColumns()));
                    JComboBox raColumn = new JComboBox(raColumnModel);
                    raColumn.setRenderer(new CustomListCellRenderer());
                    TapTableColumn selectColumn = serverTap.getDefaultRa();
                    if (selectColumn != null) {
                        raColumn.setSelectedItem(selectColumn);
                        selectColumn = null;
                    }
                    raColumn.setSize(raColumn.getWidth(), Server.HAUT);
                    Vector<TapTableColumn> decColumnModel = new Vector<TapTableColumn>();
                    decColumnModel = new Vector();
                    decColumnModel.addAll(raColumnModel);
                    JComboBox decColumn = new JComboBox(decColumnModel);
                    decColumn.setRenderer(new CustomListCellRenderer());
                    selectColumn = serverTap.getDefaultDec();
                    if (selectColumn != null) {
                        decColumn.setSelectedItem(selectColumn);
                    }
                    decColumn.setSize(decColumn.getWidth(), Server.HAUT);
                    Object[] raAndDec = new Object[]{"ra:", raColumn, "dec:", decColumn};
                    int option = JOptionPane.showConfirmDialog(TapManager.this.aladin.dialog, raAndDec, "Set ra and dec", 2);
                    if (option == 0) {
                        if (serverTap.getRaColumnName() == null || serverTap.getDecColumnName() == null) {
                            addTargetPanel = true;
                        }
                        TapTableColumn selected = (TapTableColumn)raColumn.getSelectedItem();
                        String selectedColumnName = null;
                        selectedColumnName = selectedTable.alias != null ? selectedTable.alias + "." + selected.getColumn_name() : selected.getColumn_name();
                        serverTap.setRaColumnName(selectedColumnName);
                        selected = (TapTableColumn)decColumn.getSelectedItem();
                        selectedColumnName = null;
                        selectedColumnName = selectedTable.alias != null ? selectedTable.alias + "." + selected.getColumn_name() : selected.getColumn_name();
                        serverTap.setDecColumnName(selectedColumnName);
                        if (addTargetPanel) {
                            if (serverTap.target == null) {
                                serverTap.targetPanel = new JPanel();
                                serverTap.createTargetPanel(serverTap.targetPanel);
                            }
                            serverTap.targetPanel.setVisible(true);
                            serverTap.queryComponentsGui.revalidate();
                            serverTap.queryComponentsGui.repaint();
                        }
                        serverTap.writeQuery();
                    }
                    if (serverTap.joinPanel != null) {
                        serverTap.joinPanel.updatePositionParams();
                    }
                    currentT.setName(oldTName);
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.displayWarning(serverTap.tapClient, "Request overload! Please wait and try again.");
        }
    }

    public boolean showOnJoinFrame(String label, String selectedTableName, JoinFacade panel) {
        boolean showFirstTimeInfo = false;
        if (this.joinFrame == null) {
            this.joinFrame = new FrameSimple(this.aladin);
            showFirstTimeInfo = true;
        }
        String displayTitle = "";
        try {
            displayTitle = String.format(JoinFacade.JOINFRAMETITLE, selectedTableName, label);
        }
        catch (Exception e) {
            displayTitle = "Create simple join constraints with " + selectedTableName + " of " + label;
        }
        this.joinFrame.show(panel, displayTitle);
        return showFirstTimeInfo;
    }

    public void setCurrentUploadPlane(String currentSelectedPlanName) {
        String valueToSelect;
        if (this.uploadFacade != null && currentSelectedPlanName != null && !currentSelectedPlanName.isEmpty() && (valueToSelect = this.uploadFacade.getUploadTableName(currentSelectedPlanName)) != null) {
            this.uploadTablesModel.setSelectedItem(valueToSelect);
        }
    }

    public boolean checkIsUploadablePlaneByLabel(String planLabel) {
        boolean result = false;
        if (this.uploadFacade.uploadTableNameDict.containsKey(planLabel)) {
            result = true;
        }
        return result;
    }

    public void closeMyJoinFacade(JoinFacade joinPanel) {
        if (this.joinFrame != null && this.joinFrame.isVisible() && (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, joinPanel) == this.joinFrame) {
            this.joinFrame.setVisible(false);
        }
    }

    public void clearJoinPanel() {
        if (this.joinFrame != null) {
            if (this.joinFrame.isShowing()) {
                this.joinFrame.setVisible(false);
            }
            this.joinFrame.dispose();
        }
    }

    public void hideTapRegistryForm() {
        if (this.tapFrameServer != null) {
            this.tapFrameServer.setVisible(false);
        }
    }

    public void addNewTapClientToCache(boolean isForDialog, String actionName, TapClient tapClient) {
        if (isForDialog) {
            tapServerPanelCache.put(actionName, tapClient);
        } else {
            tapServerTreeCache.put(actionName, tapClient);
        }
    }

    public TapClient getExistingTapClientForGluActionName(Constants.TapClientMode clientMode, String actionName) {
        TapClient result = null;
        if (clientMode == Constants.TapClientMode.TREEPANEL && tapServerTreeCache.containsKey(actionName)) {
            result = tapServerTreeCache.get(actionName);
        } else if (clientMode == Constants.TapClientMode.DIALOG && tapServerPanelCache.containsKey(actionName)) {
            result = tapServerPanelCache.get(actionName);
        }
        return result;
    }

    public void setSelectedServerLabel() {
        this.tapFrameServer.selectedServerLabel = null;
        int whichList = this.tapFrameServer.options.getSelectedIndex();
        if (whichList == 0) {
            int index = this.tapFrameServer.preselectedServersTable.getSelectedRow();
            this.tapFrameServer.selectedServerLabel = index >= 0 ? splTapServerLabels.get(index) : null;
        } else if (whichList == 1) {
            int index = this.tapFrameServer.allServersTable.getSelectedRow();
            if (index >= 0) {
                Vector<String> dataLabel = this.tapFrameServer.allServersDataLabelTable.getDataLabelAt(index);
                this.tapFrameServer.selectedServerLabel = dataLabel;
            } else {
                this.tapFrameServer.selectedServerLabel = null;
            }
        }
    }

    public boolean canReload(String cacheId) {
        boolean result = false;
        if (tapServerPanelCache.containsKey(cacheId) && TapManager.tapServerPanelCache.get((Object)cacheId).serverTap != null && TapManager.tapServerPanelCache.get((Object)cacheId).serverTap.isVisible()) {
            result = true;
        }
        return result;
    }

    public ServerTapExamples getNewServerTapExamplesInstance(TapClient tapClient, boolean isFullServerCapability) {
        ServerTapExamples newServer = new ServerTapExamples(this.aladin);
        this.initNewServerTap(newServer, tapClient, isFullServerCapability);
        return newServer;
    }

    public void initNewServerTap(DynamicTapForm newServer, TapClient tapClient, boolean isFullServerCapability) {
        newServer.setName(tapClient.tapLabel);
        newServer.tapClient = tapClient;
        newServer.setOpaque(true);
        newServer.isFullServer = isFullServerCapability;
        newServer.formLoadStatus = 0;
    }

    public ServerTap getNewServerTapInstance(TapClient tapClient, boolean isFullServerCapability) {
        ServerTap newServer = new ServerTap(this.aladin);
        this.initNewServerTap(newServer, tapClient, isFullServerCapability);
        return newServer;
    }

    public ServerObsTap getNewServerObsTapInstance(TapClient tapClient) {
        ServerObsTap newServer = new ServerObsTap(this.aladin);
        this.initNewServerTap(newServer, tapClient, true);
        return newServer;
    }

    public static Server getTapServerForLabel(String label) {
        ServerTap result = null;
        if (tapServerPanelCache.containsKey(label)) {
            result = TapManager.tapServerPanelCache.get((Object)label).serverTap;
        } else if (tapServerTreeCache.containsKey(label)) {
            result = TapManager.tapServerTreeCache.get((Object)label).serverTap;
        }
        return result;
    }

    public void displayWarning(TapClient tapClient, String message) {
        if (tapClient.mode == Constants.TapClientMode.TREEPANEL) {
            Aladin.error(this.tapPanelFromTree, message);
        } else {
            Aladin.error(this.aladin.dialog, message);
        }
    }

    public void displayWarning(Server server, int requestNumber, String message) {
        this.displayWarning(server.tapClient, message);
        server.setStatusForCurrentRequest(requestNumber, 3);
    }

    public static String getFullyQualifiedTableName(DefaultDBTable defaultDBTable) {
        StringBuffer tableName = new StringBuffer();
        if (defaultDBTable.getADQLCatalogName() != null) {
            tableName.append(defaultDBTable.getADQLCatalogName()).append(".");
        }
        if (defaultDBTable.getADQLSchemaName() != null) {
            tableName.append(defaultDBTable.getADQLSchemaName()).append(".");
        }
        if (defaultDBTable.getADQLName() != null) {
            tableName.append(defaultDBTable.getADQLName());
        }
        return tableName.toString();
    }

    public static boolean areSameQueryCheckerTables(DefaultDBTable input1, DefaultDBTable input2) {
        String input2QualifiedName;
        boolean result = false;
        String input1QualifiedName = TapManager.getFullyQualifiedTableName(input1);
        if (!input1QualifiedName.isEmpty() && !(input2QualifiedName = TapManager.getFullyQualifiedTableName(input2)).isEmpty() && input1QualifiedName.equalsIgnoreCase(input2QualifiedName)) {
            result = true;
        }
        return result;
    }

    public void updateAddUploadPlans(Plan newPlan) {
        if (this.uploadFacade != null && this.uploadTablesModel != null && newPlan.pcat != null && newPlan instanceof PlanCatalog && newPlan.pcat.flagVOTable) {
            try {
                this.uploadFacade.allowPlanIntoUploadFacade(newPlan);
                PlanCatalog planCatalog = (PlanCatalog)newPlan;
                this.uploadFacade.updateUploadGuiWithNewUpload(planCatalog);
            }
            catch (Exception e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                Aladin.trace(3, "Unable to parse " + newPlan.label + " data for upload");
            }
        }
    }

    public void updateDeleteUploadPlans(Plan planInDeletion) {
        if (this.uploadFacade != null) {
            this.uploadFacade.deleteAvailableUploadTable(planInDeletion);
        }
    }

    public void reAddPlan(Plan plan) {
        this.updateDeleteUploadPlans(plan);
        this.updateAddUploadPlans(plan);
        if (this.joinFrame != null) {
            Aladin.info(this.joinFrame, UPLOADTABLECHANGEWARNING);
        }
    }

    public UploadFacade initUploadFrame() {
        if (this.uploadFacade == null) {
            this.uploadFacade = new UploadFacade(this.aladin);
        }
        return this.uploadFacade;
    }

    public Map<String, TapTable> initUploadFrameAndGetUploadedTables() {
        this.initUploadFrame();
        return this.uploadFacade.uploadTablesMetaData;
    }

    public Map<String, TapTable> getUploadedTables() {
        Map<String, TapTable> results = null;
        if (this.uploadFacade != null && this.uploadFacade.uploadTablesMetaData != null) {
            results = this.uploadFacade.uploadTablesMetaData;
        }
        return results;
    }

    public ComboBoxModel getUploadClientModel() {
        return this.uploadTablesModel;
    }

    static {
        tapServerPanelCache = new HashMap<String, TapClient>();
        tapServerTreeCache = new HashMap<String, TapClient>();
        GENERICERROR = Aladin.getChaine().getString("GENERICERROR");
        TAPLOADINGMESSAGE = Aladin.getChaine().getString("TAPLOADINGMESSAGE");
        TAPLOADERRORMESSAGE = Aladin.getChaine().getString("TAPLOADERRORMESSAGE");
        UPLOADTABLECHANGEWARNING = Aladin.getChaine().getString("UPLOADTABLECHANGEWARNING");
    }
}

