/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import adql.db.DBChecker;
import adql.db.DBType;
import adql.db.DefaultDBColumn;
import adql.db.DefaultDBTable;
import cds.aladin.Aladin;
import cds.aladin.Constants;
import cds.aladin.Coord;
import cds.aladin.DynamicTapForm;
import cds.aladin.FrameInfoServer;
import cds.aladin.Server;
import cds.aladin.ServerGlu;
import cds.aladin.ServerObsTap;
import cds.aladin.ServerTap;
import cds.aladin.ServerTapExamples;
import cds.aladin.TapClientModesRenderer;
import cds.aladin.TapManager;
import cds.aladin.TapTable;
import cds.aladin.TapTableColumn;
import cds.tools.Util;
import cds.xml.VOSICapabilitiesReader;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Insets;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class TapClient {
    public static String modesLabel = "Modes";
    public static String modesToolTip;
    public DefaultComboBoxModel model = null;
    public static String RELOAD;
    public static String TIPRELOAD;
    public static String GENERICERROR;
    public static String TARGETERROR;
    public static String NOGLURECFOUND;
    public static String CHANGESERVERTOOLTIP;
    public static String INVALIDNUMBERINPUT;
    public TapManager tapManager;
    public String tapLabel;
    public String tapBaseUrl;
    public List<String> nodeTableNames;
    public ServerGlu serverGlu;
    public ServerTap serverTapNode;
    public ServerTap serverTap;
    public ServerObsTap serverObsTap;
    public ServerTapExamples serverExamples;
    public Constants.TapClientMode mode;
    public Future<JPanel> infoPanel;
    Coord target;
    double radius;
    Map<String, TapTable> tablesMetaData;
    Future<VOSICapabilitiesReader> capabilities;
    public String nodeName = null;
    public static Map<String, DBType.DBDatatype> DBDATATYPES;
    List<DefaultDBTable> queryCheckerTables;
    Color primaryColor = Aladin.BLUE;
    Color secondColor = new Color(198, 218, 239);
    private boolean editing = false;
    public Map<String, TapTable> obscoreTables = new LinkedHashMap<String, TapTable>();

    public TapClient() {
    }

    public void updateNodeAndSetModes(String nodeTable) {
        boolean edit = false;
        if (this.nodeName == null) {
            edit = true;
        }
        if (nodeTable != null) {
            this.nodeName = nodeTable;
            this.nodeTableNames = new ArrayList<String>();
            this.nodeTableNames.add(nodeTable);
        }
        if (this.model != null) {
            if (edit) {
                this.editing = true;
                this.model.insertElementAt(this.nodeName, 1);
                this.editing = false;
            }
        } else {
            String[] modesAllowed = null;
            modesAllowed = this.nodeName != null ? new String[]{this.nodeName, "Generic", "Templates", "Obscore"} : new String[]{"Generic", "Templates", "Obscore"};
            this.model = new DefaultComboBoxModel<String>(modesAllowed);
        }
    }

    public TapClient(Constants.TapClientMode mode, TapManager tapManager, String tapLabel, String tapBaseUrl, String nodeTable) {
        this.mode = mode;
        this.tapManager = tapManager;
        this.tapLabel = tapLabel;
        this.tapBaseUrl = tapBaseUrl;
        if (mode != Constants.TapClientMode.STANDALONE) {
            this.updateNodeAndSetModes(nodeTable);
            this.model.addListDataListener(new ListDataListener(){

                @Override
                public void intervalRemoved(ListDataEvent arg0) {
                }

                @Override
                public void intervalAdded(ListDataEvent arg0) {
                }

                @Override
                public void contentsChanged(ListDataEvent arg0) {
                    Server serverToDisplay = null;
                    try {
                        if (!TapClient.this.editing) {
                            String selected = (String)TapClient.this.model.getSelectedItem();
                            serverToDisplay = TapClient.this.getServerToDisplay(selected);
                            if (Aladin.levelTrace >= 3) {
                                System.out.println("contentsChanged" + (Object)((Object)TapClient.this.mode) + "  " + selected);
                            }
                            if (TapClient.this.mode == Constants.TapClientMode.TREEPANEL) {
                                TapClient.this.tapManager.showTapPanelFromTree(TapClient.this.tapLabel, serverToDisplay);
                            } else {
                                TapClient.this.tapManager.showTapServerOnServerSelector(serverToDisplay);
                            }
                        }
                    }
                    catch (Exception ex) {
                        if (Aladin.levelTrace >= 3) {
                            ex.printStackTrace();
                        }
                        if (serverToDisplay == null) {
                            Aladin.error("Error! unable load tap server!" + ex.getMessage());
                        }
                        Aladin.error(serverToDisplay, "Error! unable load tap server!" + ex.getMessage());
                    }
                }
            });
        }
    }

    @Deprecated
    public static TapClient getUploadTapClient(Aladin aladin, String tapLabel, String mainServerUrl) {
        TapManager tapManager = TapManager.getInstance(aladin);
        TapClient tapClient = new TapClient(Constants.TapClientMode.UPLOAD, tapManager, tapLabel, mainServerUrl, null);
        tapClient.serverTap = new ServerTap(aladin);
        tapClient.serverTap.tapClient = tapClient;
        tapClient.tablesMetaData = new HashMap<String, TapTable>();
        return tapClient;
    }

    public JButton getChangeServerButton(Server server) {
        JButton button = null;
        if (this.mode != Constants.TapClientMode.STANDALONE) {
            Image image = Aladin.aladin.getImagette("changeServerOptions.png");
            button = image == null ? new JButton("Change server") : new JButton(new ImageIcon(image));
            button.setBorderPainted(false);
            button.setMargin(new Insets(0, 0, 0, 0));
            button.setContentAreaFilled(true);
            button.setActionCommand("CHANGESERVER");
            button.addActionListener(server);
            button.setToolTipText(CHANGESERVERTOOLTIP);
        }
        return button;
    }

    public JPanel getModes(Server server) {
        JPanel optionsPanel = null;
        if (this.mode != Constants.TapClientMode.STANDALONE) {
            optionsPanel = new JPanel(new FlowLayout(2, 0, 0));
            server.modeChoice = new JComboBox(this.model);
            server.modeChoice.setRenderer(new TapClientModesRenderer(this));
            server.modeChoice.setToolTipText(modesToolTip);
            optionsPanel.add(server.modeChoice);
            if (this.serverGlu != null && this.serverTap != null && this.serverTap.modeChoice != null) {
                this.serverTap.modeChoice.revalidate();
                this.serverTap.modeChoice.repaint();
            }
        }
        return optionsPanel;
    }

    public static JButton getReloadButton() {
        JButton reloadButton = null;
        Image image = Aladin.aladin.getImagette("reload.png");
        reloadButton = image == null ? new JButton("Reload") : new JButton(new ImageIcon(image));
        reloadButton.setBorderPainted(false);
        reloadButton.setMargin(new Insets(0, 0, 0, 0));
        reloadButton.setContentAreaFilled(true);
        reloadButton.setActionCommand(RELOAD);
        reloadButton.setToolTipText(TIPRELOAD);
        return reloadButton;
    }

    public Server getServerToDisplay(String serverType) throws Exception {
        Server resultServer = null;
        DynamicTapForm dynamicTapForm = null;
        this.editing = true;
        if (serverType == "Basic" && this.serverGlu != null) {
            resultServer = this.serverGlu;
        } else {
            boolean isFullServerCapability = true;
            if (this.nodeName != null && this.nodeTableNames != null) {
                isFullServerCapability = false;
            }
            if (this.nodeName != null && serverType == this.nodeName) {
                if (this.serverTapNode == null) {
                    this.serverTapNode = this.tapManager.getNewServerTapInstance(this, isFullServerCapability);
                }
                dynamicTapForm = this.serverTapNode;
                this.model.setSelectedItem(this.nodeName);
            } else if (serverType == "Generic") {
                if (this.serverTap == null) {
                    this.serverTap = this.tapManager.getNewServerTapInstance(this, true);
                }
                dynamicTapForm = this.serverTap;
                this.model.setSelectedItem(serverType);
            } else if (serverType == "Templates") {
                if (this.serverExamples == null) {
                    this.serverExamples = this.tapManager.getNewServerTapExamplesInstance(this, isFullServerCapability);
                }
                dynamicTapForm = this.serverExamples;
                this.model.setSelectedItem("Templates");
            } else if (serverType == "Obscore" && !this.obscoreTables.isEmpty()) {
                if (this.serverObsTap == null) {
                    this.serverObsTap = this.tapManager.getNewServerObsTapInstance(this);
                }
                dynamicTapForm = this.serverObsTap;
                this.model.setSelectedItem("Obscore");
            } else if (this.serverTapNode != null && this.serverTapNode.isLoaded()) {
                dynamicTapForm = this.serverTapNode;
                if (this.nodeName != null) {
                    this.model.setSelectedItem(this.nodeName);
                } else {
                    this.model.setSelectedItem("NODE");
                }
            } else if (this.serverTap != null && this.serverTap.isLoaded()) {
                dynamicTapForm = this.serverTap;
                this.model.setSelectedItem("Generic");
            } else if (this.serverExamples != null && this.serverExamples.isLoaded()) {
                dynamicTapForm = this.serverExamples;
                this.model.setSelectedItem("Templates");
            } else if (this.serverObsTap != null && !this.obscoreTables.isEmpty()) {
                dynamicTapForm = this.serverObsTap;
                this.model.setSelectedItem("Obscore");
            } else if (this.nodeName != null) {
                this.serverTapNode = this.tapManager.getNewServerTapInstance(this, isFullServerCapability);
                dynamicTapForm = this.serverTapNode;
                this.model.setSelectedItem(this.nodeName);
            } else {
                this.serverTap = this.tapManager.getNewServerTapInstance(this, isFullServerCapability);
                dynamicTapForm = this.serverTap;
                this.model.setSelectedItem("Generic");
            }
            if (dynamicTapForm != null && dynamicTapForm.formLoadStatus == 0) {
                if (this.tablesMetaData == null || this.tablesMetaData.isEmpty()) {
                    this.tapManager.createAndLoadATapServer(this, dynamicTapForm);
                } else {
                    dynamicTapForm.showloading();
                    this.tapManager.createGenericTapFormFromMetaData(dynamicTapForm);
                }
            }
            resultServer = dynamicTapForm;
        }
        this.editing = false;
        return resultServer;
    }

    protected void tackleFrameInfoServerUpdate(Aladin aladin, DynamicTapForm newServer, Future<JPanel> newInfoPanel) {
        block13: {
            try {
                FrameInfoServer frameInfoServer = null;
                if (this.infoPanel != null) {
                    if (this.infoPanel.isDone()) {
                        JPanel infoPanel = this.infoPanel.get();
                        frameInfoServer = (FrameInfoServer)SwingUtilities.getRoot(infoPanel);
                        if (frameInfoServer != null) {
                            frameInfoServer.setAdditionalComponent(newInfoPanel);
                            if (frameInfoServer.isVisible()) {
                                frameInfoServer.updateInfoPanel();
                                frameInfoServer.revalidate();
                                frameInfoServer.repaint();
                            } else {
                                frameInfoServer.setFlagUpdate(1);
                            }
                        }
                    } else {
                        this.infoPanel.cancel(true);
                    }
                } else if (aladin.frameInfoServer != null && aladin.frameInfoServer.getServer() != null && aladin.frameInfoServer.getServer().equals(newServer)) {
                    frameInfoServer = newInfoPanel == null ? new FrameInfoServer(aladin) : new FrameInfoServer(aladin, newInfoPanel);
                    if (aladin.frameInfoServer.isVisible()) {
                        frameInfoServer.updateInfoPanel();
                        aladin.frameInfoServer.dispose();
                        aladin.frameInfoServer = frameInfoServer;
                        frameInfoServer.revalidate();
                        frameInfoServer.repaint();
                        String visibleServer = (String)this.model.getSelectedItem();
                        if (!visibleServer.equals("Basic")) {
                            frameInfoServer.show(this.serverTap);
                        }
                    } else {
                        frameInfoServer.setFlagUpdate(1);
                    }
                }
                this.infoPanel = newInfoPanel;
                this.tapManager.updateServerMetaDataInCache(this, true);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block13;
                e.printStackTrace();
            }
        }
    }

    public void preprocessTapClient() {
        Map<String, TapTable> backUpTablesMetaData = this.tablesMetaData;
        LinkedList<Map.Entry<String, TapTable>> sorter = new LinkedList<Map.Entry<String, TapTable>>();
        sorter.addAll(this.tablesMetaData.entrySet());
        Collections.sort(sorter, new Comparator<Map.Entry<String, TapTable>>(){

            @Override
            public int compare(Map.Entry<String, TapTable> o1, Map.Entry<String, TapTable> o2) {
                int one = 0;
                int two = 0;
                if (o2.getValue().flaggedColumns != null) {
                    two = o2.getValue().flaggedColumns.size();
                }
                if (o2.getValue().obsCoreColumns != null) {
                    two += o2.getValue().obsCoreColumns.size();
                }
                if (o1.getValue().flaggedColumns != null) {
                    one = o1.getValue().flaggedColumns.size();
                }
                if (o1.getValue().obsCoreColumns != null) {
                    one += o1.getValue().obsCoreColumns.size();
                }
                return two - one;
            }
        });
        if (this.queryCheckerTables == null) {
            this.queryCheckerTables = new ArrayList<DefaultDBTable>();
        } else {
            this.queryCheckerTables.clear();
        }
        LinkedHashMap<String, TapTable> sorted = new LinkedHashMap<String, TapTable>();
        LinkedHashMap tapSchemaMeta = new LinkedHashMap();
        for (Map.Entry entry : sorter) {
            DefaultDBTable parserTable = new DefaultDBTable((String)entry.getKey());
            Vector<TapTableColumn> columnsMeta = backUpTablesMetaData.get(entry.getKey()).getColumns();
            TapClient.updateQueryCheckTableColumns(parserTable, columnsMeta);
            this.queryCheckerTables.add(parserTable);
            if (TapClient.isSchemaTable((String)entry.getKey())) {
                tapSchemaMeta.put(entry.getKey(), entry.getValue());
                continue;
            }
            sorted.put((String)entry.getKey(), (TapTable)entry.getValue());
        }
        sorted.putAll(tapSchemaMeta);
        this.tablesMetaData = sorted;
        this.tapManager.setTargetDimensions(this);
    }

    public static boolean isSchemaTable(String tableName) {
        boolean result = false;
        Pattern tapSchemaPattern = Pattern.compile("schemas|TAP_SCHEMA.tables|TAP_SCHEMA.keys|key_columns|columns", 2);
        Matcher matcher = tapSchemaPattern.matcher(tableName);
        if (matcher.find()) {
            result = true;
        }
        return result;
    }

    public static void updateQueryCheckTableColumns(DefaultDBTable parserTable, Vector<TapTableColumn> columnsMeta) {
        if (parserTable != null && columnsMeta != null) {
            for (TapTableColumn tapTableColumn : columnsMeta) {
                String datatype;
                int offset;
                DefaultDBColumn columnForParser = new DefaultDBColumn(tapTableColumn.getColumn_name(), parserTable);
                if (tapTableColumn.getDatatype() != null && !tapTableColumn.getDatatype().isEmpty() && (offset = tapTableColumn.getDatatype().indexOf("adql:")) != -1 && offset + 5 < tapTableColumn.getDatatype().length() && DBDATATYPES.containsKey(datatype = tapTableColumn.getDatatype().substring(offset + 5))) {
                    DBType.DBDatatype dbDataType = DBDATATYPES.get(datatype);
                    DBType type = null;
                    type = tapTableColumn.getSize() > 0 ? new DBType(dbDataType, tapTableColumn.getSize()) : new DBType(dbDataType);
                    columnForParser.setDatatype(type);
                }
                parserTable.addColumn(columnForParser);
            }
        }
    }

    public static String isInValidOperatorNumber(Server s, String input, boolean showError) {
        String inputInProgress = null;
        Pattern regex = Pattern.compile("^\\s*((?<operator>>=|<=|!=|[><=])\\s*)?(?<value>[-+]?\\d+(\\.\\d+)?([eE]{1}[-+]?\\d+)?){1}$");
        Matcher matcher = regex.matcher(input);
        if (matcher.find()) {
            inputInProgress = matcher.group("operator") == null ? "=".concat(input) : input;
        } else if (showError) {
            Aladin.error(s, s.getNumberIncorrectMessage(input));
            s.ball.setMode(3);
        }
        return inputInProgress;
    }

    public static String getRangeInput(String input, String outputRegEx) {
        String result = "";
        Pattern regex = Pattern.compile("^(?<range1>[-+]?\\d+(\\.\\d+)?([eE]{1}[-+]?\\d+)?){1}\\s*(?<operator>\\.\\.|,|and|AND|\\s+)\\s*(?<range2>[-+]?\\d+(\\.\\d+)?([eE]{1}[-+]?\\d+)?){1}\\s*$");
        Matcher matcher = regex.matcher(input);
        if (matcher.find()) {
            if (outputRegEx == null || outputRegEx.isEmpty()) {
                outputRegEx = "BETWEEN ${range1} AND ${range2}";
            }
            result = matcher.replaceAll(outputRegEx);
        }
        return result;
    }

    public static String getStringInput(String input, boolean processAsString) {
        String inputInProgress = null;
        Pattern regex = Pattern.compile("^\\s*((?<operator>=|!=|LIKE|NOT LIKE|IS NOT|IS)\\s+)?(?<value>(.*)(?!\\s))$", 2);
        Matcher matcher = regex.matcher(input);
        if (matcher.find()) {
            String value = matcher.group("value");
            String operator = matcher.group("operator");
            if (operator == null || operator.isEmpty()) {
                operator = "= ";
            }
            if (value != null && !value.isEmpty()) {
                inputInProgress = operator.toUpperCase() + " " + Util.formatterPourRequete(processAsString, matcher.group("value"));
            }
        }
        return inputInProgress;
    }

    public void reload(DynamicTapForm dynamicTapForm) throws Exception {
        if (this.serverTapNode != null) {
            this.serverTapNode.removeAll();
            this.serverTapNode.formLoadStatus = 0;
        }
        if (this.serverTap != null) {
            this.serverTap.removeAll();
            this.serverTap.resetJoin();
            this.serverTap.formLoadStatus = 0;
        }
        if (this.serverExamples != null) {
            this.serverExamples.removeAll();
            this.serverExamples.formLoadStatus = 0;
            this.serverExamples.initExamples = true;
        }
        if (this.serverObsTap != null) {
            this.serverObsTap.removeAll();
            this.serverObsTap.formLoadStatus = 0;
        }
        this.infoPanel = null;
        this.tapManager.createAndLoadATapServer(this, dynamicTapForm);
        if (this.mode == Constants.TapClientMode.TREEPANEL) {
            this.tapManager.showTapPanelFromTree(this.tapLabel, dynamicTapForm);
        } else {
            this.tapManager.showTapServerOnServerSelector(dynamicTapForm);
        }
        dynamicTapForm.revalidate();
        dynamicTapForm.repaint();
    }

    public boolean isUploadAllowed() {
        boolean result = false;
        if (this.capabilities != null) {
            try {
                VOSICapabilitiesReader meta = this.capabilities.get();
                result = meta.isUploadAllowed();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public void updateUploadedTablesToADQLParser(DynamicTapForm server, Map<String, Object> requestParams) throws Exception {
        ArrayList<DefaultDBTable> queryCheckerTablesUpdate = new ArrayList<DefaultDBTable>();
        if (this.queryCheckerTables != null && !this.queryCheckerTables.isEmpty()) {
            queryCheckerTablesUpdate.addAll(this.queryCheckerTables);
        }
        Map<String, TapTable> uploadedTables = this.tapManager.getUploadedTables();
        ArrayList<String> uploadTablesReferenced = new ArrayList<String>();
        if (uploadedTables != null) {
            for (String uploadtable : uploadedTables.keySet()) {
                if (!server.tap.getText().toUpperCase().contains(uploadtable.toUpperCase())) continue;
                if (requestParams != null && !this.tapManager.uploadFacade.uploadTableNameDict.containsValue(uploadtable)) {
                    Aladin.error(server, "Unable to submit " + uploadtable + " data!");
                    Aladin.trace(3, "No file found for " + uploadtable);
                } else {
                    uploadTablesReferenced.add(uploadtable);
                }
                server.updateQueryChecker(true, uploadtable, this.tapManager.uploadFacade.uploadTablesMetaData, queryCheckerTablesUpdate);
            }
            this.tapManager.uploadFacade.addUploadToSubmitParams(uploadTablesReferenced, requestParams);
            DBChecker checker = new DBChecker(queryCheckerTablesUpdate);
            server.adqlParser.setQueryChecker(checker);
        }
    }

    public void activateWaitMode(ServerTap serverTap) {
        this.tapManager.activateWaitMode(serverTap);
    }

    public String getVisibleLabel() {
        String results = this.tapLabel;
        if (this.tapLabel.equalsIgnoreCase(this.tapBaseUrl)) {
            try {
                results = Util.getDomainNameFromUrl(this.tapBaseUrl);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    public void setData(Map<String, TapTable> tablesMetaData) {
        this.tablesMetaData = tablesMetaData;
    }

    static {
        DBDATATYPES = new HashMap<String, DBType.DBDatatype>();
        RELOAD = Aladin.chaine.getString("FSRELOAD");
        TIPRELOAD = Aladin.chaine.getString("TIPRELOAD");
        modesToolTip = Aladin.chaine.getString("TAPMODESTOOLTIP");
        GENERICERROR = Aladin.chaine.getString("GENERICERROR");
        for (DBType.DBDatatype dbDatatype : DBType.DBDatatype.values()) {
            DBDATATYPES.put(dbDatatype.name(), dbDatatype);
        }
        TARGETERROR = Aladin.chaine.getString("TARGETERROR");
        NOGLURECFOUND = Aladin.chaine.getString("NOGLURECFOUND");
        CHANGESERVERTOOLTIP = Aladin.chaine.getString("CHANGESERVERTOOLTIP");
    }
}

