/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.tools.Util;
import java.util.Vector;

public final class Synchro {
    static final boolean VERBOSE = false;
    private Vector<Task> taskList;
    private long defaultDelay;
    private transient boolean lock;
    private final Object lockObj = new Object();

    public Synchro() {
        this(0L);
    }

    public Synchro(long defaultDelay) {
        this.defaultDelay = defaultDelay;
        this.taskList = new Vector();
    }

    public boolean isReady() {
        try {
            this.waitLock();
            this.checkTask();
            boolean bl = this.taskList.size() == 0;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public String start(String proposedTaskId) {
        return this.start(proposedTaskId, 0L, null);
    }

    public String start(String proposedTaskId, long delay) {
        return this.start(proposedTaskId, delay, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String start(String proposedTaskId, long delay, String cmd) {
        try {
            this.waitLock();
            Task t = new Task();
            t.taskId = this.getUniqueTaskId(proposedTaskId);
            t.cmd = cmd;
            t.endTime = delay > 0L ? System.currentTimeMillis() + delay : (this.defaultDelay > 0L ? System.currentTimeMillis() + this.defaultDelay : 0L);
            this.taskList.addElement(t);
            String string = t.taskId;
            return string;
        }
        finally {
            this.unlock();
        }
    }

    public void stop(String taskId) {
        if (taskId == null) {
            return;
        }
        try {
            this.waitLock();
            this.checkTask(taskId);
        }
        finally {
            this.unlock();
        }
    }

    public String waitingTasks() {
        try {
            this.waitLock();
            String string = this.toString();
            return string;
        }
        finally {
            this.unlock();
        }
    }

    public void reset() {
        this.unlock();
        this.taskList.clear();
    }

    public void waitUntil() {
        try {
            this.waitUntil(0L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void waitUntil(long delay) throws Exception {
        long t = System.currentTimeMillis();
        while (!this.isReady()) {
            if (delay > 0L && System.currentTimeMillis() - t > delay) {
                throw new Exception("Synchro.waitUntil() time out");
            }
            this.sleep(25);
        }
    }

    private void sleep(int delay) {
        try {
            Thread.currentThread();
            Thread.sleep(delay);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getUniqueTaskId(String proposedTaskId) {
        int n = 0;
        for (Task t : this.taskList) {
            if (!t.taskId.equals(proposedTaskId)) continue;
            ++n;
        }
        return n == 0 ? proposedTaskId : proposedTaskId + "~" + n;
    }

    private void checkTask() {
        this.checkTask(null);
    }

    private void checkTask(String taskId) {
        long time = System.currentTimeMillis();
        for (int i = 0; i < this.taskList.size(); ++i) {
            Task t = this.taskList.get(i);
            if ((t.endTime <= 0L || t.endTime >= time) && !t.taskId.equals(taskId)) continue;
            this.taskList.removeElementAt(i);
            --i;
        }
    }

    public String toString() {
        if (this.taskList.size() == 0) {
            return "Synchro: no task";
        }
        StringBuffer s = new StringBuffer("Waiting " + this.taskList.size() + " tasks:\n");
        for (Task t : this.taskList) {
            s.append("." + t + "\n");
        }
        return s.toString();
    }

    private void waitLock() {
        while (!this.getLock()) {
            this.sleep(100);
        }
    }

    private void unlock() {
        this.lock = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getLock() {
        Object object = this.lockObj;
        synchronized (object) {
            if (this.lock) {
                return false;
            }
            this.lock = true;
            return true;
        }
    }

    private static boolean testThread() {
        final Synchro synchro = new Synchro();
        Thread a = new Thread("Thread A"){

            @Override
            public void run() {
                System.out.println("Starting thread A");
                String un = synchro.start("bidule");
                System.out.println("Thread A adds " + un);
                String deux = synchro.start("truc");
                System.out.println("Thread A adds " + deux);
                synchro.stop(un);
                System.out.println("Thread A removes " + un);
                System.out.println("Endind thread A");
            }
        };
        Thread b = new Thread("Thread B"){

            @Override
            public void run() {
                System.out.println("Starting thread B");
                String un = synchro.start("bidule");
                System.out.println("Thread B adds " + un);
                String deux = synchro.start("truc");
                System.out.println("Thread B adds " + deux);
                synchro.stop(deux);
                System.out.println("Thread B removes " + deux);
                System.out.println("Endind thread B");
            }
        };
        Thread c = new Thread("Thread c"){

            @Override
            public void run() {
                System.out.println("Starting thread C");
                synchro.waitUntil();
                System.out.println("Endind thread C");
            }
        };
        a.start();
        try {
            Thread.currentThread();
            Thread.sleep(15L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        b.start();
        c.start();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("*******************\n" + synchro.waitingTasks() + "*******************\n");
        try {
            Thread.currentThread();
            Thread.sleep(3000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        synchro.reset();
        System.out.println("Termin\u00e9");
        return true;
    }

    private static boolean testBasic() {
        Synchro synchro = new Synchro(6000L);
        String un = synchro.start("TacheUne", 2000L);
        String deux = synchro.start("TacheDeux");
        String trois = synchro.start("TacheUne", 3000L);
        System.out.println("Les taches indiqu\u00e9es : " + un + ", " + deux + ", " + trois);
        System.out.println(synchro.waitingTasks());
        Util.pause(2500);
        System.out.println(synchro.waitingTasks());
        synchro.stop(deux);
        System.out.println(synchro.waitingTasks());
        synchro.waitUntil();
        System.out.println(synchro.waitingTasks());
        return true;
    }

    public static void main(String[] args) {
        try {
            Synchro.testBasic();
            Synchro.testThread();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class Task {
        String taskId;
        long endTime;
        String cmd;

        Task() {
        }

        public String toString() {
            return this.taskId + (this.endTime == 0L ? "" : " (watchdog in " + (this.endTime - System.currentTimeMillis()) / 1000L + "s)");
        }
    }
}

