/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Coord;
import cds.aladin.Legende;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.Source;
import cds.aladin.ViewSimple;
import cds.aladin.prop.Prop;
import cds.aladin.prop.PropAction;
import cds.tools.Util;
import cds.xml.Field;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SourceTag
extends Source {
    private static int INDICE = 0;
    protected static Legende legende = SourceTag.createLegende();
    protected Plan planBase;

    protected static Legende createLegende() {
        if (legende != null) {
            return legende;
        }
        legende = Legende.adjustDefaultLegende(legende, 3, new String[]{"_RAJ2000", "_DEJ2000", "Label", "Plan", "RA (ICRS)", "DE (ICRS)", "X", "Y"});
        legende = Legende.adjustDefaultLegende(legende, 6, new String[]{"double", "double", "char", "char", "char", "char", "double", "double"});
        legende = Legende.adjustDefaultLegende(legende, 5, new String[]{"deg", "deg", "char", "", "\"h:m:s\"", "\"h:m:s\"", "", ""});
        legende = Legende.adjustDefaultLegende(legende, 9, new String[]{"10", "10", "15", "10", "13", "13", "8", "8"});
        legende = Legende.adjustDefaultLegende(legende, 11, new String[]{"6", "6", "", "", "2", "3", "2", "2"});
        legende = Legende.adjustDefaultLegende(legende, 4, new String[]{"RA", "DEC", "Identifier", "Reference plane", "Right ascension", "Declination", "Current image X axis (FITS convention)", "Current image Y axis (Fits Convention)"});
        legende = Legende.adjustDefaultLegende(legende, 7, new String[]{"pos.eq.ra;meta.main", "pos.eq.dec;meta.main", "meta.id;meta.main", "", "pos.eq.ra", "pos.eq.dec", "", ""});
        SourceTag.legende.name = "Positional tags";
        SourceTag.hideRADECLegende(legende);
        return legende;
    }

    protected static void hideRADECLegende(Legende legende) {
        int nra = legende.find("_RAJ2000");
        int nde = legende.find("_DEJ2000");
        if (nra < 0 || nde < 0) {
            return;
        }
        Field fra = legende.field[nra];
        Field fde = legende.field[nde];
        fde.type = "hidden";
        fra.type = "hidden";
        fde.visible = false;
        fra.visible = false;
        fra.coo = 1;
        fde.coo = 2;
    }

    protected static int nextIndice() {
        return ++INDICE;
    }

    protected SourceTag(Plan plan) {
        super(plan);
    }

    protected SourceTag(Plan plan, ViewSimple v, double x, double y, String id) {
        super(plan, v, x, y, 0.0, 0.0, 5, id);
        this.setLeg(legende);
        this.planBase = v.pref;
        plan.setSourceRemovable(true);
        this.suite();
    }

    protected SourceTag(Plan plan, ViewSimple v, Coord c, String id) {
        super(plan, c.al, c.del, id, null);
        this.planBase = v.pref;
        plan.setSourceRemovable(true);
        this.suite();
    }

    protected void suite() {
        this.setLeg(legende);
        this.setShape(6);
        this.setWithLabel(true);
        this.resumeMesures();
    }

    protected void resume() {
        this.resumeMesures();
        this.plan.aladin.view.newView(1);
        this.plan.aladin.mesure.redisplay();
    }

    protected void resumeMesures() {
        Coord c = new Coord(this.raj, this.dej);
        if (this.id == null) {
            this.id = "Tag " + this.plan.pcat.getNextID();
        }
        String x = " ";
        String y = " ";
        if (this.planBase instanceof PlanImage) {
            this.planBase.projd.getXY(c);
            x = Util.myRound("" + (c.x + 0.5), 4);
            y = Util.myRound("" + ((double)((PlanImage)this.planBase).naxis2 - c.y + 0.5));
        }
        this.info = "<&_A Tags>\t" + this.raj + "\t" + this.dej + "\t" + this.id + "\t" + this.planBase.label + "\t" + c.getRA() + "\t" + c.getDE() + "\t" + x + "\t" + y;
    }

    @Override
    public boolean hasProp() {
        return true;
    }

    @Override
    public Vector<Prop> getProp() {
        Vector<Prop> propList = new Vector<Prop>();
        JLabel l = new JLabel("\"" + this.getObjType() + "\" in plane: \"" + this.plan.getLabel() + "\"");
        l.setFont(l.getFont().deriveFont(1));
        l.setFont(l.getFont().deriveFont(14.0f));
        propList.add(Prop.propFactory("object", "", null, l, null, null));
        final JTextField idL = new JTextField(this.id, 20);
        PropAction updateId = new PropAction(){

            @Override
            public int action() {
                SourceTag.this.id = idL.getText();
                SourceTag.this.resume();
                return 1;
            }
        };
        propList.add(Prop.propFactory("label", "Label", "Identifier", idL, null, updateId));
        l = new JLabel("\"" + this.getObjType() + "\" object in plane: \"" + this.plan.getLabel() + "\"");
        propList.add(Prop.propFactory("Plan", "Plan", "Reference plane", l, null, null));
        final SourceTag myself = this;
        final JTextField pos = new JTextField(20);
        PropAction updatePos = new PropAction(){

            @Override
            public int action() {
                pos.setText(SourceTag.this.plan.aladin.localisation.getLocalisation(myself));
                SourceTag.this.resume();
                return 1;
            }
        };
        PropAction changePos = new PropAction(){

            @Override
            public int action() {
                pos.setForeground(Color.black);
                String opos = SourceTag.this.plan.aladin.localisation.getLocalisation(myself);
                try {
                    String npos = pos.getText();
                    if (npos.equals(opos)) {
                        return -1;
                    }
                    Coord c1 = new Coord(pos.getText());
                    if (("" + c1).indexOf("--") >= 0) {
                        throw new Exception();
                    }
                    c1 = SourceTag.this.plan.aladin.localisation.frameToICRS(c1);
                    SourceTag.this.setRaDec(c1.al, c1.del);
                    SourceTag.this.resume();
                    return 1;
                }
                catch (Exception e1) {
                    pos.setForeground(Color.red);
                    pos.setText(opos);
                    return 0;
                }
            }
        };
        propList.add(Prop.propFactory("coord", "Coord", "Localisation", pos, updatePos, changePos));
        final JCheckBox labelCheck = new JCheckBox("label display");
        labelCheck.setSelected(this.isWithLabel());
        final PropAction changeLabel = new PropAction(){

            @Override
            public int action() {
                if (labelCheck.isSelected() == SourceTag.this.isWithLabel()) {
                    return -1;
                }
                SourceTag.this.setWithLabel(labelCheck.isSelected());
                return 1;
            }
        };
        labelCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                changeLabel.action();
                SourceTag.this.plan.aladin.view.repaintAll();
            }
        });
        propList.add(Prop.propFactory("display", "Display", "Display the label in the view", labelCheck, null, changeLabel));
        final JCheckBox tagCheck = new JCheckBox("tagged (permanently selected)");
        tagCheck.setSelected(this.isTagged());
        final PropAction changeTagged = new PropAction(){

            @Override
            public int action() {
                if (tagCheck.isSelected() == SourceTag.this.isTagged()) {
                    return -1;
                }
                SourceTag.this.setTag(tagCheck.isSelected());
                return 1;
            }
        };
        tagCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                changeTagged.action();
                SourceTag.this.plan.aladin.view.repaintAll();
            }
        });
        propList.add(Prop.propFactory("tagged", "Tagged", "Check it to tag this object in the measurement panel", tagCheck, null, changeTagged));
        return propList;
    }
}

