/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Legende;
import cds.aladin.Localisation;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanField;
import cds.aladin.PlanImage;
import cds.aladin.Projection;
import cds.aladin.Server;
import cds.aladin.SourceTag;
import cds.aladin.ViewSimple;
import cds.aladin.ZoomHist;
import cds.aladin.prop.Prop;
import cds.aladin.prop.PropAction;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class SourceStat
extends SourceTag {
    protected static Legende legende = SourceStat.createLegende();
    protected int L = 5;
    private double radius;
    protected int dw;
    protected int dh;
    protected Color couleur = null;
    private int order = 0;
    private static final String C = "|";
    static final Color JAUNEPALE = new Color(255, 255, 225);

    protected static Legende createLegende() {
        if (legende != null) {
            return legende;
        }
        legende = Legende.adjustDefaultLegende(legende, 3, new String[]{"_RAJ2000", "_DEJ2000", "ID", "Image", "RA (ICRS)", "DE (ICRS)", "Count", "Sum", "Sigma", "Min", "Avg", "Max", "Radius", "Area"});
        legende = Legende.adjustDefaultLegende(legende, 6, new String[]{"double", "double", "char", "char", "char", "char", "integer", "double", "double", "double", "double", "double", "double", "double"});
        legende = Legende.adjustDefaultLegende(legende, 5, new String[]{"deg", "deg", "", "", "\"h:m:s\"", "\"h:m:s\"", "pixel", "", "", "", "", "", "arcmin", "arcmin^2"});
        legende = Legende.adjustDefaultLegende(legende, 9, new String[]{"10", "10", "10", "20", "13", "13", "10", "10", "10", "10", "10", "10", "10", "10"});
        legende = Legende.adjustDefaultLegende(legende, 11, new String[]{"6", "6", "", "", "4", "5", "2", "4", "4", "4", "4", "4", "4", "4"});
        legende = Legende.adjustDefaultLegende(legende, 4, new String[]{"RA", "DEC", "Identifier", "Reference image", "Right ascension", "Declination", "Pixel count", "Sum of pixel values", "Median of the distribution", "Minimum value", "Average value", "Maximum value", "Radius", "Area (pixels)"});
        legende = Legende.adjustDefaultLegende(legende, 7, new String[]{"pos.eq.ra;meta.main", "pos.eq.dec;meta.main", "meta.id;meta.main", "", "pos.eq.ra", "pos.eq.dec", "", "", "", "", "", "", "", ""});
        SourceStat.legende.name = "Pixel statistics";
        SourceStat.hideRADECLegende(legende);
        return legende;
    }

    protected SourceStat(Plan plan) {
        super(plan);
    }

    protected SourceStat(Plan plan, ViewSimple v, double x, double y, String id) {
        super(plan, v, x, y, id);
    }

    protected SourceStat(Plan plan, ViewSimple v, Coord c, String id) {
        super(plan, v, c, id);
    }

    @Override
    protected void suite() {
        this.setLeg(legende);
        this.setId();
        this.resumeMesures();
    }

    public void setOrder(String order) throws Exception {
        this.order = order.equalsIgnoreCase("max") ? -1 : Integer.parseInt(order);
        this.resumeMesures();
    }

    @Override
    protected void resumeMesures() {
        double[] stat = null;
        try {
            stat = this.getStatistics(this.planBase);
        }
        catch (Exception e) {
            stat = null;
        }
        String cnt = stat == null ? " " : "" + stat[0];
        String tot = stat == null ? " " : "" + stat[1];
        String avg = stat != null && stat[0] > 0.0 ? "" + stat[1] / stat[0] : " ";
        String sig = stat == null ? " " : "" + stat[2];
        String surf = stat == null ? " " : "" + stat[3] * 3600.0;
        String rad = "" + this.getRadius() * 60.0;
        String min = stat == null ? " " : "" + stat[4];
        String max = stat == null ? " " : "" + stat[5];
        Coord c = new Coord(this.raj, this.dej);
        String nomPlan = this.planBase.label;
        if (this.planBase instanceof PlanBG) {
            PlanBG pbg = (PlanBG)this.planBase;
            int orderFile = this.order == -1 ? pbg.maxOrder : (this.order == 0 ? pbg.getOrder() : this.order);
            nomPlan = orderFile + "/" + nomPlan;
        }
        if (this.planBase.isCube()) {
            int d = 1 + (int)this.planBase.getZ();
            nomPlan = nomPlan + "/" + d;
        }
        this.info = "<&_A Phots>\t" + this.raj + "\t" + this.dej + "\t" + this.id + "\t" + nomPlan + "\t" + "\t" + c.getRA() + "\t" + c.getDE() + "\t" + cnt + "\t" + tot + "\t" + sig + "\t" + min + "\t" + avg + "\t" + max + "\t" + rad + "\t" + surf;
    }

    public Vector getProp() {
        Vector<Prop> propList = super.getProp();
        final SourceStat myself = this;
        final JTextField testRadius = new JTextField(10);
        final PropAction updateRadius = new PropAction(){

            @Override
            public int action() {
                testRadius.setText(Coord.getUnit(SourceStat.this.getRadius()));
                return 1;
            }
        };
        PropAction changRadius = new PropAction(){

            @Override
            public int action() {
                testRadius.setForeground(Color.black);
                String oval = Coord.getUnit(SourceStat.this.getRadius());
                try {
                    String nval = testRadius.getText();
                    if (nval.equals(oval)) {
                        return -1;
                    }
                    ((SourceStat)myself).setRadius(nval);
                    return 1;
                }
                catch (Exception e1) {
                    updateRadius.action();
                    testRadius.setForeground(Color.red);
                    return 0;
                }
            }
        };
        propList.add(Prop.propFactory("radius", "Radius", "", testRadius, updateRadius, changRadius));
        final JCheckBox lockCheck = new JCheckBox("mouse locked");
        lockCheck.setSelected(this.isLocked());
        final PropAction changeLock = new PropAction(){

            @Override
            public int action() {
                if (lockCheck.isSelected() == SourceStat.this.isWithLabel()) {
                    return -1;
                }
                SourceStat.this.setLocked(lockCheck.isSelected());
                return 1;
            }
        };
        lockCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                changeLock.action();
                SourceStat.this.plan.aladin.view.repaintAll();
            }
        });
        propList.add(Prop.propFactory("lock", "Locked", "Not movable and/or extensible by mouse", lockCheck, null, changeLock));
        final Couleur col = new Couleur(this.couleur, true);
        final PropAction changeCouleur = new PropAction(){

            @Override
            public int action() {
                Color c = col.getCouleur();
                if (c == SourceStat.this.couleur) {
                    return -1;
                }
                SourceStat.this.couleur = c;
                return 1;
            }
        };
        col.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                changeCouleur.action();
                SourceStat.this.plan.aladin.view.repaintAll();
            }
        });
        propList.add(Prop.propFactory("color", "Color", "Alternative color", col, null, changeCouleur));
        return propList;
    }

    @Override
    protected String getSpecificAJInfo() {
        return this.id + C + (this.hasRayon() ? Double.valueOf(this.getRadius()) : "");
    }

    @Override
    protected void setSpecificAJInfo(String s) {
        block3: {
            StringTokenizer tok = new StringTokenizer(s, C);
            String s1 = tok.nextToken();
            String string = this.id = s1.length() == 0 ? null : s1;
            if (tok.hasMoreTokens()) {
                try {
                    this.radius = Double.parseDouble(tok.nextToken());
                }
                catch (Exception e) {
                    if (Aladin.levelTrace != 3) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public String getObjType() {
        return "Phot";
    }

    @Override
    protected void setPosition(ViewSimple v, double x, double y) {
        if (this.isLocked()) {
            return;
        }
        this.setPosition1(v, x, y);
        this.resume();
    }

    @Override
    protected void deltaPosition(ViewSimple v, double x, double y) {
        if (this.isLocked()) {
            return;
        }
        this.deltaPosition1(v, x, y);
        this.resume();
    }

    @Override
    protected void deltaRaDec(double dra, double dde) {
        if (this.isLocked()) {
            return;
        }
        this.deltaRaDec1(dra, dde);
        this.resume();
    }

    void setD() {
        FontMetrics m = Toolkit.getDefaultToolkit().getFontMetrics(DF);
        this.dw = m.stringWidth(this.id) + 4;
        this.dh = HF;
    }

    @Override
    public void setColor(Color c) {
        this.couleur = c;
    }

    protected void setRadius(String r) {
        this.radius = Server.getAngleInArcmin(r, 1) / 60.0;
        this.resume();
    }

    void setRayon(ViewSimple v, double r) {
        Coord c = new Coord();
        Projection proj = v.getProj();
        c.al = this.raj;
        c.del = this.dej;
        proj.getXY(c);
        c.y += r;
        proj.getCoord(c);
        this.radius = Math.abs(this.dej - c.del);
        this.resume();
    }

    protected void setId(String s) {
        this.id = s;
        this.setD();
    }

    void setId() {
        if (this.id == null) {
            this.id = "Stat " + SourceStat.nextIndice();
        }
        this.setD();
    }

    @Override
    protected boolean inside(ViewSimple v, double x, double y) {
        double yc;
        if (!this.isVisible()) {
            return false;
        }
        double xc = Math.abs(x - this.xv[v.n]);
        return Math.sqrt(xc * xc + (yc = Math.abs(y - this.yv[v.n])) * yc) <= this.getRayon(v);
    }

    @Override
    protected Rectangle extendClip(ViewSimple v, Rectangle clip) {
        if (!this.isVisible()) {
            return clip;
        }
        int l = (int)Math.ceil(this.getRayon(v) * v.getZoom());
        Point p = this.getViewCoord(v, l, l);
        if (p == null) {
            return clip;
        }
        int D = l;
        clip = SourceStat.unionRect(clip, p.x - D, p.y - D, D * 2, D * 2);
        if (this.isSelected()) {
            clip = SourceStat.unionRect(clip, p.x - l - 4, p.y - l - 4, l * 2 + 8, l * 2 + 8);
        }
        if (this.isWithLabel()) {
            clip = SourceStat.unionRect(clip, p.x - this.dw / 2, p.y - this.L - 1 - this.dh - 1, this.dw, this.dh);
        }
        if (this.isWithStat()) {
            clip = SourceStat.unionRect(clip, p.x, p.y - 20, 250, 150);
        }
        return clip;
    }

    protected Rectangle getClipRayon(ViewSimple v) {
        Rectangle clip = null;
        if (!this.isVisible()) {
            return null;
        }
        int L = (int)Math.ceil(this.getRayon(v) * v.getZoom());
        Point p = this.getViewCoord(v, L, L);
        if (p == null) {
            return null;
        }
        if (this.isSelected()) {
            clip = SourceStat.unionRect(clip, p.x - L - 4, p.y - L - 4, L * 2 + 8, L * 2 + 8);
        }
        return clip;
    }

    @Override
    public Color getColor() {
        if (this.couleur != null) {
            return this.couleur;
        }
        if (this.plan != null) {
            if (this.plan.type != 10) {
                return this.plan.c;
            }
        } else {
            return Color.black;
        }
        this.couleur = ((PlanField)this.plan).getColor(this);
        return this.couleur;
    }

    @Override
    protected boolean statCompute(Graphics g, ViewSimple v) {
        boolean flagHist;
        boolean bl = flagHist = v == v.aladin.view.getCurrentView();
        if (v == null || v.isFree() || !this.hasPhot(v.pref)) {
            return false;
        }
        this.statInit();
        double xc = this.xv[v.n] - 0.5;
        double yc = this.yv[v.n] - 0.5;
        double r = this.getRayon(v);
        if (r > 100.0 && v.flagClicAndDrag) {
            return false;
        }
        minx = (int)Math.floor(xc - r);
        maxx = (int)Math.ceil(xc + r);
        miny = (int)Math.floor(yc - r);
        maxy = (int)Math.ceil(yc + r);
        double carreRayon = r * r;
        double pixelSurf = 0.0;
        ZoomHist.HistItem onMouse = null;
        if (flagHist) {
            ZoomHist.HistItem histItem = onMouse = v.aladin.view.zoomview.hist == null ? null : v.aladin.view.zoomview.hist.onMouse;
            if (onMouse == null) {
                v.aladin.view.zoomview.initPixelHist();
            } else {
                flagHist = false;
            }
        }
        if (v.pref instanceof PlanBG) {
            try {
                PlanBG pbg = (PlanBG)v.pref;
                int orderFile = pbg.getOrder();
                long nsideLosange = CDSHealpix.pow2(pbg.getTileOrder());
                int orderPix = pbg.getOrder() + pbg.getTileOrder();
                pixelSurf = CDSHealpix.pixRes(orderPix) / 3600.0;
                pixelSurf *= pixelSurf;
                Coord coo = new Coord(this.raj, this.dej);
                coo = Localisation.frameToFrame(coo, 0, pbg.frameOrigin);
                double radiusRadian = Math.toRadians(this.getRadius());
                long[] npix = CDSHealpix.query_disc(orderPix, coo.al, coo.del, radiusRadian, false);
                for (int i = 0; i < npix.length; ++i) {
                    long npixFile = npix[i] / (nsideLosange * nsideLosange);
                    double pix = pbg.getHealpixPixel(orderFile, npixFile, npix[i], 2);
                    if (Double.isNaN(pix)) continue;
                    pix = pix * pbg.bScale + pbg.bZero;
                    double[] polar = CDSHealpix.pix2ang_nest(orderPix, npix[i]);
                    polar = CDSHealpix.polarToRadec(polar);
                    coo.al = polar[0];
                    coo.del = polar[1];
                    coo = Localisation.frameToFrame(coo, pbg.frameOrigin, 0);
                    this.statPixel(g, pix, coo.al, coo.del, v, onMouse);
                    if (!flagHist) continue;
                    v.aladin.view.zoomview.addPixelHist(pix);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                pixelSurf = v.pref.projd.getPixResAlpha() * v.pref.projd.getPixResDelta();
            }
            catch (Exception e) {
                // empty catch block
            }
            for (double y = miny; y <= maxy; y += 1.0) {
                for (double x = minx; x <= maxx; x += 1.0) {
                    double pix;
                    if ((x - xc) * (x - xc) + (y - yc) * (y - yc) > carreRayon || Double.isNaN(pix = this.statPixel(g, (int)x, (int)y, v, onMouse)) || !flagHist) continue;
                    v.aladin.view.zoomview.addPixelHist(pix);
                }
            }
        }
        if (flagHist) {
            v.aladin.view.zoomview.createPixelHist(v.pref.type == 16 ? "HEALPixels" : "Pixels");
        }
        xc = this.xv[v.n];
        yc = this.yv[v.n];
        minx = xc - r;
        maxx = xc + r;
        miny = yc - r;
        maxy = yc + r;
        try {
            surface = (double)nombre * pixelSurf;
            moyenne = total / (double)nombre;
            variance = carre / (double)nombre - moyenne * moyenne;
            sigma = Math.sqrt(variance);
            if (medianeArrayNb == 10000) {
                mediane = Double.NaN;
            } else {
                Arrays.sort(medianeArray, 0, medianeArrayNb);
                mediane = medianeArray[medianeArrayNb / 2];
            }
            this.setWithStat(true);
        }
        catch (Exception e) {
            // empty catch block
        }
        return true;
    }

    @Override
    public double[] getStatistics(Plan p) throws Exception {
        double pixelSurf;
        Projection proj = p.projd;
        if (!p.hasAvailablePixels()) {
            throw new Exception("getStats error: image without pixel values");
        }
        if (!this.hasPhot(p)) {
            throw new Exception("getStats error: not compatible image");
        }
        if (!Projection.isOk(proj)) {
            throw new Exception("getStats error: image without astrometrical calibration");
        }
        if (this.radius <= 0.0) {
            throw new Exception("getStats error: no radius");
        }
        double nombre = 0.0;
        double carre = 0.0;
        double total = Double.NaN;
        double min = Double.NaN;
        double max = Double.NaN;
        if (p.type == 16) {
            PlanBG pbg = (PlanBG)p;
            int orderFile = this.order == -1 ? pbg.maxOrder : (this.order == 0 ? pbg.getOrder() : this.order);
            long nsideLosange = CDSHealpix.pow2(pbg.getTileOrder());
            int orderPix = orderFile + pbg.getTileOrder();
            pixelSurf = CDSHealpix.pixRes(orderPix) / 3600.0;
            pixelSurf *= pixelSurf;
            Coord coo = new Coord(this.raj, this.dej);
            coo = Localisation.frameToFrame(coo, 0, pbg.frameOrigin);
            double radiusRadian = Math.toRadians(this.getRadius());
            long[] npix = CDSHealpix.query_disc(orderPix, coo.al, coo.del, radiusRadian, false);
            for (int i = 0; i < npix.length; ++i) {
                long npixFile = npix[i] / (nsideLosange * nsideLosange);
                double pix = pbg.getHealpixPixel(orderFile, npixFile, npix[i], 2);
                if (Double.isNaN(pix)) continue;
                pix = pix * pbg.bScale + pbg.bZero;
                if (nombre == 0.0) {
                    min = max = pix;
                    total = 0.0;
                }
                if (pix < min) {
                    min = pix;
                }
                if (pix > max) {
                    max = pix;
                }
                nombre += 1.0;
                total += pix;
                carre += pix * pix;
            }
        } else {
            PlanImage pi = (PlanImage)p;
            pi.setLockCacheFree(true);
            pi.pixelsOriginFromCache();
            pixelSurf = proj.getPixResAlpha() * proj.getPixResDelta();
            Coord c = new Coord(this.raj, this.dej);
            proj.getXY(c);
            double xc = c.x - 0.5;
            double yc = c.y - 0.5;
            c.del = this.dej + this.radius;
            proj.getXY(c);
            double dy = yc + 0.5 - c.y;
            double dx = xc + 0.5 - c.x;
            double r = Math.sqrt(dx * dx + dy * dy);
            double carreRayon = r * r;
            int minx = (int)Math.floor(xc - r);
            int maxx = (int)Math.ceil(xc + r);
            int miny = (int)Math.floor(yc - r);
            int maxy = (int)Math.ceil(yc + r);
            for (int y = miny; y <= maxy; ++y) {
                for (int x = minx; x <= maxx; ++x) {
                    double pix;
                    if (((double)x - xc) * ((double)x - xc) + ((double)y - yc) * ((double)y - yc) > carreRayon || !pi.isIn(x, y) || Double.isNaN(pix = pi.getPixelInDouble(x, y))) continue;
                    if (nombre == 0.0) {
                        min = max = pix;
                        total = 0.0;
                    }
                    if (pix < min) {
                        min = pix;
                    }
                    if (pix > max) {
                        max = pix;
                    }
                    nombre += 1.0;
                    total += pix;
                    carre += pix * pix;
                }
            }
            pi.setLockCacheFree(false);
        }
        double surface = nombre * pixelSurf;
        double moyenne = total / nombre;
        double variance = carre / nombre - moyenne * moyenne;
        double sigma = Math.sqrt(variance);
        return new double[]{nombre, total, sigma, surface, min, max};
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    protected boolean hasRayon() {
        return this.radius > 0.0;
    }

    @Override
    public boolean hasPhot() {
        return true;
    }

    public boolean hasPhot(Plan p) {
        if (!this.hasPhot()) {
            return false;
        }
        return p.hasAvailablePixels();
    }

    @Override
    public String getCommand() {
        String r = this.plan.aladin.localisation.getFrame() == 11 ? Util.myRound(this.getRayon(this.plan.aladin.view.getCurrentView())) : Coord.getUnit(this.getRadius());
        return "draw phot(" + this.getLocalisation() + "," + r + ")";
    }

    protected double getRayon(ViewSimple v) {
        Coord c = new Coord();
        Projection proj = v.getProj();
        if (this.radius == 0.0 || v.pref == null || !Projection.isOk(proj)) {
            return 0.0;
        }
        c.al = this.raj;
        c.del = this.dej + this.radius;
        proj.getXY(c);
        double dy = this.yv[v.n] - c.y;
        double dx = this.xv[v.n] - c.x;
        return Math.sqrt(dx * dx + dy * dy);
    }

    protected boolean onPoignee(ViewSimple v, double x, double y) {
        if (this.isLocked()) {
            return false;
        }
        double r = this.getRayon(v) + 1.0;
        for (int i = 0; i < 4; ++i) {
            double xc = this.xv[v.n];
            double yc = this.yv[v.n];
            if (i == 0) {
                yc += r;
            } else if (i == 2) {
                yc -= r;
            } else {
                xc = i == 1 ? (xc += r) : (xc -= r);
            }
            double dx = x - xc;
            double dy = y - yc;
            double l = (double)this.L / v.getZoom();
            if (l < 1.0) {
                l = 1.0;
            }
            if (!(dx * dx + dy * dy < l * l)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean draw(Graphics g, ViewSimple v, int dx, int dy) {
        if (!this.isVisible()) {
            return false;
        }
        int l = (int)(this.getRayon(v) * v.getZoom());
        Point p = this.getViewCoord(v, l, l);
        if (p == null) {
            return false;
        }
        p.x += dx;
        p.y += dy;
        g.setColor(this.getColor());
        if (this.hasPhot(v.pref) && v.pref == this.planBase) {
            Util.drawFillOval(g, p.x - l, p.y - l, l * 2, l * 2, 0.2f * this.plan.getOpacityLevel(), null);
        } else {
            g.drawOval(p.x - l, p.y - l, l * 2, l * 2);
        }
        if (this.isWithLabel()) {
            g.drawString(this.id, p.x - this.dw / 2, p.y - 1);
        }
        if (this.hasPhot(v.pref) && this.isSelected()) {
            this.statDraw(g, v, dx, dy);
        }
        if (this.isSelected()) {
            g.setColor(Color.green);
            this.drawSelect(g, v);
        }
        return true;
    }

    @Override
    protected void drawSelect(Graphics g, ViewSimple v) {
        Rectangle r = this.getClipRayon(v);
        int xc = 0;
        int yc = 0;
        Color c = g.getColor();
        for (int i = 0; i < 4; ++i) {
            switch (i) {
                case 0: {
                    xc = r.x + r.width / 2 - 4;
                    yc = r.y;
                    break;
                }
                case 1: {
                    xc = r.x + r.width / 2 - 4;
                    yc = r.y + r.height - 4;
                    break;
                }
                case 2: {
                    xc = r.x + r.width - 4;
                    yc = r.y + r.height / 2 - 4;
                    break;
                }
                case 3: {
                    xc = r.x;
                    yc = r.y + r.height / 2 - 4;
                }
            }
            g.setColor(c);
            g.fillRect(xc + 1, yc + 1, 4, 4);
            g.setColor(Color.black);
            g.drawRect(xc, yc, 4, 4);
        }
        g.setColor(c);
    }

    @Override
    protected void remove() {
        this.cutOff();
    }

    protected void cutOff() {
        this.plan.aladin.calque.zoom.zoomView.stopHist();
        this.plan.aladin.calque.zoom.zoomView.cutOff(this);
    }

    @Override
    protected boolean cutOn() {
        ViewSimple v = this.plan.aladin.view.getCurrentView();
        if (v == null || this.plan.aladin.toolBox.getTool() == 8) {
            return false;
        }
        Plan pc = v.pref;
        if (!pc.isCube()) {
            return false;
        }
        double x = this.xv[v.n];
        double y = this.yv[v.n];
        int n = pc.getDepth();
        int[] res = new int[n];
        try {
            for (int z = 0; z < n; ++z) {
                res[z] = pc.getPixel8bit(z, x, y) & 0xFF;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.plan.aladin.calque.zoom.zoomView.setCut(this, res, 0);
        return true;
    }
}

