/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.Fov;
import cds.aladin.Legende;
import cds.aladin.MetaDataTree;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanBGCat;
import cds.aladin.PlanField;
import cds.aladin.PlanFilter;
import cds.aladin.PointD;
import cds.aladin.Position;
import cds.aladin.SourceFootprint;
import cds.aladin.Tok;
import cds.aladin.View;
import cds.aladin.ViewSimple;
import cds.image.EPSGraphics;
import cds.tools.Util;
import cds.xml.Field;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class Source
extends Position
implements Comparator {
    static final int MDS = 2;
    static final int[] LIMIT = new int[]{3, 10, 100, 250, 500, 1000, 2000, 5000, 13000, 100000};
    static final String[] TYPENAME = new String[]{"oval", "square", "circle", "rhomb", "cross", "triangle", "plus", "small circle", "dot", "microdot", "solid oval", "solid square", "solid circle", "solid rhomb", "solid triangle"};
    protected byte sourceType = 1;
    protected String info;
    private Legende leg;
    private String oid = null;
    protected double[][][] values;
    protected boolean[] isSelected;
    protected Action[][] actions;
    protected SourceFootprint sourceFootprint;
    static int NOID = 0;
    private static Rectangle box = new Rectangle();
    private static Source sortSource;
    private static int sortNField;
    private static boolean sortNumeric;
    private static int sortSens;

    protected int getL() {
        if (this.plan == null || this.plan.getScalingFactor() == 1.0f) {
            return 3;
        }
        return (int)((double)(2.0f * this.plan.getScalingFactor()) / 3.0 * 3.0);
    }

    protected Source() {
    }

    protected Source(Plan plan, ViewSimple v, double x, double y, double raj, double dej, int methode, String id) {
        super(plan, v, x, y, raj, dej, methode, id);
    }

    protected Source(Plan plan) {
        super(plan);
    }

    protected Source(Plan plan, double raj, double dej, String id, String info) {
        super(plan, null, 0.0, 0.0, raj, dej, 2, id);
        this.info = info;
        this.sourceType = (byte)plan.sourceType;
        this.fixInfo();
    }

    protected Source(Plan plan, double raj, double dej, double jdtime, String id, String info) {
        this(plan, raj, dej, id, info);
        this.jdtime = jdtime;
    }

    protected Source(Plan plan, double raj, double dej, String id, String info, Legende leg) {
        super(plan, null, 0.0, 0.0, raj, dej, 2, id);
        this.info = info;
        this.leg = leg;
        this.sourceType = (byte)plan.sourceType;
        this.fixInfo();
    }

    protected Source(Plan plan, double x, double y, double raj, double dej, int methode, String id, String info, Legende leg) {
        super(plan, null, x, y, raj, dej, methode, id);
        this.info = info;
        this.leg = leg;
        this.sourceType = (byte)plan.sourceType;
        this.fixInfo();
    }

    public Legende getLeg() {
        Legende l;
        if (this.plan != null && this.plan instanceof PlanBGCat && (l = this.plan.getFirstLegende()) != null) {
            return l;
        }
        return this.leg;
    }

    protected void setLeg(Legende leg) {
        this.leg = leg;
    }

    void increaseSourceSize(int sens) {
        this.sourceType = (byte)(this.sourceType + sens);
        if (this.sourceType >= TYPENAME.length) {
            this.sourceType = (byte)(TYPENAME.length - 1);
        } else if (this.sourceType < 0) {
            this.sourceType = 0;
        }
    }

    @Override
    public boolean hasProp() {
        return false;
    }

    @Override
    protected void projection(ViewSimple v) {
        if (v.isPlot()) {
            double[] xy = v.plot.getXY(this);
            this.xv[v.n] = xy[0];
            this.yv[v.n] = xy[1];
        } else {
            super.projection(v);
        }
    }

    protected final void setTag(boolean tag) {
        if (this.plan != null && tag) {
            this.plan.aladin.calque.taggedSrc = true;
        }
        this.flags = tag ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    protected final boolean isTagged() {
        return (this.flags & 2) != 0;
    }

    protected final void setHighlight(boolean fl) {
        this.flags = fl ? (byte)(this.flags | 0x10) : (byte)(this.flags & 0xFFFFFFEF);
    }

    protected final boolean isHighlighted() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public boolean hasPhot() {
        return this.getLeg().hasGroup();
    }

    protected static final String getShape(int i) {
        return TYPENAME[i];
    }

    protected static final int getShapeIndex(String shape) {
        for (int i = 0; i < TYPENAME.length; ++i) {
            if (!shape.equalsIgnoreCase(TYPENAME[i])) continue;
            return i;
        }
        return -1;
    }

    protected void fixInfo() {
        if (this.getLeg() == null || this.getLeg().field == null || this.info == null) {
            return;
        }
        StringTokenizer st = new StringTokenizer(this.info, "\t");
        int nbFields = this.getLeg().field.length;
        for (int nbInfo = st.countTokens() - 1; nbInfo < nbFields; ++nbInfo) {
            this.info = new String(this.info) + "\t ";
            if (Aladin.levelTrace < 3) continue;
            System.err.println("Source.fixInfo() =>  pour " + this.id);
        }
    }

    protected String getOID() {
        return this.oid;
    }

    protected void setOID(String oid) {
        this.oid = oid;
    }

    protected String setOID() {
        this.oid = "Aladin." + ++NOID;
        return this.oid;
    }

    protected static int getDefaultType(int nombre) {
        int i;
        for (i = 0; i < LIMIT.length && nombre > LIMIT[i]; ++i) {
        }
        if (i >= LIMIT.length) {
            i = LIMIT.length - 1;
        }
        return i;
    }

    @Override
    protected void setText(String id) {
        super.setText(id);
    }

    @Override
    public void setInfo(String info) {
        this.info = info;
        this.oid = "";
    }

    protected void setLegende(Legende leg) {
        this.leg = leg;
        this.oid = "";
    }

    @Override
    protected void info(Aladin aladin) {
        aladin.mesure.setInfo(this);
    }

    @Override
    protected void status(Aladin aladin) {
        View cfr_ignored_0 = aladin.view;
        aladin.status.setText(this.id + " " + View.HCLIC);
    }

    @Override
    protected void setPosition(ViewSimple v, double x, double y) {
    }

    @Override
    protected void deltaPosition(ViewSimple v, double dx, double dy) {
        if (this.plan == null || !this.plan.recalibrating) {
            return;
        }
        int n = v.n;
        this.xv[n] = this.xv[n] + dx;
        int n2 = v.n;
        this.yv[n2] = this.yv[n2] + dy;
    }

    private Rectangle setBox() {
        return this.setBox(null);
    }

    private Rectangle setBox(Graphics g) {
        int dy;
        int dx;
        if (g != null) {
            g.setFont(DF);
        }
        FontMetrics m = Toolkit.getDefaultToolkit().getFontMetrics(DF);
        int dw = dx = (int)(m.stringWidth(this.id) / 2);
        int dh = dy = (int)(HF / 2);
        int L = this.getL();
        if (dx > L) {
            dx = L - 1;
            dw += dw - dx;
        }
        if (dy > L) {
            dy = L - 1;
            dh += dh - dy;
        }
        Source.box.x = dx;
        Source.box.y = dy;
        Source.box.width = dw;
        Source.box.height = dh;
        return box;
    }

    @Override
    protected boolean inside(ViewSimple v, double x, double y) {
        int L = this.getL();
        double l = (double)L / v.getZoom();
        double xc = this.xv[v.n];
        double yc = this.yv[v.n];
        return xc <= x + l && xc >= x - l && yc <= y + l && yc >= y - l;
    }

    @Override
    protected Rectangle extendClip(ViewSimple v, Rectangle clip) {
        if (!this.isVisible()) {
            return clip;
        }
        int L = this.getL();
        Point p = this.getViewCoord(v, L * 2, L * 2);
        if (p == null) {
            return clip;
        }
        if (this.sourceFootprint != null) {
            // empty if block
        }
        if (!this.isWithLabel()) {
            if (this.isSelected()) {
                return Source.unionRect(clip, p.x - L - 2, p.y - L - 2, L * 2 + 4, L * 2 + 4);
            }
            return Source.unionRect(clip, p.x - L, p.y - L, L * 2, L * 2);
        }
        this.setBox();
        if (this.isSelected()) {
            return Source.unionRect(clip, p.x - L - 2, p.y - L - Source.box.height - 2, Source.box.width + L * 2 + 4, Source.box.height + L * 2 + 4);
        }
        return Source.unionRect(clip, p.x - L, p.y - L - Source.box.height, Source.box.width + L * 2, Source.box.height + L * 2);
    }

    @Override
    protected boolean inClip(ViewSimple v, Rectangle clip) {
        int w;
        int h;
        int y;
        int x;
        if (!this.isVisible()) {
            return false;
        }
        int L = this.getL();
        Point p = this.getViewCoord(v, L * 2, L * 2);
        if (p == null) {
            return false;
        }
        if (!this.isWithLabel()) {
            if (this.isSelected()) {
                x = p.x - L - 2;
                y = p.y - L - 2;
                w = h = L * 2 + 4;
            } else {
                x = p.x - L;
                y = p.y - L;
                w = h = L * 2;
            }
        } else {
            this.setBox();
            if (this.isSelected()) {
                x = p.x - L - 2;
                y = p.y - L - Source.box.height - 2;
                w = Source.box.width + L * 2 + 4;
                h = Source.box.height + L * 2 + 4;
            } else {
                x = p.x - L;
                y = p.y - L - Source.box.height;
                w = Source.box.width + L * 2;
                h = Source.box.height + L * 2;
            }
        }
        return Obj.intersectRect(clip, x, y, w, h);
    }

    void drawCarre(Graphics g, Point p) {
        this.drawCarre(g, p, false);
    }

    void drawCarre(Graphics g, Point p, boolean solid) {
        int L = this.getL();
        if (!this.isWithLabel()) {
            g.drawRect(p.x - L, p.y - L, L * 2, L * 2);
            if (solid) {
                g.fillRect(p.x - L, p.y - L, L * 2, L * 2);
            }
        } else {
            this.setBox(g);
            g.drawLine(p.x + L, p.y - L + Source.box.y + 2, p.x + L, p.y + L);
            g.drawLine(p.x - L, p.y + L, p.x + L, p.y + L);
            g.drawLine(p.x - L, p.y + L, p.x - L, p.y - L);
            g.drawLine(p.x - L, p.y - L, p.x + L - Source.box.x - 2, p.y - L);
            if (solid) {
                g.fillRect(p.x - L, p.y - L, L * 2, L * 2);
            }
            g.drawString(this.id, p.x + L - Source.box.x, p.y - L + Source.box.y);
        }
    }

    void drawCircleS(Graphics g, Point p) {
        int L = this.getL();
        if (g instanceof EPSGraphics || L != 3) {
            int SR = (int)((double)L + (double)L / 3.0);
            g.drawOval(p.x - SR / 2, p.y - SR / 2, SR, SR);
        } else {
            Util.drawCircle5(g, p.x, p.y);
        }
        if (this.isWithLabel()) {
            this.setBox(g);
            g.drawString(this.id, p.x + L - Source.box.x, p.y - L + Source.box.y);
        }
    }

    void drawOval(Graphics g, Point p) {
        this.drawOval(g, p, false);
    }

    void drawOval(Graphics g, Point p, boolean solid) {
        int L = this.getL();
        int R = (int)(((double)L + (double)L / 3.0) * 2.0);
        g.drawOval(p.x - R / 2, p.y - R / 3, R, 2 * R / 3);
        if (solid) {
            g.fillOval(p.x - R / 2, p.y - R / 3, R, 2 * R / 3);
        }
        if (this.isWithLabel()) {
            this.setBox(g);
            g.drawString(this.id, p.x + L - Source.box.x, p.y - L + Source.box.y);
        }
    }

    void drawCircle(Graphics g, Point p) {
        this.drawCircle(g, p, false);
    }

    void drawCircle(Graphics g, Point p, boolean solid) {
        int L = this.getL();
        if (g instanceof EPSGraphics || L != 3) {
            int LR = L * 2;
            g.drawOval(p.x - LR / 2, p.y - LR / 2, LR, LR);
            if (solid) {
                g.fillOval(p.x - LR / 2, p.y - LR / 2, LR, LR);
            }
        } else if (solid) {
            Util.fillCircle7(g, p.x, p.y);
        } else {
            Util.drawCircle7(g, p.x, p.y);
        }
        if (this.isWithLabel()) {
            this.setBox(g);
            g.drawString(this.id, p.x + L - Source.box.x, p.y - L + Source.box.y);
        }
    }

    void drawLosange(Graphics g, Point p) {
        this.drawLosange(g, p, false);
    }

    void drawLosange(Graphics g, Point p, boolean solid) {
        int L = this.getL();
        Polygon pol = new Polygon(new int[]{p.x, p.x + L, p.x, p.x - L}, new int[]{p.y - L, p.y, p.y + L, p.y}, 4);
        g.drawPolygon(pol);
        if (solid) {
            g.fillPolygon(pol);
        }
        if (this.isWithLabel()) {
            this.setBox(g);
            g.drawString(this.id, p.x + L - Source.box.x, p.y - L + Source.box.y);
        }
    }

    void drawTriangle(Graphics g, Point p) {
        this.drawTriangle(g, p, false);
    }

    void drawTriangle(Graphics g, Point p, boolean solid) {
        int L = this.getL();
        Polygon pol = new Polygon(new int[]{p.x - L, p.x + L, p.x}, new int[]{p.y + L / 3, p.y + L / 3, p.y + L, p.y - 2 * L / 3}, 3);
        g.drawPolygon(pol);
        if (solid) {
            g.fillPolygon(pol);
        }
        if (this.isWithLabel()) {
            this.setBox(g);
            g.drawString(this.id, p.x + L - Source.box.x, p.y - L + Source.box.y);
        }
    }

    void drawPlus(Graphics g, Point p) {
        int L = this.getL();
        g.drawLine(p.x - L, p.y, p.x + L, p.y);
        g.drawLine(p.x, p.y - L, p.x, p.y + L);
        if (this.isWithLabel()) {
            this.setBox(g);
            g.drawString(this.id, p.x + L - Source.box.x / 2, p.y - L + Source.box.y / 2);
        }
    }

    void drawReticule(Graphics g, Point p) {
        int L = this.getL();
        int m = 4;
        g.drawLine(p.x - L, p.y, p.x - m, p.y);
        g.drawLine(p.x + m, p.y, p.x + L, p.y);
        g.drawLine(p.x, p.y - L, p.x, p.y - m);
        g.drawLine(p.x, p.y + m, p.x, p.y + L);
        g.drawLine(p.x, p.y, p.x, p.y);
        if (this.isWithLabel()) {
            this.setBox(g);
            g.drawString(this.id, p.x + L - Source.box.x / 2, p.y - L + Source.box.y / 2);
        }
    }

    void drawCroix(Graphics g, Point p) {
        int L = this.getL();
        g.drawLine(p.x - L, p.y - L, p.x + L, p.y + L);
        g.drawLine(p.x - L, p.y + L, p.x + L, p.y - L);
        if (this.isWithLabel()) {
            this.setBox(g);
            g.drawString(this.id, p.x + L, p.y + Source.box.y / 2);
        }
    }

    void drawPoint(Graphics g, Point p) {
        if (this.plan != null && this.plan.getScalingFactor() > 2.0f) {
            this.drawCircleS(g, p);
            return;
        }
        g.drawLine(p.x - 1, p.y, p.x + 1, p.y);
        g.drawLine(p.x, p.y - 1, p.x, p.y + 1);
        if (this.isWithLabel()) {
            this.setBox(g);
            g.drawString(this.id, p.x + 2 - Source.box.x / 2, p.y - 2 + Source.box.y / 2);
        }
    }

    void drawDot(Graphics g, Point p) {
        if (this.plan != null && this.plan.getScalingFactor() > 1.0f) {
            this.drawPoint(g, p);
            return;
        }
        g.drawLine(p.x, p.y, p.x, p.y);
        if (this.isWithLabel()) {
            this.setBox(g);
            g.drawString(this.id, p.x + 2 - Source.box.x / 2, p.y - 2 + Source.box.y / 2);
        }
    }

    protected void print(Graphics g, int x, int y) {
        Point p = new Point(x, y);
        boolean mwithlabel = this.isWithLabel();
        this.setWithLabel(false);
        g.setColor(this.plan.c);
        switch (this.sourceType) {
            case 1: {
                this.drawCarre(g, p);
                break;
            }
            case 4: {
                this.drawCroix(g, p);
                break;
            }
            case 6: {
                this.drawPlus(g, p);
                break;
            }
            case 3: {
                this.drawLosange(g, p);
                break;
            }
            case 8: {
                this.drawPoint(g, p);
                break;
            }
            case 9: {
                this.drawDot(g, p);
            }
        }
        this.setWithLabel(mwithlabel);
    }

    protected boolean isSelectedInFilter() {
        for (int i = 0; i < PlanFilter.allFilters.length; ++i) {
            PlanFilter pf = PlanFilter.allFilters[i];
            if (!pf.isOn() || this.isSelected == null || !this.isSelected[pf.numero]) continue;
            return true;
        }
        return false;
    }

    protected boolean noFilterInfluence() {
        for (int i = 0; i < PlanFilter.allFilters.length; ++i) {
            PlanFilter pf = PlanFilter.allFilters[i];
            if (!pf.isOn() || pf.numero >= this.plan.influence.length || !this.plan.influence[pf.numero]) continue;
            return false;
        }
        return true;
    }

    private int nbFiltersOk() {
        int nb = 0;
        for (int i = 0; i < PlanFilter.allFilters.length; ++i) {
            PlanFilter pf = PlanFilter.allFilters[i];
            if (!pf.isOn() || !pf.flagOk || !this.plan.influence[pf.numero]) continue;
            ++nb;
        }
        return nb;
    }

    protected void writeLinkFlex(OutputStream o, ViewSimple v) throws Exception {
        int L = this.getL();
        PointD p = this.getViewCoordDouble(v, L, L);
        if (p == null) {
            return;
        }
        o.write((this.plan.label + "\t" + (this.id != null ? this.id : "-") + "\t" + p.x + "\t" + p.y + "\t" + this.getFirstLink() + "\n").getBytes());
    }

    @Override
    protected void writeLink(OutputStream o, ViewSimple v) throws Exception {
        int L = this.getL();
        Point p = this.getViewCoord(v, L, L);
        if (p == null) {
            return;
        }
        o.write((this.plan.label + "\t" + (this.id != null ? this.id : "-") + "\t" + p.x + "\t" + p.y + "\t" + this.getFirstLink() + "\n").getBytes());
    }

    protected String getFirstLink() {
        if (this.getLeg() == null) {
            return "-";
        }
        int i = this.getLeg().getFirstLink();
        if (i < 0) {
            return "-";
        }
        try {
            String s = this.getCodedValue(i);
            int pipe = s.indexOf(124);
            int blanc = s.indexOf(32);
            int sup = s.lastIndexOf(62);
            String id = s.substring(2, blanc > 0 ? blanc : (pipe > 0 ? pipe : sup));
            String param = blanc > 0 ? s.substring(blanc + 1, pipe > 0 ? pipe : sup) : "";
            boolean flagEncode = id.equals("Http");
            URL url = this.plan.aladin.glu.getURL(id, param, flagEncode, false);
            return url.toString();
        }
        catch (Exception e) {
            return "-";
        }
    }

    @Override
    protected boolean draw(Graphics g, ViewSimple v, int dx, int dy) {
        if (!this.inTime(v)) {
            return false;
        }
        int L = this.getL();
        Point p = this.getViewCoord(v, L, L);
        if (p == null) {
            return false;
        }
        p.x += dx;
        p.y += dy;
        if (this.plan.aladin.view.flagHighlight && !this.isHighlighted()) {
            return false;
        }
        boolean iAmSelected = this.isSelectedInFilter();
        boolean noInfluence = this.noFilterInfluence();
        if (this.isSelected() && (noInfluence || iAmSelected)) {
            g.setColor(this.isTagged() ? Color.magenta : Color.green);
            g.drawRect(p.x - L - 1, p.y - L - 1, L * 2 + 2, L * 2 + 2);
        }
        int nbFiltersOk = this.nbFiltersOk();
        if (!noInfluence && iAmSelected) {
            this.drawAssociatedFootprint(g, v, dx, dy);
            if (nbFiltersOk == 0) {
                this.doDraw(g, p, this.plan.c);
            } else {
                boolean success = this.drawWithFilter(g, v, p, dx, dy);
                if (!success) {
                    return false;
                }
            }
        } else if (noInfluence) {
            this.doDraw(g, p, this.plan.c);
            this.drawAssociatedFootprint(g, v, dx, dy);
        } else if (!iAmSelected && nbFiltersOk == 0) {
            this.doDraw(g, p, this.plan.c);
            this.drawAssociatedFootprint(g, v, dx, dy);
        }
        return true;
    }

    private boolean drawWithFilter(Graphics g, ViewSimple v, Point p, int dx, int dy) {
        for (int i = 0; i < PlanFilter.allFilters.length; ++i) {
            PlanFilter pf = PlanFilter.allFilters[i];
            if (!pf.isOn() || !this.plan.influence[pf.numero] || !this.isSelected[pf.numero] || !pf.flagOk) continue;
            if (this.actions[pf.numero] == null) {
                return false;
            }
            for (int j = 0; j < this.actions[pf.numero].length; ++j) {
                this.actions[pf.numero][j].action(this, g, v, p, pf.numero, j, dx, dy);
            }
        }
        return true;
    }

    private void drawAssociatedFootprint(Graphics g, ViewSimple v, int dx, int dy) {
        if (this.sourceFootprint != null) {
            this.sourceFootprint.draw(v.getProj(), g, v, dx, dy, this.getColor());
        }
    }

    protected void doDraw(Graphics g, Point p, Color c) {
        if (c == null) {
            g.setColor(this.plan.c);
        } else {
            g.setColor(c);
        }
        switch (this.sourceType) {
            case 10: {
                this.drawOval(g, p, true);
                break;
            }
            case 0: {
                this.drawOval(g, p);
                break;
            }
            case 11: {
                this.drawCarre(g, p, true);
                break;
            }
            case 1: {
                this.drawCarre(g, p);
                break;
            }
            case 4: {
                this.drawCroix(g, p);
                break;
            }
            case 6: {
                this.drawPlus(g, p);
                break;
            }
            case 13: {
                this.drawLosange(g, p, true);
                break;
            }
            case 3: {
                this.drawLosange(g, p);
                break;
            }
            case 14: {
                this.drawTriangle(g, p, true);
                break;
            }
            case 5: {
                this.drawTriangle(g, p);
                break;
            }
            case 7: {
                this.drawCircleS(g, p);
                break;
            }
            case 12: {
                this.drawCircle(g, p, true);
                break;
            }
            case 2: {
                this.drawCircle(g, p);
                break;
            }
            case 8: {
                this.drawPoint(g, p);
                break;
            }
            case 9: {
                this.drawDot(g, p);
                break;
            }
            case 15: {
                this.drawReticule(g, p);
            }
        }
    }

    private boolean match(String mask, String word, boolean wildcard) {
        if (wildcard) {
            return Util.matchMask(mask, word);
        }
        return word.equals(mask);
    }

    protected int findUCD(String ucd) {
        String curUCD = null;
        if (this.getLeg() == null) {
            return -1;
        }
        Field[] fields = this.getLeg().field;
        boolean wildcard = Source.useWildcard(ucd);
        ucd = MetaDataTree.replace(ucd, "\\*", "*", -1);
        ucd = ucd.toUpperCase();
        for (int curPos = 0; curPos < fields.length; ++curPos) {
            String myVal;
            curUCD = fields[curPos].ucd;
            if (curUCD != null) {
                curUCD = curUCD.toUpperCase();
            }
            if (curUCD == null || wildcard && ((myVal = this.getValue(curPos)) == null || myVal.trim().length() == 0) || !this.match(ucd, curUCD, wildcard)) continue;
            return curPos;
        }
        return -1;
    }

    protected int findUtype(String utype) {
        String curUtype = null;
        if (this.getLeg() == null) {
            return -1;
        }
        Field[] fields = this.getLeg().field;
        boolean wildcard = Source.useWildcard(utype);
        utype = MetaDataTree.replace(utype, "\\*", "*", -1);
        utype = utype.toUpperCase();
        for (int curPos = 0; curPos < fields.length; ++curPos) {
            String myVal;
            curUtype = fields[curPos].utype;
            if (curUtype != null) {
                curUtype = curUtype.toUpperCase();
            }
            if (curUtype == null || wildcard && ((myVal = this.getValue(curPos)) == null || myVal.trim().length() == 0) || !this.match(utype, curUtype, wildcard)) continue;
            return curPos;
        }
        return -1;
    }

    protected int findColumn(String name) {
        String curName = null;
        if (this.getLeg() == null) {
            return -1;
        }
        name = MetaDataTree.replace(name, " ", "", -1);
        Field[] fields = this.getLeg().field;
        boolean wildcard = Source.useWildcard(name);
        name = MetaDataTree.replace(name, "\\*", "*", -1);
        for (int curPos = 0; curPos < fields.length; ++curPos) {
            curName = MetaDataTree.replace(fields[curPos].name.trim(), " ", "", -1);
            if (curName == null || !this.match(name, curName, wildcard)) continue;
            return curPos;
        }
        return -1;
    }

    protected static boolean useWildcard(String s) {
        int oldChar = 32;
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char curChar = s.charAt(i);
            if (curChar == '?') {
                return true;
            }
            if (curChar == '*' && oldChar != 92) {
                return true;
            }
            oldChar = curChar;
        }
        return false;
    }

    protected String getCatalogue() {
        if (this.info != null) {
            int b;
            int a;
            int tab = this.info.indexOf("\t");
            if (tab < 0) {
                return null;
            }
            String name = this.info.substring(0, tab);
            if (name.startsWith("<&") && (a = name.indexOf(124)) > 0 && (b = name.indexOf(62, a + 1)) >= 0) {
                name = name.substring(a + 1, b);
            }
            return name;
        }
        return null;
    }

    protected String getCodedValue(int index) throws NoSuchElementException {
        int i;
        ++index;
        int deb = -1;
        int n = this.info.length();
        int j = 0;
        for (i = 0; i < n && j < index + 1; ++i) {
            if (this.info.charAt(i) != '\t' || ++j != index || deb != -1) continue;
            deb = i + 1;
        }
        if (deb == -1) {
            throw new NoSuchElementException();
        }
        if (i < n) {
            --i;
        }
        return this.info.substring(deb, i);
    }

    protected String getValue(int index) {
        String ret;
        try {
            int b;
            int a;
            ret = this.getCodedValue(index);
            if (this.getLeg().isNullValue(ret, index)) {
                ret = "";
            }
            if (ret.startsWith("<&") && (a = ret.indexOf(124)) > 0 && (b = ret.indexOf(62, a + 1)) >= 0) {
                ret = ret.substring(a + 1, b);
            }
        }
        catch (NoSuchElementException e) {
            return null;
        }
        return ret.trim();
    }

    @Override
    public String getObjType() {
        return "Source";
    }

    @Override
    public String[] getValues() {
        boolean encore;
        StringTokenizer st = new StringTokenizer(this.info, "\t");
        String[] v = null;
        Vector<String> tmp = null;
        if (this.getLeg().field.length > 0) {
            v = new String[this.getLeg().field.length];
        } else {
            tmp = new Vector<String>();
        }
        st.nextElement();
        for (int i = 0; (encore = st.hasMoreTokens()) || v != null && i < v.length; ++i) {
            int b;
            int a;
            String ret;
            String string = ret = encore ? st.nextToken() : "";
            if (ret.startsWith("<&") && (a = ret.indexOf(124)) > 0 && (b = ret.indexOf(62, a + 1)) >= 0) {
                ret = ret.substring(a + 1, b);
            }
            if (v != null) {
                v[i] = ret;
                continue;
            }
            tmp.add(ret);
        }
        if (v == null) {
            v = new String[tmp.size()];
            Enumeration e = tmp.elements();
            for (int i = 0; i < v.length; ++i) {
                v[i] = (String)e.nextElement();
            }
        }
        return v;
    }

    @Override
    public boolean setValue(int index, String value) {
        boolean encore;
        StringTokenizer st = new StringTokenizer(this.info, "\t");
        StringBuilder nInfo = null;
        ++index;
        for (int i = 0; (encore = st.hasMoreTokens()) || i <= index; ++i) {
            String s;
            String string = s = encore ? st.nextToken() : "";
            if (i == index) {
                s = value;
            }
            if (i == 0) {
                nInfo = new StringBuilder(s);
                continue;
            }
            nInfo.append("\t" + s);
        }
        this.info = nInfo.toString();
        return true;
    }

    @Override
    public void setShape(int shape) {
        this.setSourceType(shape);
    }

    protected void setSourceType(int sourceType) {
        this.sourceType = (byte)sourceType;
    }

    @Override
    public void setHighlighted(boolean flag) {
        this.plan.aladin.view.setHighlighted(this, flag);
    }

    @Override
    public void setColumn(int index, String name, String unit, String ucd, int width) {
        this.setColumn(index, name, null, unit, ucd, width);
    }

    public void setColumn(int index, String name, String datatype, String unit, String ucd, int width) {
        int newCol;
        if (this.leg == null) {
            this.leg = new Legende();
        }
        if ((newCol = this.getLeg().setField(index, name, datatype, unit, ucd, width)) > 0 && this.plan != null && this.plan.pcat != null) {
            this.plan.pcat.fixInfo(this.getLeg());
        }
    }

    @Override
    public int indexOf(String key) {
        int i;
        if (this.getLeg() == null) {
            return -1;
        }
        for (i = 0; i < this.getLeg().field.length; ++i) {
            if (!Util.matchMask(key, this.getLeg().field[i].name)) continue;
            return i;
        }
        for (i = 0; i < this.getLeg().field.length; ++i) {
            if (!Util.matchMask(key, this.getLeg().field[i].ucd)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getSize() {
        if (this.getLeg() != null) {
            return this.getLeg().getSize();
        }
        if (this.info == null) {
            return 0;
        }
        return new StringTokenizer(this.info, "\t").countTokens();
    }

    public String getRecord() {
        StringBuilder rep = new StringBuilder();
        String[] names = this.getNames();
        String[] values = this.getValues();
        String[] desc = this.getDescriptions();
        String[] units = this.getUnits();
        for (int i = 0; i < names.length; ++i) {
            if (values[i].trim().length() == 0) continue;
            String d = desc[i] == null || desc[i].length() == 0 ? "" : (desc[i].length() > 40 ? " / " + desc[i].substring(0, 38) + "..." : " / " + desc[i]);
            String u = units[i] == null || units[i].length() == 0 ? "" : " " + units[i];
            rep.append(Util.align(names[i], 15) + "= " + Util.align(values[i] + u, 20) + d + "\n");
        }
        return rep.toString();
    }

    @Override
    public String[] getNames() {
        return this.getMeta(0);
    }

    @Override
    public String[] getUnits() {
        return this.getMeta(1);
    }

    @Override
    public String[] getUCDs() {
        return this.getMeta(2);
    }

    @Override
    public String[] getDataTypes() {
        return this.getMeta(3);
    }

    @Override
    public String[] getArraysizes() {
        return this.getMeta(4);
    }

    @Override
    public String[] getWidths() {
        return this.getMeta(5);
    }

    @Override
    public String[] getPrecisions() {
        return this.getMeta(6);
    }

    public String[] getNullValues() {
        return this.getMeta(7);
    }

    public String[] getDescriptions() {
        return this.getMeta(8);
    }

    private String[] getMeta(int m) {
        if (this.getLeg() == null) {
            return new String[0];
        }
        String[] u = new String[this.getLeg().getSize()];
        block11: for (int i = 0; i < u.length; ++i) {
            switch (m) {
                case 0: {
                    u[i] = this.getLeg().field[i].name;
                    continue block11;
                }
                case 1: {
                    u[i] = this.getLeg().field[i].unit;
                    continue block11;
                }
                case 2: {
                    u[i] = this.getLeg().field[i].ucd;
                    continue block11;
                }
                case 3: {
                    u[i] = this.getLeg().field[i].datatype;
                    continue block11;
                }
                case 4: {
                    u[i] = this.getLeg().field[i].arraysize;
                    continue block11;
                }
                case 5: {
                    u[i] = this.getLeg().field[i].width;
                    continue block11;
                }
                case 6: {
                    u[i] = this.getLeg().field[i].precision;
                    continue block11;
                }
                case 7: {
                    u[i] = this.getLeg().field[i].nullValue;
                    continue block11;
                }
                case 8: {
                    u[i] = this.getLeg().field[i].description;
                }
            }
        }
        return u;
    }

    @Override
    public String getXMLMetaData() {
        return this.getLeg().getGroup();
    }

    protected String getUnit(int pos) {
        if (pos < 0) {
            return "";
        }
        String u = this.getLeg().field[pos].unit;
        if (u != null) {
            u = u.replace("year", "yr");
        }
        return u;
    }

    @Override
    public InputStream getVOTable() throws Exception {
        return this.plan.aladin.writeObjectInVOTable(null, this, null, true, false, false, false).getInputStream();
    }

    public String createSIAFoV() {
        if (this.getLeg() == null) {
            return null;
        }
        try {
            double scaleH;
            int axis;
            int iScale = this.getLeg().findUCD("VOX:Image_Scale");
            int iNaxis = this.getLeg().findUCD("VOX:Image_Naxes");
            int iSize = this.getLeg().findUCD("VOX:Image_Naxis");
            int iCD = this.getLeg().findUCD("VOX:WCS_CDMatrix");
            String[] val = this.getValues();
            if (iNaxis >= 0 && (axis = Integer.parseInt(val[iNaxis])) != 2) {
                return null;
            }
            String s = val[iSize];
            Tok st = new Tok(s, ", ");
            int width = Integer.parseInt(st.nextToken());
            int height = Integer.parseInt(st.nextToken());
            s = val[iScale];
            st = new Tok(s, ", ");
            double scaleW = Double.parseDouble(st.nextToken());
            try {
                scaleH = Double.parseDouble(st.nextToken());
            }
            catch (Exception e1) {
                scaleH = scaleW;
            }
            scaleW *= (double)width;
            scaleH *= (double)height;
            double angle = 0.0;
            if (iCD >= 0) {
                try {
                    st = new Tok(val[iCD], ", ");
                    double cd01 = Double.parseDouble(st.nextToken());
                    st.nextToken();
                    double cd11 = Double.parseDouble(st.nextToken());
                    angle = 90.0 - Math.atan2(cd01, cd11) * 180.0 / Math.PI;
                    if (Double.isNaN(angle)) {
                        angle = 0.0;
                    }
                }
                catch (Exception e) {
                    angle = 0.0;
                }
            }
            Fov fov = new Fov(this.raj, this.dej, scaleW, scaleH, angle);
            StringBuilder s1 = new StringBuilder("Polygon ICRS");
            for (PointD p : fov.getPoints()) {
                s1.append(" " + p.x + " " + p.y);
            }
            return s1.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private void createSourceFootprint() {
        if (this.sourceFootprint == null) {
            this.sourceFootprint = new SourceFootprint();
        }
    }

    protected SourceFootprint getFootprint() {
        return this.sourceFootprint;
    }

    protected void setFootprint(PlanField footprint) {
        this.createSourceFootprint();
        this.sourceFootprint.setFootprint(footprint);
    }

    protected void setFootprint(String stcs) {
        this.createSourceFootprint();
        this.sourceFootprint.setStcs(this.raj, this.dej, stcs);
    }

    protected void resetFootprint() {
        this.sourceFootprint = new SourceFootprint();
        int idxSTCS = this.findUtype("*ObservationLocation.AstroCoordArea.Region");
        if (idxSTCS < 0) {
            idxSTCS = this.findUtype("*Char.SpatialAxis.Coverage.Support.Area");
        }
        if (idxSTCS >= 0) {
            try {
                this.setFootprint(this.getValue(idxSTCS));
                this.setIdxFootprint(idxSTCS);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean isSetFootprint() {
        return this.sourceFootprint != null && this.sourceFootprint.isSet();
    }

    protected void switchFootprint() {
        this.setShowFootprint(!this.sourceFootprint.showFootprint(), true);
    }

    protected void setShowFootprint(boolean show, boolean withRepaint) {
        this.createSourceFootprint();
        this.sourceFootprint.setShowFootprint(show);
        if (withRepaint) {
            this.plan.aladin.calque.repaintAll();
        }
    }

    protected void setShowFootprintTransient(boolean show, boolean withRepaint) {
        this.createSourceFootprint();
        this.sourceFootprint.setShowFootprintTransient(show);
        if (withRepaint) {
            this.plan.aladin.calque.repaintAll();
        }
    }

    protected boolean isShowingFootprint() {
        if (this.sourceFootprint == null) {
            return false;
        }
        return this.sourceFootprint.showFootprint();
    }

    protected int getIdxFootprint() {
        return this.sourceFootprint == null ? -1 : this.sourceFootprint.getIdxFootprint();
    }

    public void setIdxFootprint(int idxFootprint) {
        this.createSourceFootprint();
        this.sourceFootprint.setIdxFootprint(idxFootprint);
    }

    public int compare(Object a1, Object b1) {
        double bNVal;
        Source a = (Source)a1;
        Source b = (Source)b1;
        if (sortSource == null || a == null || b == null) {
            return 0;
        }
        if (sortNField == -1) {
            if (a.isTagged() == b.isTagged()) {
                return 0;
            }
            return a.isTagged() ? -sortSens : sortSens;
        }
        if (a.getLeg() != sortSource.getLeg()) {
            return 1;
        }
        if (b.getLeg() != sortSource.getLeg()) {
            return -1;
        }
        String aVal = a.getValue(sortNField);
        String bVal = b.getValue(sortNField);
        if (!sortNumeric) {
            if (sortSens == 1) {
                return aVal.compareTo(bVal);
            }
            return bVal.compareTo(aVal);
        }
        double aNVal = aVal.length() == 0 ? Double.MAX_VALUE : Double.valueOf(aVal);
        if (aNVal == (bNVal = bVal.length() == 0 ? Double.MAX_VALUE : Double.valueOf(bVal))) {
            return 0;
        }
        return aNVal > bNVal ? sortSens : -sortSens;
    }

    protected static Comparator getComparator() {
        return sortSource;
    }

    protected static void setSort(Source s, int nField, int sens) {
        sortNumeric = s.getLeg().isNumField(nField);
        sortSource = s;
        sortNField = nField;
        sortSens = sens;
        Aladin.trace(1, "Measurement " + (sortNumeric ? "numerical " : "alphanumerical ") + (sens == 1 ? "ascending" : "descending") + " sort on " + (s.getLeg() == null || nField == -1 ? "field " + nField : "${" + s.getLeg().field[nField].name) + "}");
    }
}

