/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Widget;
import cds.aladin.WidgetControl;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class SliderPlusMoins
extends JPanel
implements MouseWheelListener,
MouseMotionListener,
MouseListener,
Widget {
    Aladin aladin;
    JLabel label;
    Slider slider;
    JButton plus;
    JButton moins;
    int wheelIncr;
    boolean enable = true;
    private int defaut = Integer.MAX_VALUE;
    private WidgetControl voc = null;

    @Override
    public String toString() {
        return this.slider == null ? "null" : this.slider.toString();
    }

    public SliderPlusMoins(Aladin aladin, String title, int min, int max, int incr) {
        this(aladin, title, min, max, incr, incr);
    }

    public SliderPlusMoins(Aladin aladin, String title, int min, int max, final int incr, int wheelIncr) {
        this.aladin = aladin;
        this.slider = new Slider(min, max, incr);
        this.label = new Lab(title);
        this.label.setOpaque(true);
        this.label.setFont(Aladin.SBOLD);
        this.label.setBackground(aladin.getBackground());
        Bouton b = new Bouton("-");
        this.moins = b;
        b.setBorderPainted(false);
        b.setBackground(aladin.getBackground());
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SliderPlusMoins.this.submit(-incr);
            }
        });
        b = new Bouton("+");
        this.plus = b;
        b.setFont(b.getFont().deriveFont((float)b.getFont().getSize() - 1.0f));
        b.setBorderPainted(false);
        b.setBackground(aladin.getBackground());
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SliderPlusMoins.this.submit(incr);
            }
        });
        JPanel p = new JPanel(new BorderLayout(5, 0));
        p.setBackground(aladin.getBackground());
        p.add((Component)this.moins, "West");
        p.add((Component)this.slider, "Center");
        p.add((Component)this.plus, "East");
        this.setLayout(new BorderLayout(0, 0));
        this.setBackground(aladin.getBackground());
        this.setOpaque(true);
        this.add((Component)this.label, "West");
        this.add((Component)p, "Center");
        this.setEnabled(false);
        this.addMouseWheelListener(this);
        this.wheelIncr = wheelIncr;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (!this.enable) {
            return;
        }
        if (e.getClickCount() == 2) {
            return;
        }
        this.submit(-this.wheelIncr * e.getWheelRotation());
        this.slider.repaint();
    }

    public double getValue() {
        return this.slider.getValue();
    }

    public void setValue(int v) {
        this.slider.setValue(v);
    }

    abstract void submit(int var1);

    @Override
    public void setEnabled(boolean m) {
        if (m == this.enable) {
            return;
        }
        this.enable = m;
        super.setEnabled(m);
        this.slider.setEnabled(m);
        this.label.setForeground(m ? Aladin.COLOR_CONTROL_FOREGROUND : Aladin.COLOR_CONTROL_FOREGROUND_UNAVAILABLE);
        this.label.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SliderPlusMoins.this.setDefault();
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.plus.setEnabled(m);
        this.moins.setEnabled(m);
    }

    public void setDefaultValue(int defaut) {
        this.defaut = defaut;
    }

    protected void setDefault() {
        if (this.defaut == Integer.MAX_VALUE) {
            return;
        }
        this.slider.setValue(this.slider.min);
        this.submit(0);
    }

    void setTooltip(String tip) {
        Util.toolTip(this.label, tip);
        Util.toolTip(this.moins, tip);
        Util.toolTip(this.plus, tip);
        Util.toolTip(this.slider, tip);
    }

    boolean setMinMax(int min, int max) {
        return this.slider.setMinMax(min, max);
    }

    private void shiftE(MouseEvent e) {
        e.translatePoint(-(this.label.getWidth() + this.moins.getWidth()), 0);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.shiftE(e);
        this.slider.mouseDragged(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.shiftE(e);
        this.slider.mouseMoved(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.shiftE(e);
        this.slider.mouseClicked(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.shiftE(e);
        this.slider.mousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.shiftE(e);
        this.slider.mouseReleased(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.shiftE(e);
        this.slider.mouseEntered(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.shiftE(e);
        this.slider.mouseExited(e);
    }

    @Override
    public WidgetControl getWidgetControl() {
        return this.voc;
    }

    @Override
    public void createWidgetControl(int x, int y, int width, int height, float opacity, JComponent parent) {
        this.voc = new WidgetControl(this, x, y, width, height, opacity, parent);
        this.voc.setResizable(true);
    }

    @Override
    public void paintCollapsed(Graphics g) {
    }

    class Lab
    extends JLabel {
        private int width;

        public Lab(String s) {
            super(s == null ? "" : s);
            this.width = 40;
            if (s == null) {
                this.width = 0;
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.width, 14);
        }
    }

    class Bouton
    extends JButton
    implements MouseListener {
        static final int SIZE = 10;
        boolean in = false;

        Bouton(String s) {
            super.setText(s);
            this.setFont(Aladin.LBOLD);
            this.addMouseListener(this);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(10, 10);
        }

        @Override
        public Dimension getSize() {
            return new Dimension(10, 10);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int H = this.getHeight();
            int W = this.getWidth();
            g.setColor(SliderPlusMoins.this.slider.getBackground());
            g.fillRect(0, 0, W, H);
            g.setColor(!SliderPlusMoins.this.enable ? Aladin.COLOR_CONTROL_FOREGROUND_UNAVAILABLE : (this.in ? Aladin.COLOR_CONTROL_FOREGROUND.brighter() : Aladin.COLOR_CONTROL_FOREGROUND));
            String s = this.getText();
            g.drawString(s, W / 2 - g.getFontMetrics().stringWidth(s) / 2, H / 2 + 5);
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            if (!SliderPlusMoins.this.enable) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.in = true;
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.in = false;
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.repaint();
        }
    }

    class Slider
    extends JPanel
    implements MouseMotionListener,
    MouseListener {
        int min;
        int max;
        int incr;
        double value;
        private Rectangle r;
        private boolean in = false;
        private int memoX;
        private int memoWhere;

        Slider(int min, int max, int incr) {
            this.min = min;
            this.value = this.min;
            this.max = max;
            this.incr = incr;
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setBackground(Aladin.COLOR_MAINPANEL_BACKGROUND);
        }

        @Override
        public String toString() {
            return "slider[" + this.min + " .. " + this.max + "] => " + this.value;
        }

        double getValue() {
            return this.value;
        }

        void setValue(double v) {
            this.value = v;
            this.repaint();
        }

        boolean setMinMax(int min, int max) {
            if (this.min == min && this.max == max) {
                return false;
            }
            this.min = min;
            this.max = max;
            if (this.value < (double)min) {
                this.value = min;
            } else if (this.value > (double)max) {
                this.value = max;
            }
            return true;
        }

        private int getPos() {
            return (int)((double)this.getWidth() * ((this.value - (double)this.min) / (double)(this.max - this.min)));
        }

        private void setPos(int x) {
            this.value = (int)((double)x / (double)this.getWidth() * (double)(this.max - this.min) + (double)this.min);
            if (this.value > (double)this.max) {
                this.value = this.max;
            } else if (this.value < (double)this.min) {
                this.value = this.min;
            }
        }

        private int where(int x) {
            return x < this.r.x ? -1 : (this.r.x <= x && x <= this.r.x + this.r.width ? 0 : 1);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.memoX = e.getX();
            this.memoWhere = this.where(this.memoX);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            int x;
            if (!this.isEnabled()) {
                return;
            }
            this.memoX = x = e.getX();
            this.setPos(x);
            if (this.value > (double)this.max) {
                this.value = this.max;
            } else if (this.value < (double)this.min) {
                this.value = this.min;
            }
            SliderPlusMoins.this.submit(0);
            this.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.mouseMoved(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.in = false;
            this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.in = true;
            this.mouseReleased(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            boolean newIn;
            if (!SliderPlusMoins.this.enable) {
                return;
            }
            boolean bl = newIn = this.where(e.getX()) == 0;
            if (newIn == this.in) {
                return;
            }
            this.in = newIn;
            this.repaint();
        }

        @Override
        public void paintComponent(Graphics g) {
            int H = this.getHeight();
            int W = this.getWidth();
            g.setClip(null);
            g.setColor(SliderPlusMoins.this.slider.getBackground());
            g.fillRect(0, 0, W, H);
            Color bg = Aladin.COLOR_BACKGROUND;
            Color fg = Aladin.COLOR_FOREGROUND;
            Util.drawCartouche(g, 0, H / 2 - 2, W, 5, 1.0f, SliderPlusMoins.this.enable ? Aladin.COLOR_CONTROL_FOREGROUND : Aladin.MYGRAY, bg);
            int x = this.getPos();
            if (x - 7 < 0) {
                x = 7;
            }
            if (x + 5 > W) {
                x = W - 5;
            }
            this.r = new Rectangle(x - 7, H / 2 - 6, 14, 13);
            g.setColor(SliderPlusMoins.this.enable ? Aladin.COLOR_CONTROL_FOREGROUND : Aladin.COLOR_CONTROL_FOREGROUND_UNAVAILABLE);
            g.fillRect(this.r.x, this.r.y, this.r.width, this.r.height);
            if (SliderPlusMoins.this.enable) {
                Util.drawEdge(g, this.r.x, this.r.y, this.r.width, this.r.height);
            }
            x -= 4;
            for (int i = 0; i < 3; ++i) {
                g.setColor(!SliderPlusMoins.this.enable ? Aladin.COLOR_CONTROL_FOREGROUND_UNAVAILABLE : fg);
                g.drawLine(x + i * 3, H / 2 - 4, x + i * 3, H / 2 + 3);
                g.setColor(bg);
                g.drawLine(x + i * 3 + 1, H / 2 - 4, x + i * 3 + 1, H / 2 + 3);
            }
        }
    }
}

