/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.CustomListCell;
import cds.aladin.CustomListCellRenderer;
import cds.aladin.DynamicTapForm;
import cds.aladin.MySplitPane;
import cds.aladin.Projection;
import cds.aladin.Server;
import cds.aladin.ServerObsTap;
import cds.aladin.TapManager;
import cds.aladin.TapTable;
import cds.aladin.TapTableColumn;
import cds.aladin.UploadTablesRenderer;
import cds.tools.CDSConstants;
import cds.tools.ConfigurationReader;
import cds.tools.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.MutableComboBoxModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;

public class ServerTapExamples
extends DynamicTapForm {
    private static final long serialVersionUID = -9113338791629047699L;
    public static String TAPSERVICEEXAMPLESTOOLTIP;
    public static String SETTARGETTOOLTIP;
    public static String TAPEXDEFAULTMAXROWS;
    public static String CHANGESETTINGSTOOLTIP;
    public static String NODUPLICATESELECTION;
    public static String JOINTABLETOOLTIP;
    public static String QUERIESREFRESHED;
    public static String TAPEXGENERATEDLABEL;
    public static String TAPEXGENERATEDTOOLTIP;
    public static String TAPEXSERVICEPROVIDEDLABEL;
    public static String TAPEXSERVICEPROVIDEDTOOLTIP;
    public static String SHOWSERVICEEXTIP;
    public static String HIDESERVICEEXAMPLES;
    public static final String TAPEXDEFAULTMAXROWS_INT = "2000";
    Map serviceExamples = null;
    Map<String, CustomListCell> basicExamples = new LinkedHashMap<String, CustomListCell>();
    Map<String, String> serviceExamples2;
    String secondaryTable;
    String grabItX1;
    String grabItY1;
    String grabItR1;
    JCheckBox addSecondTable;
    String max;
    JList examplesGui;
    JList serviceExamplesGui;
    JPanel queryDisplays;
    public boolean initExamples = true;
    JComboBox secondaryTablesGui;
    private MySplitPane centerPanel;
    private JButton reduce;

    public ServerTapExamples(Aladin aladin) {
        super(aladin);
    }

    protected Coord getDefaultTargetCoo() {
        Coord coo = null;
        if (this.tapClient.target != null) {
            coo = this.tapClient.target;
        } else if (this.aladin.view.isFree() || !Projection.isOk(this.aladin.view.getCurrentView().getProj())) {
            coo = null;
        } else {
            coo = this.aladin.view.getCurrentView().getCooCentre();
            coo = this.aladin.localisation.ICRSToFrame(coo);
        }
        return coo;
    }

    protected void createForm(String priTableChoice, String secTableChoice) {
        Map<String, TapTable> uploadMeta;
        this.CLIENTINSTR = Aladin.chaine.getString("TAPEXCLIENTINSTR");
        Coord defaultCoo = this.getDefaultTargetCoo();
        this.grabItX1 = defaultCoo == null || defaultCoo.al == 0.0 ? "313.25097844474084" : String.format(Locale.US, "%.5f", defaultCoo.al);
        this.grabItY1 = defaultCoo == null || defaultCoo.del == 0.0 ? "31.1768737946931" : String.format(Locale.US, "%.5f", defaultCoo.del);
        double defaultRadius = this.tapClient.radius;
        this.grabItR1 = defaultRadius < 0.0 ? String.format(Locale.US, "%.5f", Server.getRM("10'") / 60.0) : String.valueOf(defaultRadius * 2.0);
        Vector<String> tables = this.getTableNames();
        TapTable chosenTable = null;
        chosenTable = priTableChoice == null || !tables.contains(priTableChoice) ? this.tapClient.tablesMetaData.get(tables.firstElement()) : this.tapClient.tablesMetaData.get(priTableChoice);
        this.selectedTableName = chosenTable.getTable_name();
        this.getColumnsToLoad(this.selectedTableName, this.tapClient.tablesMetaData);
        TapManager tapManager = TapManager.getInstance(this.aladin);
        TapTable chosenTable2 = null;
        if (this.tapClient.isUploadAllowed() && (uploadMeta = tapManager.initUploadFrameAndGetUploadedTables()) != null && !uploadMeta.isEmpty()) {
            this.secondaryTable = secTableChoice == null || !uploadMeta.containsKey(secTableChoice) ? (uploadMeta.size() > 1 ? uploadMeta.keySet().iterator().next() : null) : secTableChoice;
            if (this.secondaryTable != null) {
                chosenTable2 = uploadMeta.get(this.secondaryTable);
            }
        }
        this.setBasics();
        this.max = null;
        JPanel containerPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.setTopPanel(containerPanel, c, this.info1, this.CLIENTINSTR);
        JPanel tablesPanel = null;
        try {
            this.tablesGui = new JComboBox<String>(tables);
            tablesPanel = ServerTapExamples.getTablesPanel(this.tapClient, this, null, this.tablesGui, chosenTable, tables, null, true);
            tablesPanel.setBackground(this.tapClient.primaryColor);
            tablesPanel.setFont(CDSConstants.BOLD);
            c.weighty = 0.02;
            c.weightx = 0.1;
            c.anchor = 18;
            c.fill = 0;
            c.insets = new Insets(0, 4, 0, 0);
            ++c.gridy;
            containerPanel.add((Component)tablesPanel, c);
            c.weighty = 0.57;
            if (this.tapClient.isUploadAllowed()) {
                MutableComboBoxModel uploadModel = (MutableComboBoxModel)tapManager.getUploadClientModel();
                this.addSecondTable = new JCheckBox();
                this.addSecondTable.setToolTipText(JOINTABLETOOLTIP);
                this.addSecondTable.setEnabled(uploadModel.getSize() > 0);
                this.secondaryTablesGui = new JComboBox(uploadModel);
                ArrayList<JComponent> compToPrefix = new ArrayList<JComponent>();
                compToPrefix.add(this.addSecondTable);
                tablesPanel = ServerTapExamples.getTablesPanel(this.tapClient, this, "Join:", this.secondaryTablesGui, chosenTable2, null, compToPrefix, false);
                UploadTablesRenderer uploadTableRenderer = UploadTablesRenderer.getInstance(this.aladin);
                this.secondaryTablesGui.setRenderer(uploadTableRenderer);
                if (this.secondaryTablesGui.getSelectedItem() != null) {
                    String uploadTable = (String)this.secondaryTablesGui.getSelectedItem();
                    String planeName = uploadTableRenderer.getUploadPlaneName((String)this.secondaryTablesGui.getSelectedItem());
                    this.secondaryTablesGui.setToolTipText(UploadTablesRenderer.getToolTip(planeName, uploadTable));
                }
                tablesPanel.setBackground(this.tapClient.primaryColor);
                tablesPanel.setFont(CDSConstants.BOLD);
                if (this.secondaryTable != null) {
                    this.secondaryTablesGui.setSelectedItem(this.secondaryTable);
                    this.addSecondTable.setSelected(true);
                } else {
                    this.addSecondTable.setSelected(false);
                    this.secondaryTablesGui.setEnabled(false);
                }
                this.addSecondTable.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        int index;
                        ComboBoxModel uploadModel = ServerTapExamples.this.tapClient.tapManager.getUploadClientModel();
                        boolean doScroll = false;
                        if (e.getStateChange() == 1 && uploadModel.getSize() > 0) {
                            doScroll = true;
                            ServerTapExamples.this.secondaryTablesGui.setEnabled(true);
                            ServerTapExamples.this.secondaryTable = (String)ServerTapExamples.this.secondaryTablesGui.getSelectedItem();
                        } else {
                            ServerTapExamples.this.secondaryTable = null;
                            ServerTapExamples.this.secondaryTablesGui.setEnabled(false);
                        }
                        ServerTapExamples.this.regenerateBasicExamplesRepaint();
                        if (doScroll && (index = ServerTapExamples.this.examplesGui.getModel().getSize() - 1) >= 0) {
                            ServerTapExamples.this.examplesGui.ensureIndexIsVisible(index);
                        }
                    }
                });
                c.weightx = 0.12;
                c.weighty = 0.02;
                c.anchor = 18;
                c.fill = 0;
                c.insets = new Insets(0, 4, 0, 0);
                ++c.gridy;
                containerPanel.add((Component)tablesPanel, c);
                c.weighty = 0.55;
            }
        }
        catch (BadLocationException e) {
            Aladin.error(this, e.getMessage());
            return;
        }
        c.weighty = 0.55;
        this.populateExamples();
        this.examplesGui = new JList<Object>(this.basicExamples.keySet().toArray());
        this.examplesGui.setCellRenderer(new CustomListCellRenderer(this.basicExamples));
        this.examplesGui.setVisibleRowCount(4);
        this.examplesGui.setSelectionMode(0);
        this.examplesGui.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String queryLabel = (String)ServerTapExamples.this.examplesGui.getSelectedValue();
                if (queryLabel != null && ServerTapExamples.this.basicExamples.containsKey(queryLabel)) {
                    ServerTapExamples.this.tap.setText(ServerTapExamples.this.basicExamples.get((Object)queryLabel).label);
                    if (ServerTapExamples.this.serviceExamplesGui != null && !ServerTapExamples.this.examplesGui.isSelectionEmpty()) {
                        ServerTapExamples.this.serviceExamplesGui.clearSelection();
                    }
                } else {
                    ServerTapExamples.this.tap.setText("");
                }
            }
        });
        this.queryDisplays = new JPanel();
        this.queryDisplays.setBackground(this.tapClient.primaryColor);
        this.queryDisplays.setLayout(new GridLayout(1, 1));
        this.queryDisplays.add(this.getScrollPane1());
        c.fill = 1;
        ++c.gridy;
        c.insets = new Insets(0, 4, 0, 0);
        containerPanel.add((Component)this.queryDisplays, c);
        JPanel linePanel = this.getBottomPanel(true);
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 0.02;
        c.insets = new Insets(0, -6, 0, 0);
        c.fill = 1;
        ++c.gridy;
        containerPanel.add((Component)linePanel, c);
        this.tap = new JTextArea(8, 100);
        this.tap.setFont(Aladin.ITALIC);
        this.tap.setWrapStyleWord(true);
        this.tap.setLineWrap(true);
        this.tap.setEditable(true);
        JScrollPane scrolley = new JScrollPane(this.tap);
        c.weighty = 0.35;
        c.weightx = 1.0;
        c.insets = new Insets(0, 4, 0, 0);
        c.fill = 1;
        ++c.gridy;
        containerPanel.add((Component)scrolley, c);
        this.removeAll();
        this.add(containerPanel);
        this.formLoadStatus = 2;
        tapManager.initTapExamples(this);
    }

    public Border getFancyTitleBorder(String title) {
        Border colorLine = BorderFactory.createLineBorder(Aladin.COLOR_MEASUREMENT_BACKGROUND_SELECTED_LINE);
        TitledBorder titleb = BorderFactory.createTitledBorder(title);
        titleb.setBorder(colorLine);
        return titleb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTapExamples() {
        if (this.initExamples) {
            this.serviceExamples = this.tapClient.tapManager.getTapExamples(this.tapClient.tapBaseUrl);
            this.initExamples = false;
        }
        if (this.serviceExamples != null && !this.serviceExamples.isEmpty()) {
            this.serviceExamplesGui = new JList<Object>(this.serviceExamples.keySet().toArray());
            this.serviceExamplesGui.setVisibleRowCount(4);
            this.serviceExamplesGui.setToolTipText(TAPSERVICEEXAMPLESTOOLTIP);
            this.serviceExamplesGui.setSelectionMode(0);
            this.serviceExamplesGui.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    String queryLabel = (String)ServerTapExamples.this.serviceExamplesGui.getSelectedValue();
                    if (queryLabel != null) {
                        ServerTapExamples.this.tap.setText(ServerTapExamples.this.serviceExamples.get(queryLabel).toString());
                        if (!ServerTapExamples.this.serviceExamplesGui.isSelectionEmpty()) {
                            ServerTapExamples.this.examplesGui.clearSelection();
                        }
                    }
                }
            });
            this.waitCursor();
            JPanel jPanel = this.queryDisplays;
            synchronized (jPanel) {
                this.setOnlyClientGenExamples();
                this.queryDisplays.revalidate();
                this.queryDisplays.repaint();
            }
            this.defaultCursor();
        }
        this.ball.setMode(1);
        this.info1.setText(this.CLIENTINSTR);
    }

    public void setOnlyClientGenExamples() {
        this.queryDisplays.removeAll();
        this.queryDisplays.setLayout(new GridBagLayout());
        this.queryDisplays.setBackground(this.tapClient.primaryColor);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.insets = new Insets(-10, 0, 0, 0);
        c.weightx = 0.01;
        c.anchor = 18;
        c.fill = 0;
        JButton button = null;
        Image image = Aladin.aladin.getImagette("Load.gif");
        if (image == null) {
            button = new JButton("+");
        } else {
            button = new JButton(new ImageIcon(image));
            button.setBorderPainted(false);
            button.setMargin(new Insets(0, 0, 0, 0));
            button.setContentAreaFilled(true);
        }
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerTapExamples.this.showBothExamples();
            }
        });
        button.setToolTipText(SHOWSERVICEEXTIP);
        this.queryDisplays.add((Component)button, c);
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, -15);
        c.fill = 1;
        c.anchor = 11;
        c.weightx = 0.99;
        c.weighty = 1.0;
        this.queryDisplays.add((Component)this.getScrollPane1(), c);
        this.queryDisplays.revalidate();
        this.queryDisplays.repaint();
    }

    public void showBothExamples() {
        this.queryDisplays.removeAll();
        this.queryDisplays.setLayout(new GridBagLayout());
        this.queryDisplays.setBackground(this.tapClient.primaryColor);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.insets = new Insets(-12, -12, 0, 0);
        c.weightx = 0.01;
        c.anchor = 18;
        c.fill = 0;
        Image image = Aladin.aladin.getImagette("Reduire.gif");
        if (image == null) {
            this.reduce = new JButton("-");
        } else {
            this.reduce = new JButton(new ImageIcon(image));
            this.reduce.setBorderPainted(false);
            this.reduce.setMargin(new Insets(0, 0, 0, 0));
            this.reduce.setContentAreaFilled(false);
        }
        this.reduce.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ServerTapExamples.this.setOnlyClientGenExamples();
            }
        });
        this.reduce.setToolTipText(HIDESERVICEEXAMPLES);
        this.queryDisplays.add((Component)this.reduce, c);
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 1;
        c.anchor = 11;
        c.weightx = 0.99;
        c.weighty = 1.0;
        JScrollPane scrolley1 = this.getScrollPane1();
        scrolley1.setMinimumSize(new Dimension(250, 100));
        JScrollPane scrolley2 = new JScrollPane(this.serviceExamplesGui);
        scrolley2.setBackground(this.tapClient.primaryColor);
        scrolley2.setToolTipText(TAPEXSERVICEPROVIDEDTOOLTIP);
        scrolley2.setBorder(this.getFancyTitleBorder(TAPEXSERVICEPROVIDEDLABEL));
        this.centerPanel = new MySplitPane(this.aladin, 1, scrolley1, scrolley2, 1);
        this.centerPanel.setBackground(this.tapClient.primaryColor);
        this.centerPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ServerTapExamples.this.reduce.revalidate();
                ServerTapExamples.this.reduce.repaint();
            }
        });
        scrolley2.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                ServerTapExamples.this.reduce.revalidate();
                ServerTapExamples.this.reduce.repaint();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                ServerTapExamples.this.reduce.revalidate();
                ServerTapExamples.this.reduce.repaint();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.centerPanel.setDividerLocation(0.7);
        this.queryDisplays.add((Component)this.centerPanel, c);
        this.queryDisplays.revalidate();
        this.queryDisplays.repaint();
    }

    private JScrollPane getScrollPane1() {
        JScrollPane scrolley = new JScrollPane(this.examplesGui);
        scrolley.setToolTipText(TAPEXGENERATEDTOOLTIP);
        scrolley.setBorder(BorderFactory.createTitledBorder(TAPEXGENERATEDLABEL));
        scrolley.setBackground(this.tapClient.primaryColor);
        return scrolley;
    }

    @Override
    public void submit() {
        if (this.sync_async != null && this.tap != null) {
            String tapQuery = this.tap.getText();
            if (this.tap.getText().isEmpty()) {
                Aladin.error(this, this.CHECKQUERY_ISBLANK);
                return;
            }
            String fullQuery = tapQuery.toUpperCase();
            if (!fullQuery.startsWith("SELECT ")) {
                tapQuery = fullQuery.substring(fullQuery.indexOf("SELECT", 0), fullQuery.length());
                Aladin.trace(3, tapQuery);
            }
            boolean sync = this.sync_async.getSelectedItem().equals("SYNC");
            this.submitTapServerRequest(sync, this.tapClient.tapLabel, this.tapClient.tapBaseUrl, tapQuery);
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String action;
        super.actionPerformed(arg0);
        Object source = arg0.getSource();
        if (source instanceof JButton && (action = ((JButton)source).getActionCommand()).equals("CHECKQUERY")) {
            this.checkQueryFlagMessage();
        }
    }

    @Override
    public void createFormDefault() {
        this.createForm(null, null);
    }

    @Override
    public void changeTableSelection(String tableChoice) {
        if (this.examplesGui != null) {
            this.setTableGetColumnsToLoad(tableChoice, this.tapClient.tablesMetaData);
            this.regenerateBasicExamplesRepaint();
        }
    }

    @Override
    public void checkSelectionChanged(JComboBox<String> comboBox) {
        if (comboBox.getSelectedItem() != null) {
            String chosen = comboBox.getSelectedItem().toString();
            if (comboBox.equals(this.tablesGui) && !this.selectedTableName.equalsIgnoreCase(chosen)) {
                Aladin.trace(3, "Change table selection from within the document");
                this.selectedTableName = chosen;
                this.changeTableSelection(this.selectedTableName);
            } else if (comboBox.equals(this.secondaryTablesGui) && (this.secondaryTable != null || !chosen.equalsIgnoreCase(this.secondaryTable))) {
                Aladin.trace(3, "Change table selection from within the document");
                if (this.secondaryTablesGui.getItemCount() > 0) {
                    if (this.addSecondTable.isSelected()) {
                        this.secondaryTablesGui.setEnabled(true);
                        this.secondaryTable = chosen;
                    }
                    this.addSecondTable.setEnabled(true);
                    if (this.secondaryTablesGui.getSelectedItem() != null) {
                        String uploadTable = (String)this.secondaryTablesGui.getSelectedItem();
                        UploadTablesRenderer uploadTableRenderer = (UploadTablesRenderer)this.secondaryTablesGui.getRenderer();
                        String planeName = uploadTableRenderer.getUploadPlaneName((String)this.secondaryTablesGui.getSelectedItem());
                        this.secondaryTablesGui.setToolTipText(UploadTablesRenderer.getToolTip(planeName, uploadTable));
                    }
                } else {
                    this.secondaryTable = null;
                    this.addSecondTable.setEnabled(false);
                    this.secondaryTablesGui.setEnabled(false);
                }
                this.changeTableSelection(this.selectedTableName);
            }
        } else if (comboBox.equals(this.secondaryTablesGui)) {
            this.secondaryTable = null;
            this.addSecondTable.setEnabled(false);
            this.secondaryTablesGui.setEnabled(false);
            this.changeTableSelection(this.selectedTableName);
            TapManager.getInstance(this.aladin).eraseNotification(this.info1, "Queries regenerated!", this.CLIENTINSTR);
        }
    }

    public void regenerateBasicExamples() {
        boolean obscore;
        Map<String, TapTable> uploadedTables;
        this.basicExamples.clear();
        if (this.secondaryTable != null && this.selectedTableName.equalsIgnoreCase(this.secondaryTable)) {
            this.secondaryTable = null;
            TapManager.getInstance(this.aladin).eraseNotification(this.info1, NODUPLICATESELECTION, this.CLIENTINSTR);
        }
        String priTableNameForQuery = TapTable.getQueryPart(this.selectedTableName, true);
        this.basicExamples.put("Select all", new CustomListCell("Select * from " + priTableNameForQuery, ""));
        this.basicExamples.put("Select top 1000", new CustomListCell("Select TOP 1000 * from " + priTableNameForQuery, ""));
        this.basicExamples.put("Get the number of rows", new CustomListCell("Select count(*) from " + priTableNameForQuery, ""));
        String areaConstraint = "0.09";
        TapTable priTableMetaData = this.tapClient.tablesMetaData.get(this.selectedTableName);
        String tableSelectAllQuery = "Select %s *  from %s";
        if (this.max == null) {
            this.max = TAPEXDEFAULTMAXROWS != null ? TAPEXDEFAULTMAXROWS : TAPEXDEFAULTMAXROWS_INT;
        }
        if (!this.max.equalsIgnoreCase("") && !this.max.startsWith("TOP ")) {
            this.max = "TOP " + this.max;
        }
        String conesearchtemplate = " where 1=CONTAINS(POINT('ICRS', %s, %s), CIRCLE('ICRS', %s, %s, %s))";
        String primaryTableSelectAllQuery = String.format(tableSelectAllQuery, this.max, priTableNameForQuery);
        String priRaColumnName = TapTable.getQueryPart(priTableMetaData.getRaColumnName(false), false);
        String priDecColumnName = TapTable.getQueryPart(priTableMetaData.getDecColumnName(false), false);
        String targetQuery = primaryTableSelectAllQuery + conesearchtemplate;
        String coneSearchPart = null;
        try {
            if (priRaColumnName != null && priDecColumnName != null) {
                if (this.grab != null) {
                    this.grab.setVisible(true);
                }
                targetQuery = String.format(targetQuery, priRaColumnName, priDecColumnName, this.grabItX1, this.grabItY1, this.grabItR1);
                this.basicExamples.put("Cone search query", new CustomListCell(targetQuery, SETTARGETTOOLTIP));
                coneSearchPart = String.format(conesearchtemplate, priRaColumnName, priDecColumnName, this.grabItX1, this.grabItY1, this.grabItR1);
            } else if (this.grab != null) {
                this.grab.setVisible(false);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        StringBuffer spQuery = null;
        StringBuffer hints = null;
        CustomListCell setCell = null;
        String queryName = null;
        ArrayList<String> mandateParamsToAdd = new ArrayList<String>();
        ArrayList<String> optionalParamsToAdd = new ArrayList<String>();
        TapTableColumn parallax = priTableMetaData.getFlaggedColumn("parallax");
        TapTableColumn radialVelocity = priTableMetaData.getFlaggedColumn("radialvelocity");
        TapTableColumn bibCode = priTableMetaData.getFlaggedColumn("bibCode");
        TapTableColumn journal = priTableMetaData.getFlaggedColumn("journal");
        TapTableColumn title = priTableMetaData.getFlaggedColumn("title");
        TapTableColumn pmra = priTableMetaData.getFlaggedColumn("pmra");
        TapTableColumn pmdec = priTableMetaData.getFlaggedColumn("pmdec");
        TapTableColumn redshift = priTableMetaData.getFlaggedColumn("redshift");
        TapTableColumn mag = priTableMetaData.getFlaggedColumn("mag");
        TapTableColumn id = priTableMetaData.getFlaggedColumn("id");
        TapTableColumn srcClass = priTableMetaData.getFlaggedColumn("srcclass");
        if (bibCode != null) {
            mandateParamsToAdd.add(bibCode.getColumnNameForQuery());
        }
        if (journal != null) {
            mandateParamsToAdd.add(journal.getColumnNameForQuery());
        }
        if (title != null) {
            mandateParamsToAdd.add(title.getColumnNameForQuery());
        }
        if (id != null) {
            optionalParamsToAdd.add(0, id.getColumnNameForQuery());
        }
        if (!mandateParamsToAdd.isEmpty()) {
            this.addSelectsToBasicExamples("Get bibliographic data", mandateParamsToAdd, optionalParamsToAdd, null, null, null, null);
        }
        spQuery = new StringBuffer();
        hints = new StringBuffer();
        mandateParamsToAdd.clear();
        if (parallax != null) {
            mandateParamsToAdd.add(parallax.getColumnNameForQuery());
            queryName = "Get parallax ";
            this.setHint(hints, parallax);
        }
        if (radialVelocity != null) {
            mandateParamsToAdd.add(radialVelocity.getColumnNameForQuery());
            queryName = queryName != null ? queryName + " and radial velocity" : "Get radial velocity";
            this.setHint(hints, radialVelocity);
        }
        if (!mandateParamsToAdd.isEmpty() && queryName != null) {
            setCell = new CustomListCell();
            setCell.tooltip = hints.toString();
            this.addSelectsToBasicExamples(queryName, mandateParamsToAdd, optionalParamsToAdd, setCell, null, coneSearchPart, SETTARGETTOOLTIP);
        }
        mandateParamsToAdd.clear();
        hints = new StringBuffer();
        setCell = new CustomListCell();
        if (pmra != null) {
            mandateParamsToAdd.add(pmra.getColumnNameForQuery());
            this.setHint(hints, pmra);
        }
        if (pmdec != null) {
            mandateParamsToAdd.add(pmdec.getColumnNameForQuery());
            this.setHint(hints, pmdec);
        }
        if (!mandateParamsToAdd.isEmpty()) {
            int index = optionalParamsToAdd.size();
            if (priDecColumnName != null) {
                optionalParamsToAdd.add(index, priDecColumnName);
            }
            if (priRaColumnName != null) {
                optionalParamsToAdd.add(index, priRaColumnName);
            }
            setCell.tooltip = hints.toString();
            this.addSelectsToBasicExamples("Position and proper motion", mandateParamsToAdd, optionalParamsToAdd, setCell, null, coneSearchPart, SETTARGETTOOLTIP);
            String properMotionQuery = "SQRT(POWER(" + pmra.getColumnNameForQuery() + ",2)+POWER(" + pmdec.getColumnNameForQuery() + ",2))";
            mandateParamsToAdd.add(properMotionQuery + " as pm");
            properMotionQuery = " WHERE " + properMotionQuery + " > 20";
            setCell = new CustomListCell();
            setCell.tooltip = hints.toString();
            this.addSelectsToBasicExamples("Proper motion", mandateParamsToAdd, optionalParamsToAdd, setCell, "Proper motion limits ", properMotionQuery, "");
        }
        spQuery = new StringBuffer();
        mandateParamsToAdd.clear();
        if (redshift != null) {
            mandateParamsToAdd.add(redshift.getColumnNameForQuery());
            setCell = new CustomListCell();
            hints = new StringBuffer();
            this.setHint(hints, redshift);
            setCell.tooltip = hints.toString();
            this.addSelectsToBasicExamples(null, mandateParamsToAdd, optionalParamsToAdd, setCell, null, coneSearchPart, SETTARGETTOOLTIP);
        }
        spQuery = new StringBuffer(primaryTableSelectAllQuery);
        hints = new StringBuffer();
        if (srcClass != null) {
            spQuery.append(" where ").append(srcClass.getColumnNameForQuery()).append(" LIKE '%STAR%'");
            this.setHint(hints, srcClass);
            this.basicExamples.put("Based on source type ", new CustomListCell(spQuery.toString(), hints.toString()));
        }
        String sRegionColumnName = null;
        String secRaColumnName = null;
        String secDecColumnName = null;
        String secTableNameForQuery = null;
        TapTable secTableMetaData = null;
        if (this.secondaryTable != null && (uploadedTables = this.tapClient.tapManager.getUploadedTables()) != null && (secTableMetaData = uploadedTables.get(this.secondaryTable)) != null) {
            secRaColumnName = TapTable.getQueryPart(secTableMetaData.getRaColumnName(false), false);
            secDecColumnName = TapTable.getQueryPart(secTableMetaData.getDecColumnName(false), false);
            secTableNameForQuery = TapTable.getQueryPart(this.secondaryTable, true);
        }
        if (obscore = priTableMetaData.isObscore()) {
            String dataproduct_type = priTableMetaData.getObsColumnNameForQuery("dataproduct_type");
            String obs_id = priTableMetaData.getObsColumnNameForQuery("obs_id");
            String access_url = priTableMetaData.getObsColumnNameForQuery("access_url");
            String access_format = priTableMetaData.getObsColumnNameForQuery("access_format");
            String access_estsize = priTableMetaData.getObsColumnNameForQuery("access_estsize");
            sRegionColumnName = priTableMetaData.getObsColumnNameForQuery(ServerObsTap.FIELDSIZE);
            String s_resolution = priTableMetaData.getObsColumnNameForQuery(ServerObsTap.SPATIALRESOLUTION);
            String t_min = priTableMetaData.getObsColumnNameForQuery("t_min");
            String t_max = priTableMetaData.getObsColumnNameForQuery("t_max");
            String t_exptime = priTableMetaData.getObsColumnNameForQuery(ServerObsTap.EXPOSURETIME);
            String t_resolution = priTableMetaData.getObsColumnNameForQuery(ServerObsTap.TIMERESOLUTION);
            String em_min = priTableMetaData.getObsColumnNameForQuery("em_min");
            String em_max = priTableMetaData.getObsColumnNameForQuery("em_max");
            String em_res_power = priTableMetaData.getObsColumnNameForQuery(ServerObsTap.SPECTRALRESOLUTIONPOWER);
            spQuery = new StringBuffer(primaryTableSelectAllQuery);
            if (dataproduct_type != null && s_resolution != null) {
                spQuery.append(" WHERE ").append(dataproduct_type).append(" = 'image'").append(" AND ").append(s_resolution).append(" < 0.3 ");
                if (em_min != null && em_max != null) {
                    spQuery.append(" AND (").append(em_min).append(" > 2.1e-06").append(" AND ").append(em_max).append(" < 2.4e-06)").append(" OR (").append(em_min).append(" > 1.6e-06").append(" AND ").append(em_max).append(" < 1.8e-06)").append(" OR (").append(em_min).append(" > 1.2e-06").append(" AND ").append(em_max).append(" < 1.4e-06)");
                }
                this.basicExamples.put("Images in band J, H, K with spatial res. > 0.3 arcsec", new CustomListCell(spQuery.toString(), ""));
            }
            mandateParamsToAdd.clear();
            optionalParamsToAdd.clear();
            if (access_url != null) {
                mandateParamsToAdd.add(access_url);
            }
            if (access_format != null) {
                mandateParamsToAdd.add(access_format);
            }
            if (access_estsize != null) {
                mandateParamsToAdd.add(access_estsize);
            }
            if (obs_id != null) {
                optionalParamsToAdd.add(0, obs_id);
            }
            if (!mandateParamsToAdd.isEmpty()) {
                this.addSelectsToBasicExamples("Get access_url, access_formats...", mandateParamsToAdd, optionalParamsToAdd, null, null, null, null);
            }
            spQuery = new StringBuffer(primaryTableSelectAllQuery);
            if (t_exptime != null && em_min != null && em_max != null) {
                spQuery.append(" WHERE ").append(t_exptime).append(" > 10000");
                if (sRegionColumnName != null) {
                    spQuery.append(" AND CONTAINS(POINT('ICRS'," + this.grabItX1 + " , " + this.grabItY1 + ")," + sRegionColumnName + ") = 1");
                }
                spQuery.append(" AND (").append(em_min).append(" < 2.48e-10").append(" AND ").append(em_max).append(" > 2.48e-10)");
                this.basicExamples.put("Data at specified values for energy, position and exposure time", new CustomListCell(spQuery.toString(), ""));
            }
            spQuery = new StringBuffer(primaryTableSelectAllQuery);
            String label = null;
            if (dataproduct_type != null) {
                spQuery.append(" WHERE ").append(dataproduct_type).append(" = 'cube'");
                if (sRegionColumnName != null) {
                    spQuery.append(" AND CONTAINS(POINT('ICRS'," + this.grabItX1 + " , " + this.grabItY1 + ")," + sRegionColumnName + ") = 1");
                    label = "Get cube at specified target";
                } else {
                    label = "Get cube";
                }
                this.basicExamples.put(label, new CustomListCell(spQuery.toString(), ""));
                if (em_res_power != null && em_min != null && em_max != null) {
                    spQuery.append(" AND ").append(em_res_power).append(" < 5250/5").append(" AND ").append(em_min).append(" <= 4000e-10 ").append(" AND 6500e-10 <= ").append(em_max);
                    this.basicExamples.put(label + " with spectral constraints", new CustomListCell(spQuery.toString(), ""));
                }
            }
            spQuery = targetQuery != null ? new StringBuffer(targetQuery).append(" AND ") : new StringBuffer(primaryTableSelectAllQuery).append(" WHERE ");
            if (dataproduct_type != null && t_resolution != null) {
                spQuery.append(dataproduct_type).append(" = 'timeseries'").append(" AND ").append(t_resolution).append(" > 60");
                if (t_min != null) {
                    spQuery.append(" AND ").append(t_min).append(" BETWEEN 54261 AND 54627");
                }
                this.basicExamples.put("Time series for position and time constraints", new CustomListCell(spQuery.toString(), ""));
            }
            spQuery = new StringBuffer(primaryTableSelectAllQuery);
            hints = new StringBuffer();
            if (sRegionColumnName != null) {
                spQuery.append(" WHERE AREA(").append(sRegionColumnName).append(") > ").append(areaConstraint);
                this.basicExamples.put("Area > " + areaConstraint, new CustomListCell(spQuery.toString(), ""));
                spQuery = new StringBuffer(primaryTableSelectAllQuery);
                String targetSearch = " WHERE 1=CONTAINS(POINT('ICRS', %s, %s), %s)";
                targetSearch = String.format(targetSearch, this.grabItX1, this.grabItY1, sRegionColumnName);
                spQuery.append(targetSearch);
                this.basicExamples.put("Specific target search", new CustomListCell(spQuery.toString(), SETTARGETTOOLTIP));
            }
            if (this.secondaryTable != null && secTableMetaData != null) {
                String sec_t_min = secTableMetaData.getObsColumnNameForQuery("t_min");
                String sec_t_max = secTableMetaData.getObsColumnNameForQuery("t_max");
                spQuery = new StringBuffer("Select ");
                spQuery.append(this.max).append(" ").append(priTableNameForQuery).append(".*,").append(secTableNameForQuery).append(".* FROM ").append(priTableNameForQuery).append(" JOIN ").append(secTableNameForQuery).append(" ");
                if (sRegionColumnName != null && secRaColumnName != null && secDecColumnName != null) {
                    spQuery.append(" ON 1= CONTAINS(POINT('ICRS',").append(secTableNameForQuery).append(".").append(secRaColumnName).append(", ").append(secTableNameForQuery).append(".").append(secDecColumnName).append("),").append(priTableNameForQuery).append(".").append(sRegionColumnName).append(")");
                    this.basicExamples.put("Join w.r.t second table positions", new CustomListCell(spQuery.toString(), ""));
                    spQuery.append(" WHERE ");
                    if (t_min != null && t_max != null && sec_t_min != null && sec_t_max != null) {
                        spQuery.append(priTableNameForQuery).append(".").append(dataproduct_type).append(" = 'image'").append(" AND ").append(priTableNameForQuery).append(".").append(t_min).append(" <= ").append(secTableNameForQuery).append(".").append(sec_t_min).append(" + 1 AND ").append(secTableNameForQuery).append(".").append(sec_t_min).append(" - 1 <= ").append(priTableNameForQuery).append(".").append(t_max);
                        this.basicExamples.put("Images within one day of second table time interval", new CustomListCell(spQuery.toString(), ""));
                    }
                }
            }
        }
        spQuery = new StringBuffer(primaryTableSelectAllQuery);
        if (this.secondaryTable != null) {
            spQuery = new StringBuffer(primaryTableSelectAllQuery);
            if (priRaColumnName != null && priDecColumnName != null && secRaColumnName != null && secDecColumnName != null) {
                spQuery.append(",").append(secTableNameForQuery).append(" WHERE 1= CONTAINS(POINT('ICRS', ").append(priTableNameForQuery).append(".").append(priRaColumnName).append(", ").append(priTableNameForQuery).append(".").append(priDecColumnName).append("), CIRCLE('ICRS', ").append(this.grabItX1).append(",").append(this.grabItY1).append(",").append(this.grabItR1).append(")) AND ").append("1 =CONTAINS (POINT('ICRS', ").append(priTableNameForQuery).append(".").append(priRaColumnName).append(", ").append(priTableNameForQuery).append(".").append(priDecColumnName).append("), CIRCLE('ICRS', ").append(secTableNameForQuery).append(".").append(secRaColumnName).append(", ").append(secTableNameForQuery).append(".").append(secDecColumnName).append(", 0.0001))");
                this.basicExamples.put("Cross match", new CustomListCell(spQuery.toString(), ""));
                spQuery = new StringBuffer(primaryTableSelectAllQuery);
                spQuery.append(" WHERE NOT EXISTS (").append(" SELECT * FROM ").append(secTableNameForQuery).append(" WHERE 1= CONTAINS (POINT('ICRS',").append(secTableNameForQuery).append(".").append(secRaColumnName).append(", ").append(secTableNameForQuery).append(".").append(secDecColumnName).append("), CIRCLE('ICRS', ").append(priTableNameForQuery).append(".").append(priRaColumnName).append(", ").append(priTableNameForQuery).append(".").append(priDecColumnName).append(", 0.0001)))");
                this.basicExamples.put("No match without target", new CustomListCell(spQuery.toString(), "Filter out objects from the second table. " + CHANGESETTINGSTOOLTIP));
                spQuery.append(" AND 1=CONTAINS(POINT('ICRS',").append(priRaColumnName).append(", ").append(priDecColumnName).append("), CIRCLE('ICRS', ").append(this.grabItX1).append(",").append(this.grabItY1).append(",").append(this.grabItR1).append("))");
                this.basicExamples.put("No match at selected target", new CustomListCell(spQuery.toString(), "Filter out objects from the second table. " + CHANGESETTINGSTOOLTIP));
            }
        }
    }

    private void setHint(StringBuffer hints, TapTableColumn tapTableColumn) {
        if (tapTableColumn != null) {
            if (hints.length() != 0) {
                hints.append(", ");
            }
            hints.append(tapTableColumn.getColumn_name());
            if (tapTableColumn.getUnit() != null && !tapTableColumn.getUnit().isEmpty()) {
                hints.append(" in ").append(tapTableColumn.getUnit());
            }
            if (tapTableColumn.getUtype() != null && !tapTableColumn.getUtype().isEmpty()) {
                hints.append(", UTYPE: ").append(tapTableColumn.getUtype());
            }
        }
    }

    public void targetSettingsChangedAction() {
        this.changeTargetSettings();
        this.regenerateBasicExamplesRepaint();
    }

    public void regenerateBasicExamplesRepaint() {
        this.regenerateBasicExamples();
        this.examplesGui.removeAll();
        this.examplesGui.setListData(this.basicExamples.keySet().toArray());
        this.examplesGui.revalidate();
        this.examplesGui.repaint();
        this.tapClient.tapManager.eraseNotification(this.info1, QUERIESREFRESHED, this.CLIENTINSTR);
    }

    public void changeTargetSettings() {
        if (this.target != null) {
            try {
                String obj = this.resolveQueryField();
                if (obj == null) {
                    throw new Exception(this.UNKNOWNOBJ);
                }
                if (!obj.trim().equals("--   --") && this.radius != null) {
                    String grabItX = Util.myRound(this.coo[0].getText(), 5);
                    String grabItY = Util.myRound(this.coo[1].getText(), 5);
                    this.grabItX1 = grabItX;
                    this.grabItY1 = grabItY;
                    this.grabItR1 = Util.myRound(this.rad[0].getText(), 5);
                }
            }
            catch (Exception e) {
                Aladin.error(this, "No target set. " + e.getMessage());
            }
        }
    }

    public void appendSelectString(List<String> selectParams, StringBuffer spQuery) {
        boolean notFirst = false;
        for (String selectParam : selectParams) {
            if (notFirst) {
                spQuery.append(", ");
            }
            spQuery.append(selectParam);
            notFirst = true;
        }
    }

    public void populateExamples() {
        this.regenerateBasicExamples();
        this.fetchServiceProvidedExamples();
    }

    private void fetchServiceProvidedExamples() {
    }

    public void addSelectsToBasicExamples(String queryName, List<String> mandatoryParams, List<String> optionalParamsToAdd, CustomListCell setCell, String whereLabel, String wherePart, String wherePartToolTip) {
        String tableSelectQuery = "Select %s %s from %s";
        StringBuffer spQuery = new StringBuffer();
        ArrayList<String> selectParamsToAdd = new ArrayList<String>();
        selectParamsToAdd.addAll(optionalParamsToAdd);
        selectParamsToAdd.addAll(mandatoryParams);
        this.appendSelectString(selectParamsToAdd, spQuery);
        if (spQuery.toString().isEmpty()) {
            spQuery.append(" * ");
        }
        String priTableNameForQuery = TapTable.getQueryPart(this.selectedTableName, true);
        String queryToDisplay = String.format(tableSelectQuery, this.max, spQuery.toString(), priTableNameForQuery);
        if (queryName == null) {
            queryName = "Select " + spQuery.toString();
        }
        if (setCell == null) {
            this.basicExamples.put(queryName, new CustomListCell(queryToDisplay, ""));
        } else {
            setCell.label = queryToDisplay;
            this.basicExamples.put(queryName, setCell);
        }
        if (wherePart != null) {
            if (whereLabel == null) {
                whereLabel = queryName + " plus conesearch";
            }
            this.basicExamples.put(whereLabel, new CustomListCell(queryToDisplay + wherePart, wherePartToolTip));
        }
    }

    @Override
    protected void clear() {
        if (this.sync_async != null) {
            this.sync_async.setSelectedIndex(0);
        }
        this.resetFields();
        super.clear();
        this.revalidate();
        this.repaint();
    }

    protected void resetFields() {
        if (this.circleOrSquare != null) {
            this.circleOrSquare.setSelectedIndex(0);
        }
        if (this.tap != null) {
            this.tap.setText("");
        }
    }

    @Override
    protected void reset() {
        this.createFormDefault();
        this.resetFields();
        super.reset();
        this.revalidate();
        this.repaint();
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.description = Aladin.chaine.getString("TAPFORMINFO");
        this.title = Aladin.chaine.getString("TAPFORMTITLE");
        this.verboseDescr = this.loadedServerDescription = Aladin.chaine.getString("TAPEXAMPLEFORMDESC");
        TAPSERVICEEXAMPLESTOOLTIP = Aladin.chaine.getString("TAPSERVICEEXAMPLESTOOLTIP");
        SETTARGETTOOLTIP = Aladin.chaine.getString("SETTARGETTOOLTIP");
        TAPEXDEFAULTMAXROWS = ConfigurationReader.getInstance().getPropertyValue("TAPEXDEFAULTMAXROWS");
        CHANGESETTINGSTOOLTIP = Aladin.chaine.getString("CHANGESETTINGSTOOLTIP");
        NODUPLICATESELECTION = Aladin.chaine.getString("NODUPLICATESELECTION");
        JOINTABLETOOLTIP = Aladin.chaine.getString("JOINTABLETOOLTIP");
        QUERIESREFRESHED = Aladin.chaine.getString("QUERIESREFRESHED");
        TAPEXGENERATEDLABEL = Aladin.chaine.getString("TAPEXGENERATEDLABEL");
        TAPEXGENERATEDTOOLTIP = Aladin.chaine.getString("TAPEXGENERATEDTOOLTIP");
        TAPEXSERVICEPROVIDEDLABEL = Aladin.chaine.getString("TAPEXSERVICEPROVIDEDLABEL");
        TAPEXSERVICEPROVIDEDTOOLTIP = Aladin.chaine.getString("TAPEXSERVICEPROVIDEDTOOLTIP");
        SHOWSERVICEEXTIP = Aladin.chaine.getString("SHOWSERVICEEXTIP");
        HIDESERVICEEXAMPLES = Aladin.chaine.getString("HIDESERVICEEXAMPLES");
    }
}

