/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import adql.db.DBChecker;
import cds.aladin.Aladin;
import cds.aladin.Ball;
import cds.aladin.ColumnConstraint;
import cds.aladin.Constants;
import cds.aladin.CustomListCellRenderer;
import cds.aladin.DynamicTapForm;
import cds.aladin.JoinConstraint;
import cds.aladin.JoinFacade;
import cds.aladin.PositionConstraint;
import cds.aladin.TapClient;
import cds.aladin.TapManager;
import cds.aladin.TapTable;
import cds.aladin.TapTableColumn;
import cds.aladin.Tok;
import cds.aladin.WhereGridConstraint;
import cds.tools.CDSConstants;
import cds.tools.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;

public class ServerTap
extends DynamicTapForm
implements MouseListener {
    private static final long serialVersionUID = 1L;
    public static String LOAD = Aladin.chaine.getString("FSLOAD");
    public static String REFRESHQUERYTOOLTIP = Aladin.chaine.getString("REFRESHQUERYTOOLTIP");
    private String raColumnName;
    private String decColumnName;
    static final int DEFAULT_INFO_TABLE_HEIGHT = 115;
    JList selectList;
    JCheckBox selectAll;
    JPanel whereClausesPanel;
    List<ColumnConstraint> whereClauses;
    JComboBox<String> limit;
    JPanel queryComponentsGui;
    JPanel targetPanel;
    JFrame setRaDecFrame;
    JoinFacade joinPanel;

    protected ServerTap(Aladin aladin) {
        super(aladin);
    }

    @Override
    public void createFormDefault() {
        this.createForm(null);
    }

    protected void createForm(String tableChoice) {
        this.CLIENTINSTR = Aladin.chaine.getString("TAPCLIENTINSTR");
        Map<String, TapTable> tablesMetaData = this.tapClient.tablesMetaData;
        Vector<String> tables = this.getTableNames();
        TapTable chosenTable = null;
        chosenTable = tableChoice == null || !tables.contains(tableChoice) ? tablesMetaData.get(tables.firstElement()) : tablesMetaData.get(tableChoice);
        this.selectedTableName = chosenTable.getTable_name();
        Vector<TapTableColumn> columnNames = this.getColumnsToLoad(this.selectedTableName, tablesMetaData);
        DBChecker checker = new DBChecker(this.tapClient.queryCheckerTables);
        this.adqlParser.setQueryChecker(checker);
        this.setBasics();
        this.raColumnName = chosenTable.getRaColumnName(false);
        this.decColumnName = chosenTable.getDecColumnName(false);
        GridBagConstraints c = new GridBagConstraints();
        JPanel containerPanel = new JPanel(new GridBagLayout());
        this.setTopPanel(containerPanel, c, this.info1, this.CLIENTINSTR);
        JPanel tablesPanel = null;
        try {
            this.tablesGui = new JComboBox<String>(tables);
            tablesPanel = ServerTap.getTablesPanel(this.tapClient, this, null, this.tablesGui, chosenTable, tables, null, false);
        }
        catch (BadLocationException e) {
            Aladin.error(this, e.getMessage());
            return;
        }
        tablesPanel.setFont(CDSConstants.BOLD);
        c.weighty = 0.02;
        c.anchor = 21;
        c.weightx = 0.1;
        c.fill = 0;
        c.insets = new Insets(0, 4, 0, 0);
        containerPanel.add((Component)tablesPanel, c);
        this.queryComponentsGui = new JPanel();
        this.setWhereAddConstraintsGui(columnNames);
        this.queryComponentsGui.setBackground(this.tapClient.primaryColor);
        this.queryComponentsGui.setFont(CDSConstants.BOLD);
        c.weighty = 0.51;
        c.weightx = 0.4;
        c.fill = 1;
        ++c.gridy;
        containerPanel.add((Component)this.queryComponentsGui, c);
        JPanel linePanel = this.getBottomPanel(true);
        c.weightx = 0.1;
        c.weighty = 0.02;
        c.insets = new Insets(0, -6, 0, 0);
        c.fill = 1;
        ++c.gridy;
        containerPanel.add((Component)linePanel, c);
        JScrollPane scrolley = null;
        this.tap = new JTextArea(8, 100);
        this.tap.setFont(Aladin.ITALIC);
        this.tap.setWrapStyleWord(true);
        this.tap.setLineWrap(true);
        this.tap.setEditable(true);
        scrolley = new JScrollPane(this.tap);
        c.weightx = 0.35;
        c.weighty = 0.35;
        c.insets = new Insets(0, 4, 0, 0);
        c.fill = 1;
        ++c.gridy;
        containerPanel.add((Component)scrolley, c);
        this.removeAll();
        this.add(containerPanel);
        this.addMouseListener(this);
        this.formLoadStatus = 2;
        this.writeQuery();
    }

    public void joinConstraintUpdated() {
        this.waitCursor();
        this.tapClient.activateWaitMode(this);
        Map<String, TapTable> tablesMetaData = this.tapClient.tablesMetaData;
        TapTable mainTable = tablesMetaData.get(this.selectedTableName);
        if (!this.joinPanel.constraints.isEmpty()) {
            String alias = TapTable.getQueryPart(this.selectedTableName, true);
            mainTable.setAlias(alias);
        } else {
            mainTable.setAlias(null);
        }
        Vector<TapTableColumn> displayColumns = null;
        try {
            displayColumns = this.getSelectedTablesColumns();
        }
        catch (Exception e) {
            this.defaultCursor();
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.error(this, e.getMessage());
            return;
        }
        if (this.whereClausesPanel.getComponentCount() > 0) {
            Component[] whereConstraints;
            ColumnConstraint columnConstraint = null;
            boolean changed = false;
            for (Component component : whereConstraints = this.whereClausesPanel.getComponents()) {
                if (!(component instanceof ColumnConstraint)) continue;
                columnConstraint = (ColumnConstraint)component;
                TapTableColumn selectedItem = columnConstraint.getSelectedItem();
                if (!displayColumns.contains(selectedItem)) {
                    this.whereClausesPanel.remove(columnConstraint);
                    changed = true;
                    continue;
                }
                columnConstraint.setWhereModel(displayColumns, selectedItem);
            }
            if (changed) {
                ColumnConstraint.removeFirstAndOrOperator(this.whereClausesPanel);
            }
        }
        int[] selectedSelectListColumns = null;
        if (!this.selectAll.isSelected()) {
            selectedSelectListColumns = this.selectList.getSelectedIndices();
        }
        DefaultListModel<TapTableColumn> model = new DefaultListModel<TapTableColumn>();
        for (TapTableColumn displayColumn : displayColumns) {
            model.addElement(displayColumn);
        }
        this.selectList.setModel(model);
        if (selectedSelectListColumns == null) {
            this.selectAll.setSelected(true);
            this.resetColumnSelection();
        } else {
            this.selectList.setSelectedIndices(selectedSelectListColumns);
        }
        this.ball.setMode(0);
        this.formLoadStatus = 2;
        this.writeQuery();
        this.revalidate();
        this.repaint();
        this.defaultCursor();
        this.info1.setText(this.CLIENTINSTR);
    }

    @Override
    public void changeTableSelection(String tableChoice) {
        this.waitCursor();
        if (this.modeChoice != null) {
            this.modeChoice.setVisible(true);
        }
        this.tapClient.activateWaitMode(this);
        Map<String, TapTable> tablesMetaData = this.tapClient.tablesMetaData;
        Vector<TapTableColumn> columnNames = this.setTableGetColumnsToLoad(tableChoice, tablesMetaData);
        if (columnNames == null) {
            return;
        }
        this.raColumnName = tablesMetaData.get(this.selectedTableName).getRaColumnName(false);
        this.decColumnName = tablesMetaData.get(this.selectedTableName).getDecColumnName(false);
        if (Aladin.levelTrace >= 3) {
            System.out.println("ra and dec: " + (this.raColumnName != null && this.decColumnName != null));
        }
        if (Aladin.levelTrace >= 3) {
            System.out.println("and target panel: " + this.target);
        }
        if (this.raColumnName != null && this.decColumnName != null) {
            if (Aladin.levelTrace >= 3) {
                System.out.println("target: " + this.target);
            }
            if (this.target == null) {
                this.createTargetPanel(this.targetPanel);
            }
            this.targetPanel.setVisible(true);
        } else if (this.target != null) {
            this.targetPanel.setVisible(false);
        }
        this.selectList.removeAll();
        Vector<TapTableColumn> model = new Vector<TapTableColumn>();
        model.addAll(columnNames);
        this.selectList.setListData(model);
        if (this.selectAll != null) {
            this.selectAll.setSelected(true);
        }
        this.resetFields();
        this.changeJoin();
        this.ball.setMode(0);
        this.formLoadStatus = 2;
        this.writeQuery();
        this.revalidate();
        this.repaint();
        this.defaultCursor();
        this.info1.setText(this.CLIENTINSTR);
    }

    private void changeJoin() {
        if (this.joinPanel != null) {
            this.tapClient.tapManager.loadForeignKeyRelationsForSelectedTable(this.tapClient, this.joinPanel, this.selectedTableName);
        }
    }

    public void setWhereAddConstraintsGui(Vector<TapTableColumn> columnNames) {
        this.queryComponentsGui.removeAll();
        GridBagLayout gridbag = new GridBagLayout();
        this.queryComponentsGui.setLayout(gridbag);
        this.queryComponentsGui.setBackground(this.tapClient.primaryColor);
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBackground(this.tapClient.secondColor);
        JLabel label = new JLabel("Select:");
        label.setFont(CDSConstants.BOLD);
        panel.add(label);
        this.selectAll = new JCheckBox("All", true);
        this.selectAll.setActionCommand("SELECTALL");
        this.selectAll.addActionListener(this);
        panel.add(this.selectAll);
        if (columnNames != null) {
            Vector<TapTableColumn> modelNames = new Vector<TapTableColumn>();
            modelNames.addAll(columnNames);
            this.selectList = new JList(modelNames);
            this.selectList.setSelectionInterval(0, modelNames.size() - 1);
            this.selectList.setCellRenderer(new CustomListCellRenderer(this));
            this.selectList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (ServerTap.this.selectList.getSelectedValuesList().size() != ServerTap.this.selectList.getModel().getSize()) {
                        ServerTap.this.selectAll.setSelected(false);
                    } else {
                        ServerTap.this.selectAll.setSelected(true);
                    }
                    ServerTap.this.writeQuery();
                }
            });
        }
        JScrollPane scrolley = new JScrollPane(this.selectList);
        this.selectList.setVisibleRowCount(4);
        this.selectList.setSelectionMode(2);
        scrolley.setHorizontalScrollBarPolicy(30);
        scrolley.setVerticalScrollBarPolicy(20);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.2;
        c.weighty = 0.02;
        c.anchor = 17;
        c.fill = 1;
        c.insets = new Insets(0, -5, 0, 0);
        this.queryComponentsGui.add((Component)panel, c);
        c.gridy = 1;
        c.weighty = 0.98;
        c.gridheight = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.queryComponentsGui.add((Component)scrolley, c);
        c.gridy = 0;
        c.gridx = 1;
        c.weightx = 0.8;
        c.weighty = 0.02;
        c.gridheight = 1;
        panel = new JPanel(new FlowLayout(0));
        panel.setBackground(this.tapClient.secondColor);
        label = new JLabel("Constraints:");
        label.setFont(CDSConstants.BOLD);
        panel.add(label);
        JButton button = new JButton("Add new");
        button.setActionCommand("ADDWHERECONSTRAINT");
        button.addActionListener(this);
        panel.add(button);
        panel.add(Box.createHorizontalStrut(15));
        label = new JLabel("Max rows:");
        label.setFont(CDSConstants.BOLD);
        panel.add(label);
        this.limit = new JComboBox<String>(Constants.TAP_REC_LIMIT);
        if (TAPEXDEFAULTMAXROWS != null) {
            if (!TAPEXDEFAULTMAXROWS.isEmpty()) {
                this.limit.setSelectedItem(TAPEXDEFAULTMAXROWS);
            } else {
                this.limit.setSelectedItem("unlimited");
            }
        }
        this.limit.setOpaque(false);
        this.limit.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ServerTap.this.writeQuery();
            }
        });
        panel.add(this.limit);
        this.queryComponentsGui.add((Component)panel, c);
        c.gridy = 1;
        c.weighty = 0.98;
        this.targetPanel = new JPanel();
        this.targetPanel.setBackground(this.tapClient.primaryColor);
        Aladin.trace(3, "ra and dec at createForm " + (this.raColumnName != null && this.decColumnName != null));
        this.createTargetPanel(this.targetPanel);
        if (this.raColumnName == null || this.decColumnName == null) {
            this.targetPanel.setVisible(false);
        }
        c.weighty = 0.2;
        c.gridheight = 1;
        this.queryComponentsGui.add((Component)this.targetPanel, c);
        c.gridy = 2;
        c.weighty = 0.78;
        this.whereClausesPanel = new JPanel();
        this.whereClausesPanel.setLayout(new BoxLayout(this.whereClausesPanel, 1));
        this.whereClausesPanel.setBackground(this.tapClient.secondColor);
        this.whereClausesPanel.setName("WHERECLAUSES");
        JScrollPane constraintsScroller = new JScrollPane();
        constraintsScroller.setViewportView(this.whereClausesPanel);
        constraintsScroller.getVerticalScrollBar().setUnitIncrement(4);
        this.queryComponentsGui.add((Component)constraintsScroller, c);
    }

    public void addWhereConstraint(WhereGridConstraint whereConstraintPanel) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.05;
        gridbag.setConstraints(whereConstraintPanel.andOrOperator, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.45;
        gridbag.setConstraints(whereConstraintPanel.firstGridComponent, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.05;
        gridbag.setConstraints(whereConstraintPanel.secondGridComponent, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.42;
        gridbag.setConstraints(whereConstraintPanel.thirdGridComponent, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.weightx = 0.03;
        whereConstraintPanel.removeButton.addActionListener(this);
        gridbag.setConstraints(whereConstraintPanel.removeButton, gridBagConstraints);
        whereConstraintPanel.setBackground(this.tapClient.secondColor);
        whereConstraintPanel.addWhereConstraints();
        whereConstraintPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, whereConstraintPanel.getMinimumSize().height));
        this.whereClausesPanel.add((Component)whereConstraintPanel, Float.valueOf(0.0f));
        ColumnConstraint.removeFirstAndOrOperator(this.whereClausesPanel);
        this.revalidate();
        this.repaint();
    }

    public void writeQuery() {
        try {
            StringBuffer queryFromGui = new StringBuffer("SELECT");
            if (!this.limit.getSelectedItem().equals("unlimited")) {
                queryFromGui.append(" TOP ").append(this.limit.getSelectedItem());
            }
            if (this.selectAll.isSelected()) {
                queryFromGui.append(" *");
            } else {
                List selectedColumns = this.selectList.getSelectedValuesList();
                if (selectedColumns == null || selectedColumns.isEmpty()) {
                    queryFromGui.append(" *");
                } else {
                    queryFromGui.append(" ");
                    for (TapTableColumn selectedColumn : selectedColumns) {
                        String alias = this.getRelevantAlias(selectedColumn);
                        if (alias != null) {
                            queryFromGui.append(alias).append(".");
                        }
                        queryFromGui.append(selectedColumn.getColumnNameForQuery()).append(", ");
                    }
                }
            }
            queryFromGui = new StringBuffer(queryFromGui.toString().trim().replaceAll(",$", ""));
            queryFromGui.append(" FROM ").append(TapTable.getQueryPart(this.selectedTableName, true)).append(" ");
            if (this.joinPanel != null && this.joinPanel.constraints != null && !this.joinPanel.constraints.isEmpty()) {
                for (JoinConstraint joinConstraint : this.joinPanel.constraints) {
                    queryFromGui.append(joinConstraint.getADQLString()).append(" ");
                }
            }
            if (this.whereClausesPanel.getComponentCount() > 0) {
                Component[] whereConstraints = this.whereClausesPanel.getComponents();
                queryFromGui.append("WHERE ");
                for (int i = 0; i < whereConstraints.length; ++i) {
                    WhereGridConstraint whereConstraint = (WhereGridConstraint)whereConstraints[i];
                    queryFromGui.append(whereConstraint.getAdqlString());
                }
            }
            this.tap.setText(queryFromGui.toString());
            this.ball.setMode(1);
        }
        catch (Exception e) {
            Aladin.error(this, e.getMessage());
            Aladin.trace(3, e.getMessage());
            this.ball.setMode(3);
        }
    }

    @Override
    protected void clear() {
        if (this.sync_async != null) {
            this.sync_async.setSelectedIndex(0);
        }
        if (this.limit != null) {
            if (!TAPEXDEFAULTMAXROWS.isEmpty()) {
                this.limit.setSelectedItem(TAPEXDEFAULTMAXROWS);
            } else {
                this.limit.setSelectedIndex(0);
            }
        }
        if (this.selectAll != null) {
            this.selectAll.setSelected(false);
        }
        boolean resetTargetPanel = false;
        if (this.raColumnName != null && this.decColumnName != null) {
            resetTargetPanel = true;
        }
        this.raColumnName = this.tapClient.tablesMetaData.get(this.selectedTableName).getRaColumnName(false);
        this.decColumnName = this.tapClient.tablesMetaData.get(this.selectedTableName).getDecColumnName(false);
        if (resetTargetPanel && this.raColumnName != null && this.decColumnName != null) {
            resetTargetPanel = false;
        }
        if (resetTargetPanel) {
            Vector<TapTableColumn> columnNames = null;
            try {
                columnNames = this.getSelectedTableColumns();
            }
            catch (Exception e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                Aladin.error(this, e.getMessage());
                return;
            }
            this.setWhereAddConstraintsGui(columnNames);
            this.queryComponentsGui.revalidate();
            this.queryComponentsGui.repaint();
        }
        this.resetColumnSelection();
        this.resetFields();
        this.resetJoin();
        super.clear();
        this.revalidate();
        this.repaint();
    }

    public void resetJoin() {
        if (this.joinPanel != null) {
            this.joinPanel.constraints.clear();
            this.joinConstraintUpdated();
            this.tapClient.tapManager.clearJoinPanel();
            this.joinPanel = null;
        }
    }

    protected void resetFields() {
        if (this.whereClausesPanel != null) {
            this.whereClausesPanel.removeAll();
        }
        if (this.circleOrSquare != null) {
            this.circleOrSquare.setSelectedIndex(0);
        }
        if (this.tap != null) {
            this.tap.setText("");
        }
        this.resetColumnSelection();
    }

    @Override
    protected void reset() {
        this.createFormDefault();
        if (this.selectAll != null) {
            this.selectAll.setSelected(true);
        }
        this.resetFields();
        super.reset();
        this.writeQuery();
        this.revalidate();
        this.repaint();
    }

    protected void resetColumnSelection() {
        if (this.selectAll != null) {
            if (this.selectAll.isSelected()) {
                int start = 0;
                int end = this.selectList.getModel().getSize() - 1;
                if (end >= 0) {
                    this.selectList.setSelectionInterval(start, end);
                }
            } else {
                this.selectList.clearSelection();
            }
        }
    }

    @Override
    protected int createPlane(String target, String radius, String criteria, String label, String origin) {
        try {
            Tok tok = new Tok(criteria, ", ");
            String baseUrl = tok.nextToken();
            String query = tok.nextToken();
            if (!baseUrl.startsWith("http://") && !baseUrl.startsWith("https://")) {
                if (label == null) {
                    label = baseUrl;
                }
                baseUrl = this.aladin.directory.resolveServiceUrl("tap", baseUrl);
            }
            this.ball = new Ball();
            this.tapClient = new TapClient();
            this.tapClient.tapLabel = label;
            TapManager tapManager = TapManager.getInstance(this.aladin);
            tapManager.fireSync(this, baseUrl, query, null);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return -1;
        }
        return 0;
    }

    @Override
    public void submit() {
        if (this.sync_async != null && this.tap != null) {
            boolean sync = this.sync_async.getSelectedItem().equals("SYNC");
            this.submitTapServerRequest(sync, this.tapClient.tapLabel, this.tapClient.tapBaseUrl, this.tap.getText());
            this.aladin.console.printCommand("get TAP(" + Tok.quote(this.tapClient.tapLabel) + "," + Tok.quote(this.tap.getText()) + ")");
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        super.actionPerformed(arg0);
        Object source = arg0.getSource();
        if (source instanceof JButton) {
            String action = ((JButton)source).getActionCommand();
            if (action.equals("WRITEQUERY")) {
                this.writeQuery();
            } else {
                if (action.equals("ADDWHERECONSTRAINT")) {
                    try {
                        Vector<TapTableColumn> columnMetaData = this.getSelectedTablesColumns();
                        ColumnConstraint columnConstraint = new ColumnConstraint(this, columnMetaData);
                        this.addWhereConstraint(columnConstraint);
                        this.writeQuery();
                    }
                    catch (Exception e) {
                        if (Aladin.levelTrace >= 3) {
                            e.printStackTrace();
                        }
                        Aladin.error(this, e.getMessage());
                        return;
                    }
                }
                if (action.equals("REMOVEWHERECONSTRAINT")) {
                    JButton button = (JButton)source;
                    JPanel thisComponent = (JPanel)button.getParent();
                    JPanel compUnderWorks = (JPanel)thisComponent.getParent();
                    compUnderWorks.remove(thisComponent);
                    ColumnConstraint.removeFirstAndOrOperator(this.whereClausesPanel);
                    this.writeQuery();
                    this.whereClausesPanel.revalidate();
                    this.whereClausesPanel.repaint();
                } else if (action.equals("ADDPOSCONSTRAINT")) {
                    String objet = null;
                    if (this.target != null) {
                        try {
                            objet = this.resolveQueryField();
                            if (objet == null) {
                                throw new Exception(this.UNKNOWNOBJ);
                            }
                            this.ball.setMode(1);
                        }
                        catch (Exception e1) {
                            Aladin.error(this, e1.getMessage());
                            this.ball.setMode(3);
                            return;
                        }
                    }
                    if (objet.trim().equals("--   --")) {
                        Aladin.error(this, TapClient.TARGETERROR);
                        this.ball.setMode(3);
                        return;
                    }
                    PositionConstraint positionConstraint = new PositionConstraint(this, Util.myRound(this.coo[0].getText(), 5), Util.myRound(this.coo[1].getText(), 5), Util.myRound(this.rad[0].getText(), 5), this.selectedTableName, this.raColumnName, this.decColumnName);
                    this.addWhereConstraint(positionConstraint);
                    this.writeQuery();
                } else if (action.equals("CHECKQUERY")) {
                    this.checkQueryFlagMessage();
                } else if (action.equals("OPEN_SET_RADEC")) {
                    this.tapClient.tapManager.setRaDecForTapServer(this, this.selectedTableName);
                } else if (action.equals("JOIN_TABLE")) {
                    if (this.joinPanel == null) {
                        this.joinPanel = new JoinFacade(this.aladin, this);
                        this.addAncestorListener(new AncestorListener(){

                            @Override
                            public void ancestorRemoved(AncestorEvent event) {
                                if (!ServerTap.this.isShowing() && ServerTap.this.joinPanel != null && ServerTap.this.joinPanel.isShowing()) {
                                    ServerTap.this.tapClient.tapManager.closeMyJoinFacade(ServerTap.this.joinPanel);
                                }
                            }

                            @Override
                            public void ancestorMoved(AncestorEvent event) {
                            }

                            @Override
                            public void ancestorAdded(AncestorEvent event) {
                            }
                        });
                    }
                    boolean showInstr = this.tapClient.tapManager.showOnJoinFrame(this.tapClient.getVisibleLabel(), this.selectedTableName, this.joinPanel);
                    this.tapClient.tapManager.loadForeignKeyRelationsForSelectedTable(this.tapClient, this.joinPanel, this.selectedTableName);
                    if (showInstr) {
                        JoinFacade.showStatusReport();
                    }
                }
            }
        } else if (source instanceof JCheckBox) {
            Aladin.trace(3, "actionperformed for SELECTALL was triggered");
            JCheckBox selectAll = (JCheckBox)source;
            String action = selectAll.getActionCommand();
            if (action.equals("SELECTALL")) {
                this.resetColumnSelection();
            }
            this.writeQuery();
            this.selectList.revalidate();
            this.selectList.repaint();
        }
    }

    public TapTable getSuitableJoinTable() {
        TapTable potentialJoinTable = null;
        TapTable chosenTable = this.tapClient.tablesMetaData.get(this.selectedTableName);
        if (chosenTable.foreignKeyColumns != null && !chosenTable.foreignKeyColumns.isEmpty()) {
            String potentialJoinTableName = chosenTable.foreignKeyColumns.get(0).getFrom_table();
            potentialJoinTable = this.tapClient.tablesMetaData.get(potentialJoinTableName);
        } else {
            String joinTableName = this.getNextUnselectedTableName();
            potentialJoinTable = this.tapClient.tablesMetaData.get(joinTableName);
        }
        return potentialJoinTable;
    }

    public String getNextUnselectedTableName() {
        String notSelectedTopTable = this.selectedTableName;
        Vector<String> tables = this.getTableNames();
        for (String table : tables) {
            if (this.selectedTableName.equalsIgnoreCase(table)) continue;
            notSelectedTopTable = table;
            break;
        }
        return notSelectedTopTable;
    }

    public Vector<TapTableColumn> getSelectedTableColumns() {
        return this.tapClient.tablesMetaData.get(this.selectedTableName).getColumns();
    }

    public static Vector<TapTableColumn> getPotentialRaOrDecColumns(Vector<TapTableColumn> allColumns) {
        Vector<TapTableColumn> displayColumns = new Vector<TapTableColumn>();
        for (TapTableColumn tapTableColumn : allColumns) {
            if (!tapTableColumn.isNumeric()) continue;
            displayColumns.add(tapTableColumn);
        }
        return displayColumns;
    }

    public Vector<TapTableColumn> getSelectedTablesColumns() throws Exception {
        Vector<TapTableColumn> displayColumns = new Vector();
        if (this.joinPanel != null && this.joinPanel.constraints != null && !this.joinPanel.constraints.isEmpty()) {
            displayColumns.addAll(this.getSelectedTableColumns());
            for (JoinConstraint joinConstraint : this.joinPanel.constraints) {
                Vector<TapTableColumn> columnNames = joinConstraint.columns;
                if (columnNames == null) {
                    throw new Exception(JoinFacade.ERROR_NOJOINCOLUMNS);
                }
                displayColumns.addAll(joinConstraint.columns);
            }
        } else {
            displayColumns = this.tapClient.tablesMetaData.get(this.selectedTableName).getColumns();
        }
        return displayColumns;
    }

    public String getRelevantAlias(TapTableColumn column) {
        String alias = null;
        TapTable table = this.tapClient.tablesMetaData.get(column.getTable_name());
        if (table != null) {
            alias = table.getAlias();
        } else if (this.joinPanel != null && !this.joinPanel.constraints.isEmpty()) {
            for (JoinConstraint constraint : this.joinPanel.constraints) {
                if (!constraint.hasThisColumn(column)) continue;
                alias = constraint.alias;
                break;
            }
        }
        return alias;
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.description = Aladin.chaine.getString("TAPFORMINFO");
        this.title = Aladin.chaine.getString("TAPFORMTITLE");
        this.verboseDescr = this.loadedServerDescription = Aladin.chaine.getString("TAPGENERICFORMDESC");
    }

    public String getRaColumnName() {
        return this.raColumnName;
    }

    public void setRaColumnName(String raColumnName) {
        this.raColumnName = raColumnName;
    }

    public String getDecColumnName() {
        return this.decColumnName;
    }

    public void setDecColumnName(String decColumnName) {
        this.decColumnName = decColumnName;
    }

    public TapTableColumn getDefaultRa() {
        return this.getDefault(this.raColumnName);
    }

    public TapTableColumn getDefaultDec() {
        return this.getDefault(this.decColumnName);
    }

    public TapTableColumn getDefault(String columnName) {
        TapTableColumn result = null;
        if (columnName != null) {
            for (TapTableColumn columnMeta : this.tapClient.tablesMetaData.get(this.selectedTableName).getColumns()) {
                if (!columnMeta.getColumn_name().equals(columnName)) continue;
                result = columnMeta;
                break;
            }
        }
        return result;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.requestFocusInWindow();
        this.writeQuery();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }
}

