/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Glu;
import cds.aladin.MyInputStream;
import cds.aladin.Server;
import cds.aladin.prop.Filet;
import java.awt.Dimension;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ServerSimbad
extends Server {
    String info1;
    String filter;
    protected double maxRadius = 60.0;

    private String getTagGlu(boolean testServer) {
        if (this.TESTSERVER && !testServer) {
            return this.gluTag.substring(0, this.gluTag.length() - 1);
        }
        return this.gluTag;
    }

    protected void init() {
        this.type = 2;
        this.aladinLabel = "Simbad database";
        this.gluTag = "SimbadXML1";
        this.aladinLogo = "SimbadLogo.gif";
        this.docUser = "http://simbad.u-strasbg.fr/guide/ch15.htx";
        this.maxRadius = -1.0;
        if (!Aladin.CDS || this.aladin.glu.getURL(this.gluTag, "", false, false) == null) {
            this.gluTag = this.gluTag.substring(0, this.gluTag.length() - 1);
        } else {
            this.TESTSERVER = true;
        }
        this.filters = new String[]{"#All objects\nfilter All {\n(${OTYPE}=\"Star\" || ${OTYPE}=\"*\\**\") && (${B}!=0 || ${V}!=0 || ${R}!=0 || ${J}!=0 || ${K}!=0) {\n   draw pm(${PMRA},${PMDEC})\n   draw circle(-$[phot.mag*],3,15)\n}\n(${OTYPE}=\"Star\" ||${OTYPE}=\"*\\**\") && ${B}=\"\" && ${V}=\"\" && ${R}=\"\" && ${J}=\"\" && ${K}=\"\" {\n   draw pm(${PMRA},${PMDEC})\n   draw circle(3)\n}\n(${OTYPE}=\"G*\" || ${OTYPE}=\"*G\") && ${GALDIM_MAJAXIS}!=0 {\n   draw ellipse(0.5*${GALDIM_MAJAXIS},0.5*${GALDIM_MINAXIS},${GALDIM_ANGLE})\n}\n(${OTYPE}=\"G*\" || ${OTYPE}=\"*G\")) && ${GALDIM_MAJAXIS}==\"\" {\n   draw oval\n}\n${OTYPE}=\"Radio*\" || ${OTYPE}=\"Maser\" || ${OTYPE}=\"HI\" { draw triangle }\n${OTYPE}=\"UV\" {draw cross;draw plus}\n${OTYPE}=\"IR\" || ${OTYPE}=\"Red*\" {draw rhomb}\n${OTYPE}=\"Neb\"  || ${OTYPE}=\"PN*\" || ${OTYPE}=\"SNR*\" {draw square}\n${OTYPE}=\"HII\" { draw dot }${OTYPE}=\"X\" { draw cross }\n${OTYPE}!=\"Unknown\" && ${OTYPE}!=\"\" { draw ${OTYPE} }\n{ draw dot }\n}", "#Star\nfilter Star {\n(${OTYPE}=\"Star\" || ${OTYPE}=\"*\\**\") && (${B}!=0 || ${V}!=0 || ${R}!=0 || ${J}!=0 || ${K}!=0) {\n   draw pm(${PMRA},${PMDEC})\n   draw circle(-$[phot.mag*],3,15)\n}\n(${OTYPE}=\"Star\" ||${OTYPE}=\"*\\**\") && ${B}=\"\" && ${V}=\"\" && ${R}=\"\" && ${J}=\"\" && ${K}=\"\" {\n   draw pm(${PMRA},${PMDEC})\n   draw circle(3)\n}\n}", "#Galaxy\nfilter Galaxy {\n(${OTYPE}=\"G*\" || ${OTYPE}=\"*G\") && ${GALDIM_MAJAXIS}!=0 {\n   draw ellipse(0.5*${GALDIM_MAJAXIS},0.5*${GALDIM_MINAXIS},${GALDIM_ANGLE})\n}\n(${OTYPE}=\"G*\" || ${OTYPE}=\"*G\")) && ${GALDIM_MAJAXIS}==\"\" {\n   draw oval\n}\n}", "#Radio\nfilter Radio {\n${OTYPE}=\"Radio*\" || ${OTYPE}=\"Maser\" || ${OTYPE}=\"HI\" { draw triangle }\n}", "#UV\nfilter UV {\n${OTYPE}=\"UV\" {draw cross;draw plus}\n}", "#IR\nfilter IR {\n${OTYPE}=\"IR\" || ${OTYPE}=\"Red*\" {draw rhomb}\n}", "#Neb\nfilter Neb {\n${OTYPE}=\"Neb\"  || ${OTYPE}=\"PN*\" || ${OTYPE}=\"SNR*\" {draw square}\n}", "#HII\nfilter HII {\n${OTYPE}=\"HII\" { draw dot }}", "#X\nfilter X {\n${OTYPE}=\"X\" { draw cross }\n}"};
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.description = Aladin.chaine.getString("SMBINFO");
        this.institute = Aladin.chaine.getString("SMBFROM");
        this.title = Aladin.chaine.getString("SMBTITLE");
        this.verboseDescr = Aladin.chaine.getString("SMBDESC");
        this.info1 = Aladin.chaine.getString("SMBINFO1");
        this.filter = Aladin.chaine.getString("SMBFILTER");
    }

    protected ServerSimbad(Aladin aladin) {
        this.aladin = aladin;
        this.createChaine();
        this.init();
        this.setBackground(Aladin.BLUE);
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        int y = 50;
        int X = 150;
        JPanel tp = new JPanel();
        Dimension d = this.makeTitle(tp, this.title);
        if (this.TESTSERVER) {
            this.testServer.setText("(live Simbad)");
            d.width += 80;
            this.testServer.setSelected(false);
        }
        tp.setBackground(Aladin.BLUE);
        tp.setBounds(235 - d.width / 2, y, d.width, d.height);
        this.add(tp);
        JLabel l = new JLabel(this.info1);
        l.setBounds(90, y += d.height + 10, 400, 20);
        y += 20;
        this.add(l);
        JPanel tPanel = new JPanel();
        tPanel.setBackground(Aladin.BLUE);
        int h = this.makeTargetPanel(tPanel, 0);
        tPanel.setBounds(0, y, XWIDTH, h);
        y += h;
        this.add(tPanel);
        this.modeCoo = 5;
        this.modeRad = 1;
        this.getGluFilters(this.gluTag);
        if (this.filters != null) {
            Filet f = new Filet();
            f.setBounds(40, y += 20, XWIDTH - 60, 5);
            y += 20;
            this.add(f);
            this.filtersChoice = this.createFilterChoice();
            this.filtersChoice.setOpaque(false);
            JLabel pFilter = new JLabel(this.addDot(this.filter));
            pFilter.setFont(Aladin.BOLD);
            pFilter.setBounds(10, y += 10, 150, HAUT);
            this.add(pFilter);
            this.filtersChoice.setBounds(160, y, XWIDTH - 160, HAUT);
            y += HAUT + MARGE;
            this.add(this.filtersChoice);
        }
    }

    @Override
    protected boolean isDiscovery() {
        return true;
    }

    @Override
    protected MyInputStream getMetaData(String target, String radius, StringBuffer infoUrl) {
        try {
            double rm = ServerSimbad.getRM(radius);
            target = this.resolveTarget(target);
            String s = Glu.quote(target) + " " + Glu.quote(rm + "");
            URL u = this.aladin.glu.getURL(this.getTagGlu(false), s);
            if (u == null) {
                return null;
            }
            infoUrl.append(u + "");
            return this.getMetaDataForCat(u);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected int createPlane(String target, String radius, String criteria, String label, String origin) {
        URL u;
        this.defaultCursor();
        double r = ServerSimbad.getRM(radius);
        if (this.maxRadius > 0.0 && r > this.maxRadius) {
            this.ball.setMode(2);
            Aladin.error(this, this.WTOOLARGE + " (>" + Coord.getUnit(this.maxRadius / 60.0) + ")", 1);
            return -1;
        }
        radius = r + "";
        String s = Glu.quote(target) + " " + Glu.quote(radius);
        label = this.getDefaultLabelIfRequired(label, "CDS/Simbad");
        boolean cdstest = false;
        if (criteria != null && criteria.indexOf("live") >= 0 || this.testServer != null && this.testServer.isSelected()) {
            cdstest = true;
        }
        if ((u = this.aladin.glu.getURL(this.getTagGlu(cdstest), s)) == null) {
            this.ball.setMode(2);
            Aladin.error(this, this.WERROR, 1);
            return -1;
        }
        if (!this.verif(8, target, label + " " + radius)) {
            return -1;
        }
        this.aladin.targetHistory.add(target);
        return this.aladin.calque.newPlanCatalog(u, label, target, label + " " + radius, origin, this);
    }

    @Override
    public void submit() {
        String objet = this.getTarget(this.flagVerif);
        if (objet == null) {
            return;
        }
        String r = this.getRadius();
        if (r == null) {
            return;
        }
        double rm = ServerSimbad.getRM(r);
        this.waitCursor();
        String script = "get " + this.aladinLabel + " " + objet + " " + Coord.getUnit(rm / 60.0);
        this.aladin.console.printCommand(script);
        int n = this.createPlane(objet, rm + "", null, null, this.institute);
        if (n != -1) {
            this.aladin.calque.getPlan(n).setBookmarkCode("get " + this.aladinLabel + " $TARGET $RADIUS");
        }
    }
}

