/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import adql.db.DBChecker;
import adql.db.exception.UnresolvedIdentifiersException;
import adql.parser.ADQLParser;
import adql.parser.ParseException;
import adql.parser.TokenMgrError;
import adql.query.ADQLQuery;
import adql.query.ClauseConstraints;
import cds.aladin.Aladin;
import cds.aladin.Constants;
import cds.aladin.CustomListCellRenderer;
import cds.aladin.DynamicTapForm;
import cds.aladin.FilterDocument;
import cds.aladin.Server;
import cds.aladin.TapClient;
import cds.aladin.TapTable;
import cds.aladin.TapTableColumn;
import cds.aladin.Tok;
import cds.aladin.WhereGridConstraint;
import cds.tools.CDSConstants;
import cds.tools.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class ServerObsTap
extends DynamicTapForm
implements ItemListener {
    private static final long serialVersionUID = 8589874284137553948L;
    private static final String[] DATAPRODUCT_TYPES = new String[]{"image", "cube", "spectrum", "sed", "timeseries", "visibility", "event", "measurements"};
    private static String TIPCLICKTOADD;
    public Map<String, String> dataProductTypeParamName = null;
    private static String S_REGION_INCLUDINGPOINT;
    String raColumnName = null;
    String decColumnName = null;
    public static String EXPOSURETIME;
    public static String SPECTRALRESOLUTIONPOWER;
    public static String SPECTRALRANGE;
    public static String TIMERANGE;
    public static String SPATIALRESOLUTION;
    public static String SPECTRALRESOLUTION;
    public static String TIMERESOLUTION;
    public static String FIELDSIZE;
    private static String RANGEQUERY;
    Map<String, Map<String, String>> spatialFieldValueOptions = new HashMap<String, Map<String, String>>();
    Map<String, Map<String, String>> spectralFieldValueOptions = new HashMap<String, Map<String, String>>();
    Map<String, Map<String, String>> timeFieldValueOptions = new HashMap<String, Map<String, String>>();
    JComboBox<String> limit;
    JComboBox selectColumns;
    JComboBox<String> dataProduct_types;
    JComboBox dataProduct_types_andOrOp;
    JComboBox spatial_andOrOp;
    JComboBox spatial_fields;
    JTextField spatial_value;
    JComboBox spectral_andOrOp;
    JComboBox spectral_fields;
    JTextField spectral_value;
    JComboBox time_andOrOp;
    JComboBox time_fields;
    JTextField time_value;
    JComboBox free_andOrOp;
    JComboBox free_fields;
    JTextField free_value;
    public Map<String, List<String>> selectAllOptions = null;
    private JPanel targetPanel;

    public void addOtherParams(String tableName) {
        String min = null;
        String max = null;
        String range = null;
        if (this.spectralFieldValueOptions.get(tableName).containsKey("em_min") && this.spectralFieldValueOptions.get(tableName).containsKey("em_max")) {
            min = this.spectralFieldValueOptions.get(tableName).get("em_min");
            max = this.spectralFieldValueOptions.get(tableName).get("em_max");
            range = min + RANGEQUERY + max;
            this.spectralFieldValueOptions.get(tableName).put(SPECTRALRANGE, range);
        }
        if (this.timeFieldValueOptions.get(tableName).containsKey("t_min") && this.timeFieldValueOptions.get(tableName).containsKey("t_max")) {
            min = this.timeFieldValueOptions.get(tableName).get("t_min");
            max = this.timeFieldValueOptions.get(tableName).get("t_max");
            range = min + RANGEQUERY + max;
            this.timeFieldValueOptions.get(tableName).put(TIMERANGE, range);
        }
    }

    public ServerObsTap(Aladin aladin) {
        super(aladin);
    }

    public void createForm(String tableChoice) {
        this.CLIENTINSTR = Aladin.chaine.getString("TAPOBSCORECLIENTINSTR");
        for (TapTable table : this.tapClient.obscoreTables.values()) {
            this.setObsCore(table);
        }
        DBChecker checker = new DBChecker(this.tapClient.queryCheckerTables);
        this.adqlParser.setQueryChecker(checker);
        this.setBasics();
        JPanel containerPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.setTopPanel(containerPanel, c, this.info1, this.CLIENTINSTR);
        JPanel panelScroll = new JPanel();
        panelScroll.setBackground(this.tapClient.secondColor);
        this.setConstraintsGui(tableChoice, panelScroll);
        panelScroll.setPreferredSize(new Dimension(565, 290));
        JScrollPane scrolley = new JScrollPane(panelScroll);
        scrolley.setPreferredSize(new Dimension(565, 400));
        c.weighty = 0.75;
        c.insets = new Insets(0, -6, 0, 0);
        c.anchor = 18;
        c.fill = 1;
        ++c.gridy;
        containerPanel.add((Component)scrolley, c);
        JPanel linePanel = this.getBottomPanel(true);
        c.weightx = 0.1;
        c.weighty = 0.02;
        c.insets = new Insets(0, -6, 0, 0);
        c.anchor = 18;
        c.fill = 2;
        ++c.gridy;
        containerPanel.add((Component)linePanel, c);
        this.tap = new JTextArea(8, 200);
        this.tap.setFont(Aladin.ITALIC);
        this.tap.setWrapStyleWord(true);
        this.tap.setLineWrap(true);
        this.tap.setEditable(true);
        scrolley = new JScrollPane(this.tap);
        c.weightx = 0.35;
        c.weighty = 0.17;
        c.insets = new Insets(0, 4, 0, 0);
        c.fill = 1;
        ++c.gridy;
        containerPanel.add((Component)scrolley, c);
        this.removeAll();
        this.add(containerPanel);
        this.formLoadStatus = 2;
        this.writeQuery();
    }

    public void setObsCore(TapTable table) {
        String tableName = table.getTable_name();
        Map<String, String> obsCoreColumns = table.obsCoreColumns;
        if (obsCoreColumns != null && obsCoreColumns.size() > 6) {
            StringBuffer statement = null;
            HashMap<String, String> params = new HashMap<String, String>();
            if (this.selectAllOptions == null) {
                this.selectAllOptions = new HashMap<String, List<String>>();
            }
            this.selectAllOptions.put(tableName, new ArrayList());
            this.selectAllOptions.get(tableName).add(" * ");
            if (obsCoreColumns.containsKey("obs_id") && obsCoreColumns.containsKey("ra") && obsCoreColumns.containsKey("dec")) {
                statement = new StringBuffer(obsCoreColumns.get("obs_id"));
                statement.append(",").append(obsCoreColumns.get("ra")).append(",").append(obsCoreColumns.get("dec"));
                this.selectAllOptions.get(tableName).add(statement.toString());
            }
            if (obsCoreColumns.containsKey("access_url") && obsCoreColumns.containsKey("access_format") && obsCoreColumns.containsKey("access_estsize")) {
                statement = new StringBuffer("access_url");
                statement.append(",").append(obsCoreColumns.get("access_format")).append(",").append(obsCoreColumns.get("access_estsize"));
                this.selectAllOptions.get(tableName).add(statement.toString());
            }
            if (obsCoreColumns.get("dataproduct_type") != null) {
                if (this.dataProductTypeParamName == null) {
                    this.dataProductTypeParamName = new HashMap<String, String>();
                }
                this.dataProductTypeParamName.put(tableName, obsCoreColumns.get("dataproduct_type"));
            }
            if (this.spatialFieldValueOptions == null) {
                this.spatialFieldValueOptions = new HashMap<String, Map<String, String>>();
            }
            params.put(FIELDSIZE, "AREA(" + obsCoreColumns.get(FIELDSIZE) + ")");
            params.put(SPATIALRESOLUTION, obsCoreColumns.get(SPATIALRESOLUTION));
            params.put("ra", obsCoreColumns.get("ra"));
            params.put("dec", obsCoreColumns.get("dec"));
            params.values().removeAll(Collections.singleton(null));
            this.spatialFieldValueOptions.put(tableName, params);
            if (this.timeFieldValueOptions == null) {
                this.timeFieldValueOptions = new HashMap<String, Map<String, String>>();
            }
            params = new HashMap();
            params.put("t_min", obsCoreColumns.get("t_min"));
            params.put("t_max", obsCoreColumns.get("t_max"));
            params.put(EXPOSURETIME, obsCoreColumns.get(EXPOSURETIME));
            params.put(TIMERESOLUTION, obsCoreColumns.get(TIMERESOLUTION));
            params.values().removeAll(Collections.singleton(null));
            this.timeFieldValueOptions.put(tableName, params);
            if (this.spectralFieldValueOptions == null) {
                this.spectralFieldValueOptions = new HashMap<String, Map<String, String>>();
            }
            params = new HashMap();
            params.put("em_min", obsCoreColumns.get("em_min"));
            params.put("em_max", obsCoreColumns.get("em_max"));
            params.put(SPECTRALRESOLUTION, obsCoreColumns.get(SPECTRALRESOLUTION));
            params.put(SPECTRALRESOLUTIONPOWER, obsCoreColumns.get(SPECTRALRESOLUTIONPOWER));
            params.values().removeAll(Collections.singleton(null));
            this.spectralFieldValueOptions.put(tableName, params);
            this.addOtherParams(tableName);
        }
    }

    private void setConstraintsGui(String tableChoice, JPanel panelScroll) {
        Vector<TapTableColumn> columns;
        GridBagLayout g = new GridBagLayout();
        panelScroll.setLayout(g);
        GridBagConstraints c = new GridBagConstraints();
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.setBackground(this.tapClient.secondColor);
        JLabel label = new JLabel();
        label.setText("Table:");
        label.setFont(CDSConstants.BOLD);
        panel.add(label);
        Vector<String> tables = new Vector<String>(this.tapClient.obscoreTables.keySet().size());
        tables.addAll(this.tapClient.obscoreTables.keySet());
        this.selectedTableName = tableChoice == null || !tables.contains(tableChoice) ? (String)tables.get(0) : tableChoice;
        Map<String, TapTable> tablesMetaData = this.tapClient.tablesMetaData;
        this.getColumnsToLoad(this.selectedTableName, tablesMetaData);
        this.raColumnName = tablesMetaData.get(this.selectedTableName).getRaColumnName(false);
        this.decColumnName = tablesMetaData.get(this.selectedTableName).getDecColumnName(false);
        this.tablesGui = new JComboBox(tables);
        this.tablesGui.setToolTipText(this.tapClient.tablesMetaData.get(this.selectedTableName).getDescription());
        this.tablesGui.setEditable(true);
        JTextComponent tablesGuiEditor = (JTextComponent)this.tablesGui.getEditor().getEditorComponent();
        try {
            ArrayList<String> keys = new ArrayList<String>();
            keys.addAll(this.tapClient.obscoreTables.keySet());
            tablesGuiEditor.setDocument(new FilterDocument(this, this.tablesGui, keys, this.selectedTableName));
        }
        catch (BadLocationException e) {
            Aladin.error(this, e.getMessage());
            this.showLoadingError();
            return;
        }
        this.tablesGui.setOpaque(false);
        this.tablesGui.setName("table");
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.gridwidth = 4;
        c.gridx = 0;
        c.anchor = 17;
        c.fill = 2;
        panel.add(this.tablesGui);
        panelScroll.add((Component)panel, c);
        panel = new JPanel(new FlowLayout(0));
        panel.setBackground(this.tapClient.secondColor);
        label = new JLabel("Select:");
        label.setFont(CDSConstants.BOLD);
        panel.add(label);
        this.selectColumns = new JComboBox<Object>(this.selectAllOptions.get(this.selectedTableName).toArray());
        this.selectColumns.setPreferredSize(new Dimension(200, Server.HAUT));
        this.selectColumns.setActionCommand("SELECTALL");
        this.selectColumns.addItemListener(this);
        panel.add(this.selectColumns);
        label = new JLabel("Max rows:");
        label.setFont(CDSConstants.BOLD);
        panel.add(label);
        this.limit = new JComboBox<String>(Constants.TAP_REC_LIMIT);
        if (TAPEXDEFAULTMAXROWS != null) {
            if (!TAPEXDEFAULTMAXROWS.isEmpty()) {
                this.limit.setSelectedItem(TAPEXDEFAULTMAXROWS);
            } else {
                this.limit.setSelectedItem("unlimited");
            }
        }
        this.limit.setPreferredSize(new Dimension(80, Server.HAUT));
        this.limit.setOpaque(false);
        this.limit.addItemListener(this);
        panel.add(this.limit);
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.gridwidth = 4;
        c.anchor = 17;
        c.fill = 2;
        panelScroll.add((Component)panel, c);
        JButton add = null;
        if (this.dataProductTypeParamName.get(this.selectedTableName) != null) {
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 1;
            label = new JLabel();
            label.setText("Dataproduct type:");
            label.setFont(CDSConstants.BOLD);
            c.weightx = 0.05;
            panelScroll.add((Component)label, c);
            this.dataProduct_types = new JComboBox<String>(DATAPRODUCT_TYPES);
            c.weightx = 0.87;
            ++c.gridx;
            c.fill = 2;
            panelScroll.add(this.dataProduct_types, c);
            c.weightx = 0.04;
            ++c.gridx;
            this.dataProduct_types_andOrOp = new JComboBox<String>(WhereGridConstraint.andOrOptions);
            panelScroll.add((Component)this.dataProduct_types_andOrOp, c);
            ++c.gridx;
            c.anchor = 17;
            add = new JButton("Add");
            add.setToolTipText("Click to add constraint");
            add.setActionCommand("ADD_DATAPRODUCTTYPE");
            add.addActionListener(this);
            c.weightx = 0.04;
            c.fill = 0;
            panelScroll.add((Component)add, c);
        }
        this.targetPanel = new JPanel();
        this.targetPanel.setBackground(this.tapClient.secondColor);
        this.createTargetPanel(this.targetPanel);
        if (this.raColumnName == null || this.decColumnName == null) {
            this.targetPanel.setVisible(false);
        }
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 4;
        c.fill = 2;
        c.anchor = 17;
        panelScroll.add((Component)this.targetPanel, c);
        if (!this.spatialFieldValueOptions.get(this.selectedTableName).isEmpty()) {
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 1;
            this.spatial_fields = new JComboBox<Object>(this.spatialFieldValueOptions.get(this.selectedTableName).keySet().toArray());
            this.spatial_fields.setFont(CDSConstants.BOLD);
            c.weightx = 0.05;
            panelScroll.add((Component)this.spatial_fields, c);
            this.spatial_value = new JTextField();
            c.weightx = 0.87;
            ++c.gridx;
            c.fill = 2;
            panelScroll.add((Component)this.spatial_value, c);
            c.weightx = 0.04;
            ++c.gridx;
            this.spatial_andOrOp = new JComboBox<String>(WhereGridConstraint.andOrOptions);
            panelScroll.add((Component)this.spatial_andOrOp, c);
            ++c.gridx;
            c.gridwidth = 1;
            c.anchor = 17;
            add = new JButton("Add");
            add.setActionCommand("ADD_SPATIALCONSTRAINT");
            add.setToolTipText("Click to add constraint");
            add.addActionListener(this);
            c.weightx = 0.04;
            c.fill = 0;
            panelScroll.add((Component)add, c);
        }
        if (!this.spectralFieldValueOptions.get(this.selectedTableName).isEmpty()) {
            ++c.gridy;
            c.gridwidth = 1;
            c.gridx = 0;
            this.spectral_fields = new JComboBox<Object>(this.spectralFieldValueOptions.get(this.selectedTableName).keySet().toArray());
            this.spectral_fields.setFont(CDSConstants.BOLD);
            c.weightx = 0.05;
            panelScroll.add((Component)this.spectral_fields, c);
            this.spectral_value = new JTextField();
            c.weightx = 0.87;
            ++c.gridx;
            c.fill = 2;
            panelScroll.add((Component)this.spectral_value, c);
            c.weightx = 0.04;
            ++c.gridx;
            this.spectral_andOrOp = new JComboBox<String>(WhereGridConstraint.andOrOptions);
            panelScroll.add((Component)this.spectral_andOrOp, c);
            c.gridwidth = 1;
            ++c.gridx;
            c.anchor = 17;
            add = new JButton("Add");
            add.setActionCommand("ADD_SPECTRALCONSTRAINT");
            add.setToolTipText("Click to add constraint");
            add.addActionListener(this);
            c.weightx = 0.04;
            c.fill = 0;
            panelScroll.add((Component)add, c);
        }
        if (!this.timeFieldValueOptions.get(this.selectedTableName).isEmpty()) {
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 1;
            this.time_fields = new JComboBox<Object>(this.timeFieldValueOptions.get(this.selectedTableName).keySet().toArray());
            this.time_fields.setFont(CDSConstants.BOLD);
            c.weightx = 0.05;
            panelScroll.add((Component)this.time_fields, c);
            this.time_value = new JTextField();
            c.weightx = 0.87;
            ++c.gridx;
            c.fill = 2;
            panelScroll.add((Component)this.time_value, c);
            c.weightx = 0.04;
            ++c.gridx;
            this.time_andOrOp = new JComboBox<String>(WhereGridConstraint.andOrOptions);
            panelScroll.add((Component)this.time_andOrOp, c);
            c.gridwidth = 1;
            c.anchor = 17;
            add = new JButton("Add");
            add.setActionCommand("ADD_TIMECONSTRAINT");
            add.setToolTipText("Click to add constraint");
            add.addActionListener(this);
            c.weightx = 0.04;
            ++c.gridx;
            c.fill = 0;
            panelScroll.add((Component)add, c);
        }
        if ((columns = this.tapClient.obscoreTables.get(this.selectedTableName).getColumns()) != null && !columns.isEmpty()) {
            ++c.gridy;
            c.gridx = 0;
            c.gridwidth = 1;
            Vector<TapTableColumn> model = new Vector<TapTableColumn>();
            model.addAll(columns);
            this.free_fields = new JComboBox(model);
            this.free_fields.setRenderer(new CustomListCellRenderer());
            this.free_fields.setSize(this.free_fields.getWidth(), Server.HAUT);
            this.free_fields.setFont(CDSConstants.BOLD);
            c.weightx = 0.05;
            panelScroll.add((Component)this.free_fields, c);
            this.free_value = new JTextField();
            c.weightx = 0.87;
            ++c.gridx;
            c.fill = 2;
            panelScroll.add((Component)this.free_value, c);
            c.weightx = 0.04;
            ++c.gridx;
            this.free_andOrOp = new JComboBox<String>(WhereGridConstraint.andOrOptions);
            panelScroll.add((Component)this.free_andOrOp, c);
            c.gridwidth = 1;
            c.anchor = 17;
            add = new JButton("Add");
            add.setActionCommand("ADD_FREECONSTRAINT");
            add.setToolTipText("Click to add constraint");
            add.addActionListener(this);
            c.weightx = 0.04;
            ++c.gridx;
            c.fill = 0;
            panelScroll.add((Component)add, c);
        }
    }

    @Override
    void createFormDefault() {
        this.createForm(null);
    }

    @Override
    public void changeTableSelection(String tableChoice) {
        this.waitCursor();
        Map<String, TapTable> tablesMetaData = this.tapClient.tablesMetaData;
        Vector<TapTableColumn> columnNames = this.setTableGetColumnsToLoad(tableChoice, tablesMetaData);
        if (columnNames == null) {
            return;
        }
        this.raColumnName = tablesMetaData.get(this.selectedTableName).getRaColumnName(false);
        this.decColumnName = tablesMetaData.get(this.selectedTableName).getDecColumnName(false);
        if (Aladin.levelTrace >= 3) {
            System.out.println("ra and dec: " + (this.raColumnName != null && this.decColumnName != null));
        }
        if (Aladin.levelTrace >= 3) {
            System.out.println("and target panel: " + this.target);
        }
        if (this.raColumnName != null && this.decColumnName != null) {
            if (Aladin.levelTrace >= 3) {
                System.out.println("target: " + this.target);
            }
            if (this.target == null) {
                this.createTargetPanel(this.targetPanel);
            }
            this.targetPanel.setVisible(true);
        } else if (this.target != null) {
            this.targetPanel.setVisible(false);
        }
        this.selectColumns.removeAllItems();
        DefaultComboBoxModel<Object> items = new DefaultComboBoxModel<Object>(this.selectAllOptions.get(this.selectedTableName).toArray());
        this.selectColumns.setModel(items);
        this.resetFields();
        this.ball.setMode(0);
        this.formLoadStatus = 2;
        this.writeQuery();
        this.revalidate();
        this.repaint();
        this.defaultCursor();
    }

    @Override
    protected void clear() {
        if (this.sync_async != null) {
            this.sync_async.setSelectedIndex(0);
        }
        this.resetFields();
        super.clear();
        this.revalidate();
        this.repaint();
    }

    protected void resetFields() {
        Vector<TapTableColumn> columns;
        this.selectColumns.setSelectedIndex(0);
        this.limit.setSelectedIndex(0);
        if (this.dataProductTypeParamName.get(this.selectedTableName) != null) {
            this.dataProduct_types_andOrOp.setSelectedIndex(0);
            this.dataProduct_types.setSelectedIndex(0);
        }
        if (!this.spatialFieldValueOptions.get(this.selectedTableName).isEmpty()) {
            this.spatial_andOrOp.setSelectedIndex(0);
            this.spatial_fields.removeAllItems();
            this.spatial_fields.setModel(new DefaultComboBoxModel<Object>(this.spatialFieldValueOptions.get(this.selectedTableName).keySet().toArray()));
            this.spatial_fields.setSelectedIndex(0);
            this.spatial_value.setText("");
            this.spatial_value.setVisible(true);
        } else {
            this.spatial_value.setVisible(false);
        }
        if (!this.spectralFieldValueOptions.get(this.selectedTableName).isEmpty()) {
            this.spectral_andOrOp.setSelectedIndex(0);
            this.spectral_fields.removeAllItems();
            this.spectral_fields.setModel(new DefaultComboBoxModel<Object>(this.spectralFieldValueOptions.get(this.selectedTableName).keySet().toArray()));
            this.spectral_fields.setSelectedIndex(0);
            this.spectral_value.setText("");
        }
        if (!this.timeFieldValueOptions.get(this.selectedTableName).isEmpty()) {
            this.time_andOrOp.setSelectedIndex(0);
            this.time_fields.removeAllItems();
            this.time_fields.setModel(new DefaultComboBoxModel<Object>(this.timeFieldValueOptions.get(this.selectedTableName).keySet().toArray()));
            this.time_fields.setSelectedIndex(0);
            this.time_value.setText("");
        }
        if ((columns = this.tapClient.obscoreTables.get(this.selectedTableName).getColumns()) != null && !columns.isEmpty() && this.free_andOrOp != null) {
            this.free_andOrOp.setSelectedIndex(0);
            this.free_fields.removeAllItems();
            Vector<TapTableColumn> model = new Vector<TapTableColumn>();
            model.addAll(columns);
            DefaultComboBoxModel combo = new DefaultComboBoxModel(model);
            this.free_fields.setModel(combo);
            this.free_value.setText("");
        }
        if (this.circleOrSquare != null) {
            this.circleOrSquare.setSelectedIndex(0);
        }
        if (this.tap != null) {
            this.tap.setText("");
        }
    }

    @Override
    protected void reset() {
        this.createFormDefault();
        this.resetFields();
        super.reset();
        this.writeQuery();
        this.revalidate();
        this.repaint();
    }

    public void writeQuery() {
        try {
            StringBuffer queryFromGui = new StringBuffer("SELECT");
            if (!this.limit.getSelectedItem().equals("unlimited")) {
                queryFromGui.append(" TOP ").append(this.limit.getSelectedItem());
            }
            queryFromGui.append(" ").append(this.selectColumns.getSelectedItem());
            queryFromGui = new StringBuffer(queryFromGui.toString().trim().replaceAll(",$", ""));
            queryFromGui.append(" FROM ").append(TapTable.getQueryPart(this.selectedTableName, true)).append(" ");
            this.tap.setText(queryFromGui.toString());
        }
        catch (Exception e) {
            Aladin.error(this, e.getMessage());
            this.ball.setMode(3);
        }
    }

    public String getRangeDefaultString(String low, String high) {
        StringBuffer result = new StringBuffer();
        low = TapTable.getQueryPart(low, false);
        high = TapTable.getQueryPart(high, false);
        result.append(low).append(" IS NOT NULL AND ").append(high).append(" IS NOT NULL ");
        return result.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent arg0) {
        super.actionPerformed(arg0);
        Object source = arg0.getSource();
        String action = arg0.getActionCommand();
        if (!(source instanceof JButton)) return;
        String defaultValue = "IS NOT NULL";
        boolean inRange = false;
        if (action.equals("ADD_DATAPRODUCTTYPE")) {
            this.appendConstraint(this.dataProduct_types_andOrOp, new String(this.dataProductTypeParamName.get(this.selectedTableName)), inRange, false, (String)this.dataProduct_types.getSelectedItem(), "IS NOT NULL");
            return;
        }
        if (action.equals("ADD_SPATIALCONSTRAINT")) {
            String constraintSelected = (String)this.spatial_fields.getSelectedItem();
            constraintSelected = this.spatialFieldValueOptions.get(this.selectedTableName).get(constraintSelected);
            if (constraintSelected == null) return;
            constraintSelected = TapTable.getQueryPart(constraintSelected, false);
            this.appendConstraint(this.spatial_andOrOp, constraintSelected, inRange, true, this.spatial_value.getText(), "IS NOT NULL");
            return;
        }
        if (action.equals("ADD_SPECTRALCONSTRAINT")) {
            try {
                String constraintSelected = (String)this.spectral_fields.getSelectedItem();
                boolean processToMeters = false;
                if (constraintSelected.equals(SPECTRALRANGE)) {
                    inRange = true;
                    processToMeters = true;
                    defaultValue = this.getRangeDefaultString(this.spectralFieldValueOptions.get(this.selectedTableName).get("em_min"), this.spectralFieldValueOptions.get(this.selectedTableName).get("em_max"));
                } else if (constraintSelected.equals("em_min") || constraintSelected.equals("em_max")) {
                    processToMeters = true;
                }
                constraintSelected = this.spectralFieldValueOptions.get(this.selectedTableName).get(constraintSelected);
                if (constraintSelected == null) return;
                String valueInProcess = this.spectral_value.getText();
                if (processToMeters && !valueInProcess.trim().isEmpty()) {
                    StringBuffer mText = this.processSpectralBand(false, valueInProcess.trim(), null);
                    valueInProcess = mText.toString();
                }
                if (!inRange) {
                    constraintSelected = TapTable.getQueryPart(constraintSelected, false);
                }
                this.appendConstraint(this.spectral_andOrOp, constraintSelected, inRange, true, valueInProcess, defaultValue);
                return;
            }
            catch (NumberFormatException e) {
                Aladin.error(this, "Error! " + e.getMessage());
                this.ball.setMode(3);
                return;
            }
            catch (Exception e) {
                Aladin.error(this, "Error! " + e.getMessage());
                this.ball.setMode(3);
            }
            return;
        }
        if (action.equals("ADD_TIMECONSTRAINT")) {
            try {
                StringBuffer mjdText;
                boolean processToMjd = false;
                String constraintSelected = (String)this.time_fields.getSelectedItem();
                if (constraintSelected.equals(TIMERANGE)) {
                    inRange = true;
                    processToMjd = true;
                    defaultValue = this.getRangeDefaultString(this.timeFieldValueOptions.get(this.selectedTableName).get("t_min"), this.timeFieldValueOptions.get(this.selectedTableName).get("t_max"));
                } else if (constraintSelected.equals("t_min") || constraintSelected.equals("t_max")) {
                    processToMjd = true;
                }
                constraintSelected = this.timeFieldValueOptions.get(this.selectedTableName).get(constraintSelected);
                if (constraintSelected == null) return;
                String valueInProcess = this.time_value.getText();
                if (processToMjd && (mjdText = this.setDateInMJDFormat(false, valueInProcess, null, " ")) != null) {
                    valueInProcess = mjdText.toString();
                }
                if (!inRange) {
                    constraintSelected = TapTable.getQueryPart(constraintSelected, false);
                }
                this.appendConstraint(this.time_andOrOp, constraintSelected, inRange, true, valueInProcess, defaultValue);
                return;
            }
            catch (Exception e) {
                Aladin.error(this, "Error! " + e.getMessage());
                this.ball.setMode(3);
                return;
            }
        }
        if (action.equals("ADD_FREECONSTRAINT")) {
            TapTableColumn columnSelected = (TapTableColumn)this.free_fields.getSelectedItem();
            boolean processAsNumber = true;
            if (columnSelected == null) return;
            if (columnSelected.getColumn_name() == null || columnSelected.getColumn_name().isEmpty()) return;
            String dataType = columnSelected.getDatatype();
            if (dataType != null && (dataType.toUpperCase().contains("VARCHAR") || dataType.toUpperCase().contains("CHAR"))) {
                processAsNumber = false;
            }
            String constraintSelected = columnSelected.getColumnNameForQuery();
            this.appendConstraint(this.free_andOrOp, constraintSelected, inRange, processAsNumber, this.free_value.getText(), defaultValue);
            return;
        }
        if (action.equals("ADDPOSCONSTRAINT")) {
            String objet = null;
            if (this.target != null) {
                try {
                    objet = this.resolveQueryField();
                    if (objet == null) {
                        throw new Exception(this.UNKNOWNOBJ);
                    }
                    this.ball.setMode(1);
                }
                catch (Exception e1) {
                    Aladin.error(this, e1.getMessage());
                    this.ball.setMode(3);
                    return;
                }
            }
            if (objet.trim().equals("--   --")) {
                Aladin.error(this, TapClient.TARGETERROR);
                this.ball.setMode(3);
                return;
            }
            StringBuffer whereClause = new StringBuffer();
            String raColumNameForQuery = TapTable.getQueryPart(this.raColumnName, false);
            String decColumNameForQuery = TapTable.getQueryPart(this.decColumnName, false);
            whereClause.append(String.format("CONTAINS(POINT('ICRS', %1$s%2$s, %1$s%3$s), CIRCLE('ICRS', %4$s, %5$s, %6$s)) = 1", "", raColumNameForQuery, decColumNameForQuery, Util.myRound(this.coo[0].getText(), 5), Util.myRound(this.coo[1].getText(), 5), Util.myRound(this.rad[0].getText(), 5))).append(" ");
            this.appendConstraint(this.free_andOrOp, null, true, false, null, whereClause.toString());
            return;
        }
        if (action.equals("CHECKQUERY")) {
            this.checkQueryFlagMessage();
            return;
        } else {
            if (!action.equals("WRITEQUERY")) return;
            this.writeQuery();
        }
    }

    public void appendConstraint(JComboBox andOrOp, String constraint, boolean inRange, boolean processAsNumber, String value, String defaultValue) {
        ADQLQuery query = null;
        try {
            if (this.tap.getText().isEmpty()) {
                this.writeQuery();
            }
            query = this.checkQuery(null);
        }
        catch (UnresolvedIdentifiersException uie) {
            Iterator<ParseException> it = uie.getErrors();
            ParseException ex = null;
            while (it.hasNext()) {
                ex = it.next();
                this.highlightQueryError(this.tap.getHighlighter(), ex);
            }
            try {
                query = this.checkSyntax();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (query != null) {
            ClauseConstraints whereConstraints = query.getWhere();
            boolean firstConstraint = false;
            StringBuffer queryInput = new StringBuffer(this.tap.getText().trim());
            if (whereConstraints == null || whereConstraints.size() == 0) {
                queryInput.append(" ").append(" WHERE");
                firstConstraint = true;
            }
            if (!firstConstraint) {
                queryInput.append(" ");
                if (andOrOp == null) {
                    queryInput.append("AND");
                } else {
                    queryInput.append(andOrOp.getSelectedItem());
                }
                queryInput.append(" ");
            }
            String processedInput = null;
            if (value == null || value.isEmpty()) {
                processedInput = defaultValue;
            } else if (processAsNumber) {
                if (inRange) {
                    processedInput = TapClient.getRangeInput(value, constraint);
                    if (processedInput == null || processedInput.isEmpty()) {
                        Aladin.error(this, NORANGEERRORMESSAGE);
                        this.ball.setMode(3);
                        return;
                    }
                } else {
                    processedInput = TapClient.getRangeInput(value, null);
                }
                if (processedInput == null || processedInput.isEmpty()) {
                    processedInput = TapClient.isInValidOperatorNumber(this, value, true);
                }
            } else {
                processedInput = TapClient.getStringInput(value, true);
                if (processedInput == null || processedInput.isEmpty()) {
                    Aladin.error(this, value + " is invalid input, please check");
                    this.ball.setMode(3);
                    return;
                }
            }
            if (processedInput != null && !processedInput.isEmpty()) {
                if (!inRange && constraint != null) {
                    processedInput = constraint + " " + processedInput;
                }
                queryInput.append(" ").append(processedInput).append(" ");
                this.tap.setText(queryInput.toString());
                this.ball.setMode(1);
            }
        }
    }

    @Override
    public void submit() {
        if (this.sync_async != null && this.tap != null) {
            boolean sync = this.sync_async.getSelectedItem().equals("SYNC");
            this.submitTapServerRequest(sync, this.tapClient.tapLabel, this.tapClient.tapBaseUrl, this.tap.getText());
            this.aladin.console.printCommand("get TAP(" + Tok.quote(this.tapClient.tapLabel) + "," + Tok.quote(this.tap.getText()) + ")");
        }
    }

    public ADQLQuery checkSyntax() throws Exception {
        if (this.tap.getText().isEmpty()) {
            throw new Exception(this.CHECKQUERY_ISBLANK);
        }
        ADQLQuery query = null;
        ADQLParser syntaxParser = new ADQLParser();
        try {
            query = syntaxParser.parseQuery(this.tap.getText());
        }
        catch (UnresolvedIdentifiersException ie) {
            Aladin.trace(3, "Number of errors in the query:" + ie.getNbErrors());
            throw ie;
        }
        catch (ParseException pe) {
            throw pe;
        }
        catch (TokenMgrError e) {
            throw e;
        }
        return query;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.writeQuery();
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.description = Aladin.chaine.getString("TAPFORMINFO");
        this.title = Aladin.chaine.getString("TAPFORMTITLE");
        this.verboseDescr = this.loadedServerDescription = Aladin.chaine.getString("TAPOBSFORMDESC");
        TIPCLICKTOADD = Aladin.chaine.getString("TIPCLICKTOADD");
        NORANGEERRORMESSAGE = Aladin.chaine.getString("NORANGEERRORMESSAGE");
    }

    static {
        S_REGION_INCLUDINGPOINT = "s_region containing point";
        EXPOSURETIME = "Exposure time";
        SPECTRALRESOLUTIONPOWER = "Spectral resolving power";
        SPECTRALRANGE = "Spectral range";
        TIMERANGE = "Time range";
        SPATIALRESOLUTION = "Spatial resolution";
        SPECTRALRESOLUTION = "Spectral resolution";
        TIMERESOLUTION = "Temporal resolution";
        FIELDSIZE = "Field size";
        RANGEQUERY = " >= ${range1} AND ${range2} <= ";
    }
}

