/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanMoc;
import cds.aladin.Server;
import cds.moc.SMoc;
import cds.tools.MultiPartPostOutputStream;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileOutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ServerMocQuery
extends Server {
    private static String[] LARGE_CATS = new String[]{"2MASS", "CMC14", "UCAC3", "UCAC4", "2MASS6X", "SDSS8", "USNOB1", "WISE_ALLSKY", "DENIS", "GLIMPSE", "GSC23", "NOMAD", "PPMX", "PPMXL", "TYCHO2", "SIMBAD", "UKIDSS_DR8_LAS", "UKIDSS_DR6_GPS"};
    protected String baseUrl;
    protected String title1;
    protected String title2;
    private JComboBox comboLocalPlane;
    private JComboBox comboCat;
    private JTextField textCat;
    private JComboBox comboMaxNbRows;
    private Plan dedicatedLocalPlane = null;
    private String catName = null;
    protected String planName = null;
    private String limit = null;

    protected void init() {
        this.type = 2;
        this.title = "MOC query";
        this.title1 = "Choose a MOC";
        this.title2 = "Catalog to query";
        this.aladinLabel = "MOC";
        this.baseUrl = "http://cdsxmatch.u-strasbg.fr/QueryCat/QueryCat";
    }

    @Override
    protected void createChaine() {
        super.createChaine();
        this.description = "Query by MOC";
    }

    protected ServerMocQuery(Aladin aladin) {
        this.aladin = aladin;
        this.createChaine();
        this.init();
        this.setBackground(Aladin.BLUE);
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        int y = 50;
        int X = 150;
        JPanel tp = new JPanel();
        Dimension d = this.makeTitle(tp, this.title);
        tp.setBackground(Aladin.BLUE);
        tp.setBounds(235 - d.width / 2, y, d.width, d.height);
        this.add(tp);
        JLabel l = new JLabel(this.description);
        l.setBounds(90, y += d.height + 10, 400, 20);
        this.add(l);
        JLabel pTitre = new JLabel(this.title1);
        pTitre.setFont(Aladin.BOLD);
        pTitre.setBounds(10, y += 20, 150, HAUT);
        this.add(pTitre);
        this.comboLocalPlane = new JComboBox();
        this.comboLocalPlane.setBounds(160, y, XWIDTH - 160, HAUT);
        this.add(this.comboLocalPlane);
        pTitre = new JLabel(this.title2);
        pTitre.setFont(Aladin.BOLD);
        pTitre.setBounds(10, y += HAUT + MARGE, 150, HAUT);
        this.add(pTitre);
        pTitre = new JLabel("Choose in list");
        pTitre.setFont(Aladin.ITALIC);
        pTitre.setBounds(10, y += HAUT + MARGE, 150, HAUT);
        this.add(pTitre);
        this.comboCat = new JComboBox();
        this.comboCat.addItem("---");
        Arrays.sort(LARGE_CATS);
        for (String cat : LARGE_CATS) {
            this.comboCat.addItem(cat);
        }
        this.comboCat.setBounds(160, y, XWIDTH - 160, HAUT);
        this.add(this.comboCat);
        pTitre = new JLabel("Or enter a VizieR table ID");
        pTitre.setFont(Aladin.ITALIC);
        pTitre.setBounds(10, y += HAUT + MARGE, 150, HAUT);
        this.add(pTitre);
        this.textCat = new JTextField();
        this.textCat.setBounds(160, y, XWIDTH - 160, HAUT);
        y += HAUT + MARGE;
        this.add(this.textCat);
        this.comboCat.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getItem().equals("---")) {
                    ServerMocQuery.this.textCat.setEnabled(true);
                } else {
                    ServerMocQuery.this.textCat.setEnabled(false);
                    ServerMocQuery.this.textCat.setText("");
                }
            }
        });
        pTitre = new JLabel("Max nb of rows");
        pTitre.setFont(Aladin.BOLD);
        pTitre.setBounds(10, y, 150, HAUT);
        this.add(pTitre);
        this.comboMaxNbRows = new JComboBox();
        this.comboMaxNbRows.addItem("10,000");
        this.comboMaxNbRows.addItem("50,000");
        this.comboMaxNbRows.addItem("100,000");
        this.comboMaxNbRows.addItem("unlimited");
        this.comboMaxNbRows.setBounds(160, y, XWIDTH - 160, HAUT);
        y += HAUT + MARGE;
        this.add(this.comboMaxNbRows);
    }

    @Override
    protected void adjustInputChoice(JComboBox c, Vector v, int defaut) {
        int i = c.getSelectedIndex();
        String s = i >= 0 ? (String)c.getItemAt(i) : null;
        c.removeAllItems();
        c.addItem(this.NOINPUTITEM);
        if (v != null) {
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                c.addItem(((Plan)e.nextElement()).label);
            }
        }
        if (defaut > 0) {
            c.setSelectedIndex(defaut);
        } else if (s == null || s.equals(this.NOINPUTITEM)) {
            c.setSelectedIndex(0);
        } else {
            c.setSelectedItem(s);
        }
    }

    protected Vector<Plan> getPlans() {
        return this.aladin.calque.getPlans(PlanCatalog.class);
    }

    @Override
    public void setVisible(boolean flag) {
        if (flag) {
            Vector<Plan> plans = this.getPlans();
            this.comboLocalPlane.removeAllItems();
            if (plans != null) {
                Iterator<Plan> it = plans.iterator();
                while (it.hasNext()) {
                    this.comboLocalPlane.addItem(it.next());
                }
            }
        }
        super.setVisible(flag);
    }

    @Override
    protected boolean isDiscovery() {
        return false;
    }

    protected void setPlan(Plan plan) {
        this.dedicatedLocalPlane = plan;
    }

    protected Plan getPlan() {
        if (this.dedicatedLocalPlane != null) {
            return this.dedicatedLocalPlane;
        }
        return (Plan)this.comboLocalPlane.getSelectedItem();
    }

    protected void setCatName(String cat) {
        this.catName = cat;
    }

    protected String getCatName() {
        if (this.catName != null) {
            return this.catName;
        }
        if (this.comboCat.getSelectedItem().equals("---")) {
            return this.textCat.getText().trim();
        }
        return this.comboCat.getSelectedItem().toString();
    }

    protected void setPlanName(String label) {
        this.planName = label;
    }

    protected String getPlanName() {
        String s = this.planName == null ? this.getCatName() : this.planName;
        return s + " by MOC";
    }

    protected void setLimit(String limit) {
        this.limit = limit;
    }

    protected String getLimit() {
        if (this.limit != null) {
            return this.limit;
        }
        return this.comboMaxNbRows.getSelectedItem().toString();
    }

    private void submitThread() {
        URL url;
        this.waitCursor();
        try {
            url = new URL(this.baseUrl);
            Aladin.trace(4, "ServerXQuery.submitThread: url=" + url);
        }
        catch (MalformedURLException e) {
            this.defaultCursor();
            e.printStackTrace();
            return;
        }
        Plan localPlan = this.getPlan();
        if (localPlan == null) {
            Aladin.error("No local plane selected !");
            return;
        }
        Aladin.trace(4, "Sending local data...");
        try {
            this.log();
            MultiPartPostOutputStream.setTmpDir(Aladin.CACHEDIR);
            String boundary = MultiPartPostOutputStream.createBoundary();
            HttpURLConnection urlConn = (HttpURLConnection)MultiPartPostOutputStream.createConnection(url);
            urlConn.setRequestProperty("Accept", "*/*");
            urlConn.setRequestProperty("Content-Type", MultiPartPostOutputStream.getContentType(boundary));
            urlConn.setRequestProperty("Connection", "Keep-Alive");
            urlConn.setRequestProperty("Cache-Control", "no-cache");
            MultiPartPostOutputStream out = new MultiPartPostOutputStream(urlConn.getOutputStream(), boundary);
            this.addParameter(out);
            this.addUpload(out, localPlan);
            out.close();
            Aladin.trace(4, "Local data file sent");
            this.aladin.calque.newPlanCatalog(urlConn, this.getPlanName());
        }
        catch (Exception e) {
            this.defaultCursor();
            e.printStackTrace();
            Aladin.error("An error occured while contacting the remote service");
            return;
        }
        this.defaultCursor();
    }

    protected void log() {
        this.aladin.log("MocQuery", this.getCatName());
    }

    protected void addParameter(MultiPartPostOutputStream out) throws Exception {
        String catName = this.getCatName();
        out.writeField("catName", catName);
        out.writeField("mode", "mocfile");
        out.writeField("format", "votable");
        String limit = this.getLimit();
        if (!limit.equals("unlimited")) {
            limit = limit.replaceAll(",", "");
            out.writeField("limit", limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addUpload(MultiPartPostOutputStream out, Plan plan) throws Exception {
        SMoc hpxMoc = ((PlanMoc)plan).getSpaceMoc();
        File tmp = File.createTempFile("tmp", "fits");
        tmp.deleteOnExit();
        FileOutputStream fo = new FileOutputStream(tmp);
        try {
            hpxMoc.writeFits(fo);
        }
        finally {
            try {
                fo.close();
            }
            catch (Exception e) {}
        }
        out.writeFile("mocfile", null, tmp, false);
    }

    @Override
    public void submit() {
        new Thread(){

            @Override
            public void run() {
                ServerMocQuery.this.submitThread();
            }
        }.start();
    }
}

