/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import adql.db.exception.UnresolvedIdentifiersException;
import adql.parser.ADQLParser;
import adql.parser.ParseException;
import adql.query.ADQLQuery;
import cds.aladin.Aladin;
import cds.aladin.BasicTree;
import cds.aladin.Constants;
import cds.aladin.Coord;
import cds.aladin.Glu;
import cds.aladin.GluAdqlTemplate;
import cds.aladin.MetaDataTree;
import cds.aladin.MyInputStream;
import cds.aladin.Plan;
import cds.aladin.ResourceNode;
import cds.aladin.SIAPruner;
import cds.aladin.Server;
import cds.aladin.ServerFile;
import cds.aladin.ServerTap;
import cds.aladin.Source;
import cds.aladin.TapClient;
import cds.aladin.TapManager;
import cds.aladin.Tok;
import cds.aladin.TreeBuilder;
import cds.aladin.UWSFacade;
import cds.aladin.stc.STCObj;
import cds.aladin.stc.STCStringParser;
import cds.moc.SMoc;
import cds.tools.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.RejectedExecutionException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ServerGlu
extends Server
implements Runnable {
    String HELP;
    String ERR;
    private boolean flagSIAIDHA = false;
    private boolean flagTAP = false;
    private boolean flagTAPV2 = false;
    private boolean flagHiPS = false;
    int fmt;
    String info1;
    String filter;
    String PARSEMJDFIELDHINT;
    String GENERICERROR;
    String CHECKQUERYTOOLTIP;
    String SYNCASYNCTOOLTIP;
    String SYNCASYNCSELECTIONCHANGE;
    String SHOWASYNCTOOLTIP;
    String ASYNCTOOLTIP;
    String system;
    String dir;
    StringBuffer record;
    Vector vc;
    String planeLabel;
    String[] vD = null;
    int baseUrlIndex;
    Thread thread;
    protected int lastY;
    HashMap<Integer, String[]> rangeValues = new HashMap();
    private Source dataLinkSource = null;
    private SMoc posBounds = null;
    private String boundaryAreaStcs = null;
    private Map<String, Vector> tapTableMapping = new HashMap<String, Vector>();
    private Map<String, GluAdqlTemplate> gluAdqlQueryTemplates;
    private String currentSelectedTapTable;
    private Hashtable<String, String> adqlFunc = null;
    private Hashtable<String, String> adqlFuncParams = null;
    JComboBox sync_async;
    String LISTDELIMITER = " ";
    private boolean cleanupFov;
    int showSyncAsync = -1;
    protected Plan lastPlan = null;
    URL uT;
    String posT;
    private boolean majChoiceSize = true;
    private int maxChoiceWidth = XWIDTH - 100;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.info1 = Aladin.chaine.getString("GLUINFO1");
        this.filter = Aladin.chaine.getString("SMBFILTER");
        this.HELP = Aladin.chaine.getString("GLUHELP");
        this.ERR = Aladin.chaine.getString("GLUERR");
        this.PARSEMJDFIELDHINT = Aladin.chaine.getString("PARSEMJDFIELDHINT");
        this.GENERICERROR = Aladin.chaine.getString("GENERICERROR");
        this.CHECKQUERYTOOLTIP = Aladin.chaine.getString("CHECKQUERYTOOLTIP");
        this.SYNCASYNCTOOLTIP = Aladin.chaine.getString("SYNCASYNCTOOLTIP");
        this.SHOWASYNCTOOLTIP = Aladin.chaine.getString("SHOWASYNCTOOLTIP");
        this.SYNCASYNCSELECTIONCHANGE = Aladin.chaine.getString("SYNCASYNCSELECTIONCHANGE");
        this.ASYNCTOOLTIP = Aladin.chaine.getString("ASYNCTOOLTIP");
    }

    protected ServerGlu(Aladin aladin, String actionName, String description, String verboseDescr, String aladinMenu, String aladinMenuNumber, String aladinLabel, String planeLabel, String docUser, String[] paramDescription, String[] paramDataType, String[] paramValue, String[][] paramRange, String resultDataType, int showSyncAsync, String institute, String[] aladinFilter, String aladinLogo, String dir, String system, StringBuffer record, String aladinProtocol, String[] tapTables, GluAdqlTemplate gluAdqlTemplate, TapClient tapClient, boolean flagTapUpload) {
        JPanel optionsPanel;
        this.aladin = aladin;
        this.createChaine();
        this.setBackground(Aladin.BLUE);
        this.record = record;
        this.gluTag = actionName;
        this.aladinLogo = aladinLogo;
        this.aladinLabel = aladinLabel != null ? aladinLabel : (description != null ? description : actionName);
        this.description = description;
        this.verboseDescr = verboseDescr;
        this.aladinMenu = aladinMenu;
        this.institute = institute;
        this.planeLabel = planeLabel;
        this.docUser = docUser;
        this.ordre = aladinMenuNumber;
        this.system = system;
        this.dir = dir;
        JScrollPane sc = null;
        if (aladinMenu != null && aladinMenu.equals("IVOA...")) {
            this.HIDDEN = true;
        }
        this.type = 1;
        if (resultDataType != null) {
            if (resultDataType.indexOf("ssa") >= 0) {
                this.type = 4;
            } else if (resultDataType.indexOf("moc") >= 0) {
                this.type = 32;
            } else if (resultDataType.indexOf("x-votable+xml") >= 0) {
                this.type = 2;
            } else if (resultDataType.indexOf("application") >= 0) {
                this.type = resultDataType.indexOf("image") > 0 ? 16 : 8;
            } else if (resultDataType.indexOf("text") >= 0 || resultDataType.indexOf("txt") >= 0 || resultDataType.indexOf("tsv") >= 0 || resultDataType.indexOf("csv") >= 0 || resultDataType.indexOf("xml") >= 0) {
                this.type = 2;
            }
        }
        this.flagSIAIDHA = resultDataType != null && (resultDataType.indexOf("sia") >= 0 || resultDataType.indexOf("idha") >= 0 || resultDataType.indexOf("ssa") >= 0);
        this.flagTAP = aladinProtocol != null && Util.indexOfIgnoreCase(aladinProtocol, "tap") == 0;
        boolean bl = this.flagTAPV2 = aladinProtocol != null && Util.indexOfIgnoreCase(aladinProtocol, "tapv1") == 0;
        if (this.flagSIAIDHA && this.type != 4) {
            this.type = 1;
        }
        this.DISCOVERY = this.flagSIAIDHA || this.type == 4 || this.type == 2;
        this.fmt = this.getFmt(resultDataType);
        this.showSyncAsync = showSyncAsync;
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        boolean flagInfo = true;
        int y = HEIGHT / 2 - (paramDescription.length * 35 + 50 + 60 + (docUser != null ? 30 : 0) + (this.flagSIAIDHA ? 180 : 0)) / 2;
        if (y < 10) {
            y = 5;
            flagInfo = false;
        }
        if (this.flagTAPV2) {
            this.LISTDELIMITER = ",";
            this.tapClient = tapClient;
            this.tapClient.serverGlu = this;
            this.gluAdqlQueryTemplates = new HashMap<String, GluAdqlTemplate>();
            for (int i = 0; i < tapTables.length; ++i) {
                this.gluAdqlQueryTemplates.put(tapTables[i], new GluAdqlTemplate());
            }
            if (this.flagTAPV2) {
                this.tapTableMapping.put("GENERAL", new Vector());
                JButton changeServerButton = this.tapClient.getChangeServerButton(this);
                if (changeServerButton != null) {
                    changeServerButton.setBounds(5, 15, 20, 20);
                    this.add(changeServerButton);
                    this.tapTableMapping.get("GENERAL").add(changeServerButton);
                }
            }
        }
        JPanel tp = new JPanel();
        Dimension d = this.makeTitle(tp, description);
        int x = XWIDTH / 2 - d.width / 2;
        if (x < 0) {
            x = 5;
        }
        tp.setBackground(Aladin.BLUE);
        tp.setBounds(x, y, d.width, d.height);
        y += d.height + 10;
        tp.setName("titrePanel");
        if (this.flagTAPV2) {
            this.tapTableMapping.get("GENERAL").add(tp);
        }
        this.add(tp);
        if (flagInfo) {
            JLabel l = new JLabel(this.info1);
            l.setName("info");
            l.setBounds(110, y, 400, 20);
            y += 20;
            if (this.flagTAPV2) {
                this.tapTableMapping.get("GENERAL").add(l);
            }
            this.add(l);
        }
        if (this.flagTAPV2 && (optionsPanel = this.tapClient.getModes(this)) != null) {
            optionsPanel.setName("modes");
            optionsPanel.setBackground(Aladin.BLUE);
            optionsPanel.setBounds(x + d.width, y - d.height, 140, 30);
            this.add(optionsPanel);
            this.tapTableMapping.get("GENERAL").add(optionsPanel);
        }
        this.baseUrlIndex = this.getBaseUrlParam(paramDataType);
        boolean targetRequired = this.targetRequired(paramDataType);
        boolean radiusRequired = this.radiusRequired(paramDataType);
        if (targetRequired || radiusRequired) {
            int targetIndex;
            JPanel tPanel = new JPanel();
            int mode = 0;
            if (!targetRequired) {
                mode |= 4;
            }
            if (!radiusRequired) {
                mode |= 2;
            }
            int h = this.makeTargetPanel(tPanel, mode);
            tPanel.setBackground(Aladin.BLUE);
            tPanel.setBounds(0, y, XWIDTH, h);
            y += h;
            tPanel.setName("tPanel");
            if (this.flagTAPV2 && (targetIndex = this.getKeyWordRequiredIndex(paramDataType, "Target")) >= 0) {
                for (String tapTable : tapTables) {
                    if (!this.isParamSpecified(paramDataType[targetIndex], tapTable)) continue;
                    Vector<JPanel> components = this.tapTableMapping.get(tapTable);
                    if (components == null) {
                        components = new Vector<JPanel>();
                        this.tapTableMapping.put(tapTable, components);
                    }
                    components.add(tPanel);
                }
            }
            this.add(tPanel);
        }
        if (this.flagTAPV2 && tapTables != null) {
            this.currentSelectedTapTable = tapTables[0];
        }
        this.vc = new Vector(5);
        int nc = 0;
        for (int i = 0; i < paramDescription.length; ++i) {
            JComponent co;
            StringTokenizer pv;
            JList<String> list = null;
            boolean flagShow = true;
            boolean flagShowBackUp = true;
            StringTokenizer stringTokenizer = pv = paramValue[i] != null ? new StringTokenizer(paramValue[i], "\t") : null;
            if (this.checkIfMultiSelect(paramDataType[i])) {
                list = new JList<String>(paramValue[i].split("\t"));
                list.setSelectionMode(2);
                list.setVisibleRowCount(5);
                if (this.flagTAPV2 && paramDataType != null && paramDataType[i] != null) {
                    this.setDedicatedFields(i, paramDataType[i], list, gluAdqlTemplate);
                    list.addListSelectionListener(new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent e) {
                            ServerGlu.this.updateWidgets();
                        }
                    });
                }
                sc = new JScrollPane(list);
                co = list;
            } else if (pv != null && pv.countTokens() > 1) {
                JComboBox<String> ch = new JComboBox<String>();
                ch.setOpaque(false);
                while (pv.hasMoreTokens()) {
                    ch.addItem(pv.nextToken());
                }
                if (this.flagTAP) {
                    ch.addActionListener(this);
                }
                if (this.flagTAPV2 && paramDataType != null && paramDataType[i] != null) {
                    this.setDedicatedFields(i, paramDataType[i], ch, gluAdqlTemplate);
                    if (paramDataType[i].contains("Tables")) {
                        ch.setActionCommand("TABLECHANGED");
                    }
                }
                co = ch;
            } else {
                JTextField t;
                if (pv != null) {
                    if (this.vD == null) {
                        this.vD = new String[paramDescription.length];
                    }
                    this.vD[nc] = paramValue[i];
                    t = new JTextField(this.vD[nc], 40);
                } else {
                    t = new JTextField(40);
                }
                t.addKeyListener(this);
                if (this.flagTAP) {
                    t.addActionListener(this);
                }
                co = t;
                if (paramDataType != null && paramDataType[i] != null) {
                    co = this.setDedicatedFields(i, paramDataType[i], co, gluAdqlTemplate);
                    flagShow = this.isShownField(paramDataType[i]);
                }
            }
            if (paramRange != null && paramRange[i] != null) {
                this.rangeValues.put(i, paramRange[i]);
                Util.toolTip(co, this.getSODAParamHint(co, i, paramRange[i]));
            }
            if (this.flagTAPV2) {
                flagShowBackUp = flagShow;
                if (flagShow) {
                    flagShow = this.isParamSpecified(paramDataType[i], this.currentSelectedTapTable);
                }
            }
            JLabel pTitre = null;
            if (flagShow) {
                String s = paramDescription[i] == null ? "Parameter " + (i + 1) : paramDescription[i] + " ";
                pTitre = new JLabel(this.addDot(s));
                pTitre.setFont(Aladin.BOLD);
                pTitre.setBounds(10, y, 150, HAUT);
                this.add(pTitre);
                if (list != null) {
                    sc.setBounds(160, y, XWIDTH - 160, LIST_HAUT);
                    y += LIST_HAUT + MARGE;
                    this.add(sc);
                    list = null;
                } else {
                    co.setBounds(160, y, XWIDTH - 160, HAUT);
                    y += HAUT + MARGE;
                    this.add(co);
                }
                co.setName(s);
                ++nc;
            }
            if (this.flagTAPV2 && paramDataType[i] != null && tapTables != null) {
                for (String tapTable : tapTables) {
                    if (!this.isParamSpecified(paramDataType[i], tapTable)) continue;
                    Vector components = this.tapTableMapping.get(tapTable);
                    if (components == null) {
                        this.tapTableMapping.put(tapTable, new Vector());
                        components = this.tapTableMapping.get(tapTable);
                    }
                    if (!flagShowBackUp) continue;
                    if (pTitre == null) {
                        pTitre = this.createDescriptiveLabel(paramDescription, i);
                    }
                    components.add(pTitre);
                    components.add(co);
                }
            }
            this.vc.addElement(co);
        }
        if (this.flagSIAIDHA) {
            this.tree = new MetaDataTree(aladin, null);
            sc = new JScrollPane(this.tree);
            this.tree.setScroll(sc);
            sc.setBackground(this.tree.bkgColor);
            sc.setBounds(10, y, XWIDTH - 20, 180);
            y += 180;
            this.add(sc);
        } else if (this.flagTAP) {
            if (this.flagTAPV2) {
                this.adqlParser = new ADQLParser();
                JPanel linePanel = new JPanel();
                linePanel.setBackground(Aladin.BLUE);
                JButton button = new JButton("Check..");
                button.setToolTipText(this.CHECKQUERYTOOLTIP);
                button.setActionCommand("CHECKQUERY");
                button.addActionListener(this);
                linePanel.add(button);
                this.sync_async = new JComboBox<String>(Constants.SYNC_ASYNC);
                this.sync_async.setToolTipText(this.SYNCASYNCTOOLTIP);
                this.sync_async.setOpaque(false);
                linePanel.add(this.sync_async);
                button = new JButton("Async jobs>>");
                button.setToolTipText(this.SHOWASYNCTOOLTIP);
                button.setActionCommand("SHOWAYNCJOBS");
                button.addActionListener(this);
                linePanel.add(button);
                if (flagTapUpload) {
                    button = new JButton("Upload");
                    button.setActionCommand("UPLOAD");
                    String uploadTipText = ServerTap.TAPTABLEUPLOADTIP;
                    button.addActionListener(this);
                    button.setToolTipText(uploadTipText);
                    linePanel.add(button);
                }
                this.tapTableMapping.put("LASTPANEL", new Vector());
                this.tapTableMapping.get("LASTPANEL").add(linePanel);
                linePanel.setBounds(10, y, XWIDTH - 20, HAUT + 10);
                y += HAUT + 10;
                this.add(linePanel);
            }
            this.tap = new JTextArea("", 8, 50);
            this.tap.setFont(Aladin.ITALIC);
            this.tap.setWrapStyleWord(true);
            this.tap.setLineWrap(true);
            sc = new JScrollPane(this.tap);
            sc.setBounds(10, y += 15, XWIDTH - 20, 180);
            y += 180;
            this.add(sc);
        } else if (showSyncAsync > -1) {
            this.setSyncAsyncOption();
            if (this.sync_async != null) {
                this.sync_async.setBounds(160, y, XWIDTH - 320, HAUT);
                y += HAUT;
                this.add(this.sync_async);
            }
        }
        if (aladinFilter != null) {
            this.filters = aladinFilter;
            JComboBox filtersChoice = this.createFilterChoice();
            filtersChoice.setOpaque(false);
            JLabel pFilter = new JLabel(this.addDot(this.filter));
            pFilter.setFont(Aladin.BOLD);
            pFilter.setBounds(10, y += 10, 150, HAUT);
            this.add(pFilter);
            filtersChoice.setBounds(160, y, XWIDTH - 160, HAUT);
            y += HAUT + MARGE;
            this.add(filtersChoice);
        }
        if (docUser != null) {
            JButton b = new JButton(this.HELP);
            b.setOpaque(false);
            b.addActionListener(this);
            b.setBounds(290, y += 10, 140, HAUT);
            this.lastY = y;
            y += HAUT + MARGE;
            this.add(b);
        }
        if (this.flagSIAIDHA || this.flagTAP) {
            this.setMaxComp(sc);
        }
    }

    private void setSyncAsyncOption() {
        this.sync_async = new JComboBox<String>(Constants.SYNC_ASYNC);
        this.sync_async.setOpaque(false);
        if (this.showSyncAsync > 0) {
            if (this.SYNCASYNCTOOLTIP != null && !this.SYNCASYNCTOOLTIP.isEmpty()) {
                this.sync_async.setToolTipText("<html><p width=\"500\">" + this.SYNCASYNCTOOLTIP + "</p></html>");
            }
            if (this.showSyncAsync == 2) {
                this.sync_async.setSelectedIndex(1);
            }
        } else {
            this.sync_async.setSelectedIndex(1);
            this.sync_async.setEnabled(false);
            this.sync_async.setToolTipText(this.ASYNCTOOLTIP);
        }
        this.sync_async.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object url = null;
                url = ServerGlu.this.sync_async.getSelectedItem().equals("SYNC") ? (Object)ServerGlu.this.aladin.glu.aladinDic.get("Datalink_Form_sync") : (Object)ServerGlu.this.aladin.glu.aladinDic.get("Datalink_Form_async");
                if (url != null) {
                    ServerGlu.this.aladin.glu.aladinDic.put("Datalink_Form", url);
                }
                Aladin.info(ServerGlu.this, ServerGlu.this.SYNCASYNCSELECTIONCHANGE);
            }
        });
    }

    protected void changeTapTable(String tableSelected) {
        int y = 5;
        JScrollPane sc = null;
        int j = 0;
        j = tableSelected.indexOf(" - ");
        this.currentSelectedTapTable = j > 0 ? tableSelected.substring(0, j).trim() : ((j = tableSelected.trim().indexOf("- ")) == 0 ? tableSelected.substring(0, j).trim() : tableSelected);
        this.removeAll();
        if (this.tapTableMapping.get("GENERAL") != null && !this.tapTableMapping.get("GENERAL").isEmpty()) {
            for (Iterator topPanelComponent : this.tapTableMapping.get("GENERAL")) {
                this.add((Component)((Object)topPanelComponent));
            }
            y += 20;
        }
        y += 20;
        Vector components = new Vector();
        components.addAll(this.tapTableMapping.get(this.currentSelectedTapTable));
        for (Component co : components) {
            if (co instanceof JPanel) {
                this.add(co);
                y += co.getHeight();
                continue;
            }
            if (co instanceof JButton) {
                this.add(co);
                continue;
            }
            if (co instanceof JLabel) {
                co.setBounds(10, y, 150, HAUT);
                this.add(co);
                continue;
            }
            if (co instanceof JList) {
                sc = new JScrollPane();
                sc.setViewport((JViewport)co.getParent());
                sc.setBounds(160, y, XWIDTH - 160, LIST_HAUT);
                y += LIST_HAUT + MARGE;
                this.add(sc);
                continue;
            }
            co.setBounds(160, y, XWIDTH - 160, HAUT);
            y += HAUT + MARGE;
            this.add(co);
        }
        Aladin.trace(3, "before addition of lastpanel y" + y);
        JPanel lastPanel = (JPanel)this.tapTableMapping.get("LASTPANEL").get(0);
        lastPanel.setBounds(10, y, XWIDTH - 20, HAUT + 10);
        this.add(lastPanel);
        Aladin.trace(3, "before addition of tap y" + (y += HAUT + 10));
        sc = new JScrollPane(this.tap);
        sc.setBounds(10, y += 15, XWIDTH - 20, 180);
        y += 180;
        this.add(sc);
        if (this.flagTAP) {
            this.setMaxComp(sc);
        }
        this.majChoiceSize();
        this.revalidate();
        this.repaint();
    }

    private JLabel createDescriptiveLabel(String[] paramDescription, int i) {
        JLabel pTitre = new JLabel();
        String s = paramDescription[i] == null ? "Parameter " + (i + 1) : paramDescription[i] + " ";
        pTitre = new JLabel(this.addDot(s));
        pTitre.setFont(Aladin.BOLD);
        return pTitre;
    }

    public void setAdditionalGluParams(HashMap<String, String[]> ranges, Hashtable<String, String> paramValues) {
        String[] paramRanges = new String[14];
        String formIndex = null;
        JTextField field = null;
        JList list = null;
        if (ranges != null) {
            for (int i = 0; i < this.vc.size(); ++i) {
                String paramValue;
                JComponent gluComponent = (JComponent)this.vc.elementAt(i);
                formIndex = String.valueOf(1 + i);
                if (paramValues.containsKey(formIndex) && (paramValue = paramValues.get(formIndex)) != null) {
                    if (gluComponent instanceof JTextField) {
                        field = (JTextField)gluComponent;
                        field.setText(paramValue);
                    } else if (gluComponent instanceof JList) {
                        list = (JList)gluComponent;
                        list.setListData(paramValue.split("\t"));
                    }
                }
                if (ranges.containsKey(formIndex)) {
                    paramRanges = ranges.get(formIndex);
                    if (paramRanges == null) continue;
                    this.rangeValues.put(i, ranges.get(formIndex));
                    Util.toolTip(gluComponent, this.getSODAParamHint(gluComponent, i, paramRanges));
                    continue;
                }
                if (formIndex.equalsIgnoreCase("7")) continue;
                this.rangeValues.put(i, null);
                Util.toolTip(gluComponent, "Field limit unknown...");
            }
        }
    }

    public String getSODAParamHint(JComponent co, int paramFormIndex, String[] paramRange) {
        String result = "Field limit unknown...";
        StringBuffer sodaHint = null;
        if (paramFormIndex == 5 && paramRange != null && paramRange[0] != null) {
            sodaHint = new StringBuffer("Valid options are: ").append(Arrays.toString(paramRange).replaceAll("[\\[\\]null(,$)]", "").trim().replaceAll("\\s", " ,"));
        } else if (paramRange != null) {
            String upperLimitString;
            String lowerLimitString = paramRange[0] == null || paramRange[0].isEmpty() ? "" : paramRange[0];
            String string = upperLimitString = paramRange[1] == null || paramRange[1].isEmpty() ? "" : paramRange[1];
            if (!lowerLimitString.isEmpty() || !upperLimitString.isEmpty()) {
                sodaHint = new StringBuffer("Valid Range: ").append(lowerLimitString);
                sodaHint.append(" > ").append(upperLimitString);
            }
        }
        if (co == this.date) {
            if (sodaHint != null) {
                sodaHint.append("  . ").append(this.PARSEMJDFIELDHINT);
            } else {
                sodaHint = new StringBuffer(result).append("  . ").append(this.PARSEMJDFIELDHINT);
            }
            result = sodaHint.toString();
        } else if (paramFormIndex + 1 == 7) {
            result = "";
        } else if (sodaHint != null) {
            result = sodaHint.toString();
        }
        return result;
    }

    private boolean targetRequired(String[] PK) {
        return this.keyWordRequired(PK, "Target");
    }

    private boolean radiusRequired(String[] PK) {
        return this.keyWordRequired(PK, "Field");
    }

    private boolean checkIfMultiSelect(String paramDataType) {
        return this.isParamSpecified(paramDataType, "MultiSelect");
    }

    private int getBaseUrlParam(String[] PK) {
        return this.getKeyWordRequiredIndex(PK, "BaseUrl");
    }

    private boolean keyWordRequired(String[] PK, String keyWord) {
        return this.getKeyWordRequiredIndex(PK, keyWord) >= 0;
    }

    private int getKeyWordRequiredIndex(String[] PK, String keyWord) {
        for (int i = 0; i < PK.length; ++i) {
            if (PK[i] == null) continue;
            int j = PK[i].indexOf(40);
            if (j < 0) {
                j = PK[i].length();
            }
            if (!PK[i].substring(0, j).equalsIgnoreCase(keyWord)) continue;
            return i;
        }
        return -1;
    }

    private boolean isParamSpecified(String paramDataType, String param) {
        if (paramDataType == null) {
            return false;
        }
        int j = paramDataType.indexOf(40);
        if (j < 0) {
            return false;
        }
        String[] params = paramDataType.substring(j + 1, paramDataType.indexOf(41)).split(",");
        for (int k = 0; k < params.length; ++k) {
            if (!params[k].equalsIgnoreCase(param)) continue;
            return true;
        }
        return false;
    }

    private int getFmt(String R) {
        if (R == null || R.indexOf("image") < 0) {
            return 0;
        }
        return R.indexOf("/gfits") > 0 ? 4 : (R.indexOf("/hfits") > 0 ? 3 : (R.indexOf("/mrcomp") > 0 ? 5 : (R.indexOf("/fits") > 0 ? 2 : 7)));
    }

    private int getMode(StringBuffer mode, char[] a, int i) {
        while (i < a.length && a[i] != ')' && a[i] != '|' && a[i] != ',' && a[i] != ' ') {
            mode.append(a[i]);
            ++i;
        }
        return i;
    }

    private boolean isShownField(String PK) {
        char[] a = PK.toCharArray();
        int i = 0;
        for (i = 0; i < a.length && a[i] != '('; ++i) {
        }
        String prefixe = new String(a, 0, i);
        return !prefixe.equalsIgnoreCase("Target") && !prefixe.equalsIgnoreCase("Field") && !prefixe.equalsIgnoreCase("HiPS");
    }

    private boolean isTargetPanelComponent(String PK) {
        return !this.isShownField(PK);
    }

    private JComponent setDedicatedFields(int gluIndex, String PK, JComponent f, GluAdqlTemplate sourceGluAdqlTemplate) {
        char[] a = PK.toCharArray();
        int i = 0;
        int nbField = 1;
        int ind = 0;
        for (i = 0; i < a.length && a[i] != '('; ++i) {
        }
        String prefixe = new String(a, 0, i);
        if (prefixe.equalsIgnoreCase("Target")) {
            while (true) {
                StringBuffer mode = new StringBuffer();
                i = this.getMode(mode, a, i + 1);
                if (mode.length() == 0) break;
                String s = mode.toString();
                if (s.equalsIgnoreCase("RA")) {
                    nbField = 2;
                    this.modeCoo |= 0x10;
                    continue;
                }
                if (s.equalsIgnoreCase("DE")) {
                    nbField = 2;
                    ind = 1;
                    this.modeCoo |= 0x10;
                    continue;
                }
                if (s.equalsIgnoreCase("RAb")) {
                    nbField = 2;
                    this.modeCoo |= 0x40;
                    continue;
                }
                if (s.equalsIgnoreCase("DEb")) {
                    nbField = 2;
                    ind = 1;
                    this.modeCoo |= 0x40;
                    continue;
                }
                if (s.equalsIgnoreCase("RAh")) {
                    nbField = 6;
                    this.modeCoo |= 0x80;
                    continue;
                }
                if (s.equalsIgnoreCase("RAm")) {
                    nbField = 6;
                    ind = 1;
                    this.modeCoo |= 0x80;
                    continue;
                }
                if (s.equalsIgnoreCase("RAs")) {
                    nbField = 6;
                    ind = 2;
                    this.modeCoo |= 0x80;
                    continue;
                }
                if (s.equalsIgnoreCase("DEdg")) {
                    nbField = 6;
                    ind = 3;
                    this.modeCoo |= 0x80;
                    continue;
                }
                if (s.equalsIgnoreCase("DEm")) {
                    nbField = 6;
                    ind = 4;
                    this.modeCoo |= 0x80;
                    continue;
                }
                if (s.equalsIgnoreCase("DEs")) {
                    nbField = 6;
                    ind = 5;
                    this.modeCoo |= 0x80;
                    continue;
                }
                if (s.equalsIgnoreCase("SIMBAD")) {
                    this.modeCoo |= 4;
                    continue;
                }
                if (s.equalsIgnoreCase("NED")) {
                    this.modeCoo |= 8;
                    continue;
                }
                if (s.equalsIgnoreCase("COO")) {
                    this.modeCoo |= 1;
                    continue;
                }
                if (s.equalsIgnoreCase("COOd")) {
                    this.modeCoo |= 0x100;
                    continue;
                }
                if (s.equalsIgnoreCase("COOb")) {
                    this.modeCoo |= 2;
                    continue;
                }
                if (s.equalsIgnoreCase("RAd")) {
                    nbField = 2;
                    this.modeCoo |= 0x20;
                    continue;
                }
                if (s.equalsIgnoreCase("DEd")) {
                    nbField = 2;
                    ind = 1;
                    this.modeCoo |= 0x20;
                    continue;
                }
                if (this.flagTAPV2 && this.gluAdqlQueryTemplates.keySet().contains(s)) {
                    this.classifyAsPerTapTables(prefixe, s, gluIndex + 1, sourceGluAdqlTemplate);
                    continue;
                }
                if (this.modeCoo != 0) continue;
                System.err.println("Server [" + this.aladinLabel + "]; unknown Target code [" + s + "] => assume COO");
                this.modeCoo |= 1;
            }
            if (this.coo == null) {
                this.coo = new JTextField[nbField];
            }
            this.coo[ind] = (JTextField)((Object)f);
        } else if (prefixe.equalsIgnoreCase("Field")) {
            while (true) {
                StringBuffer mode = new StringBuffer();
                i = this.getMode(mode, a, i + 1);
                if (mode.length() == 0) break;
                String s = mode.toString();
                if (s.equalsIgnoreCase("RA")) {
                    nbField = 2;
                    this.modeRad |= 4;
                    continue;
                }
                if (s.equalsIgnoreCase("DE")) {
                    nbField = 2;
                    ind = 1;
                    this.modeRad |= 4;
                    continue;
                }
                if (s.equalsIgnoreCase("RAd")) {
                    nbField = 2;
                    this.modeRad |= 0x40;
                    continue;
                }
                if (s.equalsIgnoreCase("DEd")) {
                    nbField = 2;
                    ind = 1;
                    this.modeRad |= 0x40;
                    continue;
                }
                if (s.equalsIgnoreCase("RAs")) {
                    nbField = 2;
                    this.modeRad |= 0x100;
                    continue;
                }
                if (s.equalsIgnoreCase("DEs")) {
                    nbField = 2;
                    ind = 1;
                    this.modeRad |= 0x100;
                    continue;
                }
                if (s.equalsIgnoreCase("SQR")) {
                    this.modeRad |= 2;
                    continue;
                }
                if (s.equalsIgnoreCase("SQRd")) {
                    this.modeRad |= 0x20;
                    continue;
                }
                if (s.equalsIgnoreCase("SQRs")) {
                    this.modeRad |= 0x80;
                    continue;
                }
                if (s.equalsIgnoreCase("RADIUS")) {
                    this.modeRad |= 1;
                    continue;
                }
                if (s.equalsIgnoreCase("RADIUSd")) {
                    this.modeRad |= 8;
                    continue;
                }
                if (s.equalsIgnoreCase("RADIUSs")) {
                    this.modeRad |= 0x10;
                    continue;
                }
                if (s.equalsIgnoreCase("STRINGd")) {
                    this.modeRad |= 0x200;
                    continue;
                }
                if (this.flagTAPV2 && this.gluAdqlQueryTemplates.keySet().contains(s)) {
                    this.classifyAsPerTapTables(prefixe, s, gluIndex + 1, sourceGluAdqlTemplate);
                    continue;
                }
                if (this.flagTAPV2 && s.equalsIgnoreCase("OP") && f instanceof JTextField) {
                    if (this.adqlOpInputs == null) {
                        this.adqlOpInputs = new Vector();
                    }
                    this.adqlOpInputs.addElement((JTextField)((Object)f));
                    continue;
                }
                if (this.modeRad != 0) continue;
                System.err.println("Server [" + this.aladinLabel + "]; unknown Field code [" + s + "] => assume RADIUS");
                this.modeRad |= 1;
            }
            if (this.rad == null) {
                this.rad = new JTextField[nbField];
            }
            this.rad[ind] = (JTextField)((Object)f);
        } else if (prefixe.equalsIgnoreCase("BaseUrl")) {
            this.baseUrl = (JTextField)((Object)f);
        } else if (prefixe.equalsIgnoreCase("Date")) {
            while (true) {
                StringBuffer mode = new StringBuffer();
                i = this.getMode(mode, a, i + 1);
                if (mode.length() == 0) break;
                String s = mode.toString();
                if (s.equalsIgnoreCase("MJD")) {
                    this.modeDate |= 2;
                    continue;
                }
                if (s.equalsIgnoreCase("JD")) {
                    this.modeDate |= 1;
                    continue;
                }
                if (s.equalsIgnoreCase("YEARd")) {
                    this.modeDate |= 4;
                    continue;
                }
                if (s.equalsIgnoreCase("ParseToMJD")) {
                    this.modeDate |= 8;
                    continue;
                }
                if (this.flagTAPV2 && this.gluAdqlQueryTemplates.keySet().contains(s)) {
                    this.classifyAsPerTapTables(prefixe, s, gluIndex + 1, sourceGluAdqlTemplate);
                    continue;
                }
                if (this.flagTAPV2 && s.equalsIgnoreCase("OP") && f instanceof JTextField) {
                    if (this.adqlOpInputs == null) {
                        this.adqlOpInputs = new Vector();
                    }
                    this.adqlOpInputs.addElement((JTextField)((Object)f));
                    continue;
                }
                if (this.modeDate != 0) continue;
                if (Aladin.levelTrace >= 3) {
                    System.err.println("Server [" + this.aladinLabel + "]; unknown Date code [" + s + "] => assume JD");
                }
                this.modeDate |= 1;
            }
            this.date = (JTextField)((Object)f);
        } else if (prefixe.equalsIgnoreCase("Input")) {
            while (true) {
                StringBuffer mode = new StringBuffer();
                i = this.getMode(mode, a, i + 1);
                if (mode.length() == 0) break;
                String s = mode.toString();
                if (this.input == null) {
                    this.input = new JComponent[10];
                    this.modeInput = new int[10];
                    this.nbInput = 0;
                }
                if (s.equalsIgnoreCase("IMG")) {
                    int n = this.nbInput;
                    this.modeInput[n] = this.modeInput[n] | 1;
                    continue;
                }
                if (s.equalsIgnoreCase("ALLIMG")) {
                    int n = this.nbInput;
                    this.modeInput[n] = this.modeInput[n] | 0x10;
                    continue;
                }
                if (s.equalsIgnoreCase("IMGs")) {
                    int n = this.nbInput;
                    this.modeInput[n] = this.modeInput[n] | 2;
                    continue;
                }
                if (s.equalsIgnoreCase("CAT")) {
                    int n = this.nbInput;
                    this.modeInput[n] = this.modeInput[n] | 4;
                    continue;
                }
                if (s.equalsIgnoreCase("CATs")) {
                    int n = this.nbInput;
                    this.modeInput[n] = this.modeInput[n] | 8;
                    continue;
                }
                if (this.flagTAPV2 && this.gluAdqlQueryTemplates.keySet().contains(s)) {
                    this.classifyAsPerTapTables(prefixe, s, gluIndex + 1, sourceGluAdqlTemplate);
                    continue;
                }
                if (this.flagTAPV2 && s.equalsIgnoreCase("OP") && f instanceof JTextField) {
                    if (this.adqlOpInputs == null) {
                        this.adqlOpInputs = new Vector();
                    }
                    this.adqlOpInputs.addElement((JTextField)((Object)f));
                    continue;
                }
                if (this.modeInput[this.nbInput] != 0) continue;
                System.err.println("Server [" + this.aladinLabel + "]; unknown Input code [" + s + "] => assume IMG");
                int n = this.nbInput;
                this.modeInput[n] = this.modeInput[n] | 1;
            }
            if ((this.modeInput[this.nbInput] & 0x15) != 0) {
                JComboBox<String> c = new JComboBox<String>();
                c.addItem(this.NOINPUTITEM);
                f = c;
            }
            this.input[this.nbInput++] = f;
            this.DISCOVERY = false;
        } else if (prefixe.equalsIgnoreCase("Band")) {
            while (true) {
                StringBuffer mode = new StringBuffer();
                i = this.getMode(mode, a, i + 1);
                if (mode.length() == 0) break;
                String s = mode.toString();
                if (s.equalsIgnoreCase("SODA") || s.equalsIgnoreCase("m")) {
                    this.modeBand |= 1;
                    continue;
                }
                if (this.flagTAPV2 && this.gluAdqlQueryTemplates.keySet().contains(s)) {
                    this.classifyAsPerTapTables(prefixe, s, gluIndex + 1, sourceGluAdqlTemplate);
                    continue;
                }
                if (!this.flagTAPV2 || !s.equalsIgnoreCase("OP") || !(f instanceof JTextField)) continue;
                if (this.adqlOpInputs == null) {
                    this.adqlOpInputs = new Vector();
                }
                this.adqlOpInputs.addElement((JTextField)((Object)f));
            }
            this.band = (JTextField)((Object)f);
        } else if (this.flagTAPV2) {
            this.setGluAdqlForAllTapTables(prefixe, i, a, gluIndex + 1, sourceGluAdqlTemplate, f);
        } else if (prefixe.equalsIgnoreCase("HiPS")) {
            f = new Server.JHiPS();
            this.flagHiPS = true;
        }
        return f;
    }

    private void setGluAdqlForAllTapTables(String prefixe, int i, char[] a, int gluIndex, GluAdqlTemplate sourceGluAdqlTemplate, JComponent f) {
        while (true) {
            StringBuffer mode = new StringBuffer();
            i = this.getMode(mode, a, i + 1);
            if (mode.length() == 0) break;
            String s = mode.toString();
            if (s.equalsIgnoreCase("OP") && f instanceof JTextField) {
                if (this.adqlOpInputs == null) {
                    this.adqlOpInputs = new Vector();
                }
                this.adqlOpInputs.addElement((JTextField)f);
                continue;
            }
            this.classifyAsPerTapTables(prefixe, s, gluIndex, sourceGluAdqlTemplate);
        }
    }

    private void classifyAsPerTapTables(String prefixe, String s, int gluIndex, GluAdqlTemplate sourceGluAdqlTemplate) {
        for (String tapTable : this.gluAdqlQueryTemplates.keySet()) {
            if (!s.equalsIgnoreCase(tapTable)) continue;
            GluAdqlTemplate tableQuery = this.gluAdqlQueryTemplates.get(tapTable);
            GluAdqlTemplate.copy(prefixe, String.valueOf(gluIndex), sourceGluAdqlTemplate, tableQuery);
        }
    }

    public static String extractFromQuotes(String input) {
        String demiliter = "";
        try {
            StringTokenizer stk = new StringTokenizer(input, "\"");
            demiliter = stk.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return demiliter;
    }

    @Override
    protected boolean is(String s) {
        return s.equalsIgnoreCase(this.gluTag) || super.is(s);
    }

    private String getComboItem(JComboBox c, String cr) {
        boolean flagNumeric = true;
        try {
            Double.parseDouble(cr);
        }
        catch (Exception e) {
            flagNumeric = false;
        }
        int n = c.getItemCount();
        for (int i = 0; i < n; ++i) {
            String s;
            String s1 = s = ((String)c.getItemAt(i)).toUpperCase();
            int m = s.indexOf(" - ");
            if (m > 0) {
                s1 = s.substring(m + 1).trim();
                s = s.substring(0, m).trim();
            }
            if ((flagNumeric || (s1 == s || !s.equals(cr) && s1.indexOf(cr) < 0) && (s1 != s || s.indexOf(cr) < 0)) && (!flagNumeric || !s.equals(cr))) continue;
            s = (String)c.getItemAt(i);
            m = s.indexOf(" - ");
            if (m > 0) {
                s = s.substring(0, m).trim();
            }
            return s;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int createPlane(String target, String radius, String criteria, String label, String origin) {
        String objet = "";
        String serverTaskId = this.aladin.synchroServer.start("ServerGlu.createPlane/" + target);
        try {
            String urlList;
            int m;
            JComponent c;
            int j;
            String s;
            try {
                objet = this.resolveTarget(target);
                if (objet == null) {
                    throw new Exception(this.UNKNOWNOBJ);
                }
            }
            catch (Exception e1) {
                Aladin.error(this, e1.getMessage(), 1);
                int n = -1;
                this.aladin.synchroServer.stop(serverTaskId);
                return n;
            }
            if (radius != null && radius.length() > 0) {
                this.resolveRadius(radius, true);
            }
            if (this.date != null && this.date.getText().trim().length() == 0) {
                this.resolveDate(this.getDefaultDate());
            }
            Tok st = new Tok(criteria.trim(), ",");
            String[] crit = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                crit[i] = st.nextToken();
                ++i;
            }
            Vector<String> v = new Vector<String>(10);
            Vector<String> vbis = new Vector<String>(10);
            Enumeration e = this.vc.elements();
            while (e.hasMoreElements()) {
                v.addElement(null);
                vbis.addElement(null);
                e.nextElement();
            }
            block26: for (i = 0; i < crit.length; ++i) {
                String cr = crit[i];
                int posEgal = cr.indexOf(61);
                if (posEgal <= 0 || cr.charAt(posEgal - 1) == '\\') continue;
                String cName = cr.substring(0, posEgal).trim().toUpperCase();
                s = cr.substring(posEgal + 1).trim();
                s = Tok.unQuote(s);
                e = this.vc.elements();
                j = 0;
                while (e.hasMoreElements()) {
                    String coName;
                    JComponent c2 = (JComponent)e.nextElement();
                    if (!this.isFieldInput(c2) && !this.isFieldTargetOrRadius(c2) && (coName = c2.getName()) != null && (coName = coName.trim().toUpperCase()).indexOf(cName) >= 0) {
                        if (c2 instanceof JComboBox) {
                            s = this.getComboItem((JComboBox)c2, s.toUpperCase());
                        }
                        if (s == null) continue block26;
                        v.setElementAt(s, j);
                        vbis.setElementAt(s, j);
                        crit[i] = null;
                        continue block26;
                    }
                    ++j;
                }
            }
            e = this.vc.elements();
            j = 0;
            while (e.hasMoreElements()) {
                c = (JComponent)e.nextElement();
                boolean trouve = false;
                for (int k = 0; !trouve && k < crit.length; ++k) {
                    String cr = crit[k];
                    if (cr == null) continue;
                    cr = cr.toUpperCase();
                    if (!(c instanceof JComboBox) || this.isFieldInput(c) || (s = this.getComboItem((JComboBox)c, cr)) == null) continue;
                    m = s.indexOf(" - ");
                    if (m > 0) {
                        s = s.substring(0, m).trim();
                    }
                    trouve = true;
                    v.setElementAt(s, j);
                    vbis.setElementAt(s, j);
                    crit[k] = null;
                }
                ++j;
            }
            e = this.vc.elements();
            c = (JComponent)e.nextElement();
            j = 0;
            for (i = 0; i < crit.length; ++i) {
                if (crit[i] == null) continue;
                try {
                    while (v.elementAt(j) != null || this.isFieldTargetOrRadius(c)) {
                        c = (JComponent)e.nextElement();
                        ++j;
                    }
                }
                catch (NoSuchElementException nsee) {
                    continue;
                }
                if (this.isFieldInput(c)) {
                    this.setSelectedItem(c, crit[i]);
                    crit[i] = this.getInputUrl(c);
                    if (crit[i] == null) {
                        int nsee = -1;
                        return nsee;
                    }
                }
                v.setElementAt(crit[i], j);
                vbis.setElementAt(crit[i], j);
            }
            e = this.vc.elements();
            j = 0;
            while (e.hasMoreElements()) {
                c = (JComponent)e.nextElement();
                if (v.elementAt(j) == null) {
                    s = "";
                    if (c instanceof JTextField) {
                        s = ((JTextField)c).getText();
                    } else if (c instanceof JComboBox) {
                        s = (String)((JComboBox)c).getSelectedItem();
                        m = s.indexOf(" - ");
                        if (m > 0) {
                            vbis.addElement(s.substring(m + 3));
                        } else {
                            vbis.addElement(s);
                        }
                        m = s.indexOf(" - ");
                        if (m > 0) {
                            s = s.substring(0, m).trim();
                        } else if (s.equals("?") || s.startsWith("-") && s.endsWith("-")) {
                            s = "";
                        }
                        v.addElement(s);
                    }
                    v.setElementAt(s, j);
                    vbis.setElementAt(s, j);
                }
                ++j;
            }
            Tok tokUrlList = null;
            if (this.baseUrlIndex >= 0 && !(s = (String)v.get(this.baseUrlIndex)).startsWith("http://") && !s.startsWith("https://") && (urlList = this.aladin.directory.resolveServiceUrl(this.gluTag, s)) != null) {
                tokUrlList = new Tok(urlList, "\t");
                v.setElementAt(tokUrlList.nextToken(), this.baseUrlIndex);
            }
            boolean encore = true;
            int n = -1;
            do {
                String[] param;
                e = v.elements();
                StringBuffer p = null;
                StringBuffer p1 = null;
                while (e.hasMoreElements()) {
                    s = (String)e.nextElement();
                    if (p == null) {
                        p = new StringBuffer(Glu.quote(s));
                        p1 = new StringBuffer(s);
                        continue;
                    }
                    p.append(" " + Glu.quote(s));
                    p1.append("/" + s);
                }
                URL u = this.aladin.glu.getURL(this.gluTag, p.toString());
                if (this.flagSIAIDHA && (this.type == 1 || this.type == 4)) {
                    ResourceNode[] nodesToLoad;
                    block73: {
                        TreeBuilder tb = new TreeBuilder(this.aladin, u, -1, null, objet);
                        ResourceNode rootNode = tb.build();
                        Vector leaves = new Vector();
                        BasicTree.getAllLeaves(rootNode, leaves);
                        SIAPruner pruner = new SIAPruner(leaves.toArray(new ResourceNode[leaves.size()]), crit);
                        nodesToLoad = pruner.prune();
                        if (nodesToLoad != null) break block73;
                        int n2 = -1;
                        return n2;
                    }
                    try {
                        for (int idx = 0; idx < nodesToLoad.length; ++idx) {
                            ResourceNode node = nodesToLoad[idx];
                            if (this.type == 1) {
                                this.aladin.dialog.localServer.tree.load(node, label);
                                continue;
                            }
                            if (this.type != 4) continue;
                            this.aladin.getMessagingMgr().sendMessageLoadSpectrum(node.location, node.location, node.name, node.getMetadata(), null);
                        }
                    }
                    catch (Exception e2) {
                        this.aladin.command.println("error : " + e2.getMessage());
                        e2.printStackTrace();
                    }
                    int e2 = 1;
                    return e2;
                }
                if (label == null) {
                    if (this.planeLabel == null) {
                        label = this.getDefaultLabelIfRequired(label);
                    } else {
                        param = new String[vbis.size()];
                        for (i = 0; i < param.length; ++i) {
                            s = (String)vbis.elementAt(i);
                            if (s.equals("-")) {
                                s = "";
                            }
                            param[i] = s;
                        }
                        this.planeLabel = this.dollarQuerySet(this.planeLabel);
                        Glu cfr_ignored_0 = this.aladin.glu;
                        label = this.getDefaultLabelIfRequired(label, Glu.dollarSet(this.planeLabel, param, 2).trim());
                    }
                }
                Object object = param = p1 != null ? p1.toString() : "";
                if (this.type == 1) {
                    if (!this.verif(1, objet, (String)param)) {
                        int e2 = -1;
                        return e2;
                    }
                    n = ((ServerFile)this.aladin.dialog.localServer).creatLocalPlane(u + "", label, origin, null, null, null, this, null, null);
                } else {
                    if (this.type == 32) {
                        MyInputStream in = null;
                        try {
                            try {
                                in = Util.openStream(u);
                            }
                            catch (Exception e1) {
                                if (this.aladin.glu.checkIndirection(this.gluTag, null)) {
                                    u = this.aladin.glu.getURL(this.gluTag, p.toString());
                                    in = Util.openStream(u);
                                }
                                throw e1;
                            }
                            n = this.aladin.calque.newPlanMOC(in, label);
                        }
                        catch (Exception e1) {
                            if (Aladin.levelTrace >= 3) {
                                e1.printStackTrace();
                            }
                            int n3 = -1;
                            this.aladin.synchroServer.stop(serverTaskId);
                            return n3;
                        }
                    }
                    if (!this.verif(8, objet, (String)param)) {
                        int in = -1;
                        return in;
                    }
                    try {
                        Tok tok = new Tok(u.toString(), "\t");
                        while (tok.hasMoreTokens()) {
                            URL u1 = new URL(tok.nextToken());
                            n = this.aladin.calque.newPlanCatalog(u1, label, objet, (String)param, "provided by " + this.institute, this);
                        }
                    }
                    catch (MalformedURLException e1) {
                        if (Aladin.levelTrace >= 3) {
                            e1.printStackTrace();
                        }
                        int n4 = -1;
                        this.aladin.synchroServer.stop(serverTaskId);
                        return n4;
                    }
                }
                if (this.baseUrlIndex >= 0 && tokUrlList != null) {
                    encore = tokUrlList.hasMoreTokens();
                    if (!encore) continue;
                    v.setElementAt(tokUrlList.nextToken(), this.baseUrlIndex);
                    continue;
                }
                encore = false;
            } while (encore);
            if (n != -1) {
                this.aladin.targetHistory.add(objet);
            }
            int n5 = n;
            return n5;
        }
        finally {
            this.aladin.synchroServer.stop(serverTaskId);
        }
    }

    @Override
    public void submit() {
        new Thread((Runnable)this, "GluServer submit"){

            @Override
            public void run() {
                ServerGlu.this.submit1(true, false);
            }
        }.start();
    }

    private void submit1(boolean flagDoIt, boolean userReady) {
        String s;
        String objet = "";
        String code = null;
        boolean flagScriptEquiv = true;
        ArrayList<Coord> rectVertices = new ArrayList<Coord>();
        if (this.target != null) {
            try {
                objet = this.resolveQueryField();
                if (objet == null) {
                    throw new Exception(this.UNKNOWNOBJ);
                }
                if (this.boundaryAreaStcs != null && !this.boundaryAreaStcs.isEmpty()) {
                    String error;
                    if (this.posBounds == null) {
                        STCStringParser parser = new STCStringParser();
                        List<STCObj> stcObjects = parser.parse(this.boundaryAreaStcs);
                        this.posBounds = this.aladin.createMocRegion(stcObjects, -1);
                    }
                    if ((error = this.isWithinBounds(this.posBounds, rectVertices)) != null) {
                        this.showFOV();
                        throw new Exception(error);
                    }
                    if (this.cleanupFov) {
                        this.cleanUpFOV();
                        this.cleanupFov = false;
                    }
                }
            }
            catch (Exception e1) {
                if (!flagDoIt) {
                    return;
                }
                Aladin.error(this, e1.getMessage());
                this.ball.setMode(3);
                return;
            }
        }
        Vector<String> v = new Vector<String>(10);
        Vector<String> vbis = new Vector<String>(10);
        StringBuffer criteres = new StringBuffer();
        Enumeration e = this.vc.elements();
        int index = 0;
        StringBuffer limitViolation = null;
        while (e.hasMoreElements()) {
            JComponent c = (JComponent)e.nextElement();
            String crit = null;
            if (this.isFieldHiPS(c)) {
                v.addElement("_HIPS_");
                vbis.addElement("HiPS");
                flagScriptEquiv = false;
            } else if (this.isFieldInput(c)) {
                v.addElement(this.getInputUrl(c));
                vbis.addElement(this.getInputPlaneName(c));
                flagScriptEquiv = false;
            } else if (this.isBaseUrl(c)) {
                crit = s = ((JTextField)c).getText();
                vbis.add(crit);
                if (!s.startsWith("http://") && !s.startsWith("https://")) {
                    String urlList = this.aladin.directory.resolveServiceUrl(this.gluTag, s);
                    s = new Tok(urlList, "\t").nextToken();
                }
                v.add(s);
            } else if (c instanceof JTextField) {
                s = ((JTextField)c).getText();
                try {
                    StringBuffer processedText = this.processCustomFields(c, flagDoIt || userReady);
                    if (processedText != null && processedText.length() > 0 && !processedText.toString().trim().isEmpty()) {
                        s = processedText.toString();
                    }
                }
                catch (Exception e1) {
                    if (!flagDoIt) {
                        return;
                    }
                    Aladin.error(this, e1.getMessage());
                    this.ball.setMode(3);
                    return;
                }
                if (this.flagTAPV2 && !s.isEmpty() && this.adqlOpInputs != null && this.adqlOpInputs.contains(c)) {
                    String processedInput = TapClient.getRangeInput(s, null);
                    if (processedInput.isEmpty()) {
                        processedInput = TapClient.isInValidOperatorNumber(this, s, userReady || flagDoIt);
                        if (processedInput == null) {
                            return;
                        }
                        s = processedInput;
                    } else {
                        s = processedInput;
                    }
                }
                v.addElement(s);
                vbis.addElement(s);
                if (!this.isFieldTargetOrRadius(c)) {
                    crit = s;
                }
                limitViolation = this.isValueWithinLimits(s, this.rangeValues.get(index), null);
            } else if (c instanceof JComboBox) {
                Object t = null;
                crit = s = (String)((JComboBox)c).getSelectedItem();
                int j = s.indexOf(" - ");
                if (j > 0) {
                    crit = s.substring(j + 3);
                    vbis.addElement(crit);
                }
                if ((j = s.trim().indexOf("- ")) == 0) {
                    crit = s.substring(j + 2);
                    vbis.addElement(crit);
                } else {
                    vbis.addElement(s);
                }
                if (j >= 0) {
                    s = s.substring(0, j).trim();
                } else if (s.equals("?") || s.startsWith("-") && s.endsWith("-")) {
                    s = "";
                    crit = "";
                }
                v.addElement(s);
            } else if (c instanceof JList) {
                StringBuffer listString = new StringBuffer();
                List selectedValues = ((JList)c).getSelectedValuesList();
                Iterator iterator = selectedValues.iterator();
                while (iterator.hasNext()) {
                    String selectedValue;
                    crit = s = (selectedValue = (String)iterator.next());
                    int j = s.indexOf(" - ");
                    if (j > 0) {
                        crit = s.substring(j + 3);
                        vbis.addElement(crit);
                    }
                    if ((j = s.trim().indexOf("- ")) == 0) {
                        crit = s.substring(j + 2);
                        vbis.addElement(crit);
                    } else {
                        vbis.addElement(s);
                    }
                    if (j >= 0) {
                        s = s.substring(0, j).trim();
                    } else if (s.equals("?") || s.startsWith("-") && s.endsWith("-")) {
                        s = "";
                        crit = "";
                    }
                    listString.append(s).append(this.LISTDELIMITER);
                }
                v.addElement(listString.toString().trim().replaceAll(this.LISTDELIMITER + "$", ""));
                limitViolation = this.isValueWithinGivenOptions(listString.toString(), this.rangeValues.get(index), null);
            }
            if (crit != null && crit.length() > 0) {
                if (criteres.length() > 0) {
                    criteres.append(",");
                }
                criteres.append(Tok.quote(crit));
            }
            if (limitViolation != null && limitViolation.length() != 0 && !this.isFieldDate(c) && !this.isFieldBand(c)) {
                Aladin.error(c, limitViolation.toString());
                return;
            }
            ++index;
        }
        e = v.elements();
        StringBuffer p = null;
        StringBuffer p1 = null;
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            if (p == null) {
                p = new StringBuffer(Glu.quote(s));
                p1 = new StringBuffer(s);
                continue;
            }
            p.append(" " + Glu.quote(s));
            p1.append("/" + s);
        }
        String label = null;
        if (this.planeLabel == null) {
            label = this.aladinLabel;
        } else {
            String[] param = new String[vbis.size()];
            for (int i = 0; i < param.length; ++i) {
                s = (String)vbis.elementAt(i);
                if (s.equals("-")) {
                    s = "";
                }
                param[i] = s;
            }
            Glu cfr_ignored_0 = this.aladin.glu;
            label = Glu.dollarSet(this.dollarQuerySet(this.planeLabel), param, 2).trim();
        }
        URL u = null;
        if (this.flagTAPV2) {
            GluAdqlTemplate gluQueryTemplate = this.gluAdqlQueryTemplates.get(this.currentSelectedTapTable);
            String queryString = "";
            if (gluQueryTemplate != null) {
                queryString = gluQueryTemplate.getGluQuery(v, this.currentSelectedTapTable, this.adqlFunc, this.adqlFuncParams);
                queryString = "REQUEST=doQuery&LANG=ADQL&MAXREC=20000000&QUERY=" + queryString;
            }
            String url = (String)this.aladin.glu.aladinDic.get(this.gluTag);
            Aladin.trace(3, "URL for " + this.gluTag + " is: " + url);
            url = TapManager.getInstance(this.aladin).getSyncUrlUnEncoded(this, url, queryString);
            Aladin.trace(3, "getSyncUrlUnEncoded: " + url);
            this.aladin.glu.aladinDic.put(this.gluTag + "v1", url);
            u = this.aladin.glu.getURL(this.gluTag + "v1", p == null ? "" : p.toString(), true);
            Aladin.trace(3, "getURL u: " + u);
            try {
                u = this.addQueryEncodedUrl(u.toString());
                this.aladin.glu.aladinDic.put(this.gluTag + "v1", u.toString());
            }
            catch (Exception e1) {
                if (!flagDoIt) {
                    return;
                }
                Aladin.error(this, e1.getMessage());
                this.ball.setMode(3);
                return;
            }
        } else {
            u = this.aladin.glu.getURL(this.gluTag, p == null ? "" : p.toString());
        }
        if (!flagDoIt && this.flagTAP) {
            this.setInTap(u);
            return;
        }
        if (this.flagTAPV2) {
            this.setInTap(u);
        }
        if (this.system != null) {
            this.exec(label, p == null ? "" : p.toString());
            return;
        }
        if (flagScriptEquiv && !this.flagTAPV2) {
            String r = this.getRadius(false);
            r = r == null ? "" : " " + Coord.getUnit(ServerGlu.getRM(r) / 60.0);
            code = "get " + this.gluTag + (criteres.length() == 0 ? " " : "(" + criteres + ") ");
            this.aladin.targetHistory.add(this.getTarget());
            this.aladin.console.printCommand(code + this.getTarget() + r);
        }
        if (this.flagSIAIDHA) {
            block79: {
                try {
                    if (this.tree != null && !this.tree.isEmpty()) {
                        if (this.tree.nbSelected() > 0) {
                            if (!this.tooManyChecked()) {
                                this.tree.loadSelected();
                                this.tree.resetCb();
                            }
                        } else {
                            Aladin.error(this, this.WNEEDCHECK);
                        }
                        break block79;
                    }
                    this.waitCursor();
                    this.uT = u;
                    this.posT = new Coord(objet).toString();
                    this.thread = new Thread((Runnable)this, "AladinGluServerMetaData");
                    Util.decreasePriority(Thread.currentThread(), this.thread);
                    this.thread.start();
                    return;
                }
                catch (Exception e1) {
                    String message = e1.getMessage();
                    if (message == null) {
                        message = "unknown error";
                    }
                    Aladin.error(this, this.ERR + "\n[" + message + "]");
                    if (Aladin.levelTrace >= 3) {
                        e1.printStackTrace();
                    }
                    this.defaultCursor();
                    this.ball.setMode(2);
                }
            }
            return;
        }
        this.defaultCursor();
        if (this.flagTAPV2) {
            String url = (String)this.aladin.glu.aladinDic.get(this.gluTag);
            boolean isSync = this.sync_async.getSelectedItem().equals("SYNC");
            this.submitTapServerRequest(isSync, label, url, this.tap.getText());
        } else if (this.flagHiPS) {
            this.aladin.calque.newPlanBG(u, label, null, null);
        } else if (this.showSyncAsync > -1 && this.sync_async != null && this.sync_async.getSelectedItem().equals("ASYNC")) {
            this.fireASync(label, u);
        } else {
            this.lastPlan = this.aladin.calque.createPlan(u + "", label, "provided by " + this.institute, this);
        }
        if (code != null && this.lastPlan != null) {
            this.lastPlan.setBookmarkCode(code + " $TARGET $RADIUS");
        }
    }

    private void showFOV() {
        if (this.dataLinkSource != null && !this.dataLinkSource.isSetFootprint()) {
            this.cleanupFov = true;
            this.dataLinkSource.setFootprint(this.boundaryAreaStcs);
        }
        if (this.dataLinkSource != null && !this.dataLinkSource.isShowingFootprint()) {
            this.dataLinkSource.setShowFootprint(true, true);
        }
    }

    protected void cleanUpFOV() {
        if (this.dataLinkSource != null && this.dataLinkSource.isShowingFootprint()) {
            this.dataLinkSource.setShowFootprint(false, true);
        }
        if (this.dataLinkSource != null && this.cleanupFov) {
            this.dataLinkSource.resetFootprint();
        }
    }

    public StringBuffer processCustomFields(JComponent c, boolean takeAction) throws Exception {
        StringBuffer processedText = null;
        if (this.isFieldDate(c)) {
            if (this.date != null && this.modeDate == 8) {
                processedText = this.setDateInMJDFormat(takeAction, this.date.getText().trim(), this.rangeValues.get(3), " ");
            }
        } else if (this.isFieldBand(c) && this.band != null && this.modeBand == 1) {
            try {
                processedText = this.processSpectralBand(takeAction, this.band.getText().trim(), this.rangeValues.get(4));
            }
            catch (NumberFormatException e1) {
                throw new Exception("Error.." + e1.getMessage());
            }
            catch (Exception e1) {
                throw e1;
            }
        }
        return processedText;
    }

    private URL addQueryEncodedUrl(String url) throws UnsupportedEncodingException, MalformedURLException {
        URL u = null;
        try {
            int offset = url.indexOf("QUERY=");
            String adqlQueryUnEncoded = url.substring(offset + 6);
            String adqlQueryEncoded = URLEncoder.encode(adqlQueryUnEncoded, "utf-8");
            url = url.replace(adqlQueryUnEncoded, adqlQueryEncoded);
            this.aladin.glu.aladinDic.put(this.gluTag + "v1", url);
            u = new URL(url);
        }
        catch (UnsupportedEncodingException e1) {
            if (Aladin.levelTrace >= 3) {
                e1.printStackTrace();
            }
            throw e1;
        }
        catch (MalformedURLException e1) {
            if (Aladin.levelTrace >= 3) {
                e1.printStackTrace();
            }
            throw e1;
        }
        return u;
    }

    private void setInTap(URL u) {
        String s = u.toString();
        int offset = s.indexOf("QUERY=");
        s = s.substring(offset + 6);
        s = URLDecoder.decode(s);
        s = s.replace("FROM", "\n   FROM");
        s = s.replace("WHERE", "\n   WHERE");
        this.tap.setText(s);
    }

    private boolean exec(final String label, String params) {
        this.aladin.log("exec", this.gluTag);
        final String dir = this.dir;
        final String command = Util.concatDir(dir, this.getCommand(params));
        Aladin.trace(1, "Exec: " + (dir != null ? "cd " + dir + ";" : "") + command);
        try {
            new Thread(this.gluTag){

                @Override
                public void run() {
                    try {
                        Process p = Runtime.getRuntime().exec(command, null, dir == null ? null : new File(dir));
                        InputStream stdout = p.getInputStream();
                        ServerGlu.this.lastPlan = ServerGlu.this.aladin.calque.createPlan(stdout, label, "provided by " + ServerGlu.this.institute);
                    }
                    catch (Exception e1) {
                        String message = e1.getMessage();
                        if (message == null) {
                            message = "unknown error";
                        }
                        Aladin.error(ServerGlu.this.ERR + "\n[" + message + "]");
                        if (Aladin.levelTrace >= 3) {
                            e1.printStackTrace();
                        }
                        ServerGlu.this.defaultCursor();
                        ServerGlu.this.ball.setMode(2);
                    }
                }
            }.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private String getCommand(String params) {
        return this.aladin.glu.gluSystem(this.system, params);
    }

    private String dollarQuerySet(String template) {
        int i = template.indexOf("$query");
        if (this.target == null || i < 0) {
            return template;
        }
        String d = this.target.getText().trim();
        if (d.length() == 0) {
            d = this.getDefaultTarget();
        }
        return template.substring(0, i) + d + template.substring(i + 6);
    }

    @Override
    public void run() {
        URL u = this.uT;
        try {
            MyInputStream in = Util.openStream(u);
            this.updateMetaData(in, this, "", this.posT);
            this.aladin.dialog.show(this);
            this.defaultCursor();
            if (this.tree.isEmpty()) {
                this.ball.setMode(3);
            }
        }
        catch (Exception e1) {
            String message = e1.getMessage();
            if (message == null) {
                message = "unknown error";
            }
            Aladin.error(this, this.ERR + "\n[" + message + "]");
            if (Aladin.levelTrace >= 3) {
                e1.printStackTrace();
            }
            this.defaultCursor();
            this.ball.setMode(2);
        }
    }

    @Override
    protected MyInputStream getMetaData(String target, String radius, StringBuffer infoUrl) throws Exception {
        String s;
        if (this.resolveTarget(target) == null) {
            return null;
        }
        this.resolveRadius(radius, true);
        Vector<String> v = new Vector<String>(10);
        Enumeration e = this.vc.elements();
        while (e.hasMoreElements()) {
            Component c = (Component)e.nextElement();
            if (c instanceof JTextField) {
                s = ((JTextField)c).getText();
                v.addElement(s);
                continue;
            }
            if (!(c instanceof JComboBox)) continue;
            s = (String)((JComboBox)c).getSelectedItem();
            int j = s.indexOf(" - ");
            if (j > 0) {
                s = s.substring(0, j).trim();
            } else if (s.equals("?") || s.startsWith("-") && s.endsWith("-")) {
                s = "";
            }
            v.addElement(s);
        }
        e = v.elements();
        StringBuffer p = null;
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            if (p == null) {
                p = new StringBuffer(Glu.quote(s));
                continue;
            }
            p.append(" " + Glu.quote(s));
        }
        URL u = this.aladin.glu.getURL(this.gluTag, p.toString());
        infoUrl.append(u + "");
        if (this.type == 2) {
            return this.getMetaDataForCat(u);
        }
        return Util.openStream(u);
    }

    protected void majChoiceSize() {
        if (!this.majChoiceSize) {
            return;
        }
        Enumeration e = this.vc.elements();
        while (e.hasMoreElements()) {
            Component c = (Component)e.nextElement();
            if (!(c instanceof JComboBox)) continue;
            JComboBox choice = (JComboBox)c;
            int orgWidth = choice.getSize().width;
            if (orgWidth <= this.maxChoiceWidth) continue;
            choice.setSize(this.maxChoiceWidth, 30);
        }
        this.majChoiceSize = false;
    }

    @Override
    protected void reset() {
        if (this.tree != null) {
            this.tree.resetCb();
        }
        super.reset();
    }

    @Override
    protected void clear() {
        int j = 0;
        Component[] c = this.getComponents();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] instanceof JTextField) {
                if (this.vD != null && this.vD[j] != null) {
                    ((JTextField)c[i]).setText(this.vD[j]);
                } else {
                    ((JTextField)c[i]).setText("");
                }
                ++j;
                continue;
            }
            if (!(c[i] instanceof JComboBox)) continue;
            ((JComboBox)c[i]).setSelectedIndex(0);
            ++j;
        }
        if (this.tree != null) {
            this.tree.clear();
        }
        super.clear();
    }

    public void fireASync(String name, final URL url) {
        int requestNumber = -1;
        try {
            String[] pairs;
            final HashMap<String, String> requestParams = new HashMap<String, String>();
            String query = url.getQuery();
            for (String pair : pairs = query.split("&")) {
                int pairIndex = pair.indexOf("=");
                requestParams.put(URLDecoder.decode(pair.substring(0, pairIndex), "utf-8"), URLDecoder.decode(pair.substring(pairIndex + 1), "utf-8"));
            }
            Aladin.trace(3, "Firing async for " + name + " url: " + url + "\n requestParams: " + requestParams);
            this.aladin.initThreadPool();
            this.aladin.executor.execute(new Runnable(){

                @Override
                public void run() {
                    Thread currentT = Thread.currentThread();
                    String oldTName = currentT.getName();
                    currentT.setName("TsubmitAsync: " + url.toString());
                    try {
                        int index = url.toString().indexOf("?");
                        String urlString = url.toString().substring(0, index);
                        UWSFacade.fireAsync(ServerGlu.this.aladin, ServerGlu.this, ServerGlu.this.planeLabel, urlString, requestParams, -1);
                        currentT.setName(oldTName);
                    }
                    catch (Exception e) {
                        if (Aladin.levelTrace >= 3) {
                            e.printStackTrace();
                        }
                        ServerGlu.this.displayWarning(ServerGlu.this, -1, Aladin.getChaine().getString("GENERICERROR"));
                    }
                }
            });
        }
        catch (RejectedExecutionException ex) {
            this.displayWarning(this, -1, "Unable to submit\n Request overload! Please wait and try again.");
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            Aladin.error(this.aladin.dialog, "Server error!");
        }
    }

    @Override
    protected boolean updateWidgets() {
        if (this.flagTAP) {
            this.submit1(false, false);
        }
        return super.updateWidgets();
    }

    @Override
    public ADQLQuery checkQuery(Map<String, Object> requestParams) throws UnresolvedIdentifiersException {
        ADQLQuery result = null;
        try {
            result = super.checkQuery(requestParams);
        }
        catch (UnresolvedIdentifiersException uie) {
            Aladin.trace(3, "Number of errors in the query:" + uie.getNbErrors());
            Iterator<ParseException> it = uie.getErrors();
            ParseException ex = null;
            while (it.hasNext()) {
                ex = it.next();
                this.highlightQueryError(this.tap.getHighlighter(), ex);
            }
            throw uie;
        }
        return result;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action;
        Object o = e.getSource();
        if (o instanceof JButton && (action = ((JButton)o).getActionCommand()).equals(this.HELP)) {
            if (this.docUser.startsWith("http://")) {
                this.aladin.glu.showDocument("Http", this.docUser, true);
            } else {
                this.aladin.glu.showDocument(this.docUser, "");
            }
            return;
        }
        if (this.flagTAPV2) {
            if (o instanceof JButton) {
                TapManager tapManager = TapManager.getInstance(this.aladin);
                String action2 = ((JButton)o).getActionCommand();
                if (action2.equals("CHECKQUERY")) {
                    this.submit1(false, true);
                    if (!this.ball.isRed()) {
                        this.checkQueryFlagMessage();
                    }
                } else if (action2.equals("CHANGESERVER")) {
                    try {
                        tapManager.showTapRegistryForm();
                    }
                    catch (Exception e1) {
                        Aladin.error(this, this.GENERICERROR);
                        this.ball.setMode(3);
                    }
                } else if (action2.equals("SHOWAYNCJOBS")) {
                    try {
                        UWSFacade.getInstance(this.aladin).showAsyncPanel();
                    }
                    catch (Exception e1) {
                        Aladin.error(this, this.GENERICERROR);
                        this.ball.setMode(3);
                    }
                }
            } else if (o instanceof JComboBox && (action = ((JComboBox)o).getActionCommand()).equals("TABLECHANGED")) {
                String tableSelected = (String)((JComboBox)o).getSelectedItem();
                this.changeTapTable(tableSelected);
            }
        } else if (this.flagTAP) {
            this.updateWidgets();
        }
        super.actionPerformed(e);
    }

    public SMoc getPosBounds() {
        return this.posBounds;
    }

    public void setPosBounds(SMoc posBounds) {
        this.posBounds = posBounds;
    }

    public Map<String, GluAdqlTemplate> getGluAdqlQueryTemplates() {
        return this.gluAdqlQueryTemplates;
    }

    public void setGluAdqlQueryTemplates(Map<String, GluAdqlTemplate> gluAdqlQueryTemplates) {
        this.gluAdqlQueryTemplates = gluAdqlQueryTemplates;
    }

    public String getCurrentSelectedTapTable() {
        return this.currentSelectedTapTable;
    }

    public void setCurrentSelectedTapTable(String currentSelectedTapTable) {
        this.currentSelectedTapTable = currentSelectedTapTable;
    }

    public Hashtable<String, String> getAdqlFunc() {
        return this.adqlFunc;
    }

    public void setAdqlFunc(Hashtable<String, String> adqlFunc) {
        this.adqlFunc = adqlFunc;
    }

    public Hashtable<String, String> getAdqlFuncParams() {
        return this.adqlFuncParams;
    }

    public void setAdqlFuncParams(Hashtable<String, String> adqlFuncParams) {
        this.adqlFuncParams = adqlFuncParams;
    }

    public String getBoundaryAreaStcs() {
        return this.boundaryAreaStcs;
    }

    public void setBoundaryAreaStcs(String boundaryAreaStcs) {
        this.boundaryAreaStcs = boundaryAreaStcs;
    }

    public Source getDataLinkSource() {
        return this.dataLinkSource;
    }

    public void setDataLinkSource(Source dataLinkSource) {
        this.dataLinkSource = dataLinkSource;
    }
}

