/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.CanvasColorMap;
import cds.aladin.Cercle;
import cds.aladin.Coord;
import cds.aladin.Cote;
import cds.aladin.FrameHeaderFits;
import cds.aladin.IDHAGenerator;
import cds.aladin.Legende;
import cds.aladin.Ligne;
import cds.aladin.MetaDataTree;
import cds.aladin.MyByteArrayStream;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanBGCat;
import cds.aladin.PlanBGCube;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanFilter;
import cds.aladin.PlanFolder;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageAlgo;
import cds.aladin.PlanImageMosaic;
import cds.aladin.PlanImageRGB;
import cds.aladin.PlanImageResamp;
import cds.aladin.PlanMoc;
import cds.aladin.PlanSTMoc;
import cds.aladin.PlanTMoc;
import cds.aladin.PlanTool;
import cds.aladin.Position;
import cds.aladin.Projection;
import cds.aladin.Repere;
import cds.aladin.ResourceNode;
import cds.aladin.Save;
import cds.aladin.Server;
import cds.aladin.ServerDialog;
import cds.aladin.ServerFoV;
import cds.aladin.Source;
import cds.aladin.SourceStat;
import cds.aladin.Tag;
import cds.aladin.Tok;
import cds.aladin.TreeObjDir;
import cds.aladin.ViewMemoItem;
import cds.moc.SMoc;
import cds.moc.STMoc;
import cds.moc.TMoc;
import cds.tools.Util;
import cds.xml.Field;
import cds.xml.XMLConsumer;
import cds.xml.XMLParser;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.image.ColorModel;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ServerFile
extends Server
implements XMLConsumer {
    String BROWSE;
    JTextField file;
    static String loadError;
    String titre;
    String info1;
    String info2;
    String info3;
    private Coord circleCenter;
    String of = "";
    private static final String DEFAULT_FILENAME = "-";
    private boolean inValue;
    private boolean inFilterScript;
    private boolean inFitsHeader;
    private boolean inFilter;
    private int nFilter = 0;
    private Vector vField;
    private Legende leg = null;
    private Plan plan = null;
    private ViewMemoItem vmi;
    private int firstView;
    private double ra = 0.0;
    private double de = 0.0;
    private double rm = 0.0;
    private int proj = 0;
    private int typePlan = -1;
    private boolean flagCatalogSource = false;
    private String rec;
    private Obj prevO = null;
    private boolean prevFlagSuite = false;
    private Vector pdf = null;
    private MyByteArrayStream inMoc = null;
    byte[] rgb = null;
    int pOffset = 0;
    Hashtable pFilter;
    static final int CATALOGTOOL = 1000;
    static final int AJTOOL = 1001;

    @Override
    protected void createChaine() {
        super.createChaine();
        this.description = Aladin.chaine.getString("FILEINFO");
        this.titre = Aladin.chaine.getString("FILETITLE");
        this.verboseDescr = Aladin.chaine.getString("FILEDESC");
        this.info1 = Aladin.chaine.getString("FILEINFO1");
        this.info2 = Aladin.chaine.getString("FILEINFO2");
        this.info3 = Aladin.chaine.getString("FILEINFO3");
        this.BROWSE = Aladin.chaine.getString("FILEBROWSE");
    }

    protected void init() {
        this.type = 8;
        this.aladinLogo = "MyDataLogo.gif";
        this.aladinLabel = "file";
    }

    protected ServerFile(Aladin aladin) {
        this.aladin = aladin;
        this.createChaine();
        this.init();
        this.setBackground(Aladin.BLUE);
        this.setLayout(null);
        this.setFont(Aladin.PLAIN);
        int y = 45;
        JPanel tp = new JPanel();
        tp.setBackground(Aladin.BLUE);
        Dimension d = this.makeTitle(tp, this.titre);
        tp.setBounds(235 - d.width / 2, y, d.width, d.height);
        this.add(tp);
        JLabel l = new JLabel(this.info1 + " " + (Aladin.STANDALONE ? this.info2 + " " : "") + this.info3);
        l.setBounds(20, y += d.height + 10, 400, 20);
        y += 20;
        this.add(l);
        this.file = new JTextField(50);
        this.file.addKeyListener(this);
        int wpos = 60;
        int xpos = XWIDTH - 10 - wpos;
        this.file.setBounds(10, y, xpos - 15, HAUT);
        this.add(this.file);
        if (Aladin.STANDALONE) {
            JButton browse = new JButton(this.BROWSE);
            browse.setMargin(new Insets(0, 0, 0, 0));
            browse.addActionListener(this);
            browse.setBounds(xpos, y + 1, wpos, 24);
            y += 40;
            this.add(browse);
        } else {
            y += 40;
        }
        this.tree = new MetaDataTree(aladin, null);
        JScrollPane sc = new JScrollPane(this.tree);
        this.tree.setScroll(sc);
        sc.setBackground(this.tree.bkgColor);
        sc.setBounds(10, y, XWIDTH - 20, 230);
        y += 230;
        this.add(sc);
        this.setMaxComp(sc);
    }

    @Override
    protected boolean is(String s) {
        if (s.equalsIgnoreCase("Local") || s.equalsIgnoreCase("MyData") || s.equalsIgnoreCase("File")) {
            return true;
        }
        return super.is(s);
    }

    @Override
    protected int createPlane(String target, String radius, String criteria, String label, String origin) {
        String m;
        int i;
        String f = criteria;
        Tok st = new Tok(criteria, " ,");
        f = st.nextToken();
        if (st.hasMoreTokens()) {
            label = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            origin = st.nextToken();
        }
        if ((i = f.lastIndexOf(32)) > 0 && ((m = f.substring(i + 1).toLowerCase()).startsWith("image/") || m.startsWith("text/"))) {
            f = f.substring(0, i);
        }
        return this.creatLocalPlane(f, label, origin, null, null, null, this, target, radius);
    }

    private String getNameWithoutBrackets(String s) {
        if (s == null) {
            return null;
        }
        int n = s.length();
        if (n < 4 || s.charAt(n - 1) != ']') {
            return s;
        }
        int pos = s.lastIndexOf(91);
        if (pos < 0) {
            return s;
        }
        try {
            n = Integer.parseInt(s.substring(pos + 1, n - 1));
            return s.substring(0, pos);
        }
        catch (Exception e) {
            return s;
        }
    }

    private String getLabelFromFile(String f) {
        if (f == null) {
            return "Data";
        }
        int i = f.lastIndexOf(f.startsWith("http:") || f.startsWith("https:") || f.startsWith("ftp:") ? "/" : Util.FS);
        String label = i >= 0 ? f.substring(i + 1) : f;
        if ((i = label.lastIndexOf(46)) > 0 && label.length() - i <= 5) {
            label = label.substring(0, i);
        }
        return label;
    }

    protected int creatLocalPlane(String f, String label, String origin, Obj o, ResourceNode resNode, InputStream is, Server server, String target, String radius) {
        return this.creatLocalPlane(f, label, origin, o, resNode, is, server, target, radius, null, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int creatLocalPlane(String f, String label, String origin, Obj o, ResourceNode resNode, InputStream is, Server server, String target, String radius, URL url, String query, int requestId) {
        String serverTaskId = this.aladin.synchroServer.start("ServerFile.creatLocalPlane/" + label);
        try {
            long type;
            boolean localFile;
            URL u;
            MyInputStream in;
            int n;
            block85: {
                n = 0;
                in = null;
                u = null;
                localFile = false;
                if (f != null) {
                    f = this.aladin.getFullFileName(f);
                }
                this.waitCursor();
                try {
                    label = this.getDefaultLabelIfRequired(label, this.getLabelFromFile(f));
                    if (is != null || f.startsWith("http:") || f.startsWith("https:")) break block85;
                    try {
                        final File x = new File(f);
                        if (!x.isDirectory()) break block85;
                        Aladin.trace(4, "ServerFile.creatLocalPlane(" + f + "...) => detect: DIR");
                        if (PlanBG.isPlanBG(f)) {
                            TreeObjDir gSky = null;
                            try {
                                gSky = new TreeObjDir(this.aladin, f);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            if (gSky == null) {
                                if (PlanBG.isPlanHpxFinder(f)) {
                                    gSky = new TreeObjDir(this.aladin, null, null, null, null, null, null, null, null, null, null, null, f, "15 progen", null);
                                } else if (new File(f + "/" + "metadata.xml").exists() || new File(f + "/Norder3/Allsky.xml").exists()) {
                                    gSky = new TreeObjDir(this.aladin, null, null, null, null, null, null, null, null, null, null, null, f, "15 cat", null);
                                }
                            }
                            n = gSky != null ? this.aladin.calque.newPlanBG(gSky, label, target, radius) : this.aladin.calque.newPlanBG(f, label, target, radius);
                        } else {
                            final ServerFile th = this;
                            new Thread(){

                                @Override
                                public void run() {
                                    try {
                                        ServerFile.this.aladin.log("load", "dir");
                                        MyInputStream mi = new MyInputStream(new IDHAGenerator().getStream(x, th));
                                        ServerFile.this.updateMetaData(mi, th, "", null);
                                        mi.close();
                                    }
                                    catch (IOException e) {
                                        e.printStackTrace();
                                    }
                                    ServerFile.this.defaultCursor();
                                }
                            }.start();
                        }
                        int th = n;
                        return th;
                    }
                    catch (Exception e) {
                        this.defaultCursor();
                        e.printStackTrace();
                        int th = n;
                        return th;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Aladin.error(this, "" + e, 1);
                    this.defaultCursor();
                    this.ball.setMode(3);
                    int n2 = -1;
                    return n2;
                }
            }
            if (origin == null) {
                origin = f;
            }
            String mode = is == null ? "file" : "stream";
            this.flagVerif = false;
            this.verif(0, null, null, null);
            if (f != null && f.startsWith("file:")) {
                f = f.replaceAll("\\\\", "/");
            }
            if (is == null && (f.startsWith("http:") || f.startsWith("https:"))) {
                block86: {
                    u = this.aladin.glu.getURL("Http", this.getNameWithoutBrackets(f), true, true);
                    try {
                        in = Util.openStream(u);
                    }
                    catch (Exception e) {
                        if (Aladin.levelTrace < 3) break block86;
                        e.printStackTrace();
                    }
                }
                mode = "http";
            } else if (is == null && f.indexOf("ftp://") >= 0) {
                u = new URL(this.getNameWithoutBrackets(f));
                in = Util.openStream(u);
                mode = "ftp";
            } else if (is == null && f.startsWith("file:/")) {
                localFile = true;
                u = new URL(this.getNameWithoutBrackets(f));
                in = Util.openStream(u);
                mode = "file";
            } else if (is == null) {
                localFile = true;
                Aladin.trace(3, "Opening " + this.getNameWithoutBrackets(f));
                in = new MyInputStream(new FileInputStream(this.getNameWithoutBrackets(f)));
            } else {
                in = is instanceof MyInputStream ? (MyInputStream)is : new MyInputStream(is);
            }
            if (in != null) {
                in = in.startRead();
                type = in.getType();
            } else {
                type = 0L;
            }
            if (f != null && f.endsWith(".ajs")) {
                type |= 0x400L;
            }
            if (f != null && f.endsWith(".reg")) {
                type |= 0x400L;
            }
            String t = MyInputStream.decodeType(type);
            Aladin.trace(3, (f == null ? "stream" : f) + " => detect: " + t);
            this.aladin.log("load", mode + t);
            if ((type & 0x2000000000L) != 0L) {
                this.aladin.calque.newPlanTool(null);
            }
            if ((type & 0x8400L) != 0L) {
                this.aladin.command.readFromStream(in);
            } else if ((type & 0x200L) != 0L) {
                n = this.loadAJ(in) ? 1 : 0;
            } else if ((type & 0x10000000000L) != 0L) {
                n = this.loadTool(in, label) ? 1 : 0;
            } else if ((type & 0x800L) != 0L) {
                n = this.updateMetaData(in, server, "", null) ? 1 : 0;
            } else if ((type & 0x1000000000L) != 0L) {
                n = this.aladin.calque.newPlanMOC(in, label);
            } else if ((type & 0x4000000000000L) != 0L) {
                n = this.aladin.calque.newPlanTMOC(in, label);
            } else if ((type & 0x8000000000000L) != 0L) {
                n = this.aladin.calque.newPlanSTMOC(in, label);
            } else if ((type & 1L) != 0L && (type & 0x200000L) != 0L) {
                n = u != null ? this.aladin.calque.newPlanImageRGB(u, in, 2, label, null, f, origin, 0, 0, null, resNode) : this.aladin.calque.newPlanImageRGB(f, null, in, resNode);
            } else if ((type & 0x100000000L) != 0L) {
                n = this.aladin.calque.newPlanHealpix(f, in, label, 0, 0, false, target, radius);
            } else if ((type & 0x20000L) != 0L) {
                this.aladin.calque.newFitsExt(f, in, label, o, target, radius);
                n = 1;
            } else if ((type & 0x800000001L) != 0L) {
                n = u != null ? this.aladin.calque.newPlanImage(u, in, 2, label, null, f, origin, 0, 0, o, resNode) : this.aladin.calque.newPlanImage(f, in, label, origin, o, resNode);
            } else if ((type & 0x80000L) != 0L) {
                boolean newPlane;
                n = this.aladin.processFovVOTable(in, null, true);
                boolean bl = newPlane = n >= 0;
                if (!newPlane) {
                    n = -2;
                    this.aladin.dialog.setCurrent(ServerDialog.FIELD);
                    ((ServerFoV)this.aladin.dialog.server[ServerDialog.FIELD]).selectFOV(ServerFoV.idLastRegistered);
                }
            } else if ((type & 0x1000000000000L) != 0L && this.aladin.mesure.activeDataLinkWord != null) {
                this.aladin.mesure.showAssociatedDatalinks(f, o);
            } else if ((type & 0x20402180L) != 0L) {
                n = u != null ? this.aladin.calque.newPlanCatalog(u, in, label, "", f, null, server) : (f != null ? this.aladin.calque.newPlanCatalog(f, in) : this.aladin.calque.newPlanCatalog(in, label, origin, server, url, query, requestId));
            } else if ((type & MyInputStream.NativeImage()) != 0L) {
                n = u != null ? this.aladin.calque.newPlanImageColor(u, in, 2, label, null, f, origin, 0, 0, o, resNode) : this.aladin.calque.newPlanImageColor(f, null, in, resNode);
            } else if ((type & 0x200000000L) != 0L) {
                if (this.aladin.glu.loadGluDic(new DataInputStream(in), false, localFile)) {
                    this.aladin.glu.reload(false, true);
                    n = 1;
                }
            } else if ((type & 0x100000000000L) != 0L) {
                int i;
                String path = null;
                int n3 = i = f == null ? -1 : f.lastIndexOf("properties");
                if (i > 0) {
                    path = f.substring(0, i - 1);
                }
                if (this.aladin.directory.addHipsProp(new InputStreamReader(in), true, path)) {
                    n = 1;
                }
            } else {
                if (!mode.equals("http") || f == null || f.indexOf(63) >= 0) throw new Exception("Data format not recognized");
                TreeObjDir gSky = null;
                try {
                    gSky = new TreeObjDir(this.aladin, f);
                }
                catch (Exception e) {
                    Aladin.trace(3, "ServerFile.creatLocalPlane(...) HiPS properties file not found => autodiscovery");
                }
                if (gSky != null) {
                    n = this.aladin.calque.newPlanBG(gSky, label, null, null);
                } else if (Util.isUrlResponding(new URL(f + "/Norder3/Allsky.jpg")) || Util.isUrlResponding(new URL(f + "/Norder3/Allsky.fits")) || Util.isUrlResponding(new URL(f + "/Norder3/Allsky.png"))) {
                    n = this.aladin.calque.newPlanBG(new URL(f), label, null, null);
                } else if (f.endsWith("HpxFinder") || f.endsWith("HpxFinder/")) {
                    gSky = new TreeObjDir(this.aladin, null, null, null, f, null, null, null, null, null, null, null, null, "15 progen", null);
                    n = this.aladin.calque.newPlanBG(gSky, label, null, null);
                } else {
                    if (!Util.isUrlResponding(new URL(f + "/metadata.xml")) && !Util.isUrlResponding(new URL(f + "/Norder3/Allsky.xml"))) throw new Exception("Data format not recognized");
                    gSky = new TreeObjDir(this.aladin, null, null, null, f, null, null, null, null, null, null, null, null, "15 cat", null);
                    n = this.aladin.calque.newPlanBG(gSky, label, null, null);
                }
            }
            this.aladin.endMsg();
            if ((type & 0x800L) != 0L) {
                this.aladin.dialog.show();
                this.aladin.dialog.setCurrent(this.aladinLabel);
            }
            this.defaultCursor();
            if (n > 0 && (f != null || u != null)) {
                this.aladin.memoLastFile(f != null ? f : u.toString());
            }
            int n4 = n;
            return n4;
        }
        finally {
            this.aladin.synchroServer.stop(serverTaskId);
        }
    }

    @Override
    protected void setInitialFocus() {
        this.file.requestFocus();
        this.file.setCaretPosition(this.file.getText().length());
    }

    @Override
    public void submit() {
        this.waitCursor();
        String f = this.file.getText().trim();
        if (!f.startsWith("\"")) {
            f = Tok.quote(f, true);
        }
        Tok tok = new Tok(f, " ");
        while (tok.hasMoreTokens()) {
            f = tok.nextToken();
            if (!(f = this.aladin.getFullFileName(f)).equals(this.of)) {
                this.tree.clear();
            }
            this.of = f;
            if (this.tree != null && !this.tree.isEmpty()) {
                if (this.tree.nbSelected() > 0) {
                    if (!this.tooManyChecked()) {
                        this.tree.loadSelected();
                        this.tree.resetCb();
                    }
                } else {
                    Aladin.error(this, this.WNEEDCHECK);
                }
                this.defaultCursor();
                continue;
            }
            String code = "load " + f;
            this.aladin.console.printCommand(code);
            int n = this.creatLocalPlane(f, null, null, null, null, null, this, null, null);
            if (n == -1) continue;
            this.aladin.calque.getPlan(n).setBookmarkCode(code);
        }
    }

    @Override
    protected void clear() {
        this.file.setText("");
        this.tree.clear();
        super.clear();
    }

    @Override
    protected void reset() {
        if (this.tree != null) {
            this.tree.resetCb();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object s = e.getSource();
        if (s instanceof JButton && ((JButton)s).getActionCommand().equals(this.BROWSE)) {
            this.browseFile();
            return;
        }
        super.actionPerformed(e);
    }

    protected void browseFile() {
        File f;
        String path = Util.dirBrowser(this.description, this.aladin.getDefaultDirectory(), this.file, 2);
        if (path == null) {
            return;
        }
        String dir = path;
        int offset = path.indexOf(" ");
        if (offset > 0) {
            Tok tok = new Tok(path, " ");
            dir = tok.nextToken();
        }
        if (!(f = new File(dir)).isDirectory()) {
            dir = f.getParent();
        }
        this.aladin.memoDefaultDirectory(dir);
        this.submit();
    }

    protected boolean loadAJ(MyInputStream in) {
        boolean rep;
        XMLParser xmlParser = new XMLParser(this);
        loadError = null;
        try {
            rep = xmlParser.parse(in);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            loadError = "" + e;
            return false;
        }
        if (!rep) {
            loadError = xmlParser.getError();
        }
        this.aladin.view.findBestDefault();
        this.aladin.view.setDefaultRepere();
        this.aladin.calque.repaintAll();
        return rep && loadError == null;
    }

    protected boolean loadTool(MyInputStream in, String label) {
        this.plan = new PlanTool(this.aladin);
        this.inValue = true;
        this.typePlan = 1001;
        boolean rep = this.loadAJ(in);
        if (rep) {
            this.plan.setLabel(label);
            this.endElement("PLANE");
        }
        return rep;
    }

    private ViewMemoItem creatViewMemoItemByAJ(Hashtable atts) {
        ViewMemoItem vmi = new ViewMemoItem();
        String s = (String)atts.get("zoom");
        if (s != null) {
            vmi.zoom = Double.valueOf(s);
        }
        if ((s = (String)atts.get("jdMin")) != null) {
            vmi.jdmin = Double.valueOf(s);
        }
        if ((s = (String)atts.get("jdMax")) != null) {
            vmi.jdmax = Double.valueOf(s);
        }
        if ((s = (String)atts.get("xzoomView")) != null) {
            vmi.xzoomView = Double.valueOf(s);
        }
        if ((s = (String)atts.get("yzoomView")) != null) {
            vmi.yzoomView = Double.valueOf(s);
        }
        if ((s = (String)atts.get("rzoomWidth")) != null) {
            vmi.rzoomWidth = Double.valueOf(s);
        }
        if ((s = (String)atts.get("rzoomHeight")) != null) {
            vmi.rzoomHeight = Double.valueOf(s);
        }
        if ((s = (String)atts.get("rvWidth")) != null) {
            vmi.rvWidth = Integer.parseInt(s);
        }
        if ((s = (String)atts.get("rvHeight")) != null) {
            vmi.rvHeight = Integer.parseInt(s);
        }
        if ((s = (String)atts.get("pref")) != null) {
            vmi.pref = this.aladin.calque.getPlan(s, 1);
        }
        if ((s = (String)atts.get("roi")) != null || (s = (String)atts.get("locked")) != null) {
            vmi.locked = new Boolean(s);
        }
        if ((s = (String)atts.get("northUp")) != null) {
            vmi.northUp = new Boolean(s);
        }
        return vmi;
    }

    private Plan creatPlaneByAJ(Hashtable atts) {
        String s;
        String type = (String)atts.get("type");
        this.typePlan = Util.indexInArrayOf(type, Plan.Tp);
        this.inFilterScript = false;
        this.inFitsHeader = false;
        this.inFilter = false;
        switch (this.typePlan) {
            case 12: {
                PlanCatalog p = null;
                s = (String)atts.get("dedicatedto");
                if (s != null) {
                    p = (PlanCatalog)this.aladin.calque.getPlan(s, 1);
                }
                this.plan = new PlanFilter(this.aladin, "", null, p);
                break;
            }
            case 11: {
                this.plan = new PlanFolder(this.aladin);
                s = (String)atts.get("localscope");
                if (s == null) break;
                ((PlanFolder)this.plan).localScope = new Boolean(s);
                break;
            }
            case 8: {
                int sourceType;
                this.plan = new PlanCatalog(this.aladin);
                s = (String)atts.get("object");
                if (s != null) {
                    this.plan.objet = s;
                }
                if ((s = (String)atts.get("param")) != null) {
                    this.plan.param = s + ".";
                }
                if ((s = (String)atts.get("from")) != null) {
                    this.plan.copyright = s;
                }
                if ((s = (String)atts.get("RA")) != null) {
                    this.ra = Double.valueOf(s);
                }
                if ((s = (String)atts.get("DE")) != null) {
                    this.de = Double.valueOf(s);
                }
                if ((s = (String)atts.get("radius")) != null) {
                    this.rm = Double.valueOf(s);
                }
                if ((s = (String)atts.get("color")) != null) {
                    this.plan.c = Action.getColor(s);
                }
                if ((s = (String)atts.get("shape")) != null && (sourceType = Util.indexInArrayOf(s, Source.TYPENAME, true)) != -1) {
                    this.plan.sourceType = sourceType;
                }
                if ((s = (String)atts.get("nopos")) == null) break;
                ((PlanTool)this.plan).hasNoPos = new Boolean(s);
                break;
            }
            case 9: 
            case 10: {
                this.plan = new PlanTool(this.aladin);
                s = (String)atts.get("color");
                if (s != null) {
                    this.plan.c = Action.getColor(s);
                }
                if ((s = (String)atts.get("withsource")) != null) {
                    this.flagCatalogSource = true;
                }
                if ((s = (String)atts.get("xylock")) == null) break;
                ((PlanTool)this.plan).hasXYorig = new Boolean(s);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 16: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: {
                boolean hasOrigPixel;
                boolean bl = hasOrigPixel = atts.get("cacheID") != null;
                if (this.typePlan == 1) {
                    this.plan = new PlanImage(this.aladin);
                } else if (this.typePlan == 16) {
                    this.plan = new PlanBG(this.aladin);
                } else if (this.typePlan == 18) {
                    this.plan = new PlanBGCat(this.aladin);
                } else if (this.typePlan == 22) {
                    this.plan = new PlanBGCube(this.aladin);
                } else if (this.typePlan == 19) {
                    this.plan = new PlanMoc(this.aladin);
                } else if (this.typePlan == 23) {
                    this.plan = new PlanTMoc(this.aladin);
                } else if (this.typePlan == 24) {
                    this.plan = new PlanSTMoc(this.aladin);
                } else if (this.typePlan == 6) {
                    this.plan = new PlanImageMosaic(this.aladin);
                } else if (this.typePlan == 5) {
                    this.plan = new PlanImageResamp(this.aladin);
                } else if (this.typePlan == 7) {
                    this.plan = new PlanImageAlgo(this.aladin);
                } else if (this.typePlan == 2) {
                    this.plan = new PlanImageRGB(this.aladin);
                    ((PlanImageRGB)this.plan).RGBControl = new int[9];
                }
                if (this.plan instanceof PlanBG) {
                    PlanBG pbg = (PlanBG)this.plan;
                    s = (String)atts.get("hipsgluTag");
                    if (s != null) {
                        pbg.gluTag = s;
                    }
                    if ((s = (String)atts.get("hipssurvey")) != null) {
                        pbg.survey = s;
                    }
                    if ((s = (String)atts.get("hipsurl")) != null) {
                        pbg.url = s;
                    }
                    if ((s = (String)atts.get("hipsminOrder")) != null) {
                        pbg.minOrder = Integer.parseInt(s);
                    }
                    if ((s = (String)atts.get("hipsmaxOrder")) != null) {
                        pbg.maxOrder = Integer.parseInt(s);
                    }
                    if ((s = (String)atts.get("hipscube")) != null) {
                        pbg.cube = new Boolean(s);
                    }
                    if ((s = (String)atts.get("hipscolor")) != null) {
                        pbg.color = new Boolean(s);
                    }
                    if ((s = (String)atts.get("hipscolorPNG")) != null) {
                        pbg.colorPNG = new Boolean(s);
                    }
                    if ((s = (String)atts.get("hipscolorUnknown")) != null) {
                        pbg.colorUnknown = new Boolean(s);
                    }
                    if ((s = (String)atts.get("hipsfitsGzipped")) != null) {
                        pbg.fitsGzipped = new Boolean(s);
                    }
                    if ((s = (String)atts.get("hipstruePixels")) != null) {
                        pbg.truePixels = new Boolean(s);
                    }
                    if ((s = (String)atts.get("hipsinFits")) != null) {
                        pbg.inFits = new Boolean(s);
                    }
                    if ((s = (String)atts.get("hipsinJPEG")) != null) {
                        pbg.inJPEG = new Boolean(s);
                    }
                    if ((s = (String)atts.get("hipsinPNG")) != null) {
                        pbg.inPNG = new Boolean(s);
                    }
                    if ((s = (String)atts.get("hipshasMoc")) != null) {
                        pbg.hasMoc = new Boolean(s);
                    }
                    if ((s = (String)atts.get("hipshasHpxFinder")) != null) {
                        pbg.hasHpxFinder = new Boolean(s);
                    }
                    if ((s = (String)atts.get("hipsbody")) != null) {
                        pbg.body = s;
                    }
                    if ((s = (String)atts.get("hipsframeOrigin")) != null) {
                        pbg.frameOrigin = Integer.parseInt(s);
                    }
                    if ((s = (String)atts.get("hipsframeDrawing")) != null) {
                        pbg.frameDrawing = Integer.parseInt(s);
                    }
                    if ((s = (String)atts.get("hipslive")) != null) {
                        pbg.live = new Boolean(s);
                    }
                    if ((s = (String)atts.get("hipspixelCut")) != null) {
                        pbg.pixelCut = s;
                    }
                    if ((s = (String)atts.get("hipstransferFct4Fits")) != null) {
                        pbg.transferFct4Fits = Integer.parseInt(s);
                    }
                    if ((s = (String)atts.get("hipstransferFct4Preview")) != null) {
                        pbg.transferFct4Preview = Integer.parseInt(s);
                    }
                    if ((s = (String)atts.get("hipstrahipstileOrdernsferFct4Preview")) != null) {
                        pbg.tileOrder = Integer.parseInt(s);
                    }
                    if (this.plan instanceof PlanBGCube && (s = (String)atts.get("hipsdepth")) != null) {
                        ((PlanBGCube)pbg).depth = Integer.parseInt(s);
                    }
                }
                if ((s = (String)atts.get("object")) != null) {
                    this.plan.objet = s;
                }
                PlanImage pi = (PlanImage)this.plan;
                s = (String)atts.get("param");
                if (s != null) {
                    this.plan.param = s + ".";
                }
                if ((s = (String)atts.get("fmt")) != null) {
                    pi.fmt = PlanImage.getFmt(s);
                }
                if ((s = (String)atts.get("resolution")) != null) {
                    pi.res = PlanImage.getRes(s);
                }
                if ((s = (String)atts.get("from")) != null) {
                    this.plan.copyright = s;
                }
                if ((s = (String)atts.get("cacheID")) != null) {
                    pi.cacheID = s;
                }
                if ((s = (String)atts.get("cacheOffset")) != null) {
                    pi.cacheOffset = Long.parseLong(s);
                }
                if ((s = (String)atts.get("url")) != null) {
                    try {
                        this.plan.u = new URL(s);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if ((s = (String)atts.get("RA")) != null) {
                    this.ra = Double.valueOf(s);
                }
                if ((s = (String)atts.get("DE")) != null) {
                    this.de = Double.valueOf(s);
                }
                if ((s = (String)atts.get("radius")) != null) {
                    this.rm = Double.valueOf(s);
                }
                if ((s = (String)atts.get("color")) != null) {
                    this.plan.c = Action.getColor(s);
                }
                pi.transfertFct = 3;
                pi.bScale = 1.0;
                pi.bitpix = 8;
                pi.npix = 1;
                pi.typeCM = 0;
                s = (String)atts.get("width");
                if (s != null) {
                    pi.naxis1 = pi.width = Integer.parseInt(s);
                }
                if ((s = (String)atts.get("height")) != null) {
                    pi.naxis2 = pi.height = Integer.parseInt(s);
                }
                if ((s = (String)atts.get("video")) != null) {
                    pi.video = Integer.parseInt(s);
                }
                if ((s = (String)atts.get("transfertFct")) != null) {
                    pi.transfertFct = Integer.parseInt(s);
                }
                if ((s = (String)atts.get("minPix")) != null) {
                    pi.dataMin = Double.valueOf(s);
                }
                if ((s = (String)atts.get("maxPix")) != null) {
                    pi.dataMax = Double.valueOf(s);
                }
                if ((s = (String)atts.get("minPixCut")) != null) {
                    pi.pixelMin = Double.valueOf(s);
                }
                if ((s = (String)atts.get("maxPixCut")) != null) {
                    pi.pixelMax = Double.valueOf(s);
                }
                if ((s = (String)atts.get("bZero")) != null) {
                    pi.bZero = Double.valueOf(s);
                }
                if ((s = (String)atts.get("bScale")) != null) {
                    pi.bScale = Double.valueOf(s);
                }
                if ((s = (String)atts.get("cm")) != null) {
                    pi.typeCM = Integer.parseInt(s);
                }
                if ((s = (String)atts.get("colormap1")) != null) {
                    pi.cmControl[0] = Integer.parseInt(s);
                }
                if ((s = (String)atts.get("colormap2")) != null) {
                    pi.cmControl[1] = Integer.parseInt(s);
                }
                if ((s = (String)atts.get("colormap3")) != null) {
                    pi.cmControl[2] = Integer.parseInt(s);
                }
                if ((s = (String)atts.get("RGBControl1")) != null) {
                    ((PlanImageRGB)pi).RGBControl[0] = Integer.parseInt(s);
                }
                if ((s = (String)atts.get("RGBControl2")) != null) {
                    ((PlanImageRGB)pi).RGBControl[1] = Integer.parseInt(s);
                }
                if ((s = (String)atts.get("RGBControl3")) != null) {
                    ((PlanImageRGB)pi).RGBControl[2] = Integer.parseInt(s);
                }
                if ((s = (String)atts.get("RGBControl4")) != null) {
                    ((PlanImageRGB)pi).RGBControl[3] = Integer.parseInt(s);
                }
                if ((s = (String)atts.get("RGBControl5")) != null) {
                    ((PlanImageRGB)pi).RGBControl[4] = Integer.parseInt(s);
                }
                if ((s = (String)atts.get("RGBControl6")) != null) {
                    ((PlanImageRGB)pi).RGBControl[5] = Integer.parseInt(s);
                }
                if ((s = (String)atts.get("RGBControl7")) != null) {
                    ((PlanImageRGB)pi).RGBControl[6] = Integer.parseInt(s);
                }
                if ((s = (String)atts.get("RGBControl8")) != null) {
                    ((PlanImageRGB)pi).RGBControl[7] = Integer.parseInt(s);
                }
                if ((s = (String)atts.get("RGBControl9")) != null) {
                    ((PlanImageRGB)pi).RGBControl[8] = Integer.parseInt(s);
                }
                if ((s = (String)atts.get("RGBRed")) != null) {
                    ((PlanImageRGB)pi).labelRed = s;
                }
                if ((s = (String)atts.get("RGBGreen")) != null) {
                    ((PlanImageRGB)pi).labelGreen = s;
                }
                if ((s = (String)atts.get("RGBBlue")) != null) {
                    ((PlanImageRGB)pi).labelBlue = s;
                }
                if ((s = (String)atts.get("opacity")) != null) {
                    pi.setOpacityLevel(Float.valueOf(s).floatValue());
                }
                if (!hasOrigPixel || (s = (String)atts.get("bitpix")) == null) break;
                pi.bitpix = Integer.parseInt(s);
                pi.npix = Math.abs(pi.bitpix) / 8;
                break;
            }
            default: {
                this.plan = null;
            }
        }
        if (this.plan != null) {
            s = (String)atts.get("label");
            if (s != null) {
                this.plan.label = s;
            }
            if ((s = (String)atts.get("depth")) != null) {
                this.plan.folder = Integer.parseInt(s);
            }
            if ((s = (String)atts.get("activated")) != null) {
                this.plan.active = this.plan.askActive = new Boolean(s).booleanValue();
            }
            if ((s = (String)atts.get("selectable")) != null) {
                this.plan.setSelectable(new Boolean(s));
            }
            if ((s = (String)atts.get("scalingfactor")) != null) {
                this.plan.setScalingFactor(Float.parseFloat(s));
            }
            if (this.plan instanceof PlanImage) {
                ((PlanImage)this.plan).orig = 1;
            }
            if ((s = (String)atts.get("proj")) != null) {
                this.proj = Integer.parseInt(s);
            }
            if ((s = (String)atts.get("calib")) != null) {
                Calib c = new Calib();
                this.parseCalib(c, s);
                c.adxpoly = this.parsePoly((String)atts.get("adxpoly"));
                c.adypoly = this.parsePoly((String)atts.get("adypoly"));
                c.xyapoly = this.parsePoly((String)atts.get("xyapoly"));
                c.xydpoly = this.parsePoly((String)atts.get("xydpoly"));
                c.CD = this.parseMat((String)atts.get("CD"));
                c.ID = this.parseMat((String)atts.get("ID"));
                this.plan.setNewProjD(new Projection(this.proj, c));
                if (this.plan instanceof PlanImage) {
                    ((PlanImage)this.plan).setHasSpecificCalib();
                }
            }
            if ((s = (String)atts.get("flagepoch")) != null && this.plan.projd != null && this.plan.projd.c != null) {
                this.plan.projd.c.flagepoc = Integer.parseInt(s);
            }
            if ((s = (String)atts.get("system")) != null && this.plan.projd != null && this.plan.projd.c != null) {
                this.plan.projd.c.system = Integer.parseInt(s);
            }
            if ((s = (String)atts.get("projection")) != null && this.plan.projd != null && this.plan.projd.c != null) {
                this.plan.projd.c.proj = Calib.getProjType(s);
            }
            this.plan.flagOk = true;
        }
        return this.plan;
    }

    private void parseCalib(Calib c, String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        c.aladin = Integer.parseInt(st.nextToken());
        c.epoch = Double.valueOf(st.nextToken());
        c.alpha = Double.valueOf(st.nextToken());
        c.delta = Double.valueOf(st.nextToken());
        c.yz = Double.valueOf(st.nextToken());
        c.xz = Double.valueOf(st.nextToken());
        c.focale = Double.valueOf(st.nextToken());
        c.Xorg = Double.valueOf(st.nextToken());
        c.Yorg = Double.valueOf(st.nextToken());
        c.incX = Double.valueOf(st.nextToken());
        c.incY = Double.valueOf(st.nextToken());
        c.alphai = Double.valueOf(st.nextToken());
        c.deltai = Double.valueOf(st.nextToken());
        c.incA = Double.valueOf(st.nextToken());
        c.incD = Double.valueOf(st.nextToken());
        c.Xcen = Double.valueOf(st.nextToken());
        c.Ycen = Double.valueOf(st.nextToken());
        c.widtha = Double.valueOf(st.nextToken());
        c.widthd = Double.valueOf(st.nextToken());
        c.xnpix = Integer.parseInt(st.nextToken());
        c.ynpix = Integer.parseInt(st.nextToken());
        c.rota = Double.valueOf(st.nextToken());
        c.cdelz = Double.valueOf(st.nextToken());
        c.sdelz = Double.valueOf(st.nextToken());
        c.type1 = st.nextToken();
        c.type2 = st.nextToken();
        try {
            c.equinox = Double.valueOf(st.nextToken());
        }
        catch (Exception e1) {
            c.equinox = 2000.0;
        }
        try {
            c.proj = Integer.parseInt(st.nextToken());
        }
        catch (Exception e1) {
            c.proj = 1;
        }
    }

    private double[] parsePoly(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        double[] x = new double[st.countTokens()];
        for (int i = 0; i < x.length; ++i) {
            x[i] = Double.valueOf(st.nextToken());
        }
        return x;
    }

    private double[][] parseMat(String s) {
        StringTokenizer st = new StringTokenizer(s, ",");
        double[][] x = new double[2][2];
        x[0][0] = Double.valueOf(st.nextToken());
        x[0][1] = Double.valueOf(st.nextToken());
        x[1][0] = Double.valueOf(st.nextToken());
        x[1][1] = Double.valueOf(st.nextToken());
        return x;
    }

    @Override
    public void startElement(String name, Hashtable atts) {
        block36: {
            if (name.equals("ALADINJAVA")) {
                this.aladin.calque.FreeAll();
            } else if (name.equals("PLANE")) {
                this.plan = this.creatPlaneByAJ(atts);
            } else if (name.equals("TABLE")) {
                this.vField = new Vector(10);
            } else if (name.equals("SCRIPT")) {
                this.inFilterScript = true;
            } else if (name.equals("ORIRIGINALHEADERFITS")) {
                this.inFitsHeader = true;
            } else if (name.equals("FILTER")) {
                this.inFilter = true;
            } else {
                if (name.equals("FILTERS")) {
                    try {
                        this.nFilter = 0;
                        this.plan.filters = new String[Integer.parseInt((String)atts.get("nFilter"))];
                        this.plan.filterIndex = Integer.parseInt((String)atts.get("filterIndex"));
                    }
                    catch (Exception e) {
                        if (Aladin.levelTrace >= 3) {
                            e.printStackTrace();
                        }
                        break block36;
                    }
                }
                if (name.equals("MODEVIEW")) {
                    this.firstView = 0;
                    try {
                        String s = (String)atts.get("mode");
                        if (s != null) {
                            this.aladin.view.setModeView(Integer.parseInt(s));
                        }
                        if ((s = (String)atts.get("position")) != null) {
                            this.firstView = Integer.parseInt(s);
                        }
                        if ((s = (String)atts.get("grid")) != null) {
                            this.aladin.calque.setOverlayFlag("grid", new Boolean(s));
                        }
                        if ((s = (String)atts.get("target")) != null) {
                            this.aladin.calque.setOverlayFlag("target", new Boolean(s));
                        }
                        if ((s = (String)atts.get("overlay")) != null) {
                            this.aladin.calque.flagOverlay = new Boolean(s);
                        }
                        if ((s = (String)atts.get("overlays")) != null) {
                            this.aladin.calque.setOverlayList(s);
                        }
                        break block36;
                    }
                    catch (Exception e) {
                        if (Aladin.levelTrace >= 3) {
                            e.printStackTrace();
                        }
                        break block36;
                    }
                }
                if (name.equals("VIEW")) {
                    this.vmi = this.creatViewMemoItemByAJ(atts);
                    String s = (String)atts.get("n");
                    try {
                        this.aladin.view.viewMemo.set(Integer.parseInt(s), this.vmi);
                    }
                    catch (Exception e) {
                        if (Aladin.levelTrace >= 3) {
                            e.printStackTrace();
                        }
                    }
                } else if (name.equals("VALUE")) {
                    this.inValue = true;
                    if (this.vField != null && this.vField.size() > 0) {
                        this.leg = new Legende(this.vField);
                    }
                } else if (name.equals("COLUMN")) {
                    Field f = new Field(atts);
                    Enumeration e = atts.keys();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        f.addInfo(key, (String)atts.get(key));
                    }
                    this.vField.addElement(f);
                }
            }
        }
    }

    @Override
    public void endElement(String name) {
        if (name.equals("PLANE")) {
            if (this.plan != null) {
                if (this.plan.filters != null && this.plan.filterIndex >= 0) {
                    if (this.pdf == null) {
                        this.pdf = new Vector();
                    }
                    this.pdf.addElement(this.plan);
                }
                if (this.typePlan == 1 || this.typePlan == 6 || this.typePlan == 5 || this.typePlan == 7) {
                    PlanImage pi = (PlanImage)this.plan;
                    pi.cm = CanvasColorMap.getCM(pi.cmControl[0], pi.cmControl[1], pi.cmControl[2], pi.video == 1, pi.typeCM, pi.getTransfertFct());
                    pi.calculPixelsZoom();
                    pi.changeImgID();
                }
                this.plan.flagOk = true;
                this.aladin.calque.addOnStack(this.plan);
                this.plan = null;
                this.inFitsHeader = false;
                this.flagCatalogSource = false;
            }
        } else if (name.equals("MODEVIEW")) {
            this.aladin.view.scrollOn(this.firstView, 0, 1);
        } else if (name.equals("SCRIPT")) {
            this.inFilterScript = false;
        } else if (name.equals("TABLE")) {
            this.leg = null;
            this.vField = null;
            if (this.flagCatalogSource) {
                this.typePlan = 1000;
            }
        } else if (name.equals("VALUE")) {
            this.inValue = false;
            if (this.plan instanceof PlanMoc) {
                try {
                    ((PlanMoc)this.plan).moc.read(this.inMoc.getInputStream());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (name.equals("ALADINJAVA")) {
            if (this.pFilter != null) {
                Enumeration filters = this.pFilter.keys();
                while (filters.hasMoreElements()) {
                    PlanFilter pf = (PlanFilter)filters.nextElement();
                    pf.updateDefinition((String)this.pFilter.get(pf), pf.label, null);
                    pf.updateState();
                }
                new Thread("AladinFilterUpdate"){

                    @Override
                    public void run() {
                        try {
                            Thread.currentThread();
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        PlanFilter.updateAllFilters(ServerFile.this.aladin);
                        Enumeration filters = ServerFile.this.pFilter.keys();
                        while (filters.hasMoreElements()) {
                            PlanFilter pf = (PlanFilter)filters.nextElement();
                            pf.setMustUpdate();
                            pf.doApplyFilter();
                        }
                        ServerFile.this.aladin.calque.select.repaint();
                        ServerFile.this.pFilter.clear();
                    }
                }.start();
            }
            if (this.pdf != null) {
                new Thread("AladinFilterUpdate2"){

                    @Override
                    public void run() {
                        try {
                            Thread.currentThread();
                            Thread.sleep(1200L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        Enumeration e = ServerFile.this.pdf.elements();
                        while (e.hasMoreElements()) {
                            Plan p = (Plan)e.nextElement();
                            p.setFilter(p.filterIndex);
                        }
                        ServerFile.this.aladin.calque.select.repaint();
                        ServerFile.this.pdf = null;
                    }
                }.start();
            }
        }
    }

    private int getSourceField(char[] ch, int cur, int end) {
        int start = cur;
        while (cur < end && ch[cur] != '\t' && ch[cur] != '\n') {
            ++cur;
        }
        this.rec = new String(ch, start, cur - start).trim();
        return ch[cur] == '\t' ? cur + 1 : cur;
    }

    private int getSource(char[] ch, int cur, int end) {
        while (cur < end && (ch[cur] == '\r' || ch[cur] == '\n')) {
            ++cur;
        }
        cur = this.getSourceField(ch, cur, end);
        double ra = Double.valueOf(this.rec);
        cur = this.getSourceField(ch, cur, end);
        double de = Double.valueOf(this.rec);
        String id = this.rec;
        int start = cur;
        for (cur = this.getSourceField(ch, cur, end); cur < end && ch[cur] != '\n'; ++cur) {
        }
        this.rec = new String(ch, start, cur - start);
        Source o = this.leg != null ? new Source(this.plan, ra, de, id, this.rec, this.leg) : new Source(this.plan, ra, de, id, this.rec);
        this.plan.pcat.setObjetFast(o);
        return cur;
    }

    private int getTool(char[] ch, int cur, int end) {
        return this.getTool1(ch, cur, end, false);
    }

    private int getToolAjtool(char[] ch, int cur, int end) {
        return this.getTool1(ch, cur, end, true);
    }

    private int getTool1(char[] ch, int cur, int end, boolean ajtool) {
        int y;
        int x;
        double de;
        double ra;
        boolean flagSuite = false;
        boolean flagSpecial = false;
        boolean withlabel = false;
        String typeTool = null;
        while (cur < end && (ch[cur] == '\r' || ch[cur] == '\n')) {
            ++cur;
        }
        cur = this.getSourceField(ch, cur, end);
        typeTool = this.rec;
        cur = this.getSourceField(ch, cur, end);
        flagSuite = this.rec.equals("+");
        flagSpecial = this.rec.equals("*");
        cur = this.getSourceField(ch, cur, end);
        try {
            ra = Double.valueOf(this.rec);
        }
        catch (Exception e) {
            ra = 0.0;
        }
        cur = this.getSourceField(ch, cur, end);
        try {
            de = Double.valueOf(this.rec);
        }
        catch (Exception e) {
            de = 0.0;
        }
        cur = this.getSourceField(ch, cur, end);
        try {
            x = Integer.parseInt(this.rec);
        }
        catch (Exception e) {
            x = 0;
        }
        cur = this.getSourceField(ch, cur, end);
        try {
            y = Integer.parseInt(this.rec);
        }
        catch (Exception e) {
            y = 0;
        }
        cur = this.getSourceField(ch, cur, end);
        withlabel = new Boolean(this.rec);
        cur = this.getSourceField(ch, cur, end);
        String id = this.rec;
        Position o = null;
        if (typeTool.equals("tag")) {
            o = new Repere(this.plan);
        } else if (typeTool.equals("text")) {
            o = new Tag(this.plan);
        } else if (typeTool.equals("phot")) {
            o = new SourceStat(this.plan);
        } else if (typeTool.equals("source")) {
            o = new Repere(this.plan);
        } else if (typeTool.equals("taglabel")) {
            o = new Tag(this.plan);
        } else if (typeTool.equals("line")) {
            o = new Ligne(this.plan);
        } else if (typeTool.equals("arrow")) {
            o = new Cote(this.plan);
        } else if (typeTool.equals("circle")) {
            if (this.circleCenter != null) {
                double r = de - this.circleCenter.del;
                o = new Cercle(this.plan, this.circleCenter, r);
                this.circleCenter = null;
            } else {
                this.circleCenter = new Coord(ra, de);
            }
        }
        if (o != null) {
            o.raj = ra;
            o.dej = de;
            o.x = x;
            o.y = y;
            try {
                if (this.prevFlagSuite) {
                    ((Ligne)this.prevO).finligne = (Ligne)o;
                    ((Ligne)o).debligne = (Ligne)this.prevO;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (flagSpecial) {
                    ((Ligne)o).bout = (byte)3;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                o.setWithLabel(withlabel);
            }
            catch (Exception e) {
                // empty catch block
            }
            o.setSpecificAJInfo(id);
            this.plan.pcat.setObjetFast(o);
            this.prevO = o;
            this.prevFlagSuite = flagSuite;
        }
        return cur;
    }

    private void getMoc(char[] ch, int cur, int length) {
        if (((PlanMoc)this.plan).moc == null) {
            ((PlanMoc)this.plan).moc = this.plan instanceof PlanSTMoc ? new STMoc() : (this.plan instanceof PlanTMoc ? new TMoc() : new SMoc());
            this.inMoc = new MyByteArrayStream(length);
        }
        this.inMoc.write(new String(ch, cur, length));
    }

    private void getImageRGB(char[] ch, int start, int length) {
        PlanImageRGB p = (PlanImageRGB)this.plan;
        if (this.rgb == null) {
            this.rgb = new byte[p.width * p.height * 3];
            this.pOffset = 0;
        }
        this.pOffset = Save.get64(this.rgb, this.pOffset, ch, start, length);
        if (this.pOffset == p.width * p.height * 3) {
            p.setByteRGB(this.rgb);
            p.cm = ColorModel.getRGBdefault();
            for (int i = 0; i < 3; ++i) {
                p.filterRGB(p.cmControl, i);
            }
            p.flagBlue = true;
            p.flagGreen = true;
            p.flagRed = true;
            this.rgb = null;
            this.pOffset = 0;
        }
    }

    private void getImage(char[] ch, int start, int length) {
        PlanImage p = (PlanImage)this.plan;
        if (p.getBufPixels8() == null) {
            p.setBufPixels8(new byte[p.width * p.height]);
            this.pOffset = 0;
        }
        this.pOffset = Save.get64(p.getBufPixels8(), this.pOffset, ch, start, length);
    }

    private void setScript(String script) {
        if (this.pFilter == null) {
            this.pFilter = new Hashtable();
        }
        this.plan.setActivated();
        this.pFilter.put(this.plan, script);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        int end = start + length;
        if (this.inValue) {
            switch (this.typePlan) {
                case 8: 
                case 1000: {
                    int cur;
                    for (cur = start; cur < end; ++cur) {
                        cur = this.getSource(ch, cur, end);
                    }
                    break;
                }
                case 9: {
                    int cur;
                    while (cur < end) {
                        cur = this.getTool(ch, cur, end);
                        ++cur;
                    }
                    this.prevFlagSuite = false;
                    break;
                }
                case 1001: {
                    int cur;
                    while (cur < end) {
                        cur = this.getToolAjtool(ch, cur, end);
                        ++cur;
                    }
                    this.prevFlagSuite = false;
                    break;
                }
                case 19: 
                case 23: 
                case 24: {
                    this.getMoc(ch, start, length);
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 15: {
                    this.getImage(ch, start, length);
                    break;
                }
                case 2: {
                    this.getImageRGB(ch, start, length);
                }
            }
        } else if (this.inFilterScript) {
            this.setScript(new String(ch, start, length).replaceAll("\\\\n", "\n"));
        } else if (this.inFitsHeader) {
            if (((PlanImage)this.plan).headerFits == null) {
                ((PlanImage)this.plan).headerFits = new FrameHeaderFits(this.plan, new String(ch, start, length));
            } else {
                ((PlanImage)this.plan).headerFits.setOriginalHeaderFits(new String(ch, start, length));
            }
        } else if (this.inFilter) {
            if (this.plan.filters == null) {
                return;
            }
            this.plan.filters[this.nFilter++] = new String(ch, start, length);
        }
    }
}

