/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.MetaDataTree;
import cds.aladin.Plan;
import cds.aladin.RobotAction;
import cds.aladin.Server;
import cds.aladin.ServerDialog;
import cds.aladin.TranslationScript;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ScriptFactory {
    private Hashtable scripts = new Hashtable();
    private String[] args;
    private static String[] defaultScripts = new String[]{"PUSH toolbox.contour\nPAUSE toolbox.contour 2000\nADJUSTPOS frameContour\nPUSH frameContour.nbLevelsChoice\n SELECT frameContour.nbLevelsChoice $$1\nPUSH frameContour.submitBtn", "PUSH toolbox.filter\nPAUSE toolbox.filter 2000\nADJUSTPOS lastFilterCreated\nTYPE lastFilterCreated.label $$1\nTYPE lastFilterCreated.filterDef $$2\nPUSH lastFilterCreated.applyBtn\nTOFRONT f", "PUSH searchdata\nPAUSE searchdata 2000\nPUSH dialog.local\nTYPE dialog.localServer.file $$2\nPUSH dialog.submit\nTOFRONT f", "PUSH toolbox.rgb\nPAUSE toolbox.rgb 2000\nADJUSTPOS frameRGB\nPUSH frameRGB.cR\nSELECT frameRGB.cR $$1\nPUSH frameRGB.cG\nSELECT frameRGB.cG $$2\nPUSH frameRGB.cB\nSELECT frameRGB.cB $$3\nPUSH frameRGB.submitBtn\nTOFRONT f", "PUSH searchData\nPAUSE searchData 2000\nADJUSTPOS dialog\nPUSH dialog.$$1\nPAUSE dialog 2000\nTYPE dialog.curServer.target $$2\nPUSH dialog.submit\nTOFRONT f", "PUSH searchData\nPAUSE searchData 2000\nADJUSTPOS dialog\nPUSH dialog.aladin\nPAUSE dialog 2000\nTYPE dialog.curServer.target $$2\nPUSH dialog.submit\nPAUSE searchData 9000\nPUSH dialog.curServer.tree.$$3\nPUSH dialog.submit\nTOFRONT f", "PUSH searchData\nPAUSE searchData 2000\nADJUSTPOS dialog\nPUSH dialog.vizier\nPAUSE dialog 2000\nTYPE dialog.vizierServer.target $$2\nTYPE dialog.vizierServer.catalog $$3\nPUSH dialog.submit\nTOFRONT f", "INFO f $$1", "PUSH calque.select.$$1", "PUSH calque.select.ref$$1"};
    private static String[] defaultScriptsLabels = new String[]{"contour", "filter", "getlocal", "rgb", "getsimbadned", "getaladin", "getvizier", "info", "show", "ref"};

    public ScriptFactory() {
        this.addDefaultScripts();
    }

    public TranslationScript getScript(String cmdName, String argsStr) {
        this.args = new String[3];
        String[] argsTmp = ScriptFactory.split(argsStr, " ");
        for (int i = 0; i < argsTmp.length; ++i) {
            if (argsTmp[i] == null || i >= this.args.length) continue;
            this.args[i] = argsTmp[i];
        }
        if (cmdName.equals("get")) {
            return this.processGet(cmdName, argsStr);
        }
        if (cmdName.equals("filter")) {
            return this.processFilter(cmdName, argsStr);
        }
        if (cmdName.equals("rgb")) {
            return this.processRGB(cmdName, argsStr);
        }
        if (cmdName.equals("info")) {
            return this.processInfo(cmdName, argsStr);
        }
        if (cmdName.equals("hide") || cmdName.equals("show")) {
            return this.processShow(cmdName, argsStr);
        }
        TranslationScript script = this.getScriptWithArgs(cmdName);
        if (script == null) {
            return null;
        }
        return script;
    }

    public void addScript(TranslationScript script) {
        this.scripts.put(script.cmdName, script);
    }

    private void addDefaultScripts() {
        for (int i = 0; i < defaultScripts.length; ++i) {
            StringTokenizer st1 = new StringTokenizer(defaultScripts[i], "\n");
            Vector<RobotAction> v = new Vector<RobotAction>();
            while (st1.hasMoreTokens()) {
                String curLine = st1.nextToken();
                StringTokenizer st2 = new StringTokenizer(curLine, " ");
                String actionStr = st2.nextToken();
                RobotAction a = RobotAction.getActionFromString(actionStr);
                String comp = st2.nextToken();
                String param = st2.hasMoreTokens() ? st2.nextToken() : null;
                v.addElement(new RobotAction(a, comp, param));
            }
            Object[] actions = new RobotAction[v.size()];
            v.copyInto(actions);
            this.addScript(new TranslationScript(defaultScriptsLabels[i], (RobotAction[])actions));
        }
    }

    private TranslationScript processInfo(String cmdName, String argsStr) {
        this.args[0] = argsStr;
        return this.getScriptWithArgs(cmdName);
    }

    private TranslationScript processShow(String cmdName, String argsStr) {
        boolean doNothing;
        Plan p = Aladin.aladin.command.getNumber(argsStr, 1, false, false);
        if (p == null) {
            return null;
        }
        boolean bl = doNothing = cmdName.equals("show") && p.active || cmdName.equals("hide") && !p.active;
        if (doNothing) {
            return null;
        }
        return this.getScriptWithArgs("show");
    }

    private TranslationScript processFilter(String cmdName, String argsStr) {
        if (argsStr.length() < 7) {
            return null;
        }
        argsStr = argsStr.trim().substring(6);
        int begin = argsStr.indexOf(123);
        int end = argsStr.lastIndexOf(125);
        if (begin < 0 || end < 0) {
            return null;
        }
        this.args[0] = argsStr.substring(0, begin).trim();
        this.args[1] = argsStr.substring(begin + 1, end);
        return this.getScriptWithArgs(cmdName);
    }

    private TranslationScript processRGB(String cmdName, String argsStr) {
        argsStr = argsStr.trim();
        StringTokenizer st = new StringTokenizer(argsStr, " ");
        try {
            this.args[0] = this.getRGBLabel(Aladin.aladin.calque.plan[this.getNumber(st.nextToken(), 0)]);
            this.args[1] = this.getRGBLabel(Aladin.aladin.calque.plan[this.getNumber(st.nextToken(), 0)]);
            this.args[2] = this.getRGBLabel(Aladin.aladin.calque.plan[this.getNumber(st.nextToken(), 0)]);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return this.getScriptWithArgs(cmdName);
    }

    private TranslationScript processGet(String cmdName, String argsStr) {
        StringBuffer servers = new StringBuffer();
        StringBuffer t = new StringBuffer();
        StringBuffer r = new StringBuffer();
        if (!Aladin.aladin.command.splitGetCmd(servers, t, r, argsStr, true)) {
            return null;
        }
        String target = t.toString();
        String radius = r.toString();
        StringTokenizer stServer = new StringTokenizer(servers.toString(), ",");
        Vector<RobotAction> v = new Vector<RobotAction>();
        while (stServer.hasMoreTokens()) {
            TranslationScript curTs = this.getScriptForServer(stServer.nextToken(), target, radius);
            if (curTs == null) {
                return null;
            }
            for (int i = 0; i < curTs.actions.length; ++i) {
                v.addElement(curTs.actions[i]);
            }
        }
        Object[] actions = new RobotAction[v.size()];
        v.copyInto(actions);
        v = null;
        return new TranslationScript("get", (RobotAction[])actions);
    }

    TranslationScript getScriptForServer(String server, String target, String radius) {
        int lindex = server.indexOf(40);
        String serverName = server;
        String param = "";
        if (lindex >= 0) {
            serverName = server.substring(0, lindex);
            int rindex = server.lastIndexOf(41);
            if (rindex > 0) {
                param = server.substring(lindex + 1, rindex);
            }
        }
        this.args[0] = serverName = serverName.trim().toLowerCase();
        if (serverName.equalsIgnoreCase("local") || serverName.equalsIgnoreCase("mydata") || serverName.equalsIgnoreCase("file")) {
            this.args[1] = param;
            return this.getScriptWithArgs("getlocal");
        }
        if (serverName.equals("aladin")) {
            this.args[1] = target;
            this.args[2] = param.length() > 0 ? param : "DSS";
            TranslationScript script = this.getScriptWithArgs("getaladin");
            Server as = Aladin.aladin.dialog.server[ServerDialog.ALADIN];
            Aladin.aladin.dialog.setDefaultParameters(Aladin.aladin.dialog.current, 0);
            if (as.tree != null && !as.tree.isEmpty() && as.target.getText().equals(target)) {
                for (int i = 5; i <= 7; ++i) {
                    script.actions[i] = null;
                }
            }
            return script;
        }
        if (serverName.equals("simbad") || serverName.equals("ned")) {
            this.args[1] = target;
            return this.getScriptWithArgs("getsimbadned");
        }
        if (serverName.equals("vizier")) {
            this.args[1] = target;
            this.args[2] = param.length() > 0 ? param : "GSC2";
            return this.getScriptWithArgs("getvizier");
        }
        return null;
    }

    private TranslationScript getScriptWithArgs(String name) {
        TranslationScript orgScript = (TranslationScript)this.scripts.get(name);
        if (orgScript == null) {
            return null;
        }
        RobotAction[] actions = new RobotAction[orgScript.actions.length];
        for (int i = 0; i < orgScript.actions.length; ++i) {
            RobotAction a = orgScript.actions[i];
            actions[i] = new RobotAction(a.getAction(), this.setArgs(a.getComp()), this.setArgs(a.getParam()));
        }
        return new TranslationScript(name, actions);
    }

    private String setArgs(String s) {
        int dollarIndex;
        if (s == null) {
            return null;
        }
        String tmp = new String(s);
        while ((dollarIndex = tmp.indexOf("$$")) >= 0) {
            int dotIndex = dollarIndex + 3;
            int index = Integer.parseInt(tmp.substring(dollarIndex + 2, dotIndex));
            if (this.args[index - 1] == null) {
                this.args[index - 1] = "null";
            }
            tmp = MetaDataTree.replace(tmp, "$$" + index, ScriptFactory.encode(this.args[index - 1]), -1);
        }
        return tmp;
    }

    protected static String encode(String s) {
        return MetaDataTree.replace(s, ".", "@@", -1);
    }

    protected static String decode(String s) {
        return MetaDataTree.replace(s, "@@", ".", -1);
    }

    protected static String[] split(String str, String sep) {
        StringTokenizer st = new StringTokenizer(str, sep);
        String[] ret = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            ret[i] = st.nextToken();
            ++i;
        }
        return ret;
    }

    private int getNumber(String s, int methode) {
        int n = 0;
        Aladin a = Aladin.aladin;
        try {
            n = Integer.parseInt(s);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (n < 1 || n > a.calque.plan.length) {
            if (methode == 1) {
                n = a.calque.getIndexPlan(s);
                if (n < 0) {
                    System.out.println("!!! Plane \"" + s + "\" not found !");
                    return -1;
                }
                return n;
            }
            System.out.println("!!! Error on plane number " + s);
            return -1;
        }
        n = a.calque.plan.length - n;
        if (a.calque.plan[n].type == 0) {
            System.out.println("!!! plane number " + s + " not assigned");
            return -1;
        }
        return n;
    }

    private String getRGBLabel(Plan p) {
        return p.label + " - \"" + p.objet + "\"";
    }
}

