/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AppMessagingInterface;
import cds.aladin.Coord;
import cds.aladin.FrameServer;
import cds.aladin.Glu;
import cds.aladin.MyButton;
import cds.aladin.MyByteArrayStream;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanImage;
import cds.aladin.PlaneLoadEvent;
import cds.aladin.PlaneLoadListener;
import cds.aladin.PlasticWidget;
import cds.aladin.SAMPUtil;
import cds.aladin.Save;
import cds.aladin.Server;
import cds.aladin.Source;
import cds.aladin.VOResource;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.astrogrid.samp.hub.Hub;
import org.astrogrid.samp.hub.HubServiceMode;
import org.astrogrid.samp.xmlrpc.SampXmlRpcClient;
import org.astrogrid.samp.xmlrpc.SampXmlRpcHandler;
import org.astrogrid.samp.xmlrpc.SampXmlRpcServer;
import org.astrogrid.samp.xmlrpc.internal.InternalServer;

public class SAMPManager
implements AppMessagingInterface,
SampXmlRpcHandler,
PlaneLoadListener {
    protected static final String NOTIFY = "samp.hub.notify";
    protected static final String NOTIFY_ALL = "samp.hub.notifyAll";
    protected static final String KEY_SELF_ID = "samp.self-id";
    protected static final String KEY_HUB_ID = "samp.hub-id";
    protected static final String KEY_PRIVATE_KEY = "samp.private-key";
    protected static final String KEY_MTYPE = "samp.mtype";
    protected static final String KEY_PARAMS = "samp.params";
    protected static final String METHOD_RECEIVE_NOTIFICATION = "samp.client.receiveNotification";
    protected static final String METHOD_RECEIVE_CALL = "samp.client.receiveCall";
    protected static final String METHOD_RECEIVE_RESPONSE = "samp.client.receiveResponse";
    protected static final String HUB_MSG_REGISTER = "samp.hub.register";
    protected static final String HUB_MSG_DECLARE_METADATA = "samp.hub.declareMetadata";
    protected static final String HUB_MSG_DECLARE_SUBSCRIPTIONS = "samp.hub.declareSubscriptions";
    protected static final String HUB_MSG_UNREGISTER = "samp.hub.unregister";
    protected static final String HUB_MSG_PING = "samp.hub.ping";
    protected static final String HUB_MSG_DISCONNECT = "samp.hub.disconnect";
    protected static final String HUB_MSG_REPLY = "samp.hub.reply";
    protected static final String HUB_MSG_GET_REGISTERED_CLIENTS = "samp.hub.getRegisteredClients";
    protected static final String HUB_MSG_GET_METADATA = "samp.hub.getMetadata";
    protected static final String HUB_MSG_GET_SUBSCRIBED_CLIENTS = "samp.hub.getSubscribedClients";
    protected static final String HUB_MSG_SHUTDOWN = "samp.hub.event.shutdown";
    protected static final String HUB_MSG_REGISTRATION = "samp.hub.event.register";
    protected static final String HUB_MSG_UNREGISTRATION = "samp.hub.event.unregister";
    protected static final String HUB_MSG_SUBSCRIPTIONS = "samp.hub.event.subscriptions";
    protected static final String MSG_LOAD_FITS_IMAGE = "image.load.fits";
    protected static final String MSG_POINT_AT_COORDS = "coord.pointAt.sky";
    protected static final String MSG_LOAD_VOT_FROM_URL = "table.load.votable";
    protected static final String MSG_LOAD_FITS_TABLE_FROM_URL = "table.load.fits";
    protected static final String MSG_LOAD_FITS_MOC_COVERAGE = "coverage.load.moc.fits";
    protected static final String MSG_HIGHLIGHT_OBJECT = "table.highlight.row";
    protected static final String MSG_SELECT_OBJECTS = "table.select.rowList";
    protected static final String MSG_LOAD_SPECTRUM = "spectrum.load.ssa-generic";
    protected static final String MSG_SEND_ALADIN_SCRIPT_CMD = "script.aladin.send";
    protected static final String MSG_GET_COORDS = "coord.get.sky";
    protected static final String MSG_GET_SNAPSHOT = "snapshot.get.jpg";
    protected static final String MSG_PING = "samp.app.ping";
    protected static final String[] SUPPORTED_MESSAGES = new String[]{"image.load.fits", "coord.pointAt.sky", "coord.get.sky", "snapshot.get.jpg", "table.load.votable", "table.load.fits", "table.highlight.row", "table.select.rowList", "samp.app.ping", "script.aladin.send", "samp.hub.event.shutdown", "samp.hub.event.register", "samp.hub.event.unregister", "samp.hub.event.subscriptions", "samp.hub.disconnect"};
    protected static final String MSG_REPLY_SAMP_STATUS = "samp.status";
    protected static final String MSG_REPLY_SAMP_STATUSOK = "samp.ok";
    protected static final String MSG_REPLY_SAMP_STATUSERROR = "samp.error";
    protected static final String MSG_REPLY_SAMP_RESULT = "samp.result";
    protected static final String MSG_REPLY_SAMP_ERROR = "samp.error";
    private Hashtable<Plan, String> planesToMsgIds = new Hashtable();
    protected static final String ALADIN_NAME = "Aladin";
    protected static final String ALADIN_IVORN = "ivo://CDS/Aladin";
    protected static final String SAMP_CONF_FILE = ".samp";
    private int curState = 0;
    private boolean updateAppsListNeeded = true;
    protected static final String ALADIN_DESC = "ALADIN is an interactive software sky atlas developed by the CDS, allowing one to visualize digitized imagesof any part of the sky, to superimpose entries from astronomical catalogs,and to interactively access related data and information.";
    static String LAUNCH_INTERNAL_HUB;
    static String CANT_CONNECT;
    static String CANT_LAUNCH_HUB;
    static String HUB_STOP;
    static String EXCEPTION;
    static String CONFIRM_STOP_HUB;
    private Aladin a;
    private boolean isRegistered = false;
    private PlasticWidget widget;
    private String hubUrl;
    private String sampSecret;
    private SampXmlRpcClient hubClient;
    private SampXmlRpcServer aladinXmlRpcServer;
    private static final String SAMP_SECRET_KEY = "samp.secret";
    private static final String SAMP_HUB_URL_KEY = "samp.hub.xmlrpc.url";
    private String selfId;
    private String hubId;
    private String myPrivateKey;
    static int startPort;
    private Hub internalHub;
    public static final String LOCALHOST_PROP = "samp.localhost";
    private Hashtable appNamesToURI;
    private Vector appNames;
    private static final Object VOID;
    private static final Object TRUE;
    private static final Object FALSE;
    Integer oidx;
    String oid;
    ResourceChooser resourceChooser;
    private Plan lastPlaneWithSelectedSrc;
    private boolean sampTrace = false;

    public SAMPManager(Aladin a) {
        this.a = a;
        this.createChaine();
    }

    private void createChaine() {
        String name = this.getProtocolName();
        LAUNCH_INTERNAL_HUB = Aladin.chaine.getString("PMLAUNCHHUB").replaceAll("SAMP", name);
        CANT_CONNECT = Aladin.chaine.getString("PMCANTCONNECT").replaceAll("SAMP", name);
        CANT_LAUNCH_HUB = Aladin.chaine.getString("PMCANTLAUNCHHUB").replaceAll("SAMP", name);
        HUB_STOP = Aladin.chaine.getString("PMHUBWILLSTOP").replaceAll("SAMP", name);
        EXCEPTION = Aladin.chaine.getString("PMEXCEPTION").replaceAll("SAMP", name);
        CONFIRM_STOP_HUB = Aladin.chaine.getString("PMCONFIRMSTOPHUB").replaceAll("SAMP", name);
    }

    @Override
    public boolean register(boolean silent, boolean launchHubIfNeeded) {
        Object result;
        this.trace("Try to register Aladin with the SAMP hub");
        if (this.isRegistered()) {
            this.trace("Aladin was already registered !");
            return true;
        }
        if (!this.getHubListener(silent, launchHubIfNeeded)) {
            this.trace("Could not register to the SAMP hub");
            return false;
        }
        boolean pbOccured = false;
        Vector<Object> params = new Vector<Object>();
        params.add(this.sampSecret);
        try {
            Map resultMap = (Map)this.hubClient.callAndWait(HUB_MSG_REGISTER, params);
            this.myPrivateKey = resultMap.get(KEY_PRIVATE_KEY).toString();
            this.selfId = resultMap.get(KEY_SELF_ID).toString();
            this.hubId = resultMap.get(KEY_HUB_ID).toString();
            this.trace("Aladin has registered, self-id=" + this.selfId);
        }
        catch (Exception e) {
            pbOccured = true;
        }
        if (pbOccured) {
            this.isRegistered = false;
        } else {
            this.isRegistered = true;
            Aladin.trace(3, "Successful registration with the SAMP hub");
        }
        params = new Vector();
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("samp.name", ALADIN_NAME);
        map.put("samp.description.text", "The Aladin sky atlas");
        map.put("samp.icon.url", "http://aladin.u-strasbg.fr/aladin_large.gif");
        map.put("samp.documentation.url", "http://aladin.u-strasbg.fr/java/FAQ.htx");
        map.put("author.name", "Pierre Fernique, Thomas Boch");
        map.put("author.email", "pierre.fernique@astro.unistra.fr");
        map.put("author.affiliation", "CDS, Observatoire astronomique de Strasbourg");
        map.put("home.page", "http://aladin.u-strasbg.fr/");
        map.put("aladin.version", "v11.024");
        params.add(this.myPrivateKey);
        params.add(map);
        try {
            result = this.hubClient.callAndWait(HUB_MSG_DECLARE_METADATA, params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.aladinXmlRpcServer = new InternalServer();
            this.aladinXmlRpcServer.addHandler(this);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String callbackAddress = this.aladinXmlRpcServer.getEndpoint().toString();
        params = new Vector();
        params.add(this.myPrivateKey);
        params.add(callbackAddress);
        try {
            this.trace("setting Aladin XMLRPC callback : " + callbackAddress);
            result = this.hubClient.callAndWait("samp.hub.setXmlrpcCallback", params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        params = new Vector();
        params.add(this.myPrivateKey);
        Hashtable subscriptionMap = new Hashtable();
        for (int i = 0; i < SUPPORTED_MESSAGES.length; ++i) {
            Hashtable<String, String> subscriptionAnnotation = new Hashtable<String, String>();
            subscriptionAnnotation.put("x-samp.mostly-harmless", "1");
            subscriptionMap.put(SUPPORTED_MESSAGES[i], subscriptionAnnotation);
        }
        params.add(subscriptionMap);
        try {
            result = this.hubClient.callAndWait(HUB_MSG_DECLARE_SUBSCRIPTIONS, params);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.widget != null) {
            this.widget.updateStatus(this.isRegistered());
        }
        this.updateState();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object execute(String method, Vector params) {
        this.trace("Receiving XML request :\nmethod=" + method + "\nparams=" + params);
        if (method.equals(METHOD_RECEIVE_NOTIFICATION) || method.equals(METHOD_RECEIVE_CALL)) {
            Object retValue = TRUE;
            String senderId = (String)params.get(1);
            boolean responseNeeded = method.equals(METHOD_RECEIVE_CALL);
            String msgId = null;
            if (responseNeeded) {
                msgId = (String)params.get(2);
            }
            int paramIdx = responseNeeded ? 3 : 2;
            Map map = (Map)params.get(paramIdx);
            Object mType = map.get(KEY_MTYPE);
            Map msgParams = (Map)map.get(KEY_PARAMS);
            if (mType == null || msgParams == null) {
                System.err.println("mtype or msgParams is null");
                return null;
            }
            this.trace("msgParams is " + msgParams);
            this.trace("mType is " + mType);
            if (mType.equals(HUB_MSG_SHUTDOWN)) {
                this.trace("hub is shutting down");
                this.unregister(true);
                this.isRegistered = false;
                this.updateState();
            } else if (mType.equals(HUB_MSG_DISCONNECT)) {
                this.trace("Hub wants us to disconnect ... proceed");
                this.unregister(true);
                this.isRegistered = false;
                this.a.dontReconnectAutomatically = true;
                this.updateState();
            } else if (mType.equals(HUB_MSG_REGISTRATION)) {
                this.updateState();
            } else if (mType.equals(HUB_MSG_UNREGISTRATION)) {
                this.updateState();
            } else if (mType.equals(HUB_MSG_SUBSCRIPTIONS)) {
                this.updateState();
                this.updateAppsListNeeded = true;
            } else if (mType.equals(MSG_PING)) {
                this.replyToMessage(msgId, MSG_REPLY_SAMP_STATUSOK, null, null);
            } else if (mType.equals(MSG_LOAD_VOT_FROM_URL) || mType.equals(MSG_LOAD_FITS_TABLE_FROM_URL)) {
                String url = (String)msgParams.get("url");
                String tableId = (String)msgParams.get("table-id");
                String name = (String)msgParams.get("name");
                if (url == null) {
                    System.err.println("Missing URL !");
                    if (responseNeeded) {
                        this.replyToMessage(msgId, "samp.error", null, "Could not load data, URL is missing !");
                    }
                    return FALSE;
                }
                String senderName = this.getNameForApp(senderId);
                Plan p = this.loadVOTFromURL(url, tableId, name, senderName);
                if (responseNeeded) {
                    if (p == null) {
                        this.replyToMessage(msgId, "samp.error", null, "Could not load VOTable !");
                    } else if (p.flagOk) {
                        this.replyToMessage(msgId, MSG_REPLY_SAMP_STATUSOK, null, null);
                    } else {
                        this.trace("Associating message ID " + msgId + " to catalogue plane " + p.getLabel());
                        this.planesToMsgIds.put(p, msgId);
                        p.addPlaneLoadListener(this);
                    }
                }
                Aladin.trace(3, "Receiving table " + url);
                this.a.log("SAMP", "receiving table");
            } else if (mType.equals(MSG_LOAD_FITS_IMAGE)) {
                String url = (String)msgParams.get("url");
                String imageId = (String)msgParams.get("image-id");
                String name = (String)msgParams.get("name");
                if (url == null) {
                    System.err.println("Missing URL !");
                    if (responseNeeded) {
                        this.replyToMessage(msgId, "samp.error", null, "Could not load image, URL is missing !");
                    }
                    return FALSE;
                }
                if (imageId == null) {
                    imageId = url;
                }
                String senderName = this.getNameForApp(senderId);
                Plan p = this.loadFitsImageFromURL(url, imageId, name, senderName);
                if (responseNeeded) {
                    if (p == null) {
                        this.replyToMessage(msgId, "samp.error", null, "Could not load image !");
                    } else if (p.flagOk) {
                        this.replyToMessage(msgId, MSG_REPLY_SAMP_STATUSOK, null, null);
                    } else {
                        this.trace("Associating message ID " + msgId + " to image plane " + p.getLabel());
                        this.planesToMsgIds.put(p, msgId);
                        p.addPlaneLoadListener(this);
                    }
                }
                Aladin.trace(3, "Receiving image " + url);
                this.a.log("SAMP", "receiving image");
            } else if (mType.equals(MSG_LOAD_FITS_MOC_COVERAGE)) {
                String url = (String)msgParams.get("url");
                String coverageId = (String)msgParams.get("coverage-id");
                String name = (String)msgParams.get("name");
                if (url == null) {
                    System.err.println("Missing URL !");
                    if (responseNeeded) {
                        this.replyToMessage(msgId, "samp.error", null, "Could not load MOC coverage, URL is missing !");
                    }
                    return FALSE;
                }
                if (coverageId == null) {
                    coverageId = url;
                }
                String senderName = this.getNameForApp(senderId);
                Plan p = this.loadFitsImageFromURL(url, coverageId, name, senderName);
                if (responseNeeded) {
                    if (p == null) {
                        this.replyToMessage(msgId, "samp.error", null, "Could not load MOC coverage !");
                    } else if (p.flagOk) {
                        this.replyToMessage(msgId, MSG_REPLY_SAMP_STATUSOK, null, null);
                    } else {
                        this.trace("Associating message ID " + msgId + " to MOC coverage plane " + p.getLabel());
                        this.planesToMsgIds.put(p, msgId);
                        p.addPlaneLoadListener(this);
                    }
                }
                Aladin.trace(3, "Receiving MOC " + url);
                this.a.log("SAMP", "receiving MOC");
            } else if (mType.equals(MSG_SEND_ALADIN_SCRIPT_CMD)) {
                String script = (String)msgParams.get("script");
                if (script == null) {
                    String errorMsg = "Missing script parameter !";
                    System.err.println(errorMsg);
                    if (responseNeeded) {
                        this.replyToMessage(msgId, "samp.error", null, errorMsg);
                    }
                    return FALSE;
                }
                String result = this.a.execCommand(script);
                if (responseNeeded) {
                    if (result.startsWith("Error")) {
                        this.replyToMessage(msgId, "samp.error", null, result);
                    } else {
                        Hashtable<String, String> scriptResult = new Hashtable<String, String>();
                        scriptResult.put("script.result", result);
                        this.replyToMessage(msgId, MSG_REPLY_SAMP_STATUSOK, scriptResult, null);
                    }
                }
            } else if (mType.equals(MSG_POINT_AT_COORDS)) {
                block95: {
                    try {
                        double ra = Double.parseDouble((String)msgParams.get("ra"));
                        double dec = Double.parseDouble((String)msgParams.get("dec"));
                        this.a.view.gotoThere(new Coord(ra, dec));
                    }
                    catch (Exception e) {
                        String errorMsg = "Error while processing SAMP message coord.pointAt.sky:Missing 'ra' or 'dec' parameter or incorrect type for params";
                        this.a.command.println(errorMsg);
                        retValue = FALSE;
                        e.printStackTrace();
                        if (!responseNeeded) break block95;
                        this.replyToMessage(msgId, "samp.error", null, errorMsg);
                    }
                }
                if (responseNeeded) {
                    this.replyToMessage(msgId, MSG_REPLY_SAMP_STATUSOK, null, null);
                }
            } else if (mType.equals(MSG_HIGHLIGHT_OBJECT)) {
                boolean success;
                try {
                    success = this.highlightObject((String)msgParams.get("table-id"), new Integer((String)msgParams.get("row")));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    success = false;
                }
                if (responseNeeded) {
                    if (success) {
                        this.replyToMessage(msgId, MSG_REPLY_SAMP_STATUSOK, null, null);
                    } else {
                        this.replyToMessage(msgId, "samp.error", null, "Could not find object to highlight");
                    }
                }
            } else if (mType.equals(MSG_SELECT_OBJECTS)) {
                String tableId = (String)msgParams.get("table-id");
                this.trace("id recu : " + tableId);
                List rowList = (List)msgParams.get("row-list");
                int[] rowIdxArray = new int[rowList.size()];
                Iterator it = rowList.iterator();
                int k = 0;
                try {
                    while (it.hasNext()) {
                        rowIdxArray[k] = Integer.parseInt((String)it.next());
                        ++k;
                    }
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                    this.replyToMessage(msgId, "samp.error", null, "Incorrect format for indices !");
                    return FALSE;
                }
                boolean success = this.selectSources(tableId, rowIdxArray);
                if (responseNeeded) {
                    if (success) {
                        this.replyToMessage(msgId, MSG_REPLY_SAMP_STATUSOK, null, null);
                    } else {
                        this.replyToMessage(msgId, "samp.error", null, "Could not find sources to select");
                    }
                }
            } else if (mType.equals(MSG_GET_COORDS)) {
                if (this.a.view.repere == null || Double.isNaN(this.a.view.repere.raj) || Double.isNaN(this.a.view.repere.dej)) {
                    retValue = FALSE;
                    this.replyToMessage(msgId, "samp.error", null, "no repere has been set");
                } else {
                    Hashtable<String, String> positionMap = new Hashtable<String, String>();
                    positionMap.put("ra", Double.toString(this.a.view.repere.raj));
                    positionMap.put("dec", Double.toString(this.a.view.repere.dej));
                    this.replyToMessage(msgId, MSG_REPLY_SAMP_STATUSOK, positionMap, null);
                }
            } else if (mType.equals(MSG_GET_SNAPSHOT)) {
                BufferedInputStream bis = null;
                StringBuffer base64Str = new StringBuffer("data:image/jpeg;base64,");
                try {
                    File tmp = File.createTempFile("samp", ".jpg");
                    tmp.deleteOnExit();
                    int h = 300;
                    int w = 300;
                    this.a.save.saveView(tmp.getAbsolutePath(), w, h, 4, 0.7f);
                    if (tmp.length() == 0L) {
                        this.replyToMessage(msgId, "samp.error", null, "Unable to generate snapshot of current view");
                        Object success = FALSE;
                        return success;
                    }
                    bis = new BufferedInputStream(new FileInputStream(tmp));
                    byte[] buffer = new byte[(int)tmp.length()];
                    int offset = 0;
                    int read = bis.read(buffer, offset, buffer.length - offset);
                    while (read >= 0 && offset < buffer.length) {
                        read = bis.read(buffer, offset += read, buffer.length - offset);
                    }
                    base64Str.append(Util.toB64(buffer));
                }
                catch (Exception e) {
                    this.replyToMessage(msgId, "samp.error", null, e.getMessage());
                    Object object = FALSE;
                    return object;
                }
                finally {
                    if (bis != null) {
                        try {
                            bis.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                Hashtable<String, String> resultMap = new Hashtable<String, String>();
                resultMap.put("data", base64Str.toString().replaceAll("(\r\n|\n)", ""));
                this.replyToMessage(msgId, MSG_REPLY_SAMP_STATUSOK, resultMap, null);
            } else {
                System.err.println("Unprocessed message " + mType);
            }
            return retValue;
        }
        if (method.equals(METHOD_RECEIVE_RESPONSE)) {
            // empty if block
        }
        System.err.println("Unknown method " + method);
        return null;
    }

    static int findFreePort() {
        int nbTry = 20;
        for (int iPort = startPort; iPort < startPort + 20; ++iPort) {
            try {
                Socket trySocket = new Socket(SAMPManager.getLocalhost(), iPort);
                if (trySocket.isClosed()) continue;
                trySocket.close();
                continue;
            }
            catch (ConnectException ce) {
                startPort = iPort + 1;
                return iPort;
            }
            catch (Exception e) {
                e.printStackTrace();
                return -1;
            }
        }
        return -1;
    }

    protected boolean isSupporting(String message) {
        for (int i = 0; i < SUPPORTED_MESSAGES.length; ++i) {
            if (!SUPPORTED_MESSAGES[i].equals(message)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean unregister() {
        return this.unregister(false);
    }

    @Override
    public boolean unregister(boolean force) {
        return this.unregister(force, false);
    }

    @Override
    public boolean unregister(boolean force, boolean destroyInternalHub) {
        block11: {
            this.trace("Try to unregister Aladin from the SAMP hub");
            if (!this.isRegistered()) {
                this.trace("Aladin is not registered with the hub, no need to unregister !");
                return true;
            }
            if (!this.getHubListener(false)) {
                this.trace("Could not unregister from the SAMP hub");
                if (force) {
                    this.isRegistered = false;
                    this.selfId = null;
                    if (destroyInternalHub) {
                        this.stopInternalHub(force);
                    }
                    if (this.aladinXmlRpcServer != null) {
                        ((InternalServer)this.aladinXmlRpcServer).getHttpServer().stop();
                    }
                    if (this.widget != null) {
                        this.widget.animateWidgetReceive(true, false);
                    }
                    this.updateState();
                }
                return false;
            }
            Vector<String> params = new Vector<String>();
            params.add(this.myPrivateKey);
            try {
                this.hubClient.callAndWait(HUB_MSG_UNREGISTER, params);
            }
            catch (Exception e) {
                this.trace("Error while trying to unregister : " + e.getMessage());
                if (force) break block11;
                return false;
            }
        }
        this.isRegistered = false;
        this.selfId = null;
        if (destroyInternalHub) {
            this.stopInternalHub(force);
        }
        if (this.aladinXmlRpcServer != null) {
            ((InternalServer)this.aladinXmlRpcServer).getHttpServer().stop();
        }
        if (this.widget != null) {
            this.widget.animateWidgetReceive(true, false);
        }
        this.updateState();
        Aladin.trace(3, "Successful unregistration from the SAMP hub");
        return true;
    }

    @Override
    public boolean isRegistered() {
        return this.isRegistered;
    }

    private static String getLocalhost() {
        String localhost = System.getProperty(LOCALHOST_PROP, "");
        if (localhost.length() == 0) {
            localhost = "127.0.0.1";
        }
        return localhost;
    }

    @Override
    public synchronized boolean startInternalHub() {
        Aladin.trace(1, "Starting an internal JSAMP hub");
        try {
            Logger.getLogger("org.astrogrid.samp").setLevel(Level.OFF);
            String localhost = SAMPManager.getLocalhost();
            System.setProperty(LOCALHOST_PROP, localhost);
            this.trace("Hub IP set to " + localhost);
            this.internalHub = Hub.runHub(HubServiceMode.NO_GUI);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.updateState();
        return true;
    }

    @Override
    public synchronized void stopInternalHub(boolean dontAsk) {
        if (this.internalHub == null) {
            return;
        }
        String[] registeredApps = this.getAppsConnected();
        if (!dontAsk && registeredApps.length > 0 && !Aladin.confirmation(this.widget, CONFIRM_STOP_HUB)) {
            return;
        }
        Aladin.trace(1, "Stopping internal SAMP hub");
        this.internalHub.shutdown();
        this.internalHub = null;
        this.updateState();
    }

    private String createLabel(Plan p) {
        return p.label == null ? "Plane" : p.label;
    }

    private boolean getHubListener(boolean silent) {
        return this.getHubListener(silent, false);
    }

    /*
     * Exception decompiling
     */
    private boolean getHubListener(boolean silent, boolean launchHubIfNeeded) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private HashMap readKeysFromHubFile(File hubFile) throws IOException {
        String str;
        DataInputStream dis = new DataInputStream(new FileInputStream(hubFile));
        HashMap<String, String> map = new HashMap<String, String>();
        while ((str = dis.readLine()) != null) {
            int idx;
            if (str.startsWith("#") || (idx = str.indexOf(61)) < 0) continue;
            map.put(str.substring(0, idx), str.substring(idx + 1));
        }
        dis.close();
        return map;
    }

    @Override
    public Object getAppWithName(String s) {
        return this.appNamesToURI.get(s);
    }

    private String getNameForApp(String id) {
        if (this.appNamesToURI == null) {
            return "";
        }
        Enumeration e = this.appNamesToURI.keys();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (!id.equals(this.appNamesToURI.get(o))) continue;
            return (String)o;
        }
        return "Unknown";
    }

    @Override
    public String getProtocolName() {
        return "SAMP";
    }

    @Override
    public void sendMessageLoadImage(String url, String name, List recipients) {
        Hashtable<String, String> paramMap = new Hashtable<String, String>();
        paramMap.put("url", url);
        paramMap.put("image-id", url);
        paramMap.put("name", name);
        Hashtable<String, Object> message = new Hashtable<String, Object>();
        message.put(KEY_MTYPE, MSG_LOAD_FITS_IMAGE);
        message.put(KEY_PARAMS, paramMap);
        this.sendNotification(message, recipients.toArray(new String[recipients.size()]));
    }

    public void sendMessageLoadMOC(String url, String name, List recipients) {
        Hashtable<String, String> paramMap = new Hashtable<String, String>();
        paramMap.put("url", url);
        paramMap.put("coverage-id", url);
        paramMap.put("name", name);
        Hashtable<String, Object> message = new Hashtable<String, Object>();
        message.put(KEY_MTYPE, MSG_LOAD_FITS_MOC_COVERAGE);
        message.put(KEY_PARAMS, paramMap);
        this.sendNotification(message, recipients.toArray(new String[recipients.size()]));
    }

    @Override
    public void sendMessageLoadVOTable(String url, String id, String name, Map metadata, List recipients) {
        Hashtable<String, Object> paramMap = new Hashtable<String, Object>();
        paramMap.put("url", url);
        paramMap.put("table-id", id);
        paramMap.put("meta", metadata);
        paramMap.put("name", name);
        Hashtable<String, Object> message = new Hashtable<String, Object>();
        message.put(KEY_MTYPE, MSG_LOAD_VOT_FROM_URL);
        message.put(KEY_PARAMS, paramMap);
        this.sendNotification(message, recipients == null ? null : recipients.toArray(new String[recipients.size()]));
    }

    @Override
    public void sendMessageLoadSpectrum(String url, String spectrumId, String spectrumName, Map metadata, List recipients) {
        Hashtable<String, Object> paramMap = new Hashtable<String, Object>();
        paramMap.put("url", url);
        paramMap.put("spectrum-id", url);
        paramMap.put("meta", metadata);
        paramMap.put("name", spectrumName);
        Hashtable<String, Object> message = new Hashtable<String, Object>();
        message.put(KEY_MTYPE, MSG_LOAD_SPECTRUM);
        message.put(KEY_PARAMS, paramMap);
        this.sendNotification(message, recipients == null ? null : recipients.toArray(new String[recipients.size()]));
    }

    @Override
    public void sendMessageLoadCharac(String url, String name, List recipients) {
        System.err.println("Not implemented yet");
    }

    public String getMessage(AppMessagingInterface.AbstractMessage abstractMsg) {
        if (abstractMsg == null) {
            return null;
        }
        if (abstractMsg.equals(ABSTRACT_MSG_LOAD_FITS)) {
            return MSG_LOAD_FITS_IMAGE;
        }
        if (abstractMsg.equals(ABSTRACT_MSG_LOAD_VOT_FROM_URL)) {
            return MSG_LOAD_VOT_FROM_URL;
        }
        if (abstractMsg.equals(ABSTRACT_MSG_LOAD_SPECTRUM_FROM_URL)) {
            return MSG_LOAD_SPECTRUM;
        }
        if (abstractMsg.equals(ABSTRACT_MSG_LOAD_CHARAC_FROM_URL)) {
            return null;
        }
        return null;
    }

    @Override
    public ArrayList<String> getAppsSupportingTables() {
        ArrayList<String> tableApps = this.getAppsSupporting(MSG_LOAD_VOT_FROM_URL);
        tableApps.addAll(this.getAppsSupporting(MSG_LOAD_FITS_TABLE_FROM_URL));
        return tableApps;
    }

    @Override
    public synchronized ArrayList<String> getAppsSupporting(AppMessagingInterface.AbstractMessage abstractMsg) {
        String implMsg = this.getMessage(abstractMsg);
        return this.getAppsSupporting(implMsg);
    }

    private synchronized ArrayList<String> getAppsSupporting(String message) {
        Map appsMap;
        ArrayList<String> apps = new ArrayList<String>();
        if (message == null) {
            return apps;
        }
        if (!this.isRegistered() || message == null) {
            return apps;
        }
        Vector<String> params = new Vector<String>();
        params.add(this.myPrivateKey);
        params.add(message);
        try {
            appsMap = (Map)this.hubClient.callAndWait(HUB_MSG_GET_SUBSCRIBED_CLIENTS, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            return apps;
        }
        if (appsMap.size() == 0) {
            return apps;
        }
        if (this.appNamesToURI == null) {
            this.appNamesToURI = new Hashtable();
        }
        if (this.appNames == null) {
            this.appNames = new Vector();
        }
        for (String appId : appsMap.keySet()) {
            if (appId.equals(this.selfId)) continue;
            String name = null;
            Enumeration e = this.appNamesToURI.keys();
            while (name == null && e.hasMoreElements()) {
                String tmp = (String)e.nextElement();
                if (!this.appNamesToURI.get(tmp).equals(appId)) continue;
                name = tmp;
            }
            if (name == null) {
                name = this.getAppName(appId);
                if (name == null) {
                    name = "Unknown";
                }
                int k = 1;
                String nameRoot = new String(name);
                while (this.appNames.contains(name)) {
                    name = nameRoot + "-" + k++;
                }
                this.appNames.addElement(name);
                this.appNamesToURI.put(name, appId);
            }
            apps.add(name);
        }
        Collections.sort(apps);
        return apps;
    }

    protected static File getLockFile() {
        String homeDir;
        if (SAMPManager.windowsPlatform()) {
            try {
                homeDir = System.getenv("USERPROFILE");
            }
            catch (Throwable e) {
                try {
                    String[] argv = new String[]{"cmd", "/c", "echo", "%USERPROFILE%"};
                    homeDir = SAMPManager.exec(argv);
                }
                catch (Throwable e2) {
                    homeDir = null;
                }
            }
            if (homeDir == null) {
                homeDir = System.getProperty("user.home");
            }
        } else {
            homeDir = System.getProperty("user.home");
        }
        return new File(homeDir, SAMP_CONF_FILE);
    }

    protected static boolean windowsPlatform() {
        String osName = System.getProperty("os.name");
        return osName.toLowerCase().indexOf("windows") >= 0 || osName.toLowerCase().indexOf("microsoft") >= 0;
    }

    private static String exec(String[] args) throws IOException {
        String err;
        Process process;
        String argv = Arrays.asList(args).toString();
        try {
            process = Runtime.getRuntime().exec(args);
            process.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException("Execution failed: " + argv);
        }
        catch (IOException e) {
            throw (IOException)new IOException("Execution failed: " + argv).initCause(e);
        }
        if (process.exitValue() == 0) {
            return SAMPManager.readStream(process.getInputStream());
        }
        try {
            err = SAMPManager.readStream(process.getErrorStream());
        }
        catch (IOException e) {
            err = "??";
        }
        throw new IOException("Execution failed: " + argv + " - " + err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readStream(InputStream in) throws IOException {
        try {
            int c;
            StringBuffer sb = new StringBuffer();
            while ((c = in.read()) >= 0) {
                sb.append((char)c);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    private boolean selectSources(String tableId, int[] rowIdxArray) {
        if (tableId == null) {
            this.trace("selectSources : argument is null, can't do anything !");
            return false;
        }
        Plan p = this.findPlaneByPlasticID(tableId);
        if (p == null) {
            this.trace("Could not find plane with plastic ID " + tableId);
            return false;
        }
        if (rowIdxArray == null) {
            this.trace("selectSources : second parameter is null, can't do anything !");
            return false;
        }
        this.a.view.selectSourcesByRowNumber((PlanCatalog)p, rowIdxArray);
        return true;
    }

    @Override
    public void pointAtCoords(final double ra, final double dec) {
        if (this.hubClient == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                Hashtable<String, String> msgParams = new Hashtable<String, String>();
                msgParams.put("ra", String.valueOf(ra));
                msgParams.put("dec", String.valueOf(dec));
                Hashtable<String, Object> pointAtMsg = new Hashtable<String, Object>();
                pointAtMsg.put(SAMPManager.KEY_MTYPE, SAMPManager.MSG_POINT_AT_COORDS);
                pointAtMsg.put(SAMPManager.KEY_PARAMS, msgParams);
                SAMPManager.this.sendNotification(pointAtMsg, null);
            }
        }.start();
    }

    private synchronized boolean highlightObject(String id, Integer idx) {
        this.oid = id;
        this.oidx = idx;
        Plan p = this.findPlaneByPlasticID(id);
        if (p == null) {
            this.trace("Could not find plane with plastic ID " + id);
            return false;
        }
        if (idx >= p.pcat.getCount()) {
            return false;
        }
        Source src = (Source)p.pcat.getObj(idx);
        if (this.a.mesure.findSrc(src) == -1) {
            this.a.view.setSelected(src, true);
        }
        this.a.mesure.mcanvas.show(src, 2);
        this.a.view.gotoThere(src);
        return true;
    }

    private synchronized Plan loadVOTFromURL(String votURL, String id, String name, String sender) {
        int idx;
        String planeName;
        MyInputStream is;
        URL url;
        try {
            url = new URL(votURL);
        }
        catch (MalformedURLException e) {
            this.trace("The provided URL string is malformed, can not load VOTable file !");
            return null;
        }
        try {
            is = Util.openStream(url);
        }
        catch (IOException e) {
            this.trace("IOException occured when getting stream from VOTable URL, loading is aborted");
            return null;
        }
        catch (Exception e) {
            this.trace("Exception occured when getting stream from VOTable URL, loading is aborted");
            return null;
        }
        String string = planeName = name == null ? "SAMP" : name;
        if (name == null && id != null && !id.startsWith("http")) {
            planeName = id;
        }
        if ((idx = this.a.calque.newPlan(is, planeName, sender)) >= 0) {
            Plan p = this.a.calque.plan[idx];
            p.addPlasticID(id);
            return p;
        }
        return null;
    }

    private synchronized Plan loadFitsImageFromURL(String fitsURL, String id, String name, String sender) {
        int idx;
        String planeName;
        try {
            new URL(fitsURL);
        }
        catch (MalformedURLException e) {
            this.trace("The provided URL string is malformed, can not load FITS file !");
            return null;
        }
        String string = planeName = name == null ? "SAMP" : name;
        if (name == null && id != null && !id.startsWith("http")) {
            planeName = id;
        }
        if ((idx = this.a.calque.newPlan(fitsURL, planeName, sender)) >= 0) {
            Plan p = this.a.calque.plan[idx];
            p.addPlasticID(id);
            return p;
        }
        return null;
    }

    private synchronized Plan loadVOT(String votable, String id, URI sender) {
        int idx = this.a.calque.newPlan(new ByteArrayInputStream(votable.getBytes()), "SAMP", sender.toString());
        if (idx >= 0) {
            Plan p = this.a.calque.plan[idx];
            p.addPlasticID(id);
            return p;
        }
        return null;
    }

    protected boolean supportMessage(URI message) {
        return true;
    }

    protected boolean mustProcessMessage(URI sender, URI message) {
        return true;
    }

    protected Map getAppMetadata(String appId) {
        try {
            Vector<String> params = new Vector<String>();
            params.add(this.myPrivateKey);
            params.add(appId);
            return (Map)this.hubClient.callAndWait(HUB_MSG_GET_METADATA, params);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getAppName(String appId) {
        Map m = this.getAppMetadata(appId);
        if (m == null) {
            return null;
        }
        Object name = m.get("samp.name");
        return name != null ? name.toString() : null;
    }

    private void sendNotification(Map message, String[] recipients) {
        if (!this.isRegistered) {
            return;
        }
        if (recipients == null) {
            Vector<Object> params = new Vector<Object>();
            params.add(this.myPrivateKey);
            params.add(message);
            try {
                this.hubClient.callAndWait(NOTIFY_ALL, params);
            }
            catch (Exception e) {
                System.err.println("Problem when sending message " + message);
                e.printStackTrace();
            }
        } else {
            for (int i = 0; i < recipients.length; ++i) {
                Vector<Object> params = new Vector<Object>();
                params.add(this.myPrivateKey);
                params.add(recipients[i]);
                params.add(message);
                try {
                    this.hubClient.callAndWait(NOTIFY, params);
                    continue;
                }
                catch (Exception e) {
                    System.err.println("Problem when sending message " + message);
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public boolean broadcastTable(final Plan pc, final String[] recipients) {
        File tmpFile;
        Aladin.trace(3, "Broadcasting table " + pc.getLabel() + " to " + (recipients == null ? "everyone" : recipients.length + " applications"));
        if (this.widget != null) {
            this.widget.animateWidgetSend();
        }
        if ((tmpFile = this.a.createTempFile("samp" + SAMPUtil.sanitizeFilename(pc.getLabel()), ".xml")) == null) {
            this.trace("Couldn't create temporary file, can't broadcast table !");
            return false;
        }
        new Thread("AladinSampSendTable"){

            @Override
            public void run() {
                if (((SAMPManager)SAMPManager.this).a.save == null) {
                    ((SAMPManager)SAMPManager.this).a.save = new Save(SAMPManager.this.a);
                }
                ((SAMPManager)SAMPManager.this).a.save.saveCatVOTable(tmpFile, pc, false, false);
                URL url = SAMPUtil.getURLForFile(tmpFile);
                String urlStr = url.toString();
                String id = pc.getPlasticID();
                if (id == null) {
                    id = urlStr;
                    pc.addPlasticID(id);
                }
                Hashtable<String, Object> message = new Hashtable<String, Object>();
                message.put(SAMPManager.KEY_MTYPE, SAMPManager.MSG_LOAD_VOT_FROM_URL);
                Hashtable<String, String> paramMap = new Hashtable<String, String>();
                paramMap.put("url", urlStr);
                paramMap.put("table-id", id);
                SAMPManager.this.trace("id initial : " + id);
                String label = SAMPManager.this.createLabel(pc);
                paramMap.put("name", label);
                message.put(SAMPManager.KEY_PARAMS, paramMap);
                SAMPManager.this.trace("Broadcast table with URL: " + urlStr);
                ArrayList recipientsList = null;
                if (recipients != null) {
                    recipientsList = new ArrayList();
                    for (int i = 0; i < recipients.length; ++i) {
                        Object app = SAMPManager.this.appNamesToURI.get(recipients[i]);
                        if (app != null) {
                            recipientsList.add(app);
                            SAMPManager.this.trace("Adding " + app + " to list of recipients");
                            continue;
                        }
                        SAMPManager.this.trace("Couldn't find ID of application " + recipients[i]);
                    }
                }
                SAMPManager.this.sendNotification(message, recipients == null ? null : recipientsList.toArray(new String[recipientsList.size()]));
                SAMPManager.this.a.log("SAMP", "broadcast table");
            }
        }.start();
        return true;
    }

    @Override
    public boolean broadcastImage(final Plan pi, final String[] recipients) {
        File tmpFile;
        Aladin.trace(3, "Broadcasting image " + pi.getLabel() + " to " + (recipients == null ? "everyone" : recipients.length + " applications"));
        if (pi == null || !(pi instanceof PlanImage)) {
            return false;
        }
        if (this.widget != null) {
            this.widget.animateWidgetSend();
        }
        if ((tmpFile = this.a.createTempFile("samp" + SAMPUtil.sanitizeFilename(pi.getLabel()), ".fits")) == null) {
            this.trace("Couldn't create temporary file, can't broadcast image !");
            return false;
        }
        new Thread("AladinSAMPSendImage"){

            @Override
            public void run() {
                if (((SAMPManager)SAMPManager.this).a.save == null) {
                    ((SAMPManager)SAMPManager.this).a.save = new Save(SAMPManager.this.a);
                }
                ((SAMPManager)SAMPManager.this).a.save.saveImageFITS(tmpFile, (PlanImage)pi);
                URL url = SAMPUtil.getURLForFile(tmpFile);
                String urlStr = url.toString();
                String id = pi.getPlasticID();
                if (id == null) {
                    id = urlStr;
                    pi.addPlasticID(id);
                }
                Hashtable<String, Object> message = new Hashtable<String, Object>();
                message.put(SAMPManager.KEY_MTYPE, SAMPManager.MSG_LOAD_FITS_IMAGE);
                Hashtable<String, String> paramMap = new Hashtable<String, String>();
                paramMap.put("url", urlStr);
                paramMap.put("image-id", id);
                String label = SAMPManager.this.createLabel(pi);
                paramMap.put("name", label);
                message.put(SAMPManager.KEY_PARAMS, paramMap);
                ArrayList recipientsList = null;
                if (recipients != null) {
                    recipientsList = new ArrayList();
                    for (int i = 0; i < recipients.length; ++i) {
                        Object app = SAMPManager.this.appNamesToURI.get(recipients[i]);
                        if (app != null) {
                            recipientsList.add(app);
                            SAMPManager.this.trace("Adding " + app + " to list of recipients");
                            continue;
                        }
                        SAMPManager.this.trace("Couldn't find ID of application " + recipients[i]);
                    }
                }
                SAMPManager.this.sendNotification(message, recipients == null ? null : recipientsList.toArray(new String[recipientsList.size()]));
                SAMPManager.this.a.log("SAMP", "broadcast image");
            }
        }.start();
        return true;
    }

    private boolean loadVOResources(Object[] args, String senderId) {
        if (this.resourceChooser == null) {
            this.resourceChooser = new ResourceChooser();
        }
        if (args[0] == null) {
            this.trace("loadVOResources : first parameter is null, can't do anything !");
            return false;
        }
        if (!(args[0] instanceof List)) {
            this.trace("loadVOResources : first parameter is not of type List, can't do anything !");
        }
        String[] uris = ((List)args[0]).toArray(new String[((List)args[0]).size()]);
        this.resourceChooser.updateFrame(uris, senderId);
        return true;
    }

    @Override
    public void sendSelectObjectsMsg() {
        if (!this.a.plasticPrefs.getBooleanValue("PlasticSelect")) {
            return;
        }
        if (!this.isRegistered()) {
            return;
        }
        new Thread("AladinSampSendSelect"){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                Plan p;
                Source[] sources;
                block12: {
                    sources = ((SAMPManager)SAMPManager.this).a.view.getSelectedSources();
                    if (sources == null) {
                        return;
                    }
                    ArrayList apps = SAMPManager.this.getAppsSupporting(SAMPManager.MSG_SELECT_OBJECTS);
                    if (apps == null || apps.size() == 0) {
                        SAMPManager.this.trace("None of the connected applications supports the 'select objects' message");
                        return;
                    }
                    SAMPManager.this.trace("Sending message table.select.rowList");
                    if (Aladin.levelTrace >= 3) {
                        for (int i = 0; i < sources.length && i < 3; ++i) {
                            Aladin.trace(3, "select object : " + sources[i]);
                        }
                    }
                    if ((p = SAMPManager.this.findPlaneForSources(sources)) == null) {
                        if (sources.length == 0 && SAMPManager.this.lastPlaneWithSelectedSrc != null) {
                            SAMPManager.this.trace("0 object selected, will send a 'deselection' message");
                            p = SAMPManager.this.lastPlaneWithSelectedSrc;
                            SAMPManager.this.lastPlaneWithSelectedSrc = null;
                            break block12;
                        } else {
                            SAMPManager.this.lastPlaneWithSelectedSrc = p;
                            return;
                        }
                    }
                    SAMPManager.this.lastPlaneWithSelectedSrc = p;
                }
                if (p.getPlasticID() == null) {
                    return;
                }
                Vector v = SAMPManager.this.getSequenceNumber(p, sources);
                String[] idxItems = new String[v.size()];
                Enumeration e = v.elements();
                int k = 0;
                while (true) {
                    Integer idx;
                    if (!e.hasMoreElements()) {
                        Hashtable<String, Object> message = new Hashtable<String, Object>();
                        message.put(SAMPManager.KEY_MTYPE, SAMPManager.MSG_SELECT_OBJECTS);
                        Hashtable<String, Object> paramMap = new Hashtable<String, Object>();
                        message.put(SAMPManager.KEY_PARAMS, paramMap);
                        paramMap.put("table-id", p.getPlasticID());
                        SAMPManager.this.trace("envoi id : " + p.getPlasticID());
                        paramMap.put("row-list", Arrays.asList(idxItems));
                        SAMPManager.this.sendNotification(message, null);
                        return;
                    }
                    try {
                        idx = (Integer)e.nextElement();
                    }
                    catch (ClassCastException cce) {
                        ((SAMPManager)SAMPManager.this).a.command.println("Encountered bad format for SAMP int");
                        cce.printStackTrace();
                        continue;
                    }
                    idxItems[k] = idx.toString();
                    ++k;
                }
            }
        }.start();
    }

    private Plan findPlaneForSources(Source[] sources) {
        return sources == null || sources.length == 0 ? null : sources[0].plan;
    }

    private Plan findPlaneByPlasticID(String plasticID) {
        Plan p = null;
        Plan[] plans = this.a.calque.plan;
        for (int i = 0; i < plans.length; ++i) {
            if (plans[i] == null || !plans[i].isSimpleCatalog() || !plans[i].hasPlasticID(plasticID)) continue;
            p = plans[i];
        }
        return p;
    }

    private Vector getSequenceNumber(Plan p, Source[] sources) {
        Vector<Integer> v = new Vector<Integer>();
        Iterator<Obj> it = p.iterator();
        int i = 0;
        while (it.hasNext()) {
            Obj o = it.next();
            for (int j = 0; j < sources.length; ++j) {
                Source sTmp;
                if (o == null || !(sTmp = (Source)o).equals(sources[j])) continue;
                v.addElement(new Integer(i));
                break;
            }
            ++i;
        }
        return v;
    }

    @Override
    public boolean internalHubRunning() {
        return this.internalHub != null;
    }

    @Override
    public void updateState() {
        new Thread("AladinSAMPUpdate"){

            @Override
            public void run() {
                block9: {
                    try {
                        if (SAMPManager.this.isRegistered()) {
                            if (SAMPManager.this.getAppsConnected().length > 0) {
                                SAMPManager.this.curState = 3;
                            } else {
                                SAMPManager.this.curState = 2;
                            }
                        } else if (SAMPManager.getLockFile().exists()) {
                            SAMPManager.this.curState = 1;
                        } else {
                            SAMPManager.this.curState = 0;
                        }
                    }
                    catch (Exception e) {
                        if (Aladin.levelTrace < 3) break block9;
                        e.printStackTrace();
                    }
                }
                if (SAMPManager.this.widget != null) {
                    SAMPManager.this.widget.updateStatus(SAMPManager.this.curState);
                }
            }
        }.start();
    }

    protected String[] getAppsConnected() {
        Vector<String> v = new Vector<String>();
        try {
            Vector<String> params = new Vector<String>();
            params.add(this.myPrivateKey);
            Iterator it = ((Vector)this.hubClient.callAndWait(HUB_MSG_GET_REGISTERED_CLIENTS, params)).iterator();
            while (it.hasNext()) {
                String curId = it.next().toString();
                if (curId.equals(this.selfId.toString()) || curId.equals(this.hubId)) continue;
                v.addElement(curId);
            }
        }
        catch (Exception e) {
            return new String[0];
        }
        Object[] ids = new String[v.size()];
        v.copyInto(ids);
        v = null;
        return ids;
    }

    @Override
    public void sendHighlightObjectsMsg(Source source) {
        if (!this.a.plasticPrefs.getBooleanValue("PlasticHighlight")) {
            return;
        }
        if (source == null) {
            return;
        }
        if (!this.isRegistered()) {
            return;
        }
        Source[] sources = new Source[]{source};
        Plan p = this.findPlaneForSources(sources);
        if (p == null) {
            this.trace("Could not find plane, can't send SAMP message");
            return;
        }
        Vector v = this.getSequenceNumber(p, sources);
        if (v.size() == 0) {
            this.trace("Could not find sequence number for source " + source);
            return;
        }
        Integer idx = (Integer)v.elementAt(0);
        if (this.oidx != null && this.oid != null && this.oid.equals(p.getPlasticID()) && this.oidx.equals(idx)) {
            return;
        }
        this.oidx = idx;
        this.oid = p.getPlasticID();
        Hashtable<String, Object> message = new Hashtable<String, Object>();
        message.put(KEY_MTYPE, MSG_HIGHLIGHT_OBJECT);
        Hashtable<String, String> paramMap = new Hashtable<String, String>();
        paramMap.put("table-id", p.getPlasticID());
        paramMap.put("row", idx.toString());
        message.put(KEY_PARAMS, paramMap);
        this.sendNotification(message, null);
    }

    @Override
    public boolean ping() {
        if (this.hubClient == null) {
            return false;
        }
        try {
            this.hubClient.callAndWait(HUB_MSG_PING, new Vector());
        }
        catch (Exception e) {
            this.unregister(true);
            this.isRegistered = false;
            this.updateState();
            return false;
        }
        if (this.updateAppsListNeeded) {
            this.getAppsSupporting(MSG_PING);
            this.updateAppsListNeeded = false;
        }
        return true;
    }

    private void replyToMessage(String msgId, String status, Map result, String error) {
        if (msgId == null) {
            this.trace("Can not reply to message because message-id has not been set in initial message !");
            return;
        }
        Hashtable<String, Object> responseMap = new Hashtable<String, Object>();
        responseMap.put(MSG_REPLY_SAMP_STATUS, status);
        responseMap.put(MSG_REPLY_SAMP_RESULT, result == null ? new Hashtable() : result);
        if (error != null) {
            Hashtable<String, String> errorMap = new Hashtable<String, String>();
            errorMap.put("samp.errortxt", error);
            responseMap.put("samp.error", errorMap);
        }
        final Vector<Object> params = new Vector<Object>();
        params.add(this.myPrivateKey);
        params.add(msgId);
        params.add(responseMap);
        new Thread(){

            @Override
            public void run() {
                try {
                    SAMPManager.this.hubClient.callAndWait(SAMPManager.HUB_MSG_REPLY, params);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    @Override
    public void setPlasticWidget(PlasticWidget widget) {
        this.widget = widget;
    }

    @Override
    public PlasticWidget getPlasticWidget() {
        return this.widget;
    }

    @Override
    public void trace(String s) {
        if (!this.sampTrace) {
            return;
        }
        System.out.println("** SAMP : " + s);
    }

    @Override
    public boolean getPlasticTrace() {
        return this.sampTrace;
    }

    @Override
    public void setPlasticTrace(boolean plasticTrace) {
        this.sampTrace = plasticTrace;
        if (this.sampTrace) {
            Logger.getLogger("org.astrogrid.samp").setLevel(Level.ALL);
        } else {
            Logger.getLogger("org.astrogrid.samp").setLevel(Level.OFF);
        }
    }

    @Override
    public void planeLoaded(PlaneLoadEvent ple) {
        String msgId = this.planesToMsgIds.get(ple.plane);
        if (msgId == null) {
            System.err.println("Ohoh, something weird happened : could not find msgId for plane " + ple.plane.getLabel());
            return;
        }
        this.trace("Received PlaneLoadEvent from plane " + ple.plane.getLabel());
        if (ple.status == PlaneLoadEvent.SUCCESS) {
            this.replyToMessage(msgId, MSG_REPLY_SAMP_STATUSOK, null, null);
        } else {
            this.replyToMessage(msgId, "samp.error", null, ple.errorMsg);
        }
        ple.plane.removeListener(this);
        this.planesToMsgIds.remove(ple.plane);
    }

    @Override
    public boolean canHandleCall(String arg0) {
        return true;
    }

    @Override
    public Object handleCall(String arg0, List arg1, Object arg2) throws Exception {
        return this.execute(arg0, new Vector(arg1));
    }

    static {
        startPort = 42195;
        VOID = "";
        TRUE = Boolean.TRUE;
        FALSE = Boolean.FALSE;
    }

    class ResourceChooser
    extends JFrame
    implements ActionListener {
        JList list;
        DefaultListModel model;
        private boolean firstShow;
        String[] uris;
        VOResource[] resources;

        ResourceChooser() {
            super("Choose resources to keep");
            this.firstShow = true;
            Util.setCloseShortcut(this, false);
            this.getContentPane().setLayout(new BorderLayout());
        }

        void updateFrame(final String[] uris, String senderId) {
            this.uris = uris;
            this.getContentPane().removeAll();
            ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JPanel pTop = new JPanel();
            JLabel label = new JLabel("<html><b>" + SAMPManager.this.getNameForApp(senderId) + "</b> has sent some registry resources.<br>Select resources you want to keep:<br></html>");
            pTop.add(label);
            this.getContentPane().add((Component)pTop, "North");
            JPanel pCenter = new JPanel();
            DefaultListSelectionModel selectionModel = new DefaultListSelectionModel();
            this.list = new JList();
            this.list.setSelectionModel(selectionModel);
            JScrollPane scrollPane = new JScrollPane(this.list);
            this.model = new DefaultListModel();
            for (int i = 0; i < uris.length; ++i) {
                this.model.addElement(uris[i]);
            }
            this.list.setModel(this.model);
            pCenter.add(scrollPane);
            this.list.setPreferredSize(new Dimension(550, 200));
            scrollPane.setPreferredSize(new Dimension(550, 200));
            this.getContentPane().add((Component)pCenter, "Center");
            JPanel pBottom = new JPanel(new FlowLayout());
            JButton okBtn = new JButton("OK");
            okBtn.addActionListener(this);
            okBtn.setFont(Aladin.BOLD);
            pBottom.add(okBtn);
            JButton closeBtn = new JButton("Close");
            closeBtn.addActionListener(this);
            pBottom.add(closeBtn);
            this.getContentPane().add((Component)pBottom, "South");
            this.pack();
            if (this.firstShow) {
                this.firstShow = false;
                this.setSize(new Dimension(600, 300));
                this.setLocation(200, 200);
            }
            this.setVisible(true);
            this.toFront();
            new Thread("SAMPManager:resolveIVORN"){

                @Override
                public void run() {
                    ResourceChooser.this.resolveIVORN(uris);
                }
            }.start();
        }

        private void resolveIVORN(String[] uris) {
            this.list.getSelectionModel().clearSelection();
            this.resources = new VOResource[uris.length];
            for (int i = 0; i < uris.length; ++i) {
                VOResource ivorn;
                this.resources[i] = ivorn = FrameServer.getIvorn(uris[i]);
                if (ivorn == null) continue;
                this.model.setElementAt(uris[i] + " - " + (ivorn == null ? "" : ivorn.desc), i);
                if (ivorn == null || ivorn.type == null || !ivorn.type.equals("siap") && !ivorn.type.equals("ssap") && !ivorn.type.equals("cs")) continue;
                this.list.getSelectionModel().addSelectionInterval(i, i);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!Aladin.PROTO) {
                return;
            }
            String s = e.getActionCommand();
            if (s.equals("Close")) {
                this.setVisible(false);
            } else if (s.equals("OK")) {
                int[] indices = this.list.getSelectedIndices();
                ArrayList<VOResource> selectedResources = new ArrayList<VOResource>();
                for (int i = 0; i < indices.length; ++i) {
                    selectedResources.add(this.resources[indices[i]]);
                }
                Iterator it = selectedResources.iterator();
                MyByteArrayStream bas = new MyByteArrayStream();
                while (it.hasNext()) {
                    VOResource curIvorn = (VOResource)it.next();
                    FrameServer.createRecord(bas, curIvorn.type, curIvorn.actionName, curIvorn.institute, curIvorn.baseUrl, curIvorn.desc, curIvorn.identifier, "SAMP");
                    bas.write("%Aladin.Menu VO res.\n\n");
                }
                Glu cfr_ignored_0 = ((SAMPManager)SAMPManager.this).a.glu;
                Glu.vGluServer = new Vector(50);
                ((SAMPManager)SAMPManager.this).a.glu.loadGluDic(new DataInputStream(bas.getInputStream()), true, false);
                Glu cfr_ignored_1 = ((SAMPManager)SAMPManager.this).a.glu;
                int n = Glu.vGluServer.size();
                if (n == 0) {
                    return;
                }
                Server[] newServer = new Server[((SAMPManager)SAMPManager.this).a.dialog.server.length + n];
                MyButton[] newButton = new MyButton[((SAMPManager)SAMPManager.this).a.dialog.server.length + n];
                System.arraycopy(((SAMPManager)SAMPManager.this).a.dialog.server, 0, newServer, 0, ((SAMPManager)SAMPManager.this).a.dialog.server.length);
                System.arraycopy(((SAMPManager)SAMPManager.this).a.dialog.buttons, 0, newButton, 0, ((SAMPManager)SAMPManager.this).a.dialog.buttons.length);
                for (int i = 0; i < n; ++i) {
                    Glu cfr_ignored_2 = ((SAMPManager)SAMPManager.this).a.glu;
                    newServer[((SAMPManager)SAMPManager.this).a.dialog.server.length + i] = (Server)Glu.vGluServer.elementAt(i);
                }
                ((SAMPManager)SAMPManager.this).a.dialog.server = newServer;
                ((SAMPManager)SAMPManager.this).a.dialog.buttons = newButton;
                newServer = null;
                newButton = null;
                Glu cfr_ignored_3 = ((SAMPManager)SAMPManager.this).a.glu;
                Enumeration eServers = Glu.vGluServer.elements();
                while (eServers.hasMoreElements()) {
                    Server curServer = (Server)eServers.nextElement();
                    ((SAMPManager)SAMPManager.this).a.dialog.voResPopup.addItem(curServer.aladinLabel);
                    curServer.setOpaque(true);
                    ((SAMPManager)SAMPManager.this).a.dialog.mp.add(curServer.aladinLabel, curServer);
                }
                this.setVisible(false);
                ((SAMPManager)SAMPManager.this).a.dialog.show();
                ((SAMPManager)SAMPManager.this).a.dialog.toFront();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((SAMPManager)SAMPManager.this).a.dialog.show(((SAMPManager)SAMPManager.this).a.dialog.voResPopup);
                    }
                });
            }
        }
    }
}

