/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Plan;
import cds.aladin.Repere;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.Graphics;
import java.awt.Point;

public class RepereSpectrum
extends Repere {
    protected RepereSpectrum(Plan plan, ViewSimple v, double x, double y) {
        super(plan, v, x, y);
    }

    @Override
    protected boolean draw(Graphics g, ViewSimple v, int dx, int dy) {
        if (!this.isVisible()) {
            return false;
        }
        Point p = this.getViewCoord(v, this.L, this.L);
        if (p == null) {
            return false;
        }
        p.x += dx;
        p.y += dy;
        g.setColor(this.getColor());
        Util.drawCircle7(g, p.x, p.y);
        if (this.isSelected() && this.plan.aladin.view.nbSelectedObjet() <= 2) {
            this.cutOn();
        } else {
            this.cutOff();
        }
        return super.draw(g, v, dx, dy);
    }

    @Override
    protected void remove() {
        this.cutOff();
    }

    protected void cutOff() {
        this.plan.aladin.calque.zoom.zoomView.stopHist();
        this.plan.aladin.calque.zoom.zoomView.cutOff(this);
    }

    @Override
    protected boolean cutOn() {
        ViewSimple v = this.plan.aladin.view.getCurrentView();
        if (v == null || this.plan.aladin.toolBox.getTool() == 8) {
            return false;
        }
        Plan pc = v.pref;
        if (!pc.isCube()) {
            return false;
        }
        double x = this.xv[v.n];
        double y = this.yv[v.n];
        int n = pc.getDepth();
        int[] res = new int[n];
        try {
            for (int z = 0; z < n; ++z) {
                res[z] = pc.getPixel8bit(z, x, y) & 0xFF;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.plan.aladin.calque.zoom.zoomView.setCut(this, res, 0);
        return true;
    }
}

