/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.CanvasColorMap;
import cds.aladin.PlanImage;
import cds.aladin.Rainbow;
import cds.aladin.RectangleD;
import cds.aladin.ViewSimple;
import java.awt.Graphics;

public class RainbowPixel
extends Rainbow {
    private ViewSimple v;
    private boolean flagRedCM;
    private double oLastPos = -1.0;
    private long t0 = -1L;

    public RainbowPixel(Aladin aladin, ViewSimple v) {
        super(aladin);
        this.r = new RectangleD(10.0, v.getHeight() - 330, 30.0, 300.0);
        this.v = v;
        this.flagRedCM = false;
    }

    private PlanImage getPlan() {
        return (PlanImage)this.v.pref;
    }

    public void setRedCM() {
        double greyLevel;
        if (this.flagRedCM && this.lastPos == this.oLastPos) {
            return;
        }
        if (!this.flagRedCM) {
            if (this.t0 == -1L) {
                this.t0 = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - this.t0 < 200L) {
                return;
            }
        }
        if ((greyLevel = 256.0 * this.lastPos) > 255.0) {
            greyLevel = 255.0;
        }
        PlanImage pimg = this.getPlan();
        pimg.setCM(CanvasColorMap.getCMBand((int)greyLevel, this.getPlan().video == 1, true, pimg.isTransparent()));
        this.oLastPos = this.lastPos;
        this.flagRedCM = true;
    }

    public void restoreCM() {
        this.t0 = -1L;
        if (!this.flagRedCM) {
            return;
        }
        this.getPlan().restoreCM();
        this.flagRedCM = false;
    }

    public boolean isAvailable() {
        return this.v.pref.hasAvailablePixels();
    }

    @Override
    public boolean mouseMove(double xview, double yview) {
        boolean rep = super.mouseMove(xview, yview);
        if (this.isIn && !this.isSelected) {
            this.setRedCM();
        } else {
            this.restoreCM();
        }
        return rep;
    }

    @Override
    public boolean submit(ViewSimple v) {
        this.restoreCM();
        return super.submit(v);
    }

    @Override
    public void draw(Graphics gr, ViewSimple v, int dx, int dy) {
        if (!this.isAvailable()) {
            return;
        }
        super.draw(gr, v, dx, dy);
    }
}

