/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Curseur;
import cds.aladin.FilterProperties;
import cds.aladin.FrameNewCalib;
import cds.aladin.Histogramme;
import cds.aladin.Legende;
import cds.aladin.Localisation;
import cds.aladin.MyAnchor;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanBGCat;
import cds.aladin.PlanBGProgen;
import cds.aladin.PlanCatalog;
import cds.aladin.PlanContour;
import cds.aladin.PlanField;
import cds.aladin.PlanFolder;
import cds.aladin.PlanFree;
import cds.aladin.PlanHealpix;
import cds.aladin.PlanImage;
import cds.aladin.PlanImageBlink;
import cds.aladin.PlanImageRGB;
import cds.aladin.PlanMoc;
import cds.aladin.PlanSTMoc;
import cds.aladin.PlanTMoc;
import cds.aladin.PlanTool;
import cds.aladin.Projection;
import cds.aladin.ServerGlu;
import cds.aladin.Source;
import cds.aladin.bookmark.FrameBookmarks;
import cds.aladin.prop.PropPanel;
import cds.astro.Astrotime;
import cds.moc.SMoc;
import cds.moc.STMoc;
import cds.moc.TMoc;
import cds.tools.Astrodate;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Properties
extends JFrame
implements ActionListener,
ChangeListener {
    String SEEFITS;
    String SEEHIPSPROP;
    String SEEPARSING;
    String TABLEINFO;
    String NEWCALIB;
    String MODCALIB;
    String SHOWFOVS;
    String HIDEFOVS;
    String TITLE;
    String BANNER;
    String APPLY;
    String CLOSE;
    String NOFILTER;
    String LABEL;
    String COLOR;
    String ERROR;
    String STATE;
    String UNDER;
    String SHAPE;
    String IMG;
    String VIEWABLE;
    String LEVEL;
    String REFCOORD;
    String REFROTATE;
    String ANGLE;
    String COMPONENT;
    String SOURCE;
    String INF;
    String FMT;
    String EPOCH;
    String DATEOBS;
    String WCSEQ;
    String SIZE;
    String PIXMODE;
    String FRAME;
    String DELAY;
    String ORIGIN;
    String FILTER;
    String FILTERB;
    String ASTRED;
    String XYRED;
    String PROJ;
    String NONE;
    String METHOD;
    String CENTER;
    String SELECTFIELD;
    String DEFCATPROJ;
    String FLIPFLOP;
    String ASSFOV;
    String LOCAL;
    String GLOBAL;
    String SCOPE;
    String HSCOPE;
    String OPACITY;
    String OPACITYLEVEL;
    String DENSITY;
    String WHITE;
    String BLACK;
    String AUTO;
    String COLORBG;
    String POLA;
    String DISPLAYPOLA;
    String GENERATEPOLAAMP;
    String GENERATEPOLAANG;
    String CURRENTFIELD;
    String POLAOPTIONS;
    String SEGMENTLEN;
    String SEGMENTTHICK;
    String SEGMENTDENSITY;
    String SCALINGFACTOR;
    String POINTING;
    String POINTINGLABEL;
    String FULLDESCR;
    String ON = "On";
    String OFF = "Off";
    Aladin aladin;
    Plan plan;
    JPanel panel;
    JPanel propPanel;
    PlanFree pmemo = null;
    int hcmemo = 0;
    boolean flagHide = true;
    JTextField label;
    TextField blankField;
    Couleur couleur = null;
    JComboBox sourceType = null;
    ButtonGroup longitude;
    JRadioButton longitudeDescending;
    JRadioButton longitudeAscending;
    ButtonGroup scope;
    JRadioButton scopeGlobal;
    JRadioButton scopeLocal;
    ButtonGroup xyLock = null;
    JComboBox planRefChoice = null;
    JComboBox specificProj = null;
    JComboBox specificFrame = null;
    Plan[] planRef = null;
    JComboBox projsChoice = null;
    Projection[] projs = null;
    JButton modCalib = null;
    JButton toGenFilterButton = null;
    JRadioButton nofilter = null;
    JTextField centerField = null;
    String sField = null;
    JTextField rotateCenter = null;
    String rotateCenterField = null;
    JTextField url = null;
    JTextField rollField = null;
    JTextField epField = null;
    JTextField eqField = null;
    String sEquinox = null;
    String sRoll = null;
    JRadioButton cbT = null;
    JRadioButton cbS = null;
    JRadioButton cbG = null;
    JButton btnDisplayPola;
    JButton btnDisplayAmp;
    JButton btnDisplayAng;
    JCheckBox[] contoursCB;
    Couleur[] contoursCouleurs;
    Curseur curs = null;
    JButton[] filterButtons = null;
    JPanel panelCont;
    JPanel panelScroll;
    JScrollPane scroll;
    JSlider opacityLevel;
    JSlider gapOrder;
    JSlider epochSlider;
    JSlider scalingFactor;
    JSlider polaSegmentLen;
    JSlider polaSegmentThickness;
    JSlider polaSegmentDensity;
    private ButtonGroup cb;
    static Vector frameProp = new Vector(10);
    private ButtonGroup filterCB;
    private TimeField timeField = null;
    private Border border = null;
    static boolean flagFullMaj = false;

    protected void createChaine() {
        if (this.SEEFITS != null) {
            return;
        }
        this.SEEFITS = Aladin.chaine.getString("PROPSEEFITS");
        this.SEEHIPSPROP = Aladin.chaine.getString("PROPSEEHIPSPROP");
        this.SEEPARSING = Aladin.chaine.getString("VWTABLEINFO");
        this.TABLEINFO = Aladin.chaine.getString("PROPTABLEINFO");
        this.NEWCALIB = Aladin.chaine.getString("PROPNEWCALIB");
        this.MODCALIB = Aladin.chaine.getString("PROPMODCALIB");
        this.SHOWFOVS = Aladin.chaine.getString("PROPSHOWFOVS");
        this.HIDEFOVS = Aladin.chaine.getString("PROPHIDEFOVS");
        this.TITLE = Aladin.chaine.getString("PROPTITLE");
        this.BANNER = Aladin.chaine.getString("PROPBANNER");
        this.APPLY = Aladin.chaine.getString("PROPAPPLY");
        this.CLOSE = Aladin.chaine.getString("PROPCLOSE");
        this.NOFILTER = Aladin.chaine.getString("PROPNOFILTER");
        this.LABEL = Aladin.chaine.getString("PROPLABEL");
        this.COLOR = Aladin.chaine.getString("PROPCOLOR");
        this.ERROR = Aladin.chaine.getString("PROPERROR");
        this.STATE = Aladin.chaine.getString("PROPSTATE");
        this.UNDER = Aladin.chaine.getString("PROPUNDER");
        this.SHAPE = Aladin.chaine.getString("PROPSHAPE");
        this.IMG = Aladin.chaine.getString("PROPIMG");
        this.VIEWABLE = Aladin.chaine.getString("PROPVIEWABLE");
        this.LEVEL = Aladin.chaine.getString("PROPLEVEL");
        this.REFCOORD = Aladin.chaine.getString("PROPREFCOORD");
        this.REFROTATE = Aladin.chaine.getString("PROPREFROTATE");
        this.ANGLE = Aladin.chaine.getString("PROPANGLE");
        this.COMPONENT = Aladin.chaine.getString("PROPCOMPONENT");
        this.SOURCE = Aladin.chaine.getString("PROPSOURCE");
        this.INF = Aladin.chaine.getString("PROPINF");
        this.FMT = Aladin.chaine.getString("PROPFMT");
        this.EPOCH = Aladin.chaine.getString("PROPEPOCH");
        this.DATEOBS = Aladin.chaine.getString("PROPDATEOBS");
        this.WCSEQ = Aladin.chaine.getString("PROPWCSEQ");
        this.PIXMODE = Aladin.chaine.getString("PROPPIXMODE");
        this.SIZE = Aladin.chaine.getString("PROPSIZE");
        this.FRAME = Aladin.chaine.getString("PROPFRAME");
        this.DELAY = Aladin.chaine.getString("PROPDELAY");
        this.ORIGIN = Aladin.chaine.getString("PROPORIGIN");
        this.FILTER = Aladin.chaine.getString("PROPFILTER");
        this.FILTERB = Aladin.chaine.getString("PROPFILTERB");
        this.ASTRED = Aladin.chaine.getString("PROPASTRED");
        this.XYRED = Aladin.chaine.getString("PROPXYRED");
        this.PROJ = Aladin.chaine.getString("PROPPROJ");
        this.NONE = Aladin.chaine.getString("PROPNONE");
        this.METHOD = Aladin.chaine.getString("PROPMETHOD");
        this.CENTER = Aladin.chaine.getString("PROPCENTER");
        this.SELECTFIELD = Aladin.chaine.getString("PROPSELECTFIELD");
        this.DEFCATPROJ = Aladin.chaine.getString("PROPDEFCATPROJ");
        this.FLIPFLOP = Aladin.chaine.getString("PROPFLIPFLOP");
        this.ASSFOV = Aladin.chaine.getString("PROPASSFOV");
        this.LOCAL = Aladin.chaine.getString("PROPLOCAL");
        this.GLOBAL = Aladin.chaine.getString("PROPGLOBAL");
        this.SCOPE = Aladin.chaine.getString("PROPSCOPE");
        this.HSCOPE = Aladin.chaine.getString("PROPHSCOPE");
        this.OPACITY = Aladin.chaine.getString("PROPOPACITY");
        this.OPACITYLEVEL = Aladin.chaine.getString("PROPOPACITYLEVEL");
        this.DENSITY = Aladin.chaine.getString("PROPDENSITY");
        this.AUTO = Aladin.chaine.getString("PROPAUTO");
        this.WHITE = Aladin.chaine.getString("PROPWHITE");
        this.BLACK = Aladin.chaine.getString("PROPBLACK");
        this.COLORBG = "Background";
        this.POLA = Aladin.chaine.getString("PROPPOLA");
        this.DISPLAYPOLA = Aladin.chaine.getString("PROPDISPLAYPOLA");
        this.GENERATEPOLAAMP = Aladin.chaine.getString("PROPGENERATEOPOLAAMP");
        this.GENERATEPOLAANG = Aladin.chaine.getString("PROPGENERATEOPOLAANG");
        this.CURRENTFIELD = Aladin.chaine.getString("PROPCURRENTFIELD");
        this.POLAOPTIONS = Aladin.chaine.getString("PROPPOLAOPTIONS");
        this.SEGMENTLEN = Aladin.chaine.getString("PROPSEGMENTLENGTH");
        this.SEGMENTTHICK = Aladin.chaine.getString("PROPSEGMENTTHICK");
        this.SEGMENTDENSITY = Aladin.chaine.getString("PROPSEGMENTDENSITY");
        this.SCALINGFACTOR = Aladin.chaine.getString("PROPSCALINGFACTOR");
        this.POINTING = Aladin.chaine.getString("PROPPOINTING");
        this.POINTINGLABEL = Aladin.chaine.getString("PROPPOINTINGLABEL");
        this.FULLDESCR = Aladin.chaine.getString("PROPFULLDESCR");
    }

    protected Properties(Plan p) {
        this.aladin = p.aladin;
        Aladin.setIcon(this);
        this.createChaine();
        this.setTitle(this.TITLE);
        this.enableEvents(64L);
        Util.setCloseShortcut(this, true, this.aladin);
        this.plan = p;
        Properties.addProperties(this);
        int i = frameProp.size();
        Point t = Aladin.computeLocation(this);
        t.x += i * 20;
        t.y += i * 20;
        this.setLocation(t);
    }

    void showProp() {
        this.showProp(false);
    }

    void showProp(boolean force) {
        Plan p = this.plan;
        this.flagHide = false;
        if (!force && this.pmemo != null && this.hcmemo == p.hashCode() && this.pmemo.equals(p)) {
            if (this.isShowing()) {
                return;
            }
            this.setVisible(true);
            return;
        }
        boolean noPack = this.pmemo != null && this.pmemo.type == p.type && this.pmemo.flagOk == p.flagOk && this.pmemo.projd == p.projd;
        this.pmemo = new PlanFree(this.aladin);
        this.pmemo.objet = p.objet == null ? null : new String(p.objet);
        this.pmemo.type = p.type;
        this.pmemo.param = p.param == null ? null : new String(p.param);
        this.pmemo.error = p.error == null ? null : new String(p.error);
        this.pmemo.flagOk = p.flagOk;
        this.pmemo.projd = p.projd;
        this.hcmemo = p.hashCode();
        this.sourceType = null;
        this.couleur = null;
        this.sEquinox = null;
        this.sField = null;
        this.rollField = null;
        this.eqField = null;
        this.epField = null;
        this.rotateCenter = null;
        if (this.panel != null) {
            this.remove(this.panel);
        }
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout(5, 5));
        this.propPanel = this.getPanelProperties();
        JScrollPane scrollPane = new JScrollPane(this.propPanel, 20, 31);
        Aladin.makeAdd(this.panel, scrollPane, "Center");
        this.setTitre(this.BANNER + " \"" + this.plan.label + "\"");
        Aladin.makeAdd(this.panel, this.getPanelValid(), "South");
        Aladin.makeAdd(this, this.panel, "Center");
        if (!noPack) {
            this.pack();
        }
        this.setVisible(true);
    }

    protected JPanel getPanelValid() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(1));
        JButton b = new JButton(this.APPLY);
        p.add(b);
        b.addActionListener(this);
        b.setFont(b.getFont().deriveFont(1));
        b = new JButton(this.CLOSE);
        p.add(b);
        b.addActionListener(this);
        if (this.plan.getBookmarkCode() != null) {
            JPanel p1 = new JPanel(new BorderLayout(2, 2));
            p1.add((Component)p, "Center");
            b = new JButton(new ImageIcon(Aladin.aladin.getImagette("Bookmark.png")));
            Util.toolTip(b, "Bookmarks this server query");
            b.setMargin(new Insets(0, 0, 0, 0));
            b.setBorderPainted(false);
            b.setContentAreaFilled(false);
            p1.add((Component)b, "East");
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Properties.this.bookmark();
                }
            });
            p = p1;
        }
        return p;
    }

    private JPanel getPanelFilter(Plan plan) {
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        c.anchor = 17;
        c.gridwidth = 0;
        c.insets = new Insets(0, 0, 0, 0);
        JPanel p = new JPanel();
        p.setLayout(g);
        this.filterCB = new ButtonGroup();
        JRadioButton cb = this.nofilter = new JRadioButton(this.NOFILTER);
        cb.setActionCommand(this.NOFILTER);
        cb.addActionListener(this);
        this.filterCB.add(cb);
        cb.setSelected(true);
        JPanel p1 = new JPanel(new FlowLayout(0));
        p1.add(cb);
        g.setConstraints(p1, c);
        p.add(p1);
        for (int i = 0; i < plan.filters.length; ++i) {
            String label = ServerGlu.getFilterDescription(plan.filters[i]);
            if (label == null) {
                label = ServerGlu.getFilterName(plan.filters[i]);
            }
            if (label == null) continue;
            cb = new JRadioButton(label);
            cb.setMargin(c.insets);
            cb.setActionCommand(label);
            cb.addActionListener(this);
            this.filterCB.add(cb);
            if (plan.filterIndex == i) {
                cb.setSelected(true);
            }
            p1 = new JPanel(new FlowLayout(0));
            p1.add(cb);
            g.setConstraints(p1, c);
            p.add(p1);
        }
        return p;
    }

    protected void createTimeField() {
        double[] t = this.aladin.calque.getDefaultTimeRange();
        this.timeField = new TimeField(t[0], t[1]);
        this.showProp(true);
    }

    private boolean moc2STmoc() {
        try {
            this.plan = this.aladin.calque.moc2STMoc((PlanMoc)this.plan, 24, this.timeField.getJdmin(), this.timeField.getJdmax());
            this.aladin.view.repaintAll();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Properties.this.showProp(true);
                    Properties.this.aladin.view.createView4TMOC(Properties.this.plan);
                }
            });
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }

    protected JPanel getPanelProperties() {
        String s1;
        int i;
        JButton b;
        GridBagConstraints c = new GridBagConstraints();
        GridBagLayout g = new GridBagLayout();
        c.fill = 1;
        c.insets = new Insets(2, 2, 0, 5);
        JPanel p = new JPanel();
        p.setLayout(g);
        this.label = new JTextField(this.plan.label, 15);
        this.label.setMinimumSize(this.label.getPreferredSize());
        PropPanel.addCouple(p, this.LABEL, this.label, g, c);
        if (this.plan.verboseDescr != null || this.plan.description != null) {
            PropPanel.addCouple(p, "Description: ", new MyAnchor(this.aladin, this.plan.description, 50, this.plan.verboseDescr, null), g, c);
        }
        if (this.plan.ack != null) {
            PropPanel.addCouple(p, "Acknowledgment: ", new MyAnchor(this.aladin, null, 40, this.plan.ack, null), g, c);
        }
        if (!(this.plan instanceof PlanBG) || ((PlanBG)this.plan).getProperty("obs_copyright") == null && ((PlanBG)this.plan).getProperty("obs_copyright_url") == null) {
            String copyright;
            String string = copyright = this.plan.copyright == null ? this.plan.copyrightUrl : this.plan.copyright;
            if (copyright != null) {
                PropPanel.addCouple(p, this.ORIGIN, new MyAnchor(this.aladin, copyright, 40, null, this.plan.copyrightUrl), g, c);
            }
        }
        if (this.plan instanceof PlanBG) {
            PlanBG pbg = (PlanBG)this.plan;
            String s = pbg.getProperty("bib_reference");
            String su = pbg.getProperty("bib_reference_url");
            if (s != null || su != null) {
                PropPanel.addCouple(p, "Bib. reference", new MyAnchor(this.aladin, s, 40, null, su), g, c);
            }
            if (((PlanBG)this.plan).id != null) {
                JLabel datasetId = new JLabel(((PlanBG)this.plan).id);
                PropPanel.addCouple(p, "Dataset ID: ", datasetId, g, c);
            }
            if ((s = pbg.getProperty("hips_creator")) == null) {
                s = pbg.getProperty("hips_publisher");
            }
            if (s == null) {
                s = pbg.getProperty("creator_id");
            }
            if (s == null) {
                s = pbg.getProperty("publisher_id");
            }
            if (s == null) {
                s = pbg.getCreatorFromId();
            }
            if (s != null) {
                PropPanel.addCouple(p, "HiPS creator", new JLabel(s), g, c);
            }
            if ((s = pbg.getProperty("hips_release_date")) != null) {
                PropPanel.addCouple(p, "Release date", new JLabel(s), g, c);
            }
        }
        if (!this.plan.isImage() && this.plan.type != 16 && this.plan.type != 11 && !(this.plan instanceof PlanContour)) {
            this.couleur = new Couleur(this.plan.c);
            PropPanel.addCouple(p, this.COLOR, this.couleur, g, c);
            this.couleur.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Properties.this.actionCouleur();
                }
            });
        }
        if (this.plan instanceof PlanContour) {
            this.couleur = new Couleur(PlanContour.couleursBase, this.plan.c, 25, 4);
            PropPanel.addCouple(p, this.COLOR, this.couleur, g, c);
        }
        if (!this.plan.flagOk) {
            MyAnchor l;
            String titre;
            if (this.plan.error != null) {
                titre = this.ERROR;
                l = new MyAnchor(this.aladin, null, 40, this.plan.error, null);
            } else {
                titre = this.STATE;
                l = new MyAnchor(this.aladin, null, 40, this.UNDER, null);
            }
            l.setForeground(Color.red);
            l.setFont(l.getFont().deriveFont(1));
            PropPanel.addCouple(p, titre, l, g, c);
        }
        if (this.plan.flagOk) {
            if (this.plan.isCatalog() && !this.plan.hasNoPos) {
                this.sourceType = new JComboBox();
                for (int i2 = 0; i2 < Source.TYPENAME.length; ++i2) {
                    this.sourceType.addItem(Source.TYPENAME[i2]);
                }
                this.sourceType.setSelectedIndex(this.plan.sourceType);
                PropPanel.addCouple(p, this.SHAPE, this.sourceType, g, c);
                this.sourceType.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Properties.this.actionSourceType();
                    }
                });
            }
            if (this.plan.type == 11) {
                JPanel pscope = new JPanel();
                pscope.setLayout(new FlowLayout(0));
                this.scope = new ButtonGroup();
                boolean limitScope = ((PlanFolder)this.plan).localScope;
                this.scopeGlobal = new JRadioButton(this.GLOBAL);
                this.scope.add(this.scopeGlobal);
                this.scopeGlobal.setSelected(!limitScope);
                this.scopeLocal = new JRadioButton(this.LOCAL);
                this.scope.add(this.scopeLocal);
                pscope.add(this.scopeGlobal);
                pscope.add(this.scopeLocal);
                b = new JButton(" ? ");
                pscope.add(b);
                b.addActionListener(this);
                PropPanel.addCouple(p, this.SCOPE, pscope, g, c);
                if (this.hasCatalogInfo()) {
                    b = new JButton(Aladin.chaine.getString("PARSING"));
                    b.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Properties.this.seeCatalogInfo();
                        }
                    });
                    PropPanel.addCouple(p, "", b, g, c);
                }
            } else {
                this.scope = null;
            }
            if (this.plan instanceof PlanContour) {
                PlanContour pcont = (PlanContour)this.plan;
                PropPanel.addCouple(p, this.IMG, new JLabel(pcont.p.label + " - " + pcont.p.objet), g, c);
                int[] contoursLevels = pcont.getIntLevels();
                this.contoursCB = new JCheckBox[contoursLevels.length];
                this.contoursCouleurs = new Couleur[contoursLevels.length];
                int scrollWidth = 330;
                int scrollHeight = 200;
                this.panelScroll = new JPanel();
                this.panelScroll.setLayout(g);
                for (int i3 = 0; i3 < contoursLevels.length; ++i3) {
                    this.contoursCB[i3] = new JCheckBox(this.VIEWABLE, pcont.isViewable(i3));
                    this.contoursCB[i3].addActionListener(this);
                    this.panelCont = new JPanel();
                    this.panelCont.add(this.contoursCB[i3]);
                    this.contoursCouleurs[i3] = new Couleur(pcont.couleursContours[i3], 15, 3, Couleur.getBrighterColors(pcont.c, 4));
                    this.panelCont.add(this.contoursCouleurs[i3]);
                    String suffix = i3 == 0 ? "1st" : (i3 == 1 ? "2nd" : (i3 == 2 ? "3rd" : i3 + 1 + "th"));
                    PropPanel.addCouple(this.panelScroll, suffix + " level", this.panelCont, g, c);
                }
                this.scroll = new JScrollPane(this.panelScroll);
                this.scroll.setSize(scrollWidth, scrollHeight);
                g.setConstraints(this.scroll, c);
                p.add(this.scroll);
                Histogramme hist = new Histogramme((PlanImage)pcont.p);
                PropPanel.addCouple(p, this.LEVEL, hist, g, c);
                this.curs = new Curseur(hist);
                this.curs.nbNiveaux = contoursLevels.length;
                this.curs.couleurTriangle = pcont.couleursContours;
                for (i = 0; i < contoursLevels.length; ++i) {
                    this.curs.niveaux[i] = contoursLevels[i];
                }
                PropPanel.addCouple(p, "", this.curs, g, c);
            }
            if (this.plan.isCatalog() || this.plan.isImage()) {
                PropPanel.addFilet(p, g, c);
            }
            if (this.plan.isCatalog() && this.plan.query != null) {
                JTextArea ta = new JTextArea(this.plan.query, 5, 40);
                JScrollPane sc = new JScrollPane(ta);
                PropPanel.addCouple(p, "ADQL query ", sc, g, c);
            }
        }
        if (this.plan.type == 10) {
            JPanel subFoV;
            final PlanField pf = (PlanField)this.plan;
            this.sField = pf.getProjCenter();
            this.centerField = new JTextField(this.sField, 25);
            if (!pf.isMovable()) {
                this.centerField.setEnabled(false);
            }
            PropPanel.addCouple(p, this.REFCOORD, this.centerField, g, c);
            if (Aladin.ROTATEFOVCENTER) {
                this.rotateCenterField = pf.getRotCenter();
                JPanel pr = new JPanel(new BorderLayout(0, 0));
                this.rotateCenter = new JTextField(this.rotateCenterField, 25);
                this.rotateCenter.setEnabled(pf.isRollable() & pf.isCenterRollable());
                pr.add((Component)this.rotateCenter, "Center");
                JCheckBox rotCheck = new JCheckBox();
                rotCheck.setSelected(pf.isCenterRollable());
                rotCheck.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        boolean r = !pf.isCenterRollable();
                        pf.setCenterRollable(r);
                        if (!r) {
                            pf.resetRotCenterObjet();
                            Properties.this.rotateCenter.setText(pf.getRotCenter());
                            Properties.this.rotateCenterField = "";
                            Properties.this.apply();
                        }
                        Properties.this.rotateCenter.setEnabled(pf.isRollable() & pf.isCenterRollable());
                    }
                });
                pr.add((Component)rotCheck, "East");
                PropPanel.addCouple(p, this.REFROTATE, pr, g, c);
            }
            this.sRoll = pf.getRoll();
            this.rollField = new JTextField(this.sRoll, 4);
            if (!pf.isRollable()) {
                this.rollField.setEnabled(false);
            }
            PropPanel.addCouple(p, this.ANGLE, this.rollField, g, c);
            if (pf.isAlmaFP()) {
                JButton bPointing = new JButton(this.POINTINGLABEL);
                bPointing.addActionListener(this);
                PropPanel.addCouple(p, this.POINTING, bPointing, g, c);
            }
            if ((subFoV = pf.getPanelSubFov(this)) != null) {
                PropPanel.addCouple(p, this.COMPONENT, subFoV, g, c);
            }
        } else {
            this.centerField = null;
        }
        if (this.plan.isSimpleCatalog() && !this.plan.hasNoPos) {
            PropPanel.addCouple(p, this.SOURCE + ":", new JLabel("" + ((PlanCatalog)this.plan).getCounts()), g, c);
        }
        if (this.plan instanceof PlanFolder && ((PlanFolder)this.plan).headerFits != null || this.plan instanceof PlanCatalog && ((PlanCatalog)this.plan).headerFits != null) {
            b = new JButton(this.SEEFITS);
            PropPanel.addCouple(p, "Fits extension", b, g, c);
            b.addActionListener(this);
        }
        if (this.plan.isImage() || this.plan instanceof PlanBG) {
            JPanel fmtp;
            PlanImage pimg = (PlanImage)this.plan;
            String survey = pimg.survey();
            if (survey != null && survey.length() > 0 && !survey.equals(pimg.getUrl())) {
                PropPanel.addCouple(p, this.INF, new MyAnchor(this.aladin, survey, 50, null, survey), g, c);
            }
            JLabel fmtl = new JLabel(this.plan instanceof PlanHealpix ? "HEALPix map" : (this.plan instanceof PlanSTMoc ? "Space Time Multi-Order Coverage map (STMOC)" : (this.plan instanceof PlanTMoc ? "Temporal Multi-Order Coverage map (TMOC)" : (this.plan instanceof PlanMoc ? "Spatial Multi-Order Coverage map (MOC)" : (this.plan instanceof PlanBG ? "Hierarchical Progressive Survey (HiPS)" : PlanImage.describeFmtRes(pimg.dis, pimg.res))))));
            if (pimg.headerFits != null) {
                fmtp = new JPanel();
                fmtp.setLayout(new FlowLayout(0));
                fmtp.add(fmtl);
                b = new JButton(this.SEEFITS);
                fmtp.add(b);
                b.addActionListener(this);
                PropPanel.addCouple(p, this.FMT, fmtp, g, c);
            } else if (pimg instanceof PlanBG && ((PlanBG)pimg).prop != null) {
                fmtp = new JPanel();
                fmtp.setLayout(new FlowLayout(0));
                fmtp.add(fmtl);
                b = new JButton(this.SEEHIPSPROP);
                fmtp.add(b);
                b.addActionListener(this);
                PropPanel.addCouple(p, this.FMT, fmtp, g, c);
            } else {
                PropPanel.addCouple(p, this.FMT, fmtl, g, c);
            }
            if (pimg.isImage()) {
                PropPanel.addCouple(p, this.PIXMODE, new JLabel(pimg.getPixModeInfo()), g, c);
                if (this.plan.flagOk && this.plan.projd != null) {
                    String s = Coord.getUnit(this.plan.projd.c.GetResol()[0]) + " x " + Coord.getUnit(this.plan.projd.c.GetResol()[1]);
                    PropPanel.addCouple(p, "Pixel angular res.", new JLabel(s), g, c);
                    double ep = this.plan.projd.c.GetEpoch();
                    if (!Double.isNaN(ep)) {
                        PropPanel.addCouple(p, this.EPOCH, new JLabel(Astrodate.JDToDate(Astrodate.YdToJD(ep)) + " (" + ep + ")"), g, c);
                    } else {
                        String d = ((PlanImage)this.plan).getDateObs();
                        if (d != null) {
                            PropPanel.addCouple(p, this.DATEOBS, new JLabel(d), g, c);
                        }
                    }
                    double eq = this.plan.projd.c.GetEquinox();
                    if (eq != 0.0) {
                        eq = (double)((int)(eq * 1000.0)) / 1000.0;
                        PropPanel.addCouple(p, this.WCSEQ, new JLabel("" + eq), g, c);
                    } else {
                        this.sEquinox = "2000.0";
                        this.eqField = new JTextField(this.sEquinox);
                        PropPanel.addCouple(p, this.WCSEQ, this.eqField, g, c);
                    }
                }
                if (pimg.width != 0 && !(pimg instanceof PlanBG)) {
                    PropPanel.addCouple(p, this.SIZE, new JLabel(pimg.getSizeInfo()), g, c);
                }
            }
        }
        if (this.plan.hasAvailablePixels()) {
            final PlanImage pimg = (PlanImage)this.plan;
            String vBlank = pimg.getBlankString();
            this.blankField = new TextField(vBlank);
            this.blankField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Properties.this.actionBlank();
                    Properties.this.blankField.setText(pimg.getBlankString());
                    Properties.this.aladin.calque.repaintAll();
                }
            });
            PropPanel.addCouple(p, "Transparency", this.blankField, g, c);
        }
        if (this.plan.isCube()) {
            PropPanel.addCouple(p, this.FRAME, new JLabel(this.plan.getDepth() + ""), g, c);
        }
        if (this.plan instanceof PlanImageBlink) {
            final PlanImageBlink pb = (PlanImageBlink)this.plan;
            JPanel panel = new JPanel(new FlowLayout());
            JButton perm = new JButton("XxY->Z");
            perm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((JButton)e.getSource()).setEnabled(false);
                    pb.permutation(0);
                }
            });
            perm.setEnabled(pb.getPermutation() != 0);
            panel.add(perm);
            perm = new JButton("XxZ->Y");
            perm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((JButton)e.getSource()).setEnabled(false);
                    pb.permutation(1);
                }
            });
            perm.setEnabled(pb.getPermutation() != 1);
            panel.add(perm);
            perm = new JButton("ZxY->X");
            perm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((JButton)e.getSource()).setEnabled(false);
                    pb.permutation(2);
                }
            });
            perm.setEnabled(pb.getPermutation() != 2);
            panel.add(perm);
            PropPanel.addCouple(p, "Permutations", panel, g, c);
        }
        if ((s1 = this.plan.getUrl()) != null && (s1.startsWith("http://") || s1.startsWith("https://") || s1.startsWith("ftp://"))) {
            JComponent a = new MyAnchor(this.aladin, s1, 50, null, s1);
            if (this.plan.getMirrorsUrl() != null) {
                JButtonTriangle b1 = new JButtonTriangle();
                JPanel p1 = new JPanel(new FlowLayout(0, 4, 0));
                p1.add(a);
                p1.add(b1);
                a = p1;
            }
            PropPanel.addCouple(p, "Url: ", a, g, c);
        }
        if (this.plan.isCatalog()) {
            int n;
            Vector<Legende> legs = this.plan.getLegende();
            JPanel pt = new JPanel();
            b = new JButton(this.SEEPARSING);
            b.addActionListener(this);
            pt.add(b);
            if (this.hasCatalogInfo()) {
                b = new JButton(Aladin.chaine.getString("PARSING"));
                b.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Properties.this.seeCatalogInfo();
                    }
                });
                pt.add(b);
            }
            if ((n = legs.size()) == 1) {
                PropPanel.addCouple(p, this.TABLEINFO, pt, g, c);
            } else {
                StringBuffer s = new StringBuffer("<html>");
                for (i = 0; i < legs.size(); ++i) {
                    s.append((i > 0 ? "<br>" : "") + (i + 1) + ": " + legs.elementAt((int)i).name);
                }
                s.append("</html>");
                PropPanel.addCouple(p, this.TABLEINFO, new JLabel(s.toString()), g, c);
                PropPanel.addCouple(p, "", pt, g, c);
            }
        }
        if (this.plan.filters != null) {
            PropPanel.addFilet(p, g, c);
            JLabel l = new JLabel(this.FILTER);
            l.setFont(l.getFont().deriveFont(1));
            c.fill = 0;
            PropPanel.addCouple(p, l, this.getPanelFilter(this.plan), g, c);
            c.fill = 1;
            this.toGenFilterButton = b = new JButton("This filter on the stack for editing");
            b.addActionListener(this);
            PropPanel.addCouple(p, "", this.toGenFilterButton, g, c);
            this.toGenFilterButton.setEnabled(this.plan.hasDedicatedFilter());
        }
        if (this.plan instanceof PlanHealpix) {
            final PlanHealpix ph = (PlanHealpix)this.plan;
            if (ph.type == 17) {
                PropPanel.addFilet(p, g, c);
                PropPanel.addSectionTitle(p, this.POLAOPTIONS, g, c);
                this.polaSegmentLen = new JSlider(0, 200);
                this.polaSegmentLen.setValue((int)ph.getSegmentLenFactor() * 200);
                this.polaSegmentLen.setPaintTicks(true);
                this.polaSegmentLen.addChangeListener(this);
                PropPanel.addCouple(p, this.SEGMENTLEN, this.polaSegmentLen, g, c);
                this.polaSegmentThickness = new JSlider(1, 5);
                this.polaSegmentThickness.setValue(ph.getSegmentThickness());
                this.polaSegmentThickness.setMajorTickSpacing(1);
                this.polaSegmentThickness.setPaintTicks(true);
                this.polaSegmentThickness.setSnapToTicks(true);
                this.polaSegmentThickness.setPaintLabels(false);
                this.polaSegmentThickness.addChangeListener(this);
                PropPanel.addCouple(p, this.SEGMENTTHICK, this.polaSegmentThickness, g, c);
                this.polaSegmentDensity = new JSlider(0, 200);
                this.polaSegmentDensity.setValue(100);
                this.polaSegmentDensity.setMajorTickSpacing(25);
                this.polaSegmentDensity.setPaintTicks(true);
                this.polaSegmentDensity.setSnapToTicks(true);
                this.polaSegmentDensity.addChangeListener(this);
                PropPanel.addCouple(p, this.SEGMENTDENSITY, this.polaSegmentDensity, g, c);
            } else {
                boolean hasPolarisationData;
                if (ph.tfieldNames != null && ph.idxTFormToRead >= 0) {
                    PropPanel.addFilet(p, g, c);
                    PropPanel.addCouple(p, this.CURRENTFIELD, new JLabel(ph.tfieldNames[ph.idxTFormToRead]), g, c);
                }
                if ((hasPolarisationData = ph.hasPolarisationData()) || ph.tfieldNames.length > 1) {
                    PropPanel.addFilet(p, g, c);
                }
                if (hasPolarisationData) {
                    JPanel pPola = new JPanel(new GridLayout(0, 1));
                    this.btnDisplayPola = new JButton(this.DISPLAYPOLA);
                    this.btnDisplayPola.addActionListener(this);
                    pPola.add(this.btnDisplayPola);
                    this.btnDisplayAmp = new JButton(this.GENERATEPOLAAMP);
                    this.btnDisplayAmp.addActionListener(this);
                    pPola.add(this.btnDisplayAmp);
                    this.btnDisplayAng = new JButton(this.GENERATEPOLAANG);
                    this.btnDisplayAng.addActionListener(this);
                    pPola.add(this.btnDisplayAng);
                    c.fill = 0;
                    PropPanel.addCouple(null, p, this.POLA, null, pPola, g, c, 18);
                }
                if (ph.tfieldNames.length > 1) {
                    JPanel pAvailableFields = new JPanel(new GridLayout(0, 1));
                    JScrollPane scrollPane = new JScrollPane(pAvailableFields, 20, 31);
                    scrollPane.setPreferredSize(new Dimension(200, 300));
                    for (i = 0; i < ph.tfieldNames.length; ++i) {
                        if (i == ph.idxTFormToRead) continue;
                        b = new JButton(ph.tfieldNames[i]);
                        pAvailableFields.add(b);
                        final int idx = i;
                        b.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                ph.loadNewField(idx);
                            }
                        });
                    }
                    PropPanel.addCouple(null, p, this.SELECTFIELD, null, pAvailableFields, g, c, 18);
                }
            }
        }
        if (this.plan.type == 16) {
            PlanBG pbg = (PlanBG)this.plan;
            PropPanel.addFilet(p, g, c);
            long res = pbg.getMaxHealpixOrder();
            long ord = pbg.getTileOrder();
            PropPanel.addSectionTitle(p, "HiPS properties", g, c);
            PropPanel.addCouple(p, "Best pixel resolution", new JLabel(pbg.getMaxResolution()), g, c);
            PropPanel.addCouple(p, "HEALPix NSide:", new JLabel(CDSHealpix.pow2(res) + " (2^" + res + ")"), g, c);
        }
        if (this.plan.isMoc()) {
            PlanMoc pmoc;
            block132: {
                pmoc = (PlanMoc)this.plan;
                if (this.plan.type == 19) {
                    double cov = ((SMoc)pmoc.getMoc()).getCoverage();
                    double degrad = Math.toDegrees(1.0);
                    double skyArea = Math.PI * 4 * degrad * degrad;
                    PropPanel.addCouple(p, "Coverage: ", new JLabel(Util.round(cov * 100.0, 3) + "% of sky => " + Coord.getUnit(skyArea * cov, false, true) + "^2"), g, c);
                    PropPanel.addCouple(p, "Best ang.res: ", new JLabel(Coord.getUnit(((SMoc)pmoc.getMoc()).getAngularRes()) + " (order=" + pmoc.getMoc().getMocOrder() + ")"), g, c);
                    if (Aladin.BETA) {
                        if (this.timeField != null) {
                            PropPanel.addCouple(p, "Time : ", this.timeField, g, c);
                        } else {
                            JButton t = new JButton("Range?");
                            t.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    Properties.this.createTimeField();
                                }
                            });
                            PropPanel.addCouple(p, "Time", t, g, c);
                        }
                    }
                } else if (this.plan.type == 23) {
                    TMoc moc = (TMoc)((PlanTMoc)this.plan).moc;
                    long nbSec = moc.getNbCells();
                    int order = moc.getMocOrder();
                    PropPanel.addCouple(p, "Start", new JLabel(Astrodate.JDToDate(moc.getTimeMin())), g, c);
                    PropPanel.addCouple(p, "End", new JLabel(Astrodate.JDToDate(moc.getTimeMax())), g, c);
                    PropPanel.addCouple(p, "Accuracy", new JLabel(TMoc.getTemps(TMoc.getDuration(moc.getMocOrder()))), g, c);
                } else if (this.plan.type == 24) {
                    try {
                        SMoc spaceMoc = ((STMoc)((PlanMoc)this.plan).moc).getSpaceMoc();
                        double cov = spaceMoc.getCoverage();
                        double degrad = Math.toDegrees(1.0);
                        double skyArea = Math.PI * 4 * degrad * degrad;
                        PropPanel.addCouple(p, "Coverage: ", new JLabel(Util.round(cov * 100.0, 3) + "% of sky => " + Coord.getUnit(skyArea * cov, false, true) + "^2"), g, c);
                        PropPanel.addCouple(p, "Best ang.res: ", new JLabel(Coord.getUnit(spaceMoc.getAngularRes()) + " (order=" + spaceMoc.getMocOrder() + ")"), g, c);
                        TMoc timeMoc = ((STMoc)((PlanMoc)this.plan).moc).getTimeMoc();
                        long nbSec = timeMoc.getNbCells();
                        int order = timeMoc.getMocOrder();
                        if (((PlanSTMoc)this.plan).isOneTimeRange()) {
                            PropPanel.addCouple(p, "Time : ", new TimeField((PlanSTMoc)this.plan), g, c);
                        } else {
                            PropPanel.addCouple(p, "Start", new JLabel(Astrodate.JDToDate(timeMoc.getTimeMin())), g, c);
                            PropPanel.addCouple(p, "End", new JLabel(Astrodate.JDToDate(timeMoc.getTimeMax())), g, c);
                            PropPanel.addCouple(p, "Time Accuracy", new JLabel(TMoc.getTemps(TMoc.getDuration(timeMoc.getMocOrder()))), g, c);
                        }
                    }
                    catch (Exception e1) {
                        if (Aladin.levelTrace < 3) break block132;
                        e1.printStackTrace();
                    }
                }
            }
            final JCheckBox b1 = new JCheckBox("cell borders");
            final JCheckBox b3 = new JCheckBox("perimeter");
            b1.setSelected(pmoc.isDrawingBorder());
            b1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean a = b1.isSelected();
                    pmoc.setDrawingBorder(a);
                    if (a) {
                        pmoc.setDrawingPerimeter(!a);
                        b3.setSelected(!a);
                        Properties.this.aladin.console.printCommand("set drawing=+border,-perimeter");
                    } else {
                        Properties.this.aladin.console.printCommand("set drawing=-border");
                    }
                    Properties.this.aladin.calque.repaintAll();
                }
            });
            b3.setSelected(pmoc.isDrawingPerimeter());
            b3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean a = b3.isSelected();
                    pmoc.setDrawingPerimeter(a);
                    if (a) {
                        pmoc.setDrawingBorder(!a);
                        b1.setSelected(!a);
                        Properties.this.aladin.console.printCommand("set drawing=+perimeter,-border");
                    } else {
                        Properties.this.aladin.console.printCommand("set drawing=-perimeter");
                    }
                    Properties.this.aladin.calque.repaintAll();
                }
            });
            final JCheckBox b2a = new JCheckBox("fill in");
            b2a.setSelected(pmoc.isDrawingFillIn());
            b2a.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean a = b2a.isSelected();
                    pmoc.setDrawingFillIn(a);
                    Properties.this.aladin.calque.repaintAll();
                    Properties.this.aladin.console.printCommand("set drawing=" + (a ? "+" : "-") + "fill");
                }
            });
            JPanel p1 = new JPanel(new FlowLayout(0, 0, 0));
            p1.add(b1);
            p1.add(b3);
            p1.add(b1);
            p1.add(b2a);
            PropPanel.addCouple(p, "Drawing method: ", p1, g, c);
        }
        if (this.plan instanceof PlanBG && !(this.plan instanceof PlanTMoc)) {
            String s;
            final PlanBG pbg = (PlanBG)this.plan;
            PropPanel.addCouple(p, "Coord.sys.:", new JLabel(pbg.getHipsFrame()), g, c);
            if (this.plan.type == 16) {
                int level = pbg.getMaxFileOrder();
                PropPanel.addCouple(p, "Number of levels", new JLabel(level + ""), g, c);
                long ord = pbg.getTileOrder();
                PropPanel.addCouple(p, "Tile format", new JLabel(pbg.getFormat()), g, c);
                if (ord > 0L) {
                    PropPanel.addCouple(p, "Tile width:", new JLabel((int)CDSHealpix.pow2(ord) + " pix (2^" + ord + ")"), g, c);
                }
                if (pbg.inFits && (pbg.inJPEG || pbg.inPNG)) {
                    JButton bt = new JButton(pbg.isTruePixels() ? Aladin.chaine.getString("ALLSKYSWJPEG") : Aladin.chaine.getString("ALLSKYSWFITS"));
                    bt.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            pbg.switchFormat();
                            Properties.this.showProp(true);
                            Properties.this.aladin.view.repaintAll();
                        }
                    });
                    PropPanel.addCouple(p, "", bt, g, c);
                }
            }
            String string = s = Aladin.BETA ? pbg.getNetSpeed() : null;
            if (s != null) {
                JLabel lab = new JLabel(s);
                if (s.indexOf("error") >= 0) {
                    lab.setForeground(Color.red);
                }
                PropPanel.addCouple(p, "Avg net speed:", lab, g, c);
            }
            String sTmin = pbg.getProperty("t_min");
            String sTmax = pbg.getProperty("t_max");
            String sEMmin = pbg.getProperty("em_min");
            String sEMmax = pbg.getProperty("em_max");
            String sR = pbg.getProperty("obs_regime");
            String sS = pbg.getProperty("moc_sky_fraction");
            boolean hasMoc = pbg.hasMoc();
            if (sS != null || sTmin != null || sTmax != null || sEMmin != null || sEMmax != null || sR != null || sS != null || hasMoc) {
                PropPanel.addFilet(p, g, c);
                PropPanel.addSectionTitle(p, "Coverage", g, c);
                if (sTmin != null || sTmax != null) {
                    PropPanel.addCouple(p, "Time range", new JLabel(PlanBG.getCoverageTime(sTmin, sTmax)), g, c);
                }
                if (sEMmin != null || sEMmax != null) {
                    PropPanel.addCouple(p, "Energy range", new JLabel(PlanBG.getCoverageEnergy(sEMmin, sEMmax)), g, c);
                }
                if (hasMoc || sS != null) {
                    if (sS == null && pbg.moc != null) {
                        sS = pbg.moc.getCoverage() + "";
                    }
                    JPanel p1 = new JPanel();
                    if (sS != null) {
                        try {
                            sS = Util.myRound(Double.parseDouble(sS) * 100.0);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        p1.add(new JLabel(sS + " % of sky"));
                    }
                    if (hasMoc) {
                        JButton bt = new JButton(this.aladin.MOC);
                        bt.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                pbg.loadMoc();
                            }
                        });
                        p1.add(bt);
                    }
                    PropPanel.addCouple(p, "Space", p1, g, c);
                }
            }
            String sP = pbg.getProperty("prov_progenitor");
            String sC = pbg.getProperty("obs_copyright");
            String sCU = pbg.getProperty("obs_copyright_url");
            boolean hasProgen = pbg.hasHpxFinder();
            if (sP != null || sC != null || sCU != null || hasProgen) {
                PropPanel.addFilet(p, g, c);
                PropPanel.addSectionTitle(p, "Original data", g, c);
                if (sP != null) {
                    PropPanel.addCouple(p, "Provenance", new MyAnchor(this.aladin, null, 40, sP, null), g, c);
                }
                if (sC != null || sCU != null) {
                    PropPanel.addCouple(p, "Copyright", new MyAnchor(this.aladin, sC, 40, null, sCU), g, c);
                }
                if (hasProgen) {
                    JButton bt = new JButton(Aladin.chaine.getString("PROGENITOR"));
                    bt.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            pbg.loadProgen();
                        }
                    });
                    JPanel p1 = new JPanel();
                    p1.add(bt);
                    PropPanel.addCouple(p, "Access", p1, g, c);
                }
            }
        }
        if (this.plan.flagOk && (this.plan.isSimpleCatalog() || this.plan instanceof PlanBG)) {
            JPanel p1 = this.aladin.view.getPlotControlPanelForPlan(this.plan);
            if (p1 != null) {
                PropPanel.addFilet(p, g, c);
                PropPanel.addCouple(p, "Scatter plot", p1, g, c);
            } else if (this.plan.ref && Projection.isOk(this.plan.projd)) {
                this.specificProj = new JComboBox();
                int index = -1;
                if (this.plan instanceof PlanBG) {
                    index = !this.plan.hasSpecificProj() ? 0 : 1 + Projection.getAlaProjIndex(Calib.getProjName(this.plan.projd.c.getProj()));
                    this.specificProj.addItem("Default");
                } else {
                    index = Projection.getAlaProjIndex(Calib.getProjName(this.plan.projd.c.getProj()));
                }
                for (String s : Projection.getAlaProj()) {
                    this.specificProj.addItem(s);
                }
                this.specificProj.setSelectedIndex(index);
                this.specificProj.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Properties.this.actionSpecificProj();
                    }
                });
                PropPanel.addFilet(p, g, c);
                PropPanel.addSectionTitle(p, this.DEFCATPROJ, g, c);
                if (!(this.plan instanceof PlanBG)) {
                    PropPanel.addCouple(p, this.CENTER, new JLabel(this.plan.projd.c.getProjCenter().getSexa()), g, c);
                }
                PropPanel.addCouple(p, this.METHOD, this.specificProj, g, c);
                if (this.plan.ref && this.plan instanceof PlanBG) {
                    this.specificFrame = Localisation.createFrameCombo();
                    this.specificFrame.setSelectedIndex(((PlanBG)this.plan).getFrameDrawing());
                    this.specificFrame.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Properties.this.actionSpecificFrame();
                        }
                    });
                    PropPanel.addCouple(p, ".frame", this.specificFrame, g, c);
                    JPanel plong = new JPanel();
                    plong.setBorder(BorderFactory.createEmptyBorder());
                    this.longitude = new ButtonGroup();
                    this.longitudeDescending = new JRadioButton("descending");
                    this.longitudeDescending.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ((PlanBG)Properties.this.plan).setSpecificProj(true);
                            Properties.this.plan.projd.setProjSym(!Properties.this.plan.projd.sym);
                            Properties.this.aladin.view.newView();
                            Properties.this.actionSpecificProj();
                            Properties.this.aladin.calque.repaintAll();
                        }
                    });
                    this.longitude.add(this.longitudeDescending);
                    this.longitudeAscending = new JRadioButton("ascending");
                    this.longitudeAscending.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ((PlanBG)Properties.this.plan).setSpecificProj(true);
                            Properties.this.plan.projd.setProjSym(!Properties.this.plan.projd.sym);
                            Properties.this.aladin.view.newView();
                            Properties.this.actionSpecificProj();
                            Properties.this.aladin.calque.repaintAll();
                        }
                    });
                    this.longitude.add(this.longitudeAscending);
                    if (this.plan.projd.sym) {
                        this.longitudeAscending.setSelected(true);
                    } else {
                        this.longitudeDescending.setSelected(true);
                    }
                    plong.add(this.longitudeAscending);
                    plong.add(this.longitudeDescending);
                    if (Aladin.BETA) {
                        PropPanel.addCouple(p, ".longitude", plong, g, c);
                    }
                }
            }
        }
        boolean filet = false;
        if (this.plan.isCatalog() && !this.plan.hasNoPos) {
            if (this.plan.flagOk && this.plan.projd != null && this.plan.hasPM()) {
                if (!filet) {
                    PropPanel.addFilet(p, g, c);
                }
                filet = false;
                String sEpoch = this.plan.getEpoch().toString("J");
                JPanel pEpoch = new JPanel();
                this.epField = new JTextField(sEpoch, 10);
                this.epField.addKeyListener(new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent arg0) {
                    }

                    @Override
                    public void keyReleased(KeyEvent arg0) {
                        if (arg0.getKeyCode() == 10) {
                            Properties.this.apply();
                        }
                    }

                    @Override
                    public void keyPressed(KeyEvent arg0) {
                    }
                });
                pEpoch.add(this.epField);
                b = new JButton("Img epoch");
                Plan pi = this.aladin.calque.getPlanBase();
                b.setEnabled(pi instanceof PlanImage && ((PlanImage)pi).getDateObs() != null);
                Insets m = b.getMargin();
                b.setMargin(new Insets(m.top, 3, m.bottom, 3));
                b.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        try {
                            Plan pi = Properties.this.aladin.calque.getPlanBase();
                            if (!(pi instanceof PlanImage)) {
                                return;
                            }
                            Astrotime t = new Astrotime();
                            t.set(((PlanImage)pi).getDateObs());
                            System.out.println("Epoch=" + t + " => " + t.toString("J"));
                            Properties.this.epField.setText(t.toString("J"));
                            Properties.this.apply();
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                    }
                });
                pEpoch.add(b);
                b = new JButton("Reset");
                m = b.getMargin();
                b.setMargin(new Insets(m.top, 3, m.bottom, 3));
                b.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        Properties.this.epField.setText("J2000");
                        Properties.this.apply();
                    }
                });
                pEpoch.add(b);
                PropPanel.addCouple(p, this.EPOCH, pEpoch, g, c);
                double y = 2000.0;
                try {
                    y = Double.parseDouble(sEpoch.substring(1));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                this.epochSlider = new JSlider(1700, 2300);
                this.epochSlider.setMinimumSize(this.epochSlider.getPreferredSize());
                this.epochSlider.setValue((int)y);
                this.epochSlider.setMajorTickSpacing(100);
                this.epochSlider.setPaintLabels(true);
                this.epochSlider.setPaintTicks(true);
                this.epochSlider.setPaintTrack(true);
                this.epochSlider.addChangeListener(this);
                PropPanel.addCouple(p, "", this.epochSlider, g, c);
            }
            if (!filet) {
                PropPanel.addFilet(p, g, c);
            }
            filet = true;
            this.scalingFactor = new JSlider(0, 300);
            this.scalingFactor.setMinimumSize(this.scalingFactor.getPreferredSize());
            this.scalingFactor.setValue((int)this.plan.getScalingFactor() * 100);
            this.scalingFactor.setMajorTickSpacing(50);
            this.scalingFactor.setPaintLabels(true);
            this.scalingFactor.setPaintTicks(true);
            this.scalingFactor.setPaintTrack(true);
            this.scalingFactor.addChangeListener(this);
            PropPanel.addCouple(p, this.SCALINGFACTOR, this.scalingFactor, g, c);
        }
        if (this.aladin.calque.canBeTransparent(this.plan)) {
            if (!filet) {
                PropPanel.addFilet(p, g, c);
            }
            filet = true;
            JPanel pTransp = new JPanel(new FlowLayout());
            this.opacityLevel = new JSlider(0, 100);
            this.opacityLevel.setValue((int)(100.0f * this.plan.getOpacityLevel()));
            this.opacityLevel.setMajorTickSpacing(20);
            this.opacityLevel.setPaintLabels(true);
            this.opacityLevel.setPaintTicks(true);
            this.opacityLevel.setPaintTrack(true);
            this.opacityLevel.setToolTipText(this.OPACITYLEVEL + " : " + this.opacityLevel.getValue());
            this.opacityLevel.addChangeListener(this);
            pTransp.add(this.opacityLevel);
            PropPanel.addCouple(p, this.OPACITY, pTransp, g, c);
        }
        if (this.plan instanceof PlanBGCat && !(this.plan instanceof PlanMoc)) {
            if (!filet) {
                PropPanel.addFilet(p, g, c);
            }
            filet = true;
            JPanel pGapOrder = new JPanel(new FlowLayout());
            this.gapOrder = new JSlider(-3, 3);
            this.gapOrder.setValue(((PlanBGCat)this.plan).getGapOrder());
            this.gapOrder.setMajorTickSpacing(1);
            this.gapOrder.setPaintLabels(true);
            this.gapOrder.setPaintTicks(true);
            this.gapOrder.setPaintTrack(true);
            this.gapOrder.addChangeListener(this);
            pGapOrder.add(this.gapOrder);
            PropPanel.addCouple(p, this.DENSITY, pGapOrder, g, c);
        }
        if (this.plan instanceof PlanTool && !(this.plan instanceof PlanContour)) {
            this.cb = new ButtonGroup();
            JPanel bg = new JPanel();
            JRadioButton r = new JRadioButton(this.ON);
            r.setActionCommand(this.ON);
            this.cb.add(r);
            r.setSelected(this.plan.isMovable());
            r.addActionListener(this);
            bg.add(r);
            r = new JRadioButton(this.OFF);
            r.setActionCommand(this.OFF);
            this.cb.add(r);
            r.setSelected(!this.plan.isMovable());
            r.addActionListener(this);
            bg.add(r);
            PropPanel.addCouple(p, "Movable:", bg, g, c);
        }
        if (this.plan.ref && !(this.plan instanceof PlanBG)) {
            this.cb = new ButtonGroup();
            JPanel bg = new JPanel();
            JRadioButton r = new JRadioButton(this.WHITE);
            r.setActionCommand(this.WHITE);
            this.cb.add(r);
            r.setSelected(this.plan.colorBackground == Color.white || this.plan instanceof PlanImageRGB && this.plan.colorBackground == null);
            r.addActionListener(this);
            bg.add(r);
            r = new JRadioButton(this.BLACK);
            r.setActionCommand(this.BLACK);
            this.cb.add(r);
            r.setSelected(this.plan.colorBackground == Color.black);
            r.addActionListener(this);
            bg.add(r);
            if (this.plan.type != 2) {
                r = new JRadioButton(this.AUTO);
                r.setActionCommand(this.AUTO);
                this.cb.add(r);
                r.setSelected(this.plan.colorBackground == null);
                r.addActionListener(this);
                bg.add(r);
            }
            PropPanel.addCouple(p, this.COLORBG, bg, g, c);
        }
        if (this.plan.flagOk && (this.plan.isImage() || this.plan.isSimpleCatalog() && this.plan.hasXYorig)) {
            PropPanel.addFilet(p, g, c);
            String s = this.plan.isImage() ? this.ASTRED : (this.plan.hasNoPos ? "No position" : (this.plan.hasXYorig ? this.XYRED : this.PROJ));
            PropPanel.addSectionTitle(p, s, g, c);
            this.planRefChoice = null;
            this.majPlanRef();
            this.projsChoice = null;
            JButton n = b = new JButton(this.NEWCALIB);
            b.addActionListener(this);
            this.modCalib = b = new JButton(this.MODCALIB);
            b.addActionListener(this);
            this.majProjs();
            if (this.projsChoice.getItemCount() == 0) {
                this.projsChoice.addItem(this.NONE);
            }
            JPanel projsP = new JPanel();
            projsP.add(this.projsChoice);
            projsP.add(n);
            projsP.add(this.modCalib);
            PropPanel.addCouple(p, "   " + this.METHOD, projsP, g, c);
        }
        if (this.plan.flagOk && this.plan.isCatalog() && this.plan.hasAssociatedFootprints()) {
            PropPanel.addFilet(p, g, c);
            PropPanel.addSectionTitle(p, this.ASSFOV, g, c);
            JPanel p1 = new JPanel(new GridLayout(0, 1));
            JButton b1 = b = new JButton(this.SHOWFOVS);
            b.addActionListener(this);
            p1.add(b1);
            JButton b2 = b = new JButton(this.HIDEFOVS);
            b.addActionListener(this);
            p1.add(b2);
            c.gridwidth = 0;
            c.weightx = 0.0;
            c.fill = 0;
            c.anchor = 10;
            g.setConstraints(p1, c);
            p.add(p1);
            c.anchor = 17;
            c.weightx = 1.0;
            c.fill = 1;
        }
        return p;
    }

    private void showPopupMirrors(MouseEvent e, final PlanBG plan) {
        ArrayList<String> a = plan.getMirrorsUrl();
        if (a == null) {
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        for (String s : a) {
            JMenuItem mi = null;
            mi = new JMenuItem(Util.getUrlHost(s) + "/...");
            mi.setActionCommand(s);
            mi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = ((JMenuItem)e.getSource()).getActionCommand();
                    if (Properties.this.aladin.glu.setIndirectionByUrl(plan.gluTag, s)) {
                        plan.url = s;
                        plan.resetStats();
                        Properties.this.showProp(true);
                    }
                }
            });
            popup.add(mi);
        }
        ((JComponent)e.getSource()).setComponentPopupMenu(popup);
        popup.show((JComponent)e.getSource(), e.getX(), e.getY());
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src == this.opacityLevel) {
            float level = (float)((double)this.opacityLevel.getValue() / 100.0);
            this.plan.setOpacityLevel(level);
            this.opacityLevel.setToolTipText(this.OPACITYLEVEL + " : " + (int)(level * 100.0f));
            this.aladin.calque.repaintAll();
        } else if (src == this.gapOrder) {
            int v = this.gapOrder.getValue();
            ((PlanBGCat)this.plan).setGapOrder(v);
            this.aladin.calque.repaintAll();
        } else if (src == this.polaSegmentLen) {
            float factor = (float)((double)this.polaSegmentLen.getValue() / 100.0);
            ((PlanBG)this.plan).setSegmentLenFactor(factor);
            this.aladin.calque.repaintAll();
        } else if (src == this.polaSegmentThickness) {
            int othickness;
            int thickness = this.polaSegmentThickness.getValue();
            if (thickness == (othickness = ((PlanBG)this.plan).getSegmentThickness())) {
                return;
            }
            ((PlanBG)this.plan).setSegmentThickness(thickness);
            this.aladin.calque.repaintAll();
        } else if (src == this.polaSegmentDensity) {
            float factor = (float)((double)(200 - this.polaSegmentDensity.getValue()) / 100.0);
            ((PlanBG)this.plan).setSegmentDensityFactor(factor);
            this.aladin.calque.repaintAll();
        } else if (src == this.scalingFactor) {
            float factor = (float)((double)this.scalingFactor.getValue() / 100.0);
            this.plan.setScalingFactor(factor);
            this.aladin.calque.repaintAll();
        } else if (src == this.epochSlider) {
            try {
                this.plan.setEpoch(this.epochSlider.getValue() + "");
                this.epField.setText(this.plan.getEpoch().toString("J"));
                this.aladin.calque.repaintAll();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    private void majPlanRef() {
        if (!this.plan.isCatalog() && !this.plan.isImage()) {
            return;
        }
        int j = 0;
        this.planRef = this.plan.getAvailablePlanRef();
        if (this.planRefChoice == null) {
            this.planRefChoice = new JComboBox();
        }
        this.planRefChoice.removeAll();
        if (this.planRef.length > 0) {
            for (int i = 0; i < this.planRef.length; ++i) {
                String s = Plan.Tp[this.planRef[i].type] + " \"" + this.planRef[i].label + "\"";
                this.planRefChoice.addItem(s);
                if (!this.planRef[i].ref) continue;
                j = i;
            }
            this.planRefChoice.setSelectedIndex(j);
        }
    }

    protected void majProjInitCat() {
        if (!this.plan.isCatalog()) {
            return;
        }
    }

    protected void majProjs() {
        if (!this.plan.isCatalog() && !this.plan.isImage() || this.planRef == null) {
            return;
        }
        int j = 0;
        Plan pref = null;
        if (this.plan.hasXYorig) {
            this.projs = this.plan.getAvailableProj();
        } else if (this.planRefChoice.getSelectedIndex() >= 0) {
            pref = this.planRef[this.planRefChoice.getSelectedIndex()];
            this.projs = pref.getAvailableProj();
        }
        if (this.projsChoice == null) {
            this.projsChoice = new JComboBox();
        }
        this.projsChoice.removeAllItems();
        if (this.projs != null && this.projs.length > 0) {
            for (int i = 0; i < this.projs.length; ++i) {
                this.projsChoice.addItem(this.projs[i].label);
                if (this.plan.hasXYorig) {
                    if (this.plan.projd != this.projs[i]) continue;
                    j = i;
                    continue;
                }
                if (pref == null || pref.projd != this.projs[i]) continue;
                j = i;
            }
            this.projsChoice.setSelectedIndex(j);
            if (this.modCalib != null) {
                this.modCalib.setEnabled(j >= 0 && this.projs[j].isModifiable());
            }
            this.projsChoice.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Properties.this.actionSpecificProj();
                }
            });
        } else if (this.modCalib != null) {
            this.modCalib.setEnabled(false);
        }
    }

    private void actionBlank() {
        ((PlanImage)this.plan).setBlankString(this.blankField.getText());
        this.showProp(true);
    }

    private void actionSpecificProj() {
        if (this.specificProj == null) {
            return;
        }
        String sproj = (String)this.specificProj.getSelectedItem();
        int index = this.specificProj.getSelectedIndex();
        if (this.plan instanceof PlanBG && index == 0 && !this.plan.hasSpecificProj()) {
            return;
        }
        if (this.plan.projd.c.getProj() == Calib.getProjType(sproj)) {
            return;
        }
        if (this.plan instanceof PlanBG) {
            if (index == 0) {
                ((PlanBG)this.plan).setSpecificProj(false);
                sproj = this.aladin.projSelector.getProjItem();
            } else {
                ((PlanBG)this.plan).setSpecificProj(true);
            }
        }
        this.plan.modifyProj(sproj);
        if (this.aladin.view.getCurrentView().pref == this.plan) {
            this.aladin.projSelector.setProjectionSilently(sproj);
        }
    }

    private void actionSpecificFrame() {
        if (!(this.plan instanceof PlanBG) || this.specificFrame == null || ((PlanBG)this.plan).getFrameDrawing() == this.specificFrame.getSelectedIndex()) {
            return;
        }
        ((PlanBG)this.plan).setFrameDrawing(this.specificFrame.getSelectedIndex());
        if (this.specificFrame.getSelectedIndex() != 0) {
            Aladin.info(this, Aladin.chaine.getString("PROPFRAMEINFO"));
        }
    }

    private void actionCouleur() {
        Color c;
        if (this.couleur == null) {
            return;
        }
        if (!(this.plan instanceof PlanContour) && this.plan.c != (c = this.couleur.getCouleur())) {
            this.plan.c = c;
            this.aladin.calque.repaintAll();
        }
    }

    private boolean actionSourceType() {
        if (this.sourceType == null) {
            return false;
        }
        this.plan.setSourceType(this.sourceType.getSelectedIndex());
        this.aladin.calque.repaintAll();
        return true;
    }

    private void actionPlanXYProjs() {
        if (this.projsChoice == null || this.projsChoice.getSelectedIndex() < 0) {
            return;
        }
        Projection p = this.projs[this.projsChoice.getSelectedIndex()];
        this.plan.pcat.setCoord(p);
        this.plan.setNewProjD(p);
        this.plan.setHasSpecificCalib();
        this.aladin.view.newView(1);
        this.aladin.calque.repaintAll();
    }

    private void actionPlanRefProjs() {
        if (this.planRefChoice.getSelectedIndex() < 0 || this.projsChoice == null || this.projsChoice.getSelectedIndex() < 0) {
            return;
        }
        Plan pref = this.planRef[this.planRefChoice.getSelectedIndex()];
        boolean flagAction = false;
        if (this.projsChoice.getSelectedIndex() < 0 || this.projsChoice.getSelectedIndex() >= this.projs.length) {
            return;
        }
        Projection p = this.projs[this.projsChoice.getSelectedIndex()];
        if (pref.projd != p) {
            Aladin.trace(2, "New proj. method for plane " + pref.label + " => " + p.label);
            pref.projd = p;
            flagAction = true;
        }
        if (!flagAction) {
            return;
        }
        this.aladin.view.newView(1);
        this.aladin.calque.repaintAll();
        this.majPlanRef();
    }

    private void bookmark() {
        FrameBookmarks fb = this.aladin.bookmarks.getFrameBookmarks();
        fb.setVisibleEdit();
        String name = this.aladin.bookmarks.getUniqueName(this.plan.label);
        String code = this.plan.getBookmarkCode();
        StringBuffer param = new StringBuffer();
        if (code != null && code.indexOf("$TARGET") >= 0) {
            param.append("$TARGET");
        }
        if (code != null && code.indexOf("$RADIUS") >= 0) {
            if (param.length() > 0) {
                param.append(',');
            }
            param.append("$RADIUS");
        }
        String param1 = param.length() > 0 ? param.toString() : null;
        fb.createNewBookmark(name, param1, "Load " + this.plan.label + (param1 != null ? "" : " on the view"), code);
    }

    private boolean hasCatalogInfo() {
        try {
            if (this.plan instanceof PlanBGCat) {
                return ((PlanBGCat)this.plan).getGenericPcat().hasCatalogInfo();
            }
            return this.plan.pcat.hasCatalogInfo();
        }
        catch (Exception e) {
            return false;
        }
    }

    private void seeCatalogInfo() {
        if (this.plan instanceof PlanBGCat) {
            ((PlanBGCat)this.plan).getGenericPcat().seeCatalogInfo();
        } else {
            this.plan.pcat.seeCatalogInfo();
        }
    }

    private void apply() {
        String s;
        boolean flag;
        Properties.setFlagFullMaj(true);
        if (this.label != null && !this.label.getText().equals(this.plan.label)) {
            this.plan.setLabel(this.label.getText());
            this.label.setText(this.plan.label);
            this.setTitre(this.BANNER + " \"" + this.plan.label + "\"");
        }
        if (this.blankField != null) {
            this.actionBlank();
        }
        this.actionSpecificProj();
        this.actionSpecificFrame();
        if (this.planRefChoice != null) {
            if (this.plan.hasXYorig) {
                this.actionPlanXYProjs();
            } else {
                this.actionPlanRefProjs();
            }
        }
        this.actionCouleur();
        if (this.scope != null && ((PlanFolder)this.plan).localScope != (flag = this.scopeLocal.isSelected())) {
            ((PlanFolder)this.plan).localScope = flag;
            this.aladin.calque.repaintAll();
        }
        if (this.plan instanceof PlanContour) {
            int i;
            PlanContour pCont = (PlanContour)this.plan;
            int nbLevels = pCont.getIntLevels().length;
            for (i = 0; i < nbLevels; ++i) {
                pCont.setViewable(i, this.contoursCB[i].isSelected());
                pCont.adjustColor(this.contoursCouleurs[i].getCouleur(), i);
            }
            double[] levelTab = new double[this.curs.niveaux.length];
            for (i = 0; i < levelTab.length; ++i) {
                levelTab[i] = this.curs.niveaux[i];
            }
            pCont.adjustContour(levelTab);
            this.curs.repaint();
            Color couleurBase = this.couleur.getCouleur();
            pCont.updateColorIfNeeded(couleurBase);
            this.pmemo = null;
            this.showProp();
        }
        if (this.centerField != null) {
            String s2;
            String s3 = this.centerField.getText();
            String s1 = this.rollField != null ? this.rollField.getText() : null;
            String string = s2 = this.rotateCenter != null ? this.rotateCenter.getText() : null;
            if (!s3.equals(this.sField) || s1 != null && !s1.equals(this.sRoll) || s2 != null && !s2.equals(this.rotateCenterField)) {
                try {
                    double roll;
                    Coord projCenter = new Coord(this.aladin.localisation.getICRSCoord(s3));
                    double d = roll = s1 == null ? 0.0 : Double.valueOf(s1);
                    if ((s2 == null || s2.equals(this.rotateCenterField)) && s1 != null && s1.equals(this.sRoll)) {
                        ((PlanField)this.plan).changeTarget(projCenter.al, projCenter.del);
                    } else {
                        Coord rotCenter = new Coord(this.aladin.localisation.getICRSCoord(s2 != null ? s2 : s3));
                        ((PlanField)this.plan).setParameters(projCenter.al, projCenter.del, rotCenter.al, rotCenter.del, roll);
                    }
                    this.aladin.view.newView();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Aladin.error(this, Aladin.chaine.getString("COORDERR"));
                }
            }
        }
        if (this.eqField != null && !(s = this.eqField.getText()).equals(this.sEquinox)) {
            ((PlanImage)this.plan).projd.c.SetEquinox(Double.valueOf(s));
            this.aladin.view.newView(1);
        }
        if (this.epField != null && !(s = this.epField.getText()).equals(this.plan.getEpoch().getJyr())) {
            try {
                this.plan.setEpoch(s);
                this.epField.setText(this.plan.getEpoch().toString("J"));
                this.epField.setForeground(Color.black);
                this.aladin.view.newView(1);
            }
            catch (Exception e) {
                Aladin.error(this, "Proper motion adjustement error\n=>" + e.getMessage());
                this.epField.setForeground(Color.red);
            }
        }
        if (!this.actionSourceType()) {
            this.aladin.calque.repaintAll();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String what;
        Object src = e.getSource();
        String string = what = src instanceof JButton ? ((JButton)src).getActionCommand() : "";
        if (this.timeField != null && this.moc2STmoc()) {
            this.timeField = null;
        }
        if (src == this.toGenFilterButton) {
            this.plan.toGenericalFilter();
            this.nofilter.setSelected(true);
            return;
        }
        if (src == this.btnDisplayPola || src == this.btnDisplayAmp || src == this.btnDisplayAng) {
            int mode = src == this.btnDisplayPola ? -42 : (src == this.btnDisplayAmp ? -41 : -40);
            ((PlanHealpix)this.plan).displayPolarisation(mode);
        }
        if (src instanceof JCheckBox && this.plan instanceof PlanField && ((PlanField)this.plan).switchCheckbox((JCheckBox)src)) {
            return;
        }
        if (src instanceof JCheckBox && this.plan instanceof PlanContour) {
            this.apply();
            return;
        }
        if (src instanceof JRadioButton && this.plan.isCatalog() && this.filterCB != null) {
            String s = this.filterCB.getSelection().getActionCommand();
            int i = ServerGlu.getFilterIndex(this.plan.filters, s);
            this.toGenFilterButton.setEnabled(i >= 0);
            this.plan.setFilter(i);
        } else if (src instanceof JRadioButton && this.plan instanceof PlanTool) {
            String s = ((JRadioButton)src).getActionCommand();
            try {
                ((PlanTool)this.plan).setMovable(s);
            }
            catch (Exception e1) {}
        } else if (src instanceof JRadioButton && this.plan.ref) {
            Color c;
            String s = this.cb.getSelection().getActionCommand();
            Color color = s == this.WHITE ? Color.white : (c = s == this.BLACK ? Color.black : null);
            if (this.plan.colorBackground == c) {
                return;
            }
            this.plan.colorBackground = c;
            this.aladin.view.repaintAll();
            return;
        }
        if (this.CLOSE.equals(what)) {
            this.dispose();
        } else if (" ? ".equals(what)) {
            Aladin.info(this, this.HSCOPE);
        } else if (this.NEWCALIB.equals(what)) {
            Plan p = this.plan;
            this.aladin.launchRecalibImg(p);
        } else if (this.MODCALIB.equals(what)) {
            Plan p = this.plan;
            if (this.aladin.frameNewCalib == null) {
                this.aladin.frameNewCalib = new FrameNewCalib(this.aladin, p, this.projs[this.projsChoice.getSelectedIndex()]);
            } else {
                this.aladin.frameNewCalib.majFrameNewCalib(p, this.projs[this.projsChoice.getSelectedIndex()]);
            }
        } else if (this.APPLY.equals(what)) {
            this.apply();
        } else if (this.SEEFITS.equals(what)) {
            this.aladin.header(this.plan);
        } else if (this.SEEHIPSPROP.equals(what)) {
            this.aladin.header(this.plan);
        } else if (this.SEEPARSING.equals(what)) {
            this.aladin.tableInfo(this.plan);
        } else if (this.SHOWFOVS.equals(what) || this.HIDEFOVS.equals(what)) {
            boolean flagShow = this.SHOWFOVS.equals(what);
            this.plan.showFootprints(flagShow);
            if (this.plan instanceof PlanBGProgen) {
                ((PlanBGProgen)this.plan).setShowFootprint(flagShow);
            }
        } else if (this.POINTINGLABEL.equals(what)) {
            ((PlanField)this.plan).exportAlmaPointings();
        }
    }

    void setTitre(String s) {
        if (this.border == null) {
            this.border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, s, 2, 2, Aladin.LBOLD), BorderFactory.createEmptyBorder(5, 5, 1, 5)));
        }
        this.propPanel.setBorder(this.border);
    }

    @Override
    public void dispose() {
        this.timeField = null;
        frameProp.removeElement(this);
        super.dispose();
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.dispose();
        }
        super.processWindowEvent(e);
    }

    protected static void addProperties(Properties p) {
        frameProp.addElement(p);
    }

    protected static void createProperties(Plan p) {
        Properties pc = Properties.getProperties(p);
        if (pc != null) {
            pc.toFront();
            return;
        }
        pc = p.type == 12 ? new FilterProperties(p) : new Properties(p);
        pc.showProp();
    }

    protected static void disposeProperties(Plan p) {
        Properties pc = Properties.getProperties(p);
        if (pc != null) {
            pc.dispose();
        }
    }

    protected static Properties getProperties(Plan p) {
        Enumeration e = frameProp.elements();
        while (e.hasMoreElements()) {
            Properties pc = (Properties)e.nextElement();
            if (pc.plan != p) continue;
            return pc;
        }
        return null;
    }

    protected static synchronized void setFlagFullMaj(boolean flag) {
        flagFullMaj = flag;
    }

    protected static void majProp(Plan plan) {
        Enumeration e = frameProp.elements();
        while (e.hasMoreElements()) {
            Properties propc = (Properties)e.nextElement();
            if (propc.plan != plan) continue;
            propc.showProp(true);
        }
    }

    protected static void majProp() {
        Properties.majProp(0);
    }

    protected static void majProp(int methode) {
        Enumeration e = frameProp.elements();
        while (e.hasMoreElements()) {
            Properties propc = (Properties)e.nextElement();
            if (propc.plan.type == 12 || !flagFullMaj && methode == 1 && propc.plan.flagOk) continue;
            propc.showProp(methode == 2);
            propc.majPlanRef();
            propc.majProjs();
        }
        Properties.setFlagFullMaj(false);
    }

    class JButtonTriangle
    extends JPanel
    implements MouseListener {
        boolean in = false;

        JButtonTriangle() {
            this.addMouseListener(this);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(15, 15);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(this.in ? Color.black : Color.darkGray.brighter());
            Util.fillTriangle7(g, 5, 5);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            Properties.this.showPopupMirrors(e, (PlanBG)Properties.this.plan);
            this.in = false;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.in = true;
            this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.in = false;
            this.repaint();
        }
    }

    class TimeField
    extends JPanel
    implements KeyListener {
        PlanSTMoc p;
        JTextField start;
        JTextField end;

        TimeField(double jdmin, double jdmax) {
            this.setLayout(new GridLayout(2, 1));
            try {
                this.start = new JTextField(Astrodate.JDToDate(jdmin));
                this.add(this.start);
                this.end = new JTextField(Astrodate.JDToDate(jdmax));
                this.add(this.end);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        TimeField(PlanSTMoc p) {
            this.p = p;
            this.setLayout(new GridLayout(2, 1));
            try {
                TMoc timeMoc = ((STMoc)p.moc).getTimeMoc();
                this.start = new JTextField(Astrodate.JDToDate(timeMoc.getTimeMin()));
                this.start.addKeyListener(this);
                this.add(this.start);
                this.end = new JTextField(Astrodate.JDToDate(timeMoc.getTimeMax()));
                this.end.addKeyListener(this);
                this.add(this.end);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.submit();
            }
        }

        double getJdmin() {
            return Astrodate.dateToJD(this.start.getText());
        }

        double getJdmax() {
            return Astrodate.dateToJD(this.end.getText());
        }

        void submit() {
            boolean error = false;
            double jdmin = Double.NaN;
            double jdmax = Double.NaN;
            try {
                jdmin = this.getJdmin();
            }
            catch (Exception e) {
                this.start.setForeground(Color.red);
                error = true;
            }
            try {
                jdmax = this.getJdmax();
            }
            catch (Exception e) {
                this.end.setForeground(Color.red);
                error = true;
            }
            if (error) {
                return;
            }
            try {
                this.p.changeTimeRange(jdmin, jdmax);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.start.setForeground(Color.black);
            this.end.setForeground(Color.black);
            Properties.this.aladin.calque.resetTimeRange();
            Properties.this.aladin.view.repaintAll();
        }
    }
}

