/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Calib;
import cds.aladin.MyComboBoxUI;
import cds.aladin.Projection;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ProjSelector
extends JPanel {
    private Aladin aladin;
    private JComboBox<String> combo;
    private ActionListener actionListener;

    protected ProjSelector(Aladin aladin) {
        this.aladin = aladin;
        JLabel lab = new JLabel(Aladin.chaine.getString("PROPPROJ") + " ");
        String tip = Aladin.chaine.getString("PROPPROJTIP");
        Util.toolTip(lab, tip);
        lab.setFont(lab.getFont().deriveFont(1));
        lab.setForeground(Aladin.COLOR_LABEL);
        String[] list = Projection.getAlaProj();
        this.combo = new JComboBox<String>(list);
        this.combo.setUI(new MyComboBoxUI());
        this.combo.setMaximumRowCount(list.length);
        this.combo.setFont(Aladin.PLAIN);
        Util.toolTip(this.combo, tip);
        String s = aladin.configuration.getProj();
        this.initProjection(s);
        this.actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjSelector.this.submitProjection((String)ProjSelector.this.combo.getSelectedItem());
            }
        };
        this.combo.addActionListener(this.actionListener);
        this.combo.setPrototypeDisplayValue("12345678");
        GridBagLayout g = new GridBagLayout();
        JPanel pCombo = new JPanel(g);
        pCombo.setBackground(aladin.getBackground());
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        pCombo.add(this.combo, gc);
        this.setLayout(new BorderLayout(7, 7));
        this.setBackground(aladin.getBackground());
        this.add((Component)lab, "West");
        this.add((Component)pCombo, "Center");
        this.setEnabled(false);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.combo.setEnabled(enabled);
    }

    protected void setProjectionSilently(String s) {
        this.combo.removeActionListener(this.actionListener);
        this.setProjection(s);
        this.combo.addActionListener(this.actionListener);
    }

    protected void setProjection(String s) {
        int index = Projection.getAlaProjIndex(s);
        if (index < 0) {
            return;
        }
        this.combo.setSelectedIndex(index);
    }

    protected void submitProjection(String s) {
        this.aladin.calque.modifyProjection(s);
    }

    protected void initProjection(String s) {
        this.combo.setSelectedItem(s);
    }

    protected int getProjType() {
        int i = Projection.getAlaProjIndex((String)this.combo.getSelectedItem());
        String calibProj = Projection.alaProjToType[i];
        i = Calib.getProjType(calibProj);
        return i;
    }

    protected String getProjName() {
        return Calib.getProjName(this.getProjType());
    }

    protected String getProjItem() {
        return (String)this.combo.getSelectedItem();
    }
}

