/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.Projection;
import cds.aladin.Source;
import cds.aladin.ViewSimple;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

class Printer
implements Runnable {
    Thread thread;
    private Aladin aladin;
    static int MARGE = 22;

    Printer(Aladin aladin) {
        this.aladin = aladin;
        this.thread = new Thread((Runnable)this, "AladinPrinter");
        Util.decreasePriority(Thread.currentThread(), this.thread);
        this.thread.start();
    }

    @Override
    public void run() {
        this.aladin.setFlagPrint(true);
        try {
            String mode = "VIEW";
            if (this.aladin.view.isMultiView()) {
                this.printMosaique();
                mode = "MOSAIC";
            } else {
                this.printCurrentView();
            }
            this.aladin.log("print", mode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.aladin.setFlagPrint(false);
    }

    private void adjustGraphics(Graphics2D pg, PageFormat pf, int w, int h) {
        double x = pf.getImageableX();
        double y = pf.getImageableY();
        double margeX = Math.max((double)MARGE, x);
        double margeY = Math.max((double)MARGE, y);
        double W = pf.getImageableWidth() - margeX - (double)(x == 0.0 ? MARGE : 0);
        double H = pf.getImageableHeight() - margeY - (double)(y == 0.0 ? MARGE : 0);
        double scaleW = W / (double)w;
        double scaleH = H / (double)h;
        double scale = Math.min(scaleW, scaleH);
        pg.translate(margeX, margeY);
        pg.scale(scale, scale);
    }

    private void printCurrentView() throws Exception {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(new PrintCurrentView(this.aladin.view.getCurrentView()));
        if (job.printDialog()) {
            job.print();
        }
    }

    private void printMosaique() throws Exception {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(new printMosaique());
        if (job.printDialog()) {
            job.print();
        }
    }

    private int printCopyright(Graphics pg, int x, int y, int imgW, boolean flagOrigin) {
        Font f = new Font("TimesRoman", 0, 7);
        pg.setColor(Color.black);
        pg.setFont(f);
        FontMetrics fm = pg.getFontMetrics();
        int cx = x;
        int cy = y + fm.getAscent() + 2;
        pg.drawString("Produced by Aladin (Centre de Donnees astronomiques de Strasbourg)", cx, cy);
        pg.drawString("http://aladin.u-strasbg.fr", cx, cy += fm.getHeight());
        Plan p = this.aladin.calque.getPlanRef();
        if (flagOrigin && p != null && p.copyright != null) {
            cy = y + fm.getAscent() + 2;
            cx = imgW - fm.stringWidth(p.copyright);
            pg.drawString(p.copyright, cx, cy);
        }
        return cy + fm.getDescent() + fm.getLeading();
    }

    private int printTitre(Graphics pg, int x, int y, int wImg) {
        int cx;
        char ch;
        Font f = new Font("TimesRoman", 0, 20);
        Font f1 = new Font("TimesRoman", 0, 14);
        Plan p = this.aladin.calque.getPlanRef();
        if (p == null || !Projection.isOk(p.projd)) {
            return 30;
        }
        String titre = p.objet == null ? null : ((ch = p.objet.charAt(0)) < '0' || ch > '9' ? p.objet : null);
        pg.setColor(Color.black);
        pg.setFont(f);
        FontMetrics fm = pg.getFontMetrics();
        int cy = y + fm.getHeight();
        if (p.isImage()) {
            pg.setFont(f1);
            fm = pg.getFontMetrics();
            cx = wImg - fm.stringWidth(p.label) - 10;
            pg.drawString(p.label, cx, cy);
            pg.setFont(f);
            fm = pg.getFontMetrics();
        }
        cx = x;
        if (titre != null) {
            pg.drawString(titre, cx, cy);
            cy += fm.getAscent();
        }
        return cy + 2;
    }

    private void printLegende(Graphics pg, int x, int y, boolean cadre) {
        Plan p;
        Plan[] plan = this.aladin.calque.plan;
        Font f = new Font("TimesRoman", 0, 12);
        Vector<Plan> v = new Vector<Plan>(10);
        int W = 0;
        pg.setFont(f);
        FontMetrics fm = pg.getFontMetrics();
        int dy = fm.getHeight();
        for (int i = 0; i < plan.length; ++i) {
            p = plan[i];
            if (!p.isCatalog() || !p.flagOk || p.error != null || !p.active) continue;
            v.addElement(p);
            int w = fm.stringWidth(p.getLabel());
            if (w <= W) continue;
            W = w;
        }
        if (v.size() == 0) {
            return;
        }
        W += 28;
        int H = v.size() * dy + fm.getDescent();
        if (cadre) {
            pg.setColor(Color.white);
            pg.fillRect(x - W, y, W, H);
            pg.setColor(Color.black);
            pg.drawRect(x - W, y, W, H);
        }
        int cy = y + dy;
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            p = (Plan)e.nextElement();
            if (!p.isCatalog() || !p.flagOk || p.error != null || !p.active) continue;
            Iterator<Obj> it = p.iterator();
            Source o = null;
            while (it.hasNext()) {
                Obj o1 = it.next();
                if (!(o1 instanceof Source)) continue;
                o = (Source)o1;
                break;
            }
            int cx = x - W + 10;
            if (o != null) {
                o.print(pg, cx, cy - dy / 3);
            }
            pg.setColor(Color.black);
            pg.drawString(p.getLabel(), cx += 10, cy);
            cy += dy;
        }
    }

    class printMosaique
    implements Printable {
        static final int GAP = 10;

        printMosaique() {
        }

        @Override
        public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
            double scaleH;
            if (page > 0) {
                return 1;
            }
            int x = MARGE;
            int y = 70;
            int offsetY = 0;
            int col = ((Printer)Printer.this).aladin.viewControl.getNbCol();
            int w = ((Printer)Printer.this).aladin.view.getWidth() + 10 * (col - 1);
            int W = (int)pf.getImageableWidth();
            int h = ((Printer)Printer.this).aladin.view.getWidth() + 10 * (col - 1);
            int H = (int)pf.getImageableWidth();
            double scaleW = (double)W / (double)w;
            if (scaleW > 1.0) {
                scaleW = 1.0 + (scaleW - 1.0) / 2.0;
            }
            if ((scaleH = (double)H / (double)(h + 70)) > 1.0) {
                scaleH = 1.0 + (scaleH - 1.0) / 2.0;
            }
            double scale = Math.min(scaleW, scaleH);
            Graphics2D pg = (Graphics2D)g;
            pg.scale(scale, scale);
            for (int i = 0; i < ((Printer)Printer.this).aladin.view.getNbView(); ++i) {
                ViewSimple v = ((Printer)Printer.this).aladin.view.viewSimple[i];
                if (i > 0 && i % col == 0) {
                    x = MARGE;
                    y += offsetY;
                    offsetY = 0;
                }
                if (!v.isFree()) {
                    try {
                        pg.setClip(x, y, v.getWidth(), v.getHeight());
                        Image img = v.getImage(-1, -1);
                        pg.drawImage(img, x, y, Printer.this.aladin);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                pg.setColor(Color.black);
                pg.drawRect(x, y, v.getWidth(), v.getHeight());
                x += v.getWidth() + 10;
                if (v.getHeight() <= offsetY) continue;
                offsetY = v.getHeight() + 10;
            }
            x = MARGE;
            g.setClip(x, y += offsetY, w, 200);
            Printer.this.printCopyright(pg, x, y, w, false);
            return 0;
        }
    }

    class PrintCurrentView
    implements Printable {
        private ViewSimple v;

        PrintCurrentView(ViewSimple v) {
            this.v = v;
        }

        @Override
        public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
            if (page > 0) {
                return 1;
            }
            int w = this.v.getWidth();
            int h = this.v.getHeight();
            Printer.this.adjustGraphics((Graphics2D)g, pf, w, h);
            int x = 1;
            int y = 1;
            g.setClip(0, 0, x + w, y + h + 200);
            y = Printer.this.printTitre(g, x, y, w);
            g.setClip(x, y, w, h);
            if (this.v.pref.active) {
                Image img = this.v.getImage(-1, -1);
                g.drawImage(img, x, y, Printer.this.aladin);
            }
            g.setClip(0, 0, x + w, y + h + 200);
            g.setColor(Color.black);
            g.drawRect(x, y, w, h);
            Printer.this.printLegende(g, x + w, y + 20, true);
            y += h;
            y = Printer.this.printCopyright(g, 0, y, w, true);
            return 0;
        }
    }

    class PrintTest
    implements Printable {
        private ViewSimple v;

        PrintTest(ViewSimple v) {
            this.v = v;
        }

        @Override
        public int print(Graphics g, PageFormat pf, int page) throws PrinterException {
            if (page > 0) {
                return 1;
            }
            int w = this.v.getWidth();
            int h = this.v.getHeight();
            Printer.this.adjustGraphics((Graphics2D)g, pf, w, h);
            g.setColor(Color.black);
            g.drawRect(0, 0, w, h);
            g.setColor(Color.red);
            g.drawLine(0, 0, w, h);
            g.drawLine(0, h, w, 0);
            g.setColor(Color.blue);
            return 0;
        }
    }
}

