/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Plan;
import cds.aladin.PlanMoc;
import cds.aladin.Plot;
import cds.aladin.PointD;
import cds.aladin.ViewSimple;
import cds.moc.Moc;
import cds.moc.SMoc;
import cds.moc.TMoc;
import cds.tools.Astrodate;
import cds.tools.Util;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;

public class PlanTMoc
extends PlanMoc {
    protected Moc[] arrayTimeMoc = null;
    protected boolean mocTimeLowReset = false;
    private int lastTimeOrderDrawn = -1;
    protected double oz = -1.0;
    private static final int MAXDRAWCELL = 100;
    private double[] lastDrawTimeRange = new double[]{Double.NaN, Double.NaN};
    public static final int BAND = 20;
    public static final int MARGE = 30;

    public PlanTMoc(Aladin a) {
        super(a);
        this.type = 23;
    }

    protected PlanTMoc(Aladin aladin, MyInputStream in, String label) {
        super(aladin);
        this.dis = in;
        this.useCache = false;
        this.type = 23;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        if (label == null) {
            label = "TMOC";
        }
        this.setLabel(label);
        Aladin.trace(3, "TMOC creation: " + Plan.Tp[this.type]);
        this.suite();
    }

    protected PlanTMoc(Aladin aladin, TMoc moc, String label) {
        super(aladin);
        this.moc = moc;
        this.useCache = false;
        this.type = 23;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        if (label == null) {
            label = "TMOC";
        }
        this.setLabel(label);
        Aladin.trace(3, "TMOC creation: " + Plan.Tp[this.type]);
        this.suite();
    }

    @Override
    protected void addMessageInfo(StringBuilder buf, MyProperties prop) {
        long nbMicrosec = ((TMoc)this.moc).getNbCells();
        PlanTMoc.ADD(buf, "\n* Start: ", Astrodate.JDToDate(((TMoc)this.moc).getTimeMin()));
        PlanTMoc.ADD(buf, "\n* End: ", Astrodate.JDToDate(((TMoc)this.moc).getTimeMax()));
        PlanTMoc.ADD(buf, "\n* Sum: ", Util.getTemps(nbMicrosec / 1000L, true));
        int order = PlanTMoc.getRealMaxOrder((TMoc)this.moc);
        int drawOrder = this.getDrawOrder();
        PlanTMoc.ADD(buf, "\n", "* Accuracy: " + TMoc.getTemps(TMoc.getDuration(order)));
        PlanTMoc.ADD(buf, "\n", "* TMOC order: " + (order == drawOrder ? order + "" : drawOrder + "/" + order));
    }

    @Override
    protected boolean isTime() {
        return true;
    }

    protected double getTimeMin() {
        double tmin = ((TMoc)this.moc).getTimeMin();
        if (tmin == -1.0) {
            tmin = Double.NaN;
        }
        return tmin;
    }

    protected double getTimeMax() {
        double tmax = ((TMoc)this.moc).getTimeMax();
        if (tmax == -1.0) {
            tmax = Double.NaN;
        }
        return tmax;
    }

    @Override
    protected double[] getTimeRange() {
        return new double[]{this.getTimeMin(), this.getTimeMax()};
    }

    @Override
    protected boolean waitForPlan() {
        if (this.dis != null) {
            this.error = null;
            try {
                if (this.moc == null && this.dis != null) {
                    this.moc = new TMoc();
                    if ((this.dis.getType() & 1L) != 0L) {
                        this.moc.readFits(this.dis);
                    } else {
                        this.moc.readASCII(this.dis);
                    }
                }
                if (this.moc.getSize() == 0) {
                    this.error = "Empty TMOC";
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                return false;
            }
        }
        return true;
    }

    protected TMoc getTimeMoc() {
        return (TMoc)this.moc;
    }

    protected static int getRealMaxOrder(SMoc m) {
        return m.getMocOrder();
    }

    protected boolean isSpaceModified() {
        return false;
    }

    protected void mocTimeLowReset() {
        this.mocTimeLowReset = true;
    }

    @Override
    protected int getDrawOrder() {
        return this.lastTimeOrderDrawn;
    }

    protected Moc getTimeMocLow(int order, int gapOrder) {
        TMoc moc = this.getTimeMoc();
        if (Aladin.NOGUI) {
            return moc;
        }
        if ((order += gapOrder) > ((Moc)moc).getTimeOrder()) {
            order = ((Moc)moc).getTimeOrder();
        }
        if (order < 0) {
            order = 0;
        }
        if (this.arrayTimeMoc == null || this.arrayTimeMoc[order] == null || this.mocTimeLowReset) {
            if (this.arrayTimeMoc == null) {
                this.arrayTimeMoc = new TMoc[30];
            }
            this.arrayTimeMoc[order] = new TMoc();
            int myOrder = order;
            int myMo = ((Moc)moc).getTimeOrder();
            Aladin.trace(4, "PlanTMoc.getHealpixMocLow(" + myOrder + ") running...");
            Moc mocLow = myOrder == myMo ? moc : ((Moc)moc).clone();
            try {
                mocLow.setMocOrder(myOrder);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.arrayTimeMoc[myOrder] = mocLow;
            Aladin.trace(4, "PlanTMoc.getHealpixMocLow(" + myOrder + ") done !");
            this.askForRepaint();
        }
        if (this.arrayTimeMoc[order].getSize() == 0) {
            int i;
            this.isLoading = true;
            for (i = order; i >= 5 && (this.arrayTimeMoc[i] == null || this.arrayTimeMoc[i].getSize() == 0); --i) {
            }
            if (i >= 5) {
                order = i;
            }
        } else {
            this.isLoading = false;
        }
        this.lastTimeOrderDrawn = order;
        return this.arrayTimeMoc[order];
    }

    protected int getDrawingOrder(ViewSimple v) {
        int o;
        Plot plot = v.plot;
        double dureeView = plot.getMax() - plot.getMin();
        for (o = 29; o >= 3; --o) {
            double nbCell = dureeView / ((double)TMoc.getDuration(o) / 1000000.0);
            if (!(nbCell < 100.0)) continue;
            return o;
        }
        return o;
    }

    @Override
    protected void draw(Graphics g, ViewSimple v) {
        if (!v.isPlotTime()) {
            return;
        }
        this.drawInTimeView(g, v);
    }

    protected double[] getLastDrawTimeRange() {
        return this.lastDrawTimeRange;
    }

    protected double getLastDrawTmin() {
        return this.lastDrawTimeRange[0];
    }

    protected double getLastDrawTmax() {
        return this.lastDrawTimeRange[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawInTimeView(Graphics g, ViewSimple v) {
        Plot plot = v.plot;
        boolean flagBorder = false;
        boolean flagfillIn = true;
        g.setColor(this.c);
        double tmin = plot.getMin();
        double tmax = plot.getMax();
        v.setTimeRange(new double[]{tmin, tmax});
        int drawingOrder = this.getDrawingOrder(v);
        TMoc lowMoc = (TMoc)this.getTimeMocLow(drawingOrder, this.gapOrder);
        this.mocTimeLowReset = false;
        Iterator<long[]> it = lowMoc.jdIterator(tmin, tmax);
        long[] jdRange = null;
        ArrayList<Rectangle> a = new ArrayList<Rectangle>();
        while (it.hasNext()) {
            jdRange = it.next();
            a.add(this.computeRectangle(plot, (double)jdRange[0] / 8.64E10, (double)jdRange[1] / 8.64E10));
        }
        if (flagfillIn && g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            Composite saveComposite = g2d.getComposite();
            try {
                g2d.setComposite(Util.getImageComposite(this.getOpacityLevel()));
                for (Rectangle r : a) {
                    if (flagBorder && this.width <= 1) continue;
                    g.fillRect(r.x, r.y, r.width, r.height);
                }
            }
            finally {
                g2d.setComposite(saveComposite);
            }
        }
        if (flagBorder) {
            for (Rectangle r : a) {
                g.drawRect(r.x, r.y, r.width, r.height);
            }
        }
    }

    private Rectangle computeRectangle(Plot plot, double jdstart, double jdstop) {
        Rectangle r = new Rectangle();
        Coord c = new Coord();
        c.al = jdstart;
        c.del = 0.0;
        plot.getProj().getXY(c);
        PointD a = plot.viewSimple.getPositionInView(c.x, c.y);
        c.al = jdstop;
        plot.getProj().getXY(c);
        PointD b = plot.viewSimple.getPositionInView(c.x, c.y);
        r.x = (int)a.x;
        r.y = plot.viewSimple.getHeight() - 15 * (this.timeStackIndex + 1) - 30;
        r.width = (int)Math.abs(b.x - a.x);
        if (r.width == 0) {
            r.width = 1;
        }
        r.height = 20;
        return r;
    }

    @Override
    protected void planReady(boolean ready) {
        this.setPourcent(-1.0);
        this.active = true;
        this.flagOk = ready;
        this.aladin.synchroPlan.stop(this.startingTaskId);
        this.flagWaitTarget = false;
        this.flagProcessing = false;
        this.aladin.calque.resetTimeRange();
        this.planReadyPost();
        this.aladin.view.repaintAll();
    }

    protected void planReadyPost() {
        this.aladin.view.createView4TMOC(this);
    }
}

