/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.MyInputStream;
import cds.aladin.Plan;
import cds.aladin.PlanMoc;
import cds.aladin.PlanSTMoc;
import cds.aladin.Position;
import cds.aladin.Source;
import cds.moc.Healpix;
import cds.moc.Range2;
import cds.moc.SMoc;
import cds.moc.STMoc;
import cds.moc.TMoc;
import cds.tools.Util;

public class PlanSTMocGen
extends PlanSTMoc {
    private Plan[] p;
    private double duration;
    private double radius;
    private boolean fov;
    private int timeOrder = 14;
    private int spaceOrder = 10;
    private boolean flagOneRange = false;
    private double gapPourcent;
    static final String TEST = "tmin=212100466200000000 tmax=212100741077906944 smin=1907076530098405376 smax=1907077629610033152";
    private boolean stop;

    protected PlanSTMocGen(Aladin aladin, String label, Plan[] p, int spaceOrder, int timeOrder, double duration, double radius, boolean fov) {
        super(aladin, (MyInputStream)null, label, null, 0.0);
        Aladin.trace(3, "STMOC creation: " + Plan.Tp[this.type]);
        this.c = null;
        this.p = p;
        this.label = label;
        this.spaceOrder = spaceOrder;
        this.timeOrder = timeOrder;
        this.duration = duration;
        this.radius = radius;
        this.fov = fov;
        this.pourcent = 0.0;
        this.gapPourcent = 100 / p.length;
        this.suiteSpecific();
        this.threading();
        this.log();
    }

    @Override
    protected void launchLoading() {
    }

    protected PlanSTMocGen(Aladin aladin, String label, Plan[] pList, int spaceOrder, int timeOrder, double jdmin, double jdmax) {
        super(aladin);
        PlanMoc p1 = (PlanMoc)pList[0];
        p1.copy(this);
        this.type = 24;
        this.setLabel(label == null ? "[" + this.label + "]" : label);
        this.c = Couleur.getNextDefault(aladin.calque);
        SMoc m1 = (SMoc)p1.getMoc().clone();
        for (int i = 1; i < pList.length; ++i) {
            SMoc m2 = (SMoc)((PlanMoc)pList[i]).getMoc();
            try {
                m1 = (SMoc)m1.union(m2);
                continue;
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) continue;
                e.printStackTrace();
            }
        }
        m1.toRangeSet();
        Range2 r = new Range2();
        long min = (long)(jdmin * 8.64E10);
        long max = (long)(jdmax * 8.64E10) + 1L;
        r.append(min, max, m1.range);
        this.moc = new STMoc(spaceOrder == -1 ? m1.getMocOrder() : spaceOrder, timeOrder < 0 ? 29 : timeOrder, r);
        this.flagOneRange = true;
    }

    @Override
    protected boolean isOneTimeRange() {
        return this.flagOneRange && ((STMoc)this.moc).range.nranges() == 1;
    }

    protected void addIt(STMoc m, int order, long npix, double jdtmin, double jdtmax) {
        long smin = npix << 2 * (29 - order);
        long smax = npix + 1L << 2 * (29 - order);
        this.addIt(m, smin, smax, jdtmin, jdtmax);
    }

    protected void addIt(STMoc m, long smin, long smax, double jdtmin, double jdtmax) {
        long tmin = 0L;
        long tmax = 0L;
        try {
            tmin = (long)(jdtmin * 8.64E10);
            tmax = (long)(jdtmax * 8.64E10 + (double)TMoc.getDuration(this.timeOrder));
            m.add(tmin, tmax, smin, smax);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("MOC=" + m);
            System.err.println("tmin=" + tmin + " tmax=" + tmax + " smin=" + smin + " smax=" + smax);
        }
    }

    @Override
    protected boolean Free() {
        this.stop = true;
        return super.Free();
    }

    /*
     * Unable to fully structure code
     */
    private void addMocFromCatalog(Plan p1, double duration, double radius, boolean fov) throws Exception {
        block15: {
            t0 = System.currentTimeMillis();
            this.stop = false;
            m2 = new STMoc(this.spaceOrder, this.timeOrder);
            it = p1.iterator();
            m = p1.getCounts();
            hpx = new Healpix();
            coo = new Coord();
            incrPourcent = this.gapPourcent / (double)m;
            while (it.hasNext()) {
                o = it.next();
                if (!(o instanceof Position)) continue;
                this.pourcent += incrPourcent;
                if (++m % 100 == 0) {
                    if (this.stop) {
                        throw new Exception("Abort");
                    }
                    try {
                        this.moc = this.moc.union(m2);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    m2 = new STMoc(this.spaceOrder, this.timeOrder);
                }
                try {
                    jdtime = ((Position)o).jdtime;
                    if (Double.isNaN(jdtime)) continue;
                    npixs = null;
                    if (fov) {
                        s = (Source)o;
                        sf = s.getFootprint();
                        if (sf == null || (listStcs = sf.getStcObjects()) == null) continue;
                        try {
                            m1 = this.aladin.createMocRegion(listStcs, this.spaceOrder);
                            m1.toRangeSet();
                            r = m1.range;
                            for (j = 0; j < r.sz; j += 2) {
                                this.addIt(m2, r.r[j], r.r[j + 1], jdtime, jdtime + duration / 86400.0);
                            }
                        }
                        catch (Exception e) {
                            if (Aladin.levelTrace < 3) ** GOTO lbl46
                            e.printStackTrace();
                        }
                    } else {
                        coo.al = ((Position)o).raj;
                        coo.del = ((Position)o).dej;
                        npixs = radius == 0.0 ? new long[]{hpx.ang2pix(this.spaceOrder, coo.al, coo.del)} : hpx.queryDisc(this.spaceOrder, coo.al, coo.del, radius);
                    }
lbl46:
                    // 4 sources

                    if (npixs == null) continue;
                    for (long npix : npixs) {
                        this.addIt(m2, this.spaceOrder, npix, jdtime, jdtime + duration / 86400.0);
                    }
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) continue;
                    e.printStackTrace();
                }
            }
            try {
                this.moc = this.moc.union(m2);
                this.moc.toMocSet();
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block15;
                e.printStackTrace();
            }
        }
        t1 = System.currentTimeMillis();
        System.out.println("STMOC generated in " + (t1 - t0) + "ms");
    }

    @Override
    protected boolean waitForPlan() {
        long t0 = System.currentTimeMillis();
        try {
            this.moc = new STMoc(this.spaceOrder, this.timeOrder);
            for (Plan p1 : this.p) {
                if (!p1.isCatalogTime()) continue;
                if (this.c == null) {
                    this.c = p1.c.darker();
                }
                this.addMocFromCatalog(p1, this.duration, this.radius, this.fov);
            }
        }
        catch (Exception e) {
            this.error = e.getMessage();
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.flagProcessing = false;
            return false;
        }
        long t1 = System.currentTimeMillis();
        Aladin.trace(3, "STMOC built in " + Util.getTemps(t1 - t0));
        this.flagProcessing = false;
        if (this.moc.getSize() == 0) {
            this.error = "Empty STMOC";
        }
        this.flagOk = true;
        this.aladin.calque.repaintAll();
        return true;
    }
}

