/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Couleur;
import cds.aladin.Plan;
import cds.aladin.PlanMoc;
import cds.aladin.PlanSTMoc;
import cds.moc.Moc;
import cds.moc.STMoc;
import cds.tools.Util;

public class PlanSTMocAlgo
extends PlanSTMoc {
    static final int UNION = 0;
    static final int INTERSECTION = 1;
    static final int SUBTRACTION = 2;
    static final int DIFFERENCE = 3;
    static final int COMPLEMENT = 4;
    static final int TOORDER = 5;
    private static final String[] OPERATION = new String[]{"union", "inter", "sub", "diff", "compl", "ord"};

    protected static String getOpName(int op) {
        return OPERATION[op];
    }

    static int getOp(String s) {
        if (s.startsWith("-")) {
            s = s.substring(1);
        }
        return Util.indexInArrayOf(s, OPERATION, true);
    }

    public PlanSTMocAlgo(Aladin aladin, String label, PlanMoc[] pList, int op, int spaceOrder, int timeOrder) {
        super(aladin);
        PlanMoc p1 = pList[0];
        p1.copy(this);
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        String s = this.getFonction(p1, pList, op, timeOrder);
        if (label == null) {
            label = s;
        }
        this.setLabel(label);
        Aladin.trace(3, "STMOC computation: " + Plan.Tp[this.type] + " => " + s);
        long t0 = System.currentTimeMillis();
        try {
            this.moc = p1.getMoc().clone();
            if (op == 5) {
                this.moc.setMocOrder(timeOrder);
            } else {
                block7: for (int i = 1; i < pList.length; ++i) {
                    Moc m1 = this.moc;
                    Moc m2 = pList[i].getMoc();
                    switch (op) {
                        case 0: {
                            this.moc = m1.union(m2);
                            continue block7;
                        }
                        case 1: {
                            this.moc = m1.intersection(m2);
                            continue block7;
                        }
                        case 2: {
                            this.moc = m1.subtraction(m2);
                        }
                    }
                }
            }
            if (timeOrder >= 0) {
                ((STMoc)this.moc).setTimeOrder(timeOrder);
            }
            if (spaceOrder >= 0) {
                ((STMoc)this.moc).setSpaceOrder(spaceOrder);
            }
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.moc.clear();
            Aladin.error = this.error = e.getMessage();
            this.flagOk = false;
        }
        long t1 = System.currentTimeMillis();
        System.out.println("STMOC operation done in " + (t1 - t0) + "ms");
        this.copyright = "Computed by Aladin";
        this.flagProcessing = false;
        this.flagOk = true;
        this.setActivated(this.flagOk);
        if (this.moc.getSize() == 0) {
            this.error = "Empty STMOC";
        }
        aladin.calque.repaintAll();
        this.sendLog("Compute", " [" + this + " = " + s + "]");
    }

    @Override
    protected void launchLoading() {
    }

    private String getFonction(PlanMoc p1, PlanMoc[] pList, int op, int order) {
        if (op == 5) {
            return p1.label + ":" + order;
        }
        String lab2 = pList.length > 1 ? pList[1].label : null;
        String lab3 = pList.length > 2 ? pList[2].label : null;
        return p1.label + " " + PlanSTMocAlgo.getOpName(op) + (lab2 == null ? " " : lab2 + (lab3 == null ? "" : " ..."));
    }
}

