/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Plan;
import cds.aladin.PlanTMoc;
import cds.aladin.Tok;
import cds.aladin.ViewSimple;
import cds.moc.Moc;
import cds.moc.SMoc;
import cds.moc.STMoc;
import cds.moc.TMoc;
import cds.tools.Astrodate;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.awt.Graphics;

public class PlanSTMoc
extends PlanTMoc {
    private double[] oLastDrawTimeRange = null;
    private SMoc oLastDrawMoc = null;
    private SMoc lastCurrentSpaceMoc = null;
    private TMoc lastCurrentTimeMoc = null;

    public PlanSTMoc(Aladin a) {
        super(a);
        this.type = 24;
    }

    protected PlanSTMoc(Aladin aladin, MyInputStream in, String label, Coord c, double radius) {
        super(aladin);
        this.dis = in;
        this.type = 24;
        this.useCache = false;
        this.frameOrigin = 0;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        if (label == null) {
            label = "STMOC";
        }
        this.setLabel(label);
        this.co = c;
        this.coRadius = radius;
        Aladin.trace(3, "STMOC creation: " + Plan.Tp[this.type] + (c != null ? " around " + c : ""));
        this.suite();
    }

    protected PlanSTMoc(Aladin aladin, STMoc moc, String label, Coord c, double radius) {
        super(aladin);
        this.moc = moc;
        this.useCache = false;
        this.frameOrigin = 0;
        this.type = 24;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        if (label == null) {
            label = "STMOC";
        }
        this.setLabel(label);
        this.co = c;
        this.coRadius = radius;
        Aladin.trace(3, "STMOC creation: " + Plan.Tp[this.type] + (c != null ? " around " + c : ""));
        this.suite();
    }

    protected boolean isOneTimeRange() {
        return false;
    }

    protected void changeTimeRange(double jdmin, double jdmax) throws Exception {
        if (!this.isOneTimeRange()) {
            throw new Exception("Not a oneTimeRange STMOC");
        }
        long min = (long)(jdmin * 8.64E10);
        long max = (long)(jdmax * 8.64E10) + 1L;
        STMoc m = (STMoc)this.moc;
        m.range.r[0] = min;
        m.range.r[1] = max;
    }

    @Override
    protected void addMessageInfo(StringBuilder buf, MyProperties prop) {
        STMoc stmoc = (STMoc)this.moc;
        PlanSTMoc.ADD(buf, "\n* Start: ", Astrodate.JDToDate(stmoc.getTimeMin()));
        PlanSTMoc.ADD(buf, "\n* End: ", Astrodate.JDToDate(stmoc.getTimeMax()));
        PlanSTMoc.ADD(buf, "\n* # ranges: ", stmoc.range.nranges() + "");
        int timeOrder = stmoc.getTimeOrder();
        PlanSTMoc.ADD(buf, "\n* Time res: ", TMoc.getTemps(TMoc.getDuration(timeOrder)));
        PlanSTMoc.ADD(buf, "\n* Best time order: ", timeOrder + "");
        double cov = 0.0;
        try {
            cov = stmoc.getSpaceMoc().getCoverage();
        }
        catch (Exception e) {
            // empty catch block
        }
        double degrad = Math.toDegrees(1.0);
        double skyArea = Math.PI * 4 * degrad * degrad;
        PlanSTMoc.ADD(buf, "\n \n* Space: ", Coord.getUnit(skyArea * cov, false, true) + "^2, " + Util.round(cov * 100.0, 3) + "% of sky");
        int spaceOrder = stmoc.getSpaceOrder();
        PlanSTMoc.ADD(buf, "\n* Space res: ", Coord.getUnit(CDSHealpix.pixRes(spaceOrder) / 3600.0));
        PlanSTMoc.ADD(buf, "\n* Best space order: ", spaceOrder + "");
        if (Aladin.levelTrace > 0) {
            PlanSTMoc.ADD(buf, "\n \nRAM: ", Util.getUnitDisk(stmoc.getMem()));
        }
    }

    @Override
    protected double getTimeMin() {
        double tmin = ((STMoc)this.moc).getTimeMin();
        if (tmin == -1.0) {
            tmin = Double.NaN;
        }
        return tmin;
    }

    @Override
    protected double getTimeMax() {
        double tmax = ((STMoc)this.moc).getTimeMax();
        if (tmax == -1.0) {
            tmax = Double.NaN;
        }
        return tmax;
    }

    @Override
    protected boolean waitForPlan() {
        if (this.dis != null) {
            this.error = null;
            try {
                if (this.moc == null && this.dis != null) {
                    this.moc = new STMoc();
                    if ((this.dis.getType() & 1L) != 0L) {
                        this.moc.readFits(this.dis);
                    } else {
                        this.moc.readASCII(this.dis);
                    }
                }
                if (this.moc.getSize() == 0) {
                    this.error = "Empty STMOC";
                }
            }
            catch (Exception e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                return false;
            }
        }
        return true;
    }

    protected SMoc getCurrentSpaceMoc(ViewSimple v) {
        return this.getCurrentSpaceMoc(v, false);
    }

    protected SMoc getCurrentSpaceMoc(ViewSimple v, boolean echoCommand) {
        long tmax;
        double[] t = v.getTimeRange();
        if (v == this.aladin.view.getCurrentView()) {
            this.oLastDrawTimeRange = t;
        }
        long tmin = Double.isNaN(t[0]) ? -1L : (long)(t[0] * 8.64E10);
        long l = tmax = Double.isNaN(t[1]) ? Long.MAX_VALUE : (long)(t[1] * 8.64E10);
        if (echoCommand) {
            String range = Double.isNaN(t[0]) && Double.isNaN(t[1]) ? "" : (Double.isNaN(t[0]) ? " -timeRange=NaN/" + Astrodate.JDToDate(t[1]) : (Double.isNaN(t[1]) ? " -timeRange=" + Astrodate.JDToDate(t[0]) + "/NaN" : " -timeRange=" + Astrodate.JDToDate(t[0]) + "/" + Astrodate.JDToDate(t[1])));
            this.aladin.console.printCommand("cmoc" + range + " " + Tok.quote(this.label));
        }
        try {
            return ((STMoc)this.moc).getSpaceMoc(tmin, tmax);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected SMoc getCurrentSpaceMoc(ViewSimple v, STMoc moc) {
        double[] t = v.getTimeRange();
        if (v == this.aladin.view.getCurrentView()) {
            this.oLastDrawTimeRange = t;
        }
        long tmin = Double.isNaN(t[0]) ? -1L : (long)(t[0] * 8.64E10);
        long tmax = Double.isNaN(t[1]) ? Long.MAX_VALUE : (long)(t[1] * 8.64E10);
        try {
            return moc.getSpaceMoc(tmin, tmax);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return null;
        }
    }

    protected TMoc getCurrentTimeMoc() {
        try {
            return ((STMoc)this.moc).getTimeMoc(this.isDisplayedInView() ? this.oLastDrawMoc : null);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private boolean isDisplayedInView() {
        int m = this.aladin.view.getNbView();
        for (int i = 0; i < m; ++i) {
            ViewSimple v = this.aladin.view.viewSimple[i];
            if (v.isFree() || !v.selected || v.isPlotTime()) continue;
            return true;
        }
        return false;
    }

    private ViewSimple getViewPlot() {
        int m = this.aladin.view.getNbView();
        for (int i = 0; i < m; ++i) {
            if (!this.aladin.view.viewSimple[i].isPlotTime()) continue;
            return this.aladin.view.viewSimple[i];
        }
        return null;
    }

    private boolean isDisplayedInPlot() {
        ViewSimple v = this.getViewPlot();
        return v != null && v.selected;
    }

    @Override
    protected void memoNewTime() {
        ViewSimple v = this.aladin.view.getCurrentView();
        this.oLastDrawTimeRange = v.getTimeRange();
        this.oiz = -1L;
        this.askForRepaint();
    }

    protected void memoNewSpace() {
        this.oLastDrawMoc = this.isDisplayedInView() ? this.getLastDrawMoc() : null;
        this.mocTimeLowReset();
        this.oiz = -1L;
        this.askForRepaint();
    }

    @Override
    protected boolean isSpaceModified() {
        if (!this.isDisplayedInPlot()) {
            return false;
        }
        SMoc m = this.isDisplayedInView() ? this.getLastDrawMoc() : null;
        boolean rep = !this.mocEquals(m, this.oLastDrawMoc);
        return rep;
    }

    public boolean mocEquals(Moc m1, Moc m2) {
        if (m1 == null && m2 == null) {
            return true;
        }
        if (m1 == null || m2 == null) {
            return false;
        }
        return ((SMoc)m1).equals(m2);
    }

    @Override
    protected boolean isTimeModified() {
        ViewSimple v = this.aladin.view.getCurrentView();
        double[] t = v.getTimeRange();
        boolean rep = (Double.isNaN(t[0]) && Double.isNaN(this.oLastDrawTimeRange[0]) || t[0] == this.oLastDrawTimeRange[0]) && (Double.isNaN(t[1]) && Double.isNaN(this.oLastDrawTimeRange[1]) || t[1] == this.oLastDrawTimeRange[1]);
        return !rep;
    }

    @Override
    protected Moc getSpaceMocLow(ViewSimple v, int order, int gapOrder) {
        STMoc m1 = (STMoc)this.getSpaceMocLow1(v, order, gapOrder);
        SMoc m = this.getCurrentSpaceMoc(v, m1);
        try {
            m.setMinOrder(3);
        }
        catch (Exception e) {
            // empty catch block
        }
        return m;
    }

    @Override
    protected void initArrayMoc(int order) {
        if (this.arrayMoc == null) {
            this.arrayMoc = new Moc[30];
        }
        this.arrayMoc[order] = new STMoc();
    }

    @Override
    protected SMoc getSpaceMoc() {
        SMoc m;
        ViewSimple v = this.aladin.view.getCurrentView();
        if (this.lastCurrentSpaceMoc != null && !this.isTimeModified()) {
            return this.lastCurrentSpaceMoc;
        }
        this.lastCurrentSpaceMoc = m = this.getCurrentSpaceMoc(v);
        this.memoNewTime();
        return this.lastCurrentSpaceMoc;
    }

    @Override
    protected TMoc getTimeMoc() {
        TMoc m;
        if (this.lastCurrentTimeMoc != null && !this.isSpaceModified()) {
            return this.lastCurrentTimeMoc;
        }
        this.lastCurrentTimeMoc = m = this.getCurrentTimeMoc();
        this.memoNewSpace();
        return this.lastCurrentTimeMoc;
    }

    @Override
    protected void draw(Graphics g, ViewSimple v) {
        if (v.isPlotTime()) {
            this.drawInTimeView(g, v);
        } else {
            this.drawInSpaceView(g, v);
        }
    }
}

