/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Plan;
import cds.aladin.PlanMoc;
import cds.moc.Moc;
import cds.moc.SMoc;
import cds.moc.STMoc;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.util.ArrayList;

public class PlanMocAlgo
extends PlanMoc {
    static final int UNION = 0;
    static final int INTERSECTION = 1;
    static final int SUBTRACTION = 2;
    static final int DIFFERENCE = 3;
    static final int COMPLEMENT = 4;
    static final int TOORDER = 5;
    protected static final String[] OPERATION = new String[]{"union", "inter", "sub", "diff", "compl", "ord"};

    protected static String getOpName(int op) {
        return OPERATION[op];
    }

    static int getOp(String s) {
        if (s.startsWith("-")) {
            s = s.substring(1);
        }
        return Util.indexInArrayOf(s, OPERATION, true);
    }

    public PlanMocAlgo(Aladin aladin, String label, PlanMoc[] pList, int op, int order) {
        super(aladin);
        PlanMoc p1 = pList[0];
        p1.copy(this);
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        String s = this.getFonction(p1, pList, op, order);
        if (label == null) {
            label = s;
        }
        this.setLabel(label);
        Aladin.trace(3, "MOC computation: " + Plan.Tp[this.type] + " => " + s);
        try {
            this.moc = p1.getMoc().clone();
            if (op == 4) {
                this.moc = ((SMoc)this.moc).complement();
            } else if (op == 5) {
                this.moc.setMocOrder(order);
            } else {
                block8: for (int i = 1; i < pList.length; ++i) {
                    Moc m1 = this.moc;
                    SMoc m2 = pList[i].toReferenceFrame(m1.getSys());
                    switch (op) {
                        case 0: {
                            this.moc = m1.union(m2);
                            continue block8;
                        }
                        case 1: {
                            this.moc = m1.intersection(m2);
                            continue block8;
                        }
                        case 2: {
                            this.moc = m1.subtraction(m2);
                            continue block8;
                        }
                        case 3: {
                            this.moc = ((SMoc)m1).difference(m2);
                        }
                    }
                }
            }
            ((SMoc)this.moc).setMinOrder(3);
            if (order != -1) {
                this.moc.setMocOrder(order);
            }
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.moc.clear();
            Aladin.error = this.error = e.getMessage();
            this.flagOk = false;
        }
        this.copyright = "Computed by Aladin";
        this.flagProcessing = false;
        this.flagOk = true;
        this.setActivated(this.flagOk);
        if (this.moc.getSize() == 0) {
            this.error = "Empty MOC";
        }
        aladin.calque.repaintAll();
        this.sendLog("Compute", " [" + this + " = " + s + "]");
    }

    protected PlanMocAlgo(Aladin aladin, String label, PlanMoc mocSource, Coord[] cooPolygon) {
        super(aladin);
        mocSource.copy(this);
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        String s = "crop";
        if (label == null) {
            label = s;
        }
        this.setLabel(label);
        Aladin.trace(3, "MOC cropping: " + Plan.Tp[this.type] + " => " + s);
        try {
            int order = mocSource.moc.getMaxUsedOrder();
            ArrayList<double[]> a = new ArrayList<double[]>();
            for (Coord c : cooPolygon) {
                a.add(new double[]{c.al, c.del});
            }
            SMoc m1 = CDSHealpix.createSMoc(a, order);
            this.moc = m1.intersection(mocSource.moc);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.moc.clear();
            Aladin.error = this.error = e.getMessage();
            this.flagOk = false;
        }
        this.copyright = "Computed by Aladin";
        this.flagProcessing = false;
        if (this.moc.getSize() == 0) {
            this.error = "Empty MOC";
            this.flagOk = true;
        } else {
            this.flagOk = true;
        }
        this.setActivated(this.flagOk);
        aladin.calque.repaintAll();
        this.sendLog("Compute", " [" + this + " = " + s + "]");
    }

    protected PlanMocAlgo(Aladin aladin, String label, PlanMoc mocSource, double jdmin, double jdmax) {
        super(aladin);
        mocSource.copy(this);
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        String s = "timecrop";
        if (label == null) {
            label = s;
        }
        this.setLabel(label);
        Aladin.trace(3, "MOC temporal cropping: " + Plan.Tp[this.type] + " => " + s);
        try {
            long tmin = Double.isNaN(jdmin) ? -1L : (long)(jdmin * 8.64E10);
            long tmax = Double.isNaN(jdmax) ? Long.MAX_VALUE : (long)(jdmax * 8.64E10);
            this.moc = ((STMoc)mocSource.moc).getSpaceMoc(tmin, tmax);
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.moc.clear();
            Aladin.error = this.error = e.getMessage();
            this.flagOk = false;
        }
        this.copyright = "Computed by Aladin";
        this.flagProcessing = false;
        if (this.moc.getSize() == 0) {
            this.error = "Empty MOC";
            this.flagOk = true;
        } else {
            this.flagOk = true;
        }
        this.setActivated(this.flagOk);
        aladin.calque.repaintAll();
        this.sendLog("Compute", " [" + this + " = " + s + "]");
    }

    @Override
    protected void launchLoading() {
    }

    private String getFonction(PlanMoc p1, PlanMoc[] pList, int op, int order) {
        if (op == 5) {
            return p1.label + ":" + order;
        }
        String lab2 = pList.length > 1 ? pList[1].label : null;
        String lab3 = pList.length > 2 ? pList[2].label : null;
        return p1.label + " " + PlanMocAlgo.getOpName(op) + (lab2 == null ? " " : lab2 + (lab3 == null ? "" : " ..."));
    }
}

