/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.Couleur;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanBGCat;
import cds.aladin.Properties;
import cds.aladin.Tok;
import cds.aladin.ViewSimple;
import cds.moc.Array;
import cds.moc.Moc;
import cds.moc.MocCell;
import cds.moc.SMoc;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Hpix;
import cds.tools.pixtools.Util;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;

public class PlanMoc
extends PlanBGCat {
    public static final int DRAW_BORDER = 1;
    public static final int DRAW_FILLIN = 4;
    public static final int DRAW_PERIMETER = 8;
    protected Moc moc = null;
    protected int wireFrame = 5;
    static int MAXGAPORDER = 3;
    protected int gapOrder = 0;
    protected Moc[] arrayMoc = null;
    protected ArrayList<Hpix> arrayHpix = null;
    private ArrayList<Hpix> arrayPeri = null;
    private static final int[] A = new int[]{2, 1, 0, 3};
    private long lastBuildingTime = -1L;
    protected boolean isLoading = false;
    protected int lastOrderDrawn = -1;
    protected long oiz = -1L;
    private boolean oFlagPeri;
    private int oGapOrder;
    private SMoc lastDrawMoc = null;
    protected float factorOpacity = 0.5f;

    public PlanMoc(Aladin a) {
        super(a);
        this.type = 19;
    }

    protected PlanMoc(Aladin aladin, SMoc moc, String label, Coord c, double radius) {
        this(aladin, null, moc, label, c, radius);
    }

    protected PlanMoc(Aladin aladin, MyInputStream in, String label, Coord c, double radius) {
        this(aladin, in, null, label, c, radius);
    }

    protected PlanMoc(Aladin aladin, MyInputStream in, SMoc moc, String label, Coord c, double radius) {
        super(aladin);
        this.dis = in;
        this.moc = moc;
        this.useCache = false;
        this.frameOrigin = 0;
        if (moc != null) {
            String f = moc.getSys();
            int n = f.equals("E") ? 2 : (this.frameOrigin = f.equals("G") ? 3 : 0);
            if (moc.getSize() < 10000) {
                this.setMaxGapOrder();
            }
        }
        this.type = 19;
        this.c = Couleur.getNextDefault(aladin.calque);
        this.setOpacityLevel(1.0f);
        if (label == null) {
            label = "MOC";
        }
        this.setLabel(label);
        this.co = c;
        this.coRadius = radius;
        Aladin.trace(3, "MOC creation: " + Plan.Tp[this.type] + (c != null ? " around " + c : ""));
        this.suite();
    }

    @Override
    protected void copy(Plan p1) {
        super.copy(p1);
        PlanMoc pm = (PlanMoc)p1;
        pm.frameOrigin = this.frameOrigin;
        pm.moc = this.moc != null ? this.moc.clone() : null;
        pm.wireFrame = this.wireFrame;
        pm.gapOrder = this.gapOrder;
        this.arrayPeri = null;
        pm.arrayHpix = null;
    }

    @Override
    protected void addMessageInfo(StringBuilder buf, MyProperties prop) {
        double cov = ((SMoc)this.moc).getCoverage();
        double degrad = Math.toDegrees(1.0);
        double skyArea = Math.PI * 4 * degrad * degrad;
        PlanMoc.ADD(buf, "\n* Space: ", Coord.getUnit(skyArea * cov, false, true) + "^2, " + cds.tools.Util.round(cov * 100.0, 3) + "% of sky");
        PlanMoc.ADD(buf, "\n* Best ang.res: ", Coord.getUnit(((SMoc)this.moc).getAngularRes()));
        int order = this.moc.getMocOrder();
        int drawOrder = this.getDrawOrder();
        PlanMoc.ADD(buf, "\n", "* SMOC order: " + (order == drawOrder ? order + "" : "draw:" + drawOrder + "/" + order));
    }

    public SMoc toReferenceFrame(String coordSys) throws Exception {
        SMoc moc1 = SMoc.convertTo((SMoc)this.moc, coordSys);
        if (this.moc != moc1) {
            Aladin.trace(2, "Moc reference frame conversion: " + this.moc.getSys() + " => " + moc1.getSys());
        }
        return moc1;
    }

    protected static int getRealMaxOrder(SMoc m) {
        Array a;
        int nOrder = m.getMaxUsedOrder();
        if (nOrder <= 0) {
            return nOrder;
        }
        while (((a = m.getArray(nOrder)) == null || a.getSize() == 0) && nOrder > 0) {
            --nOrder;
        }
        return nOrder;
    }

    public static String createPerimeterString(SMoc moc) throws Exception {
        StringBuilder res = null;
        ArrayList<double[]> a = PlanMoc.getPerimeter(moc);
        for (int i = a.size() - 1; i >= 0; --i) {
            double[] c = a.get(i);
            if (c == null) continue;
            if (res == null) {
                res = new StringBuilder(c[0] + "," + c[1]);
            }
            res.append("," + c[0] + "," + c[1]);
        }
        return res.toString();
    }

    public static ArrayList<double[]> getPerimeter(SMoc moc) throws Exception {
        if (moc == null) {
            return null;
        }
        int maxOrder = PlanMoc.getRealMaxOrder(moc);
        ArrayList<double[]> a = new ArrayList<double[]>();
        if (maxOrder == -1 || moc.isFull()) {
            return a;
        }
        SMoc done = new SMoc(moc.getSys(), moc.getMinOrder(), maxOrder);
        Iterator<Long> it = moc.pixelIterator();
        while (it.hasNext()) {
            long pix = it.next();
            PlanMoc.parcoursBord(maxOrder, moc, done, a, maxOrder, pix, 0, 0);
            if (a.size() <= 0 || a.get(a.size() - 1) == null) continue;
            a.add(null);
        }
        return a;
    }

    private static void parcoursBord(int order, SMoc moc, SMoc done, ArrayList<double[]> a, int maxOrder, long pix, int sens, int rec) throws Exception {
        if (done.isIntersecting(maxOrder, pix)) {
            return;
        }
        if (rec > 10000) {
            return;
        }
        done.add(maxOrder, pix);
        long[] voisins = PlanMoc.getVoisins(order, moc, maxOrder, pix);
        double[][] corners = null;
        for (int j = 0; j < 4; ++j) {
            boolean flagAdd;
            int i = (sens + j) % 4;
            long voisin = voisins[i];
            if (voisin != -1L) continue;
            if (corners == null) {
                corners = PlanMoc.getCorners(order, pix);
            }
            if ((flagAdd = true) && a.size() > 0) {
                double[] lastCorner = a.get(a.size() - 1);
                boolean bl = flagAdd = lastCorner == null || lastCorner[0] != corners[i][0] || lastCorner[1] != corners[i][1];
            }
            if (flagAdd) {
                a.add(corners[i]);
            }
            a.add(corners[i < 3 ? i + 1 : 0]);
            long nextVoisin = voisins[i < 3 ? i + 1 : 0];
            if (nextVoisin == -1L) continue;
            long[] vVoisins = PlanMoc.getVoisins(order, moc, maxOrder, nextVoisin);
            long nNextVoisin = vVoisins[i];
            if (nNextVoisin != -1L) {
                PlanMoc.parcoursBord(order, moc, done, a, maxOrder, nNextVoisin, i == 0 ? 3 : i - 1, rec + 1);
            } else {
                PlanMoc.parcoursBord(order, moc, done, a, maxOrder, nextVoisin, i, rec + 1);
            }
            if (a.size() <= 0 || a.get(a.size() - 1) == null) continue;
            a.add(null);
        }
    }

    private static double[][] getCorners(int order, long pix) throws Exception {
        double[][] radec = CDSHealpix.borders(order, pix, 1);
        double[][] corners = new double[radec.length][2];
        for (int i = 0; i < radec.length; ++i) {
            int j = A[i];
            corners[j] = CDSHealpix.polarToRadec(radec[i]);
        }
        return corners;
    }

    private static long[] getVoisins(int order, SMoc moc, int maxOrder, long npix) throws Exception {
        long[] voisins = new long[4];
        long[] neib = CDSHealpix.neighbours(order, npix);
        int i = 0;
        int j = 0;
        while (i < voisins.length) {
            voisins[i] = moc.isIntersecting(maxOrder, neib[j]) ? neib[j] : -1L;
            ++i;
            j += 2;
        }
        return voisins;
    }

    private long[] getVoisinsSameOrder(int order, SMoc moc, int maxOrder, long npix) throws Exception {
        long[] voisins = new long[4];
        long[] neib = CDSHealpix.neighbours(order, npix);
        int i = 0;
        int j = 0;
        while (i < voisins.length) {
            voisins[i] = moc.isIn(maxOrder, neib[j]) ? neib[j] : -1L;
            ++i;
            j += 2;
        }
        return voisins;
    }

    protected int getMocOrder() {
        return this.moc.getMocOrder();
    }

    protected Moc getMoc() {
        return this.moc;
    }

    @Override
    protected void suiteSpecific() {
        this.isOldPlan = false;
    }

    @Override
    protected boolean isSync() {
        return this.isReady() && !this.isLoading();
    }

    @Override
    protected void reallocObjetCache() {
    }

    public void setWireFrame(int wireFrame) {
        this.wireFrame = wireFrame;
    }

    public void switchWireFrame(int mask) {
        this.wireFrame &= ~mask;
    }

    public int getWireFrame() {
        return this.wireFrame;
    }

    public boolean isDrawingBorder() {
        return (this.wireFrame & 1) != 0;
    }

    public boolean isDrawingFillIn() {
        return (this.wireFrame & 4) != 0;
    }

    public boolean isDrawingPerimeter() {
        return (this.wireFrame & 8) != 0;
    }

    public void setDrawingBorder(boolean flag) {
        this.wireFrame = flag ? (this.wireFrame |= 1) : (this.wireFrame &= 0xFFFFFFFE);
    }

    public void setDrawingFillIn(boolean flag) {
        this.wireFrame = flag ? (this.wireFrame |= 4) : (this.wireFrame &= 0xFFFFFFFB);
    }

    public void setDrawingPerimeter(boolean flag) {
        this.wireFrame = flag ? (this.wireFrame |= 8) : (this.wireFrame &= 0xFFFFFFF7);
    }

    public String getPropDrawingMethod() {
        StringBuilder s = new StringBuilder();
        if (this.isDrawingPerimeter()) {
            if (s.length() > 0) {
                s.append(',');
            }
            s.append("perimeter");
        }
        if (this.isDrawingBorder()) {
            if (s.length() > 0) {
                s.append(',');
            }
            s.append("border");
        }
        if (this.isDrawingFillIn()) {
            if (s.length() > 0) {
                s.append(',');
            }
            s.append("fill");
        }
        return s.toString();
    }

    public String getPropCoverage() {
        return cds.tools.Util.myRound(((SMoc)this.moc).getCoverage());
    }

    public String getPropMocOrder() {
        return PlanMoc.getRealMaxOrder((SMoc)this.moc) + "";
    }

    @Override
    protected boolean isCatalog() {
        return false;
    }

    @Override
    protected boolean isTime() {
        return false;
    }

    @Override
    protected boolean hasSources() {
        return false;
    }

    @Override
    protected boolean hasCatalogInfo() {
        return false;
    }

    @Override
    protected int getCounts() {
        return 0;
    }

    @Override
    protected void planReadyMoc() {
    }

    @Override
    protected boolean waitForPlan() {
        block21: {
            if (this.dis != null) {
                super.waitForPlan();
                try {
                    String c;
                    if (this.moc == null && this.dis != null) {
                        this.moc = new SMoc();
                        if ((this.dis.getType() & 1L) != 0L) {
                            this.moc.readFits(this.dis);
                        } else {
                            this.moc.readASCII(this.dis);
                        }
                    }
                    int n = this.frameOrigin = (c = this.moc.getSys()) == null || c.charAt(0) == 'G' ? 3 : 0;
                    if (this.moc.getSize() == 0) {
                        this.error = "Empty MOC";
                    }
                }
                catch (Exception e) {
                    if (Aladin.levelTrace >= 3) {
                        e.printStackTrace();
                    }
                    return false;
                }
            }
            if (this.moc != null && !this.moc.isEmpty()) {
                double[] radec;
                if (this.co != null) {
                    int order = this.moc.getMocOrder();
                    Coord c = Localisation.frameToFrame(this.co, 0, this.frameOrigin);
                    radec = CDSHealpix.radecToPolar(new double[]{c.al, c.del});
                    try {
                        long npix = CDSHealpix.ang2pix_nest(order, radec[0], radec[1]);
                        if (!((SMoc)this.moc).isIntersecting(order, npix)) {
                            this.co = null;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (this.co == null || this.co.al == 0.0 && this.co.del == 0.0) {
                    try {
                        MocCell cell = this.moc.iterator().next();
                        double[] res = CDSHealpix.pix2ang_nest(cell.getOrder(), cell.getNpix());
                        radec = CDSHealpix.polarToRadec(new double[]{res[0], res[1]});
                        this.co = Localisation.frameToFrame(new Coord(radec[0], radec[1]), this.frameOrigin, 0);
                        Aladin.trace(3, "MOC target (re)computed from the first MOC HEALPix cell => " + this.co);
                    }
                    catch (Exception e) {
                        if (Aladin.levelTrace < 3) break block21;
                        e.printStackTrace();
                    }
                }
            }
        }
        if (this.moc != null && ((SMoc)this.moc).getMinOrder() < 3) {
            try {
                if (this.moc.getMocOrder() < 3) {
                    this.moc.setMocOrder(3);
                }
                ((SMoc)this.moc).setMinOrder(3);
            }
            catch (Exception e) {
                if (Aladin.levelTrace >= 3) {
                    e.printStackTrace();
                }
                this.error = "MOC error";
                return false;
            }
        }
        return true;
    }

    @Override
    protected Iterator<Obj> iterator() {
        return null;
    }

    @Override
    protected void resetProj(int n) {
    }

    @Override
    protected boolean isDrawn() {
        return true;
    }

    protected SMoc getViewMoc(ViewSimple v, int order) throws Exception {
        return (SMoc)v.getMoc(order);
    }

    protected void setMaxGapOrder() {
        this.setGapOrder(MAXGAPORDER);
    }

    @Override
    protected int getGapOrder() {
        return this.gapOrder;
    }

    @Override
    protected void setGapOrder(int gapOrder) {
        if (Math.abs(gapOrder) > MAXGAPORDER) {
            return;
        }
        this.gapOrder = gapOrder;
    }

    @Override
    protected void setPropertie(String prop, String specif, String value) throws Exception {
        int a = -1;
        int b = -1;
        int c = -1;
        if (prop.equalsIgnoreCase("drawing")) {
            Tok tok = new Tok(value, ", ");
            while (tok.hasMoreTokens()) {
                String v = tok.nextToken();
                a = cds.tools.Util.indexOfIgnoreCase(v, "perimeter");
                if (a >= 0) {
                    this.setDrawingPerimeter(a <= 0 || v.charAt(a - 1) != '-');
                }
                if ((b = cds.tools.Util.indexOfIgnoreCase(v, "fill")) >= 0) {
                    this.setDrawingFillIn(b <= 0 || v.charAt(b - 1) != '-');
                    b = v.indexOf(":", b);
                    if (b > 0) {
                        try {
                            float f = Float.parseFloat(v.substring(b + 1));
                            if (f < 0.1f || f > 1.0f) {
                                throw new Exception();
                            }
                            this.factorOpacity = f;
                        }
                        catch (Exception e) {
                            throw new Exception("set drawing parameter unknown [" + v + "]");
                        }
                    }
                }
                if ((c = cds.tools.Util.indexOfIgnoreCase(v, "border")) >= 0) {
                    this.setDrawingBorder(c <= 0 || v.charAt(c - 1) != '-');
                }
                if (a >= 0 || b >= 0 || c >= 0) continue;
                throw new Exception("set drawing parameter unknown [" + v + "]");
            }
            Properties.majProp(this);
        } else {
            super.setPropertie(prop, specif, value);
        }
    }

    protected SMoc getSpaceMoc() {
        return (SMoc)this.moc;
    }

    protected boolean isTimeModified() {
        return false;
    }

    protected Moc getSpaceMocLow(ViewSimple v, int order, int gapOrder) {
        SMoc m = (SMoc)this.getSpaceMocLow1(v, order, gapOrder);
        try {
            m.setMinOrder(3);
        }
        catch (Exception e) {
            // empty catch block
        }
        return m;
    }

    protected int getLowOrder(int order, int gapOrder) {
        int mo = this.moc.getSpaceOrder();
        if (mo == -1) {
            try {
                mo = PlanMoc.getRealMaxOrder((SMoc)this.moc);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (mo < 3) {
            mo = 3;
        }
        if ((order += 5) < 7) {
            order = 7;
        }
        if ((order += gapOrder) < 5) {
            order = 5;
        }
        if (order > mo) {
            order = mo;
        }
        return order;
    }

    protected Moc getSpaceMocLow1(ViewSimple v, int order, int gapOrder) {
        int mo;
        block13: {
            if (Aladin.NOGUI) {
                return this.moc;
            }
            mo = this.moc.getMaxUsedOrder();
            if (mo < 3) {
                mo = 3;
            }
            order = this.getLowOrder(order, gapOrder);
            if (v.getTaille() < 20.0) {
                try {
                    if (order < this.moc.getSpaceOrder()) {
                        ++order;
                    }
                    Moc mocP = this.arrayMoc != null && this.arrayMoc[order] != null && this.arrayMoc[order].getSize() > 0 ? this.arrayMoc[order] : this.moc;
                    Moc moclow = mocP.intersection(v.getMoc());
                    moclow.setSpaceOrder(order);
                    return moclow;
                }
                catch (Exception e) {
                    if (Aladin.levelTrace < 3) break block13;
                    e.printStackTrace();
                }
            }
        }
        if (this.arrayMoc == null || this.arrayMoc[order] == null) {
            this.initArrayMoc(order);
            BuildLow t = new BuildLow(this.moc, order, mo);
            if (this.moc.getSize() < 100000 || this.lastBuildingTime >= 0L && this.lastBuildingTime < 30L) {
                t.run();
            } else {
                t.start();
            }
        }
        if (this.arrayMoc[order].getSize() == 0) {
            int i;
            this.isLoading = true;
            for (i = order; i >= 5 && (this.arrayMoc[i] == null || this.arrayMoc[i].getSize() == 0); --i) {
            }
            if (i >= 5) {
                order = i;
            }
        } else {
            this.isLoading = false;
        }
        this.lastOrderDrawn = order;
        return this.arrayMoc[order];
    }

    protected void initArrayMoc(int order) {
        if (this.arrayMoc == null) {
            this.arrayMoc = new Moc[30];
        }
        this.arrayMoc[order] = new SMoc();
    }

    @Override
    protected boolean isLoading() {
        return this.isLoading;
    }

    @Override
    protected boolean hasMoreDetails() {
        return this.moc != null && this.lastOrderDrawn < this.moc.getMaxUsedOrder();
    }

    protected int getDrawOrder() {
        return this.lastOrderDrawn;
    }

    @Override
    protected double getCompletude() {
        return -1.0;
    }

    protected void memoNewTime() {
    }

    @Override
    protected void draw(Graphics g, ViewSimple v) {
        this.drawInSpaceView(g, v);
    }

    protected SMoc getLastDrawMoc() {
        return this.lastDrawMoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawInSpaceView(Graphics g, ViewSimple v) {
        block17: {
            long t1 = cds.tools.Util.getTime();
            g.setColor(this.c);
            int max = Math.min(this.maxOrder(v), this.maxOrder) + 1;
            try {
                long t = 0L;
                int myOrder = max + (v.isAllSky() ? 0 : 1);
                int drawingOrder = 0;
                Moc lowMoc = null;
                boolean flagPeri = this.isDrawingPerimeter();
                boolean flagBorder = this.isDrawingBorder();
                boolean flagFill = this.isDrawingFillIn();
                int gapOrder = this.gapOrder;
                if (this.mustDrawFast()) {
                    --gapOrder;
                }
                if (this.oiz != v.getIZ() || flagPeri != this.oFlagPeri || gapOrder != this.oGapOrder) {
                    lowMoc = this.getSpaceMocLow(v, myOrder, gapOrder);
                    drawingOrder = PlanMoc.getRealMaxOrder((SMoc)lowMoc);
                    if (drawingOrder == -1) {
                        return;
                    }
                    this.lastDrawMoc = this.getViewMoc(v, max);
                    String coordsys = this.moc.getSys();
                    boolean notEquatorial = this.moc != null && coordsys != null && !coordsys.equals("C");
                    SMoc viewMoc = v.isAllSky() || notEquatorial ? null : this.lastDrawMoc;
                    ArrayList<Hpix> a1 = new ArrayList<Hpix>(10000);
                    ArrayList<Hpix> a2 = !flagPeri ? null : new ArrayList<Hpix>(10000);
                    for (MocCell c : lowMoc) {
                        long[] vo;
                        Hpix p;
                        if (viewMoc != null && !viewMoc.isIntersecting(c.order, c.npix) || (p = new Hpix(c.order, c.npix, this.frameOrigin)).isOutView(v)) continue;
                        a1.add(p);
                        if (!flagPeri || (vo = this.getVoisinsSameOrder(p.order, (SMoc)lowMoc, p.order, p.npix))[0] != -1L && vo[1] != -1L && vo[2] != -1L && vo[3] != -1L) continue;
                        long base = p.npix << 2 * (drawingOrder - p.order);
                        Bord bord = new Bord((int)CDSHealpix.pow2(drawingOrder - p.order));
                        while (bord.hasNext()) {
                            long b = bord.next();
                            long pix = base | b;
                            vo = PlanMoc.getVoisins(drawingOrder, (SMoc)lowMoc, drawingOrder, pix);
                            int mask = (vo[0] == -1L ? 1 : 0) | (vo[1] == -1L ? 2 : 0) | (vo[2] == -1L ? 4 : 0) | (vo[3] == -1L ? 8 : 0);
                            if (mask == 0) continue;
                            Hpix p1 = new Hpix(drawingOrder, pix, this.frameOrigin);
                            p1.setBorderMask(mask);
                            a2.add(p1);
                        }
                    }
                    this.arrayHpix = a1;
                    this.arrayPeri = a2;
                    this.oiz = v.getIZ();
                    this.oFlagPeri = flagPeri;
                    this.oGapOrder = gapOrder;
                }
                if (flagFill && this.arrayHpix != null && g instanceof Graphics2D) {
                    Graphics2D g2d = (Graphics2D)g;
                    Composite saveComposite = g2d.getComposite();
                    try {
                        g2d.setComposite(cds.tools.Util.getImageComposite(this.getOpacityLevel() * this.getFactorOpacity()));
                        for (Hpix p : this.arrayHpix) {
                            boolean small = flagBorder && p.getDiag2(v) < 25.0;
                            if (small) continue;
                            p.fill(g, v);
                        }
                    }
                    finally {
                        g2d.setComposite(saveComposite);
                    }
                }
                if (flagBorder && this.arrayHpix != null) {
                    for (Hpix p : this.arrayHpix) {
                        p.draw(g, v);
                    }
                }
                if (flagPeri && this.arrayPeri != null) {
                    for (Hpix p : this.arrayPeri) {
                        p.draw(g, v);
                    }
                }
                t = cds.tools.Util.getTime();
                this.statTimeDisplay = t - t1;
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block17;
                e.printStackTrace();
            }
        }
    }

    protected float getFactorOpacity() {
        return this.factorOpacity;
    }

    static class Bord
    implements Iterator<Long> {
        int order;
        int bord;
        int i;

        public Bord(int order) {
            this.order = order;
            this.i = 0;
            this.bord = 0;
        }

        @Override
        public boolean hasNext() {
            if (this.order < 2 && this.i > 0) {
                return false;
            }
            return this.bord < 3 || this.bord == 3 && this.i < this.order - 1;
        }

        @Override
        public Long next() {
            long res;
            long l = this.bord == 0 ? Util.getHpxNestedNumber(0, this.i) : (this.bord == 1 ? Util.getHpxNestedNumber(this.i, this.order - 1) : (res = this.bord == 2 ? Util.getHpxNestedNumber(this.order - 1, this.order - this.i - 1) : Util.getHpxNestedNumber(this.order - this.i - 1, 0)));
            if (++this.i >= this.order) {
                ++this.bord;
                this.i = 1;
            }
            return res;
        }

        @Override
        public void remove() {
        }
    }

    class BuildLow
    extends Thread {
        int myOrder;
        int myMo;
        Moc moc;

        BuildLow(Moc moc, int myOrder, int myMo) {
            super("BuidLow order=" + myOrder);
            this.setPriority(this.getPriority() - 1);
            this.moc = moc;
            this.myOrder = myOrder;
            this.myMo = myMo;
        }

        @Override
        public void run() {
            long t0 = System.currentTimeMillis();
            Aladin.trace(4, "PlanMoc.getHealpixMocLow(" + this.myOrder + ") running...");
            Moc mocLow = null;
            if (this.myOrder == this.myMo) {
                mocLow = this.moc;
            } else {
                for (int o = this.myOrder; o < this.myMo; ++o) {
                    if (PlanMoc.this.arrayMoc[o] == null || PlanMoc.this.arrayMoc[o].getSize() == 0) continue;
                    mocLow = PlanMoc.this.arrayMoc[o].clone();
                    break;
                }
                if (mocLow == null) {
                    mocLow = this.moc.clone();
                }
            }
            try {
                mocLow.setSpaceOrder(this.myOrder);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            PlanMoc.this.arrayMoc[this.myOrder] = mocLow;
            PlanMoc.this.lastBuildingTime = System.currentTimeMillis() - t0;
            Aladin.trace(4, "PlanMoc.getHealpixMocLow(" + this.myOrder + ") done in " + PlanMoc.this.lastBuildingTime + "ms");
            PlanMoc.this.askForRepaint();
        }
    }
}

