/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameHeaderFits;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.ResourceNode;
import cds.tools.Util;
import java.util.Date;

public class PlanImageRice
extends PlanImage {
    static byte[] b = new byte[1];
    private static final long MASK = 0xFFFFFFFFL;
    private static final int[] nonzero_count = new int[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};

    protected PlanImageRice(Aladin aladin, String file, MyInputStream inImg, String label, String from, Obj o, ResourceNode imgNode, boolean skip, boolean doClose, Plan forPourcent) {
        super(aladin, file, inImg, label, from, o, imgNode, skip, doClose, forPourcent);
    }

    @Override
    protected boolean cacheImageFits(MyInputStream dis) throws Exception {
        int n;
        if (this.headerFits == null) {
            this.headerFits = new FrameHeaderFits((Plan)this, dis);
        }
        this.bitpix = this.headerFits.getIntFromHeader("ZBITPIX");
        this.width = this.naxis1 = this.headerFits.getIntFromHeader("ZNAXIS1");
        this.height = this.naxis2 = this.headerFits.getIntFromHeader("ZNAXIS2");
        this.npix = n = Math.abs(this.bitpix) / 8;
        int taille = this.width * this.height * n;
        this.setPourcent(0.0);
        Aladin.trace(3, " => NAXIS1=" + this.width + " NAXIS2=" + this.height + " BITPIX=" + this.bitpix + " => size=" + taille);
        this.loadFitsHeaderParam(this.headerFits);
        Date d = new Date();
        int nnaxis1 = this.headerFits.getIntFromHeader("NAXIS1");
        int nnaxis2 = this.headerFits.getIntFromHeader("NAXIS2");
        int theap = nnaxis1 * nnaxis2;
        try {
            theap = this.headerFits.getIntFromHeader("THEAP");
        }
        catch (Exception e) {
            // empty catch block
        }
        int pcount = this.headerFits.getIntFromHeader("PCOUNT");
        int tile = this.headerFits.getIntFromHeader("ZTILE1");
        boolean cut = this.aladin.configuration.getCMCut();
        int nblock = 32;
        try {
            nblock = this.headerFits.getIntFromHeader("ZVAL1");
        }
        catch (Exception e) {
            // empty catch block
        }
        int bsize = 4;
        try {
            bsize = this.headerFits.getIntFromHeader("ZVAL2");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setBufPixels8(new byte[this.width * this.height]);
        if (this.flagSkip) {
            dis.skip(theap + pcount);
        } else {
            Aladin.trace(2, "Loading RICE FITS image extension (NBLOCK=" + nblock + " BSIZE=" + bsize + ")");
            int posCompress = 0;
            int posZscale = -1;
            int posZzero = -1;
            int posUncompress = -1;
            int tfields = this.headerFits.getIntFromHeader("TFIELDS");
            int pos = 0;
            for (int i = 1; i <= tfields; ++i) {
                String type = this.headerFits.getStringFromHeader("TTYPE" + i);
                if (type.equals("COMPRESSED_DATA")) {
                    posCompress = pos;
                } else if (type.equals("ZSCALE")) {
                    posZscale = pos;
                } else if (type.equals("ZZERO")) {
                    posZzero = pos;
                } else if (type.equals("UNCOMPRESSED_DATA")) {
                    posUncompress = pos;
                }
                String form = this.headerFits.getStringFromHeader("TFORM" + i);
                pos += Util.binSizeOf(form);
            }
            Aladin.trace(2, "Loading RICE FITS image extension (TFIELDS=" + tfields + " NBLOCK=" + nblock + " BSIZE=" + bsize + ")");
            this.pixelsOrigin = new byte[taille];
            byte[] table = new byte[nnaxis1 * nnaxis2];
            byte[] heap = new byte[pcount];
            try {
                dis.readFully(table);
                dis.skip(theap - nnaxis1 * nnaxis2);
                dis.readFully(heap);
                int offset = 0;
                for (int row = 0; row < nnaxis2; ++row) {
                    int offsetRec = row * nnaxis1;
                    int size = PlanImageRice.getInt(table, offsetRec + posCompress);
                    int pos2 = PlanImageRice.getInt(table, offsetRec + posCompress + 4);
                    double bzero = posZzero < 0 ? 0.0 : PlanImageRice.getDouble(table, offsetRec + posZzero);
                    double bscale = posZscale < 0 ? 1.0 : PlanImageRice.getDouble(table, offsetRec + posZscale);
                    System.out.println("row=" + row + " size=" + size + " pos=" + pos2 + " bscale=" + bscale + " bzero=" + bzero);
                    if (size == 0 && posUncompress >= 0) {
                        size = PlanImageRice.getInt(table, offsetRec + posUncompress);
                        pos2 = PlanImageRice.getInt(table, offsetRec + posUncompress);
                        PlanImageRice.direct(heap, pos2, this.pixelsOrigin, offset, tile, this.bitpix, bzero, bscale);
                    } else {
                        PlanImageRice.decomp(heap, pos2, this.pixelsOrigin, offset, tile, bsize, nblock, this.bitpix, bzero, bscale);
                    }
                    offset += tile;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.findMinMax(this.pixelsOrigin, this.bitpix, this.width, this.height, this.dataMinFits, this.dataMaxFits, cut, 0, 0, 0, 0);
            this.to8bits(this.getBufPixels8(), 0, this.pixelsOrigin, this.width * this.height, this.bitpix, this.pixelMin, this.pixelMax, true);
        }
        if (this.flagSkip) {
            return true;
        }
        this.headerFits.setKeyword("BITPIX", this.bitpix + "");
        this.headerFits.setKeyword("NAXIS1", this.width + "");
        this.headerFits.setKeyword("NAXIS2", this.height + "");
        this.headerFits.setKeyword("NAXIS", "2");
        Date d1 = new Date();
        int temps = (int)(d1.getTime() - d.getTime());
        d = d1;
        Aladin.trace(3, " => Reading, uncompressing " + (cut ? "and autocutting " : "") + "in " + Util.round((double)temps / 1000.0, 3) + " s => " + Util.round((double)this.offsetLoad / (double)temps / 1048.576, 2) + " Mbyte/s");
        PlanImageRice.invImageLine(this.width, this.height, this.getBufPixels8());
        this.creatDefaultCM();
        this.setPourcent(99.0);
        return true;
    }

    public static void direct(byte[] buf, int pos, byte[] array, int offset, int nx, int bitpix, double bzero, double bscale) throws Exception {
        int size = Math.abs(bitpix) / 8;
        for (int i = 0; i < nx; i += size) {
            double val = PlanImageRice.getPixVal1(buf, bitpix, pos + i);
            PlanImageRice.setPixVal(array, bitpix, offset + i, val * bscale + bzero);
        }
    }

    public static void decomp(byte[] buf, int pos, byte[] array, int offset, int nx, int bsize, int nblock, int bitpix, double bzero, double bscale) throws Exception {
        int i;
        int fsmax;
        int fsbits;
        switch (bsize) {
            case 1: {
                fsbits = 3;
                fsmax = 6;
                break;
            }
            case 2: {
                fsbits = 4;
                fsmax = 14;
                break;
            }
            case 4: {
                fsbits = 5;
                fsmax = 25;
                break;
            }
            default: {
                throw new Exception("Rice.decomp error: bitpix must be 8, 16 or 32");
            }
        }
        int bbits = 1 << fsbits;
        int lastpix = 0;
        for (i = 0; i < bsize; ++i) {
            int bytevalue = 0xFF & buf[pos++];
            lastpix = lastpix << 8 | bytevalue;
        }
        int b = 0xFF & buf[pos++];
        int nbits = 8;
        i = 0;
        while (i < nx) {
            int diff;
            nbits -= fsbits;
            while (nbits < 0) {
                b = b << 8 | 0xFF & buf[pos++];
                nbits += 8;
            }
            int fs = (b >>> nbits) - 1;
            b &= (1 << nbits) - 1;
            int imax = i + nblock;
            if (imax > nx) {
                imax = nx;
            }
            if (fs < 0) {
                while (i < imax) {
                    PlanImageRice.setPixVal(array, bitpix, i + offset, (double)lastpix * bscale + bzero);
                    ++i;
                }
                continue;
            }
            if (fs == fsmax) {
                while (i < imax) {
                    int k = bbits - nbits;
                    diff = b << k;
                    k -= 8;
                    while (k >= 0) {
                        b = 0xFF & buf[pos++];
                        diff |= b << k;
                        k -= 8;
                    }
                    if (nbits > 0) {
                        b = 0xFF & buf[pos++];
                        diff |= b >>> -k;
                        b &= (1 << nbits) - 1;
                    } else {
                        b = 0;
                    }
                    diff = (diff & 1) == 0 ? (diff >>>= 1) : ~(diff >>> 1);
                    lastpix = diff + lastpix;
                    PlanImageRice.setPixVal(array, bitpix, i + offset, (double)lastpix * bscale + bzero);
                    ++i;
                }
                continue;
            }
            while (i < imax) {
                while (b == 0) {
                    nbits += 8;
                    b = 0xFF & buf[pos++];
                }
                int nzero = nbits - nonzero_count[b];
                b ^= 1 << (nbits -= nzero + 1);
                nbits -= fs;
                while (nbits < 0) {
                    b = b << 8 | 0xFF & buf[pos++];
                    nbits += 8;
                }
                diff = nzero << fs | b >>> nbits;
                b &= (1 << nbits) - 1;
                diff = (diff & 1) == 0 ? (diff >>>= 1) : ~(diff >>> 1);
                lastpix = diff + lastpix;
                PlanImageRice.setPixVal(array, bitpix, i + offset, (double)lastpix * bscale + bzero);
                ++i;
            }
        }
    }
}

