/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.PlanImage;
import cds.aladin.Projection;
import cds.aladin.RectangleD;
import cds.aladin.ViewSimple;
import cds.tools.Util;

public class PlanImageMosaic
extends PlanImage {
    protected PlanImage Ref;
    private PlanImage[] tmpP;
    private boolean flagCreat;
    private boolean firstMosaic;
    private ViewSimple v;

    protected PlanImageMosaic(Aladin aladin, PlanImage p) {
        super(aladin, p);
        this.type = 6;
    }

    protected PlanImageMosaic(Aladin aladin) {
        super(aladin);
        this.type = 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PlanImageMosaic(Aladin aladin, PlanImage[] p, String label, ViewSimple v) {
        super(aladin);
        this.type = 6;
        this.Ref = p[0];
        this.firstMosaic = true;
        this.v = v;
        Aladin.trace(3, "Mosaic ref plane: " + this.Ref.label);
        this.init(label, this.Ref);
        this.tmpP = new PlanImage[p.length - 1];
        System.arraycopy(p, 1, this.tmpP, 0, p.length - 1);
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < p.length; ++i) {
            s.append((i > 0 ? "/" : "") + p[i]);
        }
        this.sendLog("Mosaic", "[" + s + "]");
        this.flagCreat = true;
        PlanImageMosaic planImageMosaic = this;
        synchronized (planImageMosaic) {
            this.runme = new Thread((Runnable)this, "AladinBuildMosaic");
            Util.decreasePriority(Thread.currentThread(), this.runme);
            this.runme.start();
        }
    }

    protected void init(String label, PlanImage p) {
        p.copy(this);
        this.flagOk = false;
        this.isOldPlan = false;
        this.askActive = true;
        this.type = 6;
        this.headerFits = null;
        this.fmt = 6;
        this.res = 0;
        this.orig = 3;
        this.status = "Mosaic in progress...";
        this.progress = "computing...";
        if (label == null) {
            label = "Msc img";
        }
        this.setLabel(label);
        this.copyright = "Mosaic";
        this.param = "";
        this.bitpix = 8;
        this.npix = 1;
        try {
            RectangleD box = this.getPixelBox(new PlanImage[]{p});
            Aladin.trace(3, "Mosaic bounding box pos=" + box.x + "," + box.y + " size=" + box.width + "x" + box.height);
            this.projd = this.shiftProjection(box);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean waitForPlan() {
        try {
            this.addFrame(this.tmpP);
            this.calculPixelsZoom();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public void run() {
        if (this.flagCreat) {
            this.flagCreat = false;
            Aladin.trace(1, "Creating the " + Tp[this.type] + " plane " + this.label);
            if (this.v == null) {
                this.planReady(this.waitForPlan());
            } else {
                this.flagProcessing = true;
                this.v.pref = this;
                this.aladin.view.setSelect(this.v);
                this.waitForPlan();
                this.v.repaint();
            }
        } else {
            Aladin.trace(1, "Adding planes to " + this.label);
            try {
                this.addFrame(this.tmpP);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            this.flagOk = true;
        }
    }

    protected synchronized void addPlan(PlanImage p) {
        this.flagOk = false;
        this.flagProcessing = true;
        this.tmpP = new PlanImage[1];
        this.tmpP[0] = p;
        this.aladin.calque.select.repaint();
        this.runme = new Thread((Runnable)this, "AladinMosaicAdd");
        Util.decreasePriority(Thread.currentThread(), this.runme);
        this.runme.start();
    }

    private RectangleD getPixelBox(PlanImage[] p) throws Exception {
        RectangleD box = new RectangleD(0.0, 0.0, this.width - 1, this.height - 1);
        Coord c = new Coord();
        for (int i = 0; i < p.length; ++i) {
            for (int j = 0; j < 4; ++j) {
                switch (j) {
                    case 0: {
                        c.x = 0.0;
                        c.y = 0.0;
                        break;
                    }
                    case 1: {
                        c.x = 0.0;
                        c.y = p[i].height - 1;
                        break;
                    }
                    case 2: {
                        c.x = p[i].width - 1;
                        c.y = p[i].height - 1;
                        break;
                    }
                    case 3: {
                        c.x = p[i].width - 1;
                        c.y = 0.0;
                    }
                }
                p[i].projd.getCoord(c);
                if (Double.isNaN(c.al)) continue;
                this.projd.getXY(c);
                if (Double.isNaN(c.x)) continue;
                if (c.x < box.x) {
                    box.x = c.x;
                }
                if (c.x > box.width) {
                    box.width = c.x;
                }
                if (c.y < box.y) {
                    box.y = c.y;
                }
                if (!(c.y > box.height)) continue;
                box.height = c.y;
            }
        }
        box.width -= box.x;
        box.height -= box.y;
        return box;
    }

    private Projection shiftProjection(RectangleD box) {
        Projection p = this.projd.copy();
        p.crop((int)box.x, (int)box.y, (int)box.width, (int)box.height);
        return p;
    }

    private void setFrom(PlanImage[] p) {
        String s = "";
        for (int i = 0; i < p.length; ++i) {
            s = s + " [" + p[i] + "]";
        }
        this.copyright = this.firstMosaic ? "Mosaic from [" + this.Ref + "]" + s : this.copyright + s;
    }

    protected synchronized void addFrame(PlanImage[] p) throws Exception {
        this.noOriginalPixels();
        Coord coo = new Coord();
        this.setFrom(p);
        Aladin.trace(3, "Mosaicing " + this.param + "...");
        RectangleD box = this.getPixelBox(p);
        Aladin.trace(3, "Mosaic bounding box pos=" + box.x + "," + box.y + " size=" + box.width + "x" + box.height);
        int w = (int)(box.width + 1.0);
        int h = (int)(box.height + 1.0);
        byte[] newPixel = new byte[w * h];
        Projection newProj = this.shiftProjection(box);
        this.setHasSpecificCalib();
        for (int i = 0; i < newPixel.length; ++i) {
            coo.x = i % w;
            coo.y = i / w;
            newProj.getCoord(coo);
            if (Double.isNaN(coo.al)) continue;
            int c = 0;
            int j = 0;
            for (int n = -1; n < p.length; ++n) {
                PlanImageMosaic p2 = n == -1 ? this : p[n];
                p2.projd.getXY(coo);
                if (!Double.isNaN(coo.x)) {
                    int x = (int)Math.round(coo.x);
                    int y = (int)Math.round(coo.y);
                    if (x >= 0 && x < p2.width && y >= 0 && y < p2.height) {
                        if (!this.firstMosaic && p2 == this && p2.getBufPixels8()[y * p2.width + x] == 0) continue;
                        c += 0xFF & p2.getBufPixels8()[y * p2.width + x];
                        ++j;
                    }
                }
                if (i * p.length % 10000 != 0) continue;
                this.setPourcent(i * 100 / newPixel.length);
            }
            if (j == 0) continue;
            newPixel[i] = (byte)(c / j & 0xFF);
        }
        this.setBufPixels8(newPixel);
        this.naxis1 = this.width = w;
        this.naxis2 = this.height = h;
        this.projd = newProj;
        this.setPourcent(-1.0);
        this.flagProcessing = false;
        this.flagOk = true;
        if (this.firstMosaic) {
            this.cm = this.Ref.cm;
        }
        this.firstMosaic = false;
        Aladin.trace(3, "Mosaic achieved...");
        this.calculPixelsZoom();
        this.changeImgID();
        this.aladin.view.repaintAll();
        this.aladin.calque.zoom.zoomView.repaint();
    }
}

