/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameHeaderFits;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanImage;
import cds.aladin.ResourceNode;
import cds.fits.HeaderFits;
import cds.fits.UtilFits;
import cds.tools.Util;
import java.util.Date;

public class PlanImageFitsCmp
extends PlanImage {
    protected PlanImageFitsCmp(Aladin aladin, String file, MyInputStream inImg, String label, String from, Obj o, ResourceNode imgNode, boolean skip, boolean doClose, Plan forPourcent) {
        super(aladin, file, inImg, label, from, o, imgNode, skip, doClose, forPourcent);
    }

    @Override
    protected boolean cacheImageFits(MyInputStream dis) throws Exception {
        if (this.headerFits == null) {
            this.headerFits = new FrameHeaderFits((Plan)this, dis);
        }
        this.setPourcent(0.0);
        Date d = new Date();
        HeaderFits outHeader = new HeaderFits();
        try {
            this.pixelsOrigin = UtilFits.uncompress(outHeader, this.headerFits.getHeaderFits(), dis, this.flagSkip);
        }
        catch (Exception e) {
            String m = e.getMessage();
            if (m == null) {
                m = "FITS compressed image read error";
            }
            this.error = Aladin.error = m;
            Aladin.error(this.error, 1);
            return false;
        }
        if (this.flagSkip) {
            return true;
        }
        this.bitpix = outHeader.getIntFromHeader("BITPIX");
        this.width = this.naxis1 = outHeader.getIntFromHeader("NAXIS1");
        this.height = this.naxis2 = outHeader.getIntFromHeader("NAXIS2");
        this.npix = Math.abs(this.bitpix) / 8;
        boolean cut = this.aladin.configuration.getCMCut();
        this.setBufPixels8(new byte[this.width * this.height]);
        this.findMinMax(this.pixelsOrigin, this.bitpix, this.width, this.height, this.dataMinFits, this.dataMaxFits, cut, 0, 0, 0, 0);
        this.to8bits(this.getBufPixels8(), 0, this.pixelsOrigin, this.width * this.height, this.bitpix, this.pixelMin, this.pixelMax, true);
        PlanImageFitsCmp.invImageLine(this.width, this.height, this.getBufPixels8());
        this.headerFits.setKeyword("BITPIX", this.bitpix + "");
        this.headerFits.setKeyword("NAXIS1", this.width + "");
        this.headerFits.setKeyword("NAXIS2", this.height + "");
        this.headerFits.setKeyword("NAXIS", "2");
        Date d1 = new Date();
        int temps = (int)(d1.getTime() - d.getTime());
        d = d1;
        Aladin.trace(3, " => Reading, uncompressing " + (cut ? "and autocutting " : "") + "in " + Util.round((double)temps / 1000.0, 3) + " s => " + Util.round((double)this.offsetLoad / (double)temps / 1048.576, 2) + " Mbyte/s");
        this.creatDefaultCM();
        this.setPourcent(99.0);
        return true;
    }
}

