/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.FrameHeaderFits;
import cds.aladin.MyInputStream;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanImageBlink;
import cds.aladin.ResourceNode;
import cds.tools.Util;
import java.io.RandomAccessFile;
import java.util.Date;

public class PlanImageCube
extends PlanImageBlink {
    private double crval3;
    private double crpix3;
    private double cdelt3;
    protected boolean fromCanal;
    private int precision = -1;

    protected PlanImageCube(Aladin aladin, String file, MyInputStream in, String label, String from, Obj o, ResourceNode imgNode, boolean skip, boolean doClose, Plan forPourcent) {
        super(aladin, file, in, label, from, o, imgNode, skip, doClose, forPourcent);
        this.type = 4;
        this.initDelay = 400;
    }

    protected String getCanalValue(int n) {
        if (this.precision == -1) {
            double f = Math.abs(this.cdelt3);
            this.precision = f < 0.001 ? 3 : (f < 0.01 ? 2 : (f < 100.0 ? 1 : 0));
        }
        return "" + (double)((int)Math.round(1000.0 * (((double)(n + 1) - this.crpix3) * this.cdelt3 + this.crval3))) / 1000.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean cacheImageFits(MyInputStream dis) throws Exception {
        int n;
        Aladin.trace(2, "Loading FITS " + Tp[this.type]);
        if (this.headerFits == null) {
            this.headerFits = new FrameHeaderFits((Plan)this, dis);
        }
        this.bitpix = this.headerFits.getIntFromHeader("BITPIX");
        int naxis = this.headerFits.getIntFromHeader("NAXIS");
        if (naxis <= 1 && this.headerFits.getStringFromHeader("EXTEND") != null) {
            this.error = "_HEAD_XFITS_";
            if (naxis == 1) {
                try {
                    this.naxis1 = this.headerFits.getIntFromHeader("NAXIS1");
                    dis.skip(this.naxis1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
        this.naxis1 = this.width = this.headerFits.getIntFromHeader("NAXIS1");
        this.naxis2 = this.height = this.headerFits.getIntFromHeader("NAXIS2");
        this.depth = this.headerFits.getIntFromHeader("NAXIS3");
        this.setPixMode(2);
        this.npix = n = Math.abs(this.bitpix) / 8;
        long taille = (long)this.width * (long)this.height * (long)this.depth * (long)n;
        this.setPourcent(0.0);
        Aladin.trace(3, " => NAXIS1=" + this.width + " NAXIS2=" + this.height + " NAXIS3=" + this.depth + " BITPIX=" + this.bitpix + " => size=" + taille);
        this.loadFitsHeaderParam(this.headerFits);
        try {
            this.crpix3 = this.headerFits.getDoubleFromHeader("CRPIX3");
            this.crval3 = this.headerFits.getDoubleFromHeader("CRVAL3");
            this.cdelt3 = this.headerFits.getDoubleFromHeader("CDELT3");
            this.fromCanal = true;
        }
        catch (Exception e) {
            this.fromCanal = false;
        }
        if (this.flagSkip) {
            dis.skip(taille);
        } else {
            Date d = new Date();
            boolean dejaCharge = false;
            int frameToBeLoad = this.depth;
            double requiredMo = (double)this.width * (double)this.height * (double)this.depth * (double)(this.npix + 1) / 1048576.0;
            boolean loadInRam = this.aladin.getMem() - requiredMo > (double)Aladin.MARGERAM;
            boolean partialInRam = false;
            Aladin.trace(4, "PlanImageCube.loadImageFits() ask for " + requiredMo + "MB " + (loadInRam ? "try in Ram" : "=> not enough space in RAM"));
            if (!loadInRam) {
                this.aladin.freeSomeRam((long)(requiredMo * 1024.0 * 1024.0), this);
                loadInRam = this.aladin.getMem() - requiredMo / 10.0 > (double)Aladin.MARGERAM;
                double t1 = (double)this.width * (double)this.height * (double)this.npix;
                double free = (this.aladin.getMem() - (double)Aladin.MARGERAM) * 1024.0 * 1024.0 - (double)(this.width * this.height * this.depth);
                frameToBeLoad = (int)(free / t1);
                Aladin.trace(4, "PlanImageCube.loadImageFits() [2nd test]  ask for " + requiredMo + "MB " + (loadInRam ? "try in Ram " + frameToBeLoad + " frames" : "not in RAM") + " freeRAM=" + free / 1048576.0 + "MB, one frame=" + t1 / 1048576.0 + "MB");
            }
            this.cacheFromOriginalFile = this.setCacheFromFile(dis);
            RandomAccessFile f = null;
            int tailleImg = PlanImageCube.floor(taille / (long)this.depth);
            this.pixelsOrigin = new byte[tailleImg];
            int m = this.depth / 2 + 1;
            byte[] buffer = null;
            long pos2emeLecture = 0L;
            try {
                if (!Aladin.STANDALONE) {
                    dejaCharge = true;
                    int maxM = PlanImageCube.floor(taille / 4L / (long)tailleImg);
                    if (m > maxM) {
                        m = maxM;
                    }
                    buffer = new byte[PlanImageCube.round(tailleImg * m)];
                    dis.readFully(buffer);
                    System.arraycopy(buffer, (m - 1) * tailleImg, this.pixelsOrigin, 0, tailleImg);
                } else {
                    dejaCharge = false;
                    buffer = this.pixelsOrigin;
                    if (!this.cacheFromOriginalFile) {
                        for (int i = 0; i < m; ++i) {
                            dis.readFully(buffer);
                            if (i == 0) {
                                f = this.beginInCache(buffer);
                                continue;
                            }
                            f.write(buffer);
                        }
                    } else {
                        pos2emeLecture = dis.getPos();
                        dis.skip((long)(m - 1) * (long)tailleImg);
                        dis.readFully(buffer);
                    }
                }
                Aladin.trace(3, " => Cube autocut uses the frame " + m);
                boolean cut = this.aladin.configuration.getCMCut();
                this.findMinMax(this.pixelsOrigin, this.bitpix, this.width, this.height, this.dataMinFits, this.dataMaxFits, cut, 0, 0, 0, 0);
                double amem = 0.0;
                double adelta = 0.0;
                for (int i = 0; i < this.depth; ++i) {
                    if (Aladin.levelTrace == 4) {
                        double mem = this.aladin.getMem();
                        double delta = amem - mem;
                        if (Math.abs(adelta - delta) > 0.2 || mem < (double)(Aladin.MARGERAM - 1)) {
                            Aladin.trace(4, "PlanImageCube.cacheImageFits(): frame " + i + " freeRam=" + mem + "MB delta=" + delta + "MB");
                        }
                        amem = mem;
                        adelta = delta;
                    }
                    try {
                        this.setBufPixels8(new byte[this.width * this.height]);
                    }
                    catch (OutOfMemoryError e) {
                        e.printStackTrace();
                        Aladin.trace(4, "PlanImageCube.loadImageFits(): out of memory1 freeRam=" + this.aladin.getMem() + "MB => inRam=false...");
                        loadInRam = false;
                        this.freeRam();
                        this.setBufPixels8(new byte[this.width * this.height]);
                    }
                    if (i < m) {
                        if (dejaCharge) {
                            System.arraycopy(buffer, i * tailleImg, this.pixelsOrigin, 0, tailleImg);
                        } else {
                            if (i == 0) {
                                if (pos2emeLecture != 0L) {
                                    f = new RandomAccessFile(this.cacheID, "r");
                                }
                                f.seek(pos2emeLecture);
                            }
                            f.readFully(this.pixelsOrigin);
                        }
                    } else {
                        dis.readFully(this.pixelsOrigin);
                        if (f != null && !this.cacheFromOriginalFile) {
                            f.write(this.pixelsOrigin);
                        }
                    }
                    this.to8bits(this.getBufPixels8(), 0, this.pixelsOrigin, this.pixelsOrigin.length / this.npix, this.bitpix, this.pixelMin, this.pixelMax, true);
                    PlanImageCube.invImageLine(this.width, this.height, this.getBufPixels8());
                    String s = this.fromCanal ? this.getCanalValue(i) : this.label;
                    try {
                        if (loadInRam && frameToBeLoad < 0) {
                            Aladin.trace(4, "PlanImageCube.loadImageFits(): low memory2 (frame=" + i + ") => other frames not in RAM...");
                            partialInRam = true;
                            loadInRam = false;
                        }
                        this.addFrame(s, this.getBufPixels8(), loadInRam ? this.pixelsOrigin : null, this.cacheFromOriginalFile, this.cacheID, this.cacheOffset);
                        if (loadInRam) {
                            this.pixelsOrigin = new byte[tailleImg];
                            --frameToBeLoad;
                        }
                    }
                    catch (OutOfMemoryError e) {
                        e.printStackTrace();
                        Aladin.trace(4, "PlanImageCube.loadImageFits(): out of memory freeRam=" + this.aladin.getMem() + "MB => inRam=false...");
                        loadInRam = false;
                        this.freeRam();
                        this.addFrame(s, this.getBufPixels8(), null, this.cacheFromOriginalFile, this.cacheID, this.cacheOffset);
                    }
                    this.cacheOffset += (long)this.pixelsOrigin.length;
                    this.setPourcent(99.0 * (double)i / (double)this.depth);
                    if (i != 0) continue;
                    this.calculPixelsZoom();
                }
            }
            finally {
                if (f != null) {
                    f.close();
                }
            }
            buffer = null;
            this.noOriginalPixels();
            Date d1 = new Date();
            int temps = (int)(d1.getTime() - d.getTime());
            d = d1;
            Aladin.trace(3, " => Reading " + (!dejaCharge ? "(2 pass) " : "") + "and analyzing " + this.getDepth() + " frames in " + Util.round((double)temps / 0.001, 3) + " s => " + (temps != 0 ? Util.round((double)(taille / (long)temps / 1024L) * 1.024, 2) + " Mbyte/s" : "--") + (loadInRam ? " (fully in RAM)" : (partialInRam ? " (partially in RAM)" : "")));
        }
        if (naxis > 3) {
            try {
                long offset = n * this.width * this.height;
                for (int i = 3; i < naxis; ++i) {
                    offset *= (long)this.headerFits.getIntFromHeader("NAXIS" + (i + 1));
                }
                dis.skip(offset -= (long)(n * this.width * this.height));
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.flagSkip) {
            return true;
        }
        this.creatDefaultCM();
        this.setPourcent(-1.0);
        return true;
    }
}

