/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Action;
import cds.aladin.Aladin;
import cds.aladin.FilterProperties;
import cds.aladin.Mesure;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.PlanCatalog;
import cds.aladin.Source;
import cds.aladin.UCDFilter;
import cds.tools.Util;
import java.awt.Color;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;

public final class PlanFilter
extends Plan {
    private static final int INCREMENT = 4;
    protected static int LIMIT = 4;
    static final String[] PREDEFFILTERS = new String[]{"# Mag.Circle\n# This filter draws for each source a circle \n# whose radius is proportional to the magnitude\n{draw circle(-$[phot.mag*])}", "# Ellipses\n# This example shows how to draw \n# an ellipse associated with a source\n\n# The first action draws the source itself,\n# the second action draws the ellipse ; \n# parameters are semi-major axis, semi-minor axis, and position angle\n{\ndraw\ndraw ellipse(0.5*$[phys.angSize.smajAxis],0.5*$[phys.angSize.sminAxis],$[pos.posAng])\n}", "# Mag.Cut\n# Only sources with a magnitude \n# brighter than 16 are displayed\n$[phot.mag*]<16 {draw}\n", "# Disp.Text\n# This filter draws for each source the content\n# of the column tagged by the UCD \"src.class\"\n{\ndraw $[src.class]\n}", "# Param.Colors\n# In this filter, the green and blue components\n# of the color of each source are defined\n# according to the value of the magnitude\n{\ndraw rgb(255,-$[phot.mag*],$[phot.mag*]) square\n}", "# Obj.Type\n# We draw a different symbol according to\n# the object type (value of the column with UCD \"src.class\")\n$[src.class]=\"Star\" {draw red square}\n$[src.class]=\"Radio\" {draw blue rhomb}\n$[src.class]=\"Galaxy\" || $[src.class]=\"Seyfert\" {draw green plus}\n# etc ...\n", "# Prop.motions\n# Draws an arrow representing\n# the proper motion of the source\n\n# Remark : You are suggested to modify the factor \n# if the arrows are too small or too long\n{draw pm(5*$[pos.pm;pos.eq.ra],5*$[pos.pm;pos.eq.dec])}\n", "# Color.Index\n# This filters aims to visualize the color of stars\n# according to their color index B-V.\n# The optional parameters -0.3 and 1 mean that :\n# - any source with a color index lesser than -0.3\n#   is displayed in blue\n# - any source with a color index greater than 1\n#    is displayed in red\n{draw rainbow($[phot.color;em.opt.B;em.opt.V],-0.3,1)}", "# Spec.Types\n# This filter assigns colors related\n# to the spectral type of sources.\n# The association spectral type --> color\n# is the following:\n# O : violet\n# B : blue/violet\n# A : blue\n# F : green/yellow\n# G : yellow\n# K : orange\n# M R N S C : red\n# T L : brown\n# W : violet\n# D : gray\n\n$[src.spType*] = \"*B*\" {draw #8a2be2}\n$[src.spType*] = \"*A*\" {draw blue}\n$[src.spType*] = \"*F*\" {draw #adff2f}\n$[src.spType*] = \"*G*\" {draw yellow}\n$[src.spType*] = \"*K*\" {draw orange}\n$[src.spType*] = \"*M*\" || \n$[src.spType*] = \"*R*\" || \n$[src.spType*] = \"*N*\" || \n$[src.spType*] = \"*S*\" || \n$[src.spType*] = \"*C*\" {draw red}\n$[src.spType*] = \"*T*\" || \n$[src.spType*] = \"*L*\" {draw #a52a2a}\n$[src.spType*] = \"*O*\" {draw #ee82ee}\n$[src.spType*] = \"*W*\" {draw #ee82ee}\n$[src.spType*] = \"*D*\" {draw gray}\n", "# Unit.Conversion\n# You can specify a unit when writing a constraint\n# Unit conversion is automatically computed (when possible)\n$[phot.flux;em.X-ray]>10^-8 erg/m^2/s {\ndraw circle($[phot.flux;em.X-ray])\n}"};
    static final String[] PREDEFLABELS = new String[]{"Magnitude circle", "Ellipses", "Magnitude cut", "Display text", "Parameterized colors", "Select object type", "Proper motions", "Color index", "Spectral types", "Unit conversion"};
    static String[] saveFilters = new String[LIMIT];
    static String[] saveLabels = new String[LIMIT];
    String script;
    static int num = -1;
    static PlanFilter[] allFilters = new PlanFilter[0];
    int numero;
    private UCDFilter filter;
    private Vector<Plan> memPlan;
    private Vector<Plan> omemPlan;
    private boolean mustUpdate = true;
    boolean mustRepaint = true;
    boolean initPlanMem = true;
    protected Plan plan;
    private long lastFilterLock = -1L;
    private boolean relaunchDone = false;

    protected PlanFilter(Aladin aladin, String label, String script) {
        this(aladin, label, script, null);
    }

    protected PlanFilter(Aladin aladin, String label, String script, Plan plan) {
        this.plan = plan;
        this.aladin = aladin;
        this.flagOk = true;
        this.type = 12;
        this.c = Color.black;
        this.askActive = true;
        this.selected = true;
        this.numero = ++num;
        this.memPlan = new Vector();
        this.omemPlan = new Vector();
        if (num >= LIMIT) {
            this.realloc();
        }
        if (script != null) {
            this.createFilter(script, label);
        } else {
            this.createFilter("", "Filter" + num);
        }
        this.script = this.filter.definition;
        this.label = this.filter.name;
        String orgName = this.filter.name;
        this.uniqueName(orgName);
        this.saveDef();
        if (script != null) {
            this.doLog();
        }
    }

    private void uniqueName(String orgName) {
        int compteur = 1;
        String name = orgName;
        while (PlanFilter.getFilterByName(name, this.aladin) != null) {
            name = orgName + compteur++;
        }
        this.label = name;
    }

    private void saveDef() {
        PlanFilter.saveFilters[this.numero] = this.script;
        PlanFilter.saveLabels[this.numero] = this.label;
    }

    protected void updateDefinition(String script, String name, FilterProperties fp) {
        String oldDef = this.script;
        if (name != null) {
            name = UCDFilter.skipSpaces(name);
        }
        this.script = script;
        this.createFilter(script, name);
        this.script = this.filter.definition;
        String save = this.label = this.filter.name.length() == 0 ? this.label : this.filter.name;
        this.label = "";
        this.uniqueName(save);
        this.saveDef();
        this.doLog();
        if (!UCDFilter.skipSpaces(this.script).equals(UCDFilter.skipSpaces(oldDef))) {
            this.setPlanMemory();
            this.updateInfluence();
            this.mustUpdate = true;
        }
        if (!this.isValid()) {
            if (fp == null || !fp.isShowing()) {
                Aladin.error(Aladin.chaine.getString("BADFILTER"), 1);
            }
            this.setActivated(false);
            this.aladin.calque.select.repaint();
            this.aladin.view.setMesure();
            return;
        }
        if (this.isOn()) {
            this.applyFilter();
        }
    }

    private void doLog() {
        this.sendLog("Filter", "Label: " + this.label);
    }

    private void createFilter(String def, String name) {
        this.filter = name == null ? new UCDFilter(def, this.aladin, this) : new UCDFilter(name, def, this.aladin, this);
        this.filter.setNumero(this.numero);
        this.error = !this.isValid() ? "ERROR" : null;
    }

    protected void updateState() {
        if (this.isOn()) {
            if (!this.isValid()) {
                Aladin.error(Aladin.chaine.getString("BADFILTER"), 1);
                this.setActivated(false);
                this.aladin.calque.select.repaint();
                this.aladin.view.setMesure();
                return;
            }
            this.mustRepaint = true;
            this.applyFilter();
        } else {
            this.aladin.view.setMesure();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyFilter() {
        if (this.mustUpdate) {
            this.flagOk = false;
        }
        if (this.initPlanMem) {
            this.setPlanMemory();
            this.updateInfluence();
            this.initPlanMem = false;
        }
        this.stopFilterThread();
        PlanFilter planFilter = this;
        synchronized (planFilter) {
            this.runme = new Thread((Runnable)this, "AladinFilterApply");
            Util.decreasePriority(Thread.currentThread(), this.runme);
            this.runme.start();
        }
    }

    private synchronized void stopFilterThread() {
        block4: {
            if (this.runme == null) {
                return;
            }
            Thread oldThread = this.runme;
            this.runme = null;
            try {
                oldThread.join();
            }
            catch (InterruptedException ie) {
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block4;
                e.printStackTrace();
            }
        }
    }

    @Override
    protected boolean isSync() {
        if (this.isSync1()) {
            this.lastFilterLock = -1L;
            return true;
        }
        long time = System.currentTimeMillis();
        if (this.lastFilterLock == -1L) {
            this.lastFilterLock = time;
        } else if (time - this.lastFilterLock > 4000L) {
            if (this.relaunchDone) {
                if (Aladin.levelTrace >= 3) {
                    System.err.println("PlanFilter.isSync()=false, last manual relaunch did not work => assume isSync()=true");
                }
                this.lastFilterLock = -1L;
                this.relaunchDone = false;
                return true;
            }
            if (Aladin.levelTrace >= 3) {
                System.err.println("PlanFilter.isSync()=false but delay exceed 4s => relaunch filter manually...");
            }
            this.relaunchDone = true;
            this.doApplyFilter();
            this.lastFilterLock = time;
        }
        return false;
    }

    private boolean isSync1() {
        return this.flagOk && (this.error != null || !this.mustUpdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doApplyFilter(boolean inThread) {
        if (this.mustUpdate) {
            Aladin.trace(1, "Updating filter results");
            if (!this.isValid()) {
                this.setActivated(false);
                this.flagOk = true;
                return;
            }
            this.flagOk = false;
            this.aladin.calque.repaintAll();
            Source[] sources = this.getSources(this.aladin, inThread);
            if (inThread && this.runme == null) {
                return;
            }
            this.resetFlags();
            this.filter.getFilteredSources(sources, inThread);
            if (inThread && this.runme == null) {
                return;
            }
            this.flagOk = true;
            this.setPourcent(-1.0);
        }
        if (this.mustRepaint) {
            Mesure mesure = this.aladin.mesure;
            synchronized (mesure) {
                this.aladin.view.setMesure();
            }
        }
        this.mustUpdate = false;
    }

    protected void doApplyFilter() {
        this.doApplyFilter(false);
    }

    protected Source[] getSources(Aladin a, boolean inThread) {
        Plan p = null;
        Vector<Source> vec = new Vector<Source>();
        Plan[] plans = this.getConcernedPlans();
        int k = 1;
        block0: for (int i = plans.length - 1; i >= 0; --i) {
            p = plans[i];
            Iterator<Obj> it = p.iterator();
            if (it == null) continue;
            while (it.hasNext()) {
                Obj s = it.next();
                if (inThread && k % 1000 == 0 && this.runme == null) continue block0;
                if (!(s instanceof Source) || s == null) continue;
                vec.addElement((Source)s);
                ++k;
            }
        }
        Object[] sources = new Source[vec.size()];
        vec.copyInto(sources);
        vec = null;
        return sources;
    }

    protected Source[] getSources(Aladin a) {
        return this.getSources(a, false);
    }

    private Plan getFolder() {
        Plan[] allPlan = this.aladin.calque.getPlans();
        for (int i = allPlan.length - 1; i >= 0; --i) {
            Plan p = allPlan[i];
            if (p.type != 11) continue;
            Plan[] plansOfFolder = this.aladin.calque.getFolderPlan(p);
            for (int j = 0; j < plansOfFolder.length; ++j) {
                if (plansOfFolder[j] != this) continue;
                return p;
            }
        }
        return null;
    }

    private Vector<Plan> getAllPlansOfFolder(Plan folder) {
        Vector<Plan> vec = new Vector<Plan>(10);
        this.getAllPlansOfFolder(folder, vec);
        return vec;
    }

    private void getAllPlansOfFolder(Plan folder, Vector<Plan> vec) {
        Plan[] plans = this.aladin.calque.getFolderPlan(folder);
        for (int i = 0; i < plans.length; ++i) {
            Plan curPlan = plans[i];
            if (curPlan.type == 11) {
                this.getAllPlansOfFolder(curPlan, vec);
                continue;
            }
            vec.addElement(curPlan);
        }
    }

    private boolean morePlans(Vector oldMem, Vector newMem) {
        if (newMem.size() > oldMem.size()) {
            return true;
        }
        Enumeration e = newMem.elements();
        while (e.hasMoreElements()) {
            if (oldMem.contains(e.nextElement())) continue;
            return true;
        }
        return false;
    }

    private void setPlanMemory() {
        Plan[] plans = this.getConcernedPlans();
        this.omemPlan = this.memPlan;
        this.memPlan = new Vector();
        for (int i = 0; i < plans.length; ++i) {
            this.memPlan.addElement(plans[i]);
        }
    }

    protected void setMustUpdate() {
        this.setPlanMemory();
        this.updateInfluence();
        if (this.morePlans(this.omemPlan, this.memPlan)) {
            this.mustUpdate = true;
            this.filter.resetActions();
        }
    }

    private void updateInfluence() {
        for (int i = this.aladin.calque.plan.length - 1; i >= 0; --i) {
            Plan p = this.aladin.calque.plan[i];
            if (!p.isCatalog()) continue;
            p.influence[this.numero] = this.memPlan.contains(p);
        }
    }

    protected Plan[] getConcernedPlans() {
        if (this.plan != null) {
            return new Plan[]{this.plan};
        }
        int pos = this.getPositionOfPlan(this);
        Vector<Plan> plans = new Vector<Plan>();
        Plan folder = this.getFolder();
        Vector<Plan> plansOfThis = null;
        if (folder != null) {
            plansOfThis = this.getAllPlansOfFolder(this.getFolder());
        }
        for (int i = this.aladin.calque.plan.length - 1; i >= pos; --i) {
            Plan p = this.aladin.calque.plan[i];
            if (!p.isCatalog() || !p.flagOk || !p.active || folder != null && !plansOfThis.contains(p)) continue;
            plans.addElement(p);
        }
        Object[] ret = new Plan[plans.size()];
        plans.copyInto(ret);
        return ret;
    }

    private int getPositionOfPlan(Plan plan) {
        for (int i = this.aladin.calque.plan.length - 1; i >= 0; --i) {
            Plan curPlan = this.aladin.calque.plan[i];
            if (curPlan != plan) continue;
            return i;
        }
        return -1;
    }

    private void resetFlags() {
        Plan p = null;
        for (int i = this.aladin.calque.plan.length - 1; i >= 0; --i) {
            p = this.aladin.calque.plan[i];
            if (!p.isCatalog() || !p.flagOk) continue;
            Iterator<Obj> it = p.iterator();
            while (it.hasNext()) {
                Source s;
                Obj o = it.next();
                if (!(o instanceof Source) || (s = (Source)o) == null) continue;
                if (s.isSelected == null) {
                    s.isSelected = new boolean[LIMIT];
                }
                s.isSelected[this.numero] = false;
            }
        }
    }

    protected void select() {
        this.filter.select(this.getSources(this.aladin));
        this.aladin.view.setMesure();
    }

    protected void export() {
        Source[] selectedSources = this.filter.getFilteredSources(this.getSources(this.aladin));
        PlanCatalog p = this.aladin.calque.newPlanCatalogBySources(new Vector<Source>(Arrays.asList(selectedSources)), "Filter.src", false);
        if (p != null) {
            this.aladin.view.selectAllInPlan(p);
        }
        this.setPourcent(-1.0);
        this.aladin.view.repaintAll();
    }

    protected void positionChange() {
        PlanFilter.updateAllFilters(this.aladin);
        this.setMustUpdate();
        if (this.isOn()) {
            this.applyFilter();
        }
    }

    protected boolean isOn() {
        if (this.plan != null) {
            return true;
        }
        return this.active;
    }

    protected boolean isValid() {
        return !this.filter.badSyntax;
    }

    @Override
    protected void planReady(boolean ready) {
    }

    @Override
    protected boolean waitForPlan() {
        this.doApplyFilter(true);
        return true;
    }

    private void realloc() {
        LIMIT += 4;
        for (int i = this.aladin.calque.plan.length - 1; i >= 0; --i) {
            Plan p = this.aladin.calque.plan[i];
            if (!p.isCatalog()) continue;
            boolean[] tmp2 = new boolean[LIMIT];
            System.arraycopy(p.influence, 0, tmp2, 0, p.influence.length);
            p.influence = tmp2;
            Iterator<Obj> it = p.iterator();
            if (it == null) continue;
            while (it.hasNext()) {
                Obj o = it.next();
                if (!(o instanceof Source)) continue;
                Source s = (Source)o;
                boolean[] tmp = new boolean[LIMIT];
                if (s.isSelected == null) {
                    s.isSelected = new boolean[LIMIT];
                }
                System.arraycopy(s.isSelected, 0, tmp, 0, s.isSelected.length);
                s.isSelected = tmp;
                if (s.actions == null) {
                    s.actions = new Action[LIMIT][];
                }
                Action[][] ac = new Action[LIMIT][];
                for (int k = 0; k < LIMIT - 4; ++k) {
                    ac[k] = s.actions[k];
                }
                s.actions = ac;
                if (s.values == null) {
                    s.values = new double[LIMIT][][];
                }
                double[][][] val = new double[LIMIT][][];
                for (int k = 0; k < LIMIT - 4; ++k) {
                    val[k] = s.values[k];
                }
                s.values = val;
            }
        }
        String[] tmp = new String[LIMIT];
        System.arraycopy(saveFilters, 0, tmp, 0, saveFilters.length);
        saveFilters = tmp;
        tmp = new String[LIMIT];
        System.arraycopy(saveLabels, 0, tmp, 0, saveLabels.length);
        saveLabels = tmp;
    }

    public UCDFilter getUCDFilter() {
        return this.filter;
    }

    protected static void updateAllFilters(Aladin a) {
        allFilters = PlanFilter.getAllFilters(a);
    }

    static void activateAllFilters() {
        PlanFilter pf = null;
        if (allFilters == null) {
            return;
        }
        for (int i = 0; i < allFilters.length; ++i) {
            pf = allFilters[i];
            pf.mustRepaint = false;
            pf.applyFilter();
            pf.setActivated(true);
        }
        if (pf != null) {
            pf.aladin.view.setMesure();
            pf.aladin.calque.select.repaint();
            pf.mustRepaint = true;
        }
    }

    static void desactivateAllFilters() {
        PlanFilter pf = null;
        if (allFilters == null) {
            return;
        }
        for (int i = 0; i < allFilters.length; ++i) {
            pf = allFilters[i];
            pf.setActivated(false);
        }
        if (pf != null) {
            pf.aladin.view.setMesure();
            pf.aladin.calque.select.repaint();
        }
    }

    private static PlanFilter[] getAllFilters(Aladin a) {
        Vector<Plan> v = new Vector<Plan>();
        for (int i = a.calque.plan.length - 1; i >= 0; --i) {
            PlanFilter planFilter;
            Plan p = a.calque.plan[i];
            if (p.type == 12) {
                v.addElement(p);
            }
            if (!p.isCatalog() || (planFilter = p.getFilter()) == null) continue;
            v.addElement(planFilter);
        }
        Object[] ret = new PlanFilter[v.size()];
        v.copyInto(ret);
        return ret;
    }

    @Override
    protected boolean Free() {
        this.stopFilterThread();
        this.memPlan = null;
        this.omemPlan = null;
        this.filter.Free();
        super.Free();
        PlanFilter.updateAllFilters(this.aladin);
        FilterProperties.majFilterProp(true, false);
        return true;
    }

    protected static PlanFilter getFilterByName(String s, Aladin a) {
        for (int i = a.calque.plan.length - 1; i >= 0; --i) {
            Plan p = a.calque.plan[i];
            if (p.type != 12 || !p.label.equals(s)) continue;
            return (PlanFilter)p;
        }
        return null;
    }

    static void updatePlan(Plan p, int oldPos, int newPos) {
        PlanFilter pf = null;
        if (allFilters == null) {
            return;
        }
        for (int i = 0; i < allFilters.length; ++i) {
            pf = allFilters[i];
            pf.setMustUpdate();
            if (!pf.isOn()) continue;
            pf.applyFilter();
        }
    }

    static void updatePlan(Plan p) {
        PlanFilter pf = null;
        if (allFilters == null) {
            return;
        }
        for (int i = 0; i < allFilters.length; ++i) {
            pf = allFilters[i];
            pf.setMustUpdate();
            if (!pf.isOn()) continue;
            pf.applyFilter();
        }
    }

    static void newPlan(Plan p) {
        PlanFilter pf = null;
        if (allFilters == null) {
            return;
        }
        for (int i = 0; i < allFilters.length; ++i) {
            pf = allFilters[i];
            pf.setMustUpdate();
            if (!pf.isOn()) continue;
            pf.applyFilter();
        }
    }

    static void updateNow() {
        PlanFilter pf = null;
        if (allFilters == null) {
            return;
        }
        for (int i = 0; i < allFilters.length; ++i) {
            pf = allFilters[i];
            pf.setMustUpdate();
            pf.setPlanMemory();
            pf.mustUpdate = true;
            if (!pf.isOn()) continue;
            pf.applyFilter();
        }
    }
}

