/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.TreeObj;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MyTree
extends JTree
implements Iterable<TreeObj> {
    protected String info;
    protected String info1;
    protected DefaultMutableTreeNode root;
    private Aladin aladin;

    protected MyTree(Aladin aladin) {
        this.aladin = aladin;
        this.createTree();
    }

    protected DefaultMutableTreeNode getRoot() {
        if (this.root == null) {
            this.root = new DefaultMutableTreeNode(new TreeObj(this.aladin, "root", null, "", ""));
        }
        return this.root;
    }

    private void createTree() {
        this.root = this.getRoot();
        ((DefaultTreeModel)this.getModel()).setRoot(this.root);
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 0));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        NoeudRenderer nr = new NoeudRenderer();
        this.setCellRenderer(nr);
        this.setCellEditor(new NoeudEditor(this));
        this.setEditable(true);
    }

    protected void freeTree() {
        if (this.root != null && this.root.getChildCount() == 0) {
            return;
        }
        DefaultMutableTreeNode r = new DefaultMutableTreeNode(new TreeObj(this.aladin, "root", null, "", ""));
        ((DefaultTreeModel)this.getModel()).setRoot(r);
        this.root = r;
    }

    @Override
    public Iterator<TreeObj> iterator() {
        return new TreeIterator();
    }

    protected void populateTree(Enumeration e) {
        while (e.hasMoreElements()) {
            TreeObj noeud = (TreeObj)e.nextElement();
            noeud.setHidden(false);
            this.createTreeBranch((DefaultTreeModel)this.getModel(), this.root, noeud, 0);
        }
        this.validate();
        this.defaultExpand();
    }

    public void reset() {
        for (TreeObj n : this) {
            n.setCheckBox(false);
        }
        this.validate();
    }

    public void submit() {
        boolean ok = false;
        for (TreeObj n : this) {
            if (!n.isCheckBoxSelected()) continue;
            this.submit(n);
            ok = true;
        }
        if (!ok) {
            this.warning();
        }
        this.reset();
    }

    protected void warning() {
    }

    protected void populateFlagIn() {
        this.setInTree(this.getRoot());
    }

    protected boolean setInTree(DefaultMutableTreeNode node) {
        TreeObj gSky = (TreeObj)node.getUserObject();
        if (node.isLeaf()) {
            return gSky.isIn();
        }
        boolean rep = false;
        DefaultMutableTreeNode subNode = null;
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            subNode = (DefaultMutableTreeNode)e.nextElement();
            if (!this.setInTree(subNode)) continue;
            rep = true;
        }
        gSky.setIn(rep);
        return rep;
    }

    protected boolean setHiddenTree(DefaultMutableTreeNode node) {
        TreeObj gSky = (TreeObj)node.getUserObject();
        if (node.isLeaf()) {
            return gSky.isHidden();
        }
        boolean rep = true;
        DefaultMutableTreeNode subNode = null;
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            subNode = (DefaultMutableTreeNode)e.nextElement();
            if (this.setHiddenTree(subNode)) continue;
            rep = false;
        }
        gSky.setHidden(rep);
        return rep;
    }

    protected void updateColor() {
    }

    private void submit(TreeObj n) {
        n.submit();
    }

    protected void createTreeBranch(DefaultTreeModel model, DefaultMutableTreeNode node, TreeObj noeud, int opos) {
        int pos;
        int index = opos;
        do {
            index = pos = noeud.path.indexOf(47, index);
            if (pos > 1 && noeud.path.charAt(pos - 1) == '\\') {
                ++index;
                continue;
            }
            index = -1;
        } while (index != -1);
        String label = pos < 0 ? noeud.path.substring(opos) : noeud.path.substring(opos, pos);
        try {
            DefaultMutableTreeNode subNode = null;
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                subNode = (DefaultMutableTreeNode)e.nextElement();
                TreeObj fils = (TreeObj)subNode.getUserObject();
                if (label.equals(fils.label)) break;
                subNode = null;
            }
            if (subNode == null) {
                subNode = new DefaultMutableTreeNode(pos != -1 ? new TreeObj(this.aladin, "", null, label, "") : noeud);
                int i = -1;
                int n = node.getChildCount();
                if (i == -1 || i > n) {
                    i = n;
                }
                model.insertNodeInto(subNode, node, i);
            }
            if (pos != -1) {
                this.createTreeBranch(model, subNode, noeud, pos + 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fireTreeChanged() {
        ((DefaultTreeModel)this.getModel()).reload();
    }

    protected boolean removeTreeBranch(DefaultMutableTreeNode node, String id) {
        DefaultMutableTreeNode subNode = null;
        boolean rep = false;
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            subNode = (DefaultMutableTreeNode)e.nextElement();
            TreeObj fils = (TreeObj)subNode.getUserObject();
            String idFils = fils.getID();
            if (idFils != null && idFils.equals(id)) {
                node.remove(subNode);
                rep = true;
                break;
            }
            if (!this.removeTreeBranch(subNode, id) || node.getChildCount() != 0) continue;
            node.remove(subNode);
            rep = true;
            break;
        }
        return rep;
    }

    protected void defaultExpand() {
        this.expandPath(new TreePath(this.root));
    }

    @Override
    public void paint(Graphics g) {
        try {
            this.updateColor();
            super.paint(g);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class NoeudEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        JTree tree;
        NoeudRenderer renderer;
        TreeObj n1;

        public NoeudEditor(JTree tree) {
            this.renderer = new NoeudRenderer();
            this.n1 = null;
            this.tree = tree;
        }

        @Override
        public boolean isCellEditable(EventObject event) {
            if (event instanceof MouseEvent) {
                TreePath path = this.tree.getPathForLocation(((MouseEvent)event).getX(), ((MouseEvent)event).getY());
                TreeObj noeud = (TreeObj)((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                return noeud.hasCheckBox();
            }
            return false;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object obj, boolean isSelected, boolean expanded, boolean leaf, int row) {
            TreeObj n;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
            this.n1 = n = (TreeObj)node.getUserObject();
            if (n != null && n.hasCheckBox()) {
                if (n.isIn()) {
                    n.checkbox.setForeground(Color.black);
                } else {
                    n.checkbox.setForeground(Color.lightGray);
                }
                return n.getPanel();
            }
            Component c = this.renderer.getTreeCellRendererComponent(tree, obj, true, expanded, leaf, row, true);
            if (n.isIn()) {
                c.setForeground(Color.black);
            } else {
                c.setForeground(Color.lightGray);
            }
            return c;
        }

        @Override
        public Object getCellEditorValue() {
            return this.n1;
        }
    }

    class NoeudRenderer
    implements TreeCellRenderer {
        DefaultTreeCellRenderer nonLeafRenderer = new DefaultTreeCellRenderer();
        Color selectionForeground = UIManager.getColor("Tree.selectionForeground");
        Color selectionBackground = UIManager.getColor("Tree.selectionBackground");
        Color textForeground = UIManager.getColor("Tree.textForeground");
        Color textBackground = UIManager.getColor("Tree.textBackground");

        NoeudRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object obj, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
            TreeObj n = (TreeObj)node.getUserObject();
            if (!node.isLeaf()) {
                n.noCheckbox();
            }
            if (n != null && n.hasCheckBox()) {
                if (n.isIn()) {
                    n.checkbox.setForeground(Color.black);
                } else {
                    n.checkbox.setForeground(Color.lightGray);
                }
                JPanel panel = n.getPanel();
                if (selected) {
                    panel.setForeground(this.selectionForeground);
                    panel.setBackground(this.selectionBackground);
                } else {
                    panel.setForeground(this.textForeground);
                    panel.setBackground(this.textBackground);
                }
                return panel;
            }
            Component c = this.nonLeafRenderer.getTreeCellRendererComponent(tree, obj, selected, expanded, leaf, row, hasFocus);
            if (n.isIn()) {
                c.setForeground(Color.black);
            } else {
                c.setForeground(Color.lightGray);
            }
            return c;
        }
    }

    class TreeIterator
    implements Iterator<TreeObj> {
        private Enumeration e;

        TreeIterator() {
            this.e = MyTree.this.root.preorderEnumeration();
        }

        @Override
        public boolean hasNext() {
            return this.e.hasMoreElements();
        }

        @Override
        public TreeObj next() {
            return (TreeObj)((DefaultMutableTreeNode)this.e.nextElement()).getUserObject();
        }

        @Override
        public void remove() {
        }
    }
}

