/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Mesure;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class MySplitPane
extends JSplitPane {
    private int memo = -1;
    private int defaultSize = -1;
    private boolean flagMesure = false;
    private Aladin aladin;
    private int mode;

    public MySplitPane(Aladin aladin, int orientation, Component first, Component second, int mode) {
        super(orientation, true, first, second);
        this.setBackground(aladin.getBackground());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setUI(new MyBasicSplitPaneUI());
        this.mode = mode;
        this.aladin = aladin;
        if (second instanceof Mesure) {
            this.flagMesure = true;
            this.setDividerSize(7);
        }
    }

    public boolean isReduced() {
        return this.getCompSize() <= this.getDividerSize();
    }

    public void setReduced(boolean flag) {
        if (this.isReduced() == flag) {
            return;
        }
        if (flag) {
            int ref;
            int m = this.getDividerLocation();
            int n = ref = this.mode == 0 ? this.getMinimumDividerLocation() : this.getMaximumDividerLocation();
            if (m != ref) {
                this.memo = m;
                this.setDividerLocation(ref);
            }
        } else {
            if (this.memo == -1) {
                if (this.defaultSize != -1) {
                    this.memo = this.mode == 0 ? this.defaultSize : this.getMaximumDividerLocation() - this.defaultSize;
                } else {
                    return;
                }
            }
            this.setDividerLocation(this.memo);
        }
        if (this.flagMesure && this.aladin.search.hideSearch(this.isReduced())) {
            this.revalidate();
        }
    }

    public void switchReduced() {
        this.setReduced(!this.isReduced());
    }

    public int getCompSize() {
        int max = this.getOrientation() == 0 ? this.getHeight() : this.getWidth();
        return this.mode == 0 ? this.getDividerLocation() : max - this.getDividerLocation();
    }

    public int getMemo() {
        return this.memo;
    }

    public void setDefaultSplit(int splitSize) {
        this.defaultSize = splitSize;
    }

    public static Rectangle drawLanguette(Graphics g, int pos, boolean closed, int h, int x1, int y1, Color bg, Color fg) {
        Rectangle r;
        int w = h * 4 + h / 3;
        g.setColor(bg);
        g.fillRect(x1, y1, pos == 0 || pos == 2 ? w : h, pos == 0 || pos == 2 ? h : w);
        g.setColor(fg);
        if (pos == 0 || pos == 2) {
            g.drawLine(x1, y1, x1, y1 + h);
            g.drawLine(x1 + w, y1, x1 + w, y1 + h);
            if (pos == 2) {
                g.drawLine(x1, y1, x1 + w, y1);
            } else {
                g.drawLine(x1, y1 + h, x1 + w, y1 + h);
            }
            r = new Rectangle(x1, y1, w, h);
        } else {
            g.drawLine(x1, y1, x1 + h, y1);
            g.drawLine(x1, y1 + w, x1 + h, y1 + w);
            if (pos == 3) {
                g.drawLine(x1, y1, x1, y1 + w);
            } else {
                g.drawLine(x1 + h, y1, x1 + h, y1 + w);
            }
            r = new Rectangle(x1, y1, h, w);
        }
        if (pos == 0 || pos == 1) {
            closed = !closed;
        }
        for (int i = 0; i < 3; ++i) {
            int y;
            int x;
            if (pos == 1 || pos == 3) {
                x = x1;
                y = y1 + h / 2 + (h + 1) * i;
            } else {
                x = x1 + h / 2 + (h + 1) * i;
                y = y1 + 2;
            }
            Polygon p = new Polygon();
            if (pos == 0 || pos == 2) {
                if (!closed) {
                    p.addPoint(x, y);
                    p.addPoint(x + h, y);
                    p.addPoint(x + h / 2, y + h);
                } else {
                    p.addPoint(x, y + h - 1);
                    p.addPoint(x + h, y + h - 1);
                    p.addPoint(x + h / 2, y - 1);
                }
            } else if (!closed) {
                p.addPoint(x, y);
                p.addPoint(x, y + h);
                p.addPoint(x + h, y + h / 2);
            } else {
                p.addPoint(x + h - 1, y);
                p.addPoint(x - 1 + h, y + h);
                p.addPoint(x - 1, y + h / 2);
            }
            g.fillPolygon(p);
        }
        return r;
    }

    class MySplitPaneDivider
    extends BasicSplitPaneDivider
    implements MouseListener {
        private Rectangle rLanguette;

        public MySplitPaneDivider(BasicSplitPaneUI ui) {
            super(ui);
            this.rLanguette = null;
            this.addMouseListener(this);
        }

        @Override
        public void paint(Graphics g) {
            if (MySplitPane.this.flagMesure) {
                if (MySplitPane.this.getCompSize() < 10) {
                    this.drawMesureLanguette(g);
                } else {
                    this.rLanguette = null;
                }
            }
        }

        private void drawMesureLanguette(Graphics g) {
            int h = this.getHeight();
            int w = h * 4;
            int x = this.getWidth() - h * 7;
            int y = 0;
            if (this.rLanguette == null) {
                this.rLanguette = new Rectangle(x, y, w, h);
            }
            g.setColor(Color.lightGray);
            g.drawLine(2 * this.getWidth() / 3, h - 1, x, h - 1);
            g.drawLine(x + w - 1, h - 1, this.getWidth(), h - 1);
            MySplitPane.drawLanguette(g, 2, true, h - 1, x, y, MySplitPane.this.aladin.getBackground(), Color.gray);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this.rLanguette == null && e.getClickCount() != 2) {
                return;
            }
            if (this.rLanguette != null && !this.rLanguette.contains(e.getPoint()) && e.getClickCount() != 2) {
                return;
            }
            MySplitPane.this.switchReduced();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (MySplitPane.this.flagMesure) {
                if (((MySplitPane)MySplitPane.this).aladin.mesure.isMesureOut()) {
                    ((MySplitPane)MySplitPane.this).aladin.mesure.split();
                } else if (((MySplitPane)MySplitPane.this).aladin.search.hideSearch(MySplitPane.this.isReduced())) {
                    this.revalidate();
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    class MyBasicSplitPaneUI
    extends BasicSplitPaneUI {
        MyBasicSplitPaneUI() {
        }

        @Override
        public BasicSplitPaneDivider createDefaultDivider() {
            return new MySplitPaneDivider(this);
        }
    }
}

