/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.tools.Util;
import java.awt.Color;
import java.awt.Label;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class MySelectableLabel
extends Label {
    private static MySelectableLabel lastSelected;
    private static Color HOVER_COLOR;
    private static Color SELECTION_COLOR;
    private Color orgBkgdColor;
    private Color orgFntColor;

    public MySelectableLabel(String s) {
        super(s);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (MySelectableLabel.this.orgBkgdColor == null) {
                    MySelectableLabel.this.orgBkgdColor = MySelectableLabel.this.getBackground();
                    MySelectableLabel.this.orgFntColor = MySelectableLabel.this.getForeground();
                }
                MySelectableLabel selected = (MySelectableLabel)me.getComponent();
                if (lastSelected != null) {
                    lastSelected.restoreOrgColors();
                }
                if (lastSelected == null || selected != lastSelected) {
                    lastSelected = (MySelectableLabel)me.getComponent();
                    MySelectableLabel.this.setBackground(MySelectableLabel.this.getSelectionColor());
                    MySelectableLabel.this.setForeground(Util.getReverseColor(MySelectableLabel.this.orgFntColor));
                    Aladin.aladin.copyToClipBoard(MySelectableLabel.this.getText());
                } else {
                    lastSelected = null;
                }
            }

            @Override
            public void mouseEntered(MouseEvent me) {
                if (MySelectableLabel.this.orgBkgdColor == null) {
                    MySelectableLabel.this.orgBkgdColor = MySelectableLabel.this.getBackground();
                }
                if (lastSelected == null || me.getComponent() != lastSelected) {
                    MySelectableLabel.this.setBackground(HOVER_COLOR);
                }
                Aladin.makeCursor(me.getComponent(), 6);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                if (lastSelected == null || me.getComponent() != lastSelected) {
                    MySelectableLabel.this.restoreOrgColors();
                }
                Aladin.makeCursor(me.getComponent(), 0);
            }
        });
    }

    private Color getSelectionColor() {
        return SELECTION_COLOR;
    }

    private void restoreOrgColors() {
        this.setBackground(this.orgBkgdColor);
        this.setForeground(this.orgFntColor);
    }

    static {
        HOVER_COLOR = new Color(232, 242, 254);
        SELECTION_COLOR = new Color(60, 107, 222);
    }
}

