/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.ActionExecutor;
import cds.aladin.Aladin;
import cds.aladin.ComponentLocator;
import cds.aladin.FilterProperties;
import cds.aladin.ScriptFactory;
import cds.aladin.TranslationScript;
import cds.tools.Util;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Toolkit;
import java.util.Random;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class MyRobot {
    static Robot robot;
    static boolean robotCompatible;
    static ActionExecutor ae;
    Aladin a;
    private ScriptFactory scriptFact;
    static Point lastLoc;
    static final int NBSTEPS100 = 10;
    private static Dimension screenSize;

    public MyRobot(Aladin a) {
        MyRobot.createRobot();
        this.scriptFact = new ScriptFactory();
        this.a = a;
    }

    public static void createRobot() {
        if (robot != null) {
            return;
        }
        try {
            robot = new Robot();
            robot.setAutoWaitForIdle(true);
        }
        catch (AWTException e) {
            robotCompatible = false;
        }
    }

    public boolean executeCommand(String cmdName, String argsStr) {
        TranslationScript script = this.scriptFact.getScript(cmdName, argsStr);
        if (script == null) {
            Aladin.trace(3, "No robot task found for command " + cmdName + ".\n" + cmdName + " will be executed as a normal script command.");
            return false;
        }
        ae = new ActionExecutor(script.actions, this.a);
        ae.execute();
        return true;
    }

    public static void info(String text, final Aladin aladinInst) {
        String title;
        JFrame robotInfo = aladinInst.command.robotInfo;
        JTextArea infoTxt = aladinInst.command.infoTxt;
        if (aladinInst.command.robotInfo == null) {
            aladinInst.command.robotInfo = new JFrame(){

                @Override
                public boolean handleEvent(Event e) {
                    if (e.id == 401 && e.key == 27 && aladinInst.command.robotMode) {
                        aladinInst.stopRobot(this);
                        return true;
                    }
                    if (e.id == 201) {
                        this.hide();
                    }
                    return super.handleEvent(e);
                }
            };
            Util.setCloseShortcut(aladinInst.command.robotInfo, false, aladinInst);
            Aladin.setIcon(aladinInst.command.robotInfo);
            robotInfo = aladinInst.command.robotInfo;
            robotInfo.setLayout(new BorderLayout(0, 10));
            aladinInst.command.infoTxt = new JTextArea("", 10, 50);
            robotInfo.add((Component)new JScrollPane(aladinInst.command.infoTxt), "Center");
            aladinInst.command.infoTxt.setWrapStyleWord(true);
            aladinInst.command.infoTxt.setLineWrap(true);
            infoTxt = aladinInst.command.infoTxt;
            JLabel l = new JLabel("Press [ESC] to stop the demonstration", 0);
            l.setFont(Aladin.BOLD);
            l.setBackground(Aladin.BLUE);
            robotInfo.add((Component)l, "South");
            robotInfo.pack();
            robotInfo.setLocation(0, 100);
            infoTxt.setFont(Aladin.BOLD);
            infoTxt.setForeground(Color.blue);
        }
        String string = title = aladinInst.command.curTuto != null ? aladinInst.command.curTuto : "Info";
        if (!robotInfo.getTitle().equals(title)) {
            robotInfo.setTitle(title);
        }
        robotInfo.setVisible(true);
        robotInfo.toFront();
        FilterProperties.insertInTA(infoTxt, "\n\n", infoTxt.getText().length());
        MyRobot.type(text, infoTxt);
    }

    private static double dist(Point p1, Point p2) {
        return Math.sqrt(Math.pow(p1.x - p2.x, 2.0) + Math.pow(p1.y - p2.y, 2.0));
    }

    protected void reset() {
        lastLoc = null;
    }

    public static void moveTo(int px, int py, Aladin aladinInst) {
        if (!robotCompatible) {
            System.out.println("Can't create java.awt.Robot object");
            return;
        }
        Point loc = new Point(px, py);
        if (lastLoc == null) {
            ComponentLocator cl = new ComponentLocator();
            Point p = cl.getLocation(aladinInst);
            Dimension d = aladinInst.f.getSize();
            lastLoc = new Point(p.x + d.width / 2, p.y + d.height / 2);
        }
        int nbSteps = (int)MyRobot.dist(loc, lastLoc) * 10 / 100;
        for (int i = 0; i < nbSteps; ++i) {
            int x = MyRobot.lastLoc.x + i * (loc.x - MyRobot.lastLoc.x) / nbSteps;
            int y = MyRobot.lastLoc.y + i * (loc.y - MyRobot.lastLoc.y) / nbSteps;
            robot.mouseMove(x, y);
            if ((double)i >= 0.9 * (double)nbSteps || (double)i <= 0.1 * (double)nbSteps) {
                robot.delay(80);
                continue;
            }
            robot.delay(30);
        }
        robot.mouseMove(loc.x, loc.y);
        lastLoc = loc;
    }

    public static void press(int x, int y, Component comp) {
        MyRobot.press(new Point(x, y), comp);
    }

    private static void press(Point loc, int delay, Component comp) {
        Component parent;
        if (!robotCompatible) {
            System.out.println("Can't create java.awt.Robot object");
            return;
        }
        robot.mouseMove(loc.x / 2, loc.y / 2);
        if (comp != null && (parent = MyRobot.getRootParent(comp)) instanceof JFrame) {
            JFrame f = (JFrame)parent;
            f.toFront();
        }
        robot.mouseMove(loc.x, loc.y);
        robot.mousePress(16);
        robot.delay(delay);
        robot.mouseRelease(16);
    }

    public static void press(Point loc, Component comp) {
        MyRobot.press(loc, 1500, comp);
    }

    public static void select(String item, Component comp, Point loc) {
        if (!(comp instanceof JComboBox)) {
            return;
        }
        MyRobot.press(loc, 0, comp);
        robot.delay(300);
        Integer myIntItem = null;
        boolean isInteger = true;
        try {
            myIntItem = new Integer(item);
        }
        catch (NumberFormatException nfe) {
            isInteger = false;
        }
        if (isInteger) {
            ((JComboBox)comp).setSelectedItem(myIntItem);
        } else {
            ((JComboBox)comp).setSelectedItem(item);
        }
        comp.doLayout();
        robot.keyPress(10);
        robot.keyRelease(10);
        robot.delay(300);
        comp.repaint();
    }

    public static void toFront(Component comp) {
        if (!(comp instanceof JFrame)) {
            return;
        }
        ((JFrame)comp).toFront();
    }

    public static void type(String text, Component c) {
        if (!robotCompatible) {
            System.out.println("Can't create java.awt.Robot object");
            return;
        }
        if (c != null) {
            c.requestFocus();
        }
        if (c instanceof JTextField || c instanceof JTextArea) {
            robot.keyPress(32);
            robot.keyRelease(32);
            robot.keyPress(8);
            robot.keyRelease(8);
        }
        Random generator = new Random();
        for (int i = 0; i < text.length(); ++i) {
            if (c == null) continue;
            if (c instanceof JTextField) {
                ((JTextField)c).setText(text.substring(0, i));
                ((JTextField)c).setCaretPosition(i);
            } else if (c instanceof JTextArea) {
                ((JTextArea)c).setText(text.substring(0, i));
                ((JTextArea)c).setCaretPosition(i);
            }
            int delay = generator.nextInt(140) + 50;
            if (delay > 160) {
                delay += 50;
            }
            robot.delay(delay);
        }
        if (c != null) {
            if (c instanceof JTextField) {
                ((JTextField)c).setText(text);
                ((JTextField)c).setCaretPosition(text.length());
            } else if (c instanceof JTextArea) {
                ((JTextArea)c).setText(text);
                ((JTextArea)c).setCaretPosition(text.length());
            }
        }
    }

    private static void type(String text, JTextArea ta) {
        if (!robotCompatible) {
            System.out.println("Can't create java.awt.Robot object");
            return;
        }
        if (ta == null) {
            return;
        }
        Random generator = new Random();
        for (int i = 0; i < text.length(); ++i) {
            ta.append("" + text.charAt(i));
            ta.setCaretPosition(ta.getDocument().getLength());
            int delay = generator.nextInt(140) + 50;
            if (delay > 160) {
                delay += 50;
            }
            robot.delay(delay);
        }
        ta.setCaretPosition(ta.getDocument().getLength());
    }

    public static void adjustPos(Component comp) {
        if (screenSize == null) {
            screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        }
        if (!(comp instanceof JFrame)) {
            return;
        }
        JFrame f = (JFrame)comp;
        Point pos = f.getLocation();
        Dimension size = f.getSize();
        if (pos.x < 0 || pos.y < 0 || pos.x + size.width > MyRobot.screenSize.width || pos.y + size.height > MyRobot.screenSize.height) {
            f.setLocation(MyRobot.screenSize.width / 2 - size.width / 2, MyRobot.screenSize.height / 2 - size.height / 2);
        }
        f.toFront();
    }

    public static void pause(int nbMs) {
        if (!robotCompatible) {
            System.out.println("Can't create java.awt.Robot object");
            return;
        }
        robot.delay(nbMs);
    }

    private static Component getRootParent(Component comp) {
        Component curComp = comp;
        while (curComp.getParent() != null) {
            curComp = curComp.getParent();
        }
        return curComp;
    }

    static {
        robotCompatible = true;
    }
}

