/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.tools.Util;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class MyAnchor
extends JLabel {
    private String url;
    private Aladin aladin;

    MyAnchor(Aladin aladin, String text, int width, String more, final String url) {
        this.aladin = aladin;
        if (text == null && more == null && url != null) {
            text = url;
        }
        if (text == null && more != null) {
            if (more.length() > width) {
                int n = more.lastIndexOf(32, width);
                if (n <= 0) {
                    n = width;
                }
                text = more.substring(0, n);
            } else {
                text = more;
                more = null;
            }
        }
        if (text == null) {
            text = "";
        }
        this.url = url;
        if (width > 0) {
            if ((text.startsWith("http://") || text.startsWith("ftp://")) && text.length() > width) {
                text = text.substring(0, width) + "...";
            } else {
                if (url != null) {
                    text = Util.fold(text, width, true);
                }
                text = Util.fold(text, width);
            }
        }
        if (url != null) {
            text = "<html><A HREF=\"\">" + text + "</A></html>";
        }
        if (more != null) {
            text = "<html>" + text + " <A HREF=\"\">...</A></html>";
        }
        if (url != null) {
            this.setToolTipText(url);
        } else if (more != null && more.startsWith("http")) {
            this.setToolTipText(more);
        }
        this.setText(text);
        this.setFont(this.getFont().deriveFont(2));
        final String more1 = more;
        if (url != null || more != null) {
            final MyAnchor c = this;
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    Aladin.makeCursor(c, 2);
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                }
            });
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if ((e.getModifiers() & 4) != 0) {
                        return;
                    }
                    if (url != null) {
                        MyAnchor.this.showDocument(url);
                    } else {
                        MyAnchor.this.showInfo(c, more1.replace("\\n", "\n"));
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    if ((e.getModifiers() & 4) != 0) {
                        MyAnchor.this.showPopMenu(e.getX(), e.getY());
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    Aladin.makeCursor(c, 0);
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }
            });
        }
    }

    MyAnchor(Aladin aladin, String text, final ActionListener action) {
        text = "<html>" + text + " <A HREF=\"\">...</A></html>";
        this.setText(text);
        this.setFont(this.getFont().deriveFont(2));
        final MyAnchor c = this;
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Aladin.makeCursor(c, 2);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if ((e.getModifiers() & 4) != 0) {
                    return;
                }
                action.actionPerformed(null);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Aladin.makeCursor(c, 0);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
    }

    private void showDocument(String url) {
        this.aladin.glu.showDocument(url);
    }

    private void showInfo(Component c, String s) {
        try {
            new URL(s);
            this.showDocument(s);
        }
        catch (Exception e) {
            Aladin.info(c, s);
        }
    }

    private void showPopMenu(int x, int y) {
        JPopupMenu popMenu = new JPopupMenu();
        popMenu.setLightWeightPopupEnabled(false);
        JMenuItem j = new JMenuItem(Aladin.chaine.getString("MFCOPYURL"));
        popMenu.add(j);
        j.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MyAnchor.this.aladin.copyToClipBoard(MyAnchor.this.url);
            }
        });
        popMenu.show(this, x, y);
    }
}

