/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.AppMessagingInterface;
import cds.aladin.BasicNode;
import cds.aladin.BasicTree;
import cds.aladin.Coord;
import cds.aladin.Fov;
import cds.aladin.FrameInfo;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.aladin.MyListener;
import cds.aladin.Plan;
import cds.aladin.PlanFov;
import cds.aladin.PlanImage;
import cds.aladin.ResourceNode;
import cds.aladin.ServerAladin;
import cds.aladin.ServerDialog;
import cds.aladin.ServerFile;
import cds.aladin.Slider;
import cds.aladin.SwingWidgetFinder;
import cds.aladin.TreeView;
import cds.aladin.Words;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.List;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MetaDataTree
extends BasicTree
implements SwingWidgetFinder,
KeyListener {
    static final String OPENWITHALADIN = "Aladin";
    static String NOLOC;
    static String NOIMG;
    static String IMAGE;
    static String NOSPEC;
    static String NOSPEC1;
    static String BADURL;
    static String ERRSPEC;
    static String OPENWITH;
    static String PLASTICAPPS;
    protected static final Color[] LABEL_COL;
    protected static Color[] LABEL_COL1;
    protected static Color[] LABEL_COL2;
    protected static Color[] LABEL_COL3;
    protected static Color[] LABEL_COL4;
    private boolean colorLabel = false;
    private static final String NOIMAGE_WARNING = "can not be loaded : \nno cutout available at this position !\nClick on the region you are interested in\nAvailable images will be marked with a red tick";
    private static final String SORTBY = "Sort by ...";
    private boolean enableKdShortcut = true;
    MyListener stateChangerLstr;
    private boolean fullExpandAtStart = true;
    private static SortableColumn[] columns;
    int indexSort = -1;
    boolean descSort = true;
    SortFrame sortFrame;
    static boolean firstShow;
    private int defaultIndexSort = 4;
    private boolean defaultDescSort = true;
    private boolean sortable = false;
    static String[] sortName;
    int[][] colBounds;
    static int wChar;
    boolean recomputeColSize = true;
    int[] colSize;
    private static final String DEFAULT_NAME = "Info frame";
    Object spv;

    private static void createLabelColors() {
        int nbCol = LABEL_COL.length;
        LABEL_COL1 = new Color[nbCol];
        LABEL_COL2 = new Color[nbCol];
        LABEL_COL3 = new Color[nbCol];
        LABEL_COL4 = new Color[nbCol];
        double increment = 0.1;
        for (int i = 0; i < LABEL_COL.length; ++i) {
            MetaDataTree.LABEL_COL1[i] = new Color((int)((double)LABEL_COL[i].getRed() + (double)((255 - LABEL_COL[i].getRed()) * 3) * increment), (int)((double)LABEL_COL[i].getGreen() + (double)((255 - LABEL_COL[i].getGreen()) * 3) * increment), (int)((double)LABEL_COL[i].getBlue() + (double)((255 - LABEL_COL[i].getBlue()) * 3) * increment));
            MetaDataTree.LABEL_COL2[i] = new Color((int)((double)LABEL_COL[i].getRed() + (double)(255 - LABEL_COL[i].getRed()) * increment), (int)((double)LABEL_COL[i].getGreen() + (double)(255 - LABEL_COL[i].getGreen()) * increment), (int)((double)LABEL_COL[i].getBlue() + (double)(255 - LABEL_COL[i].getBlue()) * increment));
            MetaDataTree.LABEL_COL3[i] = new Color((int)((double)LABEL_COL[i].getRed() - (double)(255 - LABEL_COL[i].getRed()) * increment), (int)((double)LABEL_COL[i].getGreen() - (double)(255 - LABEL_COL[i].getGreen()) * increment), (int)((double)LABEL_COL[i].getBlue() - (double)(255 - LABEL_COL[i].getBlue()) * increment));
            MetaDataTree.LABEL_COL4[i] = new Color((int)((double)LABEL_COL[i].getRed() - (double)((255 - LABEL_COL[i].getRed()) * 3) * increment), (int)((double)LABEL_COL[i].getGreen() - (double)((255 - LABEL_COL[i].getGreen()) * 3) * increment), (int)((double)LABEL_COL[i].getBlue() - (double)((255 - LABEL_COL[i].getBlue()) * 3) * increment));
        }
    }

    protected synchronized void createChaine() {
        if (NOLOC != null) {
            return;
        }
        NOLOC = Aladin.chaine.getString("MTNOLOC");
        NOIMG = Aladin.chaine.getString("MTNOIMG");
        IMAGE = Aladin.chaine.getString("IMAGE");
        NOSPEC = Aladin.chaine.getString("MTNOSPEC");
        NOSPEC1 = Aladin.chaine.getString("MTNOSPEC1");
        BADURL = Aladin.chaine.getString("MTBADURL");
        OPENWITH = Aladin.chaine.getString("MTOPENWITH");
        String appMsgProtocolName = this.aladin.getMessagingMgr().getProtocolName();
        PLASTICAPPS = Aladin.chaine.getString("MTPLASTICAPPS").replaceAll("SAMP", appMsgProtocolName);
    }

    MetaDataTree(BasicNode rootNode, Aladin aladin, JScrollPane scroll) {
        super(aladin, rootNode, scroll);
        this.createChaine();
        if (this.enableKdShortcut) {
            this.addKeyListener(this);
        }
    }

    MetaDataTree(Aladin aladin, JScrollPane scroll) {
        this(new ResourceNode(aladin), aladin, scroll);
    }

    MetaDataTree(BasicNode rootNode, Aladin aladin, JScrollPane scroll, boolean isHistoryTree) {
        super(aladin, rootNode, scroll, isHistoryTree);
        this.createChaine();
        if (this.enableKdShortcut) {
            this.addKeyListener(this);
        }
    }

    void addNode(ResourceNode parent, ResourceNode newNode) {
        parent.addChild(newNode);
        this.traverseTree();
        this.getStartPosition(newNode);
        this.repaint();
    }

    void setRoot(ResourceNode newRoot) {
        this.setRootNode(newRoot);
        this.traverseTree();
        this.getStartPosition(this.getRootNode());
        this.repaint();
    }

    protected void turnOffAllNodes() {
        if (this.nodeTab == null) {
            return;
        }
        for (int i = 0; i < this.nodeTab.length; ++i) {
            ResourceNode curNode = (ResourceNode)this.nodeTab[i];
            if (!curNode.isLeaf || curNode.type != 1) continue;
            this.turnOffNode(curNode);
        }
    }

    protected void turnOffNode(ResourceNode node) {
        if (!node.litup) {
            return;
        }
        node.litup = false;
        Graphics h = this.getGraphics();
        this.drawPreCheckBox(h, node.x - 22, node.y, node, true);
        int lineLength = h.getFontMetrics().stringWidth(this.getName(node));
        h.setColor(Aladin.COLOR_CONTROL_BACKGROUND);
        h.fillRect(node.x - 1, node.y / 18 * 18, lineLength + 2, 18);
        if (node.equals(this.lastInfoNode)) {
            h.setFont(boldNameFont);
        } else {
            h.setFont(nameFont);
        }
        h.setColor(Color.black);
        if (node.isLeaf && node.equals(this.lastInfoNode)) {
            this.drawBorder(h, node, lineLength);
        }
        h.drawString(this.getName(node), node.x, node.y + 9 + 4);
    }

    protected void litUpNode(BasicNode node) {
        if (node.litup) {
            return;
        }
        node.litup = true;
        Graphics h = this.getGraphics();
        this.drawPreCheckBox(h, node.x - 22, node.y, node, false);
        int lineLength = h.getFontMetrics().stringWidth(this.getName(node));
        h.setColor(LITBGCOLOR);
        h.fillRect(node.x - 1, node.y / 18 * 18, lineLength + 2, 18);
        h.setColor(LITFGCOLOR);
        if (node.equals(this.lastInfoNode)) {
            h.setFont(boldNameFont);
        } else {
            h.setFont(nameFont);
        }
        if (node.isLeaf && node.equals(this.lastInfoNode)) {
            this.drawBorder(h, node, lineLength);
        }
        h.drawString(this.getName(node), node.x, node.y + 9 + 4);
    }

    private void getStartPosition(BasicNode[] tab) {
        for (int i = 0; i < tab.length; ++i) {
            BasicNode node = tab[i];
            if (node.isLeaf) continue;
            node.isOpen = this.fullExpandAtStart || node.nbChildren <= 0 || !node.getChildrenAt((int)0).isLeaf && ((ResourceNode)node).valueCriteria == null;
            if (!node.equals(this.getRootNode())) continue;
            node.isOpen = true;
        }
    }

    protected void getStartPosition() {
        this.getStartPosition(this.nodeFullTab);
    }

    protected void getStartPosition(BasicNode myNode) {
        Vector<BasicNode> v = new Vector<BasicNode>();
        this.getAllSubnodes(myNode, v);
        v.addElement(myNode);
        Object[] tab = new BasicNode[v.size()];
        v.copyInto(tab);
        v = null;
        this.getStartPosition((BasicNode[])tab);
    }

    @Override
    public void setFlat(boolean b) {
        this.indexSort = -1;
        super.setFlat(b);
    }

    @Override
    BasicNode[] getLeavesForFlatView(BasicNode node) {
        BasicNode[] nodes = super.getLeavesForFlatView(node);
        Object[] ret = new ResourceNode[nodes.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (ResourceNode)nodes[i];
        }
        if (this.flatView && this.sortable && this.indexSort >= 0) {
            MetaDataTree.sort(ret, columns[this.indexSort], this.descSort);
        }
        return ret;
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        if (this.flatView && this.sortable && this.nodeFullTab.length > 1 && y < 18 && (evt.getModifiers() & 4) == 0) {
            for (int i = 0; i < this.colBounds.length; ++i) {
                if (x < this.colBounds[i][0]) {
                    return;
                }
                if (x > this.colBounds[i][1]) continue;
                this.descSort = this.indexSort == i ? !this.descSort : true;
                this.indexSort = i;
                this.repaint();
            }
        }
        super.mousePressed(evt);
    }

    @Override
    protected void onNodeExpanded(BasicNode node) {
    }

    @Override
    protected void onNodeCollapsed(BasicNode node) {
    }

    @Override
    protected void onNodeSelected(BasicNode node) {
        this.showInfo((ResourceNode)node);
    }

    @Override
    protected void onNodeSelectedDbleClick(BasicNode node) {
        this.load((ResourceNode)node, null);
    }

    @Override
    protected void onNodeRemoved(BasicNode node) {
        Vector vec = new Vector();
        this.getAllSubnodes(node, vec);
        if (node.equals(this.lastInfoNode) || vec.contains(this.lastInfoNode)) {
            this.lastInfoNode = null;
        }
    }

    @Override
    protected void onMouseMoved(BasicNode node, boolean inNodeName) {
        ResourceNode curNode = (ResourceNode)node;
        if ((curNode.type == 1 || curNode.type == 3) && inNodeName) {
            this.showFov(curNode);
            this.showCutoutFov(curNode);
        } else {
            this.deactivateCutoutFov();
        }
        Plan pref = this.aladin.calque.getPlanRef();
        if (curNode.isLeaf && curNode.type == 1 && inNodeName && pref == null) {
            Coord coo = this.getPos(curNode);
            if (coo != null) {
                this.aladin.localisation.setTextSaisie(this.aladin.localisation.J2000ToString(coo.al, coo.del));
            } else {
                this.resetLocalisation();
            }
        } else if (pref == null && this.aladin.localisation.getTextSaisie().length() > 0) {
            this.resetLocalisation();
        }
        if (!inNodeName || curNode.type != 1 && curNode.type != 3) {
            this.hideFov();
        }
    }

    private void resetLocalisation() {
        this.aladin.localisation.setTextSaisie("");
    }

    private void fillOpenWith(JMenu m, ResourceNode node) {
        if (node.type == 1 || node.type == 2) {
            m.add(this.createItem(OPENWITHALADIN));
            m.addSeparator();
        }
        if (Aladin.PLASTIC_SUPPORT) {
            JMenuItem mi = this.createItem(PLASTICAPPS);
            mi.setFont(Aladin.BOLD);
            m.add(mi);
            JMenuItem plasticMenu = mi;
            AppMessagingInterface.AbstractMessage msg = node.getPlasticMsg();
            ArrayList<String> apps = this.aladin.getMessagingMgr().getAppsSupporting(msg);
            System.out.println(apps.size());
            if (apps != null) {
                for (String app : apps) {
                    mi = this.createItem(app);
                    mi.setActionCommand(PLASTICAPPS);
                    m.add(mi);
                }
            }
            try {
                plasticMenu.setEnabled(apps != null && apps.size() > 0 && this.aladin.getMessagingMgr().isRegistered());
            }
            catch (NullPointerException npe) {
                // empty catch block
            }
        }
    }

    private void createMenuItem(JComponent pop, String[] sort) {
        if (sort.length == 1) {
            JMenuItem item = new JMenuItem(sort[0]);
            String cmd = pop instanceof JMenu ? ((JMenu)pop).getActionCommand() : "";
            item.setActionCommand(cmd + ";" + sort[0]);
            pop.add(item);
            return;
        }
        for (int i = 0; i < sort.length; ++i) {
            JMenu menu = new JMenu(sort[i]);
            String cmd = pop instanceof JMenu ? ((JMenu)pop).getActionCommand() : "";
            menu.setActionCommand(cmd + ";" + sort[i]);
            pop.add(menu);
            String[] newSort = new String[sort.length - 1];
            int start = 0;
            if (i > 0) {
                System.arraycopy(sort, 0, newSort, 0, i);
                start = i;
            }
            if (i < sort.length - 1) {
                System.arraycopy(sort, i + 1, newSort, start, sort.length - (i + 1));
            }
            this.createMenuItem(menu, newSort);
        }
    }

    @Override
    protected void onRightClickInNode(BasicNode node, int x, int y) {
        ResourceNode resNode = (ResourceNode)node;
        this.popup.removeAll();
        if (resNode.sortCriteria != null && resNode.sortCriteria.length > 1) {
            this.popup.addSeparator();
            this.popup.add(this.createItem(SORTBY));
            this.createMenuItem(this.popup, resNode.sortCriteria);
        }
        if (resNode.isLeaf) {
            JMenu openWith = new JMenu(OPENWITH);
            this.popup.add(openWith);
            this.fillOpenWith(openWith, resNode);
        }
        this.popup.addSeparator();
        this.popup.add(this.createItem("Collapse all"));
        this.popup.add(this.createItem("Expand all"));
        if (!this.isHistoryTree && this.hasSpectraOrImages) {
            this.popup.addSeparator();
            this.popup.add(this.createItem("Create a catalog plane with all images/spectra"));
        }
        this.popup.addSeparator();
        this.popup.add(this.flatView ? this.createItem("Hierarchical view") : this.createItem("Flat view"));
        if (!this.flatView && resNode.isSIAPEvol) {
            this.popup.addSeparator();
            this.popup.add(this.createItem("Sort"));
        }
        this.popup.show(this, x, y);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        super.actionPerformed(ae);
        Object src = ae.getSource();
        String o = ae.getActionCommand();
        ResourceNode n = (ResourceNode)this.selectedNode;
        if (o.equals("Delete")) {
            return;
        }
        if (o.equals("Collapse this subtree") || o.equals("Expand this subtree")) {
            return;
        }
        if (src instanceof JMenuItem) {
            if (o.equals(OPENWITHALADIN)) {
                this.load(n, null);
                return;
            }
            String text = ((JMenuItem)src).getText();
            if (text.equals(PLASTICAPPS)) {
                return;
            }
            if (((JMenuItem)src).getActionCommand().equals(PLASTICAPPS)) {
                this.loadNodeWithPlastic(n, text);
                return;
            }
            if (o.equals(SORTBY) || o.equals("Collapse all") || o.equals("Expand all") || o.equals("Flat view") || o.equals("Hierarchical view")) {
                if (this.stateChangerLstr != null) {
                    this.stateChangerLstr.fireStateChange(o);
                }
                return;
            }
            if (o.equals("Sort")) {
                this.sortSiapEvol();
                return;
            }
            if (o.equals("Create a catalog plane with all images/spectra")) {
                this.creatCatPlaneForSpectra((ResourceNode)this.getRootNode());
                return;
            }
            this.sortNode(n, ((JMenuItem)src).getActionCommand());
        }
    }

    private void creatCatPlaneForSpectra(ResourceNode beginNode) {
        Vector<ResourceNode> leaves = new Vector<ResourceNode>();
        MetaDataTree.getAllLeaves(beginNode, leaves);
        if (beginNode.isLeaf) {
            leaves.addElement(beginNode);
        }
        Vector spectra = new Vector();
        for (int i = 0; i < leaves.size(); ++i) {
            ResourceNode node = (ResourceNode)leaves.elementAt(i);
            if (node.type != 3 && node.type != 1) continue;
            spectra.addElement(leaves.elementAt(i));
        }
        if (spectra.size() == 0) {
            Aladin.error(this, "No spectrum/image found in this tree !");
        } else {
            Object[] spectraTab = new ResourceNode[spectra.size()];
            spectra.copyInto(spectraTab);
            spectra = null;
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\"?>\n<!DOCTYPE VOTABLE SYSTEM \"http://us-vo.org/xml/VOTable.dtd\">\n<VOTABLE version=\"1.0\" xmlns=\"http://vizier.u-strasbg.fr/VOTable\">\n  <DESCRIPTION>Object selection from Aladin</DESCRIPTION>\n  <DEFINITIONS>\n    <COOSYS ID=\"J2000\" equinox=\"2000.\" epoch=\"2000\" system=\"eq_FK5\"/>\n  </DEFINITIONS>\n");
            sb.append("<RESOURCE>\n");
            sb.append("<TABLE>\n");
            sb.append("<FIELD name=\"name\" datatype=\"char\" arraysize=\"*\" />\n");
            sb.append("<FIELD name=\"RA\" ucd=\"pos.eq.ra;meta.main\" unit=\"deg\" datatype=\"float\" />\n");
            sb.append("<FIELD name=\"DE\" ucd=\"pos.eq.dec;meta.main\" unit=\"deg\" datatype=\"float\" />\n");
            sb.append("<FIELD name=\"url_data\" ucd=\"meta.ref.url\"  datatype=\"char\" arraysize=\"*\"  type=\"hidden\" >\n");
            sb.append("</FIELD>\n");
            sb.append("<DATA><TABLEDATA>\n");
            String target = "";
            for (int i = 0; i < spectraTab.length; ++i) {
                sb.append("<TR>");
                sb.append("<TD>" + ((ResourceNode)spectraTab[i]).name + "</TD>");
                if (((ResourceNode)spectraTab[i]).getFov() != null) {
                    if (target != null && target.length() == 0 && ((ResourceNode)spectraTab[i]).objet != null) {
                        target = ((ResourceNode)spectraTab[i]).objet;
                    }
                    sb.append("<TD>" + ((ResourceNode)spectraTab[i]).getFov().alpha + "</TD>");
                    sb.append("<TD>" + ((ResourceNode)spectraTab[i]).getFov().delta + "</TD>");
                } else {
                    sb.append("<TD></TD>");
                    sb.append("<TD></TD>");
                }
                String location = ((ResourceNode)spectraTab[i]).location != null ? ((ResourceNode)spectraTab[i]).location : "";
                sb.append("<TD>" + URLEncoder.encode(location) + "</TD>");
                sb.append("</TR>\n");
            }
            sb.append("</TABLEDATA></DATA>\n");
            sb.append("</TABLE>\n");
            sb.append("</RESOURCE>\n");
            sb.append("</VOTABLE>");
            try {
                int n = this.aladin.calque.newPlanCatalog(new MyInputStream(new BufferedInputStream(new ByteArrayInputStream(sb.toString().getBytes()))), "toto");
                if (n >= 0) {
                    String orgLabel = "Spectra." + target;
                    String newLabel = new String(orgLabel);
                    int count = 0;
                    while (MetaDataTree.getPlaneByName(newLabel, this.aladin) != null) {
                        newLabel = orgLabel + "_" + ++count;
                    }
                    this.aladin.calque.plan[n].setLabel(newLabel);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected static Plan getPlaneByName(String s, Aladin a) {
        for (int i = a.calque.plan.length - 1; i >= 0; --i) {
            Plan p = a.calque.plan[i];
            if (p.label == null || !p.label.equals(s)) continue;
            return p;
        }
        return null;
    }

    protected void loadNodeWithPlastic(ResourceNode n, String plasticApp) {
        if (n == null || plasticApp == null) {
            return;
        }
        AppMessagingInterface mMgr = this.aladin.getMessagingMgr();
        AppMessagingInterface.AbstractMessage msg = n.getPlasticMsg();
        if (msg == null) {
            Aladin.trace(3, "Could not find a " + mMgr.getProtocolName() + " message to load node, aborting !");
            return;
        }
        ArrayList argsList = new ArrayList();
        String url = this.resolveLocation(n.location, n, null).toString();
        if (url == null) {
            Aladin.trace(3, "Could not resolve location of the resource to load");
            return;
        }
        ArrayList<Object> recipientsList = new ArrayList<Object>();
        recipientsList.add(mMgr.getAppWithName(plasticApp));
        mMgr.getPlasticWidget().animateWidgetSend();
        if (msg.equals(AppMessagingInterface.ABSTRACT_MSG_LOAD_SPECTRUM_FROM_URL)) {
            mMgr.sendMessageLoadSpectrum(url, url, n.name, n.getMetadata(), recipientsList);
        } else if (msg.equals(AppMessagingInterface.ABSTRACT_MSG_LOAD_CHARAC_FROM_URL)) {
            mMgr.sendMessageLoadCharac(url, n.name, recipientsList);
        } else if (msg.equals(AppMessagingInterface.ABSTRACT_MSG_LOAD_FITS)) {
            mMgr.sendMessageLoadImage(url, n.name, recipientsList);
        }
        Aladin.trace(3, "Sending data or spectrum with url " + url);
        this.aladin.glu.log(mMgr.getProtocolName(), "sending data or spectrum URL");
    }

    private void sortSiapEvol() {
        if (this.sortFrame == null) {
            this.sortFrame = new SortFrame("Choose sort fields");
        }
        this.sortFrame.updateList();
        this.sortFrame.pack();
        this.sortFrame.show();
        this.sortFrame.toFront();
    }

    protected static void doSortSiapEvol(String[] items, BasicNode rootNode) {
        Vector v = new Vector();
        MetaDataTree.getAllObs(rootNode, v);
        Object[] obs = new ResourceNode[v.size()];
        v.copyInto(obs);
        v = null;
        for (int i = items.length - 1; i >= 0; --i) {
            MetaDataTree.genericSort(obs, items[i], true);
        }
        rootNode.removeAllChild();
        for (int i = 0; i < obs.length; ++i) {
            Object curNode = obs[i];
            ResourceNode curParent = (ResourceNode)rootNode;
            for (int j = 0; j < items.length; ++j) {
                String curItem = items[j];
                String curValue = curItem + "::: " + (String)((ResourceNode)curNode).properties.get(curItem) + " ///" + (String)((ResourceNode)curNode).propertiesUnits.get(curItem);
                ResourceNode node = (ResourceNode)curParent.getChild(curValue);
                if (node == null) {
                    ResourceNode tmpNode = null;
                    if (((ResourceNode)curNode).links != null) {
                        tmpNode = (ResourceNode)((ResourceNode)curNode).links.get(curItem);
                    }
                    node = tmpNode == null ? new ResourceNode(rootNode.aladin, curValue) : new ResourceNode(rootNode.aladin, tmpNode);
                    node.type = ((ResourceNode)curNode).type;
                    curParent.addChild(node);
                }
                curParent = node;
            }
            curParent.addChild((BasicNode)curNode);
        }
    }

    private void doSortSiapEvol(String[] items) {
        MetaDataTree.doSortSiapEvol(items, this.getRootNode());
        this.traverseTree();
        this.repaint();
    }

    private void sortNode(ResourceNode node, String critStr) {
        StringTokenizer st = new StringTokenizer(critStr, ";");
        String[] crit = new String[st.countTokens()];
        for (int i = 0; i < crit.length; ++i) {
            crit[i] = st.nextToken();
        }
        Vector vec = new Vector();
        MetaDataTree.getAllLeaves(node, vec);
        Object[] allLeaves = new ResourceNode[vec.size()];
        vec.copyInto(allLeaves);
        vec = null;
        vec = new Vector();
        MetaDataTree.getAllNonLeaves(node, vec);
        Enumeration e = vec.elements();
        Hashtable<String, ResourceNode> hash = new Hashtable<String, ResourceNode>();
        while (e.hasMoreElements()) {
            ResourceNode bn = (ResourceNode)e.nextElement();
            bn.removeAllChild();
            hash.put(bn.name, bn);
        }
        node.removeAllChild();
        this.sortAndCreate((ResourceNode[])allLeaves, node, crit, hash);
        this.traverseTree();
        this.repaint();
    }

    private void sortAndCreate(ResourceNode[] tab, ResourceNode parent, String[] criteria, Hashtable nonLeaves) {
        if (tab.length == 0) {
            return;
        }
        for (int i = 0; i < tab.length; ++i) {
            ResourceNode curLeaf = tab[i];
            Hashtable value = curLeaf.criteriaVal;
            ResourceNode curParent = parent;
            String name = null;
            for (int j = 0; j < criteria.length; ++j) {
                name = (String)value.get(criteria[j]);
                ResourceNode node = (ResourceNode)curParent.getChild(name);
                if (node == null) {
                    node = new ResourceNode(this.aladin, (ResourceNode)nonLeaves.get(name));
                    curParent.addChild(node);
                }
                curParent = node;
            }
            curParent.addChild(curLeaf);
            if (curParent.col != null) continue;
            curParent.col = curLeaf.col;
        }
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        this.aladin.calque.curFov = null;
        this.aladin.calque.cutoutFov = null;
        this.resetLocalisation();
        this.clearSelected();
        this.aladin.calque.repaintAll();
    }

    private void showInfo(ResourceNode node) {
        String defFormat;
        FrameInfo curInst = this.aladin.getFrameInfo();
        if (node.server != null && node.server instanceof ServerAladin && node.isAvailableFormat(defFormat = ((ServerAladin)this.aladin.dialog.server[ServerDialog.ALADIN]).getDefaultFormat())) {
            node.curFormat = defFormat;
        }
        if (this.dontShow(node)) {
            return;
        }
        curInst.update(node, this);
        curInst.toFront();
        curInst.show();
    }

    private boolean dontShow(ResourceNode n) {
        if (n != null && this.aladin.calque.curFov != null) {
            return false;
        }
        return n == null || n.description == null || n.explanation == null || n.description.length == 0 && n.links == null && (n.filterDesc == null || n.filterExpla == null);
    }

    @Override
    protected void drawNodeName(Graphics h, BasicNode node, boolean redrawAll) {
        int type;
        boolean withSortField;
        ResourceNode resNode = (ResourceNode)node;
        boolean bl = withSortField = this.getName(node).indexOf("::: ") >= 0 && !node.isLeaf;
        if (!this.useColorLabel() || resNode.nbChildren == 0 || withSortField || (type = ((ResourceNode)resNode.getChildrenAt((int)0)).type) == 0) {
            super.drawNodeName(h, node, redrawAll);
        } else {
            h.setFont(nameFont);
            if (node == this.getRootNode() && this.flatView) {
                return;
            }
            String name = this.getName(node);
            h.setColor(LABEL_COL2[type]);
            h.fillRect(node.x, node.y + 1, h.getFontMetrics().stringWidth(name) + 1, 16);
            h.fillArc(node.x - 8, node.y + 1, 16, 17, 90, 90);
            h.fillArc(node.x + h.getFontMetrics().stringWidth(name) + 1 - 8, node.y + 1, 16, 17, 0, 90);
            h.setColor(LABEL_COL3[type]);
            h.fillRect(node.x, node.y + 1 + 9, h.getFontMetrics().stringWidth(name) + 1, 8);
            h.fillArc(node.x - 8, node.y + 1, 16, 17, 180, 90);
            h.fillArc(node.x + h.getFontMetrics().stringWidth(name) + 1 - 8, node.y + 1, 16, 17, 270, 90);
            h.setColor(LABEL_COL1[type]);
            h.drawLine(node.x, node.y + 1, node.x + h.getFontMetrics().stringWidth(name), node.y + 1);
            h.setColor(LABEL_COL4[type]);
            h.drawLine(node.x, node.y + 1 + 18 - 2, node.x + h.getFontMetrics().stringWidth(name), node.y + 1 + 18 - 2);
            boolean mouseOver = false;
            if (this.oHilightNode >= 0 && this.oHilightNode < this.nodeTab.length && this.nodeTab != null && node.equals(this.nodeTab[this.oHilightNode])) {
                mouseOver = true;
                if (node.isLeaf) {
                    this.drawSelectedLeafNodeName(h, node, name);
                }
            }
            h.setColor(mouseOver ? this.getMouseOverColor(node) : Color.black);
            h.setFont(node.equals(this.lastInfoNode) ? boldNameFont : nameFont);
            h.drawString(name, node.x, node.y + 9 + 4);
        }
    }

    void showFov(ResourceNode node) {
        if (firstShow) {
            this.aladin.cardView.show(this.aladin.bigView, "View");
            firstShow = false;
        }
        this.aladin.calque.curFov = this.getFovs(node, false);
        ResourceNode parent = (ResourceNode)node.getParent();
        this.aladin.calque.fovProj = node.isLeaf && parent != null && parent.type == 1 && node.getFov() != null ? PlanFov.getProjection(this.getFovs(parent, false)) : null;
        this.aladin.view.repaintAll();
    }

    protected Fov[] getFovs(ResourceNode node, boolean cutout, boolean cutoutIfNeeded) {
        Vector<ResourceNode> leavesV = new Vector<ResourceNode>();
        MetaDataTree.getAllLeaves(node, leavesV);
        if (node.isLeaf && (!cutout || node.cutout && node.getFov() != null)) {
            leavesV.addElement(node);
        }
        Enumeration e = leavesV.elements();
        Fov[] fovs = new Fov[leavesV.size()];
        int i = 0;
        while (e.hasMoreElements()) {
            fovs[i] = cutout ? this.getCutoutFov((ResourceNode)e.nextElement()) : (cutoutIfNeeded ? (node.cutout && node.getFov() != null ? this.getCutoutFov((ResourceNode)e.nextElement()) : ((ResourceNode)e.nextElement()).getFov()) : ((ResourceNode)e.nextElement()).getFov());
            ++i;
        }
        return fovs;
    }

    protected Fov[] getFovs(ResourceNode node, boolean cutout) {
        return this.getFovs(node, cutout, false);
    }

    void showCutoutFov(ResourceNode node) {
        this.aladin.calque.cutoutFov = this.getFovs(node, true);
        this.aladin.view.repaintAll();
    }

    private Fov getCutoutFov(ResourceNode node) {
        Fov fov;
        try {
            fov = new Fov(MetaDataTree.resolveTarget(node.getCutoutTarget(), this.aladin), node.getFov().cutout_x, node.getFov().cutout_y, node.getFov().angle);
        }
        catch (Exception e) {
            return null;
        }
        return fov;
    }

    static String resolveTarget(String s, Aladin aladinInst) {
        Coord c;
        try {
            c = !Localisation.notCoord(s) ? new Coord(s) : aladinInst.view.sesame(s);
        }
        catch (Exception e) {
            return null;
        }
        return c.getSexa(":");
    }

    void deactivateCutoutFov() {
        this.aladin.calque.cutoutFov = null;
        this.aladin.view.repaintAll();
    }

    void hideFov() {
        this.aladin.calque.curFov = null;
        this.aladin.view.repaintAll();
    }

    void setSortable(boolean b) {
        this.sortable = b;
        if (this.sortable) {
            this.indexSort = this.defaultIndexSort;
            this.descSort = this.defaultDescSort;
        }
    }

    void setFullExpandAtStart(boolean b) {
        this.fullExpandAtStart = b;
    }

    @Override
    protected int initMaxWidth() {
        if (this.flatView && this.sortable) {
            int max = 44;
            if (this.recomputeColSize) {
                this.computeColSize();
                this.recomputeColSize = false;
            }
            for (int i = 0; i < this.colSize.length; ++i) {
                max += (this.colSize[i] + 1) * wChar;
            }
            return max;
        }
        return super.initMaxWidth();
    }

    @Override
    void fullDisplay(Graphics h) {
        if (this.flatView && this.sortable && this.nodeFullTab.length > 1) {
            int i;
            this.colBounds = new int[this.colSize.length][2];
            int x = 44;
            int height = 14;
            h.setColor(Color.blue);
            for (i = 0; i < this.colSize.length; ++i) {
                int width = wChar * this.colSize[i] - 1;
                this.colBounds[i][0] = x;
                this.colBounds[i][1] = x + width;
                x += width + wChar;
            }
            for (i = 0; i < this.colBounds.length; ++i) {
                this.drawOnglet(h, i);
            }
        }
        super.fullDisplay(h);
    }

    private void drawOnglet(Graphics h, int index) {
        int width = this.colBounds[index][1] - this.colBounds[index][0];
        int height = 14;
        int xBegin = this.colBounds[index][0];
        h.setColor(grayFill);
        h.fillRect(xBegin + 1, 3, width, height);
        h.setColor(Color.white);
        h.drawRect(xBegin + 1, 3, width, height);
        h.setColor(grayCB);
        h.drawRect(xBegin, 2, width, height);
        h.setColor(Color.black);
        h.setFont(nameFont);
        h.drawString(sortName[index], wChar + xBegin, height);
        if (index == this.indexSort) {
            if (this.descSort) {
                xBegin = this.colBounds[index][1] - wChar - 3 + wChar / 2;
                h.setColor(Color.white);
                h.drawLine(xBegin, 14, xBegin + wChar / 2, 5);
                xBegin = this.colBounds[index][1] - wChar - 3;
                h.setColor(Color.black);
                h.drawLine(xBegin, 5, xBegin + wChar / 2, 14);
                xBegin = this.colBounds[index][1] - wChar - 3;
                h.setColor(Color.black);
                h.drawLine(xBegin, 5, xBegin + wChar - 1, 5);
            } else {
                xBegin = this.colBounds[index][1] - wChar - 3 + wChar / 2;
                h.setColor(Color.white);
                h.drawLine(xBegin, 5, xBegin + wChar / 2, 14);
                xBegin = this.colBounds[index][1] - wChar - 3;
                h.setColor(Color.black);
                h.drawLine(xBegin, 14, xBegin + wChar / 2, 5);
                xBegin = this.colBounds[index][1] - wChar - 3;
                h.setColor(Color.white);
                h.drawLine(xBegin, 14, xBegin + wChar - 1, 14);
            }
        }
    }

    @Override
    void traverseTree() {
        this.recomputeColSize = true;
        super.traverseTree();
    }

    private void computeColSize() {
        this.colSize = new int[columns.length];
        if (this.sortable) {
            for (int i = 0; i < this.colSize.length; ++i) {
                this.colSize[i] = sortName[i].length() + 3;
            }
        }
        Vector v = new Vector();
        MetaDataTree.getAllLeaves(this.getRootNode(), v);
        Object[] res = new ResourceNode[v.size()];
        v.copyInto(res);
        v = null;
        for (int i = 0; i < res.length; ++i) {
            Object curNode = res[i];
            for (int j = 0; j < columns.length; ++j) {
                this.colSize[j] = Math.max(this.colSize[j], columns[j].getColName((ResourceNode)curNode).length());
            }
        }
    }

    protected String getName(BasicNode node, boolean flat) {
        if (node.name == null) {
            node.name = "NULL";
        }
        if (!node.isLeaf) {
            return node.name.length() > 0 ? node.name : DEFAULT_NAME;
        }
        ResourceNode n = (ResourceNode)node;
        if (!flat) {
            if (n.isSIAPEvol && n.altName != null && n.getParent().isObs) {
                return n.altName;
            }
            int indexEp = n.name.indexOf("-EPOCH");
            if (indexEp > 0) {
                return n.name.substring(0, indexEp);
            }
            StringBuffer ret = new StringBuffer();
            if (n.machine != null && n.machine.length() > 0) {
                ret.append(n.machine + ".");
            }
            ret.append(n.name.length() > 0 ? n.name : DEFAULT_NAME);
            if (n.getFov() != null) {
                ret.append(" " + n.getFov().getSizeStr(n.cutout));
            }
            if (n.obsDate != null) {
                ret.append(" " + n.obsDate);
            }
            return ret.toString().trim();
        }
        if (!n.isLeaf || n.survey == null) {
            String newName = this.getName(n, false);
            for (ResourceNode parent = (ResourceNode)n.getParent(); parent != null && parent.type == 1; parent = (ResourceNode)parent.getParent()) {
                String parentName = parent.name;
                int idx = parentName.indexOf("::: ");
                if (idx >= 0) {
                    parentName = parentName.substring(idx + 4);
                }
                parentName = MetaDataTree.replace(parentName, " ///", "", 1);
                newName = newName + " " + parentName;
            }
            newName = newName + (n.getPixSize() != null ? " " + n.getPixSize() : "");
            newName = newName + (n.obsDate != null ? " " + n.obsDate : "");
            return newName;
        }
        if (this.recomputeColSize) {
            this.computeColSize();
            this.recomputeColSize = false;
        }
        String retName = "";
        for (int i = 0; i < columns.length; ++i) {
            retName = retName + Util.fillWithBlank(columns[i].getColName(n), this.colSize[i] + 1);
        }
        return retName.trim();
    }

    @Override
    protected String getName(BasicNode node) {
        return this.getName(node, this.flatView);
    }

    protected boolean checkCutoutAvailability(BasicNode node, double alpha, double delta, Aladin al) {
        return true;
    }

    private URL resolveLocation(String location, ResourceNode node, String imgParam) {
        URL url;
        if (node.type != 1) {
            try {
                return new URL(location);
            }
            catch (MalformedURLException mue) {
                if (location != null && (location.startsWith("/") || location.toLowerCase().startsWith("c:/"))) {
                    return this.resolveLocation("file://" + location, node, imgParam);
                }
                Aladin.error("Can't interpret location " + location);
                return null;
            }
        }
        String gluLink = node.gluLink;
        boolean useGluLink = gluLink != null;
        Coord coo = null;
        coo = this.getPos(node);
        if (coo != null) {
            if (node.cutout && !this.checkCutoutAvailability(node, coo.al, coo.del, this.aladin)) {
                Aladin.error(IMAGE + " " + node.name + " " + NOIMAGE_WARNING, 1);
                return null;
            }
            String pos = TreeView.getDeciCoord(coo.getSexa());
            if (location.indexOf("alapre") >= 0) {
                pos = coo.getSexa();
            }
            if (useGluLink) {
                gluLink = MetaDataTree.replace(gluLink, "$POS", URLEncoder.encode(pos), -1);
            } else {
                location = MetaDataTree.replace(location, "$POS", URLEncoder.encode(pos), -1);
            }
        }
        String curFormat = node.curFormat;
        if (imgParam != null && node.isAvailableFormat(imgParam)) {
            curFormat = imgParam;
        }
        if (curFormat != null) {
            if (useGluLink) {
                gluLink = MetaDataTree.replace(gluLink, "$COMPRESSION", URLEncoder.encode(curFormat), -1);
            } else {
                location = MetaDataTree.replace(location, "$COMPRESSION", URLEncoder.encode(curFormat), -1);
            }
        }
        if (node.curMode != null) {
            if (useGluLink) {
                gluLink = MetaDataTree.replace(gluLink, "$MODE", URLEncoder.encode(node.curMode), -1);
            } else {
                location = MetaDataTree.replace(location, "$MODE", URLEncoder.encode(node.curMode), -1);
            }
        }
        if (useGluLink) {
            gluLink = MetaDataTree.replace(gluLink, "$RESOLUTION", "FULL", -1);
        } else {
            location = MetaDataTree.replace(location, "$RESOLUTION", "FULL", -1);
        }
        if (useGluLink) {
            gluLink = MetaDataTree.replace(gluLink, "$NumberOfPatches", node.curImgNumber, -1);
        } else {
            location = MetaDataTree.replace(location, "$NumberOfPatches", node.curImgNumber, -1);
        }
        String[] imagePos = node.getImagePosTarget();
        String xPix = imagePos[0];
        String yPix = imagePos[1];
        if (useGluLink) {
            gluLink = MetaDataTree.replace(gluLink, "$Xpix", xPix, -1);
            gluLink = MetaDataTree.replace(gluLink, "$Ypix", yPix, -1);
        } else {
            location = MetaDataTree.replace(location, "$Xpix", xPix, -1);
            location = MetaDataTree.replace(location, "$Ypix", yPix, -1);
        }
        if (useGluLink) {
            Words w = new Words("", -1);
            w.tagGlu(gluLink.toCharArray());
            url = this.aladin.glu.getURL(w.id, w.param, true);
        } else {
            url = this.aladin.glu.getURL("Http", location, true);
        }
        return url;
    }

    private void loadImage(ResourceNode node, String imgParam, String label) {
        String objet;
        URL url;
        boolean useGluLink;
        String location = node.getLocation();
        String gluLink = node.gluLink;
        if (location == null && gluLink == null) {
            Aladin.error(NOLOC);
            return;
        }
        if (location == null) {
            location = "";
        }
        if (location.equalsIgnoreCase("NoData") && gluLink == null) {
            Aladin.error(NOIMG);
            return;
        }
        if (node.indexing != null && node.indexing.equals("HTML")) {
            this.aladin.glu.showDocument("Http", location, true);
            return;
        }
        boolean bl = useGluLink = gluLink != null;
        if (location.startsWith("file:")) {
            location = location.substring(5);
            ((ServerFile)this.aladin.dialog.server[ServerDialog.LOCAL]).creatLocalPlane(location, node.name, "", null, node, null, null, null, null);
            return;
        }
        Coord coo = null;
        coo = this.getPos(node);
        if (coo != null) {
            if (node.cutout && !this.checkCutoutAvailability(node, coo.al, coo.del, this.aladin)) {
                Aladin.error(IMAGE + " " + node.name + " " + NOIMAGE_WARNING, 1);
                return;
            }
            String pos = TreeView.getDeciCoord(coo.getSexa());
            if (location.indexOf("alapre") >= 0) {
                pos = coo.getSexa();
            }
            if (useGluLink) {
                gluLink = MetaDataTree.replace(gluLink, "$POS", URLEncoder.encode(pos), -1);
            } else {
                location = MetaDataTree.replace(location, "$POS", URLEncoder.encode(pos), -1);
            }
        }
        String curFormat = node.curFormat;
        if (imgParam != null && node.isAvailableFormat(imgParam)) {
            curFormat = imgParam;
        }
        if (curFormat != null) {
            if (useGluLink) {
                gluLink = MetaDataTree.replace(gluLink, "$COMPRESSION", URLEncoder.encode(curFormat), -1);
            } else {
                location = MetaDataTree.replace(location, "$COMPRESSION", URLEncoder.encode(curFormat), -1);
            }
        }
        if (node.curMode != null) {
            if (useGluLink) {
                gluLink = MetaDataTree.replace(gluLink, "$MODE", URLEncoder.encode(node.curMode), -1);
            } else {
                location = MetaDataTree.replace(location, "$MODE", URLEncoder.encode(node.curMode), -1);
            }
        }
        if (useGluLink) {
            gluLink = MetaDataTree.replace(gluLink, "$RESOLUTION", "FULL", -1);
        } else {
            location = MetaDataTree.replace(location, "$RESOLUTION", "FULL", -1);
        }
        if (useGluLink) {
            gluLink = MetaDataTree.replace(gluLink, "$NumberOfPatches", node.curImgNumber, -1);
        } else {
            location = MetaDataTree.replace(location, "$NumberOfPatches", node.curImgNumber, -1);
        }
        String[] imagePos = node.getImagePosTarget();
        String xPix = imagePos[0];
        String yPix = imagePos[1];
        if (useGluLink) {
            gluLink = MetaDataTree.replace(gluLink, "$Xpix", xPix, -1);
            gluLink = MetaDataTree.replace(gluLink, "$Ypix", yPix, -1);
        } else {
            location = MetaDataTree.replace(location, "$Xpix", xPix, -1);
            location = MetaDataTree.replace(location, "$Ypix", yPix, -1);
        }
        if (useGluLink) {
            Words w = new Words("", -1);
            w.tagGlu(gluLink.toCharArray());
            url = this.aladin.glu.getURL(w.id, w.param, true);
        } else {
            url = this.aladin.glu.getURL("Http", location, true);
        }
        if (label == null) {
            label = this.buildStackLabel(node);
        }
        String param = this.buildQual(node);
        int format = curFormat != null ? PlanImage.getFmt(curFormat) : 0;
        String string = objet = coo != null ? coo.getSexa(":") : "";
        if (objet.length() == 0 || node.objet != null && (!node.cutout && (node.modes == null || node.modes.length <= 1 || node.curMode == null || node.curMode.equals("ORIGIN")) || node.targetObjet != null && objet.equals(node.targetObjet))) {
            objet = node.objet;
        }
        if (node.server != null && node.server instanceof ServerAladin && !this.aladin.dialog.server[this.aladin.dialog.current].verif(1, objet, param, format + "/" + 0)) {
            return;
        }
        String cmd = node.getScriptCommand();
        if (cmd != null) {
            this.aladin.console.printCommand(cmd);
        }
        if (node.server instanceof ServerAladin) {
            this.aladin.calque.newPlanImage(url, 0, label, objet, param, node.origin != null && node.origin.length() > 0 ? node.origin : (node.server != null ? node.server.institute : null), format, 0, null, node);
        } else {
            ((ServerFile)this.aladin.dialog.localServer).creatLocalPlane(url.toString(), label, node.origin != null && node.origin.length() > 0 ? node.origin : (node.server != null ? node.server.institute : null), null, node, null, node.server != null ? node.server : null, null, null);
        }
    }

    private String buildStackLabel(ResourceNode node) {
        StringBuffer ret = new StringBuffer();
        if (node.resol != null && node.survey != null) {
            if (node.resol.equals("PLATE")) {
                ret.append("Pl-");
            } else if (node.resol.equals("LOW")) {
                ret.append("Lw-");
            }
        }
        if (node.survey != null) {
            ret.append(node.survey);
        }
        if (node.epoch != null) {
            ret.append("." + node.epoch);
        }
        if (node.bandPass != null) {
            ret.append("." + node.bandPass);
        }
        if (node.machine != null) {
            ret.append("." + node.machine);
        }
        ret.append("." + node.name);
        if (!node.curImgNumber.equals("1") || !node.maxImgNumber.equals("1")) {
            ret.append(node.curImgNumber);
            if (node.velStep != 0.0) {
                String velocity;
                try {
                    double val = Slider.round(node.beginVel + (double)(Integer.parseInt(node.curImgNumber) - 1) * node.velStep, 2);
                    velocity = "_" + val + "km/s";
                }
                catch (NumberFormatException nfe) {
                    velocity = "";
                }
                ret.append(velocity);
            }
        }
        String stackLabel = ret.toString().trim();
        while (stackLabel.length() > 0 && stackLabel.charAt(0) == '.') {
            stackLabel = stackLabel.substring(1);
        }
        stackLabel = MetaDataTree.replace(stackLabel, "..", ".", -1);
        while (stackLabel.length() > 0 && stackLabel.charAt(stackLabel.length() - 1) == '.') {
            stackLabel = stackLabel.substring(0, stackLabel.length() - 2);
        }
        return stackLabel;
    }

    private String buildQual(ResourceNode node) {
        StringBuffer ret = new StringBuffer();
        if (node.survey != null) {
            ret.append(node.survey + " ");
        }
        if (node.bandPass != null) {
            ret.append(node.bandPass + " ");
        }
        if (node.curMode != null) {
            ret.append(node.curMode + " ");
        }
        ret.append(node.name + " ");
        return ret.toString();
    }

    private Coord getPos(ResourceNode node) {
        if (node.cutout) {
            Coord coo = null;
            try {
                coo = new Coord(node.getCutoutTarget());
            }
            catch (Exception e) {
                try {
                    coo = this.aladin.view.sesame(node.getCutoutTarget());
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            return coo;
        }
        if (node.modes != null && node.modes.length > 1 && !node.curMode.equals("ORIGIN")) {
            Coord coo = null;
            try {
                coo = new Coord(node.getMosaicTarget());
            }
            catch (Exception e) {
                try {
                    coo = this.aladin.view.sesame(node.getMosaicTarget());
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            return coo;
        }
        if (node.getFov() == null) {
            return null;
        }
        return new Coord(node.getFov().alpha, node.getFov().delta);
    }

    void loadSelected(String param) {
        Vector v = this.getSelectedLeaves();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            ResourceNode node = (ResourceNode)e.nextElement();
            this.load(node, param, null, this);
        }
    }

    void loadSelected() {
        this.loadSelected(null);
    }

    int nbSelected() {
        return this.getSelectedLeaves().size();
    }

    void clear() {
        ResourceNode node = new ResourceNode(this.aladin);
        node.hide = true;
        this.setRoot(node);
        if (this.sortable) {
            this.indexSort = this.defaultIndexSort;
            this.descSort = this.defaultDescSort;
        }
    }

    protected void load(final ResourceNode node, final String param, final String label, final Component c) {
        final String treeTaskId = this.aladin.synchroServer.start("MetaDataTree.load");
        new Thread("LoadResourceNode"){

            @Override
            public void run() {
                try {
                    if (node.location == null || node.location.length() == 0) {
                        return;
                    }
                    if (node.type == 1 || node.type == 4) {
                        MetaDataTree.this.loadImage(node, param, label);
                    } else if (node.type == 2) {
                        MetaDataTree.this.loadCat(node, label);
                    } else if (node.type == 3) {
                        MetaDataTree.this.loadSpectrum(node, c);
                    } else if (node.type == 7) {
                        MetaDataTree.this.loadOther(node, label);
                    } else if (node.indexing != null && node.indexing.equals("HTML")) {
                        MetaDataTree.this.aladin.glu.showDocument("Http", node.location, true);
                    }
                }
                finally {
                    MetaDataTree.this.aladin.synchroServer.stop(treeTaskId);
                }
            }
        }.start();
        Util.pause(100);
    }

    protected void load(ResourceNode node, String label) {
        this.load(node, null, label, null);
    }

    private void loadOther(BasicNode node, String label) {
        if (label == null) {
            label = node.name;
        }
        this.aladin.calque.newPlan(((ResourceNode)node).location, label, null, null, null);
    }

    private void loadSpectrum(ResourceNode node, Component c) {
        ArrayList<String> plasticApps;
        boolean cantDisplay = false;
        if (!this.aladin.getMessagingMgr().isRegistered()) {
            cantDisplay = true;
        }
        if ((plasticApps = this.aladin.getMessagingMgr().getAppsSupporting(node.getPlasticMsg())) == null || plasticApps.size() == 0) {
            cantDisplay = true;
        }
        if (cantDisplay) {
            System.out.println("Can't load spectrum " + node.name + " : couldn't find any PLASTIC-compatible spectrum viewer");
        } else {
            this.loadNodeWithPlastic(node, plasticApps.get(0));
        }
    }

    private void loadCat(BasicNode node, String label) {
        this.loadOther(node, label);
    }

    private static void swap(Object[] x, int a, int b) {
        Object tmp = x[a];
        x[a] = x[b];
        x[b] = tmp;
    }

    public static void sort(Object[] nodes, SortableColumn c, boolean descSort) {
        Object[] aux = (Object[])nodes.clone();
        if (c == null) {
            c = new SortableColumn(){

                @Override
                public String getColName(ResourceNode n) {
                    return "";
                }

                @Override
                public int compare(Object o1, Object o2, boolean goOn) {
                    return o1.toString().toLowerCase().compareTo(o2.toString().toLowerCase());
                }
            };
        }
        MetaDataTree.mergeSort(aux, nodes, 0, nodes.length, c, descSort);
    }

    public static void genericSort(Object[] nodes, final String sortField, boolean descSort) {
        Object[] aux = (Object[])nodes.clone();
        SortableColumn c = new SortableColumn(){

            @Override
            public String getColName(ResourceNode node) {
                String val = (String)node.properties.get(sortField);
                return val == null ? "" : val;
            }

            @Override
            public int compare(Object o1, Object o2, boolean goOn) {
                ResourceNode n1 = (ResourceNode)o1;
                ResourceNode n2 = (ResourceNode)o2;
                String val1 = this.getColName(n1).toLowerCase();
                String val2 = this.getColName(n2).toLowerCase();
                try {
                    Double d1 = new Double(val1);
                    Double d2 = new Double(val2);
                    return d1.compareTo(d2);
                }
                catch (NumberFormatException nfe) {
                    return val1.compareTo(val2);
                }
            }
        };
        MetaDataTree.mergeSort(aux, nodes, 0, nodes.length, c, descSort);
    }

    private static void mergeSort(Object[] src, Object[] dest, int low, int high, SortableColumn c, boolean desc) {
        int fact;
        int length = high - low;
        int n = fact = desc ? 1 : -1;
        if (length < 7) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && fact * c.compare(dest[j - 1], dest[j], true) > 0; --j) {
                    MetaDataTree.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int mid = low + high >> 1;
        MetaDataTree.mergeSort(dest, src, low, mid, c, desc);
        MetaDataTree.mergeSort(dest, src, mid, high, c, desc);
        if (fact * c.compare(src[mid - 1], src[mid], true) <= 0) {
            System.arraycopy(src, low, dest, low, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = low; i < high; ++i) {
            dest[i] = q >= high || p < mid && fact * c.compare(src[p], src[q], true) <= 0 ? src[p++] : src[q++];
        }
    }

    public static String replace(String text, String repl, String with, int max) {
        if (text == null || repl == null || with == null || repl.length() == 0 || max == 0) {
            return text;
        }
        if (text.indexOf(repl) < 0) {
            return text;
        }
        int n = repl.length();
        StringBuffer buf = new StringBuffer(text.length());
        int start = 0;
        int end = 0;
        while ((end = text.indexOf(repl, start)) != -1) {
            buf.append(text.substring(start, end)).append(with);
            start = end + n;
            if (--max != 0) continue;
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    void setStateChangedListener(MyListener listener) {
        this.stateChangerLstr = listener;
    }

    @Override
    public BasicNode searchNodeByName(String name) {
        for (int i = 0; i < this.nodeFullTab.length; ++i) {
            if (!this.nodeFullTab[i].name.equals(name)) continue;
            return this.nodeFullTab[i];
        }
        return null;
    }

    private ResourceNode searchNodeByName(String name, String band) {
        for (int i = 0; i < this.nodeFullTab.length; ++i) {
            boolean bandOK;
            ResourceNode n = (ResourceNode)this.nodeFullTab[i];
            boolean nameOK = n.isLeaf && (n.machine.indexOf(name) >= 0 || n.survey.indexOf(name) >= 0);
            boolean bl = bandOK = band == null || n.bandPass != null && n.bandPass.equalsIgnoreCase(band);
            if (!nameOK || !bandOK) continue;
            return n;
        }
        return null;
    }

    @Override
    public boolean findWidget(String name) {
        return true;
    }

    @Override
    public Point getWidgetLocation(String name) {
        ResourceNode bn;
        StringTokenizer st = new StringTokenizer(name, "/ ");
        name = st.nextToken();
        String band = null;
        if (st.hasMoreTokens()) {
            band = st.nextToken();
        }
        if ((bn = this.searchNodeByName(name, band)) != null) {
            return new Point(bn.x - 18, bn.y + 6);
        }
        return null;
    }

    public boolean useColorLabel() {
        return this.colorLabel;
    }

    public void setColorLabel(boolean colorLabel) {
        this.colorLabel = colorLabel;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        char key = keyEvent.getKeyChar();
        Event e = null;
        if (key == 'c') {
            super.action(e, "Collapse all");
        } else if (key == 'e') {
            super.action(e, "Expand all");
        }
        if (key == 't') {
            super.action(e, "Hierarchical view");
            if (this.stateChangerLstr != null) {
                this.stateChangerLstr.fireStateChange("Hierarchical view");
            }
        } else if (key == 'l') {
            super.action(e, "Flat view");
            if (this.stateChangerLstr != null) {
                this.stateChangerLstr.fireStateChange("Flat view");
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    static {
        LABEL_COL = new Color[]{Aladin.COLOR_BUTTON_BACKGROUND, new Color(249, 188, 97), new Color(208, 160, 224), new Color(192, 229, 107), new Color(255, 124, 116), new Color(127, 183, 255)};
        columns = new SortableColumn[6];
        MetaDataTree.createLabelColors();
        MetaDataTree.columns[0] = new SortableColumn(){

            @Override
            public String getColName(ResourceNode n) {
                return n.survey != null ? n.survey : "";
            }

            @Override
            public int compare(Object o1, Object o2, boolean goOn) {
                ResourceNode n1 = (ResourceNode)o1;
                ResourceNode n2 = (ResourceNode)o2;
                int ret = this.getColName(n1).compareTo(this.getColName(n2));
                if (ret != 0 || !goOn) {
                    return ret;
                }
                ret = columns[1].compare(n1, n2, false);
                if (ret != 0) {
                    return ret;
                }
                ret = columns[2].compare(n1, n2, false);
                return ret;
            }
        };
        MetaDataTree.columns[1] = new SortableColumn(){

            @Override
            public String getColName(ResourceNode n) {
                String s = "";
                if (n.bandPass != null) {
                    s = s + n.bandPass;
                    if (n.wavelengthExpla != null) {
                        s = s + "(" + n.wavelengthExpla + ")";
                    } else if (n.wavelength != null) {
                        s = s + "(" + n.wavelength + ")";
                    }
                }
                return s;
            }

            @Override
            public int compare(Object o1, Object o2, boolean goOn) {
                ResourceNode n1 = (ResourceNode)o1;
                ResourceNode n2 = (ResourceNode)o2;
                int ret = this.getColName(n1).compareTo(this.getColName(n2));
                if (ret != 0 || !goOn) {
                    return ret;
                }
                ret = columns[0].compare(n1, n2, false);
                if (ret != 0) {
                    return ret;
                }
                ret = columns[2].compare(n1, n2, false);
                return ret;
            }
        };
        MetaDataTree.columns[2] = new SortableColumn(){

            @Override
            public String getColName(ResourceNode n) {
                if (n.getFov() == null) {
                    return "";
                }
                return n.getFov().getSizeStr(n.cutout);
            }

            @Override
            public int compare(Object o1, Object o2, boolean goOn) {
                int ret;
                ResourceNode n1 = (ResourceNode)o1;
                ResourceNode n2 = (ResourceNode)o2;
                if (n1.getFov() == null) {
                    ret = n2.getFov() == null ? 0 : -1;
                } else if (n2.getFov() == null) {
                    ret = 1;
                } else {
                    double size2;
                    double size1 = n1.cutout ? n1.getFov().cutout_x * n1.getFov().cutout_y : n1.getFov().x * n1.getFov().y;
                    double d = size2 = n2.cutout ? n2.getFov().cutout_x * n2.getFov().cutout_y : n2.getFov().x * n2.getFov().y;
                    if (size1 == size2) {
                        ret = 0;
                    } else {
                        int n = ret = size1 > size2 ? 1 : -1;
                    }
                }
                if (ret != 0 || !goOn) {
                    return ret;
                }
                ret = columns[0].compare(n1, n2, false);
                if (ret != 0) {
                    return ret;
                }
                ret = columns[1].compare(n1, n2, false);
                return ret;
            }
        };
        MetaDataTree.columns[5] = new SortableColumn(){

            @Override
            public String getColName(ResourceNode n) {
                return n.obsDate != null ? n.obsDate : "";
            }

            @Override
            public int compare(Object o1, Object o2, boolean goOn) {
                ResourceNode n1 = (ResourceNode)o1;
                ResourceNode n2 = (ResourceNode)o2;
                return this.getColName(n1).compareTo(this.getColName(n2));
            }
        };
        MetaDataTree.columns[4] = new SortableColumn(){

            @Override
            public String getColName(ResourceNode n) {
                return n.getPixSize() != null ? n.getPixSize() : "";
            }

            @Override
            public int compare(Object o1, Object o2, boolean goOn) {
                ResourceNode n1 = (ResourceNode)o1;
                ResourceNode n2 = (ResourceNode)o2;
                int ret = n1.getPixSizeDeg() == 0.0 ? (n2.getPixSizeDeg() == 0.0 ? 0 : -1) : (n2.getPixSizeDeg() == 0.0 ? 1 : (n1.getPixSizeDeg() == n2.getPixSizeDeg() ? 0 : (n1.getPixSizeDeg() > n2.getPixSizeDeg() ? 1 : -1)));
                return ret;
            }
        };
        MetaDataTree.columns[3] = new SortableColumn(){

            @Override
            public String getColName(ResourceNode n) {
                String ret = "";
                if (n.machine != null && n.machine.length() != 0) {
                    ret = ret + n.machine + ".";
                }
                ret = ret + n.name;
                return ret;
            }

            @Override
            public int compare(Object o1, Object o2, boolean goOn) {
                ResourceNode n1 = (ResourceNode)o1;
                ResourceNode n2 = (ResourceNode)o2;
                return this.getColName(n1).compareTo(this.getColName(n2));
            }
        };
        firstShow = true;
        sortName = new String[]{"SURVEY", "COLOR", "SIZE", "OBS ID", "RESOL", "DATE"};
        wChar = fm.stringWidth("A");
    }

    class SortFrame
    extends JFrame {
        List leftList;
        List rightList;
        Button arrow;
        Button go;

        public SortFrame(String s) {
            super(s);
            Aladin.setIcon(this);
            this.setBackground(Aladin.BLUE);
            this.setLayout(new BorderLayout());
            this.leftList = new List(15, true);
            this.rightList = new List(15, true);
            this.arrow = new Button("-->");
            this.go = new Button("OK");
            JPanel p = new JPanel();
            p.setLayout(new FlowLayout());
            p.add(this.leftList);
            p.add(this.arrow);
            p.add(this.rightList);
            Aladin.makeAdd(this, p, "North");
            Aladin.makeAdd(this, this.go, "South");
        }

        public void updateList() {
            this.leftList.removeAll();
            this.rightList.removeAll();
            ResourceNode n = null;
            Vector v = new Vector();
            BasicTree.getAllLeaves(MetaDataTree.this.getRootNode(), v);
            n = (ResourceNode)v.elementAt(0);
            for (int i = 0; i < n.description.length; ++i) {
                this.leftList.add(n.description[i]);
            }
        }

        @Override
        public boolean action(Event e, Object o) {
            if (e.target.equals(this.arrow)) {
                String[] selected = this.leftList.getSelectedItems();
                for (int i = 0; i < selected.length; ++i) {
                    this.rightList.add(selected[i]);
                    this.leftList.remove(selected[i]);
                }
            } else if (e.target.equals(this.go)) {
                MetaDataTree.this.doSortSiapEvol(this.rightList.getItems());
                this.hide();
            }
            return true;
        }

        @Override
        public boolean handleEvent(Event e) {
            if (e.id == 201) {
                this.hide();
            }
            return super.handleEvent(e);
        }
    }

    public static interface SortableColumn {
        public String getColName(ResourceNode var1);

        public int compare(Object var1, Object var2, boolean var3);
    }
}

