/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.DataLinkGlu;
import cds.aladin.DatalinkServiceUtil;
import cds.aladin.FrameMesure;
import cds.aladin.Legende;
import cds.aladin.MCanvas;
import cds.aladin.MyScrollbar;
import cds.aladin.Obj;
import cds.aladin.Plan;
import cds.aladin.Search;
import cds.aladin.SimpleData;
import cds.aladin.Source;
import cds.aladin.Status;
import cds.aladin.Widget;
import cds.aladin.WidgetControl;
import cds.aladin.Words;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public final class Mesure
extends JPanel
implements Runnable,
Iterable<Source>,
Widget {
    Aladin aladin;
    MCanvas mcanvas;
    MyScrollbar scrollV;
    MyScrollbar scrollH;
    JPanel haut;
    Status status;
    boolean flagSplit;
    int previousHeight = 0;
    Search search;
    private static int DEFAULTBLOC = 100;
    private static int MAXBLOC = 100000;
    protected Source[] src = new Source[DEFAULTBLOC];
    protected int nbSrc = 0;
    protected FrameMesure frameMesure = null;
    private Hashtable memoWL = new Hashtable(DEFAULTBLOC);
    private JButton cross;
    public Words activeDataLinkWord = null;
    public Source activeDataLinkSource = null;
    public SimpleData activeDataLinkGlu;
    JPopupMenu additionalServiceMenu;
    int datalinkshowX = -1;
    int datalinkshowY = -1;
    private boolean isSorting = false;
    private int nOccurence;
    private String oMasq = null;
    private static String MFSEARCH;
    private static String MFSEARCHO;
    private static String MFSEARCHBAD;
    private static String NOCUTOUTCLIENTSUPPORT;
    Source lastOcc = null;
    private Object verrou = new Object();
    private HashSet<String> haspushedSet = new HashSet();
    protected boolean flagDorepaintForScroll = false;
    private Plan oldPlanHighlighted = null;
    private WidgetControl voc = null;

    protected Mesure(Aladin aladin) {
        this.aladin = aladin;
        this.scrollV = new MyScrollbar(1, 0, 0, 0, 0);
        this.scrollH = new MyScrollbar(0, 0, 0, 0, 0);
        this.mcanvas = new MCanvas(aladin, this.scrollV, this.scrollH);
        this.scrollV.addAdjustmentListener(this.mcanvas);
        this.scrollH.addAdjustmentListener(this.mcanvas);
        this.status = new Status(aladin, "");
        this.status.setBackground(aladin.getBackground());
        this.flagSplit = false;
        this.search = new Search(aladin, false);
        this.search.setEnabled(true);
        this.search.setBackground(aladin.getBackground());
        this.haut = new JPanel();
        this.haut.setBackground(aladin.getBackground());
        this.haut.setLayout(new BorderLayout(2, 2));
        this.haut.add((Component)this.status, "Center");
        JPanel x = new JPanel();
        x.add(this.search);
        x.setBackground(aladin.getBackground());
        this.haut.add((Component)x, "East");
        this.setLayout(new BorderLayout(0, 0));
        this.setBackground(aladin.getBackground());
        this.add((Component)this.haut, "North");
        this.add((Component)this.mcanvas, "Center");
        this.add((Component)this.scrollV, "East");
        this.add((Component)this.scrollH, "South");
        this.haut.setVisible(false);
        MFSEARCH = Aladin.chaine.getString("MFSEARCH");
        MFSEARCHO = Aladin.chaine.getString("MFSEARCHO");
        MFSEARCHBAD = Aladin.chaine.getString("MFSEARCHBAD");
        NOCUTOUTCLIENTSUPPORT = Aladin.getChaine().getString("NOCUTOUTCLIENTSUPPORT");
    }

    public void showAssociatedDatalinks(String url, Obj o) throws MalformedURLException {
        Aladin.makeCursor(this.mcanvas, 1);
        URL datalinkUrl = null;
        if (this.activeDataLinkWord.datalinksInfo == null || this.activeDataLinkWord.datalinksInfo.isEmpty()) {
            this.activeDataLinkWord.datalinksInfo = new ArrayList<SimpleData>();
            datalinkUrl = new URL(url);
        } else if (this.activeDataLinkGlu != null && this.activeDataLinkWord.datalinksInfo.contains(this.activeDataLinkGlu)) {
            this.activeDataLinkWord.datalinksInfo = new ArrayList<SimpleData>();
            SimpleData activeDatalinkLabel = this.activeDataLinkGlu;
            datalinkUrl = new URL(activeDatalinkLabel.getParams().get("access_url"));
        }
        this.activeDataLinkSource = (Source)o;
        DatalinkServiceUtil.populateDataLinksInfo(datalinkUrl, this.activeDataLinkWord.datalinksInfo);
        this.datalinkPopupShow(this.activeDataLinkWord.datalinksInfo);
        this.activeDataLinkGlu = null;
    }

    public void datalinkPopupShow(List<SimpleData> datalinksInfo) {
        if (datalinksInfo != null && !datalinksInfo.isEmpty()) {
            Aladin.makeCursor(this.mcanvas, 0);
            this.createAdditionalServiceMenu(datalinksInfo);
            this.additionalServiceMenu.show(this, this.datalinkshowX, this.datalinkshowY);
        }
    }

    private void createAdditionalServiceMenu(List<SimpleData> datalinksInfo) {
        this.additionalServiceMenu = new JPopupMenu();
        this.additionalServiceMenu.setLightWeightPopupEnabled(false);
        for (int i = 0; i < datalinksInfo.size(); ++i) {
            SimpleData datalinkInfo = datalinksInfo.get(i);
            JMenuItem j = new JMenuItem(datalinkInfo.getDisplayString());
            this.additionalServiceMenu.add((Component)j, i);
            j.setActionCommand(String.valueOf(i));
            j.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent clickEvent) {
                    int menuIndex = Integer.parseInt(clickEvent.getActionCommand());
                    Mesure.this.aladin.mesure.getFormInfo(menuIndex);
                }
            });
        }
        this.add(this.additionalServiceMenu);
    }

    public void getFormInfo(int menuIndex) {
        this.activeDataLinkGlu = this.activeDataLinkWord.datalinksInfo.get(menuIndex);
        try {
            Map<String, String> params;
            String accessUrl = this.activeDataLinkGlu.getParams().get("access_url");
            if (this.activeDataLinkGlu != null && (params = this.activeDataLinkGlu.getParams()) != null) {
                String semantics = this.activeDataLinkGlu.getParams().get("semantics");
                String contentType = this.activeDataLinkGlu.getParams().get("content_type");
                if (semantics.equalsIgnoreCase("#cutout") || semantics.equalsIgnoreCase("#access") || semantics.equalsIgnoreCase("#proc")) {
                    if (this.aladin.datalinkGlu == null) {
                        this.aladin.datalinkGlu = new DataLinkGlu(this.aladin);
                    }
                    this.aladin.datalinkGlu.createDLGlu(this.activeDataLinkSource, this.activeDataLinkGlu);
                } else if (semantics.startsWith("#preview-plot") && accessUrl != null && contentType.equalsIgnoreCase("application/x-votable+xml")) {
                    int x = this.activeDataLinkWord.x + this.activeDataLinkWord.w / 2;
                    this.aladin.mesure.mcanvas.toSamp(accessUrl, x, this.activeDataLinkWord.y);
                } else if (contentType != null && accessUrl != null && (contentType.equalsIgnoreCase("text/html") || contentType.equalsIgnoreCase("text/plain") || contentType.equalsIgnoreCase("application/pdf"))) {
                    this.aladin.glu.showDocument("Http", accessUrl, true);
                } else if (accessUrl != null && !accessUrl.isEmpty()) {
                    this.aladin.calque.newPlan(this.activeDataLinkGlu.getParams().get("access_url"), null, null, this.activeDataLinkSource);
                } else {
                    Aladin.error("Error in loading datalink", 1);
                }
            }
        }
        catch (Exception e) {
            Aladin.error("Error in loading datalink", 1);
        }
    }

    protected boolean isMesureOut() {
        return this.frameMesure != null;
    }

    protected void split() {
        if (this.frameMesure == null) {
            this.frameMesure = new FrameMesure(this.aladin);
        } else {
            this.frameMesure.close();
            this.frameMesure = null;
        }
    }

    protected synchronized void setSorting(boolean flag) {
        this.isSorting = flag;
    }

    protected synchronized boolean isSorting() {
        return this.isSorting;
    }

    @Override
    public void run() {
        this.showStatus("...sorting...");
        this.setSorting(true);
        try {
            Util.pause(100);
            Arrays.sort(this.src, Source.getComparator());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setSorting(false);
        this.scrollV.setValue(0);
        this.showStatus("");
        Aladin.makeCursor(this.mcanvas, 0);
        this.memoWordLineClear();
        this.mcanvas.repaint();
    }

    protected void tri(boolean ascendant) {
        this.mcanvas.tri(this.mcanvas.sCourante, this.mcanvas.sortField, ascendant);
    }

    protected synchronized double[] getFieldNumericValues(Source o, int nField) {
        int nb = 0;
        for (int i = 0; i < this.nbSrc; ++i) {
            if (this.src[i].getLeg() != o.getLeg()) continue;
            ++nb;
        }
        double[] x = new double[nb];
        int j = 0;
        for (int i = 0; i < this.nbSrc; ++i) {
            if (this.src[i].getLeg() != o.getLeg()) continue;
            x[j] = Double.NaN;
            String s = this.src[i].getValue(nField);
            int n = s.length();
            if (n > 0) {
                if (!Character.isDigit(s.charAt(n - 1))) {
                    s = s.substring(0, n - 1);
                }
                try {
                    x[j] = Double.parseDouble(s);
                }
                catch (Exception e) {
                    x[j] = Double.NaN;
                }
            }
            ++j;
        }
        return x;
    }

    protected synchronized String[] getFieldStringValues(Source o, int nField) {
        int nb = 0;
        for (int i = 0; i < this.nbSrc; ++i) {
            if (this.src[i].getLeg() != o.getLeg()) continue;
            ++nb;
        }
        String[] x = new String[nb];
        int j = 0;
        for (int i = 0; i < this.nbSrc; ++i) {
            if (this.src[i].getLeg() != o.getLeg()) continue;
            x[j] = this.src[i].getValue(nField);
            ++j;
        }
        return x;
    }

    protected void tri(Source o, int nField, boolean ascendant) {
        if (this.isSorting()) {
            return;
        }
        Aladin.makeCursor(this.mcanvas, 1);
        Source.setSort(o, nField, ascendant ? 1 : -1);
        if (this.src.length > 75000) {
            Thread t = new Thread((Runnable)this, "AladinSort");
            Util.decreasePriority(Thread.currentThread(), t);
            t.start();
        } else {
            this.run();
        }
    }

    protected void tag() {
        for (int i = 0; i < this.nbSrc; ++i) {
            this.src[i].setTag(true);
        }
        this.mcanvas.repaint();
        this.aladin.view.repaintAll();
    }

    protected void untag() {
        for (int i = 0; i < this.nbSrc; ++i) {
            this.src[i].setTag(false);
        }
        this.mcanvas.repaint();
        this.aladin.view.repaintAll();
    }

    protected void keepUntag() {
        this.keepTag1(false);
    }

    protected void keepTag() {
        this.keepTag1(true);
    }

    private void keepTag1(boolean keep) {
        for (int i = this.nbSrc - 1; i >= 0; --i) {
            if (this.src[i].isTagged() == keep) continue;
            this.src[i].setSelect(false);
            this.rmSrc(i);
        }
        this.scrollV.setMaximum(this.nbSrc);
        this.aladin.view.majSelect();
        this.mcanvas.repaint();
    }

    protected int searchString(String s, int mode) {
        int rep = this.search(s, mode == -1 ? -1 : 1);
        return rep;
    }

    private void infoSearch(int nOccurence) {
        if (nOccurence >= 0) {
            this.showStatus(MFSEARCH + " => " + nOccurence + " " + MFSEARCHO + (nOccurence > 1 ? "s" : ""));
        } else {
            this.showStatus(MFSEARCHBAD);
        }
    }

    protected boolean selectByString(String s, int clear) {
        this.aladin.view.selectSrcByString(s, clear);
        this.infoSearch(this.nbSrc);
        this.oMasq = "";
        return this.nbSrc > 0;
    }

    protected int search(String masq, int sens) {
        boolean flagSame;
        int n = -1;
        Source t = null;
        int nMasq = masq.length();
        boolean bl = flagSame = nMasq == 0 || masq.equals(this.oMasq);
        if (!flagSame) {
            this.nOccurence = 0;
        }
        this.oMasq = masq;
        if (this.mcanvas.objSelect != null) {
            this.lastOcc = this.mcanvas.objSelect;
        }
        for (int i = 0; i < this.nbSrc; ++i) {
            if (this.src[i] != this.lastOcc) continue;
            n = i;
            break;
        }
        if ((n += sens) == -1) {
            n = sens < 0 ? this.nbSrc - 1 : 0;
        }
        StringBuffer col = new StringBuffer();
        StringBuffer v = new StringBuffer();
        int mode = this.aladin.view.getAdvancedSearch(col, v, masq);
        masq = v.toString();
        boolean abs = false;
        if (col.length() > 0) {
            abs = this.aladin.view.getAbsSearch(col);
        }
        int colIndex = -1;
        double numS = Double.MAX_VALUE;
        boolean numeric = false;
        Legende oLeg = null;
        int i = 0;
        block3: while (i < this.nbSrc) {
            block18: {
                String[] val;
                Source s;
                block19: {
                    if (n >= this.nbSrc) {
                        n = 0;
                    } else if (n < 0) {
                        n = this.nbSrc - 1;
                    }
                    s = this.src[n];
                    if (s == null) break block18;
                    this.lastOcc = s;
                    if (col.length() > 0 && oLeg != s.getLeg()) {
                        colIndex = s.getLeg().matchIgnoreCaseColIndex(col.toString());
                        if (colIndex == -1) break;
                        numeric = s.getLeg().isNumField(colIndex);
                        if (numeric) {
                            try {
                                numS = Double.parseDouble(masq);
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        oLeg = s.getLeg();
                    }
                    val = s.getValues();
                    if (colIndex < 0) break block19;
                    if (!this.aladin.view.advancedSearch(mode, numeric, abs, val[colIndex], masq, numS)) break block18;
                    if (t == null) {
                        t = s;
                    }
                    if (flagSame) break;
                    ++this.nOccurence;
                    break block18;
                }
                for (int j = 0; j < val.length; ++j) {
                    if (nMasq != 0 && Util.indexOfIgnoreCase(val[j], masq) < 0) continue;
                    if (t == null) {
                        t = s;
                    }
                    if (flagSame) break block3;
                    ++this.nOccurence;
                    break;
                }
            }
            ++i;
            n += sens;
        }
        int rep = 0;
        if (t != null) {
            this.mcanvas.show(t, 2);
            int n2 = rep = this.aladin.view.setRepere(new Coord(t.raj, t.dej)) ? 1 : -1;
            if (!Aladin.NOGUI) {
                this.aladin.view.showSource(t);
            }
        }
        return rep;
    }

    protected void redisplay() {
        this.mcanvas.reloadHead();
        this.mcanvas.repaint();
    }

    protected int memoSrcList(Source[] memoSrcList) {
        System.arraycopy(this.src, 0, memoSrcList, 0, this.nbSrc);
        return this.nbSrc;
    }

    protected synchronized void restoreSrcList(Source[] memoSrcList, int nbSrc) {
        this.src = memoSrcList;
        this.nbSrc = nbSrc;
        this.scrollV.setMaximum(nbSrc);
        this.mcanvas.unselect();
        this.aladin.calque.zoom.zoomView.stopHist();
        this.aladin.calque.zoom.zoomView.resumeSED();
        this.aladin.console.setEnabledDumpButton(true);
        if (this.mcanvas.triTag != 0) {
            this.mcanvas.triTag = 0;
        }
    }

    private synchronized void addSrc(Source s) {
        if (this.frameMesure == null) {
            this.setReduced(false);
        }
        if (this.nbSrc == this.src.length) {
            Source[] srcBis = new Source[this.src.length > MAXBLOC ? this.src.length + MAXBLOC : this.src.length * 2];
            System.arraycopy(this.src, 0, srcBis, 0, this.src.length);
            this.src = srcBis;
            Object var2_2 = null;
        }
        this.src[this.nbSrc++] = s;
        this.scrollV.setMaximum(this.nbSrc);
        this.mcanvas.unselect();
        this.aladin.calque.zoom.zoomView.stopHist();
        this.aladin.calque.zoom.zoomView.resumeSED();
        this.aladin.console.setEnabledDumpButton(true);
        if (s.getLeg() != null && s.getLeg().isSorted()) {
            s.getLeg().clearSort();
            this.mcanvas.reloadHead();
        }
        if (this.mcanvas.triTag != 0) {
            this.mcanvas.triTag = 0;
        }
    }

    private synchronized void rmAllSrc() {
        try {
            if (this.nbSrc > MAXBLOC) {
                this.src = new Source[DEFAULTBLOC];
            } else {
                for (int i = 0; i < this.nbSrc; ++i) {
                    this.src[i] = null;
                }
            }
            this.nbSrc = 0;
            this.mcanvas.unselect();
            this.aladin.calque.zoom.zoomView.stopHist();
            this.aladin.calque.zoom.zoomView.resumeSED();
            this.aladin.console.setEnabledDumpButton(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rmPlanSrc(Plan p) {
        Mesure mesure = this;
        synchronized (mesure) {
            int n = 0;
            for (int i = 0; i < this.nbSrc; ++i) {
                if (this.src[i].plan == p) continue;
                if (i != n) {
                    this.src[n] = this.src[i];
                }
                ++n;
            }
            this.nbSrc = n;
        }
        this.mcanvas.currentsee = -1;
        this.mcanvas.currentselect = -2;
        this.scrollV.setMaximum(this.nbSrc);
        this.mcanvas.unselect();
        this.mcanvas.repaint();
        this.aladin.calque.zoom.zoomView.stopHist();
        this.aladin.calque.zoom.zoomView.resumeSED();
        this.aladin.console.setEnabledDumpButton(this.nbSrc > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Source[] getSources() {
        Mesure mesure = this;
        synchronized (mesure) {
            Source[] s = new Source[this.nbSrc];
            System.arraycopy(this.src, 0, s, 0, this.nbSrc);
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rmSrc(ArrayList list) {
        Mesure mesure = this;
        synchronized (mesure) {
            int n = 0;
            int m = 0;
            int index = m < list.size() ? (Integer)list.get(m) : -1;
            for (int i = 0; i < this.nbSrc; ++i) {
                if (i == index) {
                    index = ++m < list.size() ? (Integer)list.get(m) : -1;
                    continue;
                }
                if (i != n) {
                    this.src[n] = this.src[i];
                }
                ++n;
            }
            this.nbSrc = n;
        }
        this.aladin.calque.zoom.zoomView.stopHist();
        this.aladin.calque.zoom.zoomView.resumeSED();
        this.aladin.console.setEnabledDumpButton(this.nbSrc > 0);
    }

    protected synchronized void rmSrc(int i) {
        while (i < this.src.length - 1) {
            this.src[i] = this.src[i + 1];
            ++i;
        }
        this.src[i] = null;
        --this.nbSrc;
        this.mcanvas.unselect();
        this.aladin.calque.zoom.zoomView.stopHist();
        this.aladin.calque.zoom.zoomView.resumeSED();
        this.aladin.console.setEnabledDumpButton(this.nbSrc > 0);
    }

    protected int findSrc(Source s) {
        for (int i = 0; i < this.nbSrc; ++i) {
            if (this.src[i] != s) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Iterator<Source> iterator() {
        return new SourceIterator();
    }

    protected Source getFirstSrc() {
        return this.nbSrc < 1 ? null : this.src[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNbSrc() {
        Object object = this.verrou;
        synchronized (object) {
            return this.nbSrc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void memoWordLineClear() {
        Object object = this.verrou;
        synchronized (object) {
            this.memoWL.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void memoWordLine(Vector wl, int i) {
        Object object = this.verrou;
        synchronized (object) {
            this.memoWL.put(new Integer(i), wl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector getWordLine(int i) {
        Object object = this.verrou;
        synchronized (object) {
            Vector wl = (Vector)this.memoWL.get(new Integer(i));
            if (wl != null) {
                return wl;
            }
            return this.getWordLine(this.src[i], i);
        }
    }

    protected Vector getHeadLine(Source o) {
        Legende leg = o.getLeg();
        Vector<Object> wordLine = new Vector<Object>(leg.field.length + 2);
        wordLine.addElement(o);
        wordLine.addElement(new Words("", -1));
        for (int i = 0; i < leg.field.length; ++i) {
            int nField = leg.fieldAt[i];
            if (!leg.isVisible(nField)) continue;
            Words w = new Words(leg.field[nField].name, null, o.getLeg().getWidth(nField), o.getLeg().getPrecision(nField), 2, o.getLeg().computed.length == 0 ? false : o.getLeg().computed[nField], leg.field[nField].sort, -1);
            w.pin = i == 0;
            wordLine.addElement(w);
        }
        return wordLine;
    }

    protected void setHaspushed(Obj o, int numField) {
        String key = o.hashCode() + "/" + numField;
        this.haspushedSet.add(key);
    }

    private boolean hasBeenPushed(Obj o, int numField) {
        String key = o.hashCode() + "/" + numField;
        return this.haspushedSet.contains(key);
    }

    protected Vector getWordLine(Source o, int num) {
        int i;
        if (o == null) {
            return null;
        }
        String s = o.info != null ? o.info : o.id;
        StringTokenizer st = new StringTokenizer(s, "\t");
        int n = st.countTokens();
        Vector<Object> wordLine = new Vector<Object>(n + 1);
        wordLine.addElement(o);
        int indexFootPrint = o.getIdxFootprint();
        String[] tags = new String[n - 1];
        String triangle = st.nextToken();
        for (i = 0; i < tags.length; ++i) {
            tags[i] = st.nextToken();
        }
        for (i = 0; i < n; ++i) {
            Words w;
            String tag;
            if (i == 0) {
                tag = triangle;
                w = new Words(tag, num);
            } else {
                int align;
                int nField = 0;
                try {
                    nField = o.getLeg().fieldAt[i - 1];
                }
                catch (Exception e) {
                    System.out.println("Y a un prob. =>" + s);
                    continue;
                }
                tag = tags[nField];
                if (!o.getLeg().isVisible(nField)) continue;
                int n2 = align = o.getLeg().isNumField(nField) ? 1 : 0;
                if (indexFootPrint == nField) {
                    w = new Words("  FoV", o.getLeg().getWidth(i - 1), o.getLeg().getPrecision(nField), 0, false, true, num);
                } else {
                    if (o.getLeg().isNullValue(tag, i - 1)) {
                        tag = "";
                    }
                    w = new Words(tag, o.getLeg().getRefText(nField), o.getLeg().getWidth(nField), o.getLeg().getPrecision(nField), align, o.getLeg().computed.length == 0 ? false : o.getLeg().computed[nField], 0, num);
                }
            }
            w.show = o == this.mcanvas.objSelect || o == this.mcanvas.objShow;
            w.haspushed = this.hasBeenPushed(o, i);
            wordLine.addElement(w);
            if (!w.glu || w.size >= tag.length()) continue;
            tag = tag.substring(w.size + 1, tag.length());
            wordLine.addElement(new Words(tag, num));
        }
        return wordLine;
    }

    public static boolean isValueOfSpecifiedUcdField(Source source, String ucd, String expectedValue) {
        String value;
        boolean result = false;
        int formatIndex = source.findUtype("obscore:Access.Format");
        if (formatIndex != -1 && (value = source.getValue(formatIndex)).contains(expectedValue)) {
            result = true;
        }
        return result;
    }

    protected boolean isSplitted() {
        return this.flagSplit;
    }

    protected void split(boolean flagSplit) {
        if (flagSplit == this.flagSplit) {
            return;
        }
        this.flagSplit = flagSplit;
        if (flagSplit) {
            this.previousHeight = this.mcanvas.getSize().height;
            this.haut.setVisible(true);
            this.status.setSize(this.status.getSize().width, this.status.H);
            this.mcanvas.setSize(this.mcanvas.getSize().width, 600);
            this.scrollV.setSize(this.scrollV.getSize().width, 600);
        } else {
            this.haut.setVisible(false);
            this.mcanvas.setSize(this.mcanvas.getSize().width, this.previousHeight);
            this.scrollV.setSize(this.scrollV.getSize().width, this.previousHeight);
        }
        this.setSize(this.getPreferredSize());
    }

    protected void setReduced(boolean flag) {
        this.aladin.splitMesureHeight.setReduced(flag);
    }

    protected void showStatus(String text) {
        if (this.flagSplit) {
            this.status.setText(text);
        } else {
            this.aladin.status.setText(text);
        }
    }

    protected void showInfo(String s, Plan p) {
        if (s == null || s.length() == 0) {
            this.aladin.calque.select.hideMessage();
        } else {
            this.aladin.calque.select.setMessageInfo(s);
        }
        if (this.oldPlanHighlighted != p) {
            this.aladin.calque.select.repaint();
        }
        if (this.oldPlanHighlighted != null) {
            this.oldPlanHighlighted.isHighlighted = false;
        }
        if (p != null) {
            p.isHighlighted = true;
        }
        this.oldPlanHighlighted = p;
    }

    protected void insertInfo(Source o) {
        this.addSrc(o);
        this.mcanvas.currentselect = -2;
    }

    protected String getCurObjVal() {
        if (this.mcanvas.sCourante == null || this.mcanvas.indiceCourant == -1) {
            return "";
        }
        return this.mcanvas.sCourante.getValue(this.mcanvas.indiceCourant);
    }

    protected String getCurObjURL() {
        if (this.mcanvas.sCourante == null || this.mcanvas.indiceCourant == -1) {
            return "";
        }
        String tag = this.mcanvas.sCourante.getCodedValue(this.mcanvas.indiceCourant);
        Words w = new Words(tag, -1);
        return w.getURL(this.aladin);
    }

    protected String getCurObjCoord() {
        Source s = this.mcanvas.objSelect;
        if (s == null) {
            return "";
        }
        return this.aladin.localisation.J2000ToString(s.raj, s.dej);
    }

    protected String getText() {
        return this.getText(false);
    }

    protected String getText(boolean ascii) {
        StringBuffer res = new StringBuffer();
        String sep = ascii ? "    " : "\t";
        for (int i = 0; i < this.nbSrc; ++i) {
            Vector v = this.getWordLine(i);
            Enumeration e = v.elements();
            e.nextElement();
            int k = -1;
            while (e.hasMoreElements()) {
                Words w = (Words)e.nextElement();
                if (ascii && k >= 0) {
                    int length = w.text.length() > w.width ? 1 : w.width - w.text.length() + 1;
                    sep = Util.fillWithBlank("", length);
                }
                if (w.repere) {
                    int deb = w.text.indexOf(34);
                    int fin = w.text.lastIndexOf(34);
                    if (ascii) {
                        sep = "    ";
                    }
                    if (deb >= 0 && fin > deb) {
                        res.append(w.text.substring(deb + 1, fin) + ":" + sep);
                    }
                } else {
                    res.append(w.text);
                    if (e.hasMoreElements()) {
                        res.append(sep);
                    }
                }
                ++k;
            }
            res.append(Util.CR);
        }
        return res.toString();
    }

    protected String getCurObjMeasurement(boolean json) {
        StringBuilder sb = new StringBuilder();
        Source s = this.mcanvas.objSelect;
        Legende leg = s.getLeg();
        String[] values = s.getValues();
        boolean first = true;
        if (json) {
            sb.append("{ ");
        }
        for (int i = 0; i < leg.field.length; ++i) {
            if (!leg.field[i].visible) continue;
            if (json) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append("\"" + Util.escapeJSON(leg.field[i].name) + "\": \"" + Util.escapeJSON(values[i]) + "\"");
            } else {
                if (!first) {
                    sb.append('\t');
                }
                sb.append(values[i]);
            }
            first = false;
        }
        if (json) {
            sb.append(" }");
        }
        return sb.toString();
    }

    protected void removeAllElements() {
        this.mcanvas.currentselect = -2;
        this.mcanvas.oleg = null;
        this.rmAllSrc();
        this.scrollV.setValues(0, 1, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(Source s) {
        boolean dopaint = false;
        Mesure mesure = this;
        synchronized (mesure) {
            for (int i = 0; i < this.nbSrc; ++i) {
                Source o = this.src[i];
                if (o != s) continue;
                dopaint = true;
                this.rmSrc(i);
                this.scrollV.setMaximum(this.nbSrc);
                break;
            }
        }
        if (dopaint) {
            this.display();
        }
    }

    protected void display() {
        this.mcanvas.currentsee = -1;
        this.mcanvas.currentselect = -2;
        Source s = this.aladin.mesure.getFirstSrc();
        if (s == null && this.aladin.view.zoomview.flagSED || s != null && s.getLeg() != null && s.getLeg().isSED()) {
            this.aladin.view.zoomview.setSED(s);
        }
        this.mcanvas.repaint();
    }

    protected void setInfo(Source o) {
        this.insertInfo(o);
        this.adjustScroll();
    }

    protected void adjustScroll() {
        this.mcanvas.initX();
        int nl = this.mcanvas.nbligne;
        int val = this.nbSrc - nl;
        if (val < 0) {
            val = 0;
        }
        int extend = nl;
        this.scrollV.setValues(val, extend, 0, this.nbSrc - 1);
        this.scrollV.setBlockIncrement(nl - 1);
    }

    @Override
    public WidgetControl getWidgetControl() {
        return this.voc;
    }

    @Override
    public void createWidgetControl(int x, int y, int width, int height, float opacity, JComponent parent) {
        this.voc = new WidgetControl(this, x, y, width, height, opacity, parent);
        this.voc.setResizable(true);
    }

    @Override
    public void paintCollapsed(Graphics g) {
    }

    class SourceIterator
    implements Iterator<Source> {
        int i;

        SourceIterator() {
            this.i = Mesure.this.nbSrc;
        }

        @Override
        public boolean hasNext() {
            return this.i > 0;
        }

        @Override
        public Source next() {
            return Mesure.this.src[--this.i];
        }

        @Override
        public void remove() {
        }
    }
}

